export type Maybe<T> = T | null
export type InputMaybe<T> = Maybe<T>
export type Exact<T extends { [key: string]: unknown }> = { [K in keyof T]: T[K] }
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]?: Maybe<T[SubKey]> }
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]: Maybe<T[SubKey]> }
export type MakeEmpty<T extends { [key: string]: unknown }, K extends keyof T> = { [_ in K]?: never }
export type Incremental<T> = T | { [P in keyof T]?: P extends " $fragmentName" | "__typename" ? T[P] : never }
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: { input: string; output: string }
  String: { input: string; output: string }
  Boolean: { input: boolean; output: boolean }
  Int: { input: number; output: number }
  Float: { input: number; output: number }
  ARN: { input: any; output: any }
  Date: { input: any; output: any }
  DateTime: { input: any; output: any }
  Decimal: { input: any; output: any }
  FormattedString: { input: any; output: any }
  HTML: { input: any; output: any }
  JSON: { input: any; output: any }
  Money: { input: any; output: any }
  StorefrontID: { input: any; output: any }
  URL: { input: any; output: any }
  UnsignedInt64: { input: any; output: any }
  UtcOffset: { input: any; output: any }
}

/** A checkout that was abandoned by the customer. */
export type AbandonedCheckout = Navigable &
  Node & {
    __typename?: "AbandonedCheckout"
    /** The URL for the buyer to recover their checkout. */
    abandonedCheckoutUrl: Scalars["URL"]["output"]
    /**
     * A default cursor that returns the single next record, sorted ascending by ID.
     *
     */
    defaultCursor: Scalars["String"]["output"]
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** A list of the line items in this checkout. */
    lineItems: AbandonedCheckoutLineItemConnection
    /** The number of products in the checkout. */
    lineItemsQuantity: Scalars["Int"]["output"]
    /**
     * The sum of all items in the checkout, including discounts, shipping, taxes, and tips.
     *
     */
    totalPriceSet: MoneyBag
  }

/** A checkout that was abandoned by the customer. */
export type AbandonedCheckoutLineItemsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** A single line item in an abandoned checkout. */
export type AbandonedCheckoutLineItem = Node & {
  __typename?: "AbandonedCheckoutLineItem"
  /** A list of extra information that has been added to the line item. */
  customAttributes: Array<Attribute>
  /** Final total price for the entire quantity of this line item, including discounts. */
  discountedTotalPriceSet: MoneyBag
  /**
   * The total price for the entire quantity of this line item, after all discounts are applied, at both the line item and code-based line item level.
   *
   */
  discountedTotalPriceWithCodeDiscount: MoneyBag
  /**
   * The price of a single variant unit after discounts are applied at the line item level, in shop and presentment currencies.
   *
   */
  discountedUnitPriceSet: MoneyBag
  /**
   * The price of a single variant unit after all discounts are applied, at both the line item and code-based line item level.
   *
   */
  discountedUnitPriceWithCodeDiscount: MoneyBag
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /**
   * The image associated with the line item's variant or product.
   * NULL if the line item has no product, or if neither the variant nor the product have an image.
   *
   */
  image?: Maybe<Image>
  /** Original total price for the entire quantity of this line item, before discounts. */
  originalTotalPriceSet: MoneyBag
  /** Original price for a single unit of this line item, before discounts. */
  originalUnitPriceSet: MoneyBag
  /**
   * Product for this line item.
   * NULL for custom line items and products that were deleted after checkout began.
   *
   */
  product?: Maybe<Product>
  /** The quantity of the line item. */
  quantity: Scalars["Int"]["output"]
  /** SKU for the inventory item associated with the variant, if any. */
  sku?: Maybe<Scalars["String"]["output"]>
  /** Title of the line item. Defaults to the product's title. */
  title?: Maybe<Scalars["String"]["output"]>
  /**
   * Product variant for this line item.
   * NULL for custom line items and variants that were deleted after checkout began.
   *
   */
  variant?: Maybe<ProductVariant>
  /**
   * Title of the variant for this line item.
   * NULL for custom line items and products that don't have distinct variants.
   *
   */
  variantTitle?: Maybe<Scalars["String"]["output"]>
}

/**
 * An auto-generated type for paginating through multiple AbandonedCheckoutLineItems.
 *
 */
export type AbandonedCheckoutLineItemConnection = {
  __typename?: "AbandonedCheckoutLineItemConnection"
  /** A list of edges. */
  edges: Array<AbandonedCheckoutLineItemEdge>
  /** A list of the nodes contained in AbandonedCheckoutLineItemEdge. */
  nodes: Array<AbandonedCheckoutLineItem>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one AbandonedCheckoutLineItem and a cursor during pagination.
 *
 */
export type AbandonedCheckoutLineItemEdge = {
  __typename?: "AbandonedCheckoutLineItemEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of AbandonedCheckoutLineItemEdge. */
  node: AbandonedCheckoutLineItem
}

/** A browse, cart, or checkout that was abandoned by a customer. */
export type Abandonment = Node & {
  __typename?: "Abandonment"
  /** The abandonment payload for the abandoned checkout. */
  abandonedCheckoutPayload?: Maybe<AbandonedCheckout>
  /** The abandonment type. */
  abandonmentType: AbandonmentAbandonmentType
  /** The app associated with an abandoned checkout. */
  app: App
  /** Permalink to the cart page. */
  cartUrl?: Maybe<Scalars["URL"]["output"]>
  /** The date and time when the abandonment was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** The customer who abandoned this event. */
  customer: Customer
  /** Whether the customer has a draft order since this abandonment has been abandoned. */
  customerHasNoDraftOrderSinceAbandonment: Scalars["Boolean"]["output"]
  /** Whether the customer has completed an order since this checkout has been abandoned. */
  customerHasNoOrderSinceAbandonment: Scalars["Boolean"]["output"]
  /** The number of days since the last abandonment email was sent to the customer. */
  daysSinceLastAbandonmentEmail: Scalars["Int"]["output"]
  /** When the email was sent, if that's the case. */
  emailSentAt?: Maybe<Scalars["DateTime"]["output"]>
  /** The email state (e.g., sent or not sent). */
  emailState?: Maybe<AbandonmentEmailState>
  /** The number of hours since the customer has last abandoned a checkout. */
  hoursSinceLastAbandonedCheckout?: Maybe<Scalars["Float"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** Whether the products in abandonment are available. */
  inventoryAvailable: Scalars["Boolean"]["output"]
  /** Whether the abandonment event comes from the Online Store sales channel. */
  isFromOnlineStore: Scalars["Boolean"]["output"]
  /** Whether the abandonment event comes from the Shop app sales channel. */
  isFromShopApp: Scalars["Boolean"]["output"]
  /** Whether the abandonment event comes from Shop Pay. */
  isFromShopPay: Scalars["Boolean"]["output"]
  /** Whether the customer didn't complete another most significant step since this abandonment. */
  isMostSignificantAbandonment: Scalars["Boolean"]["output"]
  /** The date for the latest browse abandonment. */
  lastBrowseAbandonmentDate: Scalars["DateTime"]["output"]
  /** The date for the latest cart abandonment. */
  lastCartAbandonmentDate: Scalars["DateTime"]["output"]
  /** The date for the latest checkout abandonment. */
  lastCheckoutAbandonmentDate: Scalars["DateTime"]["output"]
  /** The most recent step type. */
  mostRecentStep: AbandonmentAbandonmentType
  /** The products added to the cart during the customer abandoned visit. */
  productsAddedToCart: CustomerVisitProductInfoConnection
  /** The products viewed during the customer abandoned visit. */
  productsViewed: CustomerVisitProductInfoConnection
  /** The date and time when the visit started. */
  visitStartedAt?: Maybe<Scalars["DateTime"]["output"]>
}

/** A browse, cart, or checkout that was abandoned by a customer. */
export type AbandonmentProductsAddedToCartArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** A browse, cart, or checkout that was abandoned by a customer. */
export type AbandonmentProductsViewedArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Specifies the abandonment type. */
export enum AbandonmentAbandonmentType {
  /** The abandonment event is an abandoned browse. */
  Browse = "BROWSE",
  /** The abandonment event is an abandoned cart. */
  Cart = "CART",
  /** The abandonment event is an abandoned checkout. */
  Checkout = "CHECKOUT",
}

/** Specifies the delivery state of a marketing activity. */
export enum AbandonmentDeliveryState {
  /** The marketing activity action has not yet been sent. */
  NotSent = "NOT_SENT",
  /** The marketing activity action has been scheduled for later delivery. */
  Scheduled = "SCHEDULED",
  /** The marketing activity action has been sent. */
  Sent = "SENT",
}

/** Specifies the email state. */
export enum AbandonmentEmailState {
  /** The email has not yet been sent. */
  NotSent = "NOT_SENT",
  /** The email has been scheduled for later delivery. */
  Scheduled = "SCHEDULED",
  /** The email has been sent. */
  Sent = "SENT",
}

/** Return type for `abandonmentEmailStateUpdate` mutation. */
export type AbandonmentEmailStateUpdatePayload = {
  __typename?: "AbandonmentEmailStateUpdatePayload"
  /** The updated abandonment. */
  abandonment?: Maybe<Abandonment>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<AbandonmentEmailStateUpdateUserError>
}

/** An error that occurs during the execution of `AbandonmentEmailStateUpdate`. */
export type AbandonmentEmailStateUpdateUserError = DisplayableError & {
  __typename?: "AbandonmentEmailStateUpdateUserError"
  /** The error code. */
  code?: Maybe<AbandonmentEmailStateUpdateUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `AbandonmentEmailStateUpdateUserError`. */
export enum AbandonmentEmailStateUpdateUserErrorCode {
  /** Unable to find an Abandonment for the provided ID. */
  AbandonmentNotFound = "ABANDONMENT_NOT_FOUND",
}

/** Return type for `abandonmentUpdateActivitiesDeliveryStatuses` mutation. */
export type AbandonmentUpdateActivitiesDeliveryStatusesPayload = {
  __typename?: "AbandonmentUpdateActivitiesDeliveryStatusesPayload"
  /** The updated abandonment. */
  abandonment?: Maybe<Abandonment>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<AbandonmentUpdateActivitiesDeliveryStatusesUserError>
}

/** An error that occurs during the execution of `AbandonmentUpdateActivitiesDeliveryStatuses`. */
export type AbandonmentUpdateActivitiesDeliveryStatusesUserError = DisplayableError & {
  __typename?: "AbandonmentUpdateActivitiesDeliveryStatusesUserError"
  /** The error code. */
  code?: Maybe<AbandonmentUpdateActivitiesDeliveryStatusesUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `AbandonmentUpdateActivitiesDeliveryStatusesUserError`. */
export enum AbandonmentUpdateActivitiesDeliveryStatusesUserErrorCode {
  /** Unable to find an Abandonment for the provided ID. */
  AbandonmentNotFound = "ABANDONMENT_NOT_FOUND",
  /** Unable to find delivery status info for the provided ID. */
  DeliveryStatusInfoNotFound = "DELIVERY_STATUS_INFO_NOT_FOUND",
  /** Unable to find a marketing activity for the provided ID. */
  MarketingActivityNotFound = "MARKETING_ACTIVITY_NOT_FOUND",
}

/**
 * The permission required to access a Shopify Admin API or Storefront API resource for a shop. Merchants grant access scopes that are requested by applications.
 *
 */
export type AccessScope = {
  __typename?: "AccessScope"
  /** A description of the actions that the access scope allows an app to perform. */
  description: Scalars["String"]["output"]
  /**
   * A readable string that represents the access scope. The string usually follows the format `{action}_{resource}`. `{action}` is `read` or `write`, and `{resource}` is the resource that the action can be performed on. `{action}` and `{resource}` are separated by an underscore. For example, `read_orders` or `write_products`.
   *
   */
  handle: Scalars["String"]["output"]
}

/** Represents an operation publishing all products to a publication. */
export type AddAllProductsOperation = Node &
  ResourceOperation & {
    __typename?: "AddAllProductsOperation"
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The count of processed rows, summing imported, failed, and skipped rows. */
    processedRowCount?: Maybe<Scalars["Int"]["output"]>
    /** Represents a rows objects within this background operation. */
    rowCount?: Maybe<RowCount>
    /** The status of this operation. */
    status: ResourceOperationStatus
  }

/** The additional fees that have been applied to the order. */
export type AdditionalFee = Node & {
  __typename?: "AdditionalFee"
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The name of the additional fee. */
  name: Scalars["String"]["output"]
  /** The price of the additional fee. */
  price: MoneyBag
  /** A list of taxes charged on the additional fee. */
  taxLines: Array<TaxLine>
}

/** A sale associated with an additional fee charge. */
export type AdditionalFeeSale = Sale & {
  __typename?: "AdditionalFeeSale"
  /** The type of order action that the sale represents. */
  actionType: SaleActionType
  /** The additional fees for the associated sale. */
  additionalFee: SaleAdditionalFee
  /** The unique ID for the sale. */
  id: Scalars["ID"]["output"]
  /** The line type assocated with the sale. */
  lineType: SaleLineType
  /** The number of units either ordered or intended to be returned. */
  quantity?: Maybe<Scalars["Int"]["output"]>
  /** All individual taxes associated with the sale. */
  taxes: Array<SaleTax>
  /** The total sale amount after taxes and discounts. */
  totalAmount: MoneyBag
  /** The total discounts allocated to the sale after taxes. */
  totalDiscountAmountAfterTaxes: MoneyBag
  /** The total discounts allocated to the sale before taxes. */
  totalDiscountAmountBeforeTaxes: MoneyBag
  /** The total amount of taxes for the sale. */
  totalTaxAmount: MoneyBag
}

/** A sale associated with an order price adjustment. */
export type AdjustmentSale = Sale & {
  __typename?: "AdjustmentSale"
  /** The type of order action that the sale represents. */
  actionType: SaleActionType
  /** The unique ID for the sale. */
  id: Scalars["ID"]["output"]
  /** The line type assocated with the sale. */
  lineType: SaleLineType
  /** The number of units either ordered or intended to be returned. */
  quantity?: Maybe<Scalars["Int"]["output"]>
  /** All individual taxes associated with the sale. */
  taxes: Array<SaleTax>
  /** The total sale amount after taxes and discounts. */
  totalAmount: MoneyBag
  /** The total discounts allocated to the sale after taxes. */
  totalDiscountAmountAfterTaxes: MoneyBag
  /** The total discounts allocated to the sale before taxes. */
  totalDiscountAmountBeforeTaxes: MoneyBag
  /** The total amount of taxes for the sale. */
  totalTaxAmount: MoneyBag
}

/** Targets all items the cart for a specified discount. */
export type AllDiscountItems = {
  __typename?: "AllDiscountItems"
  /** Whether all items are eligible for the discount. This value always returns `true`. */
  allItems: Scalars["Boolean"]["output"]
}

/**
 * A version of the API, as defined by [Shopify API versioning](https://shopify.dev/api/usage/versioning).
 * Versions are commonly referred to by their handle (for example, `2021-10`).
 *
 */
export type ApiVersion = {
  __typename?: "ApiVersion"
  /** The human-readable name of the version. */
  displayName: Scalars["String"]["output"]
  /** The unique identifier of an ApiVersion. All supported API versions have a date-based (YYYY-MM) or `unstable` handle. */
  handle: Scalars["String"]["output"]
  /** Whether the version is actively supported by Shopify. Supported API versions are guaranteed to be stable. Unsupported API versions include unstable, release candidate, and end-of-life versions that are marked as unsupported. For more information, refer to [Versioning](https://shopify.dev/api/usage/versioning). */
  supported: Scalars["Boolean"]["output"]
}

/** A Shopify application. */
export type App = Node & {
  __typename?: "App"
  /** A unique application API identifier. */
  apiKey: Scalars["String"]["output"]
  /** App store page URL of the app. */
  appStoreAppUrl?: Maybe<Scalars["URL"]["output"]>
  /** App store page URL of the developer who created the app. */
  appStoreDeveloperUrl?: Maybe<Scalars["URL"]["output"]>
  /** The access scopes available to the app. */
  availableAccessScopes: Array<AccessScope>
  /** Banner image for the app. */
  banner: Image
  /** Description of the app. */
  description?: Maybe<Scalars["String"]["output"]>
  /** The name of the app developer. */
  developerName?: Maybe<Scalars["String"]["output"]>
  /** The type of app developer. */
  developerType: AppDeveloperType
  /**
   * Website of the developer who created the app.
   * @deprecated Use `appStoreDeveloperUrl` instead.
   */
  developerUrl: Scalars["URL"]["output"]
  /** Whether the app uses the Embedded App SDK. */
  embedded: Scalars["Boolean"]["output"]
  /** Requirements that must be met before the app can be installed. */
  failedRequirements: Array<FailedRequirement>
  /** A list of app features that are shown in the Shopify App Store listing. */
  features: Array<Scalars["String"]["output"]>
  /** Feedback from this app about the store. */
  feedback?: Maybe<AppFeedback>
  /** Handle of the app. */
  handle?: Maybe<Scalars["String"]["output"]>
  /** Icon that represents the app. */
  icon: Image
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** Webpage where you can install the app. */
  installUrl?: Maybe<Scalars["URL"]["output"]>
  /**
   * Corresponding AppInstallation for this shop and App.
   * Returns null if the App is not installed.
   *
   */
  installation?: Maybe<AppInstallation>
  /**
   * Whether the app is the [post purchase](https://shopify.dev/apps/checkout/post-purchase) app in use.
   *
   */
  isPostPurchaseAppInUse: Scalars["Boolean"]["output"]
  /**
   * Webpage that the app starts in.
   * @deprecated Use AppInstallation.launchUrl instead
   */
  launchUrl: Scalars["URL"]["output"]
  /**
   * Menu items for the app, which also appear as submenu items in left navigation sidebar in the Shopify admin.
   *
   * @deprecated Use AppInstallation.navigationItems instead
   */
  navigationItems: Array<NavigationItem>
  /** Whether the app was previously installed on the current shop. */
  previouslyInstalled: Scalars["Boolean"]["output"]
  /** Detailed information about the app pricing. */
  pricingDetails?: Maybe<Scalars["String"]["output"]>
  /** Summary of the app pricing details. */
  pricingDetailsSummary: Scalars["String"]["output"]
  /** Link to app privacy policy. */
  privacyPolicyUrl?: Maybe<Scalars["URL"]["output"]>
  /** The public category for the app. */
  publicCategory: AppPublicCategory
  /** Whether the app is published to the Shopify App Store. */
  published: Scalars["Boolean"]["output"]
  /** The access scopes requested by the app. */
  requestedAccessScopes: Array<AccessScope>
  /** Screenshots of the app. */
  screenshots: Array<Image>
  /** Whether the app was developed by Shopify. */
  shopifyDeveloped: Scalars["Boolean"]["output"]
  /** Name of the app. */
  title: Scalars["String"]["output"]
  /**
   * Message that appears when the app is uninstalled. For example:
   * By removing this app, you will no longer be able to publish products to MySocialSite or view this app in your Shopify admin. You can re-enable this channel at any time.
   *
   */
  uninstallMessage: Scalars["String"]["output"]
  /**
   * Webpage where you can uninstall the app.
   * @deprecated Use AppInstallation.uninstallUrl instead
   */
  uninstallUrl?: Maybe<Scalars["URL"]["output"]>
  /** The webhook API version for the app. */
  webhookApiVersion: Scalars["String"]["output"]
}

/**
 * A catalog that defines the publication associated with an app.
 *
 */
export type AppCatalog = Catalog &
  Node & {
    __typename?: "AppCatalog"
    /** The apps associated with the catalog. */
    apps: AppConnection
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** Most recent catalog operations. */
    operations: Array<ResourceOperation>
    /** The price list associated with the catalog. */
    priceList?: Maybe<PriceList>
    /** A group of products and collections that's published to a catalog. */
    publication?: Maybe<Publication>
    /** The status of the catalog. */
    status: CatalogStatus
    /** The name of the catalog. */
    title: Scalars["String"]["output"]
  }

/**
 * A catalog that defines the publication associated with an app.
 *
 */
export type AppCatalogAppsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple Apps.
 *
 */
export type AppConnection = {
  __typename?: "AppConnection"
  /** A list of edges. */
  edges: Array<AppEdge>
  /** A list of the nodes contained in AppEdge. */
  nodes: Array<App>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** App credits can be applied by the merchant towards future app purchases, subscriptions, or usage records in Shopify. */
export type AppCredit = Node & {
  __typename?: "AppCredit"
  /** The amount that can be used towards future app purchases in Shopify. */
  amount: MoneyV2
  /** The date and time when the app credit was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** The description of the app credit. */
  description: Scalars["String"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** Whether the app credit is a test transaction. */
  test: Scalars["Boolean"]["output"]
}

/**
 * An auto-generated type for paginating through multiple AppCredits.
 *
 */
export type AppCreditConnection = {
  __typename?: "AppCreditConnection"
  /** A list of edges. */
  edges: Array<AppCreditEdge>
  /** A list of the nodes contained in AppCreditEdge. */
  nodes: Array<AppCredit>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one AppCredit and a cursor during pagination.
 *
 */
export type AppCreditEdge = {
  __typename?: "AppCreditEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of AppCreditEdge. */
  node: AppCredit
}

/** Possible types of app developer. */
export enum AppDeveloperType {
  /** Indicates the app developer works directly for a Merchant. */
  Merchant = "MERCHANT",
  /** Indicates the app developer is a Partner. */
  Partner = "PARTNER",
  /** Indicates the app developer is Shopify. */
  Shopify = "SHOPIFY",
  /** Indicates the app developer is unknown. It is not categorized as any of the other developer types. */
  Unknown = "UNKNOWN",
}

/** A script that defines a discount type. */
export type AppDiscountType = {
  __typename?: "AppDiscountType"
  /** The app providing the app discount type. */
  app: App
  /** The App Bridge details for discount type configuration. */
  appBridge: FunctionsAppBridge
  /** The client ID of the app providing the app discount type. */
  appKey: Scalars["String"]["output"]
  /** A description of the app discount type. */
  description?: Maybe<Scalars["String"]["output"]>
  /** The class of the app discount type. */
  discountClass: DiscountClass
  /** The ID of the function providing the app discount type. */
  functionId: Scalars["String"]["output"]
  /** The target type of the app discount type. Possible values: `SHIPPING_LINE` and `LINE_ITEM`. */
  targetType: DiscountApplicationTargetType
  /** The title of the app discount type. */
  title: Scalars["String"]["output"]
}

/**
 * An auto-generated type which holds one App and a cursor during pagination.
 *
 */
export type AppEdge = {
  __typename?: "AppEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of AppEdge. */
  node: App
}

/**
 * Reports the status of shops and their resources and displays this information
 * within Shopify admin. AppFeedback is used to notify merchants about steps they need to take
 * to set up an app on their store.
 *
 */
export type AppFeedback = {
  __typename?: "AppFeedback"
  /** The application associated to the feedback. */
  app: App
  /** A link to where merchants can resolve errors. */
  link?: Maybe<Link>
  /** The feedback message presented to the merchant. */
  messages: Array<UserError>
}

/** Represents an installed application on a shop. */
export type AppInstallation = HasMetafields &
  Node & {
    __typename?: "AppInstallation"
    /** The access scopes granted to the application by a merchant during installation. */
    accessScopes: Array<AccessScope>
    /** The active application subscriptions billed to the shop on a recurring basis. */
    activeSubscriptions: Array<AppSubscription>
    /** All subscriptions created for a shop. */
    allSubscriptions: AppSubscriptionConnection
    /** Application which is installed. */
    app: App
    /**
     * Channel associated with the installed application.
     * @deprecated Use `publication` instead.
     */
    channel?: Maybe<Channel>
    /** Credits that can be used towards future app purchases. */
    credits: AppCreditConnection
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The URL to launch the application. */
    launchUrl: Scalars["URL"]["output"]
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /** One-time purchases to a shop. */
    oneTimePurchases: AppPurchaseOneTimeConnection
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
    /** The publication associated with the installed application. */
    publication?: Maybe<Publication>
    /** The records that track the externally-captured revenue for the app. The records are used for revenue attribution purposes. */
    revenueAttributionRecords: AppRevenueAttributionRecordConnection
    /**
     * Subscriptions charge to a shop on a recurring basis.
     * @deprecated Use `activeSubscriptions` instead.
     */
    subscriptions: Array<AppSubscription>
    /** The URL to uninstall the application. */
    uninstallUrl?: Maybe<Scalars["URL"]["output"]>
  }

/** Represents an installed application on a shop. */
export type AppInstallationAllSubscriptionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<AppSubscriptionSortKeys>
}

/** Represents an installed application on a shop. */
export type AppInstallationCreditsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<AppTransactionSortKeys>
}

/** Represents an installed application on a shop. */
export type AppInstallationMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/** Represents an installed application on a shop. */
export type AppInstallationMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Represents an installed application on a shop. */
export type AppInstallationOneTimePurchasesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<AppTransactionSortKeys>
}

/** Represents an installed application on a shop. */
export type AppInstallationPrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/** Represents an installed application on a shop. */
export type AppInstallationPrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Represents an installed application on a shop. */
export type AppInstallationRevenueAttributionRecordsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<AppRevenueAttributionRecordSortKeys>
}

/**
 * The possible categories of an app installation, based on their purpose
 * or the environment they can run in.
 *
 */
export enum AppInstallationCategory {
  /** Apps that serve as channels through which sales are made, such as the online store. */
  Channel = "CHANNEL",
  /** Apps that can be used in the POS mobile client. */
  PosEmbedded = "POS_EMBEDDED",
}

/**
 * An auto-generated type for paginating through multiple AppInstallations.
 *
 */
export type AppInstallationConnection = {
  __typename?: "AppInstallationConnection"
  /** A list of edges. */
  edges: Array<AppInstallationEdge>
  /** A list of the nodes contained in AppInstallationEdge. */
  nodes: Array<AppInstallation>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one AppInstallation and a cursor during pagination.
 *
 */
export type AppInstallationEdge = {
  __typename?: "AppInstallationEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of AppInstallationEdge. */
  node: AppInstallation
}

/** The levels of privacy of an app installation. */
export enum AppInstallationPrivacy {
  Private = "PRIVATE",
  Public = "PUBLIC",
}

/** The set of valid sort keys for the AppInstallation query. */
export enum AppInstallationSortKeys {
  /** Sort by the `app_title` value. */
  AppTitle = "APP_TITLE",
  /** Sort by the `id` value. */
  Id = "ID",
  /** Sort by the `installed_at` value. */
  InstalledAt = "INSTALLED_AT",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
}

/**
 * The pricing model for the app subscription.
 * The pricing model input can be either `appRecurringPricingDetails` or `appUsagePricingDetails`.
 *
 */
export type AppPlanInput = {
  /** The pricing details for recurring billing. */
  appRecurringPricingDetails?: InputMaybe<AppRecurringPricingInput>
  /** The pricing details for usage-based billing. */
  appUsagePricingDetails?: InputMaybe<AppUsagePricingInput>
}

/** The app plan that the merchant is subscribed to. */
export type AppPlanV2 = {
  __typename?: "AppPlanV2"
  /** The plan billed to a shop on a recurring basis. */
  pricingDetails: AppPricingDetails
}

/**
 * The information about the price that's charged to a shop every plan period.
 * The concrete type can be `AppRecurringPricing` for recurring billing or `AppUsagePricing` for usage-based billing.
 *
 */
export type AppPricingDetails = AppRecurringPricing | AppUsagePricing

/** The frequency at which the shop is billed for an app subscription. */
export enum AppPricingInterval {
  /** The app subscription bills the shop annually. */
  Annual = "ANNUAL",
  /** The app subscription bills the shop every 30 days. */
  Every_30Days = "EVERY_30_DAYS",
}

/** The public-facing category for an app. */
export enum AppPublicCategory {
  /** The app's public category is [custom](https://shopify.dev/apps/distribution#capabilities-and-requirements). */
  Custom = "CUSTOM",
  /** The app's public category is other. An app is in this category if it's not classified under any of the other app types (private, public, or custom). */
  Other = "OTHER",
  /** The app's public category is [private](https://shopify.dev/apps/distribution#deprecated-app-types). */
  Private = "PRIVATE",
  /** The app's public category is [public](https://shopify.dev/apps/distribution#capabilities-and-requirements). */
  Public = "PUBLIC",
}

/** Services and features purchased once by the store. */
export type AppPurchase = {
  /** The date and time when the app purchase occurred. */
  createdAt: Scalars["DateTime"]["output"]
  /** The name of the app purchase. */
  name: Scalars["String"]["output"]
  /** The amount to be charged to the store for the app purchase. */
  price: MoneyV2
  /** The status of the app purchase. */
  status: AppPurchaseStatus
  /** Whether the app purchase is a test transaction. */
  test: Scalars["Boolean"]["output"]
}

/** Services and features purchased once by a store. */
export type AppPurchaseOneTime = AppPurchase &
  Node & {
    __typename?: "AppPurchaseOneTime"
    /** The date and time when the app purchase occurred. */
    createdAt: Scalars["DateTime"]["output"]
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The name of the app purchase. */
    name: Scalars["String"]["output"]
    /** The amount to be charged to the store for the app purchase. */
    price: MoneyV2
    /** The status of the app purchase. */
    status: AppPurchaseStatus
    /** Whether the app purchase is a test transaction. */
    test: Scalars["Boolean"]["output"]
  }

/**
 * An auto-generated type for paginating through multiple AppPurchaseOneTimes.
 *
 */
export type AppPurchaseOneTimeConnection = {
  __typename?: "AppPurchaseOneTimeConnection"
  /** A list of edges. */
  edges: Array<AppPurchaseOneTimeEdge>
  /** A list of the nodes contained in AppPurchaseOneTimeEdge. */
  nodes: Array<AppPurchaseOneTime>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `appPurchaseOneTimeCreate` mutation. */
export type AppPurchaseOneTimeCreatePayload = {
  __typename?: "AppPurchaseOneTimeCreatePayload"
  /** The newly created app one-time purchase. */
  appPurchaseOneTime?: Maybe<AppPurchaseOneTime>
  /**
   * The URL that the merchant can access to approve or decline the newly created app one-time purchase.
   *
   * If the merchant declines, then the merchant is redirected to the app and receives a notification message stating that the charge was declined.
   * If the merchant approves and they're successfully invoiced, then the state of the charge changes from `pending` to `active`.
   *
   * You get paid after the charge is activated.
   *
   */
  confirmationUrl?: Maybe<Scalars["URL"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * An auto-generated type which holds one AppPurchaseOneTime and a cursor during pagination.
 *
 */
export type AppPurchaseOneTimeEdge = {
  __typename?: "AppPurchaseOneTimeEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of AppPurchaseOneTimeEdge. */
  node: AppPurchaseOneTime
}

/**
 * The approval status of the app purchase.
 *
 * The merchant is charged for the purchase immediately after approval, and the status changes to `active`.
 * If the payment fails, then the app purchase remains `pending`.
 *
 * Purchases start as `pending` and can change to: `active`, `declined`, `expired`. After a purchase changes, it
 * remains in that final state.
 *
 */
export enum AppPurchaseStatus {
  /**
   * The app purchase has been approved by the merchant and is ready to be activated by the app. App purchases created through the GraphQL Admin API are activated upon approval.
   * @deprecated As of API version 2021-01, when a merchant accepts an app purchase, the status immediately changes from `pending` to `active`.
   */
  Accepted = "ACCEPTED",
  /** The app purchase was approved by the merchant and has been activated by the app. Active app purchases are charged to the merchant and are paid out to the partner. */
  Active = "ACTIVE",
  /** The app purchase was declined by the merchant. */
  Declined = "DECLINED",
  /** The app purchase was not accepted within two days of being created. */
  Expired = "EXPIRED",
  /** The app purchase is pending approval by the merchant. */
  Pending = "PENDING",
}

/**
 * The pricing information about a subscription app.
 * The object contains an interval (the frequency at which the shop is billed for an app subscription) and
 * a price (the amount to be charged to the subscribing shop at each interval).
 *
 */
export type AppRecurringPricing = {
  __typename?: "AppRecurringPricing"
  /** The discount applied to the subscription for a given number of billing intervals. */
  discount?: Maybe<AppSubscriptionDiscount>
  /** The frequency at which the subscribing shop is billed for an app subscription. */
  interval: AppPricingInterval
  /** The amount and currency to be charged to the subscribing shop every billing interval. */
  price: MoneyV2
}

/** Instructs the app subscription to generate a fixed charge on a recurring basis. The frequency is specified by the billing interval. */
export type AppRecurringPricingInput = {
  /** The discount applied to the subscription for a given number of billing intervals. */
  discount?: InputMaybe<AppSubscriptionDiscountInput>
  /** How often the app subscription generates a charge. */
  interval?: InputMaybe<AppPricingInterval>
  /** The amount to be charged to the store every billing interval. */
  price: MoneyInput
}

/** Represents app revenue that was captured externally by the partner. */
export type AppRevenueAttributionRecord = Node & {
  __typename?: "AppRevenueAttributionRecord"
  /** The financial amount captured in this attribution. */
  amount: MoneyV2
  /** The timestamp when the financial amount was captured. */
  capturedAt: Scalars["DateTime"]["output"]
  /** The timestamp at which this revenue attribution was issued. */
  createdAt: Scalars["DateTime"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /**
   * The unique value submitted during the creation of the app revenue attribution record.
   * For more information, refer to
   * [Idempotent requests](https://shopify.dev/api/usage/idempotent-requests).
   *
   */
  idempotencyKey: Scalars["String"]["output"]
  /** Indicates whether this is a test submission. */
  test: Scalars["Boolean"]["output"]
  /** The type of revenue attribution. */
  type: AppRevenueAttributionType
}

/**
 * An auto-generated type for paginating through multiple AppRevenueAttributionRecords.
 *
 */
export type AppRevenueAttributionRecordConnection = {
  __typename?: "AppRevenueAttributionRecordConnection"
  /** A list of edges. */
  edges: Array<AppRevenueAttributionRecordEdge>
  /** A list of the nodes contained in AppRevenueAttributionRecordEdge. */
  nodes: Array<AppRevenueAttributionRecord>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one AppRevenueAttributionRecord and a cursor during pagination.
 *
 */
export type AppRevenueAttributionRecordEdge = {
  __typename?: "AppRevenueAttributionRecordEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of AppRevenueAttributionRecordEdge. */
  node: AppRevenueAttributionRecord
}

/** The set of valid sort keys for the AppRevenueAttributionRecord query. */
export enum AppRevenueAttributionRecordSortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
}

/** Represents the billing types of revenue attribution. */
export enum AppRevenueAttributionType {
  /** App purchase related revenue collection. */
  ApplicationPurchase = "APPLICATION_PURCHASE",
  /** App subscription revenue collection. */
  ApplicationSubscription = "APPLICATION_SUBSCRIPTION",
  /** App usage-based revenue collection. */
  ApplicationUsage = "APPLICATION_USAGE",
  /** Other app revenue collection type. */
  Other = "OTHER",
}

/** Provides users access to services and/or features for a duration of time. */
export type AppSubscription = Node & {
  __typename?: "AppSubscription"
  /** The date and time when the app subscription was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** The date and time when the current app subscription period ends. Returns `null` if the subscription isn't active. */
  currentPeriodEnd?: Maybe<Scalars["DateTime"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The plans attached to the app subscription. */
  lineItems: Array<AppSubscriptionLineItem>
  /** The name of the app subscription. */
  name: Scalars["String"]["output"]
  /** The URL that the merchant is redirected to after approving the app subscription. */
  returnUrl: Scalars["URL"]["output"]
  /** The status of the app subscription. */
  status: AppSubscriptionStatus
  /** Specifies whether the app subscription is a test transaction. */
  test: Scalars["Boolean"]["output"]
  /** The number of free trial days, starting at the subscription's creation date, by which billing is delayed. */
  trialDays: Scalars["Int"]["output"]
}

/** Return type for `appSubscriptionCancel` mutation. */
export type AppSubscriptionCancelPayload = {
  __typename?: "AppSubscriptionCancelPayload"
  /** The cancelled app subscription. */
  appSubscription?: Maybe<AppSubscription>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * An auto-generated type for paginating through multiple AppSubscriptions.
 *
 */
export type AppSubscriptionConnection = {
  __typename?: "AppSubscriptionConnection"
  /** A list of edges. */
  edges: Array<AppSubscriptionEdge>
  /** A list of the nodes contained in AppSubscriptionEdge. */
  nodes: Array<AppSubscription>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `appSubscriptionCreate` mutation. */
export type AppSubscriptionCreatePayload = {
  __typename?: "AppSubscriptionCreatePayload"
  /** The newly-created app subscription. */
  appSubscription?: Maybe<AppSubscription>
  /** The URL pointing to the page where the merchant approves or declines the charges for an app subscription. */
  confirmationUrl?: Maybe<Scalars["URL"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Discount applied to the recurring pricing portion of a subscription. */
export type AppSubscriptionDiscount = {
  __typename?: "AppSubscriptionDiscount"
  /**
   * The total number of billing intervals to which the discount will be applied.
   * The discount will be applied to an indefinite number of billing intervals if this value is blank.
   *
   */
  durationLimitInIntervals?: Maybe<Scalars["Int"]["output"]>
  /** The price of the subscription after the discount is applied. */
  priceAfterDiscount: MoneyV2
  /** The remaining number of billing intervals to which the discount will be applied. */
  remainingDurationInIntervals?: Maybe<Scalars["Int"]["output"]>
  /** The value of the discount applied every billing interval. */
  value: AppSubscriptionDiscountValue
}

/** The fixed amount value of a discount. */
export type AppSubscriptionDiscountAmount = {
  __typename?: "AppSubscriptionDiscountAmount"
  /** The fixed amount value of a discount. */
  amount: MoneyV2
}

/**
 * The input fields to specify a discount to the recurring pricing portion of a subscription over a number of billing intervals.
 *
 */
export type AppSubscriptionDiscountInput = {
  /**
   * The total number of billing intervals to which the discount will be applied. Must be greater than 0.
   * The discount will be applied to an indefinite number of billing intervals if this value is left blank.
   *
   */
  durationLimitInIntervals?: InputMaybe<Scalars["Int"]["input"]>
  /** The value to be discounted every billing interval. */
  value?: InputMaybe<AppSubscriptionDiscountValueInput>
}

/** The percentage value of a discount. */
export type AppSubscriptionDiscountPercentage = {
  __typename?: "AppSubscriptionDiscountPercentage"
  /** The percentage value of a discount. */
  percentage: Scalars["Float"]["output"]
}

/** The value of the discount. */
export type AppSubscriptionDiscountValue = AppSubscriptionDiscountAmount | AppSubscriptionDiscountPercentage

/** The input fields to specify the value discounted every billing interval. */
export type AppSubscriptionDiscountValueInput = {
  /** The monetary value of a discount. */
  amount?: InputMaybe<Scalars["Decimal"]["input"]>
  /** The percentage value of a discount. */
  percentage?: InputMaybe<Scalars["Float"]["input"]>
}

/**
 * An auto-generated type which holds one AppSubscription and a cursor during pagination.
 *
 */
export type AppSubscriptionEdge = {
  __typename?: "AppSubscriptionEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of AppSubscriptionEdge. */
  node: AppSubscription
}

/** The plan attached to an app subscription. */
export type AppSubscriptionLineItem = {
  __typename?: "AppSubscriptionLineItem"
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The pricing model for the app subscription. */
  plan: AppPlanV2
  /** A list of the store's usage records for a usage pricing plan. */
  usageRecords: AppUsageRecordConnection
}

/** The plan attached to an app subscription. */
export type AppSubscriptionLineItemUsageRecordsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<AppUsageRecordSortKeys>
}

/** The input fields to add more than one pricing plan to an app subscription. */
export type AppSubscriptionLineItemInput = {
  /** The pricing model for the app subscription. */
  plan: AppPlanInput
}

/** Return type for `appSubscriptionLineItemUpdate` mutation. */
export type AppSubscriptionLineItemUpdatePayload = {
  __typename?: "AppSubscriptionLineItemUpdatePayload"
  /** The updated app subscription. */
  appSubscription?: Maybe<AppSubscription>
  /** The URL where the merchant approves or declines the updated app subscription line item. */
  confirmationUrl?: Maybe<Scalars["URL"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The replacement behavior when creating an app subscription for a merchant with an already existing app subscription. */
export enum AppSubscriptionReplacementBehavior {
  /** Cancels the merchant's current app subscription immediately and replaces it with the newly created app subscription. */
  ApplyImmediately = "APPLY_IMMEDIATELY",
  /** Defers canceling the merchant's current app subscription and applying the newly created app subscription until the start of the next billing cycle. This value is ignored if the new app subscription is using a different currency than the current app subscription, in which case the new app subscription is applied immediately. */
  ApplyOnNextBillingCycle = "APPLY_ON_NEXT_BILLING_CYCLE",
  /**
   * Cancels the merchant's current app subscription immediately and replaces it with the newly created app subscription, with the exception of
   * the following scenarios where replacing the current app subscription will be deferred until the start of the next billing cycle.
   * 1) The current app subscription is annual and the newly created app subscription is annual, using the same currency, but is of a lesser value.
   * 2) The current app subscription is annual and the newly created app subscription is monthly and using the same currency.
   * 3) The current app subscription and the newly created app subscription are identical except for the `discount` value.
   *
   */
  Standard = "STANDARD",
}

/** The set of valid sort keys for the AppSubscription query. */
export enum AppSubscriptionSortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
}

/** The status of the app subscription. */
export enum AppSubscriptionStatus {
  /**
   * The app subscription has been approved by the merchant and is ready to be activated by the app.
   * @deprecated As of API version 2021-01, when a merchant approves an app subscription, the status immediately transitions from `pending` to `active`.
   */
  Accepted = "ACCEPTED",
  /** The app subscription has been approved by the merchant. Active app subscriptions are billed to the shop. After payment, partners receive payouts. */
  Active = "ACTIVE",
  /** The app subscription was cancelled by the app. This could be caused by the app being uninstalled, a new app subscription being activated, or a direct cancellation by the app. This is a terminal state. */
  Cancelled = "CANCELLED",
  /** The app subscription was declined by the merchant. This is a terminal state. */
  Declined = "DECLINED",
  /** The app subscription wasn't approved by the merchant within two days of being created. This is a terminal state. */
  Expired = "EXPIRED",
  /** The app subscription is on hold due to non-payment. The subscription re-activates after payments resume. */
  Frozen = "FROZEN",
  /** The app subscription is pending approval by the merchant. */
  Pending = "PENDING",
}

/** Return type for `appSubscriptionTrialExtend` mutation. */
export type AppSubscriptionTrialExtendPayload = {
  __typename?: "AppSubscriptionTrialExtendPayload"
  /** The app subscription that had its trial extended. */
  appSubscription?: Maybe<AppSubscription>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<AppSubscriptionTrialExtendUserError>
}

/** An error that occurs during the execution of `AppSubscriptionTrialExtend`. */
export type AppSubscriptionTrialExtendUserError = DisplayableError & {
  __typename?: "AppSubscriptionTrialExtendUserError"
  /** The error code. */
  code?: Maybe<AppSubscriptionTrialExtendUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `AppSubscriptionTrialExtendUserError`. */
export enum AppSubscriptionTrialExtendUserErrorCode {
  /** The app subscription isn't active. */
  SubscriptionNotActive = "SUBSCRIPTION_NOT_ACTIVE",
  /** The app subscription wasn't found. */
  SubscriptionNotFound = "SUBSCRIPTION_NOT_FOUND",
  /** The trial isn't active. */
  TrialNotActive = "TRIAL_NOT_ACTIVE",
}

/** The set of valid sort keys for the AppTransaction query. */
export enum AppTransactionSortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
}

/**
 * Defines a usage pricing model for the app subscription.
 * These charges are variable based on how much the merchant uses the app.
 *
 */
export type AppUsagePricing = {
  __typename?: "AppUsagePricing"
  /** The total usage records for interval. */
  balanceUsed: MoneyV2
  /**
   * The capped amount prevents the merchant from being charged for any usage over that amount during a billing period.
   * This prevents billing from exceeding a maximum threshold over the duration of the billing period.
   * For the merchant to continue using the app after exceeding a capped amount, they would need to agree to a new usage charge.
   *
   */
  cappedAmount: MoneyV2
  /** The frequency with which the app usage records are billed. */
  interval: AppPricingInterval
  /**
   * The terms and conditions for app usage pricing.
   * Must be present in order to create usage charges.
   * The terms are presented to the merchant when they approve an app's usage charges.
   *
   */
  terms: Scalars["String"]["output"]
}

/** The input fields to issue arbitrary charges for app usage associated with a subscription. */
export type AppUsagePricingInput = {
  /** The maximum amount of usage charges that can be incurred within a subscription billing interval. */
  cappedAmount: MoneyInput
  /** The terms and conditions for app usage. These terms stipulate the pricing model for the charges that an app creates. */
  terms: Scalars["String"]["input"]
}

/** Store usage for app subscriptions with usage pricing. */
export type AppUsageRecord = Node & {
  __typename?: "AppUsageRecord"
  /** The date and time when the usage record was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** The description of the app usage record. */
  description: Scalars["String"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /**
   * A unique key generated by the client to avoid duplicate charges.
   *
   */
  idempotencyKey?: Maybe<Scalars["String"]["output"]>
  /** The price of the usage record. */
  price: MoneyV2
  /** Defines the usage pricing plan the merchant is subscribed to. */
  subscriptionLineItem: AppSubscriptionLineItem
}

/**
 * An auto-generated type for paginating through multiple AppUsageRecords.
 *
 */
export type AppUsageRecordConnection = {
  __typename?: "AppUsageRecordConnection"
  /** A list of edges. */
  edges: Array<AppUsageRecordEdge>
  /** A list of the nodes contained in AppUsageRecordEdge. */
  nodes: Array<AppUsageRecord>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `appUsageRecordCreate` mutation. */
export type AppUsageRecordCreatePayload = {
  __typename?: "AppUsageRecordCreatePayload"
  /** The newly created app usage record. */
  appUsageRecord?: Maybe<AppUsageRecord>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * An auto-generated type which holds one AppUsageRecord and a cursor during pagination.
 *
 */
export type AppUsageRecordEdge = {
  __typename?: "AppUsageRecordEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of AppUsageRecordEdge. */
  node: AppUsageRecord
}

/** The set of valid sort keys for the AppUsageRecord query. */
export enum AppUsageRecordSortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
}

/** Represents a generic custom attribute. */
export type Attribute = {
  __typename?: "Attribute"
  /** Key or name of the attribute. */
  key: Scalars["String"]["output"]
  /** Value of the attribute. */
  value?: Maybe<Scalars["String"]["output"]>
}

/** The input fields for an attribute. */
export type AttributeInput = {
  /** Key or name of the attribute. */
  key: Scalars["String"]["input"]
  /** Value of the attribute. */
  value: Scalars["String"]["input"]
}

/**
 * Automatic discount applications capture the intentions of a discount that was automatically applied.
 *
 */
export type AutomaticDiscountApplication = DiscountApplication & {
  __typename?: "AutomaticDiscountApplication"
  /** The method by which the discount's value is applied to its entitled items. */
  allocationMethod: DiscountApplicationAllocationMethod
  /**
   * An ordered index that can be used to identify the discount application and indicate the precedence
   * of the discount application for calculations.
   *
   */
  index: Scalars["Int"]["output"]
  /** How the discount amount is distributed on the discounted lines. */
  targetSelection: DiscountApplicationTargetSelection
  /** Whether the discount is applied on line items or shipping lines. */
  targetType: DiscountApplicationTargetType
  /** The title of the discount application. */
  title: Scalars["String"]["output"]
  /** The value of the discount application. */
  value: PricingValue
}

/** The set of valid sort keys for the AutomaticDiscount query. */
export enum AutomaticDiscountSortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
}

/**
 * Represents an object containing all information for channels available to a shop.
 *
 */
export type AvailableChannelDefinitionsByChannel = {
  __typename?: "AvailableChannelDefinitionsByChannel"
  /** The channel definitions for channels installed on a shop. */
  channelDefinitions: Array<ChannelDefinition>
  /** The name of the channel. */
  channelName: Scalars["String"]["output"]
}

/** The possible types for a badge. */
export enum BadgeType {
  /** This badge has type `attention`. */
  Attention = "ATTENTION",
  /** This badge has type `default`. */
  Default = "DEFAULT",
  /** This badge has type `info`. */
  Info = "INFO",
  /** This badge has type `success`. */
  Success = "SUCCESS",
  /** This badge has type `warning`. */
  Warning = "WARNING",
}

/** The set of valid sort keys for the BalanceTransaction query. */
export enum BalanceTransactionSortKeys {
  /** Sort by the `amount` value. */
  Amount = "AMOUNT",
  /** Sort by the `fee` value. */
  Fee = "FEE",
  /** Sort by the `id` value. */
  Id = "ID",
  /** Sort by the `net` value. */
  Net = "NET",
  /** Sort by the `order_name` value. */
  OrderName = "ORDER_NAME",
  /** Sort by the `payment_method_name` value. */
  PaymentMethodName = "PAYMENT_METHOD_NAME",
  /** Sort by the `payout_date` value. */
  PayoutDate = "PAYOUT_DATE",
  /** Sort by the `payout_status` value. */
  PayoutStatus = "PAYOUT_STATUS",
  /** Sort by the `processed_at` value. */
  ProcessedAt = "PROCESSED_AT",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `transaction_type` value. */
  TransactionType = "TRANSACTION_TYPE",
}

/** Generic payment details that are related to a transaction. */
export type BasePaymentDetails = {
  /** The name of payment method used by the buyer. */
  paymentMethodName?: Maybe<Scalars["String"]["output"]>
}

/**
 * Basic events chronicle resource activities such as the creation of an article, the fulfillment of an order, or
 * the addition of a product.
 *
 */
export type BasicEvent = Event &
  Node & {
    __typename?: "BasicEvent"
    /** The name of the app that created the event. */
    appTitle?: Maybe<Scalars["String"]["output"]>
    /** Whether the event was created by an app. */
    attributeToApp: Scalars["Boolean"]["output"]
    /** Whether the event was caused by an admin user. */
    attributeToUser: Scalars["Boolean"]["output"]
    /** The date and time when the event was created. */
    createdAt: Scalars["DateTime"]["output"]
    /** Whether the event is critical. */
    criticalAlert: Scalars["Boolean"]["output"]
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** Human readable text that describes the event. */
    message: Scalars["FormattedString"]["output"]
  }

/** Represents an error that happens during the execution of a billing attempt mutation. */
export type BillingAttemptUserError = DisplayableError & {
  __typename?: "BillingAttemptUserError"
  /** The error code. */
  code?: Maybe<BillingAttemptUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `BillingAttemptUserError`. */
export enum BillingAttemptUserErrorCode {
  /** The input value is blank. */
  Blank = "BLANK",
  /** Subscription contract does not exist. */
  ContractNotFound = "CONTRACT_NOT_FOUND",
  /** Subscription contract cannot be billed once terminated. */
  ContractTerminated = "CONTRACT_TERMINATED",
  /** Subscription contract is under review. */
  ContractUnderReview = "CONTRACT_UNDER_REVIEW",
  /** Billing cycle selector cannot select billing cycle outside of index range. */
  CycleIndexOutOfRange = "CYCLE_INDEX_OUT_OF_RANGE",
  /** Billing cycle selector cannot select billing cycle outside of start date range. */
  CycleStartDateOutOfRange = "CYCLE_START_DATE_OUT_OF_RANGE",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** Origin time cannot be before the contract creation time. */
  OriginTimeBeforeContractCreation = "ORIGIN_TIME_BEFORE_CONTRACT_CREATION",
  /** Origin time needs to be within the selected billing cycle's start and end at date. */
  OriginTimeOutOfRange = "ORIGIN_TIME_OUT_OF_RANGE",
  /** Billing cycle selector cannot select upcoming billing cycle past limit. */
  UpcomingCycleLimitExceeded = "UPCOMING_CYCLE_LIMIT_EXCEEDED",
}

/** Possible error codes that can be returned by `BulkMutationUserError`. */
export enum BulkMutationErrorCode {
  /** There was a problem reading the JSONL file. This error might be intermittent, so you can try performing the same query again. */
  InternalFileServerError = "INTERNAL_FILE_SERVER_ERROR",
  /** The operation did not run because the mutation is invalid. Check your mutation syntax and try again. */
  InvalidMutation = "INVALID_MUTATION",
  /** The JSONL file submitted via the `stagedUploadsCreate` mutation is invalid. Update the file and try again. */
  InvalidStagedUploadFile = "INVALID_STAGED_UPLOAD_FILE",
  /** The JSONL file could not be found. Try [uploading the file](https://shopify.dev/api/usage/bulk-operations/imports#generate-the-uploaded-url-and-parameters) again, and check that you've entered the URL correctly for the `stagedUploadPath` mutation argument. */
  NoSuchFile = "NO_SUCH_FILE",
  /** The operation did not run because another bulk mutation is already running. [Wait for the operation to finish](https://shopify.dev/api/usage/bulk-operations/imports#wait-for-the-operation-to-finish) before retrying this operation. */
  OperationInProgress = "OPERATION_IN_PROGRESS",
}

/** Represents an error that happens during execution of a bulk mutation. */
export type BulkMutationUserError = DisplayableError & {
  __typename?: "BulkMutationUserError"
  /** The error code. */
  code?: Maybe<BulkMutationErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/**
 * An asynchronous long-running operation to fetch data in bulk or to bulk import data.
 *
 * Bulk operations are created using the `bulkOperationRunQuery` or `bulkOperationRunMutation` mutation. After
 * they are created, clients should poll the `status` field for updates. When `COMPLETED`, the `url` field contains
 * a link to the data in [JSONL](http://jsonlines.org/) format.
 *
 * Refer to the [bulk operations guide](https://shopify.dev/api/usage/bulk-operations/imports) for more details.
 *
 */
export type BulkOperation = Node & {
  __typename?: "BulkOperation"
  /** When the bulk operation was successfully completed. */
  completedAt?: Maybe<Scalars["DateTime"]["output"]>
  /** When the bulk operation was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** Error code for failed operations. */
  errorCode?: Maybe<BulkOperationErrorCode>
  /** File size in bytes of the file in the `url` field. */
  fileSize?: Maybe<Scalars["UnsignedInt64"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /**
   * A running count of all the objects processed.
   * For example, when fetching all the products and their variants, this field counts both products and variants.
   * This field can be used to track operation progress.
   *
   */
  objectCount: Scalars["UnsignedInt64"]["output"]
  /**
   * The URL that points to the partial or incomplete response data (in [JSONL](http://jsonlines.org/) format) that was returned by a failed operation.
   * The URL expires 7 days after the operation fails. Returns `null` when there's no data available.
   *
   */
  partialDataUrl?: Maybe<Scalars["URL"]["output"]>
  /** GraphQL query document specified in `bulkOperationRunQuery`. */
  query: Scalars["String"]["output"]
  /**
   * A running count of all the objects that are processed at the root of the query.
   * For example, when fetching all the products and their variants, this field only counts products.
   * This field can be used to track operation progress.
   *
   */
  rootObjectCount: Scalars["UnsignedInt64"]["output"]
  /** Status of the bulk operation. */
  status: BulkOperationStatus
  /** The bulk operation's type. */
  type: BulkOperationType
  /**
   * The URL that points to the response data in [JSONL](http://jsonlines.org/) format.
   * The URL expires 7 days after the operation completes.
   *
   */
  url?: Maybe<Scalars["URL"]["output"]>
}

/** Return type for `bulkOperationCancel` mutation. */
export type BulkOperationCancelPayload = {
  __typename?: "BulkOperationCancelPayload"
  /** The bulk operation to be canceled. */
  bulkOperation?: Maybe<BulkOperation>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Error codes for failed bulk operations. */
export enum BulkOperationErrorCode {
  /**
   * The provided operation `query` returned access denied due to missing
   * [access scopes](https://shopify.dev/api/usage/access-scopes).
   * Review the requested object permissions and execute the query as a normal non-bulk GraphQL request to see more details.
   *
   */
  AccessDenied = "ACCESS_DENIED",
  /**
   * The operation resulted in partial or incomplete data due to internal server errors during execution.
   * These errors might be intermittent, so you can try performing the same query again.
   *
   */
  InternalServerError = "INTERNAL_SERVER_ERROR",
  /**
   * The operation resulted in partial or incomplete data due to query timeouts during execution.
   * In some cases, timeouts can be avoided by modifying your `query` to select fewer fields.
   *
   */
  Timeout = "TIMEOUT",
}

/** Return type for `bulkOperationRunMutation` mutation. */
export type BulkOperationRunMutationPayload = {
  __typename?: "BulkOperationRunMutationPayload"
  /** The newly created bulk operation. */
  bulkOperation?: Maybe<BulkOperation>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BulkMutationUserError>
}

/** Return type for `bulkOperationRunQuery` mutation. */
export type BulkOperationRunQueryPayload = {
  __typename?: "BulkOperationRunQueryPayload"
  /** The newly created bulk operation. */
  bulkOperation?: Maybe<BulkOperation>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The valid values for the status of a bulk operation. */
export enum BulkOperationStatus {
  /** The bulk operation has been canceled. */
  Canceled = "CANCELED",
  /**
   * Cancelation has been initiated on the bulk operation. There may be a short delay from when a cancelation
   * starts until the operation is actually canceled.
   *
   */
  Canceling = "CANCELING",
  /** The bulk operation has successfully completed. */
  Completed = "COMPLETED",
  /** The bulk operation has been created. */
  Created = "CREATED",
  /** The bulk operation URL has expired. */
  Expired = "EXPIRED",
  /**
   * The bulk operation has failed. For information on why the operation failed, use
   * [BulkOperation.errorCode](https://shopify.dev/api/admin-graphql/latest/enums/bulkoperationerrorcode).
   *
   */
  Failed = "FAILED",
  /** The bulk operation is runnning. */
  Running = "RUNNING",
}

/** The valid values for the bulk operation's type. */
export enum BulkOperationType {
  /** The bulk operation is a mutation. */
  Mutation = "MUTATION",
  /** The bulk operation is a query. */
  Query = "QUERY",
}

/** Return type for `bulkProductResourceFeedbackCreate` mutation. */
export type BulkProductResourceFeedbackCreatePayload = {
  __typename?: "BulkProductResourceFeedbackCreatePayload"
  /** The feedback that's created. */
  feedback?: Maybe<Array<ProductResourceFeedback>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BulkProductResourceFeedbackCreateUserError>
}

/** An error that occurs during the execution of `BulkProductResourceFeedbackCreate`. */
export type BulkProductResourceFeedbackCreateUserError = DisplayableError & {
  __typename?: "BulkProductResourceFeedbackCreateUserError"
  /** The error code. */
  code?: Maybe<BulkProductResourceFeedbackCreateUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `BulkProductResourceFeedbackCreateUserError`. */
export enum BulkProductResourceFeedbackCreateUserErrorCode {
  /** The input value is blank. */
  Blank = "BLANK",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** The input value should be less than or equal to the maximum value allowed. */
  LessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO",
  /** The operation was attempted on too many feedback objects. The maximum number of feedback objects that you can operate on is 50. */
  MaximumFeedbackLimitExceeded = "MAXIMUM_FEEDBACK_LIMIT_EXCEEDED",
  /** The feedback for a later version of this resource was already accepted. */
  OutdatedFeedback = "OUTDATED_FEEDBACK",
  /** The input value needs to be blank. */
  Present = "PRESENT",
  /** The product wasn't found or isn't available to the channel. */
  ProductNotFound = "PRODUCT_NOT_FOUND",
}

/**
 * Represents the Bundles feature configuration for the shop.
 *
 */
export type BundlesFeature = {
  __typename?: "BundlesFeature"
  /** Whether a shop is configured properly to sell bundles. */
  eligibleForBundles: Scalars["Boolean"]["output"]
  /** The reason why a shop is not eligible for bundles. */
  ineligibilityReason?: Maybe<Scalars["String"]["output"]>
  /** Whether a shop has any fixed bundle products or has a cartTransform function installed. */
  sellsBundles: Scalars["Boolean"]["output"]
}

/** Possible error codes that can be returned by `BusinessCustomerUserError`. */
export enum BusinessCustomerErrorCode {
  /** The input value is blank. */
  Blank = "BLANK",
  /** Deleting the resource failed. */
  FailedToDelete = "FAILED_TO_DELETE",
  /** An internal error occurred. */
  InternalError = "INTERNAL_ERROR",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** The input is invalid. */
  InvalidInput = "INVALID_INPUT",
  /** The number of resources exceeded the limit. */
  LimitReached = "LIMIT_REACHED",
  /** The input is empty. */
  NoInput = "NO_INPUT",
  /** Missing a required field. */
  Required = "REQUIRED",
  /** The resource wasn't found. */
  ResourceNotFound = "RESOURCE_NOT_FOUND",
  /** The input value is already taken. */
  Taken = "TAKEN",
  /** The field value is too long. */
  TooLong = "TOO_LONG",
  /** Unexpected type. */
  UnexpectedType = "UNEXPECTED_TYPE",
}

/** An error that happens during the execution of a business customer mutation. */
export type BusinessCustomerUserError = DisplayableError & {
  __typename?: "BusinessCustomerUserError"
  /** The error code. */
  code?: Maybe<BusinessCustomerErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Settings describing the behavior of checkout for a B2B buyer. */
export type BuyerExperienceConfiguration = {
  __typename?: "BuyerExperienceConfiguration"
  /** Whether to checkout to draft order for merchant review. */
  checkoutToDraft: Scalars["Boolean"]["output"]
  /** Whether to allow customers to use editable shipping addresses. */
  editableShippingAddress: Scalars["Boolean"]["output"]
  /**
   * Whether a buyer must pay at checkout or they can also choose to pay
   * later using net terms.
   *
   */
  payNowOnly: Scalars["Boolean"]["output"]
  /** Represents the merchant configured payment terms. */
  paymentTermsTemplate?: Maybe<PaymentTermsTemplate>
}

/** The input fields specifying the behavior of checkout for a B2B buyer. */
export type BuyerExperienceConfigurationInput = {
  /** Whether to checkout to draft order for merchant review. */
  checkoutToDraft?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Whether to allow customers to edit their shipping address at checkout. */
  editableShippingAddress?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Represents the merchant configured payment terms. */
  paymentTermsTemplateId?: InputMaybe<Scalars["ID"]["input"]>
}

/**
 * A discount that is automatically applied to an order that is being edited.
 *
 */
export type CalculatedAutomaticDiscountApplication = CalculatedDiscountApplication & {
  __typename?: "CalculatedAutomaticDiscountApplication"
  /** The method by which the discount's value is allocated to its entitled items. */
  allocationMethod: DiscountApplicationAllocationMethod
  /** The level at which the discount was applied. */
  appliedTo: DiscountApplicationLevel
  /** The description of discount application. Indicates the reason why the discount was applied. */
  description?: Maybe<Scalars["String"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** How the discount amount is distributed on the discounted lines. */
  targetSelection: DiscountApplicationTargetSelection
  /** Whether the discount is applied on line items or shipping lines. */
  targetType: DiscountApplicationTargetType
  /** The value of the discount application. */
  value: PricingValue
}

/**
 * An amount discounting the line that has been allocated by an associated discount application.
 *
 */
export type CalculatedDiscountAllocation = {
  __typename?: "CalculatedDiscountAllocation"
  /** The money amount that's allocated by the discount application in shop and presentment currencies. */
  allocatedAmountSet: MoneyBag
  /** The discount that the allocated amount originated from. */
  discountApplication: CalculatedDiscountApplication
}

/**
 * A [discount application](https://shopify.dev/api/admin-graphql/latest/interfaces/discountapplication) involved in order editing that might be newly added or have new changes applied.
 *
 */
export type CalculatedDiscountApplication = {
  /** The method by which the discount's value is allocated to its entitled items. */
  allocationMethod: DiscountApplicationAllocationMethod
  /** The level at which the discount was applied. */
  appliedTo: DiscountApplicationLevel
  /** The description of discount application. Indicates the reason why the discount was applied. */
  description?: Maybe<Scalars["String"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** How the discount amount is distributed on the discounted lines. */
  targetSelection: DiscountApplicationTargetSelection
  /** Whether the discount is applied on line items or shipping lines. */
  targetType: DiscountApplicationTargetType
  /** The value of the discount application. */
  value: PricingValue
}

/**
 * An auto-generated type for paginating through multiple CalculatedDiscountApplications.
 *
 */
export type CalculatedDiscountApplicationConnection = {
  __typename?: "CalculatedDiscountApplicationConnection"
  /** A list of edges. */
  edges: Array<CalculatedDiscountApplicationEdge>
  /** A list of the nodes contained in CalculatedDiscountApplicationEdge. */
  nodes: Array<CalculatedDiscountApplication>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one CalculatedDiscountApplication and a cursor during pagination.
 *
 */
export type CalculatedDiscountApplicationEdge = {
  __typename?: "CalculatedDiscountApplicationEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CalculatedDiscountApplicationEdge. */
  node: CalculatedDiscountApplication
}

/**
 * A discount code that is applied to an order that is being edited.
 *
 */
export type CalculatedDiscountCodeApplication = CalculatedDiscountApplication & {
  __typename?: "CalculatedDiscountCodeApplication"
  /** The method by which the discount's value is allocated to its entitled items. */
  allocationMethod: DiscountApplicationAllocationMethod
  /** The level at which the discount was applied. */
  appliedTo: DiscountApplicationLevel
  /** The string identifying the discount code that was used at the time of application. */
  code: Scalars["String"]["output"]
  /** The description of discount application. Indicates the reason why the discount was applied. */
  description?: Maybe<Scalars["String"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** How the discount amount is distributed on the discounted lines. */
  targetSelection: DiscountApplicationTargetSelection
  /** Whether the discount is applied on line items or shipping lines. */
  targetType: DiscountApplicationTargetType
  /** The value of the discount application. */
  value: PricingValue
}

/** The computed properties for a draft order. */
export type CalculatedDraftOrder = {
  __typename?: "CalculatedDraftOrder"
  /** Order-level discount applied to the draft order. */
  appliedDiscount?: Maybe<DraftOrderAppliedDiscount>
  /** The available shipping rates for the draft order. Requires a customer with a valid shipping address and at least one line item. */
  availableShippingRates: Array<ShippingRate>
  /** Whether the billing address matches the shipping address. */
  billingAddressMatchesShippingAddress: Scalars["Boolean"]["output"]
  /** The currency of the store for this draft order. */
  currencyCode: CurrencyCode
  /** Customer who will be sent an invoice for the draft order, if there's one. */
  customer?: Maybe<Customer>
  /** Line items in the draft order with their computed properties. */
  lineItems: Array<CalculatedDraftOrderLineItem>
  /** A subtotal of the line items and corresponding discounts. The subtotal doesn't include shipping charges, shipping discounts, taxes, or order discounts. */
  lineItemsSubtotalPrice: MoneyBag
  /** The name of the selected market. */
  marketName: Scalars["String"]["output"]
  /** The selected country code that determines the pricing of the draft order. */
  marketRegionCountryCode: CountryCode
  /** Phone number assigned to draft order. */
  phone?: Maybe<Scalars["String"]["output"]>
  /** The payment currency of the customer for this draft order. */
  presentmentCurrencyCode: CurrencyCode
  /** The purchasing entity for the draft order. */
  purchasingEntity?: Maybe<PurchasingEntity>
  /** Line item that contains the shipping costs. */
  shippingLine?: Maybe<ShippingLine>
  /**
   * Subtotal of the line items and their discounts (doesn't contain shipping charges or shipping discounts, or taxes).
   *
   */
  subtotalPrice: Scalars["Money"]["output"]
  /** Subtotal of the line items and their discounts (doesn't contain shipping charges or shipping discounts, or taxes). */
  subtotalPriceSet: MoneyBag
  /** Total amount of taxes charged for each line item and shipping line. */
  taxLines: Array<TaxLine>
  /** Total discounts for this draft order. */
  totalDiscountsSet: MoneyBag
  /** Total price of line items for this draft order. */
  totalLineItemsPriceSet: MoneyBag
  /** Total amount of the draft order (includes taxes, shipping charges, and discounts). */
  totalPrice: Scalars["Money"]["output"]
  /** Total amount of the draft order(includes taxes, shipping charges, and discounts). */
  totalPriceSet: MoneyBag
  /** Total shipping charge for the draft order. */
  totalShippingPrice: Scalars["Money"]["output"]
  /** Total shipping charge for the draft order. */
  totalShippingPriceSet: MoneyBag
  /** Total amount of taxes for the draft order. */
  totalTax: Scalars["Money"]["output"]
  /** Total amount of taxes for the draft order. */
  totalTaxSet: MoneyBag
}

/** The computed line items for a draft order. */
export type CalculatedDraftOrderLineItem = {
  __typename?: "CalculatedDraftOrderLineItem"
  /** The discount applied to the line item. */
  appliedDiscount?: Maybe<DraftOrderAppliedDiscount>
  /** Whether the line item is a custom line item (`true`) or a product variant line item (`false`). */
  custom: Scalars["Boolean"]["output"]
  /** A list of attributes that represent custom features or special requests. */
  customAttributes: Array<Attribute>
  /** Additional information (metafields) about the line item with the associated types. */
  customAttributesV2: Array<TypedAttribute>
  /** Total price with discounts applied. */
  discountedTotal: MoneyV2
  /** The total price with discounts applied. */
  discountedTotalSet: MoneyBag
  /** The unit price with discounts applied. */
  discountedUnitPrice: MoneyV2
  /** Unit price with discounts applied. */
  discountedUnitPriceSet: MoneyBag
  /**
   * Name of the service provider who fulfilled the order.
   *
   * Valid values are either **manual** or the name of the provider.
   * For example, **amazon**, **shipwire**.
   *
   * Deleted fulfillment services will return null.
   *
   */
  fulfillmentService?: Maybe<FulfillmentService>
  /** The image associated with the draft order line item. */
  image?: Maybe<Image>
  /** Whether the line item represents the purchase of a gift card. */
  isGiftCard: Scalars["Boolean"]["output"]
  /** The name of the product. */
  name: Scalars["String"]["output"]
  /**
   * The total price (without discounts) of the line item, based on the original unit price of the variant x quantity.
   *
   */
  originalTotal: MoneyV2
  /** The total price (without discounts) of the line item, based on the original unit price of the variant x quantity. */
  originalTotalSet: MoneyBag
  /** The variant price without any discounts applied. */
  originalUnitPrice: MoneyV2
  /** The variant price without any discounts applied. */
  originalUnitPriceSet: MoneyBag
  /** The product associated with the draft order line item. */
  product?: Maybe<Product>
  /** The number of variant items requested in the draft order. */
  quantity: Scalars["Int"]["output"]
  /** Whether physical shipping is required for the variant. */
  requiresShipping: Scalars["Boolean"]["output"]
  /** The SKU number of the product variant. */
  sku?: Maybe<Scalars["String"]["output"]>
  /** Whether the variant is taxable. */
  taxable: Scalars["Boolean"]["output"]
  /** The title of the product or variant. This field only applies to custom line items. */
  title: Scalars["String"]["output"]
  /** The total value of the discount. */
  totalDiscount: MoneyV2
  /** The total value of the discount. */
  totalDiscountSet: MoneyBag
  /** The variant associated with the draft order line item. */
  variant?: Maybe<ProductVariant>
  /** The name of the variant. */
  variantTitle?: Maybe<Scalars["String"]["output"]>
  /** The name of the vendor who created the product variant. */
  vendor?: Maybe<Scalars["String"]["output"]>
  /** The weight unit and value for a draft order line item. */
  weight?: Maybe<Weight>
}

/**
 * A line item involved in order editing that may be newly added or have new changes applied.
 *
 */
export type CalculatedLineItem = {
  __typename?: "CalculatedLineItem"
  /** The discounts that have been allocated onto the line item by discount applications. */
  calculatedDiscountAllocations: Array<CalculatedDiscountAllocation>
  /** A list of attributes that represent custom features or special requests. */
  customAttributes: Array<Attribute>
  /**
   * The discounts that have been allocated onto the line item by discount applications.
   * @deprecated Use `calculatedDiscountAllocations` instead.
   */
  discountAllocations: Array<DiscountAllocation>
  /** The price of a single quantity of the line item with line item discounts applied, in shop and presentment currencies. Discounts applied to the entire order aren't included in this price. */
  discountedUnitPriceSet: MoneyBag
  /** The total number of items that can be edited. */
  editableQuantity: Scalars["Int"]["output"]
  /** The editable quantity prior to any changes made in the current edit. */
  editableQuantityBeforeChanges: Scalars["Int"]["output"]
  /** The total price of editable lines in shop and presentment currencies. */
  editableSubtotalSet: MoneyBag
  /** Whether the calculated line item has a staged discount. */
  hasStagedLineItemDiscount: Scalars["Boolean"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The image object associated to the line item's variant. */
  image?: Maybe<Image>
  /** The variant unit price in shop and presentment currencies, without any discounts applied. */
  originalUnitPriceSet: MoneyBag
  /** The total number of items. */
  quantity: Scalars["Int"]["output"]
  /** Whether the line item can be restocked or not. */
  restockable: Scalars["Boolean"]["output"]
  /** Whether the changes on the line item will result in a restock. */
  restocking: Scalars["Boolean"]["output"]
  /** The variant SKU number. */
  sku?: Maybe<Scalars["String"]["output"]>
  /** A list of changes that affect this line item. */
  stagedChanges: Array<OrderStagedChange>
  /** The title of the product. */
  title: Scalars["String"]["output"]
  /** The total price of uneditable lines in shop and presentment currencies. */
  uneditableSubtotalSet: MoneyBag
  /**
   * The product variant associated with this line item. The value is null for custom line items and items where
   * the variant has been deleted.
   *
   */
  variant?: Maybe<ProductVariant>
  /** The title of the variant. */
  variantTitle?: Maybe<Scalars["String"]["output"]>
}

/**
 * An auto-generated type for paginating through multiple CalculatedLineItems.
 *
 */
export type CalculatedLineItemConnection = {
  __typename?: "CalculatedLineItemConnection"
  /** A list of edges. */
  edges: Array<CalculatedLineItemEdge>
  /** A list of the nodes contained in CalculatedLineItemEdge. */
  nodes: Array<CalculatedLineItem>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one CalculatedLineItem and a cursor during pagination.
 *
 */
export type CalculatedLineItemEdge = {
  __typename?: "CalculatedLineItemEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CalculatedLineItemEdge. */
  node: CalculatedLineItem
}

/**
 * Represents a discount that was manually created for an order that is being edited.
 *
 */
export type CalculatedManualDiscountApplication = CalculatedDiscountApplication & {
  __typename?: "CalculatedManualDiscountApplication"
  /** The method by which the discount's value is allocated to its entitled items. */
  allocationMethod: DiscountApplicationAllocationMethod
  /** The level at which the discount was applied. */
  appliedTo: DiscountApplicationLevel
  /** The description of discount application. Indicates the reason why the discount was applied. */
  description?: Maybe<Scalars["String"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** How the discount amount is distributed on the discounted lines. */
  targetSelection: DiscountApplicationTargetSelection
  /** Whether the discount is applied on line items or shipping lines. */
  targetType: DiscountApplicationTargetType
  /** The value of the discount application. */
  value: PricingValue
}

/**
 * An order with edits applied but not saved.
 *
 */
export type CalculatedOrder = Node & {
  __typename?: "CalculatedOrder"
  /** Returns only the new discount applications being added to the order in the current edit. */
  addedDiscountApplications: CalculatedDiscountApplicationConnection
  /**
   * Returns only the new line items being added to the order during the current edit.
   *
   */
  addedLineItems: CalculatedLineItemConnection
  /** Amount of the order-level discount (doesn't contain any line item discounts) in shop and presentment currencies. */
  cartDiscountAmountSet?: Maybe<MoneyBag>
  /** Whether the changes have been applied and saved to the order. */
  committed: Scalars["Boolean"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /**
   * Returns all items on the order that existed before starting the edit.
   * Will include any changes that have been made.
   * Will not include line items added during the current edit.
   *
   */
  lineItems: CalculatedLineItemConnection
  /** The HTML of the customer notification for the order edit. */
  notificationPreviewHtml?: Maybe<Scalars["HTML"]["output"]>
  /** The customer notification title. */
  notificationPreviewTitle: Scalars["String"]["output"]
  /**
   * The order without any changes applied.
   * @deprecated Use `originalOrder` instead.
   */
  order: Order
  /**
   * The order without any changes applied.
   *
   */
  originalOrder: Order
  /**
   * List of changes made to the order during the current edit.
   *
   */
  stagedChanges: OrderStagedChangeConnection
  /** The sum of the quantities for the line items that contribute to the order's subtotal. */
  subtotalLineItemsQuantity: Scalars["Int"]["output"]
  /** The subtotal of the line items, in shop and presentment currencies, after all the discounts are applied.  The subtotal doesn't include shipping.  The subtotal includes taxes for taxes-included orders and excludes taxes for taxes-excluded orders. */
  subtotalPriceSet?: Maybe<MoneyBag>
  /** Taxes charged for the line item. */
  taxLines: Array<TaxLine>
  /** Total price of the order less the total amount received from the customer in shop and presentment currencies. */
  totalOutstandingSet: MoneyBag
  /** Total amount of the order (includes taxes and discounts) in shop and presentment currencies. */
  totalPriceSet: MoneyBag
}

/**
 * An order with edits applied but not saved.
 *
 */
export type CalculatedOrderAddedDiscountApplicationsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An order with edits applied but not saved.
 *
 */
export type CalculatedOrderAddedLineItemsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An order with edits applied but not saved.
 *
 */
export type CalculatedOrderLineItemsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An order with edits applied but not saved.
 *
 */
export type CalculatedOrderStagedChangesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * A discount created by a Shopify script for an order that is being edited.
 *
 */
export type CalculatedScriptDiscountApplication = CalculatedDiscountApplication & {
  __typename?: "CalculatedScriptDiscountApplication"
  /** The method by which the discount's value is allocated to its entitled items. */
  allocationMethod: DiscountApplicationAllocationMethod
  /** The level at which the discount was applied. */
  appliedTo: DiscountApplicationLevel
  /** The description of discount application. Indicates the reason why the discount was applied. */
  description?: Maybe<Scalars["String"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** How the discount amount is distributed on the discounted lines. */
  targetSelection: DiscountApplicationTargetSelection
  /** Whether the discount is applied on line items or shipping lines. */
  targetType: DiscountApplicationTargetType
  /** The value of the discount application. */
  value: PricingValue
}

/** Card payment details related to a transaction. */
export type CardPaymentDetails = BasePaymentDetails & {
  __typename?: "CardPaymentDetails"
  /** The response code from the address verification system (AVS). The code is always a single letter. */
  avsResultCode?: Maybe<Scalars["String"]["output"]>
  /** The issuer identification number (IIN), formerly known as bank identification number (BIN) of the customer's credit card. This is made up of the first few digits of the credit card number. */
  bin?: Maybe<Scalars["String"]["output"]>
  /** The name of the company that issued the customer's credit card. */
  company?: Maybe<Scalars["String"]["output"]>
  /** The response code from the credit card company indicating whether the customer entered the card security code, or card verification value, correctly. The code is a single letter or empty string. */
  cvvResultCode?: Maybe<Scalars["String"]["output"]>
  /** The month in which the used credit card expires. */
  expirationMonth?: Maybe<Scalars["Int"]["output"]>
  /** The year in which the used credit card expires. */
  expirationYear?: Maybe<Scalars["Int"]["output"]>
  /** The holder of the credit card. */
  name?: Maybe<Scalars["String"]["output"]>
  /** The customer's credit card number, with most of the leading digits redacted. */
  number?: Maybe<Scalars["String"]["output"]>
  /** The name of payment method used by the buyer. */
  paymentMethodName?: Maybe<Scalars["String"]["output"]>
  /** Digital wallet used for the payment. */
  wallet?: Maybe<DigitalWallet>
}

/**
 * A Cart Transform Function to create [Customized Bundles.](https://shopify.dev/docs/apps/selling-strategies/bundles/add-a-customized-bundle).
 *
 */
export type CartTransform = HasMetafields &
  Node & {
    __typename?: "CartTransform"
    /** Whether a run failure will block cart and checkout operations. */
    blockOnFailure: Scalars["Boolean"]["output"]
    /** The ID for the Cart Transform function. */
    functionId: Scalars["String"]["output"]
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
  }

/**
 * A Cart Transform Function to create [Customized Bundles.](https://shopify.dev/docs/apps/selling-strategies/bundles/add-a-customized-bundle).
 *
 */
export type CartTransformMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/**
 * A Cart Transform Function to create [Customized Bundles.](https://shopify.dev/docs/apps/selling-strategies/bundles/add-a-customized-bundle).
 *
 */
export type CartTransformMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * A Cart Transform Function to create [Customized Bundles.](https://shopify.dev/docs/apps/selling-strategies/bundles/add-a-customized-bundle).
 *
 */
export type CartTransformPrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/**
 * A Cart Transform Function to create [Customized Bundles.](https://shopify.dev/docs/apps/selling-strategies/bundles/add-a-customized-bundle).
 *
 */
export type CartTransformPrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple CartTransforms.
 *
 */
export type CartTransformConnection = {
  __typename?: "CartTransformConnection"
  /** A list of edges. */
  edges: Array<CartTransformEdge>
  /** A list of the nodes contained in CartTransformEdge. */
  nodes: Array<CartTransform>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `cartTransformCreate` mutation. */
export type CartTransformCreatePayload = {
  __typename?: "CartTransformCreatePayload"
  /** The newly created cart transform function. */
  cartTransform?: Maybe<CartTransform>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CartTransformCreateUserError>
}

/** An error that occurs during the execution of `CartTransformCreate`. */
export type CartTransformCreateUserError = DisplayableError & {
  __typename?: "CartTransformCreateUserError"
  /** The error code. */
  code?: Maybe<CartTransformCreateUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `CartTransformCreateUserError`. */
export enum CartTransformCreateUserErrorCode {
  /** A cart transform function already exists for the provided function_id. */
  FunctionAlreadyRegistered = "FUNCTION_ALREADY_REGISTERED",
  /** Function does not implement the required interface for this cart_transform function. */
  FunctionDoesNotImplement = "FUNCTION_DOES_NOT_IMPLEMENT",
  /** No Shopify Function found for provided function_id. */
  FunctionNotFound = "FUNCTION_NOT_FOUND",
  /** Failed to create cart transform due to invalid input. */
  InputInvalid = "INPUT_INVALID",
}

/** Return type for `cartTransformDelete` mutation. */
export type CartTransformDeletePayload = {
  __typename?: "CartTransformDeletePayload"
  /** The globally-unique ID for the deleted cart transform. */
  deletedId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CartTransformDeleteUserError>
}

/** An error that occurs during the execution of `CartTransformDelete`. */
export type CartTransformDeleteUserError = DisplayableError & {
  __typename?: "CartTransformDeleteUserError"
  /** The error code. */
  code?: Maybe<CartTransformDeleteUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `CartTransformDeleteUserError`. */
export enum CartTransformDeleteUserErrorCode {
  /** Could not find cart transform for provided id. */
  NotFound = "NOT_FOUND",
  /** Unauthorized app scope. */
  UnauthorizedAppScope = "UNAUTHORIZED_APP_SCOPE",
}

/**
 * An auto-generated type which holds one CartTransform and a cursor during pagination.
 *
 */
export type CartTransformEdge = {
  __typename?: "CartTransformEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CartTransformEdge. */
  node: CartTransform
}

/**
 * Represents the cart transform feature configuration for the shop.
 *
 */
export type CartTransformEligibleOperations = {
  __typename?: "CartTransformEligibleOperations"
  /** The shop is eligible for expand operations. */
  expandOperation: Scalars["Boolean"]["output"]
  /** The shop is eligible for merge operations. */
  mergeOperation: Scalars["Boolean"]["output"]
  /** The shop is eligible for update operations. */
  updateOperation: Scalars["Boolean"]["output"]
}

/**
 * Represents the cart transform feature configuration for the shop.
 *
 */
export type CartTransformFeature = {
  __typename?: "CartTransformFeature"
  /** The cart transform operations eligible for the shop. */
  eligibleOperations: CartTransformEligibleOperations
}

/**
 * A list of products with publishing and pricing information.
 * A catalog can be associated with a specific context, such as a [`Market`](https://shopify.dev/api/admin-graphql/current/objects/market), [`CompanyLocation`](https://shopify.dev/api/admin-graphql/current/objects/companylocation), or [`App`](https://shopify.dev/api/admin-graphql/current/objects/app).
 *
 */
export type Catalog = {
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** Most recent catalog operations. */
  operations: Array<ResourceOperation>
  /** The price list associated with the catalog. */
  priceList?: Maybe<PriceList>
  /** A group of products and collections that's published to a catalog. */
  publication?: Maybe<Publication>
  /** The status of the catalog. */
  status: CatalogStatus
  /** The name of the catalog. */
  title: Scalars["String"]["output"]
}

/**
 * An auto-generated type for paginating through multiple Catalogs.
 *
 */
export type CatalogConnection = {
  __typename?: "CatalogConnection"
  /** A list of edges. */
  edges: Array<CatalogEdge>
  /** A list of the nodes contained in CatalogEdge. */
  nodes: Array<Catalog>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
  /** The total count of Catalogs. */
  totalCount: Scalars["UnsignedInt64"]["output"]
}

/** The input fields for the context in which the catalog's publishing and pricing rules apply. */
export type CatalogContextInput = {
  /** The IDs of the company locations to associate to the catalog. */
  companyLocationIds?: InputMaybe<Array<Scalars["ID"]["input"]>>
}

/** Return type for `catalogContextUpdate` mutation. */
export type CatalogContextUpdatePayload = {
  __typename?: "CatalogContextUpdatePayload"
  /** The updated catalog. */
  catalog?: Maybe<Catalog>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CatalogUserError>
}

/** The input fields required to create a catalog. */
export type CatalogCreateInput = {
  /** The context associated with the catalog. */
  context: CatalogContextInput
  /** The ID of the price list to associate to the catalog. */
  priceListId?: InputMaybe<Scalars["ID"]["input"]>
  /** The ID of the publication to associate to the catalog. */
  publicationId?: InputMaybe<Scalars["ID"]["input"]>
  /** The status of the catalog. */
  status: CatalogStatus
  /** The name of the catalog. */
  title: Scalars["String"]["input"]
}

/** Return type for `catalogCreate` mutation. */
export type CatalogCreatePayload = {
  __typename?: "CatalogCreatePayload"
  /** The newly created catalog. */
  catalog?: Maybe<Catalog>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CatalogUserError>
}

/** A catalog csv operation represents a CSV file import. */
export type CatalogCsvOperation = Node &
  ResourceOperation & {
    __typename?: "CatalogCsvOperation"
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The count of processed rows, summing imported, failed, and skipped rows. */
    processedRowCount?: Maybe<Scalars["Int"]["output"]>
    /** Represents a rows objects within this background operation. */
    rowCount?: Maybe<RowCount>
    /** The status of this operation. */
    status: ResourceOperationStatus
  }

/** Return type for `catalogDelete` mutation. */
export type CatalogDeletePayload = {
  __typename?: "CatalogDeletePayload"
  /** The ID of the deleted catalog. */
  deletedId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CatalogUserError>
}

/**
 * An auto-generated type which holds one Catalog and a cursor during pagination.
 *
 */
export type CatalogEdge = {
  __typename?: "CatalogEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CatalogEdge. */
  node: Catalog
}

/** The set of valid sort keys for the Catalog query. */
export enum CatalogSortKeys {
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `title` value. */
  Title = "TITLE",
}

/**
 * The state of a catalog.
 *
 */
export enum CatalogStatus {
  /** The catalog is active. */
  Active = "ACTIVE",
  /** The catalog is archived. */
  Archived = "ARCHIVED",
  /** The catalog is in draft. */
  Draft = "DRAFT",
}

/**
 * The associated catalog's type.
 *
 */
export enum CatalogType {
  /** Catalogs belonging to apps. */
  App = "APP",
  /** Catalogs belonging to company locations. */
  CompanyLocation = "COMPANY_LOCATION",
  /** Catalogs belonging to markets. */
  Market = "MARKET",
  /** Not associated to a catalog. */
  None = "NONE",
}

/** The input fields used to update a catalog. */
export type CatalogUpdateInput = {
  /** The context associated with the catalog. */
  context?: InputMaybe<CatalogContextInput>
  /** The ID of the price list to associate to the catalog. */
  priceListId?: InputMaybe<Scalars["ID"]["input"]>
  /** The ID of the publication to associate to the catalog. */
  publicationId?: InputMaybe<Scalars["ID"]["input"]>
  /** The status of the catalog. */
  status?: InputMaybe<CatalogStatus>
  /** The name of the catalog. */
  title?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `catalogUpdate` mutation. */
export type CatalogUpdatePayload = {
  __typename?: "CatalogUpdatePayload"
  /** The updated catalog. */
  catalog?: Maybe<Catalog>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CatalogUserError>
}

/**
 * Defines errors encountered while managing a catalog.
 *
 */
export type CatalogUserError = DisplayableError & {
  __typename?: "CatalogUserError"
  /** The error code. */
  code?: Maybe<CatalogUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `CatalogUserError`. */
export enum CatalogUserErrorCode {
  /** An app catalog cannot be assigned to a price list. */
  AppCatalogPriceListAssignment = "APP_CATALOG_PRICE_LIST_ASSIGNMENT",
  /** The input value is blank. */
  Blank = "BLANK",
  /** The catalog can't be associated with more than one market. */
  CannotAddMoreThanOneMarket = "CANNOT_ADD_MORE_THAN_ONE_MARKET",
  /** Cannot create a catalog for an app. */
  CannotCreateAppCatalog = "CANNOT_CREATE_APP_CATALOG",
  /** Cannot create a catalog for a market. */
  CannotCreateMarketCatalog = "CANNOT_CREATE_MARKET_CATALOG",
  /** Cannot delete a catalog for an app. */
  CannotDeleteAppCatalog = "CANNOT_DELETE_APP_CATALOG",
  /** Cannot delete a catalog for a market. */
  CannotDeleteMarketCatalog = "CANNOT_DELETE_MARKET_CATALOG",
  /** Cannot modify a catalog for an app. */
  CannotModifyAppCatalog = "CANNOT_MODIFY_APP_CATALOG",
  /** Cannot modify a catalog for a market. */
  CannotModifyMarketCatalog = "CANNOT_MODIFY_MARKET_CATALOG",
  /** Quantity price breaks can be associated only with company location catalogs. */
  CatalogContextDoesNotSupportQuantityPriceBreaks = "CATALOG_CONTEXT_DOES_NOT_SUPPORT_QUANTITY_PRICE_BREAKS",
  /** Quantity rules can be associated only with company location catalogs. */
  CatalogContextDoesNotSupportQuantityRules = "CATALOG_CONTEXT_DOES_NOT_SUPPORT_QUANTITY_RULES",
  /** Catalog failed to save. */
  CatalogFailedToSave = "CATALOG_FAILED_TO_SAVE",
  /** The catalog wasn't found. */
  CatalogNotFound = "CATALOG_NOT_FOUND",
  /** A company location catalog outside of a supported plan can only have an archived status. */
  CompanyLocationCatalogStatusPlan = "COMPANY_LOCATION_CATALOG_STATUS_PLAN",
  /** The company location could not be found. */
  CompanyLocationNotFound = "COMPANY_LOCATION_NOT_FOUND",
  /** Context driver already assigned to this catalog. */
  ContextAlreadyAssignedToCatalog = "CONTEXT_ALREADY_ASSIGNED_TO_CATALOG",
  /** Cannot save the catalog because the catalog limit for the context was reached. */
  ContextCatalogLimitReached = "CONTEXT_CATALOG_LIMIT_REACHED",
  /** The arguments `contextsToAdd` and `contextsToRemove` must match existing catalog context type. */
  ContextDriverMismatch = "CONTEXT_DRIVER_MISMATCH",
  /** A country price list cannot be assigned to a catalog. */
  CountryPriceListAssignment = "COUNTRY_PRICE_LIST_ASSIGNMENT",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** The catalog context type is invalid. */
  InvalidCatalogContextType = "INVALID_CATALOG_CONTEXT_TYPE",
  /** The catalog's market and price list currencies do not match. */
  MarketAndPriceListCurrencyMismatch = "MARKET_AND_PRICE_LIST_CURRENCY_MISMATCH",
  /** A market catalog must have an active status. */
  MarketCatalogStatus = "MARKET_CATALOG_STATUS",
  /** Market not found. */
  MarketNotFound = "MARKET_NOT_FOUND",
  /** Market already belongs to another catalog. */
  MarketTaken = "MARKET_TAKEN",
  /** Must provide exactly one context type. */
  MustProvideExactlyOneContextType = "MUST_PROVIDE_EXACTLY_ONE_CONTEXT_TYPE",
  /** Price list failed to save. */
  PriceListFailedToSave = "PRICE_LIST_FAILED_TO_SAVE",
  /** The price list is currently being modified. Please try again later. */
  PriceListLocked = "PRICE_LIST_LOCKED",
  /** A price list cannot be assigned to the primary market. */
  PriceListNotAllowedForPrimaryMarket = "PRICE_LIST_NOT_ALLOWED_FOR_PRIMARY_MARKET",
  /** Price list not found. */
  PriceListNotFound = "PRICE_LIST_NOT_FOUND",
  /** Publication not found. */
  PublicationNotFound = "PUBLICATION_NOT_FOUND",
  /** Must have `contexts_to_add` or `contexts_to_remove` argument. */
  RequiresContextsToAddOrRemove = "REQUIRES_CONTEXTS_TO_ADD_OR_REMOVE",
  /** The input value is already taken. */
  Taken = "TAKEN",
  /** The input value is too long. */
  TooLong = "TOO_LONG",
  /** The input value is too short. */
  TooShort = "TOO_SHORT",
  /** Can't perform this action on a catalog of this type. */
  UnsupportedCatalogAction = "UNSUPPORTED_CATALOG_ACTION",
}

/**
 * A channel represents an app where you sell a group of products and collections.
 * A channel can be a platform or marketplace such as Facebook or Pinterest, an online store, or POS.
 *
 */
export type Channel = Node & {
  __typename?: "Channel"
  /** The underlying app used by the channel. */
  app: App
  /** The collection publications for the list of collections published to the channel. */
  collectionPublicationsV3: ResourcePublicationConnection
  /** The list of collections published to the channel. */
  collections: CollectionConnection
  /**
   * The unique identifier for the channel.
   * @deprecated Use `id` instead.
   */
  handle: Scalars["String"]["output"]
  /** Whether the collection is available to the channel. */
  hasCollection: Scalars["Boolean"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The name of the channel. */
  name: Scalars["String"]["output"]
  /**
   * The menu items for the channel, which also appear as submenu items in the left navigation sidebar in the Shopify admin.
   *
   * @deprecated Use [AppInstallation.navigationItems](
   *           https://shopify.dev/api/admin-graphql/current/objects/AppInstallation#field-appinstallation-navigationitems) instead.
   */
  navigationItems: Array<NavigationItem>
  /**
   * Home page for the channel.
   * @deprecated Use [AppInstallation.launchUrl](
   *           https://shopify.dev/api/admin-graphql/current/objects/AppInstallation#field-appinstallation-launchurl) instead.
   */
  overviewPath?: Maybe<Scalars["URL"]["output"]>
  /**
   * The product publications for the products published to the channel.
   * @deprecated Use `productPublicationsV3` instead.
   */
  productPublications: ProductPublicationConnection
  /** The product publications for the list of products published to the channel. */
  productPublicationsV3: ResourcePublicationConnection
  /** The list of products published to the channel. */
  products: ProductConnection
  /** Whether the channel supports future publishing. */
  supportsFuturePublishing: Scalars["Boolean"]["output"]
}

/**
 * A channel represents an app where you sell a group of products and collections.
 * A channel can be a platform or marketplace such as Facebook or Pinterest, an online store, or POS.
 *
 */
export type ChannelCollectionPublicationsV3Args = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * A channel represents an app where you sell a group of products and collections.
 * A channel can be a platform or marketplace such as Facebook or Pinterest, an online store, or POS.
 *
 */
export type ChannelCollectionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * A channel represents an app where you sell a group of products and collections.
 * A channel can be a platform or marketplace such as Facebook or Pinterest, an online store, or POS.
 *
 */
export type ChannelHasCollectionArgs = {
  id: Scalars["ID"]["input"]
}

/**
 * A channel represents an app where you sell a group of products and collections.
 * A channel can be a platform or marketplace such as Facebook or Pinterest, an online store, or POS.
 *
 */
export type ChannelProductPublicationsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * A channel represents an app where you sell a group of products and collections.
 * A channel can be a platform or marketplace such as Facebook or Pinterest, an online store, or POS.
 *
 */
export type ChannelProductPublicationsV3Args = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * A channel represents an app where you sell a group of products and collections.
 * A channel can be a platform or marketplace such as Facebook or Pinterest, an online store, or POS.
 *
 */
export type ChannelProductsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple Channels.
 *
 */
export type ChannelConnection = {
  __typename?: "ChannelConnection"
  /** A list of edges. */
  edges: Array<ChannelEdge>
  /** A list of the nodes contained in ChannelEdge. */
  nodes: Array<Channel>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * A channel definition represents channels surfaces on the platform.
 * A channel definition can be a platform or a subsegment of it such as Facebook Home, Instagram Live, Instagram Shops, or WhatsApp chat.
 *
 */
export type ChannelDefinition = Node & {
  __typename?: "ChannelDefinition"
  /** Name of the channel that this sub channel belongs to. */
  channelName: Scalars["String"]["output"]
  /** Unique string used as a public identifier for the channel definition. */
  handle: Scalars["String"]["output"]
  /** The unique ID for the channel definition. */
  id: Scalars["ID"]["output"]
  /** Whether this channel definition represents a marketplace. */
  isMarketplace: Scalars["Boolean"]["output"]
  /** Name of the sub channel (e.g. Online Store, Instagram Shopping, TikTok Live). */
  subChannelName: Scalars["String"]["output"]
  /** Icon displayed when showing the channel in admin. */
  svgIcon?: Maybe<Scalars["String"]["output"]>
}

/**
 * An auto-generated type which holds one Channel and a cursor during pagination.
 *
 */
export type ChannelEdge = {
  __typename?: "ChannelEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of ChannelEdge. */
  node: Channel
}

/**
 * Contains the information for a given sales channel.
 *
 */
export type ChannelInformation = Node & {
  __typename?: "ChannelInformation"
  /** The app associated with the channel. */
  app: App
  /** The channel definition associated with the channel. */
  channelDefinition?: Maybe<ChannelDefinition>
  /** The unique ID for the channel. */
  channelId: Scalars["ID"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
}

/**
 * The settings of checkout visual customizations.
 *
 * To learn more about updating checkout branding settings, refer to the
 * [checkoutBrandingUpsert](https://shopify.dev/api/admin-graphql/unstable/mutations/checkoutBrandingUpsert) mutation.
 *
 */
export type CheckoutBranding = {
  __typename?: "CheckoutBranding"
  /** The customizations that apply to specific components or areas of the user interface. */
  customizations?: Maybe<CheckoutBrandingCustomizations>
  /**
   * The design system allows you to set values that represent specific attributes
   * of your brand like color and font. These attributes are used throughout the user
   * interface. This brings consistency and allows you to easily make broad design changes.
   *
   */
  designSystem?: Maybe<CheckoutBrandingDesignSystem>
}

/** Possible values for the background style. */
export enum CheckoutBrandingBackgroundStyle {
  /** The None background style. */
  None = "NONE",
  /** The Solid background style. */
  Solid = "SOLID",
}

/** Possible values for the border. */
export enum CheckoutBrandingBorder {
  /** The Block End border. */
  BlockEnd = "BLOCK_END",
  /** The Full border. */
  Full = "FULL",
  /** The None border. */
  None = "NONE",
}

/** The buttons customizations. */
export type CheckoutBrandingButton = {
  __typename?: "CheckoutBrandingButton"
  /** The background style used for buttons. */
  background?: Maybe<CheckoutBrandingBackgroundStyle>
  /** The block padding used for buttons. */
  blockPadding?: Maybe<CheckoutBrandingSpacing>
  /** The border used for buttons. */
  border?: Maybe<CheckoutBrandingSimpleBorder>
  /** The corner radius used for buttons. */
  cornerRadius?: Maybe<CheckoutBrandingCornerRadius>
  /** The inline padding used for buttons. */
  inlinePadding?: Maybe<CheckoutBrandingSpacing>
  /** The typography used for buttons. */
  typography?: Maybe<CheckoutBrandingTypographyStyle>
}

/** Colors for buttons. */
export type CheckoutBrandingButtonColorRoles = {
  __typename?: "CheckoutBrandingButtonColorRoles"
  /** The color of accented objects (links and focused state). */
  accent?: Maybe<Scalars["String"]["output"]>
  /** The color of the background. */
  background?: Maybe<Scalars["String"]["output"]>
  /** The color of borders. */
  border?: Maybe<Scalars["String"]["output"]>
  /** The decorative color for highlighting specific parts of the user interface. */
  decorative?: Maybe<Scalars["String"]["output"]>
  /** The colors of the button on hover. */
  hover?: Maybe<CheckoutBrandingColorRoles>
  /** The color of icons. */
  icon?: Maybe<Scalars["String"]["output"]>
  /** The color of text. */
  text?: Maybe<Scalars["String"]["output"]>
}

/** The input fields to set colors for buttons. */
export type CheckoutBrandingButtonColorRolesInput = {
  /** The color of accented objects (links and focused state). */
  accent?: InputMaybe<Scalars["String"]["input"]>
  /** The color of the background. */
  background?: InputMaybe<Scalars["String"]["input"]>
  /** The color of borders. */
  border?: InputMaybe<Scalars["String"]["input"]>
  /** The decorative color for highlighting specific parts of the user interface. */
  decorative?: InputMaybe<Scalars["String"]["input"]>
  /** The colors of the button on hover. */
  hover?: InputMaybe<CheckoutBrandingColorRolesInput>
  /** The color of icons. */
  icon?: InputMaybe<Scalars["String"]["input"]>
  /** The color of text. */
  text?: InputMaybe<Scalars["String"]["input"]>
}

/** The input fields used to update the buttons customizations. */
export type CheckoutBrandingButtonInput = {
  /** The background style used for buttons. */
  background?: InputMaybe<CheckoutBrandingBackgroundStyle>
  /** The block padding used for buttons. */
  blockPadding?: InputMaybe<CheckoutBrandingSpacing>
  /** The border used for buttons. */
  border?: InputMaybe<CheckoutBrandingSimpleBorder>
  /** The corner radius used for buttons. */
  cornerRadius?: InputMaybe<CheckoutBrandingCornerRadius>
  /** The inline padding used for buttons. */
  inlinePadding?: InputMaybe<CheckoutBrandingSpacing>
  /** The typography style used for buttons. */
  typography?: InputMaybe<CheckoutBrandingTypographyStyleInput>
}

/** The checkboxes customizations. */
export type CheckoutBrandingCheckbox = {
  __typename?: "CheckoutBrandingCheckbox"
  /** The corner radius used for checkboxes. */
  cornerRadius?: Maybe<CheckoutBrandingCornerRadius>
}

/** The input fields used to update the checkboxes customizations. */
export type CheckoutBrandingCheckboxInput = {
  /** The corner radius used for checkboxes. */
  cornerRadius?: InputMaybe<CheckoutBrandingCornerRadius>
}

/** The choice list customizations. */
export type CheckoutBrandingChoiceList = {
  __typename?: "CheckoutBrandingChoiceList"
  /** The settings that apply to the 'group' variant of ChoiceList. */
  group?: Maybe<CheckoutBrandingChoiceListGroup>
}

/** The settings that apply to the 'group' variant of ChoiceList. */
export type CheckoutBrandingChoiceListGroup = {
  __typename?: "CheckoutBrandingChoiceListGroup"
  /** The spacing between UI elements in the list. */
  spacing?: Maybe<CheckoutBrandingSpacingKeyword>
}

/** The input fields to update the settings that apply to the 'group' variant of ChoiceList. */
export type CheckoutBrandingChoiceListGroupInput = {
  /** The spacing between UI elements in the list. */
  spacing?: InputMaybe<CheckoutBrandingSpacingKeyword>
}

/** The input fields to use to update the choice list customizations. */
export type CheckoutBrandingChoiceListInput = {
  /** The settings that apply to the 'group' variant of ChoiceList. */
  group?: InputMaybe<CheckoutBrandingChoiceListGroupInput>
}

/** A set of colors for customizing the overall look and feel of the checkout. */
export type CheckoutBrandingColorGlobal = {
  __typename?: "CheckoutBrandingColorGlobal"
  /** A color used for interaction, like links and focus states. */
  accent?: Maybe<Scalars["String"]["output"]>
  /**
   * A color strongly associated with the merchant, currently used for elements
   * like primary and secondary buttons.
   *
   */
  brand?: Maybe<Scalars["String"]["output"]>
  /** A semantic color used for components that communicate critical content. */
  critical?: Maybe<Scalars["String"]["output"]>
  /** A color used to highlight certain areas of the user interface. */
  decorative?: Maybe<Scalars["String"]["output"]>
  /** A semantic color used for components that communicate informative content. */
  info?: Maybe<Scalars["String"]["output"]>
  /** A semantic color used for components that communicate successful actions. */
  success?: Maybe<Scalars["String"]["output"]>
  /** A semantic color used for components that display content that requires attention. */
  warning?: Maybe<Scalars["String"]["output"]>
}

/** The input fields to customize the overall look and feel of the checkout. */
export type CheckoutBrandingColorGlobalInput = {
  /** A color used for interaction, like links and focus states. */
  accent?: InputMaybe<Scalars["String"]["input"]>
  /**
   * A color strongly associated with the merchant, currently used for elements
   * like primary and secondary buttons.
   *
   */
  brand?: InputMaybe<Scalars["String"]["input"]>
  /** A semantic color used for components that communicate critical content. */
  critical?: InputMaybe<Scalars["String"]["input"]>
  /** A color used to highlight certain areas of the user interface. */
  decorative?: InputMaybe<Scalars["String"]["input"]>
  /** A semantic color used for components that communicate informative content. */
  info?: InputMaybe<Scalars["String"]["input"]>
  /** A semantic color used for components that communicate successful actions. */
  success?: InputMaybe<Scalars["String"]["input"]>
  /** A semantic color used for components that display content that requires attention. */
  warning?: InputMaybe<Scalars["String"]["input"]>
}

/** A group of colors used together on a surface. */
export type CheckoutBrandingColorRoles = {
  __typename?: "CheckoutBrandingColorRoles"
  /** The color of accented objects (links and focused state). */
  accent?: Maybe<Scalars["String"]["output"]>
  /** The color of the background. */
  background?: Maybe<Scalars["String"]["output"]>
  /** The color of borders. */
  border?: Maybe<Scalars["String"]["output"]>
  /** The decorative color for highlighting specific parts of the user interface. */
  decorative?: Maybe<Scalars["String"]["output"]>
  /** The color of icons. */
  icon?: Maybe<Scalars["String"]["output"]>
  /** The color of text. */
  text?: Maybe<Scalars["String"]["output"]>
}

/** The input fields for a group of colors used together on a surface. */
export type CheckoutBrandingColorRolesInput = {
  /** The color of accented objects (links and focused state). */
  accent?: InputMaybe<Scalars["String"]["input"]>
  /** The color of the background. */
  background?: InputMaybe<Scalars["String"]["input"]>
  /** The color of borders. */
  border?: InputMaybe<Scalars["String"]["input"]>
  /** The decorative color for highlighting specific parts of the user interface. */
  decorative?: InputMaybe<Scalars["String"]["input"]>
  /** The color of icons. */
  icon?: InputMaybe<Scalars["String"]["input"]>
  /** The color of text. */
  text?: InputMaybe<Scalars["String"]["input"]>
}

/**
 * A base set of color customizations that is applied to an area of Checkout, from which every component
 * pulls its colors from.
 *
 */
export type CheckoutBrandingColorScheme = {
  __typename?: "CheckoutBrandingColorScheme"
  /** The main colors of a scheme. */
  base?: Maybe<CheckoutBrandingColorRoles>
  /** The colors of form controls. */
  control?: Maybe<CheckoutBrandingControlColorRoles>
  /** The colors of the primary button. */
  primaryButton?: Maybe<CheckoutBrandingButtonColorRoles>
  /** The colors of the secondary button. */
  secondaryButton?: Maybe<CheckoutBrandingButtonColorRoles>
}

/**
 * The input fields for a base set of color customizations that is applied to an area of Checkout, from which
 * every component pulls its colors from.
 *
 */
export type CheckoutBrandingColorSchemeInput = {
  /** The main colors of a scheme. */
  base?: InputMaybe<CheckoutBrandingColorRolesInput>
  /** The colors of form controls. */
  control?: InputMaybe<CheckoutBrandingControlColorRolesInput>
  /** The colors of the primary button. */
  primaryButton?: InputMaybe<CheckoutBrandingButtonColorRolesInput>
  /** The colors of the secondary button. */
  secondaryButton?: InputMaybe<CheckoutBrandingButtonColorRolesInput>
}

/** The possible color schemes. */
export enum CheckoutBrandingColorSchemeSelection {
  /** Color Scheme1 color scheme selection. */
  ColorScheme1 = "COLOR_SCHEME1",
  /** Color Scheme2 color scheme selection. */
  ColorScheme2 = "COLOR_SCHEME2",
  /** Transparent color scheme selection. */
  Transparent = "TRANSPARENT",
}

/** The color schemes. */
export type CheckoutBrandingColorSchemes = {
  __typename?: "CheckoutBrandingColorSchemes"
  /** The primary scheme. By default, it’s used for the main area of the interface. */
  scheme1?: Maybe<CheckoutBrandingColorScheme>
  /** The secondary scheme. By default, it’s used for secondary areas, like Checkout’s Order Summary. */
  scheme2?: Maybe<CheckoutBrandingColorScheme>
}

/** The input fields for the color schemes. */
export type CheckoutBrandingColorSchemesInput = {
  /** The primary scheme. By default, it’s used for the main area of the interface. */
  scheme1?: InputMaybe<CheckoutBrandingColorSchemeInput>
  /** The secondary scheme. By default, it’s used for secondary areas, like Checkout’s Order Summary. */
  scheme2?: InputMaybe<CheckoutBrandingColorSchemeInput>
}

/** The possible colors. */
export enum CheckoutBrandingColorSelection {
  /** Transparent color selection. */
  Transparent = "TRANSPARENT",
}

/** The color settings for global colors and color schemes. */
export type CheckoutBrandingColors = {
  __typename?: "CheckoutBrandingColors"
  /** A group of global colors for customizing the overall look and feel of the user interface. */
  global?: Maybe<CheckoutBrandingColorGlobal>
  /** A set of color schemes which apply to different areas of the user interface. */
  schemes?: Maybe<CheckoutBrandingColorSchemes>
}

/** The input fields used to update the color settings for global colors and color schemes. */
export type CheckoutBrandingColorsInput = {
  /**
   * The input to update global colors for customizing the overall look and feel of the user interface.
   *
   */
  global?: InputMaybe<CheckoutBrandingColorGlobalInput>
  /** The input to define color schemes which apply to different areas of the user interface. */
  schemes?: InputMaybe<CheckoutBrandingColorSchemesInput>
}

/** The form controls customizations. */
export type CheckoutBrandingControl = {
  __typename?: "CheckoutBrandingControl"
  /** The border used for form controls. */
  border?: Maybe<CheckoutBrandingSimpleBorder>
  /**
   * Set to TRANSPARENT to define transparent form controls. If null, form controls inherit colors from their scheme settings (for example, the main section inherits from `design_system.colors.schemes.scheme1.control` by default). Note that usage of the `customizations.control.color` setting to customize the form control color is deprecated.
   *
   */
  color?: Maybe<CheckoutBrandingColorSelection>
  /** The corner radius used for form controls. */
  cornerRadius?: Maybe<CheckoutBrandingCornerRadius>
  /** The label position used for form controls. */
  labelPosition?: Maybe<CheckoutBrandingLabelPosition>
}

/** Colors for form controls. */
export type CheckoutBrandingControlColorRoles = {
  __typename?: "CheckoutBrandingControlColorRoles"
  /** The color of accented objects (links and focused state). */
  accent?: Maybe<Scalars["String"]["output"]>
  /** The color of the background. */
  background?: Maybe<Scalars["String"]["output"]>
  /** The color of borders. */
  border?: Maybe<Scalars["String"]["output"]>
  /** The decorative color for highlighting specific parts of the user interface. */
  decorative?: Maybe<Scalars["String"]["output"]>
  /** The color of icons. */
  icon?: Maybe<Scalars["String"]["output"]>
  /** The colors of selected controls. */
  selected?: Maybe<CheckoutBrandingColorRoles>
  /** The color of text. */
  text?: Maybe<Scalars["String"]["output"]>
}

/** The input fields to define colors for form controls. */
export type CheckoutBrandingControlColorRolesInput = {
  /** The color of accented objects (links and focused state). */
  accent?: InputMaybe<Scalars["String"]["input"]>
  /** The color of the background. */
  background?: InputMaybe<Scalars["String"]["input"]>
  /** The color of borders. */
  border?: InputMaybe<Scalars["String"]["input"]>
  /** The decorative color for highlighting specific parts of the user interface. */
  decorative?: InputMaybe<Scalars["String"]["input"]>
  /** The color of icons. */
  icon?: InputMaybe<Scalars["String"]["input"]>
  /** The colors of selected controls. */
  selected?: InputMaybe<CheckoutBrandingColorRolesInput>
  /** The color of text. */
  text?: InputMaybe<Scalars["String"]["input"]>
}

/** The input fields used to update the form controls customizations. */
export type CheckoutBrandingControlInput = {
  /** The border used for form controls. */
  border?: InputMaybe<CheckoutBrandingSimpleBorder>
  /**
   * Set to TRANSPARENT to define transparent form controls. If null, form controls inherit colors from their scheme settings (for example, the main section inherits from `design_system.colors.schemes.scheme1.control` by default). Note that usage of the `customizations.control.color` setting to customize the form control color is deprecated.
   *
   */
  color?: InputMaybe<CheckoutBrandingColorSelection>
  /** The corner radius used for form controls. */
  cornerRadius?: InputMaybe<CheckoutBrandingCornerRadius>
  /** The label position used for form controls. */
  labelPosition?: InputMaybe<CheckoutBrandingLabelPosition>
}

/**
 * The options for customizing the corner radius of checkout-related objects. Examples include the primary
 * button, the name text fields and the sections within the main area (if they have borders).
 * Refer to this complete [list](https://shopify.dev/docs/api/admin-graphql/latest/enums/CheckoutBrandingCornerRadius#fieldswith)
 * for objects with customizable corner radii.
 *
 * The design system defines the corner radius pixel size for each option. Modify the defaults by setting the
 * [designSystem.cornerRadius](https://shopify.dev/docs/api/admin-graphql/latest/input-objects/CheckoutBrandingDesignSystemInput#field-checkoutbrandingdesignsysteminput-cornerradius)
 * input fields.
 *
 */
export enum CheckoutBrandingCornerRadius {
  /**
   * The corner radius with a pixel value defined by designSystem.cornerRadius.base.
   *
   */
  Base = "BASE",
  /**
   * The corner radius with a pixel value defined by designSystem.cornerRadius.large.
   *
   */
  Large = "LARGE",
  /** The 0px corner radius (square corners). */
  None = "NONE",
  /**
   * The corner radius with a pixel value defined by designSystem.cornerRadius.small.
   *
   */
  Small = "SMALL",
}

/**
 * Define the pixel size of corner radius options.
 *
 */
export type CheckoutBrandingCornerRadiusVariables = {
  __typename?: "CheckoutBrandingCornerRadiusVariables"
  /** The value in pixels for base corner radii. Example: 5. */
  base?: Maybe<Scalars["Int"]["output"]>
  /** The value in pixels for large corner radii. Example: 10. */
  large?: Maybe<Scalars["Int"]["output"]>
  /** The value in pixels for small corner radii. Example: 3. */
  small?: Maybe<Scalars["Int"]["output"]>
}

/** The input fields used to update the corner radius variables. */
export type CheckoutBrandingCornerRadiusVariablesInput = {
  /**
   * The value in pixels for base corner radii. It should be greater than zero. Example: 5.
   *
   */
  base?: InputMaybe<Scalars["Int"]["input"]>
  /**
   * The value in pixels for large corner radii. It should be greater than zero. Example: 10.
   *
   */
  large?: InputMaybe<Scalars["Int"]["input"]>
  /**
   * The value in pixels for small corner radii. It should be greater than zero. Example: 3.
   *
   */
  small?: InputMaybe<Scalars["Int"]["input"]>
}

/** A custom font. */
export type CheckoutBrandingCustomFont = CheckoutBrandingFont & {
  __typename?: "CheckoutBrandingCustomFont"
  /** Globally unique ID reference to the custom font file. */
  genericFileId?: Maybe<Scalars["ID"]["output"]>
  /** The font sources. */
  sources?: Maybe<Scalars["String"]["output"]>
  /** The font weight. */
  weight?: Maybe<Scalars["Int"]["output"]>
}

/** The input fields required to update a custom font group. */
export type CheckoutBrandingCustomFontGroupInput = {
  /** The base font. */
  base: CheckoutBrandingCustomFontInput
  /** The bold font. */
  bold: CheckoutBrandingCustomFontInput
  /** The font loading strategy. */
  loadingStrategy?: InputMaybe<CheckoutBrandingFontLoadingStrategy>
}

/** The input fields required to update a font. */
export type CheckoutBrandingCustomFontInput = {
  /**
   * A globally-unique ID for a font file uploaded via the Files api.
   * Allowed font types are .woff and .woff2.
   *
   */
  genericFileId: Scalars["ID"]["input"]
  /** The font weight. Its value should be between 100 and 900. */
  weight: Scalars["Int"]["input"]
}

/** The customizations that apply to specific components or areas of the user interface. */
export type CheckoutBrandingCustomizations = {
  __typename?: "CheckoutBrandingCustomizations"
  /** The checkboxes customizations. */
  checkbox?: Maybe<CheckoutBrandingCheckbox>
  /** The choice list customizations. */
  choiceList?: Maybe<CheckoutBrandingChoiceList>
  /** The form controls customizations. */
  control?: Maybe<CheckoutBrandingControl>
  /** The favicon image. */
  favicon?: Maybe<CheckoutBrandingImage>
  /** The global customizations. */
  global?: Maybe<CheckoutBrandingGlobal>
  /** The header customizations. */
  header?: Maybe<CheckoutBrandingHeader>
  /** The Heading Level 1 customizations. */
  headingLevel1?: Maybe<CheckoutBrandingHeadingLevel>
  /** The Heading Level 2 customizations. */
  headingLevel2?: Maybe<CheckoutBrandingHeadingLevel>
  /** The Heading Level 3 customizations. */
  headingLevel3?: Maybe<CheckoutBrandingHeadingLevel>
  /** The main area customizations. */
  main?: Maybe<CheckoutBrandingMain>
  /** The merchandise thumbnails customizations. */
  merchandiseThumbnail?: Maybe<CheckoutBrandingMerchandiseThumbnail>
  /** The order summary customizations. */
  orderSummary?: Maybe<CheckoutBrandingOrderSummary>
  /** The primary buttons customizations. */
  primaryButton?: Maybe<CheckoutBrandingButton>
  /** The secondary buttons customizations. */
  secondaryButton?: Maybe<CheckoutBrandingButton>
  /** The selects customizations. */
  select?: Maybe<CheckoutBrandingSelect>
  /** The text fields customizations. */
  textField?: Maybe<CheckoutBrandingTextField>
}

/** The input fields used to update the components customizations. */
export type CheckoutBrandingCustomizationsInput = {
  /** The checkboxes customizations. */
  checkbox?: InputMaybe<CheckoutBrandingCheckboxInput>
  /** The choice list customizations. */
  choiceList?: InputMaybe<CheckoutBrandingChoiceListInput>
  /** The form controls customizations. */
  control?: InputMaybe<CheckoutBrandingControlInput>
  /** The favicon image (must be of PNG format). */
  favicon?: InputMaybe<CheckoutBrandingImageInput>
  /** The global customizations. */
  global?: InputMaybe<CheckoutBrandingGlobalInput>
  /** The header customizations. */
  header?: InputMaybe<CheckoutBrandingHeaderInput>
  /** The Heading Level 1 customizations. */
  headingLevel1?: InputMaybe<CheckoutBrandingHeadingLevelInput>
  /** The Heading Level 2 customizations. */
  headingLevel2?: InputMaybe<CheckoutBrandingHeadingLevelInput>
  /** The Heading Level 3 customizations. */
  headingLevel3?: InputMaybe<CheckoutBrandingHeadingLevelInput>
  /** The main area customizations. */
  main?: InputMaybe<CheckoutBrandingMainInput>
  /** The merchandise thumbnails customizations. */
  merchandiseThumbnail?: InputMaybe<CheckoutBrandingMerchandiseThumbnailInput>
  /** The order summary customizations. */
  orderSummary?: InputMaybe<CheckoutBrandingOrderSummaryInput>
  /** The primary buttons customizations. */
  primaryButton?: InputMaybe<CheckoutBrandingButtonInput>
  /** The secondary buttons customizations. */
  secondaryButton?: InputMaybe<CheckoutBrandingButtonInput>
  /** The selects customizations. */
  select?: InputMaybe<CheckoutBrandingSelectInput>
  /** The text fields customizations. */
  textField?: InputMaybe<CheckoutBrandingTextFieldInput>
}

/**
 * The design system allows you to set values that represent specific attributes
 * of your brand like color and font. These attributes are used throughout the user
 * interface. This brings consistency and allows you to easily make broad design changes.
 *
 */
export type CheckoutBrandingDesignSystem = {
  __typename?: "CheckoutBrandingDesignSystem"
  /** The color settings for global colors and color schemes. */
  colors?: Maybe<CheckoutBrandingColors>
  /** The corner radius variables. */
  cornerRadius?: Maybe<CheckoutBrandingCornerRadiusVariables>
  /** The typography. */
  typography?: Maybe<CheckoutBrandingTypography>
}

/** The input fields used to update the design system. */
export type CheckoutBrandingDesignSystemInput = {
  /** The color settings for global colors and color schemes. */
  colors?: InputMaybe<CheckoutBrandingColorsInput>
  /** The corner radius variables. */
  cornerRadius?: InputMaybe<CheckoutBrandingCornerRadiusVariablesInput>
  /** The typography. */
  typography?: InputMaybe<CheckoutBrandingTypographyInput>
}

/** A font. */
export type CheckoutBrandingFont = {
  /** The font sources. */
  sources?: Maybe<Scalars["String"]["output"]>
  /** The font weight. */
  weight?: Maybe<Scalars["Int"]["output"]>
}

/**
 * A font group. To learn more about updating fonts, refer to the
 * [checkoutBrandingUpsert](https://shopify.dev/api/admin-graphql/unstable/mutations/checkoutBrandingUpsert)
 * mutation and the checkout branding [tutorial](https://shopify.dev/docs/apps/checkout/styling).
 *
 */
export type CheckoutBrandingFontGroup = {
  __typename?: "CheckoutBrandingFontGroup"
  /** The base font. */
  base?: Maybe<CheckoutBrandingFont>
  /** The bold font. */
  bold?: Maybe<CheckoutBrandingFont>
  /** The font loading strategy. */
  loadingStrategy?: Maybe<CheckoutBrandingFontLoadingStrategy>
  /** The font group name. */
  name?: Maybe<Scalars["String"]["output"]>
}

/**
 * The input fields used to update a font group. To learn more about updating fonts, refer to the
 * [checkoutBrandingUpsert](https://shopify.dev/api/admin-graphql/unstable/mutations/checkoutBrandingUpsert)
 * mutation and the checkout branding [tutorial](https://shopify.dev/docs/apps/checkout/styling).
 *
 */
export type CheckoutBrandingFontGroupInput = {
  /** A custom font group. */
  customFontGroup?: InputMaybe<CheckoutBrandingCustomFontGroupInput>
  /** A Shopify font group. */
  shopifyFontGroup?: InputMaybe<CheckoutBrandingShopifyFontGroupInput>
}

/**
 * The font loading strategy determines how a font face is displayed after it is loaded or failed to load.
 * For more information: https://developer.mozilla.org/en-US/docs/Web/CSS/@font-face/font-display.
 *
 */
export enum CheckoutBrandingFontLoadingStrategy {
  /** The font display strategy is defined by the browser user agent. */
  Auto = "AUTO",
  /** Gives the font face a short block period and an infinite swap period. */
  Block = "BLOCK",
  /** Gives the font face an extremely small block period and a short swap period. */
  Fallback = "FALLBACK",
  /** Gives the font face an extremely small block period and no swap period. */
  Optional = "OPTIONAL",
  /** Gives the font face an extremely small block period and an infinite swap period. */
  Swap = "SWAP",
}

/** The font size. */
export type CheckoutBrandingFontSize = {
  __typename?: "CheckoutBrandingFontSize"
  /** The base font size. */
  base?: Maybe<Scalars["Float"]["output"]>
  /** The scale ratio used to derive all font sizes such as small and large. */
  ratio?: Maybe<Scalars["Float"]["output"]>
}

/** The input fields used to update the font size. */
export type CheckoutBrandingFontSizeInput = {
  /** The base font size. Its value should be between 12.0 and 18.0. */
  base?: InputMaybe<Scalars["Float"]["input"]>
  /** The scale ratio used to derive all font sizes such as small and large. Its value should be between 1.0 and 1.4. */
  ratio?: InputMaybe<Scalars["Float"]["input"]>
}

/** The global customizations. */
export type CheckoutBrandingGlobal = {
  __typename?: "CheckoutBrandingGlobal"
  /**
   * The global corner radius setting that overrides all other [corner radius](https://shopify.dev/docs/api/admin-graphql/latest/enums/CheckoutBrandingCornerRadius)
   * customizations.
   *
   */
  cornerRadius?: Maybe<CheckoutBrandingGlobalCornerRadius>
  /** The global typography customizations. */
  typography?: Maybe<CheckoutBrandingTypographyStyleGlobal>
}

/**
 * Possible choices to override corner radius customizations on all applicable objects. Note that this selection
 * can only be used to set the override to `NONE` (0px).
 *
 * For more customizations options, set the [corner radius](https://shopify.dev/docs/api/admin-graphql/latest/enums/CheckoutBrandingCornerRadius)
 * selection on specific objects while leaving the global corner radius unset.
 *
 */
export enum CheckoutBrandingGlobalCornerRadius {
  /** Set the global corner radius override to 0px (square corners). */
  None = "NONE",
}

/** The input fields used to update the global customizations. */
export type CheckoutBrandingGlobalInput = {
  /**
   * Select a global corner radius setting that overrides all other [corner radii](https://shopify.dev/docs/api/admin-graphql/latest/enums/CheckoutBrandingCornerRadius)
   * customizations.
   *
   */
  cornerRadius?: InputMaybe<CheckoutBrandingGlobalCornerRadius>
  /** The global typography customizations. */
  typography?: InputMaybe<CheckoutBrandingTypographyStyleGlobalInput>
}

/** The header customizations. */
export type CheckoutBrandingHeader = {
  __typename?: "CheckoutBrandingHeader"
  /** The header alignment. */
  alignment?: Maybe<CheckoutBrandingHeaderAlignment>
  /** The background image of the header. */
  banner?: Maybe<CheckoutBrandingImage>
  /** The store logo. */
  logo?: Maybe<CheckoutBrandingLogo>
  /** The header position. */
  position?: Maybe<CheckoutBrandingHeaderPosition>
}

/** The possible header alignments. */
export enum CheckoutBrandingHeaderAlignment {
  /** Center alignment. */
  Center = "CENTER",
  /** End alignment. */
  End = "END",
  /** Start alignment. */
  Start = "START",
}

/** The input fields used to update the header customizations. */
export type CheckoutBrandingHeaderInput = {
  /** The header alignment. */
  alignment?: InputMaybe<CheckoutBrandingHeaderAlignment>
  /** The background image of the header (must not be of SVG format). */
  banner?: InputMaybe<CheckoutBrandingImageInput>
  /** The store logo. */
  logo?: InputMaybe<CheckoutBrandingLogoInput>
  /** The header position. */
  position?: InputMaybe<CheckoutBrandingHeaderPosition>
}

/** The possible header positions. */
export enum CheckoutBrandingHeaderPosition {
  /** Inline position. */
  Inline = "INLINE",
  /** Secondary inline position. */
  InlineSecondary = "INLINE_SECONDARY",
  /** Start position. */
  Start = "START",
}

/** The heading level customizations. */
export type CheckoutBrandingHeadingLevel = {
  __typename?: "CheckoutBrandingHeadingLevel"
  /** The typography customizations used for headings. */
  typography?: Maybe<CheckoutBrandingTypographyStyle>
}

/** The input fields for heading level customizations. */
export type CheckoutBrandingHeadingLevelInput = {
  /** The typography customizations used for headings. */
  typography?: InputMaybe<CheckoutBrandingTypographyStyleInput>
}

/** A checkout branding image. */
export type CheckoutBrandingImage = {
  __typename?: "CheckoutBrandingImage"
  /** The image details. */
  image?: Maybe<Image>
}

/** The input fields used to update a checkout branding image uploaded via the Files API. */
export type CheckoutBrandingImageInput = {
  /** A globally-unique ID. */
  mediaImageId?: InputMaybe<Scalars["ID"]["input"]>
}

/** The input fields used to upsert the checkout branding settings. */
export type CheckoutBrandingInput = {
  /** The customizations that apply to specific components or areas of the user interface. */
  customizations?: InputMaybe<CheckoutBrandingCustomizationsInput>
  /**
   * The design system allows you to set values that represent specific attributes
   * of your brand like color and font. These attributes are used throughout the user
   * interface. This brings consistency and allows you to easily make broad design changes.
   *
   */
  designSystem?: InputMaybe<CheckoutBrandingDesignSystemInput>
}

/** Possible values for the label position. */
export enum CheckoutBrandingLabelPosition {
  /** The Inside label position. */
  Inside = "INSIDE",
  /** The Outside label position. */
  Outside = "OUTSIDE",
}

/** The store logo customizations. */
export type CheckoutBrandingLogo = {
  __typename?: "CheckoutBrandingLogo"
  /** The logo image. */
  image?: Maybe<Image>
  /** The maximum width of the logo. */
  maxWidth?: Maybe<Scalars["Int"]["output"]>
}

/** The input fields used to update the logo customizations. */
export type CheckoutBrandingLogoInput = {
  /** The logo image (must not be of SVG format). */
  image?: InputMaybe<CheckoutBrandingImageInput>
  /** The maximum width of the logo. */
  maxWidth?: InputMaybe<Scalars["Int"]["input"]>
}

/** The main container customizations. */
export type CheckoutBrandingMain = {
  __typename?: "CheckoutBrandingMain"
  /** The background image of the main container. */
  backgroundImage?: Maybe<CheckoutBrandingImage>
  /** The selected color scheme of the main container. */
  colorScheme?: Maybe<CheckoutBrandingColorSchemeSelection>
}

/** The input fields used to update the main container customizations. */
export type CheckoutBrandingMainInput = {
  /** The background image of the main container (must not be of SVG format). */
  backgroundImage?: InputMaybe<CheckoutBrandingImageInput>
  /** The selected color scheme for the main container of the checkout. */
  colorScheme?: InputMaybe<CheckoutBrandingColorSchemeSelection>
}

/** The merchandise thumbnails customizations. */
export type CheckoutBrandingMerchandiseThumbnail = {
  __typename?: "CheckoutBrandingMerchandiseThumbnail"
  /** The border used for merchandise thumbnails. */
  border?: Maybe<CheckoutBrandingSimpleBorder>
  /** The corner radius used for merchandise thumbnails. */
  cornerRadius?: Maybe<CheckoutBrandingCornerRadius>
}

/** The input fields used to update the merchandise thumbnails customizations. */
export type CheckoutBrandingMerchandiseThumbnailInput = {
  /** The border used for merchandise thumbnails. */
  border?: InputMaybe<CheckoutBrandingSimpleBorder>
  /** The corner radius used for merchandise thumbnails. */
  cornerRadius?: InputMaybe<CheckoutBrandingCornerRadius>
}

/** The order summary customizations. */
export type CheckoutBrandingOrderSummary = {
  __typename?: "CheckoutBrandingOrderSummary"
  /** The background image of the order summary container. */
  backgroundImage?: Maybe<CheckoutBrandingImage>
  /** The selected color scheme of the order summary container. */
  colorScheme?: Maybe<CheckoutBrandingColorSchemeSelection>
}

/** The input fields used to update the order summary container customizations. */
export type CheckoutBrandingOrderSummaryInput = {
  /** The background image of the order summary container (must not be of SVG format). */
  backgroundImage?: InputMaybe<CheckoutBrandingImageInput>
  /** The selected color scheme for the order summary container of the checkout. */
  colorScheme?: InputMaybe<CheckoutBrandingColorSchemeSelection>
}

/** The selects customizations. */
export type CheckoutBrandingSelect = {
  __typename?: "CheckoutBrandingSelect"
  /** The border used for selects. */
  border?: Maybe<CheckoutBrandingBorder>
  /** The typography customizations used for selects. */
  typography?: Maybe<CheckoutBrandingTypographyStyle>
}

/** The input fields used to update the selects customizations. */
export type CheckoutBrandingSelectInput = {
  /** The border used for selects. */
  border?: InputMaybe<CheckoutBrandingBorder>
  /** The typography customizations used for selects. */
  typography?: InputMaybe<CheckoutBrandingTypographyStyleInput>
}

/** A Shopify font. */
export type CheckoutBrandingShopifyFont = CheckoutBrandingFont & {
  __typename?: "CheckoutBrandingShopifyFont"
  /** The font sources. */
  sources?: Maybe<Scalars["String"]["output"]>
  /** The font weight. */
  weight?: Maybe<Scalars["Int"]["output"]>
}

/** The input fields used to update a Shopify font group. */
export type CheckoutBrandingShopifyFontGroupInput = {
  /** The base font weight. */
  baseWeight?: InputMaybe<Scalars["Int"]["input"]>
  /** The bold font weight. */
  boldWeight?: InputMaybe<Scalars["Int"]["input"]>
  /** The font loading strategy. */
  loadingStrategy?: InputMaybe<CheckoutBrandingFontLoadingStrategy>
  /** The Shopify font name from [the list of available fonts](https://shopify.dev/themes/architecture/settings/fonts#available-fonts), such as `Alegreya Sans` or `Anonymous Pro`. */
  name: Scalars["String"]["input"]
}

/** Possible values for the simple border. */
export enum CheckoutBrandingSimpleBorder {
  /** The Full simple border. */
  Full = "FULL",
  /** The None simple border. */
  None = "NONE",
}

/** Possible values for the spacing. */
export enum CheckoutBrandingSpacing {
  /** The Base spacing. */
  Base = "BASE",
  /** The Extra Loose spacing. */
  ExtraLoose = "EXTRA_LOOSE",
  /** The Extra Tight spacing. */
  ExtraTight = "EXTRA_TIGHT",
  /** The Loose spacing. */
  Loose = "LOOSE",
  /** The None spacing. */
  None = "NONE",
  /** The Tight spacing. */
  Tight = "TIGHT",
}

/** The spacing between UI elements. */
export enum CheckoutBrandingSpacingKeyword {
  /** The Base spacing. */
  Base = "BASE",
  /** The Large spacing. */
  Large = "LARGE",
  /** The Large 100 spacing. */
  Large_100 = "LARGE_100",
  /** The Large 200 spacing. */
  Large_200 = "LARGE_200",
  /** The Large 300 spacing. */
  Large_300 = "LARGE_300",
  /** The Large 400 spacing. */
  Large_400 = "LARGE_400",
  /** The Large 500 spacing. */
  Large_500 = "LARGE_500",
  /** The None spacing. */
  None = "NONE",
  /** The Small spacing. */
  Small = "SMALL",
  /** The Small 100 spacing. */
  Small_100 = "SMALL_100",
  /** The Small 200 spacing. */
  Small_200 = "SMALL_200",
  /** The Small 300 spacing. */
  Small_300 = "SMALL_300",
  /** The Small 400 spacing. */
  Small_400 = "SMALL_400",
  /** The Small 500 spacing. */
  Small_500 = "SMALL_500",
}

/** The text fields customizations. */
export type CheckoutBrandingTextField = {
  __typename?: "CheckoutBrandingTextField"
  /** The border used for text fields. */
  border?: Maybe<CheckoutBrandingBorder>
  /** The typography customizations used for text fields. */
  typography?: Maybe<CheckoutBrandingTypographyStyle>
}

/** The input fields used to update the text fields customizations. */
export type CheckoutBrandingTextFieldInput = {
  /** The border used for text fields. */
  border?: InputMaybe<CheckoutBrandingBorder>
  /** The typography customizations used for text fields. */
  typography?: InputMaybe<CheckoutBrandingTypographyStyleInput>
}

/**
 * The typography settings used for checkout-related text. Use these settings to customize the
 * font family and size for primary and secondary text elements.
 *
 * Refer to the [typography tutorial](https://shopify.dev/docs/apps/checkout/styling/customize-typography)
 * for further information on typography customization.
 *
 */
export type CheckoutBrandingTypography = {
  __typename?: "CheckoutBrandingTypography"
  /** A font group used for most components such as text, buttons and form controls. */
  primary?: Maybe<CheckoutBrandingFontGroup>
  /** A font group used for heading components by default. */
  secondary?: Maybe<CheckoutBrandingFontGroup>
  /** The font size design system (base size in pixels and scaling between different sizes). */
  size?: Maybe<CheckoutBrandingFontSize>
}

/** The font selection. */
export enum CheckoutBrandingTypographyFont {
  /** The primary font. */
  Primary = "PRIMARY",
  /** The secondary font. */
  Secondary = "SECONDARY",
}

/**
 * The input fields used to update the typography. Refer to the [typography tutorial](https://shopify.dev/docs/apps/checkout/styling/customize-typography)
 * for more information on how to set these fields.
 *
 */
export type CheckoutBrandingTypographyInput = {
  /** A font group used for most components such as text, buttons and form controls. */
  primary?: InputMaybe<CheckoutBrandingFontGroupInput>
  /** A font group used for heading components by default. */
  secondary?: InputMaybe<CheckoutBrandingFontGroupInput>
  /** The font size. */
  size?: InputMaybe<CheckoutBrandingFontSizeInput>
}

/** Possible values for the typography kerning. */
export enum CheckoutBrandingTypographyKerning {
  /** Base or default kerning. */
  Base = "BASE",
  /** Extra loose kerning, leaving even more space in between characters. */
  ExtraLoose = "EXTRA_LOOSE",
  /** Loose kerning, leaving more space than the default in between characters. */
  Loose = "LOOSE",
}

/** Possible values for the typography letter case. */
export enum CheckoutBrandingTypographyLetterCase {
  /** All letters are is lower case. */
  Lower = "LOWER",
  /** No letter casing applied. */
  None = "NONE",
  /** Capitalize the first letter of each word. */
  Title = "TITLE",
  /** All letters are uppercase. */
  Upper = "UPPER",
}

/**
 * Possible choices for the font size.
 *
 * Note that the value in pixels of these settings can be customized with the
 * [typography size](https://shopify.dev/docs/api/admin-graphql/latest/input-objects/CheckoutBrandingFontSizeInput)
 * object. Refer to the [typography tutorial](https://shopify.dev/docs/apps/checkout/styling/customize-typography)
 * for more information.
 *
 */
export enum CheckoutBrandingTypographySize {
  /** The base font size. Example: 14px. */
  Base = "BASE",
  /** The extra extra large font size. Example: 24px. */
  ExtraExtraLarge = "EXTRA_EXTRA_LARGE",
  /** The extra large font size. Example: 21px. */
  ExtraLarge = "EXTRA_LARGE",
  /** The extra small font size. Example: 10px. */
  ExtraSmall = "EXTRA_SMALL",
  /** The large font size. Example: 17px. */
  Large = "LARGE",
  /** The medium font size. Example: 15px. */
  Medium = "MEDIUM",
  /** The small font size. Example: 12px. */
  Small = "SMALL",
}

/** The typography customizations. */
export type CheckoutBrandingTypographyStyle = {
  __typename?: "CheckoutBrandingTypographyStyle"
  /** The font. */
  font?: Maybe<CheckoutBrandingTypographyFont>
  /** The kerning. */
  kerning?: Maybe<CheckoutBrandingTypographyKerning>
  /** The letter case. */
  letterCase?: Maybe<CheckoutBrandingTypographyLetterCase>
  /** The font size. */
  size?: Maybe<CheckoutBrandingTypographySize>
  /** The font weight. */
  weight?: Maybe<CheckoutBrandingTypographyWeight>
}

/** The global typography customizations. */
export type CheckoutBrandingTypographyStyleGlobal = {
  __typename?: "CheckoutBrandingTypographyStyleGlobal"
  /** The kerning. */
  kerning?: Maybe<CheckoutBrandingTypographyKerning>
  /** The letter case. */
  letterCase?: Maybe<CheckoutBrandingTypographyLetterCase>
}

/** The input fields used to update the global typography customizations. */
export type CheckoutBrandingTypographyStyleGlobalInput = {
  /** The kerning. */
  kerning?: InputMaybe<CheckoutBrandingTypographyKerning>
  /** The letter case. */
  letterCase?: InputMaybe<CheckoutBrandingTypographyLetterCase>
}

/** The input fields used to update the typography customizations. */
export type CheckoutBrandingTypographyStyleInput = {
  /** The font. */
  font?: InputMaybe<CheckoutBrandingTypographyFont>
  /** The kerning. */
  kerning?: InputMaybe<CheckoutBrandingTypographyKerning>
  /** The letter case. */
  letterCase?: InputMaybe<CheckoutBrandingTypographyLetterCase>
  /** The font size. */
  size?: InputMaybe<CheckoutBrandingTypographySize>
  /** The font weight. */
  weight?: InputMaybe<CheckoutBrandingTypographyWeight>
}

/** Possible values for the font weight. */
export enum CheckoutBrandingTypographyWeight {
  /** The base weight. */
  Base = "BASE",
  /** The bold weight. */
  Bold = "BOLD",
}

/** Return type for `checkoutBrandingUpsert` mutation. */
export type CheckoutBrandingUpsertPayload = {
  __typename?: "CheckoutBrandingUpsertPayload"
  /** Returns the new checkout branding settings. */
  checkoutBranding?: Maybe<CheckoutBranding>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CheckoutBrandingUpsertUserError>
}

/** An error that occurs during the execution of `CheckoutBrandingUpsert`. */
export type CheckoutBrandingUpsertUserError = DisplayableError & {
  __typename?: "CheckoutBrandingUpsertUserError"
  /** The error code. */
  code?: Maybe<CheckoutBrandingUpsertUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `CheckoutBrandingUpsertUserError`. */
export enum CheckoutBrandingUpsertUserErrorCode {
  /** Unexpected internal error happened. */
  InternalError = "INTERNAL_ERROR",
}

/** A checkout profile defines the branding settings and the UI extensions for a store's checkout. A checkout profile could be published or draft. A store might have at most one published checkout profile, which is used to render their live checkout. The store could also have multiple draft profiles that were created, previewed, and published using the admin checkout editor. */
export type CheckoutProfile = Node & {
  __typename?: "CheckoutProfile"
  /** The date and time when the checkout profile was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** The date and time when the checkout profile was last edited. */
  editedAt: Scalars["DateTime"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** Whether the checkout profile is published or not. */
  isPublished: Scalars["Boolean"]["output"]
  /** The profile name. */
  name: Scalars["String"]["output"]
  /** The date and time when the checkout profile was last updated. */
  updatedAt: Scalars["DateTime"]["output"]
}

/**
 * An auto-generated type for paginating through multiple CheckoutProfiles.
 *
 */
export type CheckoutProfileConnection = {
  __typename?: "CheckoutProfileConnection"
  /** A list of edges. */
  edges: Array<CheckoutProfileEdge>
  /** A list of the nodes contained in CheckoutProfileEdge. */
  nodes: Array<CheckoutProfile>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one CheckoutProfile and a cursor during pagination.
 *
 */
export type CheckoutProfileEdge = {
  __typename?: "CheckoutProfileEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CheckoutProfileEdge. */
  node: CheckoutProfile
}

/** The set of valid sort keys for the CheckoutProfile query. */
export enum CheckoutProfileSortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `edited_at` value. */
  EditedAt = "EDITED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /** Sort by the `is_published` value. */
  IsPublished = "IS_PUBLISHED",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `updated_at` value. */
  UpdatedAt = "UPDATED_AT",
}

/** The set of valid sort keys for the CodeDiscount query. */
export enum CodeDiscountSortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `ends_at` value. */
  EndsAt = "ENDS_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `starts_at` value. */
  StartsAt = "STARTS_AT",
  /** Sort by the `title` value. */
  Title = "TITLE",
  /** Sort by the `updated_at` value. */
  UpdatedAt = "UPDATED_AT",
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type Collection = HasMetafieldDefinitions &
  HasMetafields &
  HasPublishedTranslations &
  Node &
  Publishable & {
    __typename?: "Collection"
    /** The number of publications a resource is published to without feedback errors. */
    availablePublicationCount: Scalars["Int"]["output"]
    /**
     * A single-line, text-only description of the collection, stripped of any HTML tags and formatting that were included in the description.
     *
     */
    description: Scalars["String"]["output"]
    /**
     * The description of the collection, including any HTML tags and formatting. This content is typically displayed to customers, such as on an online store, depending on the theme.
     *
     */
    descriptionHtml: Scalars["HTML"]["output"]
    /** Information about the collection that's provided through resource feedback. */
    feedback?: Maybe<ResourceFeedback>
    /**
     * A unique string that identifies the collection. If a handle isn't specified when a collection is created, it's automatically generated from the collection's original title, and typically includes words from the title separated by hyphens. For example, a collection that was created with the title `Summer Catalog 2022` might have the handle `summer-catalog-2022`.
     *
     * If the title is changed, the handle doesn't automatically change.
     *
     * The handle can be used in themes by the Liquid templating language to refer to the collection, but using the ID is preferred because it never changes.
     *
     */
    handle: Scalars["String"]["output"]
    /** Whether the collection includes the specified product. */
    hasProduct: Scalars["Boolean"]["output"]
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The image associated with the collection. */
    image?: Maybe<Image>
    /** The ID of the corresponding resource in the REST Admin API. */
    legacyResourceId: Scalars["UnsignedInt64"]["output"]
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafield definitions. */
    metafieldDefinitions: MetafieldDefinitionConnection
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
    /** The products that are included in the collection. */
    products: ProductConnection
    /** The number of products in the collection. */
    productsCount: Scalars["Int"]["output"]
    /** The number of publications a resource is published on. */
    publicationCount: Scalars["Int"]["output"]
    /**
     * The channels where the collection is published.
     * @deprecated Use `resourcePublications` instead.
     */
    publications: CollectionPublicationConnection
    /**
     * Check to see whether the resource is published to a given channel.
     * @deprecated Use `publishedOnPublication` instead.
     */
    publishedOnChannel: Scalars["Boolean"]["output"]
    /**
     * Check to see whether the resource is published to the calling app's channel.
     * @deprecated Use `publishedOnCurrentPublication` instead.
     */
    publishedOnCurrentChannel: Scalars["Boolean"]["output"]
    /** Check to see whether the resource is published to the calling app's publication. */
    publishedOnCurrentPublication: Scalars["Boolean"]["output"]
    /** Check to see whether the resource is published to a given publication. */
    publishedOnPublication: Scalars["Boolean"]["output"]
    /** The list of resources that are published to a publication. */
    resourcePublications: ResourcePublicationConnection
    /** The list of resources that are either published or staged to be published to a publication. */
    resourcePublicationsV2: ResourcePublicationV2Connection
    /**
     * For a smart (automated) collection, specifies the rules that determine whether a product is included.
     *
     */
    ruleSet?: Maybe<CollectionRuleSet>
    /**
     * If the default SEO fields for page title and description have been modified, contains the modified information.
     *
     */
    seo: Seo
    /**
     * The order in which the products in the collection are displayed by default in the Shopify admin and in sales channels, such as an online store.
     *
     */
    sortOrder: CollectionSortOrder
    /**
     * The Storefront GraphQL API ID of the `Collection`.
     *
     * As of the `2022-04` version release, the Storefront GraphQL API will no longer return Base64 encoded IDs to match the behavior of the Admin GraphQL API. Therefore, you can safely use the `id` field's value instead.
     *
     * @deprecated Use `id` instead.
     */
    storefrontId: Scalars["StorefrontID"]["output"]
    /**
     * The suffix of the Liquid template being used to show the collection in an online store. For example, if the value is `custom`, then the collection is using the `collection.custom.liquid` template. If the value is `null`, then the collection is using the default `collection.liquid` template.
     *
     */
    templateSuffix?: Maybe<Scalars["String"]["output"]>
    /**
     * The name of the collection. It's displayed in the Shopify admin and is typically displayed in sales channels, such as an online store.
     *
     */
    title: Scalars["String"]["output"]
    /** The translations associated with the resource. */
    translations: Array<Translation>
    /**
     * The list of channels that the resource is not published to.
     * @deprecated Use `unpublishedPublications` instead.
     */
    unpublishedChannels: ChannelConnection
    /** The list of publications that the resource is not published to. */
    unpublishedPublications: PublicationConnection
    /**
     * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) when the collection was last modified.
     *
     */
    updatedAt: Scalars["DateTime"]["output"]
  }

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionDescriptionArgs = {
  truncateAt?: InputMaybe<Scalars["Int"]["input"]>
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionHasProductArgs = {
  id: Scalars["ID"]["input"]
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionMetafieldDefinitionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  pinnedStatus?: InputMaybe<MetafieldDefinitionPinnedStatus>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<MetafieldDefinitionSortKeys>
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionPrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionPrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionProductsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<ProductCollectionSortKeys>
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionPublicationCountArgs = {
  onlyPublished?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionPublicationsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  onlyPublished?: InputMaybe<Scalars["Boolean"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionPublishedOnChannelArgs = {
  channelId: Scalars["ID"]["input"]
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionPublishedOnPublicationArgs = {
  publicationId: Scalars["ID"]["input"]
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionResourcePublicationsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  onlyPublished?: InputMaybe<Scalars["Boolean"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionResourcePublicationsV2Args = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  catalogType?: InputMaybe<CatalogType>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  onlyPublished?: InputMaybe<Scalars["Boolean"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionTranslationsArgs = {
  locale: Scalars["String"]["input"]
  marketId?: InputMaybe<Scalars["ID"]["input"]>
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionUnpublishedChannelsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents a group of products that can be displayed in online stores and other sales channels in categories, which makes it easy for customers to find them. For example, an athletics store might create different collections for running attire, shoes, and accessories.
 *
 * Collections can be defined by conditions, such as whether they match certain product tags. These are called smart or automated collections.
 *
 * Collections can also be created for a custom group of products. These are called custom or manual collections.
 *
 */
export type CollectionUnpublishedPublicationsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Return type for `collectionAddProducts` mutation. */
export type CollectionAddProductsPayload = {
  __typename?: "CollectionAddProductsPayload"
  /** The updated collection. Returns `null` if an error is raised. */
  collection?: Maybe<Collection>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `collectionAddProductsV2` mutation. */
export type CollectionAddProductsV2Payload = {
  __typename?: "CollectionAddProductsV2Payload"
  /** The asynchronous job adding the products. */
  job?: Maybe<Job>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CollectionAddProductsV2UserError>
}

/** An error that occurs during the execution of `CollectionAddProductsV2`. */
export type CollectionAddProductsV2UserError = DisplayableError & {
  __typename?: "CollectionAddProductsV2UserError"
  /** The error code. */
  code?: Maybe<CollectionAddProductsV2UserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `CollectionAddProductsV2UserError`. */
export enum CollectionAddProductsV2UserErrorCode {
  /** Can't manually add products to a smart collection. */
  CantAddToSmartCollection = "CANT_ADD_TO_SMART_COLLECTION",
  /** Collection doesn't exist. */
  CollectionDoesNotExist = "COLLECTION_DOES_NOT_EXIST",
}

/**
 * An auto-generated type for paginating through multiple Collections.
 *
 */
export type CollectionConnection = {
  __typename?: "CollectionConnection"
  /** A list of edges. */
  edges: Array<CollectionEdge>
  /** A list of the nodes contained in CollectionEdge. */
  nodes: Array<Collection>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `collectionCreate` mutation. */
export type CollectionCreatePayload = {
  __typename?: "CollectionCreatePayload"
  /** The collection that has been created. */
  collection?: Maybe<Collection>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The input fields for specifying the collection to delete. */
export type CollectionDeleteInput = {
  /** The ID of the collection to be deleted. */
  id: Scalars["ID"]["input"]
}

/** Return type for `collectionDelete` mutation. */
export type CollectionDeletePayload = {
  __typename?: "CollectionDeletePayload"
  /** The ID of the collection that was deleted. Returns `null` if the collection doesn't exist. */
  deletedCollectionId?: Maybe<Scalars["ID"]["output"]>
  /** The shop associated with the collection. */
  shop: Shop
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * An auto-generated type which holds one Collection and a cursor during pagination.
 *
 */
export type CollectionEdge = {
  __typename?: "CollectionEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CollectionEdge. */
  node: Collection
}

/** The input fields required to create a collection. */
export type CollectionInput = {
  /** The description of the collection, in HTML format. */
  descriptionHtml?: InputMaybe<Scalars["String"]["input"]>
  /**
   * A unique human-friendly string for the collection. Automatically generated from the collection's title.
   *
   */
  handle?: InputMaybe<Scalars["String"]["input"]>
  /**
   * Specifies the collection to update or create a new collection if absent. Required for updating a collection.
   *
   */
  id?: InputMaybe<Scalars["ID"]["input"]>
  /** The image associated with the collection. */
  image?: InputMaybe<ImageInput>
  /** The metafields to associate with the collection. */
  metafields?: InputMaybe<Array<MetafieldInput>>
  /** Initial list of collection products. Only valid with `collectionCreate` and without rules. */
  products?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /**
   * Indicates whether a redirect is required after a new handle has been provided.
   * If true, then the old handle is redirected to the new one automatically.
   *
   */
  redirectNewHandle?: InputMaybe<Scalars["Boolean"]["input"]>
  /**
   * The rules used to assign products to the collection.
   *
   */
  ruleSet?: InputMaybe<CollectionRuleSetInput>
  /** SEO information for the collection. */
  seo?: InputMaybe<SeoInput>
  /** The order in which the collection's products are sorted. */
  sortOrder?: InputMaybe<CollectionSortOrder>
  /** The theme template used when viewing the collection in a store. */
  templateSuffix?: InputMaybe<Scalars["String"]["input"]>
  /** The title of the collection. Required for creating a new collection. */
  title?: InputMaybe<Scalars["String"]["input"]>
}

/** Represents the publications where a collection is published. */
export type CollectionPublication = {
  __typename?: "CollectionPublication"
  /**
   * The channel where the collection will be published.
   * @deprecated Use `publication` instead.
   */
  channel: Channel
  /** The collection to be published on the publication. */
  collection: Collection
  /** Whether the publication is published or not. */
  isPublished: Scalars["Boolean"]["output"]
  /** The publication where the collection will be published. */
  publication: Publication
  /** The date that the publication was or is going to be published. */
  publishDate: Scalars["DateTime"]["output"]
}

/**
 * An auto-generated type for paginating through multiple CollectionPublications.
 *
 */
export type CollectionPublicationConnection = {
  __typename?: "CollectionPublicationConnection"
  /** A list of edges. */
  edges: Array<CollectionPublicationEdge>
  /** A list of the nodes contained in CollectionPublicationEdge. */
  nodes: Array<CollectionPublication>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one CollectionPublication and a cursor during pagination.
 *
 */
export type CollectionPublicationEdge = {
  __typename?: "CollectionPublicationEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CollectionPublicationEdge. */
  node: CollectionPublication
}

/** The input fields for publications to which a collection will be published. */
export type CollectionPublicationInput = {
  /** The ID of the publication. */
  publicationId?: InputMaybe<Scalars["ID"]["input"]>
}

/** The input fields for specifying a collection to publish and the sales channels to publish it to. */
export type CollectionPublishInput = {
  /** The channels where the collection will be published. */
  collectionPublications: Array<CollectionPublicationInput>
  /** The collection to create or update publications for. */
  id: Scalars["ID"]["input"]
}

/** Return type for `collectionPublish` mutation. */
export type CollectionPublishPayload = {
  __typename?: "CollectionPublishPayload"
  /** The published collection. */
  collection?: Maybe<Collection>
  /** The channels where the collection has been published. */
  collectionPublications?: Maybe<Array<CollectionPublication>>
  /** The shop associated with the collection. */
  shop: Shop
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `collectionRemoveProducts` mutation. */
export type CollectionRemoveProductsPayload = {
  __typename?: "CollectionRemoveProductsPayload"
  /** The asynchronous job removing the products. */
  job?: Maybe<Job>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `collectionReorderProducts` mutation. */
export type CollectionReorderProductsPayload = {
  __typename?: "CollectionReorderProductsPayload"
  /** The asynchronous job reordering the products. */
  job?: Maybe<Job>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Represents at rule that's used to assign products to a collection. */
export type CollectionRule = {
  __typename?: "CollectionRule"
  /** The attribute that the rule focuses on. For example, `title` or `product_type`. */
  column: CollectionRuleColumn
  /** The value that the operator is applied to. For example, `Hats`. */
  condition: Scalars["String"]["output"]
  /** The value that the operator is applied to. */
  conditionObject?: Maybe<CollectionRuleConditionObject>
  /**
   * The type of operator that the rule is based on. For example, `equals`, `contains`, or `not_equals`.
   *
   */
  relation: CollectionRuleRelation
}

/** Specifies the attribute of a product being used to populate the smart collection. */
export enum CollectionRuleColumn {
  /**
   * An attribute evaluated based on the `compare_at_price` attribute of the product's variants.
   * With `is_set` relation, the rule matches products with at least one variant with `compare_at_price` set.
   * With `is_not_set` relation, the rule matches matches products with at least one variant with `compare_at_price` not set.
   *
   */
  IsPriceReduced = "IS_PRICE_REDUCED",
  /**
   * This category includes metafield definitions that have the `useAsCollectionCondition` flag set to true.
   *
   */
  ProductMetafieldDefinition = "PRODUCT_METAFIELD_DEFINITION",
  /** The [`product_taxonomy_node_id`](https://shopify.dev/api/admin-graphql/latest/objects/Product#field-product-productcategory) attribute. */
  ProductTaxonomyNodeId = "PRODUCT_TAXONOMY_NODE_ID",
  /** The [`tag`](https://shopify.dev/api/admin-graphql/latest/objects/Product#field-product-producttype) attribute. */
  Tag = "TAG",
  /** The [`title`](https://shopify.dev/api/admin-graphql/latest/objects/Product#field-product-title) attribute. */
  Title = "TITLE",
  /** The [`type`](https://shopify.dev/api/admin-graphql/latest/objects/Product#field-product-producttype) attribute. */
  Type = "TYPE",
  /** The [`variant_compare_at_price`](https://shopify.dev/api/admin-graphql/latest/objects/ProductVariant#field-productvariant-compareatprice) attribute. */
  VariantCompareAtPrice = "VARIANT_COMPARE_AT_PRICE",
  /** The [`variant_inventory`](https://shopify.dev/api/admin-graphql/latest/objects/ProductVariant#field-productvariant-inventoryquantity) attribute. */
  VariantInventory = "VARIANT_INVENTORY",
  /**
   * This category includes metafield definitions that have the `useAsCollectionCondition` flag set to true.
   *
   */
  VariantMetafieldDefinition = "VARIANT_METAFIELD_DEFINITION",
  /** The [`variant_price`](https://shopify.dev/api/admin-graphql/latest/objects/ProductVariant#field-productvariant-price) attribute. */
  VariantPrice = "VARIANT_PRICE",
  /** The [`variant_title`](https://shopify.dev/api/admin-graphql/latest/objects/ProductVariant#field-productvariant-title) attribute. */
  VariantTitle = "VARIANT_TITLE",
  /** The [`variant_weight`](https://shopify.dev/api/admin-graphql/latest/objects/ProductVariant#field-productvariant-weight) attribute. */
  VariantWeight = "VARIANT_WEIGHT",
  /** The [`vendor`](https://shopify.dev/api/admin-graphql/latest/objects/Product#field-product-vendor) attribute. */
  Vendor = "VENDOR",
}

/** Specifies object for the condition of the rule. */
export type CollectionRuleConditionObject = CollectionRuleMetafieldCondition | CollectionRuleProductCategoryCondition | CollectionRuleTextCondition

/** This object defines all columns and allowed relations that can be used in rules for smart collections to automatically include the matching products. */
export type CollectionRuleConditions = {
  __typename?: "CollectionRuleConditions"
  /** Allowed relations of the rule. */
  allowedRelations: Array<CollectionRuleRelation>
  /** Most commonly used relation for this rule. */
  defaultRelation: CollectionRuleRelation
  /** Additional attributes defining the rule. */
  ruleObject?: Maybe<CollectionRuleConditionsRuleObject>
  /** Type of the rule. */
  ruleType: CollectionRuleColumn
}

/** Specifies object with additional rule attributes. */
export type CollectionRuleConditionsRuleObject = CollectionRuleMetafieldCondition

/** The input fields for a rule to associate with a collection. */
export type CollectionRuleInput = {
  /** The attribute that the rule focuses on. For example, `title` or `product_type`. */
  column: CollectionRuleColumn
  /** The value that the operator is applied to. For example, `Hats`. */
  condition: Scalars["String"]["input"]
  /**
   * The object ID that points to additional attributes for the collection rule.
   * This is only required when using metafield definition rules.
   *
   */
  conditionObjectId?: InputMaybe<Scalars["ID"]["input"]>
  /**
   * The type of operator that the rule is based on. For example, `equals`, `contains`, or `not_equals`.
   *
   */
  relation: CollectionRuleRelation
}

/** Identifies a metafield definition used as a rule for the smart collection. */
export type CollectionRuleMetafieldCondition = {
  __typename?: "CollectionRuleMetafieldCondition"
  /** The metafield definition associated with the condition. */
  metafieldDefinition: MetafieldDefinition
}

/** Specifies the condition for a Product Category field. */
export type CollectionRuleProductCategoryCondition = {
  __typename?: "CollectionRuleProductCategoryCondition"
  /** The value of the condition. */
  value: ProductTaxonomyNode
}

/** Specifies the relationship between the `column` and the `condition`. */
export enum CollectionRuleRelation {
  /** The attribute contains the condition. */
  Contains = "CONTAINS",
  /** The attribute ends with the condition. */
  EndsWith = "ENDS_WITH",
  /** The attribute is equal to the condition. */
  Equals = "EQUALS",
  /** The attribute is greater than the condition. */
  GreaterThan = "GREATER_THAN",
  /** The attribute is not set (equal to `null`). */
  IsNotSet = "IS_NOT_SET",
  /** The attribute is set (not equal to `null`). */
  IsSet = "IS_SET",
  /** The attribute is less than the condition. */
  LessThan = "LESS_THAN",
  /** The attribute does not contain the condition. */
  NotContains = "NOT_CONTAINS",
  /** The attribute does not equal the condition. */
  NotEquals = "NOT_EQUALS",
  /** The attribute starts with the condition. */
  StartsWith = "STARTS_WITH",
}

/** The set of rules that are used to determine which products are included in the collection. */
export type CollectionRuleSet = {
  __typename?: "CollectionRuleSet"
  /**
   * Whether products must match any or all of the rules to be included in the collection.
   * If true, then products must match at least one of the rules to be included in the collection.
   * If false, then products must match all of the rules to be included in the collection.
   *
   */
  appliedDisjunctively: Scalars["Boolean"]["output"]
  /** The rules used to assign products to the collection. */
  rules: Array<CollectionRule>
}

/** The input fields for a rule set of the collection. */
export type CollectionRuleSetInput = {
  /**
   * Whether products must match any or all of the rules to be included in the collection.
   * If true, then products must match at least one of the rules to be included in the collection.
   * If false, then products must match all of the rules to be included in the collection.
   *
   */
  appliedDisjunctively: Scalars["Boolean"]["input"]
  /** The rules used to assign products to the collection. */
  rules?: InputMaybe<Array<CollectionRuleInput>>
}

/** Specifies the condition for a text field. */
export type CollectionRuleTextCondition = {
  __typename?: "CollectionRuleTextCondition"
  /** The value of the condition. */
  value: Scalars["String"]["output"]
}

/** The set of valid sort keys for the Collection query. */
export enum CollectionSortKeys {
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `title` value. */
  Title = "TITLE",
  /** Sort by the `updated_at` value. */
  UpdatedAt = "UPDATED_AT",
}

/** Specifies the sort order for the products in the collection. */
export enum CollectionSortOrder {
  /** Alphabetically, in ascending order (A - Z). */
  AlphaAsc = "ALPHA_ASC",
  /** Alphabetically, in descending order (Z - A). */
  AlphaDesc = "ALPHA_DESC",
  /** By best-selling products. */
  BestSelling = "BEST_SELLING",
  /** By date created, in ascending order (oldest - newest). */
  Created = "CREATED",
  /** By date created, in descending order (newest - oldest). */
  CreatedDesc = "CREATED_DESC",
  /** In the order set manually by the merchant. */
  Manual = "MANUAL",
  /** By price, in ascending order (lowest - highest). */
  PriceAsc = "PRICE_ASC",
  /** By price, in descending order (highest - lowest). */
  PriceDesc = "PRICE_DESC",
}

/**
 * The input fields for specifying the collection to unpublish and the sales channels to remove it from.
 *
 */
export type CollectionUnpublishInput = {
  /** The channels where the collection is published. */
  collectionPublications: Array<CollectionPublicationInput>
  /** The collection to create or update publications for. */
  id: Scalars["ID"]["input"]
}

/** Return type for `collectionUnpublish` mutation. */
export type CollectionUnpublishPayload = {
  __typename?: "CollectionUnpublishPayload"
  /** The collection that has been unpublished. */
  collection?: Maybe<Collection>
  /** The shop associated with the collection. */
  shop: Shop
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `collectionUpdate` mutation. */
export type CollectionUpdatePayload = {
  __typename?: "CollectionUpdatePayload"
  /** The updated collection. */
  collection?: Maybe<Collection>
  /** The asynchronous job updating the products based on the new rule set. */
  job?: Maybe<Job>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * Comment events are generated by staff members of a shop.
 * They are created when a staff member adds a comment to the timeline of an order, draft order, customer, or transfer.
 *
 */
export type CommentEvent = Event &
  Node & {
    __typename?: "CommentEvent"
    /** The name of the app that created the event. */
    appTitle?: Maybe<Scalars["String"]["output"]>
    /** The attachments associated with the comment event. */
    attachments: Array<CommentEventAttachment>
    /** Whether the event was created by an app. */
    attributeToApp: Scalars["Boolean"]["output"]
    /** Whether the event was caused by an admin user. */
    attributeToUser: Scalars["Boolean"]["output"]
    /** The name of the user that authored the comment event. */
    author: StaffMember
    /** Whether the comment event can be deleted. If true, then the comment event can be deleted. */
    canDelete: Scalars["Boolean"]["output"]
    /** Whether the comment event can be edited. If true, then the comment event can be edited. */
    canEdit: Scalars["Boolean"]["output"]
    /** The date and time when the event was created. */
    createdAt: Scalars["DateTime"]["output"]
    /** Whether the event is critical. */
    criticalAlert: Scalars["Boolean"]["output"]
    /** Whether the comment event has been edited. If true, then the comment event has been edited. */
    edited: Scalars["Boolean"]["output"]
    /** The object reference associated with the comment event. For example, a product or discount). */
    embed?: Maybe<CommentEventEmbed>
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** Human readable text that describes the event. */
    message: Scalars["FormattedString"]["output"]
    /** The raw body of the comment event. */
    rawMessage: Scalars["String"]["output"]
    /** The parent subject to which the comment event belongs. */
    subject: CommentEventSubject
  }

/** A file attachment associated to a comment event. */
export type CommentEventAttachment = {
  __typename?: "CommentEventAttachment"
  /** The file extension of the comment event attachment, indicating the file format. */
  fileExtension?: Maybe<Scalars["String"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The image attached to the comment event. */
  image?: Maybe<Image>
  /** The filename of the comment event attachment. */
  name: Scalars["String"]["output"]
  /** The size of the attachment. */
  size: Scalars["Int"]["output"]
  /** The URL of the attachment. */
  url: Scalars["URL"]["output"]
}

/** The main embed of a comment event. */
export type CommentEventEmbed = Customer | DraftOrder | Order | Product | ProductVariant

/** The subject line of a comment event. */
export type CommentEventSubject = {
  /** Whether the timeline subject has a timeline comment. If true, then a timeline comment exists. */
  hasTimelineComment: Scalars["Boolean"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
}

/** Return type for `companiesDelete` mutation. */
export type CompaniesDeletePayload = {
  __typename?: "CompaniesDeletePayload"
  /** A list of IDs of the deleted companies. */
  deletedCompanyIds?: Maybe<Array<Scalars["ID"]["output"]>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Represents information about a company which is also a customer of the shop. */
export type Company = CommentEventSubject &
  HasEvents &
  HasMetafieldDefinitions &
  HasMetafields &
  Navigable &
  Node & {
    __typename?: "Company"
    /** The number of contacts that belong to the company. */
    contactCount: Scalars["Int"]["output"]
    /** The list of roles for the company contacts. */
    contactRoles: CompanyContactRoleConnection
    /** The list of contacts in the company. */
    contacts: CompanyContactConnection
    /** The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company was created in Shopify. */
    createdAt: Scalars["DateTime"]["output"]
    /** The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company became the customer. */
    customerSince: Scalars["DateTime"]["output"]
    /**
     * A default cursor that returns the single next record, sorted ascending by ID.
     *
     */
    defaultCursor: Scalars["String"]["output"]
    /** The role proposed by default for a contact at the company. */
    defaultRole?: Maybe<CompanyContactRole>
    /** The list of the company's draft orders. */
    draftOrders: DraftOrderConnection
    /** The paginated list of events associated with the host subject. */
    events: EventConnection
    /** A unique externally-supplied ID for the company. */
    externalId?: Maybe<Scalars["String"]["output"]>
    /** Whether the merchant added a timeline comment to the company. */
    hasTimelineComment: Scalars["Boolean"]["output"]
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The lifetime duration of the company, since it became a customer of the shop. Examples: `2 days`, `3 months`, `1 year`. */
    lifetimeDuration: Scalars["String"]["output"]
    /** The number of locations that belong to the company. */
    locationCount: Scalars["Int"]["output"]
    /** The list of locations in the company. */
    locations: CompanyLocationConnection
    /** The main contact for the company. */
    mainContact?: Maybe<CompanyContact>
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafield definitions. */
    metafieldDefinitions: MetafieldDefinitionConnection
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /** The name of the company. */
    name: Scalars["String"]["output"]
    /** A note about the company. */
    note?: Maybe<Scalars["String"]["output"]>
    /** The total number of orders placed for this company, across all its locations. */
    orderCount: Scalars["Int"]["output"]
    /** The list of the company's orders. */
    orders: OrderConnection
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
    /** The total amount spent by this company, across all its locations. */
    totalSpent: MoneyV2
    /** The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company was last modified. */
    updatedAt: Scalars["DateTime"]["output"]
  }

/** Represents information about a company which is also a customer of the shop. */
export type CompanyContactRolesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<CompanyContactRoleSortKeys>
}

/** Represents information about a company which is also a customer of the shop. */
export type CompanyContactsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<CompanyContactSortKeys>
}

/** Represents information about a company which is also a customer of the shop. */
export type CompanyDraftOrdersArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<DraftOrderSortKeys>
}

/** Represents information about a company which is also a customer of the shop. */
export type CompanyEventsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<EventSortKeys>
}

/** Represents information about a company which is also a customer of the shop. */
export type CompanyLocationsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<CompanyLocationSortKeys>
}

/** Represents information about a company which is also a customer of the shop. */
export type CompanyMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/** Represents information about a company which is also a customer of the shop. */
export type CompanyMetafieldDefinitionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  pinnedStatus?: InputMaybe<MetafieldDefinitionPinnedStatus>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<MetafieldDefinitionSortKeys>
}

/** Represents information about a company which is also a customer of the shop. */
export type CompanyMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Represents information about a company which is also a customer of the shop. */
export type CompanyOrdersArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<OrderSortKeys>
}

/** Represents information about a company which is also a customer of the shop. */
export type CompanyPrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/** Represents information about a company which is also a customer of the shop. */
export type CompanyPrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Represents a billing or shipping address for a company location. */
export type CompanyAddress = Node & {
  __typename?: "CompanyAddress"
  /** The first line of the address. Typically the street address or PO Box number. */
  address1: Scalars["String"]["output"]
  /** The second line of the address. Typically the number of the apartment, suite, or unit. */
  address2?: Maybe<Scalars["String"]["output"]>
  /** The name of the city, district, village, or town. */
  city?: Maybe<Scalars["String"]["output"]>
  /** The name of the company. */
  companyName: Scalars["String"]["output"]
  /** The name of the country. */
  country?: Maybe<Scalars["String"]["output"]>
  /**
   * The two-letter code for the country of the address.
   * For example, US.
   *
   */
  countryCode: CountryCode
  /**
   * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company address was created.
   *
   */
  createdAt: Scalars["DateTime"]["output"]
  /** The first name of the recipient. */
  firstName?: Maybe<Scalars["String"]["output"]>
  /** The formatted version of the address. */
  formattedAddress: Array<Scalars["String"]["output"]>
  /** A comma-separated list of the values for city, province, and country. */
  formattedArea?: Maybe<Scalars["String"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The last name of the recipient. */
  lastName?: Maybe<Scalars["String"]["output"]>
  /**
   * A unique phone number for the customer.
   * Formatted using E.164 standard. For example, _+16135551111_.
   *
   */
  phone?: Maybe<Scalars["String"]["output"]>
  /** The region of the address, such as the province, state, or district. */
  province?: Maybe<Scalars["String"]["output"]>
  /** The identity of the recipient e.g. 'Receiving Department'. */
  recipient?: Maybe<Scalars["String"]["output"]>
  /**
   * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company address was last updated.
   *
   */
  updatedAt: Scalars["DateTime"]["output"]
  /** The zip or postal code of the address. */
  zip?: Maybe<Scalars["String"]["output"]>
  /**
   * The two-letter code for the region.
   * For example, ON.
   *
   */
  zoneCode?: Maybe<Scalars["String"]["output"]>
}

/** Represents a billing or shipping address for a company location. */
export type CompanyAddressFormattedAddressArgs = {
  withCompanyName?: InputMaybe<Scalars["Boolean"]["input"]>
  withName?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Return type for `companyAddressDelete` mutation. */
export type CompanyAddressDeletePayload = {
  __typename?: "CompanyAddressDeletePayload"
  /** The ID of the deleted address. */
  deletedAddressId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** The input fields to create or update the address of a company location. */
export type CompanyAddressInput = {
  /** The first line of the address. Typically the street address or PO Box number. */
  address1?: InputMaybe<Scalars["String"]["input"]>
  /** The second line of the address. Typically the number of the apartment, suite, or unit. */
  address2?: InputMaybe<Scalars["String"]["input"]>
  /** The name of the city, district, village, or town. */
  city?: InputMaybe<Scalars["String"]["input"]>
  /** The two-letter code ([ISO 3166-1 alpha-2]](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format) for the country of the address. For example, `US`` for the United States. */
  countryCode?: InputMaybe<CountryCode>
  /** The first name of the recipient. */
  firstName?: InputMaybe<Scalars["String"]["input"]>
  /** The last name of the recipient. */
  lastName?: InputMaybe<Scalars["String"]["input"]>
  /** A phone number for the recipient. Formatted using E.164 standard. For example, _+16135551111_. */
  phone?: InputMaybe<Scalars["String"]["input"]>
  /** The identity of the recipient e.g. 'Receiving Department'. */
  recipient?: InputMaybe<Scalars["String"]["input"]>
  /** The zip or postal code of the address. */
  zip?: InputMaybe<Scalars["String"]["input"]>
  /** The two-letter code ([ISO 3166-2 alpha-2]](https://en.wikipedia.org/wiki/ISO_3166-2) format) for the region of the address, such as the province, state, or district. For example, `ON` for Ontario, Canada. */
  zoneCode?: InputMaybe<Scalars["String"]["input"]>
}

/** The valid values for the address type of a company. */
export enum CompanyAddressType {
  /** The address is a billing address. */
  Billing = "BILLING",
  /** The address is a shipping address. */
  Shipping = "SHIPPING",
}

/** Return type for `companyAssignCustomerAsContact` mutation. */
export type CompanyAssignCustomerAsContactPayload = {
  __typename?: "CompanyAssignCustomerAsContactPayload"
  /** The created company contact. */
  companyContact?: Maybe<CompanyContact>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyAssignMainContact` mutation. */
export type CompanyAssignMainContactPayload = {
  __typename?: "CompanyAssignMainContactPayload"
  /** The company for which the main contact is assigned. */
  company?: Maybe<Company>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/**
 * An auto-generated type for paginating through multiple Companies.
 *
 */
export type CompanyConnection = {
  __typename?: "CompanyConnection"
  /** A list of edges. */
  edges: Array<CompanyEdge>
  /** A list of the nodes contained in CompanyEdge. */
  nodes: Array<Company>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** A person that acts on behalf of company associated to [a customer](https://shopify.dev/api/admin-graphql/latest/objects/customer). */
export type CompanyContact = Node & {
  __typename?: "CompanyContact"
  /** The company to which the contact belongs. */
  company: Company
  /** The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company contact was created at Shopify. */
  createdAt: Scalars["DateTime"]["output"]
  /** The customer associated to this contact. */
  customer: Customer
  /** The list of draft orders for the company contact. */
  draftOrders: DraftOrderConnection
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** Whether the contact is the main contact of the company. */
  isMainContact: Scalars["Boolean"]["output"]
  /** The lifetime duration of the company contact, since its creation date on Shopify. Examples: `1 year`, `2 months`, `3 days`. */
  lifetimeDuration: Scalars["String"]["output"]
  /** The company contact's locale (language). */
  locale?: Maybe<Scalars["String"]["output"]>
  /** The list of orders for the company contact. */
  orders: OrderConnection
  /** The list of roles assigned to this company contact. */
  roleAssignments: CompanyContactRoleAssignmentConnection
  /** The company contact's job title. */
  title?: Maybe<Scalars["String"]["output"]>
  /** The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company contact was last updated. */
  updatedAt: Scalars["DateTime"]["output"]
}

/** A person that acts on behalf of company associated to [a customer](https://shopify.dev/api/admin-graphql/latest/objects/customer). */
export type CompanyContactDraftOrdersArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<DraftOrderSortKeys>
}

/** A person that acts on behalf of company associated to [a customer](https://shopify.dev/api/admin-graphql/latest/objects/customer). */
export type CompanyContactOrdersArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<OrderSortKeys>
}

/** A person that acts on behalf of company associated to [a customer](https://shopify.dev/api/admin-graphql/latest/objects/customer). */
export type CompanyContactRoleAssignmentsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<CompanyContactRoleAssignmentSortKeys>
}

/** Return type for `companyContactAssignRole` mutation. */
export type CompanyContactAssignRolePayload = {
  __typename?: "CompanyContactAssignRolePayload"
  /** The company contact role assignment. */
  companyContactRoleAssignment?: Maybe<CompanyContactRoleAssignment>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyContactAssignRoles` mutation. */
export type CompanyContactAssignRolesPayload = {
  __typename?: "CompanyContactAssignRolesPayload"
  /** A list of newly created assignments of company contacts to a company location. */
  roleAssignments?: Maybe<Array<CompanyContactRoleAssignment>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/**
 * An auto-generated type for paginating through multiple CompanyContacts.
 *
 */
export type CompanyContactConnection = {
  __typename?: "CompanyContactConnection"
  /** A list of edges. */
  edges: Array<CompanyContactEdge>
  /** A list of the nodes contained in CompanyContactEdge. */
  nodes: Array<CompanyContact>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `companyContactCreate` mutation. */
export type CompanyContactCreatePayload = {
  __typename?: "CompanyContactCreatePayload"
  /** The created company contact. */
  companyContact?: Maybe<CompanyContact>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyContactDelete` mutation. */
export type CompanyContactDeletePayload = {
  __typename?: "CompanyContactDeletePayload"
  /** The ID of the deleted company contact. */
  deletedCompanyContactId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/**
 * An auto-generated type which holds one CompanyContact and a cursor during pagination.
 *
 */
export type CompanyContactEdge = {
  __typename?: "CompanyContactEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CompanyContactEdge. */
  node: CompanyContact
}

/** The input fields for company contact attributes when creating or updating a company contact. */
export type CompanyContactInput = {
  /** The unique email address of the company contact. */
  email?: InputMaybe<Scalars["String"]["input"]>
  /** The company contact's first name. */
  firstName?: InputMaybe<Scalars["String"]["input"]>
  /** The company contact's last name. */
  lastName?: InputMaybe<Scalars["String"]["input"]>
  /** The contact's locale. */
  locale?: InputMaybe<Scalars["String"]["input"]>
  /** The phone number of the company contact. */
  phone?: InputMaybe<Scalars["String"]["input"]>
  /** The title of the company contact. */
  title?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `companyContactRemoveFromCompany` mutation. */
export type CompanyContactRemoveFromCompanyPayload = {
  __typename?: "CompanyContactRemoveFromCompanyPayload"
  /** The ID of the removed company contact. */
  removedCompanyContactId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyContactRevokeRole` mutation. */
export type CompanyContactRevokeRolePayload = {
  __typename?: "CompanyContactRevokeRolePayload"
  /** The role assignment that was revoked. */
  revokedCompanyContactRoleAssignmentId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyContactRevokeRoles` mutation. */
export type CompanyContactRevokeRolesPayload = {
  __typename?: "CompanyContactRevokeRolesPayload"
  /** A list of role assignment IDs that were removed from the company contact. */
  revokedRoleAssignmentIds?: Maybe<Array<Scalars["ID"]["output"]>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** The role for a [company contact](https://shopify.dev/api/admin-graphql/latest/objects/companycontact). */
export type CompanyContactRole = Node & {
  __typename?: "CompanyContactRole"
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /**
   * The name of a role.
   * For example, `admin` or `buyer`.
   *
   */
  name: Scalars["String"]["output"]
  /** A note for the role. */
  note?: Maybe<Scalars["String"]["output"]>
}

/**
 * The input fields for the role and location to assign to a company contact.
 *
 */
export type CompanyContactRoleAssign = {
  /** The role ID. */
  companyContactRoleId: Scalars["ID"]["input"]
  /** The location. */
  companyLocationId: Scalars["ID"]["input"]
}

/** The CompanyContactRoleAssignment describes the company and location associated to a company contact's role. */
export type CompanyContactRoleAssignment = Node & {
  __typename?: "CompanyContactRoleAssignment"
  /** The company this role assignment belongs to. */
  company: Company
  /** The company contact for whom this role is assigned. */
  companyContact: CompanyContact
  /** The company location to which the role is assigned. */
  companyLocation: CompanyLocation
  /** The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) when the assignment record was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The role that's assigned to the company contact. */
  role: CompanyContactRole
  /** The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) when the assignment record was last updated. */
  updatedAt: Scalars["DateTime"]["output"]
}

/**
 * An auto-generated type for paginating through multiple CompanyContactRoleAssignments.
 *
 */
export type CompanyContactRoleAssignmentConnection = {
  __typename?: "CompanyContactRoleAssignmentConnection"
  /** A list of edges. */
  edges: Array<CompanyContactRoleAssignmentEdge>
  /** A list of the nodes contained in CompanyContactRoleAssignmentEdge. */
  nodes: Array<CompanyContactRoleAssignment>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one CompanyContactRoleAssignment and a cursor during pagination.
 *
 */
export type CompanyContactRoleAssignmentEdge = {
  __typename?: "CompanyContactRoleAssignmentEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CompanyContactRoleAssignmentEdge. */
  node: CompanyContactRoleAssignment
}

/** The set of valid sort keys for the CompanyContactRoleAssignment query. */
export enum CompanyContactRoleAssignmentSortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /** Sort by the `location_name` value. */
  LocationName = "LOCATION_NAME",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `updated_at` value. */
  UpdatedAt = "UPDATED_AT",
}

/**
 * An auto-generated type for paginating through multiple CompanyContactRoles.
 *
 */
export type CompanyContactRoleConnection = {
  __typename?: "CompanyContactRoleConnection"
  /** A list of edges. */
  edges: Array<CompanyContactRoleEdge>
  /** A list of the nodes contained in CompanyContactRoleEdge. */
  nodes: Array<CompanyContactRole>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one CompanyContactRole and a cursor during pagination.
 *
 */
export type CompanyContactRoleEdge = {
  __typename?: "CompanyContactRoleEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CompanyContactRoleEdge. */
  node: CompanyContactRole
}

/** The set of valid sort keys for the CompanyContactRole query. */
export enum CompanyContactRoleSortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `updated_at` value. */
  UpdatedAt = "UPDATED_AT",
}

/** Return type for `companyContactSendWelcomeEmail` mutation. */
export type CompanyContactSendWelcomeEmailPayload = {
  __typename?: "CompanyContactSendWelcomeEmailPayload"
  /** The company contact to whom a welcome email was sent. */
  companyContact?: Maybe<CompanyContact>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** The set of valid sort keys for the CompanyContact query. */
export enum CompanyContactSortKeys {
  /** Sort by the `company_id` value. */
  CompanyId = "COMPANY_ID",
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `email` value. */
  Email = "EMAIL",
  /** Sort by the `id` value. */
  Id = "ID",
  /** Sort by the `name` value. */
  Name = "NAME",
  /** Sort by the `name_email` value. */
  NameEmail = "NAME_EMAIL",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `title` value. */
  Title = "TITLE",
  /** Sort by the `updated_at` value. */
  UpdatedAt = "UPDATED_AT",
}

/** Return type for `companyContactUpdate` mutation. */
export type CompanyContactUpdatePayload = {
  __typename?: "CompanyContactUpdatePayload"
  /** The updated company contact. */
  companyContact?: Maybe<CompanyContact>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyContactsDelete` mutation. */
export type CompanyContactsDeletePayload = {
  __typename?: "CompanyContactsDeletePayload"
  /** The list of IDs of the deleted company contacts. */
  deletedCompanyContactIds?: Maybe<Array<Scalars["ID"]["output"]>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/**
 * The input fields and values for creating a company and its associated resources.
 *
 */
export type CompanyCreateInput = {
  /** The attributes for the company. */
  company: CompanyInput
  /** The attributes for the company contact. */
  companyContact?: InputMaybe<CompanyContactInput>
  /** The attributes for the company location. */
  companyLocation?: InputMaybe<CompanyLocationInput>
}

/** Return type for `companyCreate` mutation. */
export type CompanyCreatePayload = {
  __typename?: "CompanyCreatePayload"
  /** The created company. */
  company?: Maybe<Company>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyDelete` mutation. */
export type CompanyDeletePayload = {
  __typename?: "CompanyDeletePayload"
  /** The ID of the deleted company. */
  deletedCompanyId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/**
 * An auto-generated type which holds one Company and a cursor during pagination.
 *
 */
export type CompanyEdge = {
  __typename?: "CompanyEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CompanyEdge. */
  node: Company
}

/** The input fields for company attributes when creating or updating a company. */
export type CompanyInput = {
  /**
   * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at
   *           which the company became the customer.
   */
  customerSince?: InputMaybe<Scalars["DateTime"]["input"]>
  /** A unique externally-supplied ID for the company. */
  externalId?: InputMaybe<Scalars["String"]["input"]>
  /** The name of the company. */
  name?: InputMaybe<Scalars["String"]["input"]>
  /** A note about the company. */
  note?: InputMaybe<Scalars["String"]["input"]>
}

/** A location or branch of a [company that's a customer](https://shopify.dev/api/admin-graphql/latest/objects/company) of the shop. Configuration of B2B relationship, for example prices lists and checkout settings, may be done for a location. */
export type CompanyLocation = CommentEventSubject &
  HasEvents &
  HasMetafieldDefinitions &
  HasMetafields &
  Navigable &
  Node & {
    __typename?: "CompanyLocation"
    /** The address used as billing address for the location. */
    billingAddress?: Maybe<CompanyAddress>
    /** The configuration for the buyer's B2B checkout. */
    buyerExperienceConfiguration?: Maybe<BuyerExperienceConfiguration>
    /** The list of catalogs associated with the company location. */
    catalogs: CatalogConnection
    /** The company that the company location belongs to. */
    company: Company
    /** The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company location was created in Shopify. */
    createdAt: Scalars["DateTime"]["output"]
    /** The location's currency based on the shipping address. If the shipping address is empty, then the value is the shop's primary market. */
    currency: CurrencyCode
    /**
     * A default cursor that returns the single next record, sorted ascending by ID.
     *
     */
    defaultCursor: Scalars["String"]["output"]
    /** The list of draft orders for the company location. */
    draftOrders: DraftOrderConnection
    /** The paginated list of events associated with the host subject. */
    events: EventConnection
    /** A unique externally-supplied ID for the company location. */
    externalId?: Maybe<Scalars["String"]["output"]>
    /** Whether the merchant added a timeline comment to the company location. */
    hasTimelineComment: Scalars["Boolean"]["output"]
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** Whether the company location is assigned a specific catalog. */
    inCatalog: Scalars["Boolean"]["output"]
    /** The preferred locale of the company location. */
    locale?: Maybe<Scalars["String"]["output"]>
    /** The market that includes the location's shipping address. If the shipping address is empty, then the value is the shop's primary market. */
    market: Market
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafield definitions. */
    metafieldDefinitions: MetafieldDefinitionConnection
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /** The name of the company location. */
    name: Scalars["String"]["output"]
    /** A note about the company location. */
    note?: Maybe<Scalars["String"]["output"]>
    /** The total number of orders placed for the location. */
    orderCount: Scalars["Int"]["output"]
    /** The list of orders for the company location. */
    orders: OrderConnection
    /** The phone number of the company location. */
    phone?: Maybe<Scalars["String"]["output"]>
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
    /** The list of roles assigned to the company location. */
    roleAssignments: CompanyContactRoleAssignmentConnection
    /** The address used as shipping address for the location. */
    shippingAddress?: Maybe<CompanyAddress>
    /** The list of tax exemptions applied to the location. */
    taxExemptions: Array<TaxExemption>
    /** The tax registration ID for the company location. */
    taxRegistrationId?: Maybe<Scalars["String"]["output"]>
    /** The total amount spent by the location. */
    totalSpent: MoneyV2
    /** The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company location was last modified. */
    updatedAt: Scalars["DateTime"]["output"]
  }

/** A location or branch of a [company that's a customer](https://shopify.dev/api/admin-graphql/latest/objects/company) of the shop. Configuration of B2B relationship, for example prices lists and checkout settings, may be done for a location. */
export type CompanyLocationCatalogsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** A location or branch of a [company that's a customer](https://shopify.dev/api/admin-graphql/latest/objects/company) of the shop. Configuration of B2B relationship, for example prices lists and checkout settings, may be done for a location. */
export type CompanyLocationDraftOrdersArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<DraftOrderSortKeys>
}

/** A location or branch of a [company that's a customer](https://shopify.dev/api/admin-graphql/latest/objects/company) of the shop. Configuration of B2B relationship, for example prices lists and checkout settings, may be done for a location. */
export type CompanyLocationEventsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<EventSortKeys>
}

/** A location or branch of a [company that's a customer](https://shopify.dev/api/admin-graphql/latest/objects/company) of the shop. Configuration of B2B relationship, for example prices lists and checkout settings, may be done for a location. */
export type CompanyLocationInCatalogArgs = {
  catalogId: Scalars["ID"]["input"]
}

/** A location or branch of a [company that's a customer](https://shopify.dev/api/admin-graphql/latest/objects/company) of the shop. Configuration of B2B relationship, for example prices lists and checkout settings, may be done for a location. */
export type CompanyLocationMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/** A location or branch of a [company that's a customer](https://shopify.dev/api/admin-graphql/latest/objects/company) of the shop. Configuration of B2B relationship, for example prices lists and checkout settings, may be done for a location. */
export type CompanyLocationMetafieldDefinitionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  pinnedStatus?: InputMaybe<MetafieldDefinitionPinnedStatus>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<MetafieldDefinitionSortKeys>
}

/** A location or branch of a [company that's a customer](https://shopify.dev/api/admin-graphql/latest/objects/company) of the shop. Configuration of B2B relationship, for example prices lists and checkout settings, may be done for a location. */
export type CompanyLocationMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** A location or branch of a [company that's a customer](https://shopify.dev/api/admin-graphql/latest/objects/company) of the shop. Configuration of B2B relationship, for example prices lists and checkout settings, may be done for a location. */
export type CompanyLocationOrdersArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<OrderSortKeys>
}

/** A location or branch of a [company that's a customer](https://shopify.dev/api/admin-graphql/latest/objects/company) of the shop. Configuration of B2B relationship, for example prices lists and checkout settings, may be done for a location. */
export type CompanyLocationPrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/** A location or branch of a [company that's a customer](https://shopify.dev/api/admin-graphql/latest/objects/company) of the shop. Configuration of B2B relationship, for example prices lists and checkout settings, may be done for a location. */
export type CompanyLocationPrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** A location or branch of a [company that's a customer](https://shopify.dev/api/admin-graphql/latest/objects/company) of the shop. Configuration of B2B relationship, for example prices lists and checkout settings, may be done for a location. */
export type CompanyLocationRoleAssignmentsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<CompanyContactRoleAssignmentSortKeys>
}

/** Return type for `companyLocationAssignAddress` mutation. */
export type CompanyLocationAssignAddressPayload = {
  __typename?: "CompanyLocationAssignAddressPayload"
  /** The list of updated addresses on the company location. */
  addresses?: Maybe<Array<CompanyAddress>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyLocationAssignRoles` mutation. */
export type CompanyLocationAssignRolesPayload = {
  __typename?: "CompanyLocationAssignRolesPayload"
  /** A list of newly created assignments of company contacts to a company location. */
  roleAssignments?: Maybe<Array<CompanyContactRoleAssignment>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyLocationAssignTaxExemptions` mutation. */
export type CompanyLocationAssignTaxExemptionsPayload = {
  __typename?: "CompanyLocationAssignTaxExemptionsPayload"
  /** The updated company location. */
  companyLocation?: Maybe<CompanyLocation>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/**
 * A list of products with publishing and pricing information associated with company locations.
 *
 */
export type CompanyLocationCatalog = Catalog &
  Node & {
    __typename?: "CompanyLocationCatalog"
    /** The company locations associated with the catalog. */
    companyLocations: CompanyLocationConnection
    /** The number of company locations associated with the catalog. */
    companyLocationsCount: Scalars["Int"]["output"]
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** Most recent catalog operations. */
    operations: Array<ResourceOperation>
    /** The price list associated with the catalog. */
    priceList?: Maybe<PriceList>
    /** A group of products and collections that's published to a catalog. */
    publication?: Maybe<Publication>
    /** The status of the catalog. */
    status: CatalogStatus
    /** The name of the catalog. */
    title: Scalars["String"]["output"]
  }

/**
 * A list of products with publishing and pricing information associated with company locations.
 *
 */
export type CompanyLocationCatalogCompanyLocationsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<CompanyLocationSortKeys>
}

/**
 * An auto-generated type for paginating through multiple CompanyLocations.
 *
 */
export type CompanyLocationConnection = {
  __typename?: "CompanyLocationConnection"
  /** A list of edges. */
  edges: Array<CompanyLocationEdge>
  /** A list of the nodes contained in CompanyLocationEdge. */
  nodes: Array<CompanyLocation>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `companyLocationCreate` mutation. */
export type CompanyLocationCreatePayload = {
  __typename?: "CompanyLocationCreatePayload"
  /** The created company location. */
  companyLocation?: Maybe<CompanyLocation>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyLocationCreateTaxRegistration` mutation. */
export type CompanyLocationCreateTaxRegistrationPayload = {
  __typename?: "CompanyLocationCreateTaxRegistrationPayload"
  /** The company location with the created tax registration. */
  companyLocation?: Maybe<CompanyLocation>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyLocationDelete` mutation. */
export type CompanyLocationDeletePayload = {
  __typename?: "CompanyLocationDeletePayload"
  /** The ID of the deleted company location. */
  deletedCompanyLocationId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/**
 * An auto-generated type which holds one CompanyLocation and a cursor during pagination.
 *
 */
export type CompanyLocationEdge = {
  __typename?: "CompanyLocationEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CompanyLocationEdge. */
  node: CompanyLocation
}

/** The input fields for company location when creating or updating a company location. */
export type CompanyLocationInput = {
  /** The input fields to create or update the billing address for a company location. */
  billingAddress?: InputMaybe<CompanyAddressInput>
  /** Whether the billing address is the same as the shipping address. If the value is true, then the input for `billingAddress` is ignored. */
  billingSameAsShipping?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The configuration for the buyer's checkout at the company location. */
  buyerExperienceConfiguration?: InputMaybe<BuyerExperienceConfigurationInput>
  /** A unique externally-supplied ID for the company location. */
  externalId?: InputMaybe<Scalars["String"]["input"]>
  /** The preferred locale of the company location. */
  locale?: InputMaybe<Scalars["String"]["input"]>
  /** The name of the company location. */
  name?: InputMaybe<Scalars["String"]["input"]>
  /** A note about the company location. */
  note?: InputMaybe<Scalars["String"]["input"]>
  /** The phone number of the company location. */
  phone?: InputMaybe<Scalars["String"]["input"]>
  /** The input fields to create or update the shipping address for a company location. */
  shippingAddress?: InputMaybe<CompanyAddressInput>
  /** The list of tax exemptions to apply to the company location. */
  taxExemptions?: InputMaybe<Array<TaxExemption>>
  /** The tax registration ID of the company location. */
  taxRegistrationId?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `companyLocationRevokeRoles` mutation. */
export type CompanyLocationRevokeRolesPayload = {
  __typename?: "CompanyLocationRevokeRolesPayload"
  /** A list of role assignment IDs that were removed from the company location. */
  revokedRoleAssignmentIds?: Maybe<Array<Scalars["ID"]["output"]>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyLocationRevokeTaxExemptions` mutation. */
export type CompanyLocationRevokeTaxExemptionsPayload = {
  __typename?: "CompanyLocationRevokeTaxExemptionsPayload"
  /** The updated company location. */
  companyLocation?: Maybe<CompanyLocation>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyLocationRevokeTaxRegistration` mutation. */
export type CompanyLocationRevokeTaxRegistrationPayload = {
  __typename?: "CompanyLocationRevokeTaxRegistrationPayload"
  /** The updated company location. */
  companyLocation?: Maybe<CompanyLocation>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/**
 * The input fields for the role and contact to assign on a location.
 *
 */
export type CompanyLocationRoleAssign = {
  /** The company contact ID.. */
  companyContactId: Scalars["ID"]["input"]
  /** The role ID. */
  companyContactRoleId: Scalars["ID"]["input"]
}

/** The set of valid sort keys for the CompanyLocation query. */
export enum CompanyLocationSortKeys {
  /** Sort by the `company_and_location_name` value. */
  CompanyAndLocationName = "COMPANY_AND_LOCATION_NAME",
  /** Sort by the `company_id` value. */
  CompanyId = "COMPANY_ID",
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /** Sort by the `name` value. */
  Name = "NAME",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `updated_at` value. */
  UpdatedAt = "UPDATED_AT",
}

/** The input fields for company location when creating or updating a company location. */
export type CompanyLocationUpdateInput = {
  /** The configuration for the buyer's checkout at the company location. */
  buyerExperienceConfiguration?: InputMaybe<BuyerExperienceConfigurationInput>
  /** A unique externally-supplied ID for the company location. */
  externalId?: InputMaybe<Scalars["String"]["input"]>
  /** The preferred locale of the company location. */
  locale?: InputMaybe<Scalars["String"]["input"]>
  /** The name of the company location. */
  name?: InputMaybe<Scalars["String"]["input"]>
  /** A note about the company location. */
  note?: InputMaybe<Scalars["String"]["input"]>
  /** The phone number of the company location. */
  phone?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `companyLocationUpdate` mutation. */
export type CompanyLocationUpdatePayload = {
  __typename?: "CompanyLocationUpdatePayload"
  /** The updated company location. */
  companyLocation?: Maybe<CompanyLocation>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyLocationsDelete` mutation. */
export type CompanyLocationsDeletePayload = {
  __typename?: "CompanyLocationsDeletePayload"
  /** A list of IDs of the deleted company locations. */
  deletedCompanyLocationIds?: Maybe<Array<Scalars["ID"]["output"]>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** Return type for `companyRevokeMainContact` mutation. */
export type CompanyRevokeMainContactPayload = {
  __typename?: "CompanyRevokeMainContactPayload"
  /** The company from which the main contact is revoked. */
  company?: Maybe<Company>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** The set of valid sort keys for the Company query. */
export enum CompanySortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /** Sort by the `name` value. */
  Name = "NAME",
  /** Sort by the `order_count` value. */
  OrderCount = "ORDER_COUNT",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `since_date` value. */
  SinceDate = "SINCE_DATE",
  /** Sort by the `total_spent` value. */
  TotalSpent = "TOTAL_SPENT",
  /** Sort by the `updated_at` value. */
  UpdatedAt = "UPDATED_AT",
}

/** Return type for `companyUpdate` mutation. */
export type CompanyUpdatePayload = {
  __typename?: "CompanyUpdatePayload"
  /** The updated company. */
  company?: Maybe<Company>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<BusinessCustomerUserError>
}

/** The input fields for the context data that determines the pricing of a variant. */
export type ContextualPricingContext = {
  /**
   * The CompanyLocation ID used to fetch company location specific prices.
   *
   */
  companyLocationId?: InputMaybe<Scalars["ID"]["input"]>
  /** The country code used to fetch country-specific prices. */
  country?: InputMaybe<CountryCode>
}

/** The context data that determines the publication status of a product. */
export type ContextualPublicationContext = {
  /** The company location ID used to fetch company-specific publication. */
  companyLocationId?: InputMaybe<Scalars["ID"]["input"]>
  /** The country code used to fetch country-specific publication. */
  country?: InputMaybe<CountryCode>
}

/** The list of all the countries from the combined shipping zones for the shop. */
export type CountriesInShippingZones = {
  __typename?: "CountriesInShippingZones"
  /** The list of all the countries from all the combined shipping zones. */
  countryCodes: Array<CountryCode>
  /** Whether 'Rest of World' has been defined in any of the shipping zones. */
  includeRestOfWorld: Scalars["Boolean"]["output"]
}

/**
 * The code designating a country/region, which generally follows ISO 3166-1 alpha-2 guidelines.
 * If a territory doesn't have a country code value in the `CountryCode` enum, then it might be considered a subdivision
 * of another country. For example, the territories associated with Spain are represented by the country code `ES`,
 * and the territories associated with the United States of America are represented by the country code `US`.
 *
 */
export enum CountryCode {
  /** Ascension Island. */
  Ac = "AC",
  /** Andorra. */
  Ad = "AD",
  /** United Arab Emirates. */
  Ae = "AE",
  /** Afghanistan. */
  Af = "AF",
  /** Antigua & Barbuda. */
  Ag = "AG",
  /** Anguilla. */
  Ai = "AI",
  /** Albania. */
  Al = "AL",
  /** Armenia. */
  Am = "AM",
  /** Netherlands Antilles. */
  An = "AN",
  /** Angola. */
  Ao = "AO",
  /** Argentina. */
  Ar = "AR",
  /** Austria. */
  At = "AT",
  /** Australia. */
  Au = "AU",
  /** Aruba. */
  Aw = "AW",
  /** Åland Islands. */
  Ax = "AX",
  /** Azerbaijan. */
  Az = "AZ",
  /** Bosnia & Herzegovina. */
  Ba = "BA",
  /** Barbados. */
  Bb = "BB",
  /** Bangladesh. */
  Bd = "BD",
  /** Belgium. */
  Be = "BE",
  /** Burkina Faso. */
  Bf = "BF",
  /** Bulgaria. */
  Bg = "BG",
  /** Bahrain. */
  Bh = "BH",
  /** Burundi. */
  Bi = "BI",
  /** Benin. */
  Bj = "BJ",
  /** St. Barthélemy. */
  Bl = "BL",
  /** Bermuda. */
  Bm = "BM",
  /** Brunei. */
  Bn = "BN",
  /** Bolivia. */
  Bo = "BO",
  /** Caribbean Netherlands. */
  Bq = "BQ",
  /** Brazil. */
  Br = "BR",
  /** Bahamas. */
  Bs = "BS",
  /** Bhutan. */
  Bt = "BT",
  /** Bouvet Island. */
  Bv = "BV",
  /** Botswana. */
  Bw = "BW",
  /** Belarus. */
  By = "BY",
  /** Belize. */
  Bz = "BZ",
  /** Canada. */
  Ca = "CA",
  /** Cocos (Keeling) Islands. */
  Cc = "CC",
  /** Congo - Kinshasa. */
  Cd = "CD",
  /** Central African Republic. */
  Cf = "CF",
  /** Congo - Brazzaville. */
  Cg = "CG",
  /** Switzerland. */
  Ch = "CH",
  /** Côte d’Ivoire. */
  Ci = "CI",
  /** Cook Islands. */
  Ck = "CK",
  /** Chile. */
  Cl = "CL",
  /** Cameroon. */
  Cm = "CM",
  /** China. */
  Cn = "CN",
  /** Colombia. */
  Co = "CO",
  /** Costa Rica. */
  Cr = "CR",
  /** Cuba. */
  Cu = "CU",
  /** Cape Verde. */
  Cv = "CV",
  /** Curaçao. */
  Cw = "CW",
  /** Christmas Island. */
  Cx = "CX",
  /** Cyprus. */
  Cy = "CY",
  /** Czechia. */
  Cz = "CZ",
  /** Germany. */
  De = "DE",
  /** Djibouti. */
  Dj = "DJ",
  /** Denmark. */
  Dk = "DK",
  /** Dominica. */
  Dm = "DM",
  /** Dominican Republic. */
  Do = "DO",
  /** Algeria. */
  Dz = "DZ",
  /** Ecuador. */
  Ec = "EC",
  /** Estonia. */
  Ee = "EE",
  /** Egypt. */
  Eg = "EG",
  /** Western Sahara. */
  Eh = "EH",
  /** Eritrea. */
  Er = "ER",
  /** Spain. */
  Es = "ES",
  /** Ethiopia. */
  Et = "ET",
  /** Finland. */
  Fi = "FI",
  /** Fiji. */
  Fj = "FJ",
  /** Falkland Islands. */
  Fk = "FK",
  /** Faroe Islands. */
  Fo = "FO",
  /** France. */
  Fr = "FR",
  /** Gabon. */
  Ga = "GA",
  /** United Kingdom. */
  Gb = "GB",
  /** Grenada. */
  Gd = "GD",
  /** Georgia. */
  Ge = "GE",
  /** French Guiana. */
  Gf = "GF",
  /** Guernsey. */
  Gg = "GG",
  /** Ghana. */
  Gh = "GH",
  /** Gibraltar. */
  Gi = "GI",
  /** Greenland. */
  Gl = "GL",
  /** Gambia. */
  Gm = "GM",
  /** Guinea. */
  Gn = "GN",
  /** Guadeloupe. */
  Gp = "GP",
  /** Equatorial Guinea. */
  Gq = "GQ",
  /** Greece. */
  Gr = "GR",
  /** South Georgia & South Sandwich Islands. */
  Gs = "GS",
  /** Guatemala. */
  Gt = "GT",
  /** Guinea-Bissau. */
  Gw = "GW",
  /** Guyana. */
  Gy = "GY",
  /** Hong Kong SAR. */
  Hk = "HK",
  /** Heard & McDonald Islands. */
  Hm = "HM",
  /** Honduras. */
  Hn = "HN",
  /** Croatia. */
  Hr = "HR",
  /** Haiti. */
  Ht = "HT",
  /** Hungary. */
  Hu = "HU",
  /** Indonesia. */
  Id = "ID",
  /** Ireland. */
  Ie = "IE",
  /** Israel. */
  Il = "IL",
  /** Isle of Man. */
  Im = "IM",
  /** India. */
  In = "IN",
  /** British Indian Ocean Territory. */
  Io = "IO",
  /** Iraq. */
  Iq = "IQ",
  /** Iran. */
  Ir = "IR",
  /** Iceland. */
  Is = "IS",
  /** Italy. */
  It = "IT",
  /** Jersey. */
  Je = "JE",
  /** Jamaica. */
  Jm = "JM",
  /** Jordan. */
  Jo = "JO",
  /** Japan. */
  Jp = "JP",
  /** Kenya. */
  Ke = "KE",
  /** Kyrgyzstan. */
  Kg = "KG",
  /** Cambodia. */
  Kh = "KH",
  /** Kiribati. */
  Ki = "KI",
  /** Comoros. */
  Km = "KM",
  /** St. Kitts & Nevis. */
  Kn = "KN",
  /** North Korea. */
  Kp = "KP",
  /** South Korea. */
  Kr = "KR",
  /** Kuwait. */
  Kw = "KW",
  /** Cayman Islands. */
  Ky = "KY",
  /** Kazakhstan. */
  Kz = "KZ",
  /** Laos. */
  La = "LA",
  /** Lebanon. */
  Lb = "LB",
  /** St. Lucia. */
  Lc = "LC",
  /** Liechtenstein. */
  Li = "LI",
  /** Sri Lanka. */
  Lk = "LK",
  /** Liberia. */
  Lr = "LR",
  /** Lesotho. */
  Ls = "LS",
  /** Lithuania. */
  Lt = "LT",
  /** Luxembourg. */
  Lu = "LU",
  /** Latvia. */
  Lv = "LV",
  /** Libya. */
  Ly = "LY",
  /** Morocco. */
  Ma = "MA",
  /** Monaco. */
  Mc = "MC",
  /** Moldova. */
  Md = "MD",
  /** Montenegro. */
  Me = "ME",
  /** St. Martin. */
  Mf = "MF",
  /** Madagascar. */
  Mg = "MG",
  /** North Macedonia. */
  Mk = "MK",
  /** Mali. */
  Ml = "ML",
  /** Myanmar (Burma). */
  Mm = "MM",
  /** Mongolia. */
  Mn = "MN",
  /** Macao SAR. */
  Mo = "MO",
  /** Martinique. */
  Mq = "MQ",
  /** Mauritania. */
  Mr = "MR",
  /** Montserrat. */
  Ms = "MS",
  /** Malta. */
  Mt = "MT",
  /** Mauritius. */
  Mu = "MU",
  /** Maldives. */
  Mv = "MV",
  /** Malawi. */
  Mw = "MW",
  /** Mexico. */
  Mx = "MX",
  /** Malaysia. */
  My = "MY",
  /** Mozambique. */
  Mz = "MZ",
  /** Namibia. */
  Na = "NA",
  /** New Caledonia. */
  Nc = "NC",
  /** Niger. */
  Ne = "NE",
  /** Norfolk Island. */
  Nf = "NF",
  /** Nigeria. */
  Ng = "NG",
  /** Nicaragua. */
  Ni = "NI",
  /** Netherlands. */
  Nl = "NL",
  /** Norway. */
  No = "NO",
  /** Nepal. */
  Np = "NP",
  /** Nauru. */
  Nr = "NR",
  /** Niue. */
  Nu = "NU",
  /** New Zealand. */
  Nz = "NZ",
  /** Oman. */
  Om = "OM",
  /** Panama. */
  Pa = "PA",
  /** Peru. */
  Pe = "PE",
  /** French Polynesia. */
  Pf = "PF",
  /** Papua New Guinea. */
  Pg = "PG",
  /** Philippines. */
  Ph = "PH",
  /** Pakistan. */
  Pk = "PK",
  /** Poland. */
  Pl = "PL",
  /** St. Pierre & Miquelon. */
  Pm = "PM",
  /** Pitcairn Islands. */
  Pn = "PN",
  /** Palestinian Territories. */
  Ps = "PS",
  /** Portugal. */
  Pt = "PT",
  /** Paraguay. */
  Py = "PY",
  /** Qatar. */
  Qa = "QA",
  /** Réunion. */
  Re = "RE",
  /** Romania. */
  Ro = "RO",
  /** Serbia. */
  Rs = "RS",
  /** Russia. */
  Ru = "RU",
  /** Rwanda. */
  Rw = "RW",
  /** Saudi Arabia. */
  Sa = "SA",
  /** Solomon Islands. */
  Sb = "SB",
  /** Seychelles. */
  Sc = "SC",
  /** Sudan. */
  Sd = "SD",
  /** Sweden. */
  Se = "SE",
  /** Singapore. */
  Sg = "SG",
  /** St. Helena. */
  Sh = "SH",
  /** Slovenia. */
  Si = "SI",
  /** Svalbard & Jan Mayen. */
  Sj = "SJ",
  /** Slovakia. */
  Sk = "SK",
  /** Sierra Leone. */
  Sl = "SL",
  /** San Marino. */
  Sm = "SM",
  /** Senegal. */
  Sn = "SN",
  /** Somalia. */
  So = "SO",
  /** Suriname. */
  Sr = "SR",
  /** South Sudan. */
  Ss = "SS",
  /** São Tomé & Príncipe. */
  St = "ST",
  /** El Salvador. */
  Sv = "SV",
  /** Sint Maarten. */
  Sx = "SX",
  /** Syria. */
  Sy = "SY",
  /** Eswatini. */
  Sz = "SZ",
  /** Tristan da Cunha. */
  Ta = "TA",
  /** Turks & Caicos Islands. */
  Tc = "TC",
  /** Chad. */
  Td = "TD",
  /** French Southern Territories. */
  Tf = "TF",
  /** Togo. */
  Tg = "TG",
  /** Thailand. */
  Th = "TH",
  /** Tajikistan. */
  Tj = "TJ",
  /** Tokelau. */
  Tk = "TK",
  /** Timor-Leste. */
  Tl = "TL",
  /** Turkmenistan. */
  Tm = "TM",
  /** Tunisia. */
  Tn = "TN",
  /** Tonga. */
  To = "TO",
  /** Türkiye. */
  Tr = "TR",
  /** Trinidad & Tobago. */
  Tt = "TT",
  /** Tuvalu. */
  Tv = "TV",
  /** Taiwan. */
  Tw = "TW",
  /** Tanzania. */
  Tz = "TZ",
  /** Ukraine. */
  Ua = "UA",
  /** Uganda. */
  Ug = "UG",
  /** U.S. Outlying Islands. */
  Um = "UM",
  /** United States. */
  Us = "US",
  /** Uruguay. */
  Uy = "UY",
  /** Uzbekistan. */
  Uz = "UZ",
  /** Vatican City. */
  Va = "VA",
  /** St. Vincent & Grenadines. */
  Vc = "VC",
  /** Venezuela. */
  Ve = "VE",
  /** British Virgin Islands. */
  Vg = "VG",
  /** Vietnam. */
  Vn = "VN",
  /** Vanuatu. */
  Vu = "VU",
  /** Wallis & Futuna. */
  Wf = "WF",
  /** Samoa. */
  Ws = "WS",
  /** Kosovo. */
  Xk = "XK",
  /** Yemen. */
  Ye = "YE",
  /** Mayotte. */
  Yt = "YT",
  /** South Africa. */
  Za = "ZA",
  /** Zambia. */
  Zm = "ZM",
  /** Zimbabwe. */
  Zw = "ZW",
  /** Unknown Region. */
  Zz = "ZZ",
}

/**
 * The country-specific harmonized system code and ISO country code for an inventory item.
 *
 */
export type CountryHarmonizedSystemCode = {
  __typename?: "CountryHarmonizedSystemCode"
  /** The ISO 3166-1 alpha-2 country code for the country that issued the specified harmonized system code. */
  countryCode: CountryCode
  /** The country-specific harmonized system code. These are usually longer than 6 digits. */
  harmonizedSystemCode: Scalars["String"]["output"]
}

/**
 * An auto-generated type for paginating through multiple CountryHarmonizedSystemCodes.
 *
 */
export type CountryHarmonizedSystemCodeConnection = {
  __typename?: "CountryHarmonizedSystemCodeConnection"
  /** A list of edges. */
  edges: Array<CountryHarmonizedSystemCodeEdge>
  /** A list of the nodes contained in CountryHarmonizedSystemCodeEdge. */
  nodes: Array<CountryHarmonizedSystemCode>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one CountryHarmonizedSystemCode and a cursor during pagination.
 *
 */
export type CountryHarmonizedSystemCodeEdge = {
  __typename?: "CountryHarmonizedSystemCodeEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CountryHarmonizedSystemCodeEdge. */
  node: CountryHarmonizedSystemCode
}

/**
 * The input fields required to specify a harmonized system code.
 *
 */
export type CountryHarmonizedSystemCodeInput = {
  /** The ISO 3166-1 alpha-2 country code for the country that issued the specified harmonized system code. */
  countryCode: CountryCode
  /** Country specific harmonized system code. */
  harmonizedSystemCode: Scalars["String"]["input"]
}

/** The input fields required to create a media object. */
export type CreateMediaInput = {
  /** The alt text associated with the media. */
  alt?: InputMaybe<Scalars["String"]["input"]>
  /** The media content type. */
  mediaContentType: MediaContentType
  /** The original source of the media object. This might be an external URL or a staged upload URL. */
  originalSource: Scalars["String"]["input"]
}

/** The part of the image that should remain after cropping. */
export enum CropRegion {
  /** Keep the bottom of the image. */
  Bottom = "BOTTOM",
  /** Keep the center of the image. */
  Center = "CENTER",
  /** Keep the left of the image. */
  Left = "LEFT",
  /** Keep the right of the image. */
  Right = "RIGHT",
  /** Keep the top of the image. */
  Top = "TOP",
}

/**
 * The three-letter currency codes that represent the world currencies used in stores. These include standard ISO 4217 codes, legacy codes,
 * and non-standard codes.
 *
 */
export enum CurrencyCode {
  /** United Arab Emirates Dirham (AED). */
  Aed = "AED",
  /** Afghan Afghani (AFN). */
  Afn = "AFN",
  /** Albanian Lek (ALL). */
  All = "ALL",
  /** Armenian Dram (AMD). */
  Amd = "AMD",
  /** Netherlands Antillean Guilder. */
  Ang = "ANG",
  /** Angolan Kwanza (AOA). */
  Aoa = "AOA",
  /** Argentine Pesos (ARS). */
  Ars = "ARS",
  /** Australian Dollars (AUD). */
  Aud = "AUD",
  /** Aruban Florin (AWG). */
  Awg = "AWG",
  /** Azerbaijani Manat (AZN). */
  Azn = "AZN",
  /** Bosnia and Herzegovina Convertible Mark (BAM). */
  Bam = "BAM",
  /** Barbadian Dollar (BBD). */
  Bbd = "BBD",
  /** Bangladesh Taka (BDT). */
  Bdt = "BDT",
  /** Bulgarian Lev (BGN). */
  Bgn = "BGN",
  /** Bahraini Dinar (BHD). */
  Bhd = "BHD",
  /** Burundian Franc (BIF). */
  Bif = "BIF",
  /** Bermudian Dollar (BMD). */
  Bmd = "BMD",
  /** Brunei Dollar (BND). */
  Bnd = "BND",
  /** Bolivian Boliviano (BOB). */
  Bob = "BOB",
  /** Brazilian Real (BRL). */
  Brl = "BRL",
  /** Bahamian Dollar (BSD). */
  Bsd = "BSD",
  /** Bhutanese Ngultrum (BTN). */
  Btn = "BTN",
  /** Botswana Pula (BWP). */
  Bwp = "BWP",
  /** Belarusian Ruble (BYN). */
  Byn = "BYN",
  /**
   * Belarusian Ruble (BYR).
   * @deprecated `BYR` is deprecated. Use `BYN` available from version `2021-01` onwards instead.
   */
  Byr = "BYR",
  /** Belize Dollar (BZD). */
  Bzd = "BZD",
  /** Canadian Dollars (CAD). */
  Cad = "CAD",
  /** Congolese franc (CDF). */
  Cdf = "CDF",
  /** Swiss Francs (CHF). */
  Chf = "CHF",
  /** Chilean Peso (CLP). */
  Clp = "CLP",
  /** Chinese Yuan Renminbi (CNY). */
  Cny = "CNY",
  /** Colombian Peso (COP). */
  Cop = "COP",
  /** Costa Rican Colones (CRC). */
  Crc = "CRC",
  /** Cape Verdean escudo (CVE). */
  Cve = "CVE",
  /** Czech Koruny (CZK). */
  Czk = "CZK",
  /** Djiboutian Franc (DJF). */
  Djf = "DJF",
  /** Danish Kroner (DKK). */
  Dkk = "DKK",
  /** Dominican Peso (DOP). */
  Dop = "DOP",
  /** Algerian Dinar (DZD). */
  Dzd = "DZD",
  /** Egyptian Pound (EGP). */
  Egp = "EGP",
  /** Eritrean Nakfa (ERN). */
  Ern = "ERN",
  /** Ethiopian Birr (ETB). */
  Etb = "ETB",
  /** Euro (EUR). */
  Eur = "EUR",
  /** Fijian Dollars (FJD). */
  Fjd = "FJD",
  /** Falkland Islands Pounds (FKP). */
  Fkp = "FKP",
  /** United Kingdom Pounds (GBP). */
  Gbp = "GBP",
  /** Georgian Lari (GEL). */
  Gel = "GEL",
  /** Ghanaian Cedi (GHS). */
  Ghs = "GHS",
  /** Gibraltar Pounds (GIP). */
  Gip = "GIP",
  /** Gambian Dalasi (GMD). */
  Gmd = "GMD",
  /** Guinean Franc (GNF). */
  Gnf = "GNF",
  /** Guatemalan Quetzal (GTQ). */
  Gtq = "GTQ",
  /** Guyanese Dollar (GYD). */
  Gyd = "GYD",
  /** Hong Kong Dollars (HKD). */
  Hkd = "HKD",
  /** Honduran Lempira (HNL). */
  Hnl = "HNL",
  /** Croatian Kuna (HRK). */
  Hrk = "HRK",
  /** Haitian Gourde (HTG). */
  Htg = "HTG",
  /** Hungarian Forint (HUF). */
  Huf = "HUF",
  /** Indonesian Rupiah (IDR). */
  Idr = "IDR",
  /** Israeli New Shekel (NIS). */
  Ils = "ILS",
  /** Indian Rupees (INR). */
  Inr = "INR",
  /** Iraqi Dinar (IQD). */
  Iqd = "IQD",
  /** Iranian Rial (IRR). */
  Irr = "IRR",
  /** Icelandic Kronur (ISK). */
  Isk = "ISK",
  /** Jersey Pound. */
  Jep = "JEP",
  /** Jamaican Dollars (JMD). */
  Jmd = "JMD",
  /** Jordanian Dinar (JOD). */
  Jod = "JOD",
  /** Japanese Yen (JPY). */
  Jpy = "JPY",
  /** Kenyan Shilling (KES). */
  Kes = "KES",
  /** Kyrgyzstani Som (KGS). */
  Kgs = "KGS",
  /** Cambodian Riel. */
  Khr = "KHR",
  /** Kiribati Dollar (KID). */
  Kid = "KID",
  /** Comorian Franc (KMF). */
  Kmf = "KMF",
  /** South Korean Won (KRW). */
  Krw = "KRW",
  /** Kuwaiti Dinar (KWD). */
  Kwd = "KWD",
  /** Cayman Dollars (KYD). */
  Kyd = "KYD",
  /** Kazakhstani Tenge (KZT). */
  Kzt = "KZT",
  /** Laotian Kip (LAK). */
  Lak = "LAK",
  /** Lebanese Pounds (LBP). */
  Lbp = "LBP",
  /** Sri Lankan Rupees (LKR). */
  Lkr = "LKR",
  /** Liberian Dollar (LRD). */
  Lrd = "LRD",
  /** Lesotho Loti (LSL). */
  Lsl = "LSL",
  /** Lithuanian Litai (LTL). */
  Ltl = "LTL",
  /** Latvian Lati (LVL). */
  Lvl = "LVL",
  /** Libyan Dinar (LYD). */
  Lyd = "LYD",
  /** Moroccan Dirham. */
  Mad = "MAD",
  /** Moldovan Leu (MDL). */
  Mdl = "MDL",
  /** Malagasy Ariary (MGA). */
  Mga = "MGA",
  /** Macedonia Denar (MKD). */
  Mkd = "MKD",
  /** Burmese Kyat (MMK). */
  Mmk = "MMK",
  /** Mongolian Tugrik. */
  Mnt = "MNT",
  /** Macanese Pataca (MOP). */
  Mop = "MOP",
  /** Mauritanian Ouguiya (MRU). */
  Mru = "MRU",
  /** Mauritian Rupee (MUR). */
  Mur = "MUR",
  /** Maldivian Rufiyaa (MVR). */
  Mvr = "MVR",
  /** Malawian Kwacha (MWK). */
  Mwk = "MWK",
  /** Mexican Pesos (MXN). */
  Mxn = "MXN",
  /** Malaysian Ringgits (MYR). */
  Myr = "MYR",
  /** Mozambican Metical. */
  Mzn = "MZN",
  /** Namibian Dollar. */
  Nad = "NAD",
  /** Nigerian Naira (NGN). */
  Ngn = "NGN",
  /** Nicaraguan Córdoba (NIO). */
  Nio = "NIO",
  /** Norwegian Kroner (NOK). */
  Nok = "NOK",
  /** Nepalese Rupee (NPR). */
  Npr = "NPR",
  /** New Zealand Dollars (NZD). */
  Nzd = "NZD",
  /** Omani Rial (OMR). */
  Omr = "OMR",
  /** Panamian Balboa (PAB). */
  Pab = "PAB",
  /** Peruvian Nuevo Sol (PEN). */
  Pen = "PEN",
  /** Papua New Guinean Kina (PGK). */
  Pgk = "PGK",
  /** Philippine Peso (PHP). */
  Php = "PHP",
  /** Pakistani Rupee (PKR). */
  Pkr = "PKR",
  /** Polish Zlotych (PLN). */
  Pln = "PLN",
  /** Paraguayan Guarani (PYG). */
  Pyg = "PYG",
  /** Qatari Rial (QAR). */
  Qar = "QAR",
  /** Romanian Lei (RON). */
  Ron = "RON",
  /** Serbian dinar (RSD). */
  Rsd = "RSD",
  /** Russian Rubles (RUB). */
  Rub = "RUB",
  /** Rwandan Franc (RWF). */
  Rwf = "RWF",
  /** Saudi Riyal (SAR). */
  Sar = "SAR",
  /** Solomon Islands Dollar (SBD). */
  Sbd = "SBD",
  /** Seychellois Rupee (SCR). */
  Scr = "SCR",
  /** Sudanese Pound (SDG). */
  Sdg = "SDG",
  /** Swedish Kronor (SEK). */
  Sek = "SEK",
  /** Singapore Dollars (SGD). */
  Sgd = "SGD",
  /** Saint Helena Pounds (SHP). */
  Shp = "SHP",
  /** Sierra Leonean Leone (SLL). */
  Sll = "SLL",
  /** Somali Shilling (SOS). */
  Sos = "SOS",
  /** Surinamese Dollar (SRD). */
  Srd = "SRD",
  /** South Sudanese Pound (SSP). */
  Ssp = "SSP",
  /**
   * Sao Tome And Principe Dobra (STD).
   * @deprecated `STD` is deprecated. Use `STN` available from version `2022-07` onwards instead.
   */
  Std = "STD",
  /** Sao Tome And Principe Dobra (STN). */
  Stn = "STN",
  /** Syrian Pound (SYP). */
  Syp = "SYP",
  /** Swazi Lilangeni (SZL). */
  Szl = "SZL",
  /** Thai baht (THB). */
  Thb = "THB",
  /** Tajikistani Somoni (TJS). */
  Tjs = "TJS",
  /** Turkmenistani Manat (TMT). */
  Tmt = "TMT",
  /** Tunisian Dinar (TND). */
  Tnd = "TND",
  /** Tongan Pa'anga (TOP). */
  Top = "TOP",
  /** Turkish Lira (TRY). */
  Try = "TRY",
  /** Trinidad and Tobago Dollars (TTD). */
  Ttd = "TTD",
  /** Taiwan Dollars (TWD). */
  Twd = "TWD",
  /** Tanzanian Shilling (TZS). */
  Tzs = "TZS",
  /** Ukrainian Hryvnia (UAH). */
  Uah = "UAH",
  /** Ugandan Shilling (UGX). */
  Ugx = "UGX",
  /** United States Dollars (USD). */
  Usd = "USD",
  /** Uruguayan Pesos (UYU). */
  Uyu = "UYU",
  /** Uzbekistan som (UZS). */
  Uzs = "UZS",
  /** Venezuelan Bolivares (VED). */
  Ved = "VED",
  /**
   * Venezuelan Bolivares (VEF).
   * @deprecated `VEF` is deprecated. Use `VES` available from version `2020-10` onwards instead.
   */
  Vef = "VEF",
  /** Venezuelan Bolivares Soberanos (VES). */
  Ves = "VES",
  /** Vietnamese đồng (VND). */
  Vnd = "VND",
  /** Vanuatu Vatu (VUV). */
  Vuv = "VUV",
  /** Samoan Tala (WST). */
  Wst = "WST",
  /** Central African CFA Franc (XAF). */
  Xaf = "XAF",
  /** East Caribbean Dollar (XCD). */
  Xcd = "XCD",
  /** West African CFA franc (XOF). */
  Xof = "XOF",
  /** CFP Franc (XPF). */
  Xpf = "XPF",
  /** Unrecognized currency. */
  Xxx = "XXX",
  /** Yemeni Rial (YER). */
  Yer = "YER",
  /** South African Rand (ZAR). */
  Zar = "ZAR",
  /** Zambian Kwacha (ZMW). */
  Zmw = "ZMW",
}

/** Currency formats configured for the merchant. These formats are available to use within Liquid. */
export type CurrencyFormats = {
  __typename?: "CurrencyFormats"
  /** Money without currency in HTML. */
  moneyFormat: Scalars["FormattedString"]["output"]
  /** Money without currency in emails. */
  moneyInEmailsFormat: Scalars["String"]["output"]
  /** Money with currency in HTML. */
  moneyWithCurrencyFormat: Scalars["FormattedString"]["output"]
  /** Money with currency in emails. */
  moneyWithCurrencyInEmailsFormat: Scalars["String"]["output"]
}

/** A setting for a presentment currency. */
export type CurrencySetting = {
  __typename?: "CurrencySetting"
  /** The currency's ISO code. */
  currencyCode: CurrencyCode
  /** The full name of the currency. */
  currencyName: Scalars["String"]["output"]
  /** Whether the currency is enabled or not. An enabled currency setting is visible to buyers and allows orders to be generated with that currency as presentment. */
  enabled: Scalars["Boolean"]["output"]
  /** The date and time when the active exchange rate for the currency was last modified. It can be the automatic rate's creation date, or the manual rate's last updated at date if active. */
  rateUpdatedAt?: Maybe<Scalars["DateTime"]["output"]>
}

/**
 * An auto-generated type for paginating through multiple CurrencySettings.
 *
 */
export type CurrencySettingConnection = {
  __typename?: "CurrencySettingConnection"
  /** A list of edges. */
  edges: Array<CurrencySettingEdge>
  /** A list of the nodes contained in CurrencySettingEdge. */
  nodes: Array<CurrencySetting>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one CurrencySetting and a cursor during pagination.
 *
 */
export type CurrencySettingEdge = {
  __typename?: "CurrencySettingEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CurrencySettingEdge. */
  node: CurrencySetting
}

/** The input fields for a custom shipping package used to pack shipment. */
export type CustomShippingPackageInput = {
  /** The default package is the one used to calculate shipping costs on checkout. */
  default?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Outside dimensions of the empty shipping package. */
  dimensions?: InputMaybe<ObjectDimensionsInput>
  /** Descriptive name for the package. */
  name?: InputMaybe<Scalars["String"]["input"]>
  /** Type of package. */
  type?: InputMaybe<ShippingPackageType>
  /** Weight of the empty shipping package. */
  weight?: InputMaybe<WeightInput>
}

/**
 * Represents information about a customer of the shop, such as the customer's contact details, their order
 * history, and whether they've agreed to receive marketing material by email.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type Customer = CommentEventSubject &
  HasEvents &
  HasMetafieldDefinitions &
  HasMetafields &
  LegacyInteroperability &
  Node & {
    __typename?: "Customer"
    /** A list of addresses associated with the customer. */
    addresses: Array<MailingAddress>
    /** The total amount that the customer has spent on orders in their lifetime. */
    amountSpent: MoneyV2
    /**
     * Whether the merchant can delete the customer from their store.
     *
     * A customer can be deleted from a store only if they haven't yet made an order. After a customer makes an
     * order, they can't be deleted from a store.
     *
     */
    canDelete: Scalars["Boolean"]["output"]
    /** A list of the customer's company contact profiles. */
    companyContactProfiles: Array<CompanyContact>
    /** The date and time when the customer was added to the store. */
    createdAt: Scalars["DateTime"]["output"]
    /** The default address associated with the customer. */
    defaultAddress?: Maybe<MailingAddress>
    /**
     * The full name of the customer, based on the values for first_name and last_name. If the first_name and
     * last_name are not available, then this falls back to the customer's email address, and if that is not available, the customer's phone number.
     *
     */
    displayName: Scalars["String"]["output"]
    /** The customer's email address. */
    email?: Maybe<Scalars["String"]["output"]>
    /**
     * The current email marketing state for the customer.
     * If the customer doesn't have an email address, then this property is `null`.
     *
     */
    emailMarketingConsent?: Maybe<CustomerEmailMarketingConsentState>
    /** A list of events associated with the customer. */
    events: EventConnection
    /** The customer's first name. */
    firstName?: Maybe<Scalars["String"]["output"]>
    /**
     * Whether the merchant has added timeline comments about the customer on the customer's page.
     * @deprecated To query for comments on the timeline, use the events connection and a `query` argument containing `verb:comment`, or look for a `CommentEvent` in the `__typename` of events.
     */
    hasTimelineComment: Scalars["Boolean"]["output"]
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The image associated with the customer. */
    image: Image
    /** The customer's last name. */
    lastName?: Maybe<Scalars["String"]["output"]>
    /** The customer's last order. */
    lastOrder?: Maybe<Order>
    /** The ID of the corresponding resource in the REST Admin API. */
    legacyResourceId: Scalars["UnsignedInt64"]["output"]
    /**
     * The amount of time since the customer was first added to the store.
     *
     * Example: 'about 12 years'.
     *
     */
    lifetimeDuration: Scalars["String"]["output"]
    /** The customer's locale. */
    locale: Scalars["String"]["output"]
    /** The market that includes the customer’s default address. */
    market?: Maybe<Market>
    /** Whether the customer can be merged with another customer. */
    mergeable: CustomerMergeable
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafield definitions. */
    metafieldDefinitions: MetafieldDefinitionConnection
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /** A unique identifier for the customer that's used with Multipass login. */
    multipassIdentifier?: Maybe<Scalars["String"]["output"]>
    /** A note about the customer. */
    note?: Maybe<Scalars["String"]["output"]>
    /** The number of orders that the customer has made at the store in their lifetime. */
    numberOfOrders: Scalars["UnsignedInt64"]["output"]
    /** A list of the customer's orders. */
    orders: OrderConnection
    /** A list of the customer's payment methods. */
    paymentMethods: CustomerPaymentMethodConnection
    /** The customer's phone number. */
    phone?: Maybe<Scalars["String"]["output"]>
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
    /** Possible subscriber states of a customer defined by their subscription contracts. */
    productSubscriberStatus: CustomerProductSubscriberStatus
    /**
     * The current SMS marketing state for the customer's phone number.
     *
     * If the customer does not have a phone number, then this property is `null`.
     *
     */
    smsMarketingConsent?: Maybe<CustomerSmsMarketingConsentState>
    /** The state of the customer's account with the shop. */
    state: CustomerState
    /** The statistics for a given customer. */
    statistics: CustomerStatistics
    /** A list of the customer's subscription contracts. */
    subscriptionContracts: SubscriptionContractConnection
    /** A comma separated list of tags that have been added to the customer. */
    tags: Array<Scalars["String"]["output"]>
    /** Whether the customer is exempt from being charged taxes on their orders. */
    taxExempt: Scalars["Boolean"]["output"]
    /** The list of tax exemptions applied to the customer. */
    taxExemptions: Array<TaxExemption>
    /** The URL to unsubscribe the customer from the mailing list. */
    unsubscribeUrl: Scalars["URL"]["output"]
    /** The date and time when the customer was last updated. */
    updatedAt: Scalars["DateTime"]["output"]
    /**
     * Whether the email address is formatted correctly.
     *
     * Returns `true` when the email is formatted correctly and
     * belongs to an existing domain. This doesn't guarantee that
     * the email address actually exists.
     *
     */
    validEmailAddress: Scalars["Boolean"]["output"]
    /** Whether the customer has verified their email address. Defaults to `true` if the customer is created through the Shopify admin or API. */
    verifiedEmail: Scalars["Boolean"]["output"]
  }

/**
 * Represents information about a customer of the shop, such as the customer's contact details, their order
 * history, and whether they've agreed to receive marketing material by email.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type CustomerAddressesArgs = {
  first?: InputMaybe<Scalars["Int"]["input"]>
}

/**
 * Represents information about a customer of the shop, such as the customer's contact details, their order
 * history, and whether they've agreed to receive marketing material by email.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type CustomerEventsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<EventSortKeys>
}

/**
 * Represents information about a customer of the shop, such as the customer's contact details, their order
 * history, and whether they've agreed to receive marketing material by email.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type CustomerMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/**
 * Represents information about a customer of the shop, such as the customer's contact details, their order
 * history, and whether they've agreed to receive marketing material by email.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type CustomerMetafieldDefinitionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  pinnedStatus?: InputMaybe<MetafieldDefinitionPinnedStatus>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<MetafieldDefinitionSortKeys>
}

/**
 * Represents information about a customer of the shop, such as the customer's contact details, their order
 * history, and whether they've agreed to receive marketing material by email.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type CustomerMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents information about a customer of the shop, such as the customer's contact details, their order
 * history, and whether they've agreed to receive marketing material by email.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type CustomerOrdersArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<OrderSortKeys>
}

/**
 * Represents information about a customer of the shop, such as the customer's contact details, their order
 * history, and whether they've agreed to receive marketing material by email.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type CustomerPaymentMethodsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  showRevoked?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents information about a customer of the shop, such as the customer's contact details, their order
 * history, and whether they've agreed to receive marketing material by email.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type CustomerPrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/**
 * Represents information about a customer of the shop, such as the customer's contact details, their order
 * history, and whether they've agreed to receive marketing material by email.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type CustomerPrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents information about a customer of the shop, such as the customer's contact details, their order
 * history, and whether they've agreed to receive marketing material by email.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type CustomerSubscriptionContractsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Information about the shop's customer accounts. */
export type CustomerAccountsV2 = {
  __typename?: "CustomerAccountsV2"
  /** Indicates which version of customer accounts the merchant is using in online store and checkout. */
  customerAccountsVersion: CustomerAccountsVersion
  /** Login links are shown in online store and checkout. */
  loginLinksVisibleOnStorefrontAndCheckout: Scalars["Boolean"]["output"]
  /** Customers are required to log in to their account before checkout. */
  loginRequiredAtCheckout: Scalars["Boolean"]["output"]
  /** The root url for the customer accounts pages. */
  url?: Maybe<Scalars["URL"]["output"]>
}

/** The login redirection target for customer accounts. */
export enum CustomerAccountsVersion {
  /** The customer is redirected to the classic customer accounts login page. */
  Classic = "CLASSIC",
  /** The customer is redirected to the new customer accounts login page. */
  NewCustomerAccounts = "NEW_CUSTOMER_ACCOUNTS",
}

/** Return type for `customerAddTaxExemptions` mutation. */
export type CustomerAddTaxExemptionsPayload = {
  __typename?: "CustomerAddTaxExemptionsPayload"
  /** The updated customer. */
  customer?: Maybe<Customer>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Possible error codes that can be returned by `CustomerCancelDataErasureUserError`. */
export enum CustomerCancelDataErasureErrorCode {
  /** Customer does not exist. */
  DoesNotExist = "DOES_NOT_EXIST",
  /** Failed to cancel customer data erasure. */
  FailedToCancel = "FAILED_TO_CANCEL",
  /** Customer's data is not scheduled for erasure. */
  NotBeingErased = "NOT_BEING_ERASED",
}

/** Return type for `customerCancelDataErasure` mutation. */
export type CustomerCancelDataErasurePayload = {
  __typename?: "CustomerCancelDataErasurePayload"
  /** The ID of the customer whose pending data erasure has been cancelled. */
  customerId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CustomerCancelDataErasureUserError>
}

/** An error that occurs when cancelling a customer data erasure request. */
export type CustomerCancelDataErasureUserError = DisplayableError & {
  __typename?: "CustomerCancelDataErasureUserError"
  /** The error code. */
  code?: Maybe<CustomerCancelDataErasureErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/**
 * An auto-generated type for paginating through multiple Customers.
 *
 */
export type CustomerConnection = {
  __typename?: "CustomerConnection"
  /** A list of edges. */
  edges: Array<CustomerEdge>
  /** A list of the nodes contained in CustomerEdge. */
  nodes: Array<Customer>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * The source that collected the customer's consent to receive marketing materials.
 *
 */
export enum CustomerConsentCollectedFrom {
  /**
   * The customer consent was collected outside of Shopify.
   *
   */
  Other = "OTHER",
  /**
   * The customer consent was collected by Shopify.
   *
   */
  Shopify = "SHOPIFY",
}

/** Return type for `customerCreate` mutation. */
export type CustomerCreatePayload = {
  __typename?: "CustomerCreatePayload"
  /** The created customer. */
  customer?: Maybe<Customer>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Represents a card instrument for customer payment method. */
export type CustomerCreditCard = {
  __typename?: "CustomerCreditCard"
  /** The billing address of the card. */
  billingAddress?: Maybe<CustomerCreditCardBillingAddress>
  /** The brand of the card. */
  brand: Scalars["String"]["output"]
  /** Whether the card is about to expire. */
  expiresSoon: Scalars["Boolean"]["output"]
  /** The expiry month of the card. */
  expiryMonth: Scalars["Int"]["output"]
  /** The expiry year of the card. */
  expiryYear: Scalars["Int"]["output"]
  /** The card's BIN number. */
  firstDigits?: Maybe<Scalars["String"]["output"]>
  /** The payment method can be revoked if there are no active subscription contracts. */
  isRevocable: Scalars["Boolean"]["output"]
  /** The last 4 digits of the card. */
  lastDigits: Scalars["String"]["output"]
  /** The masked card number with only the last 4 digits displayed. */
  maskedNumber: Scalars["String"]["output"]
  /** The name of the card holder. */
  name: Scalars["String"]["output"]
  /** The source of the card if coming from a wallet such as Apple Pay. */
  source?: Maybe<Scalars["String"]["output"]>
  /** The last 4 digits of the Device Account Number. */
  virtualLastDigits?: Maybe<Scalars["String"]["output"]>
}

/** The billing address of a credit card payment instrument. */
export type CustomerCreditCardBillingAddress = {
  __typename?: "CustomerCreditCardBillingAddress"
  /** The first line of the address. Typically the street address or PO Box number. */
  address1?: Maybe<Scalars["String"]["output"]>
  /** The name of the city, district, village, or town. */
  city?: Maybe<Scalars["String"]["output"]>
  /** The name of the country. */
  country?: Maybe<Scalars["String"]["output"]>
  /**
   * The two-letter code for the country of the address.
   * For example, US.
   *
   */
  countryCode?: Maybe<CountryCode>
  /** The first name in the billing address. */
  firstName?: Maybe<Scalars["String"]["output"]>
  /** The last name in the billing address. */
  lastName?: Maybe<Scalars["String"]["output"]>
  /** The region of the address, such as the province, state, or district. */
  province?: Maybe<Scalars["String"]["output"]>
  /**
   * The two-letter code for the region.
   * For example, ON.
   *
   */
  provinceCode?: Maybe<Scalars["String"]["output"]>
  /** The zip or postal code of the address. */
  zip?: Maybe<Scalars["String"]["output"]>
}

/** The input fields to delete a customer. */
export type CustomerDeleteInput = {
  /** The ID of the customer to delete. */
  id: Scalars["ID"]["input"]
}

/** Return type for `customerDelete` mutation. */
export type CustomerDeletePayload = {
  __typename?: "CustomerDeletePayload"
  /** The ID of the deleted customer. */
  deletedCustomerId?: Maybe<Scalars["ID"]["output"]>
  /** The shop of the deleted customer. */
  shop: Shop
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * An auto-generated type which holds one Customer and a cursor during pagination.
 *
 */
export type CustomerEdge = {
  __typename?: "CustomerEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CustomerEdge. */
  node: Customer
}

/**
 * Represents an email address.
 *
 */
export type CustomerEmailAddress = {
  __typename?: "CustomerEmailAddress"
  /** The customer's default email address. */
  emailAddress: Scalars["String"]["output"]
  /** Whether the customer has subscribed to email marketing. */
  marketingState: CustomerEmailAddressMarketingState
  /** The URL to unsubscribe a member from all mailing lists. */
  marketingUnsubscribeUrl: Scalars["URL"]["output"]
  /**
   * Whether the customer has opted in to having their opened emails tracked.
   *
   */
  openTrackingLevel: CustomerEmailAddressOpenTrackingLevel
  /**
   * The URL that can be used to opt a customer in or out of email open tracking.
   *
   */
  openTrackingUrl: Scalars["URL"]["output"]
}

/**
 * Possible marketing states for the customer’s email address.
 *
 */
export enum CustomerEmailAddressMarketingState {
  /**
   * The customer’s email address marketing state is invalid.
   *
   */
  Invalid = "INVALID",
  /**
   * The customer is not subscribed to email marketing.
   *
   */
  NotSubscribed = "NOT_SUBSCRIBED",
  /**
   * The customer is in the process of subscribing to email marketing.
   *
   */
  Pending = "PENDING",
  /**
   * The customer is subscribed to email marketing.
   *
   */
  Subscribed = "SUBSCRIBED",
  /**
   * The customer is not subscribed to email marketing but was previously subscribed.
   *
   */
  Unsubscribed = "UNSUBSCRIBED",
}

/**
 * The different levels related to whether a customer has opted in to having their opened emails tracked.
 *
 */
export enum CustomerEmailAddressOpenTrackingLevel {
  /**
   * The customer has opted in to having their open emails tracked.
   *
   */
  OptedIn = "OPTED_IN",
  /**
   * The customer has opted out of having their open emails tracked.
   *
   */
  OptedOut = "OPTED_OUT",
  /**
   * The customer has not specified whether they want to opt in or out of having their open emails tracked.
   *
   */
  Unknown = "UNKNOWN",
}

/**
 * Information that describes when a customer consented to
 *         receiving marketing material by email.
 */
export type CustomerEmailMarketingConsentInput = {
  /**
   * The latest date and time when the customer consented or objected to
   *           receiving marketing material by email.
   */
  consentUpdatedAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The customer opt-in level at the time of subscribing to marketing material. */
  marketingOptInLevel?: InputMaybe<CustomerMarketingOptInLevel>
  /**
   * The current marketing state associated with the customer's email.
   *           If the customer doesn't have an email, then this field is `null`.
   */
  marketingState: CustomerEmailMarketingState
}

/**
 * The record of when a customer consented to receive marketing material by email.
 *
 */
export type CustomerEmailMarketingConsentState = {
  __typename?: "CustomerEmailMarketingConsentState"
  /**
   * The date and time at which the customer consented to receive marketing material by email.
   * The customer's consent state reflects the consent record with the most recent `consent_updated_at` date.
   * If no date is provided, then the date and time at which the consent information was sent is used.
   *
   */
  consentUpdatedAt?: Maybe<Scalars["DateTime"]["output"]>
  /**
   * The marketing subscription opt-in level, as described by the M3AAWG best practices guidelines,
   * that the customer gave when they consented to receive marketing material by email.
   *
   */
  marketingOptInLevel?: Maybe<CustomerMarketingOptInLevel>
  /** The current email marketing state for the customer. */
  marketingState: CustomerEmailMarketingState
}

/**
 * The input fields for the email consent information to update for a given customer ID.
 *
 */
export type CustomerEmailMarketingConsentUpdateInput = {
  /** The ID of the customer for which to update the email marketing consent information. The customer must have a unique email address associated to the record. If not, add the email address using the `customerUpdate` mutation first. */
  customerId: Scalars["ID"]["input"]
  /** The marketing consent information when the customer consented to receiving marketing material by email. */
  emailMarketingConsent: CustomerEmailMarketingConsentInput
}

/** Return type for `customerEmailMarketingConsentUpdate` mutation. */
export type CustomerEmailMarketingConsentUpdatePayload = {
  __typename?: "CustomerEmailMarketingConsentUpdatePayload"
  /**
   * The updated customer.
   *
   */
  customer?: Maybe<Customer>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CustomerEmailMarketingConsentUpdateUserError>
}

/** An error that occurs during the execution of `CustomerEmailMarketingConsentUpdate`. */
export type CustomerEmailMarketingConsentUpdateUserError = DisplayableError & {
  __typename?: "CustomerEmailMarketingConsentUpdateUserError"
  /** The error code. */
  code?: Maybe<CustomerEmailMarketingConsentUpdateUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `CustomerEmailMarketingConsentUpdateUserError`. */
export enum CustomerEmailMarketingConsentUpdateUserErrorCode {
  /** The input value isn't included in the list. */
  Inclusion = "INCLUSION",
  /** Unexpected internal error happened. */
  InternalError = "INTERNAL_ERROR",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** Missing a required argument. */
  MissingArgument = "MISSING_ARGUMENT",
}

/**
 * The possible email marketing states for a customer.
 *
 */
export enum CustomerEmailMarketingState {
  /**
   * The customer’s email address marketing state is invalid.
   *
   */
  Invalid = "INVALID",
  /**
   * The customer isn't subscribed to email marketing.
   *
   */
  NotSubscribed = "NOT_SUBSCRIBED",
  /**
   * The customer is in the process of subscribing to email marketing.
   *
   */
  Pending = "PENDING",
  /**
   * The customer's personal data is erased. This value is internally-set and read-only.
   *
   */
  Redacted = "REDACTED",
  /**
   * The customer is subscribed to email marketing.
   *
   */
  Subscribed = "SUBSCRIBED",
  /**
   * The customer isn't currently subscribed to email marketing but was previously subscribed.
   *
   */
  Unsubscribed = "UNSUBSCRIBED",
}

/** Return type for `customerGenerateAccountActivationUrl` mutation. */
export type CustomerGenerateAccountActivationUrlPayload = {
  __typename?: "CustomerGenerateAccountActivationUrlPayload"
  /** The generated account activation URL. */
  accountActivationUrl?: Maybe<Scalars["URL"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The input fields and values to use when creating or updating a customer. */
export type CustomerInput = {
  /** The addresses for a customer. */
  addresses?: InputMaybe<Array<MailingAddressInput>>
  /** The unique email address of the customer. */
  email?: InputMaybe<Scalars["String"]["input"]>
  /**
   * Information that describes when the customer consented to receiving marketing
   *         material by email. The `email` field is required when creating a customer with email marketing
   *         consent information.
   */
  emailMarketingConsent?: InputMaybe<CustomerEmailMarketingConsentInput>
  /** The customer's first name. */
  firstName?: InputMaybe<Scalars["String"]["input"]>
  /** The ID of the customer to update. */
  id?: InputMaybe<Scalars["ID"]["input"]>
  /** The customer's last name. */
  lastName?: InputMaybe<Scalars["String"]["input"]>
  /** The customer's locale. */
  locale?: InputMaybe<Scalars["String"]["input"]>
  /** Additional metafields to associate to the customer. */
  metafields?: InputMaybe<Array<MetafieldInput>>
  /** A note about the customer. */
  note?: InputMaybe<Scalars["String"]["input"]>
  /** The unique phone number for the customer. */
  phone?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The marketing consent information when the customer consented to receiving marketing
   *         material by SMS. The `phone` field is required when creating a customer with SMS
   *         marketing consent information.
   */
  smsMarketingConsent?: InputMaybe<CustomerSmsMarketingConsentInput>
  /**
   * A list of tags to associate with the customer. Can be an array or a comma-separated list. Example values: `["tag1", "tag2", "tag3"]`, `"tag1, tag2, tag3"`
   *
   * Updating `tags` overwrites any existing tags that were previously added to the customer. To add new tags without overwriting
   * existing tags, use the [tagsAdd](https://shopify.dev/api/admin-graphql/latest/mutations/tagsadd)
   * mutation.
   *
   */
  tags?: InputMaybe<Array<Scalars["String"]["input"]>>
  /** Whether the customer is exempt from paying taxes on their order. */
  taxExempt?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The list of tax exemptions to apply to the customer. */
  taxExemptions?: InputMaybe<Array<TaxExemption>>
}

/** Represents a customer's visiting activities on a shop's online store. */
export type CustomerJourney = {
  __typename?: "CustomerJourney"
  /** The position of the current order within the customer's order history. */
  customerOrderIndex: Scalars["Int"]["output"]
  /** The amount of days between first session and order creation date. First session represents first session since the last order, or first session within the 30 day attribution window, if more than 30 days has passed since the last order. */
  daysToConversion: Scalars["Int"]["output"]
  /** The customer's first session going into the shop. */
  firstVisit: CustomerVisit
  /** The last session before an order is made. */
  lastVisit?: Maybe<CustomerVisit>
  /** Events preceding a customer order, such as shop sessions. */
  moments: Array<CustomerMoment>
}

/** Represents a customer's visiting activities on a shop's online store. */
export type CustomerJourneySummary = {
  __typename?: "CustomerJourneySummary"
  /** The position of the current order within the customer's order history. Test orders aren't included. */
  customerOrderIndex?: Maybe<Scalars["Int"]["output"]>
  /** The number of days between the first session and the order creation date. The first session represents the first session since the last order, or the first session within the 30 day attribution window, if more than 30 days have passed since the last order. */
  daysToConversion?: Maybe<Scalars["Int"]["output"]>
  /** The customer's first session going into the shop. */
  firstVisit?: Maybe<CustomerVisit>
  /** The last session before an order is made. */
  lastVisit?: Maybe<CustomerVisit>
  /** The events preceding a customer's order, such as shop sessions. */
  moments?: Maybe<CustomerMomentConnection>
  /** The total number of customer moments associated with this order. Returns null if the order is still in the process of being attributed. */
  momentsCount?: Maybe<Scalars["Int"]["output"]>
  /** Whether the attributed sessions for the order have been created yet. */
  ready: Scalars["Boolean"]["output"]
}

/** Represents a customer's visiting activities on a shop's online store. */
export type CustomerJourneySummaryMomentsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * The possible values for the marketing subscription opt-in level enabled at the time the customer consented to receive marketing information.
 *
 * The levels are defined by [the M3AAWG best practices guideline
 *   document](https://www.m3aawg.org/sites/maawg/files/news/M3AAWG_Senders_BCP_Ver3-2015-02.pdf).
 *
 */
export enum CustomerMarketingOptInLevel {
  /**
   * After providing their information, the customer receives a confirmation and is required to
   * perform a intermediate step before receiving marketing information.
   *
   */
  ConfirmedOptIn = "CONFIRMED_OPT_IN",
  /**
   * After providing their information, the customer receives marketing information without any
   * intermediate steps.
   *
   */
  SingleOptIn = "SINGLE_OPT_IN",
  /**
   * The customer receives marketing information but how they were opted in is unknown.
   *
   */
  Unknown = "UNKNOWN",
}

/** The error blocking a customer merge. */
export type CustomerMergeError = {
  __typename?: "CustomerMergeError"
  /** The list of fields preventing the customer from being merged. */
  errorFields: Array<CustomerMergeErrorFieldType>
  /** The customer merge error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `CustomerMergeUserError`. */
export enum CustomerMergeErrorCode {
  /** The customer cannot be merged because it has associated gift cards. */
  CustomerHasGiftCards = "CUSTOMER_HAS_GIFT_CARDS",
  /** An internal error occurred. */
  InternalError = "INTERNAL_ERROR",
  /** The customer cannot be merged. */
  InvalidCustomer = "INVALID_CUSTOMER",
  /** The customer ID is invalid. */
  InvalidCustomerId = "INVALID_CUSTOMER_ID",
  /** The customer is missing the attribute requested for override. */
  MissingOverrideAttribute = "MISSING_OVERRIDE_ATTRIBUTE",
  /** The override attribute is invalid. */
  OverrideAttributeInvalid = "OVERRIDE_ATTRIBUTE_INVALID",
}

/**
 * The types of the hard blockers preventing a customer from being merged to another customer.
 *
 */
export enum CustomerMergeErrorFieldType {
  /** The customer is a company contact. */
  CompanyContact = "COMPANY_CONTACT",
  /** The customer has payment methods. */
  CustomerPaymentMethods = "CUSTOMER_PAYMENT_METHODS",
  /** The customer does not exist. */
  DeletedAt = "DELETED_AT",
  /** The customer has gift cards. */
  GiftCards = "GIFT_CARDS",
  /** The customer has a merge in progress. */
  MergeInProgress = "MERGE_IN_PROGRESS",
  /** The customer has a multipass identifier. */
  MultipassIdentifier = "MULTIPASS_IDENTIFIER",
  /** The customer has a pending data request. */
  PendingDataRequest = "PENDING_DATA_REQUEST",
  /** The customer has a pending or completed redaction. */
  RedactedAt = "REDACTED_AT",
  /** The customer has a subscription history. */
  Subscriptions = "SUBSCRIPTIONS",
}

/**
 * The input fields to override default customer merge rules.
 *
 */
export type CustomerMergeOverrideFields = {
  /**
   * The ID of the customer whose default address will be kept.
   *
   */
  customerIdOfDefaultAddressToKeep?: InputMaybe<Scalars["ID"]["input"]>
  /**
   * The ID of the customer whose email will be kept.
   *
   */
  customerIdOfEmailToKeep?: InputMaybe<Scalars["ID"]["input"]>
  /**
   * The ID of the customer whose first name will be kept.
   *
   */
  customerIdOfFirstNameToKeep?: InputMaybe<Scalars["ID"]["input"]>
  /**
   * The ID of the customer whose last name will be kept.
   *
   */
  customerIdOfLastNameToKeep?: InputMaybe<Scalars["ID"]["input"]>
  /**
   * The ID of the customer whose phone number will be kept.
   *
   */
  customerIdOfPhoneNumberToKeep?: InputMaybe<Scalars["ID"]["input"]>
  /** The note to keep. */
  note?: InputMaybe<Scalars["String"]["input"]>
  /** The tags to keep. */
  tags?: InputMaybe<Array<Scalars["String"]["input"]>>
}

/** Return type for `customerMerge` mutation. */
export type CustomerMergePayload = {
  __typename?: "CustomerMergePayload"
  /** The asynchronous job for merging the customers. */
  job?: Maybe<Job>
  /** The ID of the customer resulting from the merge. */
  resultingCustomerId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CustomerMergeUserError>
}

/** A preview of the results of a customer merge request. */
export type CustomerMergePreview = {
  __typename?: "CustomerMergePreview"
  /** The fields that can be used to override the default fields. */
  alternateFields?: Maybe<CustomerMergePreviewAlternateFields>
  /** The fields that will block the merge if the two customers are merged. */
  blockingFields?: Maybe<CustomerMergePreviewBlockingFields>
  /** The errors blocking the customer merge. */
  customerMergeErrors?: Maybe<Array<CustomerMergeError>>
  /** The fields that will be kept if the two customers are merged. */
  defaultFields?: Maybe<CustomerMergePreviewDefaultFields>
  /** The resulting customer ID if the two customers are merged. */
  resultingCustomerId?: Maybe<Scalars["ID"]["output"]>
}

/** The fields that can be used to override the default fields. */
export type CustomerMergePreviewAlternateFields = {
  __typename?: "CustomerMergePreviewAlternateFields"
  /** The default address of a customer. */
  defaultAddress?: Maybe<MailingAddress>
  /** The email state of a customer. */
  email?: Maybe<CustomerEmailAddress>
  /** The first name of a customer. */
  firstName?: Maybe<Scalars["String"]["output"]>
  /** The last name of a customer. */
  lastName?: Maybe<Scalars["String"]["output"]>
  /** The phone number state of a customer. */
  phoneNumber?: Maybe<CustomerPhoneNumber>
}

/**
 * The blocking fields of a customer merge preview. These fields will block customer merge unless edited.
 *
 */
export type CustomerMergePreviewBlockingFields = {
  __typename?: "CustomerMergePreviewBlockingFields"
  /**
   * The merged note resulting from a customer merge. The merged note is over the 5000 character limit and will block customer merge.
   *
   */
  note?: Maybe<Scalars["String"]["output"]>
  /**
   * The merged tags resulting from a customer merge. The merged tags are over the 250 limit and will block customer merge.
   *
   */
  tags: Array<Scalars["String"]["output"]>
}

/** The fields that will be kept as part of a customer merge preview. */
export type CustomerMergePreviewDefaultFields = {
  __typename?: "CustomerMergePreviewDefaultFields"
  /** The merged addresses resulting from a customer merge. */
  addresses: MailingAddressConnection
  /** The default address resulting from a customer merge. */
  defaultAddress?: Maybe<MailingAddress>
  /** The total number of customer-specific discounts resulting from a customer merge. */
  discountNodeCount: Scalars["UnsignedInt64"]["output"]
  /** The merged customer-specific discounts resulting from a customer merge. */
  discountNodes: DiscountNodeConnection
  /** The full name of the customer, based on the values for `first_name` and `last_name`. If `first_name` and `last_name` aren't available, then this field falls back to the customer's email address. If the customer's email isn't available, then this field falls back to the customer's phone number. */
  displayName: Scalars["String"]["output"]
  /** The total number of merged draft orders. */
  draftOrderCount: Scalars["UnsignedInt64"]["output"]
  /** The merged draft orders resulting from a customer merge. */
  draftOrders: DraftOrderConnection
  /** The email state of a customer. */
  email?: Maybe<CustomerEmailAddress>
  /** The first name resulting from a customer merge. */
  firstName?: Maybe<Scalars["String"]["output"]>
  /** The total number of merged gift cards. */
  giftCardCount: Scalars["UnsignedInt64"]["output"]
  /** The merged gift cards resulting from a customer merge. */
  giftCards: GiftCardConnection
  /** The last name resulting from a customer merge. */
  lastName?: Maybe<Scalars["String"]["output"]>
  /** The total number of merged metafields. */
  metafieldCount: Scalars["UnsignedInt64"]["output"]
  /** The merged note resulting from a customer merge. */
  note?: Maybe<Scalars["String"]["output"]>
  /** The total number of merged orders. */
  orderCount: Scalars["UnsignedInt64"]["output"]
  /** The merged orders resulting from a customer merge. */
  orders: OrderConnection
  /** The phone number state of a customer. */
  phoneNumber?: Maybe<CustomerPhoneNumber>
  /** The merged tags resulting from a customer merge. */
  tags: Array<Scalars["String"]["output"]>
}

/** The fields that will be kept as part of a customer merge preview. */
export type CustomerMergePreviewDefaultFieldsAddressesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** The fields that will be kept as part of a customer merge preview. */
export type CustomerMergePreviewDefaultFieldsDiscountNodesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<DiscountSortKeys>
}

/** The fields that will be kept as part of a customer merge preview. */
export type CustomerMergePreviewDefaultFieldsDraftOrdersArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<DraftOrderSortKeys>
}

/** The fields that will be kept as part of a customer merge preview. */
export type CustomerMergePreviewDefaultFieldsGiftCardsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<GiftCardSortKeys>
}

/** The fields that will be kept as part of a customer merge preview. */
export type CustomerMergePreviewDefaultFieldsOrdersArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<OrderSortKeys>
}

/**
 * A merge request for merging two customers.
 *
 */
export type CustomerMergeRequest = {
  __typename?: "CustomerMergeRequest"
  /** The merge errors that occurred during the customer merge request. */
  customerMergeErrors: Array<CustomerMergeError>
  /** The UUID of the merge job. */
  jobId?: Maybe<Scalars["ID"]["output"]>
  /** The ID of the customer resulting from the merge. */
  resultingCustomerId: Scalars["ID"]["output"]
  /** The status of the customer merge request. */
  status: CustomerMergeRequestStatus
}

/**
 * The status of the customer merge request.
 *
 */
export enum CustomerMergeRequestStatus {
  /**
   * The customer merge request has been completed.
   *
   */
  Completed = "COMPLETED",
  /**
   * The customer merge request has failed.
   *
   */
  Failed = "FAILED",
  /**
   * The customer merge request is currently in progress.
   *
   */
  InProgress = "IN_PROGRESS",
  /**
   * The customer merge request has been requested.
   *
   */
  Requested = "REQUESTED",
}

/** An error that occurs while merging two customers. */
export type CustomerMergeUserError = DisplayableError & {
  __typename?: "CustomerMergeUserError"
  /** The error code. */
  code?: Maybe<CustomerMergeErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/**
 * An object that represents whether a customer can be merged with another customer.
 *
 */
export type CustomerMergeable = {
  __typename?: "CustomerMergeable"
  /**
   * The list of fields preventing the customer from being merged.
   *
   */
  errorFields: Array<CustomerMergeErrorFieldType>
  /**
   * Whether the customer can be merged with another customer.
   *
   */
  isMergeable: Scalars["Boolean"]["output"]
  /**
   * The merge request if one is currently in progress.
   *
   */
  mergeInProgress?: Maybe<CustomerMergeRequest>
  /**
   * The reason why the customer can't be merged with another customer.
   *
   */
  reason?: Maybe<Scalars["String"]["output"]>
}

/** Represents a session preceding an order, often used for building a timeline of events leading to an order. */
export type CustomerMoment = {
  /** The date and time when the customer's session occurred. */
  occurredAt: Scalars["DateTime"]["output"]
}

/**
 * An auto-generated type for paginating through multiple CustomerMoments.
 *
 */
export type CustomerMomentConnection = {
  __typename?: "CustomerMomentConnection"
  /** A list of edges. */
  edges: Array<CustomerMomentEdge>
  /** A list of the nodes contained in CustomerMomentEdge. */
  nodes: Array<CustomerMoment>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one CustomerMoment and a cursor during pagination.
 *
 */
export type CustomerMomentEdge = {
  __typename?: "CustomerMomentEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CustomerMomentEdge. */
  node: CustomerMoment
}

/** All possible instruments for CustomerPaymentMethods. */
export type CustomerPaymentInstrument = CustomerCreditCard | CustomerPaypalBillingAgreement | CustomerShopPayAgreement

/** The billing address of a payment instrument. */
export type CustomerPaymentInstrumentBillingAddress = {
  __typename?: "CustomerPaymentInstrumentBillingAddress"
  /** The first line of the address. Typically the street address or PO Box number. */
  address1?: Maybe<Scalars["String"]["output"]>
  /** The name of the city, district, village, or town. */
  city?: Maybe<Scalars["String"]["output"]>
  /** The name of the country. */
  country?: Maybe<Scalars["String"]["output"]>
  /**
   * The two-letter code for the country of the address.
   * For example, US.
   *
   */
  countryCode?: Maybe<CountryCode>
  /** The name of the buyer of the address. */
  name?: Maybe<Scalars["String"]["output"]>
  /** The region of the address, such as the province, state, or district. */
  province?: Maybe<Scalars["String"]["output"]>
  /**
   * The two-letter code for the region.
   * For example, ON.
   *
   */
  provinceCode?: Maybe<Scalars["String"]["output"]>
  /** The zip or postal code of the address. */
  zip?: Maybe<Scalars["String"]["output"]>
}

/** A customer's payment method. */
export type CustomerPaymentMethod = Node & {
  __typename?: "CustomerPaymentMethod"
  /** The customer to whom the payment method belongs. */
  customer?: Maybe<Customer>
  /** The ID of this payment method. */
  id: Scalars["ID"]["output"]
  /** The instrument for this payment method. */
  instrument?: Maybe<CustomerPaymentInstrument>
  /** The time that the payment method was revoked. */
  revokedAt?: Maybe<Scalars["DateTime"]["output"]>
  /** The revocation reason for this payment method. */
  revokedReason?: Maybe<CustomerPaymentMethodRevocationReason>
  /** List Subscription Contracts. */
  subscriptionContracts: SubscriptionContractConnection
}

/** A customer's payment method. */
export type CustomerPaymentMethodSubscriptionContractsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple CustomerPaymentMethods.
 *
 */
export type CustomerPaymentMethodConnection = {
  __typename?: "CustomerPaymentMethodConnection"
  /** A list of edges. */
  edges: Array<CustomerPaymentMethodEdge>
  /** A list of the nodes contained in CustomerPaymentMethodEdge. */
  nodes: Array<CustomerPaymentMethod>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `customerPaymentMethodCreateFromDuplicationData` mutation. */
export type CustomerPaymentMethodCreateFromDuplicationDataPayload = {
  __typename?: "CustomerPaymentMethodCreateFromDuplicationDataPayload"
  /** The customer payment method. */
  customerPaymentMethod?: Maybe<CustomerPaymentMethod>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CustomerPaymentMethodCreateFromDuplicationDataUserError>
}

/** An error that occurs during the execution of `CustomerPaymentMethodCreateFromDuplicationData`. */
export type CustomerPaymentMethodCreateFromDuplicationDataUserError = DisplayableError & {
  __typename?: "CustomerPaymentMethodCreateFromDuplicationDataUserError"
  /** The error code. */
  code?: Maybe<CustomerPaymentMethodCreateFromDuplicationDataUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `CustomerPaymentMethodCreateFromDuplicationDataUserError`. */
export enum CustomerPaymentMethodCreateFromDuplicationDataUserErrorCode {
  /** Customer doesn't exist. */
  CustomerDoesNotExist = "CUSTOMER_DOES_NOT_EXIST",
  /** Invalid encrypted duplication data. */
  InvalidEncryptedDuplicationData = "INVALID_ENCRYPTED_DUPLICATION_DATA",
  /** Too many requests. */
  TooManyRequests = "TOO_MANY_REQUESTS",
}

/** Return type for `customerPaymentMethodCreditCardCreate` mutation. */
export type CustomerPaymentMethodCreditCardCreatePayload = {
  __typename?: "CustomerPaymentMethodCreditCardCreatePayload"
  /** The customer payment method. */
  customerPaymentMethod?: Maybe<CustomerPaymentMethod>
  /** If the card verification result is processing. When this is true, customer_payment_method will be null. */
  processing?: Maybe<Scalars["Boolean"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `customerPaymentMethodCreditCardUpdate` mutation. */
export type CustomerPaymentMethodCreditCardUpdatePayload = {
  __typename?: "CustomerPaymentMethodCreditCardUpdatePayload"
  /** The customer payment method. */
  customerPaymentMethod?: Maybe<CustomerPaymentMethod>
  /** If the card verification result is processing. When this is true, customer_payment_method will be null. */
  processing?: Maybe<Scalars["Boolean"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * An auto-generated type which holds one CustomerPaymentMethod and a cursor during pagination.
 *
 */
export type CustomerPaymentMethodEdge = {
  __typename?: "CustomerPaymentMethodEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CustomerPaymentMethodEdge. */
  node: CustomerPaymentMethod
}

/** Return type for `customerPaymentMethodGetDuplicationData` mutation. */
export type CustomerPaymentMethodGetDuplicationDataPayload = {
  __typename?: "CustomerPaymentMethodGetDuplicationDataPayload"
  /** The encrypted data from the payment method to be duplicated. */
  encryptedDuplicationData?: Maybe<Scalars["String"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CustomerPaymentMethodGetDuplicationDataUserError>
}

/** An error that occurs during the execution of `CustomerPaymentMethodGetDuplicationData`. */
export type CustomerPaymentMethodGetDuplicationDataUserError = DisplayableError & {
  __typename?: "CustomerPaymentMethodGetDuplicationDataUserError"
  /** The error code. */
  code?: Maybe<CustomerPaymentMethodGetDuplicationDataUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `CustomerPaymentMethodGetDuplicationDataUserError`. */
export enum CustomerPaymentMethodGetDuplicationDataUserErrorCode {
  /** Customer doesn't exist. */
  CustomerDoesNotExist = "CUSTOMER_DOES_NOT_EXIST",
  /** Invalid payment instrument. */
  InvalidInstrument = "INVALID_INSTRUMENT",
  /** Must be targeted to another shop in the same organization. */
  InvalidOrganizationShop = "INVALID_ORGANIZATION_SHOP",
  /** Payment method doesn't exist. */
  PaymentMethodDoesNotExist = "PAYMENT_METHOD_DOES_NOT_EXIST",
  /** Target shop cannot be the same as the source. */
  SameShop = "SAME_SHOP",
  /** Too many requests. */
  TooManyRequests = "TOO_MANY_REQUESTS",
}

/** Return type for `customerPaymentMethodGetUpdateUrl` mutation. */
export type CustomerPaymentMethodGetUpdateUrlPayload = {
  __typename?: "CustomerPaymentMethodGetUpdateUrlPayload"
  /** The URL to redirect the customer to update the payment method. */
  updatePaymentMethodUrl?: Maybe<Scalars["URL"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CustomerPaymentMethodGetUpdateUrlUserError>
}

/** An error that occurs during the execution of `CustomerPaymentMethodGetUpdateUrl`. */
export type CustomerPaymentMethodGetUpdateUrlUserError = DisplayableError & {
  __typename?: "CustomerPaymentMethodGetUpdateUrlUserError"
  /** The error code. */
  code?: Maybe<CustomerPaymentMethodGetUpdateUrlUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `CustomerPaymentMethodGetUpdateUrlUserError`. */
export enum CustomerPaymentMethodGetUpdateUrlUserErrorCode {
  /** Customer doesn't exist. */
  CustomerDoesNotExist = "CUSTOMER_DOES_NOT_EXIST",
  /** Invalid payment instrument. */
  InvalidInstrument = "INVALID_INSTRUMENT",
  /** Payment method doesn't exist. */
  PaymentMethodDoesNotExist = "PAYMENT_METHOD_DOES_NOT_EXIST",
  /** Too many requests. */
  TooManyRequests = "TOO_MANY_REQUESTS",
}

/** Return type for `customerPaymentMethodPaypalBillingAgreementCreate` mutation. */
export type CustomerPaymentMethodPaypalBillingAgreementCreatePayload = {
  __typename?: "CustomerPaymentMethodPaypalBillingAgreementCreatePayload"
  /** The customer payment method. */
  customerPaymentMethod?: Maybe<CustomerPaymentMethod>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CustomerPaymentMethodUserError>
}

/** Return type for `customerPaymentMethodPaypalBillingAgreementUpdate` mutation. */
export type CustomerPaymentMethodPaypalBillingAgreementUpdatePayload = {
  __typename?: "CustomerPaymentMethodPaypalBillingAgreementUpdatePayload"
  /** The customer payment method. */
  customerPaymentMethod?: Maybe<CustomerPaymentMethod>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CustomerPaymentMethodUserError>
}

/** Return type for `customerPaymentMethodRemoteCreate` mutation. */
export type CustomerPaymentMethodRemoteCreatePayload = {
  __typename?: "CustomerPaymentMethodRemoteCreatePayload"
  /** The customer payment method. */
  customerPaymentMethod?: Maybe<CustomerPaymentMethod>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CustomerPaymentMethodRemoteUserError>
}

/** Return type for `customerPaymentMethodRemoteCreditCardCreate` mutation. */
export type CustomerPaymentMethodRemoteCreditCardCreatePayload = {
  __typename?: "CustomerPaymentMethodRemoteCreditCardCreatePayload"
  /** The customer payment method. */
  customerPaymentMethod?: Maybe<CustomerPaymentMethod>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CustomerPaymentMethodUserError>
}

/**
 * The input fields for a remote gateway payment method, only one remote reference permitted.
 *
 */
export type CustomerPaymentMethodRemoteInput = {
  /**
   * The input fields for a remote authorize net customer profile.
   *
   */
  authorizeNetCustomerPaymentProfile?: InputMaybe<RemoteAuthorizeNetCustomerPaymentProfileInput>
  /** The input fields for a remote Braintree customer profile. */
  braintreePaymentMethod?: InputMaybe<RemoteBraintreePaymentMethodInput>
  /**
   * Input containing the fields for a remote stripe payment method.
   *
   */
  stripePaymentMethod?: InputMaybe<RemoteStripePaymentMethodInput>
}

/** Represents an error in the input of a mutation. */
export type CustomerPaymentMethodRemoteUserError = DisplayableError & {
  __typename?: "CustomerPaymentMethodRemoteUserError"
  /** The error code. */
  code?: Maybe<CustomerPaymentMethodRemoteUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `CustomerPaymentMethodRemoteUserError`. */
export enum CustomerPaymentMethodRemoteUserErrorCode {
  /** Authorize.net is not enabled for subscriptions. */
  AuthorizeNetNotEnabledForSubscriptions = "AUTHORIZE_NET_NOT_ENABLED_FOR_SUBSCRIPTIONS",
  /** Braintree is not enabled for subscriptions. */
  BraintreeNotEnabledForSubscriptions = "BRAINTREE_NOT_ENABLED_FOR_SUBSCRIPTIONS",
  /** Exactly one remote reference is required. */
  ExactlyOneRemoteReferenceRequired = "EXACTLY_ONE_REMOTE_REFERENCE_REQUIRED",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** The input value needs to be blank. */
  Present = "PRESENT",
  /** The input value is already taken. */
  Taken = "TAKEN",
}

/** The revocation reason types for a customer payment method. */
export enum CustomerPaymentMethodRevocationReason {
  /** The Authorize.net payment gateway is not enabled. */
  AuthorizeNetGatewayNotEnabled = "AUTHORIZE_NET_GATEWAY_NOT_ENABLED",
  /** Authorize.net did not return any payment methods. Make sure that the correct Authorize.net account is linked. */
  AuthorizeNetReturnedNoPaymentMethod = "AUTHORIZE_NET_RETURNED_NO_PAYMENT_METHOD",
  /** Failed to contact Braintree API. */
  BraintreeApiAuthenticationError = "BRAINTREE_API_AUTHENTICATION_ERROR",
  /** The Braintree payment gateway is not enabled. */
  BraintreeGatewayNotEnabled = "BRAINTREE_GATEWAY_NOT_ENABLED",
  /** The Braintree payment method type should be a credit card or Apple Pay card. */
  BraintreePaymentMethodNotCard = "BRAINTREE_PAYMENT_METHOD_NOT_CARD",
  /** Braintree returned no payment methods. Make sure the correct Braintree account is linked. */
  BraintreeReturnedNoPaymentMethod = "BRAINTREE_RETURNED_NO_PAYMENT_METHOD",
  /** The credit card failed to update. */
  FailedToUpdateCreditCard = "FAILED_TO_UPDATE_CREDIT_CARD",
  /** The payment method was manually revoked. */
  ManuallyRevoked = "MANUALLY_REVOKED",
  /** The payment method was replaced with an existing payment method. The associated contracts have been migrated to the other payment method. */
  Merged = "MERGED",
  /** Failed to contact the Stripe API. */
  StripeApiAuthenticationError = "STRIPE_API_AUTHENTICATION_ERROR",
  /** Invalid request. Failed to retrieve payment method from Stripe. */
  StripeApiInvalidRequestError = "STRIPE_API_INVALID_REQUEST_ERROR",
  /** The Stripe payment gateway is not enabled. */
  StripeGatewayNotEnabled = "STRIPE_GATEWAY_NOT_ENABLED",
  /** The Stripe payment method type should be card. */
  StripePaymentMethodNotCard = "STRIPE_PAYMENT_METHOD_NOT_CARD",
  /** Stripe did not return any payment methods. Make sure that the correct Stripe account is linked. */
  StripeReturnedNoPaymentMethod = "STRIPE_RETURNED_NO_PAYMENT_METHOD",
}

/** Return type for `customerPaymentMethodRevoke` mutation. */
export type CustomerPaymentMethodRevokePayload = {
  __typename?: "CustomerPaymentMethodRevokePayload"
  /** The ID of the revoked customer payment method. */
  revokedCustomerPaymentMethodId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `customerPaymentMethodSendUpdateEmail` mutation. */
export type CustomerPaymentMethodSendUpdateEmailPayload = {
  __typename?: "CustomerPaymentMethodSendUpdateEmailPayload"
  /** The customer to whom an update payment method email was sent. */
  customer?: Maybe<Customer>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Represents an error in the input of a mutation. */
export type CustomerPaymentMethodUserError = DisplayableError & {
  __typename?: "CustomerPaymentMethodUserError"
  /** The error code. */
  code?: Maybe<CustomerPaymentMethodUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `CustomerPaymentMethodUserError`. */
export enum CustomerPaymentMethodUserErrorCode {
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** The input value needs to be blank. */
  Present = "PRESENT",
  /** The input value is already taken. */
  Taken = "TAKEN",
}

/** Represents a PayPal instrument for customer payment method. */
export type CustomerPaypalBillingAgreement = {
  __typename?: "CustomerPaypalBillingAgreement"
  /** The billing address of this payment method. */
  billingAddress?: Maybe<CustomerPaymentInstrumentBillingAddress>
  /** Whether the PayPal billing agreement is inactive. */
  inactive: Scalars["Boolean"]["output"]
  /** Whether the payment method can be revoked.The payment method can be revoked if there are no active subscription contracts. */
  isRevocable: Scalars["Boolean"]["output"]
  /** The customers's PayPal account email address. */
  paypalAccountEmail?: Maybe<Scalars["String"]["output"]>
}

/**
 * A phone number.
 *
 */
export type CustomerPhoneNumber = {
  __typename?: "CustomerPhoneNumber"
  /** Whether the customer has subscribed to SMS marketing material. */
  marketingState: CustomerSmsMarketingState
  /** A customer's phone number. */
  phoneNumber: Scalars["String"]["output"]
}

/** The valid tiers for the predicted spend of a customer with a shop. */
export enum CustomerPredictedSpendTier {
  /**
   * The customer's spending is predicted to be in the top spending range for the shop in the following year.
   *
   */
  High = "HIGH",
  /**
   * The customer's spending is predicted to be zero, or in the lowest spending range for the shop in the following year.
   *
   */
  Low = "LOW",
  /**
   * The customer's spending is predicted to be in the normal spending range for the shop in the following year.
   *
   */
  Medium = "MEDIUM",
}

/**
 * The possible product subscription states for a customer, as defined by the customer's subscription contracts.
 *
 */
export enum CustomerProductSubscriberStatus {
  /**
   * The customer has at least one active subscription contract.
   *
   */
  Active = "ACTIVE",
  /**
   * The customer's last subscription contract was cancelled and there are no other active or paused
   * subscription contracts.
   *
   */
  Cancelled = "CANCELLED",
  /**
   * The customer's last subscription contract expired and there are no other active or paused
   * subscription contracts.
   *
   */
  Expired = "EXPIRED",
  /**
   * The customer's last subscription contract failed and there are no other active or paused
   * subscription contracts.
   *
   */
  Failed = "FAILED",
  /**
   * The customer has never had a subscription contract.
   *
   */
  NeverSubscribed = "NEVER_SUBSCRIBED",
  /**
   * The customer has at least one paused subscription contract and there are no other active
   * subscription contracts.
   *
   */
  Paused = "PAUSED",
}

/** Return type for `customerRemoveTaxExemptions` mutation. */
export type CustomerRemoveTaxExemptionsPayload = {
  __typename?: "CustomerRemoveTaxExemptionsPayload"
  /** The updated customer. */
  customer?: Maybe<Customer>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `customerReplaceTaxExemptions` mutation. */
export type CustomerReplaceTaxExemptionsPayload = {
  __typename?: "CustomerReplaceTaxExemptionsPayload"
  /** The updated customer. */
  customer?: Maybe<Customer>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Possible error codes that can be returned by `CustomerRequestDataErasureUserError`. */
export enum CustomerRequestDataErasureErrorCode {
  /** Customer does not exist. */
  DoesNotExist = "DOES_NOT_EXIST",
  /** Failed to request customer data erasure. */
  FailedToRequest = "FAILED_TO_REQUEST",
}

/** Return type for `customerRequestDataErasure` mutation. */
export type CustomerRequestDataErasurePayload = {
  __typename?: "CustomerRequestDataErasurePayload"
  /** The ID of the customer that will be erased. */
  customerId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CustomerRequestDataErasureUserError>
}

/** An error that occurs when requesting a customer data erasure. */
export type CustomerRequestDataErasureUserError = DisplayableError & {
  __typename?: "CustomerRequestDataErasureUserError"
  /** The error code. */
  code?: Maybe<CustomerRequestDataErasureErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** The set of valid sort keys for the CustomerSavedSearch query. */
export enum CustomerSavedSearchSortKeys {
  /** Sort by the `id` value. */
  Id = "ID",
  /** Sort by the `name` value. */
  Name = "NAME",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
}

/**
 * The member of a segment.
 *
 */
export type CustomerSegmentMember = HasMetafields & {
  __typename?: "CustomerSegmentMember"
  /** The total amount of money that the member has spent on orders. */
  amountSpent?: Maybe<MoneyV2>
  /** The member's default address. */
  defaultAddress?: Maybe<MailingAddress>
  /** The member's default email address. */
  defaultEmailAddress?: Maybe<CustomerEmailAddress>
  /** The member's default phone number. */
  defaultPhoneNumber?: Maybe<CustomerPhoneNumber>
  /** The full name of the member, which is based on the values of the `first_name` and `last_name` fields. If the member's first name and last name aren't available, then the customer's email address is used. If the customer's email address isn't available, then the customer's phone number is used. */
  displayName: Scalars["String"]["output"]
  /** The member's first name. */
  firstName?: Maybe<Scalars["String"]["output"]>
  /** The member’s ID. */
  id: Scalars["ID"]["output"]
  /** The member's last name. */
  lastName?: Maybe<Scalars["String"]["output"]>
  /** The ID of the member's most recent order. */
  lastOrderId?: Maybe<Scalars["ID"]["output"]>
  /** Whether the customer can be merged with another customer. */
  mergeable: CustomerMergeable
  /** Returns a metafield by namespace and key that belongs to the resource. */
  metafield?: Maybe<Metafield>
  /** List of metafields that belong to the resource. */
  metafields: MetafieldConnection
  /** A note about the member. */
  note?: Maybe<Scalars["String"]["output"]>
  /** The total number of orders that the member has made. */
  numberOfOrders?: Maybe<Scalars["UnsignedInt64"]["output"]>
  /**
   * Returns a private metafield by namespace and key that belongs to the resource.
   * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
   * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
   *
   */
  privateMetafield?: Maybe<PrivateMetafield>
  /**
   * List of private metafields that belong to the resource.
   * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
   * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
   *
   */
  privateMetafields: PrivateMetafieldConnection
}

/**
 * The member of a segment.
 *
 */
export type CustomerSegmentMemberMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/**
 * The member of a segment.
 *
 */
export type CustomerSegmentMemberMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * The member of a segment.
 *
 */
export type CustomerSegmentMemberPrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/**
 * The member of a segment.
 *
 */
export type CustomerSegmentMemberPrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** The connection type for the `CustomerSegmentMembers` object. */
export type CustomerSegmentMemberConnection = {
  __typename?: "CustomerSegmentMemberConnection"
  /** A list of edges. */
  edges: Array<CustomerSegmentMemberEdge>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
  /** The statistics for a given segment. */
  statistics: SegmentStatistics
  /** The total number of members in a given segment. */
  totalCount: Scalars["Int"]["output"]
}

/**
 * An auto-generated type which holds one CustomerSegmentMember and a cursor during pagination.
 *
 */
export type CustomerSegmentMemberEdge = {
  __typename?: "CustomerSegmentMemberEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CustomerSegmentMemberEdge. */
  node: CustomerSegmentMember
}

/** A job to determine a list of members, such as customers, that are associated with an individual segment. */
export type CustomerSegmentMembersQuery = JobResult &
  Node & {
    __typename?: "CustomerSegmentMembersQuery"
    /** The current total number of members in a given segment. */
    currentCount: Scalars["Int"]["output"]
    /** This indicates if the job is still queued or has been run. */
    done: Scalars["Boolean"]["output"]
    /** A globally-unique ID that's returned when running an asynchronous mutation. */
    id: Scalars["ID"]["output"]
  }

/** Return type for `customerSegmentMembersQueryCreate` mutation. */
export type CustomerSegmentMembersQueryCreatePayload = {
  __typename?: "CustomerSegmentMembersQueryCreatePayload"
  /** The newly created customer segment members query. */
  customerSegmentMembersQuery?: Maybe<CustomerSegmentMembersQuery>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CustomerSegmentMembersQueryUserError>
}

/** The input fields and values for creating a customer segment members query. */
export type CustomerSegmentMembersQueryInput = {
  /** The query that's used to filter the members. The query is composed of a combination of conditions on facts about customers such as `email_subscription_status = 'SUBSCRIBED'` with [this syntax](https://shopify.dev/api/shopifyql/segment-query-language-reference). */
  query?: InputMaybe<Scalars["String"]["input"]>
  /** Reverse the order of the list. The sorting behaviour defaults to ascending order. */
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The ID of the segment. */
  segmentId?: InputMaybe<Scalars["ID"]["input"]>
  /** Sort the list by a given key. */
  sortKey?: InputMaybe<Scalars["String"]["input"]>
}

/**
 * Represents a customer segment members query custom error.
 *
 */
export type CustomerSegmentMembersQueryUserError = DisplayableError & {
  __typename?: "CustomerSegmentMembersQueryUserError"
  /** The error code. */
  code?: Maybe<CustomerSegmentMembersQueryUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `CustomerSegmentMembersQueryUserError`. */
export enum CustomerSegmentMembersQueryUserErrorCode {
  /** The input value is invalid. */
  Invalid = "INVALID",
}

/** Represents a Shop Pay card instrument for customer payment method. */
export type CustomerShopPayAgreement = {
  __typename?: "CustomerShopPayAgreement"
  /** The billing address of the card. */
  billingAddress?: Maybe<CustomerCreditCardBillingAddress>
  /** Whether the card is about to expire. */
  expiresSoon: Scalars["Boolean"]["output"]
  /** The expiry month of the card. */
  expiryMonth: Scalars["Int"]["output"]
  /** The expiry year of the card. */
  expiryYear: Scalars["Int"]["output"]
  /** Whether the Shop Pay billing agreement is inactive. */
  inactive: Scalars["Boolean"]["output"]
  /** The payment method can be revoked if there are no active subscription contracts. */
  isRevocable: Scalars["Boolean"]["output"]
  /** The last 4 digits of the card. */
  lastDigits: Scalars["String"]["output"]
  /** The masked card number with only the last 4 digits displayed. */
  maskedNumber: Scalars["String"]["output"]
  /** The name of the card holder. */
  name: Scalars["String"]["output"]
}

/** An error that occurs during execution of an SMS marketing consent mutation. */
export type CustomerSmsMarketingConsentError = DisplayableError & {
  __typename?: "CustomerSmsMarketingConsentError"
  /** The error code. */
  code?: Maybe<CustomerSmsMarketingConsentErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `CustomerSmsMarketingConsentError`. */
export enum CustomerSmsMarketingConsentErrorCode {
  /** The input value isn't included in the list. */
  Inclusion = "INCLUSION",
  /** Unexpected internal error happened. */
  InternalError = "INTERNAL_ERROR",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** Missing a required argument. */
  MissingArgument = "MISSING_ARGUMENT",
}

/**
 * The marketing consent information when the customer consented to
 *         receiving marketing material by SMS.
 */
export type CustomerSmsMarketingConsentInput = {
  /**
   * The date and time when the customer consented to receive marketing material by SMS.
   * If no date is provided, then the date and time when the consent information was sent is used.
   *
   */
  consentUpdatedAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /**
   * The marketing subscription opt-in level that was set when the customer consented to receive marketing information.
   *
   */
  marketingOptInLevel?: InputMaybe<CustomerMarketingOptInLevel>
  /** The current SMS marketing state for the customer. */
  marketingState: CustomerSmsMarketingState
}

/**
 * The record of when a customer consented to receive marketing material by SMS.
 *
 * The customer's consent state reflects the record with the most recent date when consent was updated.
 *
 */
export type CustomerSmsMarketingConsentState = {
  __typename?: "CustomerSmsMarketingConsentState"
  /** The source from which the SMS marketing information for the customer was collected. */
  consentCollectedFrom?: Maybe<CustomerConsentCollectedFrom>
  /**
   * The date and time when the customer consented to receive marketing material by SMS.
   * If no date is provided, then the date and time when the consent information was sent is used.
   *
   */
  consentUpdatedAt?: Maybe<Scalars["DateTime"]["output"]>
  /**
   * The marketing subscription opt-in level that was set when the customer consented to receive marketing information.
   *
   */
  marketingOptInLevel: CustomerMarketingOptInLevel
  /** The current SMS marketing state for the customer. */
  marketingState: CustomerSmsMarketingState
}

/**
 * The input fields for updating SMS marketing consent information for a given customer ID.
 *
 */
export type CustomerSmsMarketingConsentUpdateInput = {
  /** The ID of the customer to update the SMS marketing consent information for. The customer must have a unique phone number associated to the record. If not, add the phone number using the `customerUpdate` mutation first. */
  customerId: Scalars["ID"]["input"]
  /** The marketing consent information when the customer consented to receiving marketing material by SMS. */
  smsMarketingConsent: CustomerSmsMarketingConsentInput
}

/** Return type for `customerSmsMarketingConsentUpdate` mutation. */
export type CustomerSmsMarketingConsentUpdatePayload = {
  __typename?: "CustomerSmsMarketingConsentUpdatePayload"
  /**
   * The updated customer.
   *
   */
  customer?: Maybe<Customer>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<CustomerSmsMarketingConsentError>
}

/**
 * The valid SMS marketing states for a customer’s phone number.
 *
 */
export enum CustomerSmsMarketingState {
  /**
   * The customer hasn't subscribed to SMS marketing.
   *
   */
  NotSubscribed = "NOT_SUBSCRIBED",
  /**
   * The customer is in the process of subscribing to SMS marketing.
   *
   */
  Pending = "PENDING",
  /**
   * The customer's personal data is erased. This value is internally-set and read-only.
   *
   */
  Redacted = "REDACTED",
  /**
   * The customer is subscribed to SMS marketing.
   *
   */
  Subscribed = "SUBSCRIBED",
  /**
   * The customer isn't currently subscribed to SMS marketing but was previously subscribed.
   *
   */
  Unsubscribed = "UNSUBSCRIBED",
}

/** The set of valid sort keys for the Customer query. */
export enum CustomerSortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /** Sort by the `last_order_date` value. */
  LastOrderDate = "LAST_ORDER_DATE",
  /** Sort by the `location` value. */
  Location = "LOCATION",
  /** Sort by the `name` value. */
  Name = "NAME",
  /** Sort by the `orders_count` value. */
  OrdersCount = "ORDERS_COUNT",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `total_spent` value. */
  TotalSpent = "TOTAL_SPENT",
  /** Sort by the `updated_at` value. */
  UpdatedAt = "UPDATED_AT",
}

/** The valid values for the state of a customer's account with a shop. */
export enum CustomerState {
  /**
   * The customer declined the email invite to create an account.
   *
   */
  Declined = "DECLINED",
  /**
   * The customer doesn't have an active account. Customer accounts can be disabled from the Shopify admin at any time.
   *
   */
  Disabled = "DISABLED",
  /**
   * The customer has created an account.
   *
   */
  Enabled = "ENABLED",
  /**
   * The customer has received an email invite to create an account.
   *
   */
  Invited = "INVITED",
}

/** A customer's computed statistics. */
export type CustomerStatistics = {
  __typename?: "CustomerStatistics"
  /** The predicted spend tier of a customer with a shop. */
  predictedSpendTier?: Maybe<CustomerPredictedSpendTier>
}

/** Return type for `customerUpdateDefaultAddress` mutation. */
export type CustomerUpdateDefaultAddressPayload = {
  __typename?: "CustomerUpdateDefaultAddressPayload"
  /** The customer whose address was updated. */
  customer?: Maybe<Customer>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `customerUpdate` mutation. */
export type CustomerUpdatePayload = {
  __typename?: "CustomerUpdatePayload"
  /** The updated customer. */
  customer?: Maybe<Customer>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Represents a customer's session visiting a shop's online store, including information about the marketing activity attributed to starting the session. */
export type CustomerVisit = CustomerMoment &
  Node & {
    __typename?: "CustomerVisit"
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** URL of the first page the customer landed on for the session. */
    landingPage?: Maybe<Scalars["URL"]["output"]>
    /** Landing page information with URL linked in HTML. For example, the first page the customer visited was store.myshopify.com/products/1. */
    landingPageHtml?: Maybe<Scalars["HTML"]["output"]>
    /**
     * Represent actions taken by an app, on behalf of a merchant,
     * to market Shopify resources such as products, collections, and discounts.
     *
     */
    marketingEvent?: Maybe<MarketingEvent>
    /** The date and time when the customer's session occurred. */
    occurredAt: Scalars["DateTime"]["output"]
    /**
     * Marketing referral code from the link that the customer clicked to visit the store.
     * Supports the following URL attributes: _ref_, _source_, or _r_.
     * For example, if the URL is myshopifystore.com/products/slide?ref=j2tj1tn2, then this value is j2tj1tn2.
     *
     */
    referralCode?: Maybe<Scalars["String"]["output"]>
    /** Referral information with URLs linked in HTML. */
    referralInfoHtml: Scalars["FormattedString"]["output"]
    /**
     * Webpage where the customer clicked a link that sent them to the online store.
     * For example, _https://randomblog.com/page1_ or _android-app://com.google.android.gm_.
     *
     */
    referrerUrl?: Maybe<Scalars["URL"]["output"]>
    /**
     * Source from which the customer visited the store, such as a platform (Facebook, Google), email, direct,
     * a website domain, QR code, or unknown.
     *
     */
    source: Scalars["String"]["output"]
    /** Describes the source explicitly for first or last session. */
    sourceDescription?: Maybe<Scalars["String"]["output"]>
    /** Type of marketing tactic. */
    sourceType?: Maybe<MarketingTactic>
    /** A set of UTM parameters gathered from the URL parameters of the referrer. */
    utmParameters?: Maybe<UtmParameters>
  }

/**
 * This type returns the information about the product and product variant from a customer visit.
 *
 */
export type CustomerVisitProductInfo = {
  __typename?: "CustomerVisitProductInfo"
  /** The product information. If `null`, then the product was deleted from the store. */
  product?: Maybe<Product>
  /** The quantity of the product that the customer requested. */
  quantity: Scalars["Int"]["output"]
  /** The product variant information, if the product variant exists. */
  variant?: Maybe<ProductVariant>
}

/**
 * An auto-generated type for paginating through multiple CustomerVisitProductInfos.
 *
 */
export type CustomerVisitProductInfoConnection = {
  __typename?: "CustomerVisitProductInfoConnection"
  /** A list of edges. */
  edges: Array<CustomerVisitProductInfoEdge>
  /** A list of the nodes contained in CustomerVisitProductInfoEdge. */
  nodes: Array<CustomerVisitProductInfo>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one CustomerVisitProductInfo and a cursor during pagination.
 *
 */
export type CustomerVisitProductInfoEdge = {
  __typename?: "CustomerVisitProductInfoEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of CustomerVisitProductInfoEdge. */
  node: CustomerVisitProductInfo
}

/** Days of the week from Monday to Sunday. */
export enum DayOfTheWeek {
  /** Friday. */
  Friday = "FRIDAY",
  /** Monday. */
  Monday = "MONDAY",
  /** Saturday. */
  Saturday = "SATURDAY",
  /** Sunday. */
  Sunday = "SUNDAY",
  /** Thursday. */
  Thursday = "THURSDAY",
  /** Tuesday. */
  Tuesday = "TUESDAY",
  /** Wednesday. */
  Wednesday = "WEDNESDAY",
}

/**
 * A token that delegates a set of scopes from the original permission.
 *
 * To learn more about creating delegate access tokens, refer to
 * [Delegate OAuth access tokens to subsystems]
 * (https://shopify.dev/apps/auth/oauth/delegate-access-tokens).
 *
 */
export type DelegateAccessToken = {
  __typename?: "DelegateAccessToken"
  /** The list of permissions associated with the token. */
  accessScopes: Array<Scalars["String"]["output"]>
  /** The issued delegate access token. */
  accessToken: Scalars["String"]["output"]
  /** The date and time when the delegate access token was created. */
  createdAt: Scalars["DateTime"]["output"]
}

/** Return type for `delegateAccessTokenCreate` mutation. */
export type DelegateAccessTokenCreatePayload = {
  __typename?: "DelegateAccessTokenCreatePayload"
  /** The delegate access token. */
  delegateAccessToken?: Maybe<DelegateAccessToken>
  /** The user's shop. */
  shop: Shop
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DelegateAccessTokenCreateUserError>
}

/** An error that occurs during the execution of `DelegateAccessTokenCreate`. */
export type DelegateAccessTokenCreateUserError = DisplayableError & {
  __typename?: "DelegateAccessTokenCreateUserError"
  /** The error code. */
  code?: Maybe<DelegateAccessTokenCreateUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `DelegateAccessTokenCreateUserError`. */
export enum DelegateAccessTokenCreateUserErrorCode {
  /** The parent access token can't be a delegate token. */
  DelegateAccessToken = "DELEGATE_ACCESS_TOKEN",
  /** The access scope can't be empty. */
  EmptyAccessScope = "EMPTY_ACCESS_SCOPE",
  /** The delegate token can't expire after the parent token. */
  ExpiresAfterParent = "EXPIRES_AFTER_PARENT",
  /** The expires_in value must be greater than 0. */
  NegativeExpiresIn = "NEGATIVE_EXPIRES_IN",
  /** Persistence failed. */
  PersistenceFailed = "PERSISTENCE_FAILED",
  /** The parent access token can't have a refresh token. */
  RefreshToken = "REFRESH_TOKEN",
  /** Unknown scopes. */
  UnknownScopes = "UNKNOWN_SCOPES",
}

/** Return type for `delegateAccessTokenDestroy` mutation. */
export type DelegateAccessTokenDestroyPayload = {
  __typename?: "DelegateAccessTokenDestroyPayload"
  /** The user's shop. */
  shop: Shop
  /** The status of the delegate access token destroy operation. Returns true if successful. */
  status?: Maybe<Scalars["Boolean"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DelegateAccessTokenDestroyUserError>
}

/** An error that occurs during the execution of `DelegateAccessTokenDestroy`. */
export type DelegateAccessTokenDestroyUserError = DisplayableError & {
  __typename?: "DelegateAccessTokenDestroyUserError"
  /** The error code. */
  code?: Maybe<DelegateAccessTokenDestroyUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `DelegateAccessTokenDestroyUserError`. */
export enum DelegateAccessTokenDestroyUserErrorCode {
  /** Access denied. */
  AccessDenied = "ACCESS_DENIED",
  /** Access token not found. */
  AccessTokenNotFound = "ACCESS_TOKEN_NOT_FOUND",
  /** Cannot delete parent access token. */
  CanOnlyDeleteDelegateTokens = "CAN_ONLY_DELETE_DELEGATE_TOKENS",
  /** Persistence failed. */
  PersistenceFailed = "PERSISTENCE_FAILED",
}

/** The input fields for a delegate access token. */
export type DelegateAccessTokenInput = {
  /** The list of scopes that will be delegated to the new access token. */
  delegateAccessScope: Array<Scalars["String"]["input"]>
  /** The amount of time, in seconds, after which the delegate access token is no longer valid. */
  expiresIn?: InputMaybe<Scalars["Int"]["input"]>
}

/**
 * Deletion events chronicle the destruction of resources (e.g. products and collections).
 * Once deleted, the deletion event is the only trace of the original's existence,
 * as the resource itself has been removed and can no longer be accessed.
 *
 */
export type DeletionEvent = {
  __typename?: "DeletionEvent"
  /** The date and time when the deletion event for the related resource was generated. */
  occurredAt: Scalars["DateTime"]["output"]
  /** The ID of the resource that was deleted. */
  subjectId: Scalars["ID"]["output"]
  /** The type of resource that was deleted. */
  subjectType: DeletionEventSubjectType
}

/**
 * An auto-generated type for paginating through multiple DeletionEvents.
 *
 */
export type DeletionEventConnection = {
  __typename?: "DeletionEventConnection"
  /** A list of edges. */
  edges: Array<DeletionEventEdge>
  /** A list of the nodes contained in DeletionEventEdge. */
  nodes: Array<DeletionEvent>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one DeletionEvent and a cursor during pagination.
 *
 */
export type DeletionEventEdge = {
  __typename?: "DeletionEventEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DeletionEventEdge. */
  node: DeletionEvent
}

/** The set of valid sort keys for the DeletionEvent query. */
export enum DeletionEventSortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
}

/** The supported subject types of deletion events. */
export enum DeletionEventSubjectType {
  Collection = "COLLECTION",
  Product = "PRODUCT",
}

/** A shipping service and a list of countries that the service is available for. */
export type DeliveryAvailableService = {
  __typename?: "DeliveryAvailableService"
  /** The countries the service provider ships to. */
  countries: DeliveryCountryCodesOrRestOfWorld
  /** The name of the service. */
  name: Scalars["String"]["output"]
}

/**
 * Represents a branded promise presented to buyers.
 *
 */
export type DeliveryBrandedPromise = {
  __typename?: "DeliveryBrandedPromise"
  /** The handle of the branded promise.  For example: `shop_promise`. */
  handle: Scalars["String"]["output"]
  /** The name of the branded promise.  For example: `Shop Promise`. */
  name: Scalars["String"]["output"]
}

/** A shipping service provider or a carrier account. */
export type DeliveryCarrierService = Node & {
  __typename?: "DeliveryCarrierService"
  /** The list of services offered for given destinations. */
  availableServicesForCountries: Array<DeliveryAvailableService>
  /** The properly formatted name of the shipping service provider, ready to display. */
  formattedName?: Maybe<Scalars["String"]["output"]>
  /** The logo of the service provider. */
  icon: Image
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The name of the shipping service provider. */
  name?: Maybe<Scalars["String"]["output"]>
}

/** A shipping service provider or a carrier account. */
export type DeliveryCarrierServiceAvailableServicesForCountriesArgs = {
  countryCodes?: InputMaybe<Array<CountryCode>>
  origins?: InputMaybe<Array<Scalars["ID"]["input"]>>
  restOfWorld: Scalars["Boolean"]["input"]
}

/** A carrier service and the associated list of shop locations. */
export type DeliveryCarrierServiceAndLocations = {
  __typename?: "DeliveryCarrierServiceAndLocations"
  /** The carrier service. */
  carrierService: DeliveryCarrierService
  /** The list of locations that support this carrier service. */
  locations: Array<Location>
}

/** A condition that must pass for a delivery method definition to be applied to an order. */
export type DeliveryCondition = Node & {
  __typename?: "DeliveryCondition"
  /** The value (weight or price) that the condition field is compared to. */
  conditionCriteria: DeliveryConditionCriteria
  /** The field to compare the criterion value against, using the operator. */
  field: DeliveryConditionField
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The operator to compare the field and criterion value. */
  operator: DeliveryConditionOperator
}

/** The value (weight or price) that the condition field is compared to. */
export type DeliveryConditionCriteria = MoneyV2 | Weight

/** The field type that the condition will be applied to. */
export enum DeliveryConditionField {
  /** The condition will check against the total price of the order. */
  TotalPrice = "TOTAL_PRICE",
  /** The condition will check against the total weight of the order. */
  TotalWeight = "TOTAL_WEIGHT",
}

/** The operator to use to determine if the condition passes. */
export enum DeliveryConditionOperator {
  /** The condition will check whether the field is greater than or equal to the criterion. */
  GreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO",
  /** The condition will check if the field is less than or equal to the criterion. */
  LessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO",
}

/** A country that is used to define a shipping zone. */
export type DeliveryCountry = Node & {
  __typename?: "DeliveryCountry"
  /**
   * A two-letter country code in ISO 3166-1 alpha-2 standard.
   * It also includes a flag indicating whether the country should be
   * a part of the 'Rest Of World' shipping zone.
   *
   */
  code: DeliveryCountryCodeOrRestOfWorld
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The full name of the country. */
  name: Scalars["String"]["output"]
  /** The list of regions associated with this country. */
  provinces: Array<DeliveryProvince>
  /** The translated name of the country. The translation returned is based on the system's locale. */
  translatedName: Scalars["String"]["output"]
}

/** The country details and the associated shipping zone. */
export type DeliveryCountryAndZone = {
  __typename?: "DeliveryCountryAndZone"
  /** The country details. */
  country: DeliveryCountry
  /** The name of the shipping zone. */
  zone: Scalars["String"]["output"]
}

/**
 * The country code and whether the country is a part of the 'Rest Of World' shipping zone.
 *
 */
export type DeliveryCountryCodeOrRestOfWorld = {
  __typename?: "DeliveryCountryCodeOrRestOfWorld"
  /** The country code in the ISO 3166-1 alpha-2 format. */
  countryCode?: Maybe<CountryCode>
  /** Whether the country is a part of the 'Rest of World' shipping zone. */
  restOfWorld: Scalars["Boolean"]["output"]
}

/**
 * The list of country codes and information whether the countries
 * are a part of the 'Rest Of World' shipping zone.
 *
 */
export type DeliveryCountryCodesOrRestOfWorld = {
  __typename?: "DeliveryCountryCodesOrRestOfWorld"
  /** List of applicable country codes in the ISO 3166-1 alpha-2 format. */
  countryCodes: Array<CountryCode>
  /** Whether the countries are a part of the 'Rest of World' shipping zone. */
  restOfWorld: Scalars["Boolean"]["output"]
}

/** The input fields to specify a country. */
export type DeliveryCountryInput = {
  /** The country code of the country in the ISO 3166-1 alpha-2 format. */
  code?: InputMaybe<CountryCode>
  /** Associate all available provinces with this country. */
  includeAllProvinces?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The regions associated with this country. */
  provinces?: InputMaybe<Array<DeliveryProvinceInput>>
  /** Whether the country is a part of the 'Rest of World' shipping zone. */
  restOfWorld?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** A delivery customization. */
export type DeliveryCustomization = HasMetafieldDefinitions &
  HasMetafields &
  Node & {
    __typename?: "DeliveryCustomization"
    /** The enabled status of the delivery customization. */
    enabled: Scalars["Boolean"]["output"]
    /** The error history on the most recent version of the delivery customization. */
    errorHistory?: Maybe<FunctionsErrorHistory>
    /** The ID of the Shopify Function implementing the delivery customization. */
    functionId: Scalars["String"]["output"]
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafield definitions. */
    metafieldDefinitions: MetafieldDefinitionConnection
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
    /** The Shopify Function implementing the delivery customization. */
    shopifyFunction: ShopifyFunction
    /** The title of the delivery customization. */
    title: Scalars["String"]["output"]
  }

/** A delivery customization. */
export type DeliveryCustomizationMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/** A delivery customization. */
export type DeliveryCustomizationMetafieldDefinitionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  pinnedStatus?: InputMaybe<MetafieldDefinitionPinnedStatus>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<MetafieldDefinitionSortKeys>
}

/** A delivery customization. */
export type DeliveryCustomizationMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** A delivery customization. */
export type DeliveryCustomizationPrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/** A delivery customization. */
export type DeliveryCustomizationPrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Return type for `deliveryCustomizationActivation` mutation. */
export type DeliveryCustomizationActivationPayload = {
  __typename?: "DeliveryCustomizationActivationPayload"
  /** The IDs of the updated delivery customizations. */
  ids?: Maybe<Array<Scalars["String"]["output"]>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DeliveryCustomizationError>
}

/**
 * An auto-generated type for paginating through multiple DeliveryCustomizations.
 *
 */
export type DeliveryCustomizationConnection = {
  __typename?: "DeliveryCustomizationConnection"
  /** A list of edges. */
  edges: Array<DeliveryCustomizationEdge>
  /** A list of the nodes contained in DeliveryCustomizationEdge. */
  nodes: Array<DeliveryCustomization>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `deliveryCustomizationCreate` mutation. */
export type DeliveryCustomizationCreatePayload = {
  __typename?: "DeliveryCustomizationCreatePayload"
  /** Returns the created delivery customization. */
  deliveryCustomization?: Maybe<DeliveryCustomization>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DeliveryCustomizationError>
}

/** Return type for `deliveryCustomizationDelete` mutation. */
export type DeliveryCustomizationDeletePayload = {
  __typename?: "DeliveryCustomizationDeletePayload"
  /** Returns the deleted delivery customization ID. */
  deletedId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DeliveryCustomizationError>
}

/**
 * An auto-generated type which holds one DeliveryCustomization and a cursor during pagination.
 *
 */
export type DeliveryCustomizationEdge = {
  __typename?: "DeliveryCustomizationEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DeliveryCustomizationEdge. */
  node: DeliveryCustomization
}

/** An error that occurs during the execution of a delivery customization mutation. */
export type DeliveryCustomizationError = DisplayableError & {
  __typename?: "DeliveryCustomizationError"
  /** The error code. */
  code?: Maybe<DeliveryCustomizationErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `DeliveryCustomizationError`. */
export enum DeliveryCustomizationErrorCode {
  /** Shop must be on a Shopify Plus plan to activate functions from a custom app. */
  CustomAppFunctionNotEligible = "CUSTOM_APP_FUNCTION_NOT_ELIGIBLE",
  /** Shop must be on a Shopify Plus plan to activate delivery customizations from a custom app. */
  DeliveryCustomizationFunctionNotEligible = "DELIVERY_CUSTOMIZATION_FUNCTION_NOT_ELIGIBLE",
  /** Delivery customization not found. */
  DeliveryCustomizationNotFound = "DELIVERY_CUSTOMIZATION_NOT_FOUND",
  /** Function does not implement the required interface for this delivery customization. */
  FunctionDoesNotImplement = "FUNCTION_DOES_NOT_IMPLEMENT",
  /** Function ID cannot be changed. */
  FunctionIdCannotBeChanged = "FUNCTION_ID_CANNOT_BE_CHANGED",
  /** Function not found. */
  FunctionNotFound = "FUNCTION_NOT_FOUND",
  /** Function is pending deletion. */
  FunctionPendingDeletion = "FUNCTION_PENDING_DELETION",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** Could not create or update metafields. */
  InvalidMetafields = "INVALID_METAFIELDS",
  /** Maximum delivery customizations are already enabled. */
  MaximumActiveDeliveryCustomizations = "MAXIMUM_ACTIVE_DELIVERY_CUSTOMIZATIONS",
  /** Required input field must be present. */
  RequiredInputField = "REQUIRED_INPUT_FIELD",
  /** Unauthorized app scope. */
  UnauthorizedAppScope = "UNAUTHORIZED_APP_SCOPE",
}

/** The input fields to create and update a delivery customization. */
export type DeliveryCustomizationInput = {
  /** The enabled status of the delivery customization. */
  enabled?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The ID of the function providing the delivery customization. */
  functionId?: InputMaybe<Scalars["String"]["input"]>
  /** Additional metafields to associate to the delivery customization. */
  metafields?: InputMaybe<Array<MetafieldInput>>
  /** The title of the delivery customization. */
  title?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `deliveryCustomizationUpdate` mutation. */
export type DeliveryCustomizationUpdatePayload = {
  __typename?: "DeliveryCustomizationUpdatePayload"
  /** Returns the updated delivery customization. */
  deliveryCustomization?: Maybe<DeliveryCustomization>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DeliveryCustomizationError>
}

/** Whether the shop is blocked from converting to full multi-location delivery profiles mode. If the shop is blocked, then the blocking reasons are also returned. */
export type DeliveryLegacyModeBlocked = {
  __typename?: "DeliveryLegacyModeBlocked"
  /** Whether the shop can convert to full multi-location delivery profiles mode. */
  blocked: Scalars["Boolean"]["output"]
  /** The reasons why the shop is blocked from converting to full multi-location delivery profiles mode. */
  reasons?: Maybe<Array<DeliveryLegacyModeBlockedReason>>
}

/** Reasons the shop is blocked from converting to full multi-location delivery profiles mode. */
export enum DeliveryLegacyModeBlockedReason {
  /**
   * Multi-Location mode is disabled. The shop can't convert to full multi-location delivery profiles mode.
   * @deprecated All shops are now using multi-location mode.
   */
  MultiLocationDisabled = "MULTI_LOCATION_DISABLED",
  /** There are no locations for this store that can fulfill online orders. */
  NoLocationsFulfillingOnlineOrders = "NO_LOCATIONS_FULFILLING_ONLINE_ORDERS",
}

/** Local pickup settings associated with a location. */
export type DeliveryLocalPickupSettings = {
  __typename?: "DeliveryLocalPickupSettings"
  /** Additional instructions or information related to the local pickup. */
  instructions: Scalars["String"]["output"]
  /** The estimated pickup time to show customers at checkout. */
  pickupTime: DeliveryLocalPickupTime
}

/** Possible pickup time values that a location enabled for local pickup can have. */
export enum DeliveryLocalPickupTime {
  /** Usually ready in 5+ days. */
  FiveOrMoreDays = "FIVE_OR_MORE_DAYS",
  /** Usually ready in 4 hours. */
  FourHours = "FOUR_HOURS",
  /** Usually ready in 1 hour. */
  OneHour = "ONE_HOUR",
  /** Usually ready in 24 hours. */
  TwentyFourHours = "TWENTY_FOUR_HOURS",
  /** Usually ready in 2 hours. */
  TwoHours = "TWO_HOURS",
  /** Usually ready in 2-4 days. */
  TwoToFourDays = "TWO_TO_FOUR_DAYS",
}

/**
 * A location group is a collection of locations. They share zones and delivery methods across delivery
 * profiles.
 *
 */
export type DeliveryLocationGroup = Node & {
  __typename?: "DeliveryLocationGroup"
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** A list of all locations that are part of this location group. */
  locations: LocationConnection
  /** A count of all locations that are part of this location group. */
  locationsCount: Scalars["Int"]["output"]
}

/**
 * A location group is a collection of locations. They share zones and delivery methods across delivery
 * profiles.
 *
 */
export type DeliveryLocationGroupLocationsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  includeInactive?: InputMaybe<Scalars["Boolean"]["input"]>
  includeLegacy?: InputMaybe<Scalars["Boolean"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<LocationSortKeys>
}

/** Links a location group with a zone and the associated method definitions. */
export type DeliveryLocationGroupZone = {
  __typename?: "DeliveryLocationGroupZone"
  /** The number of method definitions for the zone. */
  methodDefinitionCounts: DeliveryMethodDefinitionCounts
  /** The method definitions associated to a zone and location group. */
  methodDefinitions: DeliveryMethodDefinitionConnection
  /** The zone associated to a location group. */
  zone: DeliveryZone
}

/** Links a location group with a zone and the associated method definitions. */
export type DeliveryLocationGroupZoneMethodDefinitionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  eligible?: InputMaybe<Scalars["Boolean"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<MethodDefinitionSortKeys>
  type?: InputMaybe<DeliveryMethodDefinitionType>
}

/**
 * An auto-generated type for paginating through multiple DeliveryLocationGroupZones.
 *
 */
export type DeliveryLocationGroupZoneConnection = {
  __typename?: "DeliveryLocationGroupZoneConnection"
  /** A list of edges. */
  edges: Array<DeliveryLocationGroupZoneEdge>
  /** A list of the nodes contained in DeliveryLocationGroupZoneEdge. */
  nodes: Array<DeliveryLocationGroupZone>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one DeliveryLocationGroupZone and a cursor during pagination.
 *
 */
export type DeliveryLocationGroupZoneEdge = {
  __typename?: "DeliveryLocationGroupZoneEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DeliveryLocationGroupZoneEdge. */
  node: DeliveryLocationGroupZone
}

/** The input fields for a delivery zone associated to a location group and profile. */
export type DeliveryLocationGroupZoneInput = {
  /** A list of countries to associate with the zone. */
  countries?: InputMaybe<Array<DeliveryCountryInput>>
  /** A globally-unique ID of the zone. */
  id?: InputMaybe<Scalars["ID"]["input"]>
  /** A list of method definitions to create. */
  methodDefinitionsToCreate?: InputMaybe<Array<DeliveryMethodDefinitionInput>>
  /** A list of method definitions to update. */
  methodDefinitionsToUpdate?: InputMaybe<Array<DeliveryMethodDefinitionInput>>
  /** The name of the zone. */
  name?: InputMaybe<Scalars["String"]["input"]>
}

/** The input fields for a local pickup setting associated with a location. */
export type DeliveryLocationLocalPickupEnableInput = {
  /** The instructions for the local pickup. */
  instructions?: InputMaybe<Scalars["String"]["input"]>
  /** The ID of the location associated with the location setting. */
  locationId: Scalars["ID"]["input"]
  /** The time of the local pickup. */
  pickupTime: DeliveryLocalPickupTime
}

/** Represents an error that happened when changing local pickup settings for a location. */
export type DeliveryLocationLocalPickupSettingsError = DisplayableError & {
  __typename?: "DeliveryLocationLocalPickupSettingsError"
  /** The error code. */
  code?: Maybe<DeliveryLocationLocalPickupSettingsErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `DeliveryLocationLocalPickupSettingsError`. */
export enum DeliveryLocationLocalPickupSettingsErrorCode {
  /** Provided locationId is not for an active location belonging to this store. */
  ActiveLocationNotFound = "ACTIVE_LOCATION_NOT_FOUND",
  /** An error occurred while changing the local pickup settings. */
  GenericError = "GENERIC_ERROR",
}

/** The delivery method used by a fulfillment order. */
export type DeliveryMethod = Node & {
  __typename?: "DeliveryMethod"
  /** The branded promise that was presented to the buyer during checkout.  For example: Shop Promise. */
  brandedPromise?: Maybe<DeliveryBrandedPromise>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The latest delivery date and time when the fulfillment is expected to arrive at the buyer's location. */
  maxDeliveryDateTime?: Maybe<Scalars["DateTime"]["output"]>
  /** The type of the delivery method. */
  methodType: DeliveryMethodType
  /** The earliest delivery date and time when the fulfillment is expected to arrive at the buyer's location. */
  minDeliveryDateTime?: Maybe<Scalars["DateTime"]["output"]>
  /** A reference to the shipping method. */
  serviceCode?: Maybe<Scalars["String"]["output"]>
}

/**
 * A method definition contains the delivery rate and the conditions that must be met for the method to be
 * applied.
 *
 */
export type DeliveryMethodDefinition = Node & {
  __typename?: "DeliveryMethodDefinition"
  /** Whether this method definition is active. */
  active: Scalars["Boolean"]["output"]
  /** The description of the method definition. Only available on shipping rates that are custom. */
  description?: Maybe<Scalars["String"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The method conditions that must pass for this method definition to be applied to an order. */
  methodConditions: Array<DeliveryCondition>
  /** The name of the method definition. */
  name: Scalars["String"]["output"]
  /** The provided rate for this method definition, from a rate definition or participant. */
  rateProvider: DeliveryRateProvider
}

/**
 * An auto-generated type for paginating through multiple DeliveryMethodDefinitions.
 *
 */
export type DeliveryMethodDefinitionConnection = {
  __typename?: "DeliveryMethodDefinitionConnection"
  /** A list of edges. */
  edges: Array<DeliveryMethodDefinitionEdge>
  /** A list of the nodes contained in DeliveryMethodDefinitionEdge. */
  nodes: Array<DeliveryMethodDefinition>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * The number of method definitions for a zone, separated into merchant-owned and participant definitions.
 *
 */
export type DeliveryMethodDefinitionCounts = {
  __typename?: "DeliveryMethodDefinitionCounts"
  /** The number of participant method definitions for the specified zone. */
  participantDefinitionsCount: Scalars["Int"]["output"]
  /** The number of merchant-defined method definitions for the specified zone. */
  rateDefinitionsCount: Scalars["Int"]["output"]
}

/**
 * An auto-generated type which holds one DeliveryMethodDefinition and a cursor during pagination.
 *
 */
export type DeliveryMethodDefinitionEdge = {
  __typename?: "DeliveryMethodDefinitionEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DeliveryMethodDefinitionEdge. */
  node: DeliveryMethodDefinition
}

/** The input fields for a method definition. */
export type DeliveryMethodDefinitionInput = {
  /** Whether to use this method definition during rate calculation. */
  active?: InputMaybe<Scalars["Boolean"]["input"]>
  /** A list of conditions to update on the method definition. */
  conditionsToUpdate?: InputMaybe<Array<DeliveryUpdateConditionInput>>
  /** The description of the method definition. */
  description?: InputMaybe<Scalars["String"]["input"]>
  /** A globally-unique ID of the method definition. Use only when updating a method definiton. */
  id?: InputMaybe<Scalars["ID"]["input"]>
  /** The name of the method definition. */
  name?: InputMaybe<Scalars["String"]["input"]>
  /** A participant to apply to the method definition. */
  participant?: InputMaybe<DeliveryParticipantInput>
  /** A list of price conditions on the method definition. */
  priceConditionsToCreate?: InputMaybe<Array<DeliveryPriceConditionInput>>
  /** A rate definition to apply to the method definition. */
  rateDefinition?: InputMaybe<DeliveryRateDefinitionInput>
  /** A list of weight conditions on the method definition. */
  weightConditionsToCreate?: InputMaybe<Array<DeliveryWeightConditionInput>>
}

/** The different types of method definitions to filter by. */
export enum DeliveryMethodDefinitionType {
  /** A static merchant-defined rate. */
  Merchant = "MERCHANT",
  /** A dynamic participant rate. */
  Participant = "PARTICIPANT",
}

/** Possible method types that a delivery method can have. */
export enum DeliveryMethodType {
  /** The order is delivered using a local delivery service. */
  Local = "LOCAL",
  /** No delivery is needed. */
  None = "NONE",
  /** The order is picked up by the customer. */
  PickUp = "PICK_UP",
  /** The order is delivered to a retail store. */
  Retail = "RETAIL",
  /** The order is shipped. */
  Shipping = "SHIPPING",
}

/**
 * A participant defines carrier-calculated rates for shipping services
 * with a possible merchant-defined fixed fee or a percentage-of-rate fee.
 *
 */
export type DeliveryParticipant = Node & {
  __typename?: "DeliveryParticipant"
  /**
   * Whether to display new shipping services automatically to the customer when the service becomes available.
   *
   */
  adaptToNewServicesFlag: Scalars["Boolean"]["output"]
  /** The carrier used for this participant. */
  carrierService: DeliveryCarrierService
  /** The merchant-defined fixed fee for this participant. */
  fixedFee?: Maybe<MoneyV2>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The carrier-specific services offered by the participant, and whether each service is active. */
  participantServices: Array<DeliveryParticipantService>
  /** The merchant-defined percentage-of-rate fee for this participant. */
  percentageOfRateFee: Scalars["Float"]["output"]
}

/** The input fields for a participant. */
export type DeliveryParticipantInput = {
  /**
   * Whether to automatically display new shipping services to the customer when a service becomes available.
   *
   */
  adaptToNewServices?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The ID of the carrier service for this participant. */
  carrierServiceId?: InputMaybe<Scalars["ID"]["input"]>
  /** The fixed feed that's defined by the merchant for this participant. */
  fixedFee?: InputMaybe<MoneyInput>
  /** The ID of the participant. */
  id?: InputMaybe<Scalars["ID"]["input"]>
  /** The list of shipping services offered by the participant. */
  participantServices?: InputMaybe<Array<DeliveryParticipantServiceInput>>
  /** The merchant-defined percentage-of-rate fee for this participant. */
  percentageOfRateFee?: InputMaybe<Scalars["Float"]["input"]>
}

/** A mail service provided by the participant. */
export type DeliveryParticipantService = {
  __typename?: "DeliveryParticipantService"
  /** Whether the service is active. */
  active: Scalars["Boolean"]["output"]
  /** The name of the service. */
  name: Scalars["String"]["output"]
}

/** The input fields for a shipping service provided by a participant. */
export type DeliveryParticipantServiceInput = {
  /** Whether the service is active. */
  active: Scalars["Boolean"]["input"]
  /** The name of the service. */
  name: Scalars["String"]["input"]
}

/** The input fields for a price-based condition of a delivery method definition. */
export type DeliveryPriceConditionInput = {
  /** The monetary value to compare the price of an order to. */
  criteria?: InputMaybe<MoneyInput>
  /** The operator to use for comparison. */
  operator?: InputMaybe<DeliveryConditionOperator>
}

/** How many product variants are in a profile. This count is capped at 500. */
export type DeliveryProductVariantsCount = {
  __typename?: "DeliveryProductVariantsCount"
  /** Whether the count has reached the cap of 500. */
  capped: Scalars["Boolean"]["output"]
  /** The product variant count. */
  count: Scalars["Int"]["output"]
}

/**
 * A shipping profile. In Shopify, a shipping profile is a set of shipping rates scoped to a set of products or variants that can be shipped from selected locations to zones.
 *
 */
export type DeliveryProfile = Node & {
  __typename?: "DeliveryProfile"
  /** The number of active shipping rates for the profile. */
  activeMethodDefinitionsCount: Scalars["Int"]["output"]
  /** Whether this is the default profile. */
  default: Scalars["Boolean"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** Whether this shop has enabled legacy compatibility mode for delivery profiles. */
  legacyMode: Scalars["Boolean"]["output"]
  /** The number of locations without rates defined. */
  locationsWithoutRatesCount: Scalars["Int"]["output"]
  /** The name of the delivery profile. */
  name: Scalars["String"]["output"]
  /** The number of active origin locations for the profile. */
  originLocationCount: Scalars["Int"]["output"]
  /**
   * The number of product variants for this profile. The count for the default profile isn't supported and will return -1.
   * @deprecated Use `productVariantsCountV2` instead.
   */
  productVariantsCount: Scalars["Int"]["output"]
  /** How many product variants are in this profile. */
  productVariantsCountV2: DeliveryProductVariantsCount
  /** The products and variants associated with this profile. */
  profileItems: DeliveryProfileItemConnection
  /** The location groups and associated zones using this profile. */
  profileLocationGroups: Array<DeliveryProfileLocationGroup>
  /** Selling plan groups associated with the specified delivery profile. */
  sellingPlanGroups: SellingPlanGroupConnection
  /** List of locations that haven't been assigned to a location group for this profile. */
  unassignedLocations: Array<Location>
  /** List of locations that have not been assigned to a location group for this profile. */
  unassignedLocationsPaginated: LocationConnection
  /** The number of countries with active rates to deliver to. */
  zoneCountryCount: Scalars["Int"]["output"]
}

/**
 * A shipping profile. In Shopify, a shipping profile is a set of shipping rates scoped to a set of products or variants that can be shipped from selected locations to zones.
 *
 */
export type DeliveryProfileProfileItemsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * A shipping profile. In Shopify, a shipping profile is a set of shipping rates scoped to a set of products or variants that can be shipped from selected locations to zones.
 *
 */
export type DeliveryProfileProfileLocationGroupsArgs = {
  locationGroupId?: InputMaybe<Scalars["ID"]["input"]>
}

/**
 * A shipping profile. In Shopify, a shipping profile is a set of shipping rates scoped to a set of products or variants that can be shipped from selected locations to zones.
 *
 */
export type DeliveryProfileSellingPlanGroupsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * A shipping profile. In Shopify, a shipping profile is a set of shipping rates scoped to a set of products or variants that can be shipped from selected locations to zones.
 *
 */
export type DeliveryProfileUnassignedLocationsPaginatedArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple DeliveryProfiles.
 *
 */
export type DeliveryProfileConnection = {
  __typename?: "DeliveryProfileConnection"
  /** A list of edges. */
  edges: Array<DeliveryProfileEdge>
  /** A list of the nodes contained in DeliveryProfileEdge. */
  nodes: Array<DeliveryProfile>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one DeliveryProfile and a cursor during pagination.
 *
 */
export type DeliveryProfileEdge = {
  __typename?: "DeliveryProfileEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DeliveryProfileEdge. */
  node: DeliveryProfile
}

/** The input fields for a delivery profile. */
export type DeliveryProfileInput = {
  /** The list of condition IDs to delete. */
  conditionsToDelete?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /**
   * The list of location groups to be created in the delivery profile.
   *
   * **Note:** due to the potential complexity of the nested data, it is recommended to send no more than 5 location groups per each request.
   *
   */
  locationGroupsToCreate?: InputMaybe<Array<DeliveryProfileLocationGroupInput>>
  /** The list of location groups to be deleted from the delivery profile. */
  locationGroupsToDelete?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /**
   * The list of location groups to be updated in the delivery profile.
   *
   * **Note:** due to the potential complexity of the nested data, it is recommended to send no more than 5 location groups per each request.
   *
   */
  locationGroupsToUpdate?: InputMaybe<Array<DeliveryProfileLocationGroupInput>>
  /** The list of method definition IDs to delete. */
  methodDefinitionsToDelete?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /** The name of the delivery profile. */
  name?: InputMaybe<Scalars["String"]["input"]>
  /** The list of location groups associated with the delivery profile. */
  profileLocationGroups?: InputMaybe<Array<DeliveryProfileLocationGroupInput>>
  /** The list of selling plan groups to be associated with the delivery profile. */
  sellingPlanGroupsToAssociate?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /** The list of selling plan groups to be dissociated with the delivery profile. */
  sellingPlanGroupsToDissociate?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /** The list of product variant IDs to be associated with the delivery profile. */
  variantsToAssociate?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /**
   * The list of product variant IDs to be dissociated from the delivery profile.
   * The dissociated product variants are moved back to the default delivery profile.
   *
   */
  variantsToDissociate?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /** The list of zone IDs to delete. */
  zonesToDelete?: InputMaybe<Array<Scalars["ID"]["input"]>>
}

/** A product and the subset of associated variants that are part of this delivery profile. */
export type DeliveryProfileItem = Node & {
  __typename?: "DeliveryProfileItem"
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** A product associated with this profile. */
  product: Product
  /** The product variants associated with this delivery profile. */
  variants: ProductVariantConnection
}

/** A product and the subset of associated variants that are part of this delivery profile. */
export type DeliveryProfileItemVariantsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple DeliveryProfileItems.
 *
 */
export type DeliveryProfileItemConnection = {
  __typename?: "DeliveryProfileItemConnection"
  /** A list of edges. */
  edges: Array<DeliveryProfileItemEdge>
  /** A list of the nodes contained in DeliveryProfileItemEdge. */
  nodes: Array<DeliveryProfileItem>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one DeliveryProfileItem and a cursor during pagination.
 *
 */
export type DeliveryProfileItemEdge = {
  __typename?: "DeliveryProfileItemEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DeliveryProfileItemEdge. */
  node: DeliveryProfileItem
}

/** Links a location group with zones. Both are associated to a delivery profile. */
export type DeliveryProfileLocationGroup = {
  __typename?: "DeliveryProfileLocationGroup"
  /** The countries already selected in any zone for the specified location group. */
  countriesInAnyZone: Array<DeliveryCountryAndZone>
  /** The collection of locations that make up the specified location group. */
  locationGroup: DeliveryLocationGroup
  /** The applicable zones associated to the specified location group. */
  locationGroupZones: DeliveryLocationGroupZoneConnection
}

/** Links a location group with zones. Both are associated to a delivery profile. */
export type DeliveryProfileLocationGroupLocationGroupZonesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** The input fields for a location group associated to a delivery profile. */
export type DeliveryProfileLocationGroupInput = {
  /** The globally-unique ID of the delivery profile location group. */
  id?: InputMaybe<Scalars["ID"]["input"]>
  /** The list of location IDs to be moved to this location group. */
  locations?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /**
   * The list of location IDs to be added to this location group.
   *
   * **Note:** due to API input array limits, a maximum of 250 items can be sent per each request.
   *
   */
  locationsToAdd?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /**
   * The list of location IDs to be removed from this location group.
   *
   * **Note:** due to API input array limits, a maximum of 250 items can be sent per each request.
   *
   */
  locationsToRemove?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /**
   * The list of location group zones to create.
   *
   * **Note:** due to the potential complexity of the nested data, it is recommended to send no more than 5 zones per each request.
   *
   */
  zonesToCreate?: InputMaybe<Array<DeliveryLocationGroupZoneInput>>
  /**
   * The list of location group zones to update.
   *
   * **Note:** due to the potential complexity of the nested data, it is recommended to send no more than 5 zones per each request.
   *
   */
  zonesToUpdate?: InputMaybe<Array<DeliveryLocationGroupZoneInput>>
}

/** A region that is used to define a shipping zone. */
export type DeliveryProvince = Node & {
  __typename?: "DeliveryProvince"
  /** The code of the region. */
  code: Scalars["String"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The full name of the region. */
  name: Scalars["String"]["output"]
  /** The translated name of the region. The translation returned is based on the system's locale. */
  translatedName: Scalars["String"]["output"]
}

/** The input fields to specify a region. */
export type DeliveryProvinceInput = {
  /** The code of the region. */
  code: Scalars["String"]["input"]
}

/** The merchant-defined rate of the [DeliveryMethodDefinition](https://shopify.dev/api/admin-graphql/latest/objects/DeliveryMethodDefinition). */
export type DeliveryRateDefinition = Node & {
  __typename?: "DeliveryRateDefinition"
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The price of this rate. */
  price: MoneyV2
}

/** The input fields for a rate definition. */
export type DeliveryRateDefinitionInput = {
  /** A globally-unique ID of the rate definition. */
  id?: InputMaybe<Scalars["ID"]["input"]>
  /** The price of the rate definition. */
  price: MoneyInput
}

/** A rate provided by a merchant-defined rate or a participant. */
export type DeliveryRateProvider = DeliveryParticipant | DeliveryRateDefinition

/**
 * The `DeliverySetting` object enables you to manage shop-wide shipping settings.
 * You can enable legacy compatibility mode for the multi-location delivery profiles feature
 * if the legacy mode isn't blocked.
 *
 */
export type DeliverySetting = {
  __typename?: "DeliverySetting"
  /** Whether the shop is blocked from converting to full multi-location delivery profiles mode. If the shop is blocked, then the blocking reasons are also returned. */
  legacyModeBlocked: DeliveryLegacyModeBlocked
  /** Enables legacy compatability mode for the multi-location delivery profiles feature. */
  legacyModeProfiles: Scalars["Boolean"]["output"]
}

/** The input fields for shop-level delivery settings. */
export type DeliverySettingInput = {
  /** Whether legacy compatability mode is enabled for the multi-location delivery profiles feature. */
  legacyModeProfiles?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Return type for `deliverySettingUpdate` mutation. */
export type DeliverySettingUpdatePayload = {
  __typename?: "DeliverySettingUpdatePayload"
  /** The updated delivery shop level settings. */
  setting?: Maybe<DeliverySetting>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `deliveryShippingOriginAssign` mutation. */
export type DeliveryShippingOriginAssignPayload = {
  __typename?: "DeliveryShippingOriginAssignPayload"
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The input fields for updating the condition of a delivery method definition. */
export type DeliveryUpdateConditionInput = {
  /** The value that will be used in comparison. */
  criteria?: InputMaybe<Scalars["Float"]["input"]>
  /** The unit associated with the value that will be used in comparison. */
  criteriaUnit?: InputMaybe<Scalars["String"]["input"]>
  /** The property of an order that will be used in comparison. */
  field?: InputMaybe<DeliveryConditionField>
  /** A globally-unique ID of the condition. */
  id: Scalars["ID"]["input"]
  /** The operator to use for comparison. */
  operator?: InputMaybe<DeliveryConditionOperator>
}

/** The input fields for a weight-based condition of a delivery method definition. */
export type DeliveryWeightConditionInput = {
  /** The weight value to compare the weight of an order to. */
  criteria?: InputMaybe<WeightInput>
  /** The operator to use for comparison. */
  operator?: InputMaybe<DeliveryConditionOperator>
}

/**
 * A zone is a group of countries that have the same shipping rates. Customers can order products from a store only if they choose a shipping destination that's included in one of the store's zones.
 *
 */
export type DeliveryZone = Node & {
  __typename?: "DeliveryZone"
  /** The list of countries within the zone. */
  countries: Array<DeliveryCountry>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The name of the zone. */
  name: Scalars["String"]["output"]
}

/** Digital wallet, such as Apple Pay, which can be used for accelerated checkouts. */
export enum DigitalWallet {
  /** Android Pay. */
  AndroidPay = "ANDROID_PAY",
  /** Apple Pay. */
  ApplePay = "APPLE_PAY",
  /** Google Pay. */
  GooglePay = "GOOGLE_PAY",
  /** Shopify Pay. */
  ShopifyPay = "SHOPIFY_PAY",
}

/** A discount. */
export type Discount =
  | DiscountAutomaticApp
  | DiscountAutomaticBasic
  | DiscountAutomaticBxgy
  | DiscountAutomaticFreeShipping
  | DiscountCodeApp
  | DiscountCodeBasic
  | DiscountCodeBxgy
  | DiscountCodeFreeShipping

/** An amount that's allocated to a line based on an associated discount application. */
export type DiscountAllocation = {
  __typename?: "DiscountAllocation"
  /**
   * The money amount that's allocated to a line based on the associated discount application.
   * @deprecated Use `allocatedAmountSet` instead.
   */
  allocatedAmount: MoneyV2
  /** The money amount that's allocated to a line based on the associated discount application in shop and presentment currencies. */
  allocatedAmountSet: MoneyBag
  /** The discount application that the allocated amount originated from. */
  discountApplication: DiscountApplication
}

/** The fixed amount value of a discount, and whether the amount is applied to each entitled item or spread evenly across the entitled items. */
export type DiscountAmount = {
  __typename?: "DiscountAmount"
  /** The value of the discount. */
  amount: MoneyV2
  /** If true, then the discount is applied to each of the entitled items. If false, then the amount is split across all of the entitled items. */
  appliesOnEachItem: Scalars["Boolean"]["output"]
}

/** The input fields for the value of the discount and how it is applied. */
export type DiscountAmountInput = {
  /** The value of the discount. */
  amount?: InputMaybe<Scalars["Decimal"]["input"]>
  /** If true, then the discount is applied to each of the entitled items. If false, then the amount is split across all of the entitled items. */
  appliesOnEachItem?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Discount applications capture the intentions of a discount source at
 * the time of application on an order's line items or shipping lines.
 *
 * Discount applications don't represent the actual final amount discounted on a line (line item or shipping line). The actual amount discounted on a line is represented by the [DiscountAllocation](https://shopify.dev/api/admin-graphql/latest/objects/discountallocation) object.
 *
 */
export type DiscountApplication = {
  /** The method by which the discount's value is applied to its entitled items. */
  allocationMethod: DiscountApplicationAllocationMethod
  /**
   * An ordered index that can be used to identify the discount application and indicate the precedence
   * of the discount application for calculations.
   *
   */
  index: Scalars["Int"]["output"]
  /** How the discount amount is distributed on the discounted lines. */
  targetSelection: DiscountApplicationTargetSelection
  /** Whether the discount is applied on line items or shipping lines. */
  targetType: DiscountApplicationTargetType
  /** The value of the discount application. */
  value: PricingValue
}

/** The method by which the discount's value is allocated onto its entitled lines. */
export enum DiscountApplicationAllocationMethod {
  /** The value is spread across all entitled lines. */
  Across = "ACROSS",
  /** The value is applied onto every entitled line. */
  Each = "EACH",
  /**
   * The value is specifically applied onto a particular line.
   * @deprecated Use ACROSS instead.
   */
  One = "ONE",
}

/**
 * An auto-generated type for paginating through multiple DiscountApplications.
 *
 */
export type DiscountApplicationConnection = {
  __typename?: "DiscountApplicationConnection"
  /** A list of edges. */
  edges: Array<DiscountApplicationEdge>
  /** A list of the nodes contained in DiscountApplicationEdge. */
  nodes: Array<DiscountApplication>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one DiscountApplication and a cursor during pagination.
 *
 */
export type DiscountApplicationEdge = {
  __typename?: "DiscountApplicationEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DiscountApplicationEdge. */
  node: DiscountApplication
}

/** The level at which the discount's value is applied. */
export enum DiscountApplicationLevel {
  /**
   * The discount is applied at the line level.
   * Line level discounts are factored into the discountedUnitPriceSet on line items.
   *
   */
  Line = "LINE",
  /**
   * The discount is applied at the order level.
   * Order level discounts are not factored into the discountedUnitPriceSet on line items.
   *
   */
  Order = "ORDER",
}

/**
 * The lines on the order to which the discount is applied, of the type defined by
 * the discount application's `targetType`. For example, the value `ENTITLED`, combined with a `targetType` of
 * `LINE_ITEM`, applies the discount on all line items that are entitled to the discount.
 * The value `ALL`, combined with a `targetType` of `SHIPPING_LINE`, applies the discount on all shipping lines.
 *
 */
export enum DiscountApplicationTargetSelection {
  /** The discount is allocated onto all the lines. */
  All = "ALL",
  /** The discount is allocated onto only the lines that it's entitled for. */
  Entitled = "ENTITLED",
  /** The discount is allocated onto explicitly chosen lines. */
  Explicit = "EXPLICIT",
}

/**
 * The type of line (i.e. line item or shipping line) on an order that the discount is applicable towards.
 *
 */
export enum DiscountApplicationTargetType {
  /** The discount applies onto line items. */
  LineItem = "LINE_ITEM",
  /** The discount applies onto shipping lines. */
  ShippingLine = "SHIPPING_LINE",
}

/** The type of discount associated to the automatic discount. For example, the automatic discount might offer a basic discount using a fixed percentage, or a fixed amount, on specific products from the order. The automatic discount may also be a BXGY discount, which offers customer discounts on select products if they add a specific product to their order. */
export type DiscountAutomatic = DiscountAutomaticApp | DiscountAutomaticBasic | DiscountAutomaticBxgy | DiscountAutomaticFreeShipping

/** Return type for `discountAutomaticActivate` mutation. */
export type DiscountAutomaticActivatePayload = {
  __typename?: "DiscountAutomaticActivatePayload"
  /** The activated automatic discount. */
  automaticDiscountNode?: Maybe<DiscountAutomaticNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** An automatic app discount. */
export type DiscountAutomaticApp = {
  __typename?: "DiscountAutomaticApp"
  /** The app discount type providing the discount type. */
  appDiscountType: AppDiscountType
  /** The number of times the discount has been used. This value is updated asynchronously and can be different than the actual usage count. */
  asyncUsageCount: Scalars["Int"]["output"]
  /** Determines which discount classes the discount can combine with. */
  combinesWith: DiscountCombinesWith
  /** The date and time when the discount was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** The class of the discount for combining purposes. */
  discountClass: DiscountClass
  /** The ID for the discount. */
  discountId: Scalars["ID"]["output"]
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: Maybe<Scalars["DateTime"]["output"]>
  /** The error history on the most recent version of the app discount. */
  errorHistory?: Maybe<FunctionsErrorHistory>
  /** The date and time when the discount starts. */
  startsAt: Scalars["DateTime"]["output"]
  /** The status of the discount. */
  status: DiscountStatus
  /** The title of the discount. */
  title: Scalars["String"]["output"]
  /** The date and time when the discount was updated. */
  updatedAt: Scalars["DateTime"]["output"]
}

/** Return type for `discountAutomaticAppCreate` mutation. */
export type DiscountAutomaticAppCreatePayload = {
  __typename?: "DiscountAutomaticAppCreatePayload"
  /** The created app discount. */
  automaticAppDiscount?: Maybe<DiscountAutomaticApp>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** The input fields to create an app discount. */
export type DiscountAutomaticAppInput = {
  /** Determines which discount classes the discount can combine with. */
  combinesWith?: InputMaybe<DiscountCombinesWithInput>
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The ID of the function providing the app discount type. */
  functionId?: InputMaybe<Scalars["String"]["input"]>
  /** Additional metafields to associate to the discount. */
  metafields?: InputMaybe<Array<MetafieldInput>>
  /** The date and time when the discount starts. */
  startsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The title of the discount. */
  title?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `discountAutomaticAppUpdate` mutation. */
export type DiscountAutomaticAppUpdatePayload = {
  __typename?: "DiscountAutomaticAppUpdatePayload"
  /** The updated automatic app discount. */
  automaticAppDiscount?: Maybe<DiscountAutomaticApp>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** An automatic discount that offers customers a percentage discount, or fixed amount discount, on specific products, collections, or the entire order. */
export type DiscountAutomaticBasic = {
  __typename?: "DiscountAutomaticBasic"
  /** The number of times the discount has been used. This value is updated asynchronously and can be different than the actual usage count. */
  asyncUsageCount: Scalars["Int"]["output"]
  /** Determines which discount classes the discount can combine with. */
  combinesWith: DiscountCombinesWith
  /** The date and time when the discount was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** The qualifying items in an order, the quantity of each one, and the total value of the discount. */
  customerGets: DiscountCustomerGets
  /** The class of the discount for combining purposes. */
  discountClass: MerchandiseDiscountClass
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: Maybe<Scalars["DateTime"]["output"]>
  /** The minimum subtotal or quantity that's required for the discount to be applied. */
  minimumRequirement: DiscountMinimumRequirement
  /** The number of times a discount applies on recurring purchases (subscriptions). */
  recurringCycleLimit: Scalars["Int"]["output"]
  /** A short summary of the discount. */
  shortSummary: Scalars["String"]["output"]
  /** The date and time when the discount starts. */
  startsAt: Scalars["DateTime"]["output"]
  /** The status of the discount. */
  status: DiscountStatus
  /** A detailed summary of the discount. */
  summary: Scalars["String"]["output"]
  /** The title of the discount. */
  title: Scalars["String"]["output"]
  /** The date and time when the discount was updated. */
  updatedAt: Scalars["DateTime"]["output"]
  /**
   * The number of times that the discount has been used.
   * @deprecated Use `asyncUsageCount` instead.
   */
  usageCount: Scalars["Int"]["output"]
}

/** Return type for `discountAutomaticBasicCreate` mutation. */
export type DiscountAutomaticBasicCreatePayload = {
  __typename?: "DiscountAutomaticBasicCreatePayload"
  /** The created automatic discount. */
  automaticDiscountNode?: Maybe<DiscountAutomaticNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** The input fields to create or update an automatic basic discount. */
export type DiscountAutomaticBasicInput = {
  /** Determines which discount classes the discount can combine with. */
  combinesWith?: InputMaybe<DiscountCombinesWithInput>
  /** Information about the qualifying items and their discount. */
  customerGets?: InputMaybe<DiscountCustomerGetsInput>
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The minimum subtotal or quantity that's required for the discount to be applied. */
  minimumRequirement?: InputMaybe<DiscountMinimumRequirementInput>
  /** The number of times a discount applies on recurring purchases (subscriptions). */
  recurringCycleLimit?: InputMaybe<Scalars["Int"]["input"]>
  /** The date and time when the discount starts. */
  startsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The title of the discount. */
  title?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `discountAutomaticBasicUpdate` mutation. */
export type DiscountAutomaticBasicUpdatePayload = {
  __typename?: "DiscountAutomaticBasicUpdatePayload"
  /** The updated automatic discount. */
  automaticDiscountNode?: Maybe<DiscountAutomaticNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** Return type for `discountAutomaticBulkDelete` mutation. */
export type DiscountAutomaticBulkDeletePayload = {
  __typename?: "DiscountAutomaticBulkDeletePayload"
  /** The asynchronous job removing the automatic discounts. */
  job?: Maybe<Job>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** An automatic discount that offers customers a Buy X, Get Y (BXGY) discount. */
export type DiscountAutomaticBxgy = HasEvents &
  Node & {
    __typename?: "DiscountAutomaticBxgy"
    /** The number of times the discount has been used. This value is updated asynchronously and can be different than the actual usage count. */
    asyncUsageCount: Scalars["Int"]["output"]
    /** Determines which discount classes the discount can combine with. */
    combinesWith: DiscountCombinesWith
    /** The date and time when the discount was created. */
    createdAt: Scalars["DateTime"]["output"]
    /** The qualifying items and the quantity of each one that the customer has to buy to be eligible for the discount. */
    customerBuys: DiscountCustomerBuys
    /** The qualifying items in an order, the quantity of each one, and the total value of the discount. */
    customerGets: DiscountCustomerGets
    /** The class of the discount for combining purposes. */
    discountClass: MerchandiseDiscountClass
    /** The date and time when the discount ends. For open-ended discounts, use `null`. */
    endsAt?: Maybe<Scalars["DateTime"]["output"]>
    /** The paginated list of events associated with the host subject. */
    events: EventConnection
    /**
     * A legacy unique ID for the discount.
     * @deprecated Use DiscountAutomaticNode.id instead.
     */
    id: Scalars["ID"]["output"]
    /** The date and time when the discount starts. */
    startsAt: Scalars["DateTime"]["output"]
    /** The status of the discount. */
    status: DiscountStatus
    /** A detailed summary of the discount. */
    summary: Scalars["String"]["output"]
    /** The title of the discount. */
    title: Scalars["String"]["output"]
    /** The date and time when the discount was updated. */
    updatedAt: Scalars["DateTime"]["output"]
    /**
     * The number of times that the discount has been used.
     * @deprecated Use `asyncUsageCount` instead.
     */
    usageCount: Scalars["Int"]["output"]
    /** The maximum number of times that the discount can be applied to an order. */
    usesPerOrderLimit?: Maybe<Scalars["Int"]["output"]>
  }

/** An automatic discount that offers customers a Buy X, Get Y (BXGY) discount. */
export type DiscountAutomaticBxgyEventsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<EventSortKeys>
}

/** Return type for `discountAutomaticBxgyCreate` mutation. */
export type DiscountAutomaticBxgyCreatePayload = {
  __typename?: "DiscountAutomaticBxgyCreatePayload"
  /** The created automatic discount. */
  automaticDiscountNode?: Maybe<DiscountAutomaticNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** The input fields to create or update an automatic Buy X, Get Y (BXGY) discount. */
export type DiscountAutomaticBxgyInput = {
  /** Determines which discount classes the discount can combine with. */
  combinesWith?: InputMaybe<DiscountCombinesWithInput>
  /** The qualifying items and the quantity of each one that the customer has to buy to be eligible for the discount. */
  customerBuys?: InputMaybe<DiscountCustomerBuysInput>
  /** The qualifying items in an order, the quantity of each one, and the total value of the discount. */
  customerGets?: InputMaybe<DiscountCustomerGetsInput>
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The date and time when the discount starts. */
  startsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The title of the discount. */
  title?: InputMaybe<Scalars["String"]["input"]>
  /** The maximum number of times that the discount can be applied to an order. */
  usesPerOrderLimit?: InputMaybe<Scalars["UnsignedInt64"]["input"]>
}

/** Return type for `discountAutomaticBxgyUpdate` mutation. */
export type DiscountAutomaticBxgyUpdatePayload = {
  __typename?: "DiscountAutomaticBxgyUpdatePayload"
  /** The updated automatic discount. */
  automaticDiscountNode?: Maybe<DiscountAutomaticNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/**
 * An auto-generated type for paginating through multiple DiscountAutomatics.
 *
 */
export type DiscountAutomaticConnection = {
  __typename?: "DiscountAutomaticConnection"
  /** A list of edges. */
  edges: Array<DiscountAutomaticEdge>
  /** A list of the nodes contained in DiscountAutomaticEdge. */
  nodes: Array<DiscountAutomatic>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `discountAutomaticDeactivate` mutation. */
export type DiscountAutomaticDeactivatePayload = {
  __typename?: "DiscountAutomaticDeactivatePayload"
  /** The deactivated automatic discount. */
  automaticDiscountNode?: Maybe<DiscountAutomaticNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** Return type for `discountAutomaticDelete` mutation. */
export type DiscountAutomaticDeletePayload = {
  __typename?: "DiscountAutomaticDeletePayload"
  /** The deleted automatic discount ID. */
  deletedAutomaticDiscountId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/**
 * An auto-generated type which holds one DiscountAutomatic and a cursor during pagination.
 *
 */
export type DiscountAutomaticEdge = {
  __typename?: "DiscountAutomaticEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DiscountAutomaticEdge. */
  node: DiscountAutomatic
}

/** An automatic discount that offers customers free shipping on their order. */
export type DiscountAutomaticFreeShipping = {
  __typename?: "DiscountAutomaticFreeShipping"
  /** Whether the discount applies on regular one-time-purchase shipping lines. */
  appliesOnOneTimePurchase: Scalars["Boolean"]["output"]
  /** Whether the discount applies on subscription shipping lines. */
  appliesOnSubscription: Scalars["Boolean"]["output"]
  /** The number of times that the discount has been used. This value is updated asynchronously and can be different than the actual usage count. */
  asyncUsageCount: Scalars["Int"]["output"]
  /** Determines which discount classes the discount can combine with. */
  combinesWith: DiscountCombinesWith
  /** The date and time when the discount was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** A shipping destination that qualifies for the discount. */
  destinationSelection: DiscountShippingDestinationSelection
  /** The class of the discount for combining purposes. */
  discountClass: ShippingDiscountClass
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: Maybe<Scalars["DateTime"]["output"]>
  /** Indicates whether there are any timeline comments on the discount. */
  hasTimelineComment: Scalars["Boolean"]["output"]
  /** The maximum shipping price amount accepted to qualify for the discount. */
  maximumShippingPrice?: Maybe<MoneyV2>
  /** The minimum subtotal or quantity that's required for the discount to be applied. */
  minimumRequirement: DiscountMinimumRequirement
  /** The number of times a discount applies on recurring purchases (subscriptions). */
  recurringCycleLimit: Scalars["Int"]["output"]
  /** A short summary of the discount. */
  shortSummary: Scalars["String"]["output"]
  /** The date and time when the discount starts. */
  startsAt: Scalars["DateTime"]["output"]
  /** The status of the discount. */
  status: DiscountStatus
  /** A detailed summary of the discount. */
  summary: Scalars["String"]["output"]
  /** The title of the discount. */
  title: Scalars["String"]["output"]
  /** The total sales from orders where the discount was used. */
  totalSales?: Maybe<MoneyV2>
  /** The date and time when the discount was updated. */
  updatedAt: Scalars["DateTime"]["output"]
}

/** Return type for `discountAutomaticFreeShippingCreate` mutation. */
export type DiscountAutomaticFreeShippingCreatePayload = {
  __typename?: "DiscountAutomaticFreeShippingCreatePayload"
  /** The created automatic discount. */
  automaticDiscountNode?: Maybe<DiscountAutomaticNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** The input fields to create or update free shipping automatic discount. */
export type DiscountAutomaticFreeShippingInput = {
  /** Whether the discount applies on regular one-time-purchase items. */
  appliesOnOneTimePurchase?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Whether the discount applies on subscription items. */
  appliesOnSubscription?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Determines which discount classes the shipping discount can combine with. */
  combinesWith?: InputMaybe<DiscountCombinesWithInput>
  /** A list of destinations where the discount will apply. */
  destination?: InputMaybe<DiscountShippingDestinationSelectionInput>
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The maximum shipping price that qualifies for the discount. */
  maximumShippingPrice?: InputMaybe<Scalars["Decimal"]["input"]>
  /** The minimum subtotal or quantity that's required for the discount to be applied. */
  minimumRequirement?: InputMaybe<DiscountMinimumRequirementInput>
  /** The number of times a discount applies on recurring purchases (subscriptions). */
  recurringCycleLimit?: InputMaybe<Scalars["Int"]["input"]>
  /** The date and time when the discount starts. */
  startsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The title of the discount. */
  title?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `discountAutomaticFreeShippingUpdate` mutation. */
export type DiscountAutomaticFreeShippingUpdatePayload = {
  __typename?: "DiscountAutomaticFreeShippingUpdatePayload"
  /** The updated automatic discount. */
  automaticDiscountNode?: Maybe<DiscountAutomaticNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** A node containing an automatic discount and its related events. */
export type DiscountAutomaticNode = HasEvents &
  HasMetafieldDefinitions &
  HasMetafields &
  Node & {
    __typename?: "DiscountAutomaticNode"
    /** The automatic discount object. */
    automaticDiscount: DiscountAutomatic
    /** The paginated list of events associated with the host subject. */
    events: EventConnection
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafield definitions. */
    metafieldDefinitions: MetafieldDefinitionConnection
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
  }

/** A node containing an automatic discount and its related events. */
export type DiscountAutomaticNodeEventsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<EventSortKeys>
}

/** A node containing an automatic discount and its related events. */
export type DiscountAutomaticNodeMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/** A node containing an automatic discount and its related events. */
export type DiscountAutomaticNodeMetafieldDefinitionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  pinnedStatus?: InputMaybe<MetafieldDefinitionPinnedStatus>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<MetafieldDefinitionSortKeys>
}

/** A node containing an automatic discount and its related events. */
export type DiscountAutomaticNodeMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** A node containing an automatic discount and its related events. */
export type DiscountAutomaticNodePrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/** A node containing an automatic discount and its related events. */
export type DiscountAutomaticNodePrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple DiscountAutomaticNodes.
 *
 */
export type DiscountAutomaticNodeConnection = {
  __typename?: "DiscountAutomaticNodeConnection"
  /** A list of edges. */
  edges: Array<DiscountAutomaticNodeEdge>
  /** A list of the nodes contained in DiscountAutomaticNodeEdge. */
  nodes: Array<DiscountAutomaticNode>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one DiscountAutomaticNode and a cursor during pagination.
 *
 */
export type DiscountAutomaticNodeEdge = {
  __typename?: "DiscountAutomaticNodeEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DiscountAutomaticNodeEdge. */
  node: DiscountAutomaticNode
}

/** The class of the discount for combining purposes. */
export enum DiscountClass {
  /** Combined as an order discount. */
  Order = "ORDER",
  /** Combined as a product discount. */
  Product = "PRODUCT",
  /** Combined as a shipping discount. */
  Shipping = "SHIPPING",
}

/** The type of discount associated with the discount code. For example, the discount code might offer a basic discount of a fixed percentage, or a fixed amount, on specific products or the order. Alternatively, the discount might offer the customer free shipping on their order. A third option is a Buy X, Get Y (BXGY) discount, which offers a customer discounts on select products if they add a specific product to their order. */
export type DiscountCode = DiscountCodeApp | DiscountCodeBasic | DiscountCodeBxgy | DiscountCodeFreeShipping

/** Return type for `discountCodeActivate` mutation. */
export type DiscountCodeActivatePayload = {
  __typename?: "DiscountCodeActivatePayload"
  /** The activated code discount. */
  codeDiscountNode?: Maybe<DiscountCodeNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** A code app discount. */
export type DiscountCodeApp = {
  __typename?: "DiscountCodeApp"
  /** The app discount type providing the discount type. */
  appDiscountType: AppDiscountType
  /** Whether the discount can be applied only once per customer. */
  appliesOncePerCustomer: Scalars["Boolean"]["output"]
  /** The number of times that the discount has been used. */
  asyncUsageCount: Scalars["Int"]["output"]
  /** The number of redeem codes for the discount. */
  codeCount: Scalars["Int"]["output"]
  /** A list of redeem codes for the discount. */
  codes: DiscountRedeemCodeConnection
  /** Determines which discount classes the discount can combine with. */
  combinesWith: DiscountCombinesWith
  /** The date and time when the discount was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** The customers that can use the discount. */
  customerSelection: DiscountCustomerSelection
  /** The class of the discount for combining purposes. */
  discountClass: DiscountClass
  /** The ID for the discount. */
  discountId: Scalars["ID"]["output"]
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: Maybe<Scalars["DateTime"]["output"]>
  /** The error history on the most recent version of the discount. */
  errorHistory?: Maybe<FunctionsErrorHistory>
  /** Indicates whether there are any timeline comments on the discount. */
  hasTimelineComment: Scalars["Boolean"]["output"]
  /** The number of times a discount applies on recurring purchases (subscriptions). */
  recurringCycleLimit?: Maybe<Scalars["Int"]["output"]>
  /** URLs that can be used to share the discount. */
  shareableUrls: Array<DiscountShareableUrl>
  /** The date and time when the discount starts. */
  startsAt: Scalars["DateTime"]["output"]
  /** The status of the discount. */
  status: DiscountStatus
  /** The title of the discount. */
  title: Scalars["String"]["output"]
  /** The total sales from orders where the discount was used. */
  totalSales?: Maybe<MoneyV2>
  /** The date and time when the discount was updated. */
  updatedAt: Scalars["DateTime"]["output"]
  /** The maximum number of times that the discount can be used. */
  usageLimit?: Maybe<Scalars["Int"]["output"]>
}

/** A code app discount. */
export type DiscountCodeAppCodesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  savedSearchId?: InputMaybe<Scalars["ID"]["input"]>
  sortKey?: InputMaybe<DiscountCodeSortKeys>
}

/** Return type for `discountCodeAppCreate` mutation. */
export type DiscountCodeAppCreatePayload = {
  __typename?: "DiscountCodeAppCreatePayload"
  /** The created code app discount. */
  codeAppDiscount?: Maybe<DiscountCodeApp>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** The input fields to create a code app discount. */
export type DiscountCodeAppInput = {
  /** Whether the discount can be applied only once per customer. */
  appliesOncePerCustomer?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The code to use the discount. */
  code?: InputMaybe<Scalars["String"]["input"]>
  /** Determines which discount classes the discount can combine with. */
  combinesWith?: InputMaybe<DiscountCombinesWithInput>
  /** The customers that can use the discount. */
  customerSelection?: InputMaybe<DiscountCustomerSelectionInput>
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The ID of the function providing the app discount type. */
  functionId?: InputMaybe<Scalars["String"]["input"]>
  /** Additional metafields to associate to the discount. */
  metafields?: InputMaybe<Array<MetafieldInput>>
  /** The date and time when the discount starts. */
  startsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The title of the discount. */
  title?: InputMaybe<Scalars["String"]["input"]>
  /** The maximum number of times that the discount can be used. For open-ended discounts, use `null`. */
  usageLimit?: InputMaybe<Scalars["Int"]["input"]>
}

/** Return type for `discountCodeAppUpdate` mutation. */
export type DiscountCodeAppUpdatePayload = {
  __typename?: "DiscountCodeAppUpdatePayload"
  /** The updated code app discount. */
  codeAppDiscount?: Maybe<DiscountCodeApp>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/**
 * Discount code applications capture the intentions of a discount code at
 * the time that it is applied onto an order.
 *
 * Discount applications don't represent the actual final amount discounted on a line (line item or shipping line). The actual amount discounted on a line is represented by the [DiscountAllocation](https://shopify.dev/api/admin-graphql/latest/objects/discountallocation) object.
 *
 */
export type DiscountCodeApplication = DiscountApplication & {
  __typename?: "DiscountCodeApplication"
  /** The method by which the discount's value is applied to its entitled items. */
  allocationMethod: DiscountApplicationAllocationMethod
  /** The string identifying the discount code that was used at the time of application. */
  code: Scalars["String"]["output"]
  /**
   * An ordered index that can be used to identify the discount application and indicate the precedence
   * of the discount application for calculations.
   *
   */
  index: Scalars["Int"]["output"]
  /** How the discount amount is distributed on the discounted lines. */
  targetSelection: DiscountApplicationTargetSelection
  /** Whether the discount is applied on line items or shipping lines. */
  targetType: DiscountApplicationTargetType
  /** The value of the discount application. */
  value: PricingValue
}

/** A code discount that offers customers a percentage or fixed amount discount on specific products, collections, or the entire order. */
export type DiscountCodeBasic = {
  __typename?: "DiscountCodeBasic"
  /** Whether the discount can be applied only once per customer. */
  appliesOncePerCustomer: Scalars["Boolean"]["output"]
  /** The number of times that the discount has been used. */
  asyncUsageCount: Scalars["Int"]["output"]
  /** The number of redeem codes for the discount. */
  codeCount: Scalars["Int"]["output"]
  /** A list of redeem codes for the discount. */
  codes: DiscountRedeemCodeConnection
  /** Determines which discount classes the discount can combine with. */
  combinesWith: DiscountCombinesWith
  /** The date and time when the discount was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** The qualifying items in an order, the quantity of each one, and the total value of the discount. */
  customerGets: DiscountCustomerGets
  /** The customers that can use the discount. */
  customerSelection: DiscountCustomerSelection
  /** The class of the discount for combining purposes. */
  discountClass: MerchandiseDiscountClass
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: Maybe<Scalars["DateTime"]["output"]>
  /** Indicates whether there are any timeline comments on the discount. */
  hasTimelineComment: Scalars["Boolean"]["output"]
  /** The minimum subtotal or quantity that's required for the discount to be applied. */
  minimumRequirement?: Maybe<DiscountMinimumRequirement>
  /** The number of times a discount applies on recurring purchases (subscriptions). */
  recurringCycleLimit?: Maybe<Scalars["Int"]["output"]>
  /** URLs that can be used to share the discount. */
  shareableUrls: Array<DiscountShareableUrl>
  /** A short summary of the discount. */
  shortSummary: Scalars["String"]["output"]
  /** The date and time when the discount starts. */
  startsAt: Scalars["DateTime"]["output"]
  /** The status of the discount. */
  status: DiscountStatus
  /** A detailed summary of the discount. */
  summary: Scalars["String"]["output"]
  /** The title of the discount. */
  title: Scalars["String"]["output"]
  /** The total sales from orders where the discount was used. */
  totalSales?: Maybe<MoneyV2>
  /** The date and time when the discount was updated. */
  updatedAt: Scalars["DateTime"]["output"]
  /** The maximum number of times that the discount can be used. */
  usageLimit?: Maybe<Scalars["Int"]["output"]>
}

/** A code discount that offers customers a percentage or fixed amount discount on specific products, collections, or the entire order. */
export type DiscountCodeBasicCodesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  savedSearchId?: InputMaybe<Scalars["ID"]["input"]>
  sortKey?: InputMaybe<DiscountCodeSortKeys>
}

/** Return type for `discountCodeBasicCreate` mutation. */
export type DiscountCodeBasicCreatePayload = {
  __typename?: "DiscountCodeBasicCreatePayload"
  /** The created code discount. */
  codeDiscountNode?: Maybe<DiscountCodeNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** The input fields to create or update a basic code discount. */
export type DiscountCodeBasicInput = {
  /** Whether the discount can be applied only once per customer. */
  appliesOncePerCustomer?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The code to use the discount. */
  code?: InputMaybe<Scalars["String"]["input"]>
  /** Determines which discount classes the discount can combine with. */
  combinesWith?: InputMaybe<DiscountCombinesWithInput>
  /** The qualifying items in an order, the quantity of each one, and the total value of the discount. */
  customerGets?: InputMaybe<DiscountCustomerGetsInput>
  /** The customers that can use the discount. */
  customerSelection?: InputMaybe<DiscountCustomerSelectionInput>
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The minimum subtotal or quantity that's required for the discount to be applied. */
  minimumRequirement?: InputMaybe<DiscountMinimumRequirementInput>
  /** The number of times a discount applies on recurring purchases (subscriptions). */
  recurringCycleLimit?: InputMaybe<Scalars["Int"]["input"]>
  /** The date and time when the discount starts. */
  startsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The title of the discount. */
  title?: InputMaybe<Scalars["String"]["input"]>
  /** The maximum number of times that the discount can be used. For open-ended discounts, use `null`. */
  usageLimit?: InputMaybe<Scalars["Int"]["input"]>
}

/** Return type for `discountCodeBasicUpdate` mutation. */
export type DiscountCodeBasicUpdatePayload = {
  __typename?: "DiscountCodeBasicUpdatePayload"
  /** The updated code discount. */
  codeDiscountNode?: Maybe<DiscountCodeNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** Return type for `discountCodeBulkActivate` mutation. */
export type DiscountCodeBulkActivatePayload = {
  __typename?: "DiscountCodeBulkActivatePayload"
  /** The asynchronous job that activates the code discounts. */
  job?: Maybe<Job>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** Return type for `discountCodeBulkDeactivate` mutation. */
export type DiscountCodeBulkDeactivatePayload = {
  __typename?: "DiscountCodeBulkDeactivatePayload"
  /** The asynchronous job that deactivates the code discounts. */
  job?: Maybe<Job>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** Return type for `discountCodeBulkDelete` mutation. */
export type DiscountCodeBulkDeletePayload = {
  __typename?: "DiscountCodeBulkDeletePayload"
  /** The asynchronous job that deletes the code discounts. */
  job?: Maybe<Job>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** A code discount that offers customers a Buy X, Get Y (BXGY) discount. */
export type DiscountCodeBxgy = {
  __typename?: "DiscountCodeBxgy"
  /** Whether the discount can be applied only once per customer. */
  appliesOncePerCustomer: Scalars["Boolean"]["output"]
  /** The number of times that the discount has been used. */
  asyncUsageCount: Scalars["Int"]["output"]
  /** The number of redeem codes for the discount. */
  codeCount: Scalars["Int"]["output"]
  /** A list of redeem codes for the discount. */
  codes: DiscountRedeemCodeConnection
  /** Determines which discount classes the discount can combine with. */
  combinesWith: DiscountCombinesWith
  /** The date and time when the discount was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** The qualifying items and the quantity of each one that the customer has to buy to be eligible for the discount. */
  customerBuys: DiscountCustomerBuys
  /** The qualifying items in an order, the quantity of each one, and the total value of the discount. */
  customerGets: DiscountCustomerGets
  /** The customers that can use the discount. */
  customerSelection: DiscountCustomerSelection
  /** The class of the discount for combining purposes. */
  discountClass: MerchandiseDiscountClass
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: Maybe<Scalars["DateTime"]["output"]>
  /** Indicates whether there are any timeline comments on the discount. */
  hasTimelineComment: Scalars["Boolean"]["output"]
  /** URLs that can be used to share the discount. */
  shareableUrls: Array<DiscountShareableUrl>
  /** The date and time when the discount starts. */
  startsAt: Scalars["DateTime"]["output"]
  /** The status of the discount. */
  status: DiscountStatus
  /** A detailed summary of the discount. */
  summary: Scalars["String"]["output"]
  /** The title of the discount. */
  title: Scalars["String"]["output"]
  /** The total sales from orders where the discount was used. */
  totalSales?: Maybe<MoneyV2>
  /** The date and time when the discount was updated. */
  updatedAt: Scalars["DateTime"]["output"]
  /** The maximum number of times that the discount can be used. */
  usageLimit?: Maybe<Scalars["Int"]["output"]>
  /** The maximum number of times that the discount can be applied to an order. */
  usesPerOrderLimit?: Maybe<Scalars["Int"]["output"]>
}

/** A code discount that offers customers a Buy X, Get Y (BXGY) discount. */
export type DiscountCodeBxgyCodesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  savedSearchId?: InputMaybe<Scalars["ID"]["input"]>
  sortKey?: InputMaybe<DiscountCodeSortKeys>
}

/** Return type for `discountCodeBxgyCreate` mutation. */
export type DiscountCodeBxgyCreatePayload = {
  __typename?: "DiscountCodeBxgyCreatePayload"
  /** The created code discount. */
  codeDiscountNode?: Maybe<DiscountCodeNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** The input fields to create or update a BXGY code discount. */
export type DiscountCodeBxgyInput = {
  /** Whether the discount can be applied only once per customer. */
  appliesOncePerCustomer?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The code to use the discount. */
  code?: InputMaybe<Scalars["String"]["input"]>
  /** Determines which discount classes the discount can combine with. */
  combinesWith?: InputMaybe<DiscountCombinesWithInput>
  /** The qualifying items and the quantity of each one that the customer has to buy to be eligible for the discount. */
  customerBuys?: InputMaybe<DiscountCustomerBuysInput>
  /** The qualifying items that will be discounted, the quantity of each one, and the total value of the discount. */
  customerGets?: InputMaybe<DiscountCustomerGetsInput>
  /** The customers that are eligible to use the discount. */
  customerSelection?: InputMaybe<DiscountCustomerSelectionInput>
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The date and time when the discount starts. */
  startsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The title of the discount. */
  title?: InputMaybe<Scalars["String"]["input"]>
  /** The maximum number of times that the discount can be used. For open-ended discounts, use `null`. */
  usageLimit?: InputMaybe<Scalars["Int"]["input"]>
  /** The maximum number of times that the discount can be applied to an order. */
  usesPerOrderLimit?: InputMaybe<Scalars["Int"]["input"]>
}

/** Return type for `discountCodeBxgyUpdate` mutation. */
export type DiscountCodeBxgyUpdatePayload = {
  __typename?: "DiscountCodeBxgyUpdatePayload"
  /** The updated code discount. */
  codeDiscountNode?: Maybe<DiscountCodeNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** Return type for `discountCodeDeactivate` mutation. */
export type DiscountCodeDeactivatePayload = {
  __typename?: "DiscountCodeDeactivatePayload"
  /** The deactivated code discount. */
  codeDiscountNode?: Maybe<DiscountCodeNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** Return type for `discountCodeDelete` mutation. */
export type DiscountCodeDeletePayload = {
  __typename?: "DiscountCodeDeletePayload"
  /** The deleted code discount ID. */
  deletedCodeDiscountId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** A code discount that offers customers free shipping on their order. */
export type DiscountCodeFreeShipping = {
  __typename?: "DiscountCodeFreeShipping"
  /** Whether the discount applies on regular one-time-purchase shipping lines. */
  appliesOnOneTimePurchase: Scalars["Boolean"]["output"]
  /** Whether the discount applies on subscription shipping lines. */
  appliesOnSubscription: Scalars["Boolean"]["output"]
  /** Whether the discount can be applied only once per customer. */
  appliesOncePerCustomer: Scalars["Boolean"]["output"]
  /** The number of times that the discount has been used. */
  asyncUsageCount: Scalars["Int"]["output"]
  /** The number of redeem codes for the discount. */
  codeCount: Scalars["Int"]["output"]
  /** A list of redeem codes for the discount. */
  codes: DiscountRedeemCodeConnection
  /** Determines which discount classes the discount can combine with. */
  combinesWith: DiscountCombinesWith
  /** The date and time when the discount was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** The customers that can use the discount. */
  customerSelection: DiscountCustomerSelection
  /** A shipping destination that qualifies for the discount. */
  destinationSelection: DiscountShippingDestinationSelection
  /** The class of the discount for combining purposes. */
  discountClass: ShippingDiscountClass
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: Maybe<Scalars["DateTime"]["output"]>
  /** Indicates whether there are any timeline comments on the discount. */
  hasTimelineComment: Scalars["Boolean"]["output"]
  /** The maximum shipping price amount accepted to qualify for the discount. */
  maximumShippingPrice?: Maybe<MoneyV2>
  /** The minimum subtotal or quantity that's required for the discount to be applied. */
  minimumRequirement?: Maybe<DiscountMinimumRequirement>
  /** The number of times a discount applies on recurring purchases (subscriptions). */
  recurringCycleLimit?: Maybe<Scalars["Int"]["output"]>
  /** URLs that can be used to share the discount. */
  shareableUrls: Array<DiscountShareableUrl>
  /** A short summary of the discount. */
  shortSummary: Scalars["String"]["output"]
  /** The date and time when the discount starts. */
  startsAt: Scalars["DateTime"]["output"]
  /** The status of the discount. */
  status: DiscountStatus
  /** A detailed summary of the discount. */
  summary: Scalars["String"]["output"]
  /** The title of the discount. */
  title: Scalars["String"]["output"]
  /** The total sales from orders where the discount was used. */
  totalSales?: Maybe<MoneyV2>
  /** The date and time when the discount was updated. */
  updatedAt: Scalars["DateTime"]["output"]
  /** The maximum number of times that the discount can be used. */
  usageLimit?: Maybe<Scalars["Int"]["output"]>
}

/** A code discount that offers customers free shipping on their order. */
export type DiscountCodeFreeShippingCodesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  savedSearchId?: InputMaybe<Scalars["ID"]["input"]>
  sortKey?: InputMaybe<DiscountCodeSortKeys>
}

/** Return type for `discountCodeFreeShippingCreate` mutation. */
export type DiscountCodeFreeShippingCreatePayload = {
  __typename?: "DiscountCodeFreeShippingCreatePayload"
  /** The created code discount. */
  codeDiscountNode?: Maybe<DiscountCodeNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** The input fields to create or update a free shipping code discount. */
export type DiscountCodeFreeShippingInput = {
  /** Whether the discount applies on regular one-time-purchase items. */
  appliesOnOneTimePurchase?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Whether the discount applies on subscription items. */
  appliesOnSubscription?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Whether the discount can be applied only once per customer. */
  appliesOncePerCustomer?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The code to use the discount. */
  code?: InputMaybe<Scalars["String"]["input"]>
  /** Determines which discount classes the shipping discount can combine with. */
  combinesWith?: InputMaybe<DiscountCombinesWithInput>
  /** The customers that are eligible to use the discount. */
  customerSelection?: InputMaybe<DiscountCustomerSelectionInput>
  /** A list of destinations where the discount will apply. */
  destination?: InputMaybe<DiscountShippingDestinationSelectionInput>
  /** The date and time when the discount ends. For open-ended discounts, use `null`. */
  endsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The maximum shipping price that qualifies for the discount. */
  maximumShippingPrice?: InputMaybe<Scalars["Decimal"]["input"]>
  /** The minimum subtotal or quantity that's required for the discount to be applied. */
  minimumRequirement?: InputMaybe<DiscountMinimumRequirementInput>
  /** The number of times a discount applies on recurring purchases (subscriptions). */
  recurringCycleLimit?: InputMaybe<Scalars["Int"]["input"]>
  /** The date and time when the discount starts. */
  startsAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The title of the discount. */
  title?: InputMaybe<Scalars["String"]["input"]>
  /** The maximum number of times that the discount can be used. For open-ended discounts, use `null`. */
  usageLimit?: InputMaybe<Scalars["Int"]["input"]>
}

/** Return type for `discountCodeFreeShippingUpdate` mutation. */
export type DiscountCodeFreeShippingUpdatePayload = {
  __typename?: "DiscountCodeFreeShippingUpdatePayload"
  /** The updated code discount. */
  codeDiscountNode?: Maybe<DiscountCodeNode>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** A node containing a code discount and its related events. */
export type DiscountCodeNode = HasEvents &
  HasMetafieldDefinitions &
  HasMetafields &
  Node & {
    __typename?: "DiscountCodeNode"
    /** The underlying code discount object. */
    codeDiscount: DiscountCode
    /** The paginated list of events associated with the host subject. */
    events: EventConnection
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafield definitions. */
    metafieldDefinitions: MetafieldDefinitionConnection
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
  }

/** A node containing a code discount and its related events. */
export type DiscountCodeNodeEventsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<EventSortKeys>
}

/** A node containing a code discount and its related events. */
export type DiscountCodeNodeMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/** A node containing a code discount and its related events. */
export type DiscountCodeNodeMetafieldDefinitionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  pinnedStatus?: InputMaybe<MetafieldDefinitionPinnedStatus>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<MetafieldDefinitionSortKeys>
}

/** A node containing a code discount and its related events. */
export type DiscountCodeNodeMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** A node containing a code discount and its related events. */
export type DiscountCodeNodePrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/** A node containing a code discount and its related events. */
export type DiscountCodeNodePrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple DiscountCodeNodes.
 *
 */
export type DiscountCodeNodeConnection = {
  __typename?: "DiscountCodeNodeConnection"
  /** A list of edges. */
  edges: Array<DiscountCodeNodeEdge>
  /** A list of the nodes contained in DiscountCodeNodeEdge. */
  nodes: Array<DiscountCodeNode>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one DiscountCodeNode and a cursor during pagination.
 *
 */
export type DiscountCodeNodeEdge = {
  __typename?: "DiscountCodeNodeEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DiscountCodeNodeEdge. */
  node: DiscountCodeNode
}

/** Return type for `discountCodeRedeemCodeBulkDelete` mutation. */
export type DiscountCodeRedeemCodeBulkDeletePayload = {
  __typename?: "DiscountCodeRedeemCodeBulkDeletePayload"
  /** The asynchronous job that deletes the discount redeem codes. */
  job?: Maybe<Job>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** The set of valid sort keys for the DiscountCode query. */
export enum DiscountCodeSortKeys {
  /** Sort by the `code` value. */
  Code = "CODE",
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
}

/** A list of collections that the discount can have as a prerequisite or a list of collections to which the discount can be applied. */
export type DiscountCollections = {
  __typename?: "DiscountCollections"
  /** The list of collections that the discount can have as a prerequisite or the list of collections to which the discount can be applied. */
  collections: CollectionConnection
}

/** A list of collections that the discount can have as a prerequisite or a list of collections to which the discount can be applied. */
export type DiscountCollectionsCollectionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** The input fields for collections attached to a discount. */
export type DiscountCollectionsInput = {
  /** Specifies list of collection ids to add. */
  add?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /** Specifies list of collection ids to remove. */
  remove?: InputMaybe<Array<Scalars["ID"]["input"]>>
}

/** Determines which discount classes the discount can combine with. */
export type DiscountCombinesWith = {
  __typename?: "DiscountCombinesWith"
  /** Combines with order discounts. */
  orderDiscounts: Scalars["Boolean"]["output"]
  /** Combines with product discounts. */
  productDiscounts: Scalars["Boolean"]["output"]
  /** Combines with shipping discounts. */
  shippingDiscounts: Scalars["Boolean"]["output"]
}

/** The input fields to determine which discount classes the discount can combine with. */
export type DiscountCombinesWithInput = {
  /** Combines with order discounts. */
  orderDiscounts?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Combines with product discounts. */
  productDiscounts?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Combines with shipping discounts. */
  shippingDiscounts?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** The shipping destinations where the discount can be applied. */
export type DiscountCountries = {
  __typename?: "DiscountCountries"
  /** The codes for the countries where the discount can be applied. */
  countries: Array<CountryCode>
  /** Whether the discount is applicable to countries that haven't been defined in the shop's shipping zones. */
  includeRestOfWorld: Scalars["Boolean"]["output"]
}

/** The input fields for a list of countries to add or remove from the free shipping discount. */
export type DiscountCountriesInput = {
  /** The country codes to add to the list of countries where the discount applies. */
  add?: InputMaybe<Array<CountryCode>>
  /** Whether the discount code is applicable to countries that haven't been defined in the shop's shipping zones. */
  includeRestOfWorld?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The country codes to remove from the list of countries where the discount applies. */
  remove?: InputMaybe<Array<CountryCode>>
}

/** The `DiscountCountryAll` object lets you target all countries as shipping destination for discount eligibility. */
export type DiscountCountryAll = {
  __typename?: "DiscountCountryAll"
  /** Whether the discount can be applied to all countries as shipping destination. This value is always `true`. */
  allCountries: Scalars["Boolean"]["output"]
}

/** The `DiscountCustomerAll` object lets you target all customers for discount eligibility. */
export type DiscountCustomerAll = {
  __typename?: "DiscountCustomerAll"
  /** Whether the discount can be applied by all customers. This value is always `true`. */
  allCustomers: Scalars["Boolean"]["output"]
}

/** The prerequisite items and prerequisite value that a customer must have on the order for the discount to be applicable. */
export type DiscountCustomerBuys = {
  __typename?: "DiscountCustomerBuys"
  /** The items required for the discount to be applicable. */
  items: DiscountItems
  /** The prerequisite value. */
  value: DiscountCustomerBuysValue
}

/** The input fields for prerequisite items and quantity for the discount. */
export type DiscountCustomerBuysInput = {
  /** The IDs of items that the customer buys. The items can be either collections or products. */
  items?: InputMaybe<DiscountItemsInput>
  /** The quantity of prerequisite items. */
  value?: InputMaybe<DiscountCustomerBuysValueInput>
}

/** The prerequisite for the discount to be applicable. For example, the discount might require a customer to buy a minimum quantity of select items. Alternatively, the discount might require a customer to spend a minimum amount on select items. */
export type DiscountCustomerBuysValue = DiscountPurchaseAmount | DiscountQuantity

/** The input fields for prerequisite quantity or minimum purchase amount required for the discount. */
export type DiscountCustomerBuysValueInput = {
  /** The prerequisite minimum purchase amount required for the discount to be applicable. */
  amount?: InputMaybe<Scalars["Decimal"]["input"]>
  /** The quantity of prerequisite items. */
  quantity?: InputMaybe<Scalars["UnsignedInt64"]["input"]>
}

/** The qualifying items in an order, the quantity of each one, and the total value of the discount. */
export type DiscountCustomerGets = {
  __typename?: "DiscountCustomerGets"
  /** Whether the discount applies on regular one-time-purchase items. */
  appliesOnOneTimePurchase: Scalars["Boolean"]["output"]
  /** Whether the discount applies on subscription items. */
  appliesOnSubscription: Scalars["Boolean"]["output"]
  /** The items to which the discount applies. */
  items: DiscountItems
  /** Entitled quantity and the discount value. */
  value: DiscountCustomerGetsValue
}

/** Specifies the items that will be discounted, the quantity of items that will be discounted, and the value of discount. */
export type DiscountCustomerGetsInput = {
  /** Whether the discount applies on regular one-time-purchase items. */
  appliesOnOneTimePurchase?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Whether the discount applies on subscription items. */
  appliesOnSubscription?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The IDs of the items that the customer gets. The items can be either collections or products. */
  items?: InputMaybe<DiscountItemsInput>
  /** The quantity of items discounted and the discount value. */
  value?: InputMaybe<DiscountCustomerGetsValueInput>
}

/** The type of the discount value and how it will be applied. For example, it might be a percentage discount on a fixed number of items. Alternatively, it might be a fixed amount evenly distributed across all items or on each individual item. A third example is a percentage discount on all items. */
export type DiscountCustomerGetsValue = DiscountAmount | DiscountOnQuantity | DiscountPercentage

/** The input fields for the quantity of items discounted and the discount value. */
export type DiscountCustomerGetsValueInput = {
  /** The value of the discount. */
  discountAmount?: InputMaybe<DiscountAmountInput>
  /** The quantity of the items that are discounted and the discount value. */
  discountOnQuantity?: InputMaybe<DiscountOnQuantityInput>
  /** The percentage value of the discount. Value must be between 0.00 - 1.00. */
  percentage?: InputMaybe<Scalars["Float"]["input"]>
}

/** A list of customer segments that contain the customers that the discount applies to. */
export type DiscountCustomerSegments = {
  __typename?: "DiscountCustomerSegments"
  /** A list of customer segments that contain the customers who can use the discount. */
  segments: Array<Segment>
}

/** The input fields for which customer segments to add to or remove from the discount. */
export type DiscountCustomerSegmentsInput = {
  /** A list of customer segments to add to the current list of customer segments. */
  add?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /** A list of customer segments to remove from the current list of customer segments. */
  remove?: InputMaybe<Array<Scalars["ID"]["input"]>>
}

/** The type used for targeting a set of customers who are eligible for the discount. For example, the discount might be available to all customers or it might only be available to a specific set of customers. You can define the set of customers by targeting a list of customer segments, or by targeting a list of specific customers. */
export type DiscountCustomerSelection = DiscountCustomerAll | DiscountCustomerSegments | DiscountCustomers

/** The input fields for the customers who can use this discount. */
export type DiscountCustomerSelectionInput = {
  /** Whether all customers can use this discount. */
  all?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The list of customer segment IDs to add or remove from the list of customer segments. */
  customerSegments?: InputMaybe<DiscountCustomerSegmentsInput>
  /** The list of customer IDs to add or remove from the list of customers. */
  customers?: InputMaybe<DiscountCustomersInput>
}

/** A list of customers eligible for the discount. */
export type DiscountCustomers = {
  __typename?: "DiscountCustomers"
  /** The list of customers eligible for the discount. */
  customers: Array<Customer>
}

/** The input fields for which customers to add to or remove from the discount. */
export type DiscountCustomersInput = {
  /** A list of customers to add to the current list of customers who can use the discount. */
  add?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /** A list of customers to remove from the current list of customers who can use the discount. */
  remove?: InputMaybe<Array<Scalars["ID"]["input"]>>
}

/** The type of discount that will be applied. Currently, only a percentage discount is supported. */
export type DiscountEffect = DiscountAmount | DiscountPercentage

/** The input fields for how the discount will be applied. Currently, only percentage off is supported. */
export type DiscountEffectInput = {
  /** The percentage value of the discount. Value must be between 0.00 - 1.00. */
  percentage?: InputMaybe<Scalars["Float"]["input"]>
}

/** Possible error codes that can be returned by `DiscountUserError`. */
export enum DiscountErrorCode {
  /** The active period overlaps with other automatic discounts. At any given time, only one automatic discount can be active. */
  ActivePeriodOverlap = "ACTIVE_PERIOD_OVERLAP",
  /** The input value is blank. */
  Blank = "BLANK",
  /** The attribute selection contains conflicting settings. */
  Conflict = "CONFLICT",
  /** The input value is already present. */
  Duplicate = "DUPLICATE",
  /** The input value should be equal to the value allowed. */
  EqualTo = "EQUAL_TO",
  /** The value exceeded the maximum allowed value. */
  ExceededMax = "EXCEEDED_MAX",
  /** The input value should be greater than the minimum allowed value. */
  GreaterThan = "GREATER_THAN",
  /** The input value should be greater than or equal to the minimum value allowed. */
  GreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO",
  /** The value is already present through another selection. */
  ImplicitDuplicate = "IMPLICIT_DUPLICATE",
  /** The input value isn't included in the list. */
  Inclusion = "INCLUSION",
  /** Unexpected internal error happened. */
  InternalError = "INTERNAL_ERROR",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** The `combinesWith` settings are invalid for the discount class. */
  InvalidCombinesWithForDiscountClass = "INVALID_COMBINES_WITH_FOR_DISCOUNT_CLASS",
  /** The discountClass is invalid for the price rule. */
  InvalidDiscountClassForPriceRule = "INVALID_DISCOUNT_CLASS_FOR_PRICE_RULE",
  /** The input value should be less than the maximum value allowed. */
  LessThan = "LESS_THAN",
  /** The input value should be less than or equal to the maximum value allowed. */
  LessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO",
  /** The active period overlaps with too many other app-provided discounts. There's a limit on the number of app discounts that can be active at any given time. */
  MaxAppDiscounts = "MAX_APP_DISCOUNTS",
  /** Specify a minimum subtotal or a quantity, but not both. */
  MinimumSubtotalAndQuantityRangeBothPresent = "MINIMUM_SUBTOTAL_AND_QUANTITY_RANGE_BOTH_PRESENT",
  /** Missing a required argument. */
  MissingArgument = "MISSING_ARGUMENT",
  /** The input value needs to be blank. */
  Present = "PRESENT",
  /** The input value is already taken. */
  Taken = "TAKEN",
  /** The input value is too long. */
  TooLong = "TOO_LONG",
  /** Too many arguments provided. */
  TooManyArguments = "TOO_MANY_ARGUMENTS",
  /** The input value is too short. */
  TooShort = "TOO_SHORT",
  /** The value is outside of the allowed range. */
  ValueOutsideRange = "VALUE_OUTSIDE_RANGE",
}

/** The type used to target the items required for discount eligibility, or the items to which the application of a discount might apply. For example, for a customer to be eligible for a discount, they're required to add an item from a specified collection to their order. Alternatively, a customer might be required to add a specific product or product variant. When using this type to target which items the discount will apply to, the discount might apply to all items on the order, or to specific products and product variants, or items in a given collection. */
export type DiscountItems = AllDiscountItems | DiscountCollections | DiscountProducts

/**
 * The input fields for the items attached to a discount. You can specify the discount items by product ID or collection ID.
 *
 */
export type DiscountItemsInput = {
  /** Whether all items should be selected. */
  all?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The collections that are attached to a discount. */
  collections?: InputMaybe<DiscountCollectionsInput>
  /** The products and product variants that are attached to a discount. */
  products?: InputMaybe<DiscountProductsInput>
}

/** The minimum quantity of items required for the discount to apply. */
export type DiscountMinimumQuantity = {
  __typename?: "DiscountMinimumQuantity"
  /** The minimum quantity of items that's required for the discount to be applied. */
  greaterThanOrEqualToQuantity: Scalars["UnsignedInt64"]["output"]
}

/** The input fields for the minimum quantity required for the discount. */
export type DiscountMinimumQuantityInput = {
  /** The minimum quantity of items that's required for the discount to be applied. */
  greaterThanOrEqualToQuantity?: InputMaybe<Scalars["UnsignedInt64"]["input"]>
}

/** The type of minimum requirement that must be met for the discount to be applied. For example, a customer must spend a minimum subtotal to be eligible for the discount. Alternatively, a customer must purchase a minimum quantity of items to be eligible for the discount. */
export type DiscountMinimumRequirement = DiscountMinimumQuantity | DiscountMinimumSubtotal

/** The input fields for the minimum quantity or subtotal required for a discount. */
export type DiscountMinimumRequirementInput = {
  /** The minimum required quantity. */
  quantity?: InputMaybe<DiscountMinimumQuantityInput>
  /** The minimum required subtotal. */
  subtotal?: InputMaybe<DiscountMinimumSubtotalInput>
}

/** The minimum subtotal required for the discount to apply. */
export type DiscountMinimumSubtotal = {
  __typename?: "DiscountMinimumSubtotal"
  /** The minimum subtotal that's required for the discount to be applied. */
  greaterThanOrEqualToSubtotal: MoneyV2
}

/** The input fields for the minimum subtotal required for a discount. */
export type DiscountMinimumSubtotalInput = {
  /** The minimum subtotal that's required for the discount to be applied. */
  greaterThanOrEqualToSubtotal?: InputMaybe<Scalars["Decimal"]["input"]>
}

/** A discount wrapper node. */
export type DiscountNode = HasEvents &
  HasMetafieldDefinitions &
  HasMetafields &
  Node & {
    __typename?: "DiscountNode"
    /** A discount. */
    discount: Discount
    /** The paginated list of events associated with the host subject. */
    events: EventConnection
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafield definitions. */
    metafieldDefinitions: MetafieldDefinitionConnection
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
  }

/** A discount wrapper node. */
export type DiscountNodeEventsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<EventSortKeys>
}

/** A discount wrapper node. */
export type DiscountNodeMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/** A discount wrapper node. */
export type DiscountNodeMetafieldDefinitionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  pinnedStatus?: InputMaybe<MetafieldDefinitionPinnedStatus>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<MetafieldDefinitionSortKeys>
}

/** A discount wrapper node. */
export type DiscountNodeMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** A discount wrapper node. */
export type DiscountNodePrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/** A discount wrapper node. */
export type DiscountNodePrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple DiscountNodes.
 *
 */
export type DiscountNodeConnection = {
  __typename?: "DiscountNodeConnection"
  /** A list of edges. */
  edges: Array<DiscountNodeEdge>
  /** A list of the nodes contained in DiscountNodeEdge. */
  nodes: Array<DiscountNode>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one DiscountNode and a cursor during pagination.
 *
 */
export type DiscountNodeEdge = {
  __typename?: "DiscountNodeEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DiscountNodeEdge. */
  node: DiscountNode
}

/** The quantity of items discounted, the discount value, and how the discount will be applied. */
export type DiscountOnQuantity = {
  __typename?: "DiscountOnQuantity"
  /** The discount's effect on qualifying items. */
  effect: DiscountEffect
  /** The number of items being discounted. The customer must have at least this many items of specified products or product variants in their order to be eligible for the discount. */
  quantity: DiscountQuantity
}

/** The input fields for the quantity of items discounted and the discount value. */
export type DiscountOnQuantityInput = {
  /** The percentage value of the discount. */
  effect?: InputMaybe<DiscountEffectInput>
  /** The quantity of items that are discounted. */
  quantity?: InputMaybe<Scalars["UnsignedInt64"]["input"]>
}

/** A discount effect that gives customers a percentage off of specified items on their order. */
export type DiscountPercentage = {
  __typename?: "DiscountPercentage"
  /** The percentage value of the discount. */
  percentage: Scalars["Float"]["output"]
}

/** A list of products and product variants that the discount can have as a prerequisite or a list of products and product variants to which the discount can be applied. */
export type DiscountProducts = {
  __typename?: "DiscountProducts"
  /** The list of product variants that the discount can have as a prerequisite or the list of product variants to which the discount can be applied. */
  productVariants: ProductVariantConnection
  /** The list of products that the discount can have as a prerequisite or the list of products to which the discount can be applied. */
  products: ProductConnection
}

/** A list of products and product variants that the discount can have as a prerequisite or a list of products and product variants to which the discount can be applied. */
export type DiscountProductsProductVariantsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** A list of products and product variants that the discount can have as a prerequisite or a list of products and product variants to which the discount can be applied. */
export type DiscountProductsProductsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** The input fields for the products and product variants attached to a discount. */
export type DiscountProductsInput = {
  /** Specifies list of product variant ids to add. */
  productVariantsToAdd?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /** Specifies list of product variant ids to remove. */
  productVariantsToRemove?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /** Specifies list of product ids to add. */
  productsToAdd?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /** Specifies list of product ids to remove. */
  productsToRemove?: InputMaybe<Array<Scalars["ID"]["input"]>>
}

/** A purchase amount in the context of a discount. This object can be used to define the minimum purchase amount required for a discount to be applicable. */
export type DiscountPurchaseAmount = {
  __typename?: "DiscountPurchaseAmount"
  /** The purchase amount in decimal format. */
  amount: Scalars["Decimal"]["output"]
}

/** A quantity of items in the context of a discount. This object can be used to define the minimum quantity of items required to apply a discount. Alternatively, it can be used to define the quantity of items that can be discounted. */
export type DiscountQuantity = {
  __typename?: "DiscountQuantity"
  /** The quantity of items. */
  quantity: Scalars["UnsignedInt64"]["output"]
}

/** A code that a customer can use at checkout to receive a discount. For example, a customer can use the redeem code 'SUMMER20' at checkout to receive a 20% discount on their entire order. */
export type DiscountRedeemCode = {
  __typename?: "DiscountRedeemCode"
  /** The number of times that the discount redeem code has been used. This value is updated asynchronously and can be different than the actual usage count. */
  asyncUsageCount: Scalars["Int"]["output"]
  /** The code that a customer can use at checkout to receive a discount. */
  code: Scalars["String"]["output"]
  /** The application that created the discount redeem code. */
  createdBy?: Maybe<App>
  /** A globally-unique ID of the discount redeem code. */
  id: Scalars["ID"]["output"]
}

/** Return type for `discountRedeemCodeBulkAdd` mutation. */
export type DiscountRedeemCodeBulkAddPayload = {
  __typename?: "DiscountRedeemCodeBulkAddPayload"
  /** The ID of the discount redeem code bulk creation operation. The properties and status of the operation can be tracked using the [`DiscountRedeemCodeBulkCreation` query](https://shopify.dev/api/admin-graphql/2022-04/queries/discountRedeemCodeBulkCreation). */
  bulkCreation?: Maybe<DiscountRedeemCodeBulkCreation>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DiscountUserError>
}

/** The properties and status of a bulk discount redeem code creation operation. */
export type DiscountRedeemCodeBulkCreation = Node & {
  __typename?: "DiscountRedeemCodeBulkCreation"
  /** The result of each code creation operation associated with the bulk creation operation including any errors that might have occurred during the operation. */
  codes: DiscountRedeemCodeBulkCreationCodeConnection
  /** The number of codes to create. */
  codesCount: Scalars["Int"]["output"]
  /** The date and time when the bulk creation was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** The code discount associated with the created codes. */
  discountCode?: Maybe<DiscountCodeNode>
  /** Whether the bulk creation is still queued (`false`) or has been run (`true`). */
  done: Scalars["Boolean"]["output"]
  /** The number of codes that weren't created successfully. */
  failedCount: Scalars["Int"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The number of codes created successfully. */
  importedCount: Scalars["Int"]["output"]
}

/** The properties and status of a bulk discount redeem code creation operation. */
export type DiscountRedeemCodeBulkCreationCodesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** A result of a discount redeem code creation operation created by a bulk creation. */
export type DiscountRedeemCodeBulkCreationCode = {
  __typename?: "DiscountRedeemCodeBulkCreationCode"
  /** The code to use in the discount redeem code creation operation. */
  code: Scalars["String"]["output"]
  /**
   * The successfully created discount redeem code.
   *
   * If the discount redeem code couldn't be created, then this field is `null``.
   *
   */
  discountRedeemCode?: Maybe<DiscountRedeemCode>
  /** A list of errors that occurred during the creation operation of the discount redeem code. */
  errors: Array<DiscountUserError>
}

/**
 * An auto-generated type for paginating through multiple DiscountRedeemCodeBulkCreationCodes.
 *
 */
export type DiscountRedeemCodeBulkCreationCodeConnection = {
  __typename?: "DiscountRedeemCodeBulkCreationCodeConnection"
  /** A list of edges. */
  edges: Array<DiscountRedeemCodeBulkCreationCodeEdge>
  /** A list of the nodes contained in DiscountRedeemCodeBulkCreationCodeEdge. */
  nodes: Array<DiscountRedeemCodeBulkCreationCode>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one DiscountRedeemCodeBulkCreationCode and a cursor during pagination.
 *
 */
export type DiscountRedeemCodeBulkCreationCodeEdge = {
  __typename?: "DiscountRedeemCodeBulkCreationCodeEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DiscountRedeemCodeBulkCreationCodeEdge. */
  node: DiscountRedeemCodeBulkCreationCode
}

/**
 * An auto-generated type for paginating through multiple DiscountRedeemCodes.
 *
 */
export type DiscountRedeemCodeConnection = {
  __typename?: "DiscountRedeemCodeConnection"
  /** A list of edges. */
  edges: Array<DiscountRedeemCodeEdge>
  /** A list of the nodes contained in DiscountRedeemCodeEdge. */
  nodes: Array<DiscountRedeemCode>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one DiscountRedeemCode and a cursor during pagination.
 *
 */
export type DiscountRedeemCodeEdge = {
  __typename?: "DiscountRedeemCodeEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DiscountRedeemCodeEdge. */
  node: DiscountRedeemCode
}

/** The input fields for the redeem code to attach to a discount. */
export type DiscountRedeemCodeInput = {
  /** The code that a customer can use at checkout to receive the associated discount. */
  code: Scalars["String"]["input"]
}

/** A shareable URL for a discount code. */
export type DiscountShareableUrl = {
  __typename?: "DiscountShareableUrl"
  /** The image URL of the item (product or collection) to which the discount applies. */
  targetItemImage?: Maybe<Image>
  /** The type of page that's associated with the URL. */
  targetType: DiscountShareableUrlTargetType
  /** The title of the page that's associated with the URL. */
  title: Scalars["String"]["output"]
  /** The URL for the discount code. */
  url: Scalars["URL"]["output"]
}

/** The type of page where a shareable discount URL lands. */
export enum DiscountShareableUrlTargetType {
  /** The URL lands on a collection page. */
  Collection = "COLLECTION",
  /** The URL lands on a home page. */
  Home = "HOME",
  /** The URL lands on a product page. */
  Product = "PRODUCT",
}

/** The type used to target the eligible countries of an order's shipping destination for which the discount applies. For example, the discount might be applicable when shipping to all countries, or only to a set of countries. */
export type DiscountShippingDestinationSelection = DiscountCountries | DiscountCountryAll

/** The input fields for the destinations where the free shipping discount will be applied. */
export type DiscountShippingDestinationSelectionInput = {
  /** Whether the discount code applies to all countries. */
  all?: InputMaybe<Scalars["Boolean"]["input"]>
  /** A list of countries where the discount code will apply. */
  countries?: InputMaybe<DiscountCountriesInput>
}

/** The set of valid sort keys for the Discount query. */
export enum DiscountSortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `ends_at` value. */
  EndsAt = "ENDS_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `starts_at` value. */
  StartsAt = "STARTS_AT",
  /** Sort by the `title` value. */
  Title = "TITLE",
  /** Sort by the `updated_at` value. */
  UpdatedAt = "UPDATED_AT",
}

/** The status of the discount. */
export enum DiscountStatus {
  /** The discount is active. */
  Active = "ACTIVE",
  /** The discount is expired. */
  Expired = "EXPIRED",
  /** The discount is scheduled. */
  Scheduled = "SCHEDULED",
}

/** The type of line (line item or shipping line) on an order that the subscription discount is applicable towards. */
export enum DiscountTargetType {
  /** The discount applies onto line items. */
  LineItem = "LINE_ITEM",
  /** The discount applies onto shipping lines. */
  ShippingLine = "SHIPPING_LINE",
}

/** The type of the subscription discount. */
export enum DiscountType {
  /** Automatic discount type. */
  AutomaticDiscount = "AUTOMATIC_DISCOUNT",
  /** Code discount type. */
  CodeDiscount = "CODE_DISCOUNT",
  /** Manual discount type. */
  Manual = "MANUAL",
}

/** An error that occurs during the execution of a discount mutation. */
export type DiscountUserError = DisplayableError & {
  __typename?: "DiscountUserError"
  /** The error code. */
  code?: Maybe<DiscountErrorCode>
  /** Extra information about this error. */
  extraInfo?: Maybe<Scalars["String"]["output"]>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Represents an error in the input of a mutation. */
export type DisplayableError = {
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Return type for `disputeEvidenceUpdate` mutation. */
export type DisputeEvidenceUpdatePayload = {
  __typename?: "DisputeEvidenceUpdatePayload"
  /** The updated dispute evidence. */
  disputeEvidence?: Maybe<ShopifyPaymentsDisputeEvidence>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DisputeEvidenceUpdateUserError>
}

/** An error that occurs during the execution of `DisputeEvidenceUpdate`. */
export type DisputeEvidenceUpdateUserError = DisplayableError & {
  __typename?: "DisputeEvidenceUpdateUserError"
  /** The error code. */
  code?: Maybe<DisputeEvidenceUpdateUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `DisputeEvidenceUpdateUserError`. */
export enum DisputeEvidenceUpdateUserErrorCode {
  /** Dispute evidence could not be found. */
  DisputeEvidenceNotFound = "DISPUTE_EVIDENCE_NOT_FOUND",
  /** Evidence already accepted. */
  EvidenceAlreadyAccepted = "EVIDENCE_ALREADY_ACCEPTED",
  /** Evidence past due date. */
  EvidencePastDueDate = "EVIDENCE_PAST_DUE_DATE",
  /** Combined files size is too large. */
  FilesSizeExceededLimit = "FILES_SIZE_EXCEEDED_LIMIT",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** Individual file size is too large. */
  TooLarge = "TOO_LARGE",
}

/** The possible statuses of a dispute. */
export enum DisputeStatus {
  Accepted = "ACCEPTED",
  ChargeRefunded = "CHARGE_REFUNDED",
  Lost = "LOST",
  NeedsResponse = "NEEDS_RESPONSE",
  UnderReview = "UNDER_REVIEW",
  Won = "WON",
}

/** The possible types for a dispute. */
export enum DisputeType {
  /** The dispute has turned into a chargeback. */
  Chargeback = "CHARGEBACK",
  /** The dispute is in the inquiry phase. */
  Inquiry = "INQUIRY",
}

/** A unique string that represents the address of a Shopify store on the Internet. */
export type Domain = Node & {
  __typename?: "Domain"
  /** The host name of the domain. For example, `example.com`. */
  host: Scalars["String"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The localization of the domain, if the domain doesn't redirect. */
  localization?: Maybe<DomainLocalization>
  /** The web presence of the domain. */
  marketWebPresence?: Maybe<MarketWebPresence>
  /** Whether SSL is enabled. */
  sslEnabled: Scalars["Boolean"]["output"]
  /** The URL of the domain (for example, `https://example.com`). */
  url: Scalars["URL"]["output"]
}

/** The country and language settings assigned to a domain. */
export type DomainLocalization = {
  __typename?: "DomainLocalization"
  /** The ISO codes for the domain’s alternate locales. For example, `["en"]`. */
  alternateLocales: Array<Scalars["String"]["output"]>
  /** The ISO code for the country assigned to the domain. For example, `"CA"` or "*" for a domain set to "Rest of world". */
  country?: Maybe<Scalars["String"]["output"]>
  /** The ISO code for the domain’s default locale. For example, `"en"`. */
  defaultLocale: Scalars["String"]["output"]
}

/**
 * An order that a merchant creates on behalf of a customer. Draft orders are useful for merchants that need to do the following tasks:
 *
 * - Create new orders for sales made by phone, in person, by chat, or elsewhere. When a merchant accepts payment for a draft order, an order is created.
 * - Send invoices to customers to pay with a secure checkout link.
 * - Use custom items to represent additional costs or products that aren't displayed in a shop's inventory.
 * - Re-create orders manually from active sales channels.
 * - Sell products at discount or wholesale rates.
 * - Take pre-orders.
 * - Save an order as a draft and resume working on it later.
 *
 * For Draft orders in multiple currencies `presentment_money` is the source of truth for what a customer is going to be charged and `shop_money` is an estimate of what the merchant might receive in their local currency.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type DraftOrder = CommentEventSubject &
  HasEvents &
  HasLocalizationExtensions &
  HasMetafields &
  LegacyInteroperability &
  Navigable &
  Node & {
    __typename?: "DraftOrder"
    /** The order-level discount applied to the draft order. */
    appliedDiscount?: Maybe<DraftOrderAppliedDiscount>
    /**
     * The billing address of the customer.
     *
     */
    billingAddress?: Maybe<MailingAddress>
    /** Whether the billing address matches the shipping address. */
    billingAddressMatchesShippingAddress: Scalars["Boolean"]["output"]
    /**
     * The date and time when the draft order converted to a new order,
     * and the draft order's status changed to **Completed**.
     *
     */
    completedAt?: Maybe<Scalars["DateTime"]["output"]>
    /** The date and time when the draft order was created in Shopify. */
    createdAt: Scalars["DateTime"]["output"]
    /**
     * The three letter code for the currency of the store at the time of the most recent update to the draft order.
     *
     */
    currencyCode: CurrencyCode
    /**
     * The custom information added to the draft order on behalf of the customer.
     *
     */
    customAttributes: Array<Attribute>
    /** The customer who will be sent an invoice for the draft order, if there is one. */
    customer?: Maybe<Customer>
    /**
     * A default cursor that returns the single next record, sorted ascending by ID.
     *
     */
    defaultCursor: Scalars["String"]["output"]
    /** The email address of the customer, which is used to send notifications. */
    email?: Maybe<Scalars["String"]["output"]>
    /** The list of events associated with the draft order. */
    events: EventConnection
    /** Whether the merchant has added timeline comments to the draft order. */
    hasTimelineComment: Scalars["Boolean"]["output"]
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The subject defined for the draft invoice email template. */
    invoiceEmailTemplateSubject: Scalars["String"]["output"]
    /** The date and time when the invoice was last emailed to the customer. */
    invoiceSentAt?: Maybe<Scalars["DateTime"]["output"]>
    /** The link to the checkout, which is sent to the customer in the invoice email. */
    invoiceUrl?: Maybe<Scalars["URL"]["output"]>
    /** The ID of the corresponding resource in the REST Admin API. */
    legacyResourceId: Scalars["UnsignedInt64"]["output"]
    /** The list of the line items in the draft order. */
    lineItems: DraftOrderLineItemConnection
    /** The subtotal of the line items and corresponding discounts. The subtotal doesn't include shipping charges, shipping discounts, taxes, or order discounts. */
    lineItemsSubtotalPrice: MoneyBag
    /** List of localization extensions for the resource. */
    localizationExtensions: LocalizationExtensionConnection
    /** The name of the selected market. */
    marketName: Scalars["String"]["output"]
    /** The selected country code that determines the pricing of the draft order. */
    marketRegionCountryCode: CountryCode
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /**
     * The identifier for the draft order, which is unique within the store. For example, _#D1223_.
     *
     */
    name: Scalars["String"]["output"]
    /** The text from an optional note attached to the draft order. */
    note2?: Maybe<Scalars["String"]["output"]>
    /** The order that was created from this draft order. */
    order?: Maybe<Order>
    /** The associated payment terms for this draft order. */
    paymentTerms?: Maybe<PaymentTerms>
    /** The phone number assigned to the draft order. */
    phone?: Maybe<Scalars["String"]["output"]>
    /** The purchase order number. */
    poNumber?: Maybe<Scalars["String"]["output"]>
    /** The payment currency of the customer for this draft order. */
    presentmentCurrencyCode: CurrencyCode
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
    /** The purchasing entity for the draft order. */
    purchasingEntity?: Maybe<PurchasingEntity>
    /** Whether the Draft Order is ready and can be completed. Draft Orders might have asynchronous operations that can take time to finish. */
    ready: Scalars["Boolean"]["output"]
    /** The time after which inventory will automatically be restocked. */
    reserveInventoryUntil?: Maybe<Scalars["DateTime"]["output"]>
    /** The shipping address of the customer. */
    shippingAddress?: Maybe<MailingAddress>
    /** The line item that contains the shipping costs. */
    shippingLine?: Maybe<ShippingLine>
    /** Status of the draft order. */
    status: DraftOrderStatus
    /**
     * The subtotal of the line items and their discounts. The subtotal doesn't include shipping charges, shipping discounts, or taxes.
     *
     */
    subtotalPrice: Scalars["Money"]["output"]
    /** A subtotal of the line items and corresponding discounts. The subtotal doesn't include shipping charges, shipping discounts, or taxes. */
    subtotalPriceSet: MoneyBag
    /**
     * A comma separated list of tags associated with the draft order. Updating `tags` overwrites
     * any existing tags that were previously added to the draft order. To add new tags without overwriting
     * existing tags, use the [tagsAdd](https://shopify.dev/api/admin-graphql/latest/mutations/tagsadd)
     * mutation.
     *
     */
    tags: Array<Scalars["String"]["output"]>
    /** Whether the draft order is tax exempt. */
    taxExempt: Scalars["Boolean"]["output"]
    /** Total amount of taxes charged for each line item and shipping line. */
    taxLines: Array<TaxLine>
    /** Whether the line item prices include taxes. */
    taxesIncluded: Scalars["Boolean"]["output"]
    /** The total discounts for this draft order. */
    totalDiscountsSet: MoneyBag
    /** The total price of line items for this draft order. */
    totalLineItemsPriceSet: MoneyBag
    /** The total amount of the draft order, including taxes, shipping charges, and discounts. */
    totalPrice: Scalars["Money"]["output"]
    /** The total amount of the draft order including taxes, shipping charges, and discounts. */
    totalPriceSet: MoneyBag
    /** The total shipping charge for the draft order. */
    totalShippingPrice: Scalars["Money"]["output"]
    /** The total shipping charge for the draft order. */
    totalShippingPriceSet: MoneyBag
    /** The total amount of taxes for the draft order. */
    totalTax: Scalars["Money"]["output"]
    /** The total amount of taxes for the draft order. */
    totalTaxSet: MoneyBag
    /** The total weight in grams of the draft order. */
    totalWeight: Scalars["UnsignedInt64"]["output"]
    /**
     * The date and time when the draft order was last changed.
     * The format is YYYY-MM-DD HH:mm:ss. For example, 2016-02-05 17:04:01.
     *
     */
    updatedAt: Scalars["DateTime"]["output"]
    /** Whether the draft order will be visible to the customer on the self-serve portal. */
    visibleToCustomer: Scalars["Boolean"]["output"]
  }

/**
 * An order that a merchant creates on behalf of a customer. Draft orders are useful for merchants that need to do the following tasks:
 *
 * - Create new orders for sales made by phone, in person, by chat, or elsewhere. When a merchant accepts payment for a draft order, an order is created.
 * - Send invoices to customers to pay with a secure checkout link.
 * - Use custom items to represent additional costs or products that aren't displayed in a shop's inventory.
 * - Re-create orders manually from active sales channels.
 * - Sell products at discount or wholesale rates.
 * - Take pre-orders.
 * - Save an order as a draft and resume working on it later.
 *
 * For Draft orders in multiple currencies `presentment_money` is the source of truth for what a customer is going to be charged and `shop_money` is an estimate of what the merchant might receive in their local currency.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type DraftOrderEventsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<EventSortKeys>
}

/**
 * An order that a merchant creates on behalf of a customer. Draft orders are useful for merchants that need to do the following tasks:
 *
 * - Create new orders for sales made by phone, in person, by chat, or elsewhere. When a merchant accepts payment for a draft order, an order is created.
 * - Send invoices to customers to pay with a secure checkout link.
 * - Use custom items to represent additional costs or products that aren't displayed in a shop's inventory.
 * - Re-create orders manually from active sales channels.
 * - Sell products at discount or wholesale rates.
 * - Take pre-orders.
 * - Save an order as a draft and resume working on it later.
 *
 * For Draft orders in multiple currencies `presentment_money` is the source of truth for what a customer is going to be charged and `shop_money` is an estimate of what the merchant might receive in their local currency.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type DraftOrderLineItemsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An order that a merchant creates on behalf of a customer. Draft orders are useful for merchants that need to do the following tasks:
 *
 * - Create new orders for sales made by phone, in person, by chat, or elsewhere. When a merchant accepts payment for a draft order, an order is created.
 * - Send invoices to customers to pay with a secure checkout link.
 * - Use custom items to represent additional costs or products that aren't displayed in a shop's inventory.
 * - Re-create orders manually from active sales channels.
 * - Sell products at discount or wholesale rates.
 * - Take pre-orders.
 * - Save an order as a draft and resume working on it later.
 *
 * For Draft orders in multiple currencies `presentment_money` is the source of truth for what a customer is going to be charged and `shop_money` is an estimate of what the merchant might receive in their local currency.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type DraftOrderLocalizationExtensionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  countryCodes?: InputMaybe<Array<CountryCode>>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  purposes?: InputMaybe<Array<LocalizationExtensionPurpose>>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An order that a merchant creates on behalf of a customer. Draft orders are useful for merchants that need to do the following tasks:
 *
 * - Create new orders for sales made by phone, in person, by chat, or elsewhere. When a merchant accepts payment for a draft order, an order is created.
 * - Send invoices to customers to pay with a secure checkout link.
 * - Use custom items to represent additional costs or products that aren't displayed in a shop's inventory.
 * - Re-create orders manually from active sales channels.
 * - Sell products at discount or wholesale rates.
 * - Take pre-orders.
 * - Save an order as a draft and resume working on it later.
 *
 * For Draft orders in multiple currencies `presentment_money` is the source of truth for what a customer is going to be charged and `shop_money` is an estimate of what the merchant might receive in their local currency.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type DraftOrderMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/**
 * An order that a merchant creates on behalf of a customer. Draft orders are useful for merchants that need to do the following tasks:
 *
 * - Create new orders for sales made by phone, in person, by chat, or elsewhere. When a merchant accepts payment for a draft order, an order is created.
 * - Send invoices to customers to pay with a secure checkout link.
 * - Use custom items to represent additional costs or products that aren't displayed in a shop's inventory.
 * - Re-create orders manually from active sales channels.
 * - Sell products at discount or wholesale rates.
 * - Take pre-orders.
 * - Save an order as a draft and resume working on it later.
 *
 * For Draft orders in multiple currencies `presentment_money` is the source of truth for what a customer is going to be charged and `shop_money` is an estimate of what the merchant might receive in their local currency.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type DraftOrderMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An order that a merchant creates on behalf of a customer. Draft orders are useful for merchants that need to do the following tasks:
 *
 * - Create new orders for sales made by phone, in person, by chat, or elsewhere. When a merchant accepts payment for a draft order, an order is created.
 * - Send invoices to customers to pay with a secure checkout link.
 * - Use custom items to represent additional costs or products that aren't displayed in a shop's inventory.
 * - Re-create orders manually from active sales channels.
 * - Sell products at discount or wholesale rates.
 * - Take pre-orders.
 * - Save an order as a draft and resume working on it later.
 *
 * For Draft orders in multiple currencies `presentment_money` is the source of truth for what a customer is going to be charged and `shop_money` is an estimate of what the merchant might receive in their local currency.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type DraftOrderPrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/**
 * An order that a merchant creates on behalf of a customer. Draft orders are useful for merchants that need to do the following tasks:
 *
 * - Create new orders for sales made by phone, in person, by chat, or elsewhere. When a merchant accepts payment for a draft order, an order is created.
 * - Send invoices to customers to pay with a secure checkout link.
 * - Use custom items to represent additional costs or products that aren't displayed in a shop's inventory.
 * - Re-create orders manually from active sales channels.
 * - Sell products at discount or wholesale rates.
 * - Take pre-orders.
 * - Save an order as a draft and resume working on it later.
 *
 * For Draft orders in multiple currencies `presentment_money` is the source of truth for what a customer is going to be charged and `shop_money` is an estimate of what the merchant might receive in their local currency.
 *
 * **Caution:** Only use this data if it's required for your app's functionality. Shopify will restrict [access to scopes](https://shopify.dev/api/usage/access-scopes) for apps that don't have a legitimate use for the associated data.
 *
 */
export type DraftOrderPrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** The order-level discount applied to a draft order. */
export type DraftOrderAppliedDiscount = {
  __typename?: "DraftOrderAppliedDiscount"
  /**
   * Amount of the order-level discount that's applied to the draft order.
   * @deprecated Use `amountV2` instead.
   */
  amount: Scalars["Money"]["output"]
  /** The amount of money discounted, with values shown in both shop currency and presentment currency. */
  amountSet: MoneyBag
  /** Amount of money discounted. */
  amountV2: MoneyV2
  /** Description of the order-level discount. */
  description: Scalars["String"]["output"]
  /** Name of the order-level discount. */
  title?: Maybe<Scalars["String"]["output"]>
  /**
   * The order level discount amount. If `valueType` is `"percentage"`,
   * then `value` is the percentage discount.
   *
   */
  value: Scalars["Float"]["output"]
  /** Type of the order-level discount. */
  valueType: DraftOrderAppliedDiscountType
}

/** The input fields for applying an order-level discount to a draft order. */
export type DraftOrderAppliedDiscountInput = {
  /**
   * The applied amount of the discount.
   * If the type of the discount is fixed amount, then this is the fixed dollar amount.
   * If the type is percentage, then this is the subtotal multiplied by the percentage.
   *
   */
  amount?: InputMaybe<Scalars["Money"]["input"]>
  /**
   * Reason for the discount.
   *
   */
  description?: InputMaybe<Scalars["String"]["input"]>
  /**
   * Title of the discount.
   *
   */
  title?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The value of the discount.
   * If the type of the discount is fixed amount, then this is a fixed dollar amount.
   * If the type is percentage, then this is the percentage.
   *
   */
  value: Scalars["Float"]["input"]
  /**
   * The type of discount.
   *
   */
  valueType: DraftOrderAppliedDiscountType
}

/** The valid discount types that can be applied to a draft order. */
export enum DraftOrderAppliedDiscountType {
  /** A fixed amount in the store's currency. */
  FixedAmount = "FIXED_AMOUNT",
  /** A percentage of the order subtotal. */
  Percentage = "PERCENTAGE",
}

/** Return type for `draftOrderBulkAddTags` mutation. */
export type DraftOrderBulkAddTagsPayload = {
  __typename?: "DraftOrderBulkAddTagsPayload"
  /** The asynchronous job for adding tags to the draft orders. */
  job?: Maybe<Job>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `draftOrderBulkDelete` mutation. */
export type DraftOrderBulkDeletePayload = {
  __typename?: "DraftOrderBulkDeletePayload"
  /** The asynchronous job for deleting the draft orders. */
  job?: Maybe<Job>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `draftOrderBulkRemoveTags` mutation. */
export type DraftOrderBulkRemoveTagsPayload = {
  __typename?: "DraftOrderBulkRemoveTagsPayload"
  /** The asynchronous job for removing tags from the draft orders. */
  job?: Maybe<Job>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `draftOrderCalculate` mutation. */
export type DraftOrderCalculatePayload = {
  __typename?: "DraftOrderCalculatePayload"
  /** The calculated properties for a draft order. */
  calculatedDraftOrder?: Maybe<CalculatedDraftOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `draftOrderComplete` mutation. */
export type DraftOrderCompletePayload = {
  __typename?: "DraftOrderCompletePayload"
  /** The completed draft order. */
  draftOrder?: Maybe<DraftOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * An auto-generated type for paginating through multiple DraftOrders.
 *
 */
export type DraftOrderConnection = {
  __typename?: "DraftOrderConnection"
  /** A list of edges. */
  edges: Array<DraftOrderEdge>
  /** A list of the nodes contained in DraftOrderEdge. */
  nodes: Array<DraftOrder>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `draftOrderCreateFromOrder` mutation. */
export type DraftOrderCreateFromOrderPayload = {
  __typename?: "DraftOrderCreateFromOrderPayload"
  /** The created Draft Order. */
  draftOrder?: Maybe<DraftOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `draftOrderCreateMerchantCheckout` mutation. */
export type DraftOrderCreateMerchantCheckoutPayload = {
  __typename?: "DraftOrderCreateMerchantCheckoutPayload"
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `draftOrderCreate` mutation. */
export type DraftOrderCreatePayload = {
  __typename?: "DraftOrderCreatePayload"
  /**
   * The created draft order.
   *
   */
  draftOrder?: Maybe<DraftOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The input fields to specify the draft order to delete by its ID. */
export type DraftOrderDeleteInput = {
  /**
   * The ID of the draft order to delete.
   *
   */
  id: Scalars["ID"]["input"]
}

/** Return type for `draftOrderDelete` mutation. */
export type DraftOrderDeletePayload = {
  __typename?: "DraftOrderDeletePayload"
  /**
   * The ID of the deleted draft order.
   *
   */
  deletedId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `draftOrderDuplicate` mutation. */
export type DraftOrderDuplicatePayload = {
  __typename?: "DraftOrderDuplicatePayload"
  /** The newly duplicated draft order. */
  draftOrder?: Maybe<DraftOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * An auto-generated type which holds one DraftOrder and a cursor during pagination.
 *
 */
export type DraftOrderEdge = {
  __typename?: "DraftOrderEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DraftOrderEdge. */
  node: DraftOrder
}

/** The input fields used to create or update a draft order. */
export type DraftOrderInput = {
  /**
   * The discount that will be applied to the draft order.
   * A draft order line item can have one discount. A draft order can also have one order-level discount.
   *
   */
  appliedDiscount?: InputMaybe<DraftOrderAppliedDiscountInput>
  /**
   * The mailing address associated with the payment method.
   *
   */
  billingAddress?: InputMaybe<MailingAddressInput>
  /**
   * Extra information added to the customer.
   *
   */
  customAttributes?: InputMaybe<Array<AttributeInput>>
  /**
   * The customer's email address.
   *
   */
  email?: InputMaybe<Scalars["String"]["input"]>
  /**
   * Product variant line item or custom line item associated to the draft order.
   * Each draft order must include at least one line item.
   *
   */
  lineItems?: InputMaybe<Array<DraftOrderLineItemInput>>
  /** The localization extensions attached to the draft order. For example, Tax IDs. */
  localizationExtensions?: InputMaybe<Array<LocalizationExtensionInput>>
  /** The selected country code that determines the pricing of the draft order. */
  marketRegionCountryCode?: InputMaybe<CountryCode>
  /**
   * Metafields attached to the draft order.
   *
   */
  metafields?: InputMaybe<Array<MetafieldInput>>
  /**
   * The text of an optional note that a shop owner can attach to the draft order.
   *
   */
  note?: InputMaybe<Scalars["String"]["input"]>
  /** The fields used to create payment terms. */
  paymentTerms?: InputMaybe<PaymentTermsInput>
  /** The customer's phone number. */
  phone?: InputMaybe<Scalars["String"]["input"]>
  /** The purchase order number. */
  poNumber?: InputMaybe<Scalars["String"]["input"]>
  /** The payment currency of the customer for this draft order. */
  presentmentCurrencyCode?: InputMaybe<CurrencyCode>
  /** The purchasing entity for this draft order. */
  purchasingEntity?: InputMaybe<PurchasingEntityInput>
  /** Time after which inventory will automatically be restocked. */
  reserveInventoryUntil?: InputMaybe<Scalars["DateTime"]["input"]>
  /**
   * The mailing address to where the order will be shipped.
   *
   */
  shippingAddress?: InputMaybe<MailingAddressInput>
  /**
   * A shipping line object, which details the shipping method used.
   *
   */
  shippingLine?: InputMaybe<ShippingLineInput>
  /**
   * The source of the checkout.
   *           To use this field for sales attribution, you must register the channels that your app is managing.
   *           You can register the channels that your app is managing by completing
   *           [this Google Form](https://docs.google.com/forms/d/e/1FAIpQLScmVTZRQNjOJ7RD738mL1lGeFjqKVe_FM2tO9xsm21QEo5Ozg/viewform?usp=sf_link).
   *           After you've submitted your request, you need to wait for your request to be processed by Shopify.
   *           You can find a list of your channels in the Partner Dashboard, in your app's Marketplace extension.
   *           You need to specify the handle as the `source_name` value in your request.
   *           The handle is the channel that the order was placed from.
   */
  sourceName?: InputMaybe<Scalars["String"]["input"]>
  /**
   * A comma separated list of tags that have been added to the draft order.
   *
   */
  tags?: InputMaybe<Array<Scalars["String"]["input"]>>
  /**
   * Whether or not taxes are exempt for the draft order.
   * If false, then Shopify will refer to the taxable field for each line item.
   * If a customer is applied to the draft order, then Shopify will use the customer's tax exempt field instead.
   *
   */
  taxExempt?: InputMaybe<Scalars["Boolean"]["input"]>
  /**
   * Sent as part of a draft order object to load customer shipping information.
   *
   */
  useCustomerDefaultAddress?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Whether the draft order will be visible to the customer on the self-serve portal. */
  visibleToCustomer?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Return type for `draftOrderInvoicePreview` mutation. */
export type DraftOrderInvoicePreviewPayload = {
  __typename?: "DraftOrderInvoicePreviewPayload"
  /** The draft order invoice email rendered as HTML to allow previewing. */
  previewHtml?: Maybe<Scalars["HTML"]["output"]>
  /** The subject preview for the draft order invoice email. */
  previewSubject?: Maybe<Scalars["HTML"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `draftOrderInvoiceSend` mutation. */
export type DraftOrderInvoiceSendPayload = {
  __typename?: "DraftOrderInvoiceSendPayload"
  /** The draft order an invoice email is sent for. */
  draftOrder?: Maybe<DraftOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** A line item included in a draft order. */
export type DraftOrderLineItem = Node & {
  __typename?: "DraftOrderLineItem"
  /**
   * The discount that will be applied to the line item or the overall order.
   *
   */
  appliedDiscount?: Maybe<DraftOrderAppliedDiscount>
  /**
   * Whether the line item is a custom line item (`true`) or a product variant line item (`false`).
   *
   */
  custom: Scalars["Boolean"]["output"]
  /** A list of attributes that represent custom features or special requests. */
  customAttributes: Array<Attribute>
  /** Additional information (metafields) about the line item with the associated types. */
  customAttributesV2: Array<TypedAttribute>
  /**
   * The line item price after discounts are applied.
   *
   */
  discountedTotal: Scalars["Money"]["output"]
  /** The line item price after discounts are applied. */
  discountedTotalSet: MoneyBag
  /**
   * The `discountedTotal` divided by `quantity`, resulting in the value of the discount per unit.
   *
   */
  discountedUnitPrice: Scalars["Money"]["output"]
  /** The `discountedTotal` divided by `quantity`, resulting in the value of the discount per unit. */
  discountedUnitPriceSet: MoneyBag
  /**
   * Name of the service provider who fulfilled the order.
   *
   * Valid values are either **manual** or the name of the provider.
   * For example, **amazon**, **shipwire**.
   *
   * Deleted fulfillment services will return null.
   *
   */
  fulfillmentService?: Maybe<FulfillmentService>
  /**
   * The weight of the line item in grams. The weight can only be specified if the line item is a custom
   * line item.
   *
   * @deprecated Use `weight` instead.
   */
  grams?: Maybe<Scalars["Int"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The image associated with the draft order line item. */
  image?: Maybe<Image>
  /** Whether the line item is a gift card. */
  isGiftCard: Scalars["Boolean"]["output"]
  /** The name of the product. */
  name: Scalars["String"]["output"]
  /**
   * The total price (without discounts) of the line item, based on the original unit price of the variant x quantity.
   *
   */
  originalTotal: Scalars["Money"]["output"]
  /** The total price (without discounts) of the line item,based on the original unit price of the variant x quantity. */
  originalTotalSet: MoneyBag
  /** The variant price without any discounts applied. */
  originalUnitPrice: Scalars["Money"]["output"]
  /** The variant price without any discounts applied. */
  originalUnitPriceSet: MoneyBag
  /**
   * The product corresponding to the line item’s product variant.
   *
   */
  product?: Maybe<Product>
  /** The number of product variants that are requested in the draft order. */
  quantity: Scalars["Int"]["output"]
  /** Whether physical shipping is required for the variant. */
  requiresShipping: Scalars["Boolean"]["output"]
  /** The SKU number of the product variant. */
  sku?: Maybe<Scalars["String"]["output"]>
  /**
   * A list of tax line objects, each of which details the total taxes applicable to the order.
   *
   */
  taxLines: Array<TaxLine>
  /** Whether the variant is taxable. */
  taxable: Scalars["Boolean"]["output"]
  /** The title of the product or variant. This field only applies to custom line items. */
  title: Scalars["String"]["output"]
  /**
   * The total value of the discount that's applied to the line item.
   *
   */
  totalDiscount: Scalars["Money"]["output"]
  /** The total value of the discount that's applied to the line item. */
  totalDiscountSet: MoneyBag
  /**
   * The associated variant for the line item.
   *
   */
  variant?: Maybe<ProductVariant>
  /** The name of the variant. */
  variantTitle?: Maybe<Scalars["String"]["output"]>
  /** The name of the vendor who created the product variant. */
  vendor?: Maybe<Scalars["String"]["output"]>
  /** The weight unit and value for a draft order line item. */
  weight?: Maybe<Weight>
}

/**
 * An auto-generated type for paginating through multiple DraftOrderLineItems.
 *
 */
export type DraftOrderLineItemConnection = {
  __typename?: "DraftOrderLineItemConnection"
  /** A list of edges. */
  edges: Array<DraftOrderLineItemEdge>
  /** A list of the nodes contained in DraftOrderLineItemEdge. */
  nodes: Array<DraftOrderLineItem>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one DraftOrderLineItem and a cursor during pagination.
 *
 */
export type DraftOrderLineItemEdge = {
  __typename?: "DraftOrderLineItemEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of DraftOrderLineItemEdge. */
  node: DraftOrderLineItem
}

/** The input fields used to create a line item for a draft order. */
export type DraftOrderLineItemInput = {
  /**
   * Discount which will be applied to the line item.
   *
   */
  appliedDiscount?: InputMaybe<DraftOrderAppliedDiscountInput>
  /**
   * Represents a generic custom attribute using a key value pair.
   *
   */
  customAttributes?: InputMaybe<Array<AttributeInput>>
  /** The price without any discounts applied. This value is ignored when `variantId` is provided. */
  originalUnitPrice?: InputMaybe<Scalars["Money"]["input"]>
  /**
   * The number of products that were purchased.
   *
   */
  quantity: Scalars["Int"]["input"]
  /**
   * Whether physical shipping is required. This value is ignored when `variantId` is provided.
   *
   */
  requiresShipping?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The SKU number of the item. This value is ignored when `variantId` is provided. */
  sku?: InputMaybe<Scalars["String"]["input"]>
  /** Whether the item is taxable. This value is ignored when `variantId` is provided. */
  taxable?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Title of the item. Ignored when `variantId` is provided. */
  title?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The ID of the product variant corresponding to the line item.
   * Null if custom line item. Required if product variant line item.
   *
   */
  variantId?: InputMaybe<Scalars["ID"]["input"]>
  /**
   * Specifies the weight unit and value inputs.
   * This value is ignored when `variantId` is provided.
   *
   */
  weight?: InputMaybe<WeightInput>
}

/** The set of valid sort keys for the DraftOrder query. */
export enum DraftOrderSortKeys {
  /** Sort by the `customer_name` value. */
  CustomerName = "CUSTOMER_NAME",
  /** Sort by the `id` value. */
  Id = "ID",
  /** Sort by the `number` value. */
  Number = "NUMBER",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `status` value. */
  Status = "STATUS",
  /** Sort by the `total_price` value. */
  TotalPrice = "TOTAL_PRICE",
  /** Sort by the `updated_at` value. */
  UpdatedAt = "UPDATED_AT",
}

/** The valid statuses for a draft order. */
export enum DraftOrderStatus {
  /** The draft order has been paid. */
  Completed = "COMPLETED",
  /** An invoice for the draft order has been sent to the customer. */
  InvoiceSent = "INVOICE_SENT",
  /** The draft order is open. It has not been paid, and an invoice hasn't been sent. */
  Open = "OPEN",
}

/** Represents a draft order tag. */
export type DraftOrderTag = Node & {
  __typename?: "DraftOrderTag"
  /** Handle of draft order tag. */
  handle: Scalars["String"]["output"]
  /** ID of draft order tag. */
  id: Scalars["ID"]["output"]
  /** Title of draft order tag. */
  title: Scalars["String"]["output"]
}

/** Return type for `draftOrderUpdate` mutation. */
export type DraftOrderUpdatePayload = {
  __typename?: "DraftOrderUpdatePayload"
  /** The updated draft order. */
  draftOrder?: Maybe<DraftOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The duty details for a line item. */
export type Duty = Node & {
  __typename?: "Duty"
  /** The ISO 3166-1 alpha-2 country code of the country of origin used in calculating the duty. */
  countryCodeOfOrigin?: Maybe<CountryCode>
  /** The harmonized system code of the item used in calculating the duty. */
  harmonizedSystemCode?: Maybe<Scalars["String"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The amount of the duty. */
  price: MoneyBag
  /** A list of taxes charged on the duty. */
  taxLines: Array<TaxLine>
}

/** A sale associated with a duty charge. */
export type DutySale = Sale & {
  __typename?: "DutySale"
  /** The type of order action that the sale represents. */
  actionType: SaleActionType
  /** The duty for the associated sale. */
  duty: Duty
  /** The unique ID for the sale. */
  id: Scalars["ID"]["output"]
  /** The line type assocated with the sale. */
  lineType: SaleLineType
  /** The number of units either ordered or intended to be returned. */
  quantity?: Maybe<Scalars["Int"]["output"]>
  /** All individual taxes associated with the sale. */
  taxes: Array<SaleTax>
  /** The total sale amount after taxes and discounts. */
  totalAmount: MoneyBag
  /** The total discounts allocated to the sale after taxes. */
  totalDiscountAmountAfterTaxes: MoneyBag
  /** The total discounts allocated to the sale before taxes. */
  totalDiscountAmountBeforeTaxes: MoneyBag
  /** The total amount of taxes for the sale. */
  totalTaxAmount: MoneyBag
}

/** The attribute editable information. */
export type EditableProperty = {
  __typename?: "EditableProperty"
  /** Whether the attribute is locked for editing. */
  locked: Scalars["Boolean"]["output"]
  /** The reason the attribute is locked for editing. */
  reason?: Maybe<Scalars["FormattedString"]["output"]>
}

/** The input fields for an email. */
export type EmailInput = {
  /** Specifies any bcc recipients for the email. */
  bcc?: InputMaybe<Array<Scalars["String"]["input"]>>
  /** Specifies the email body. */
  body?: InputMaybe<Scalars["String"]["input"]>
  /** Specifies a custom message to include in the email. */
  customMessage?: InputMaybe<Scalars["String"]["input"]>
  /** Specifies the email sender. */
  from?: InputMaybe<Scalars["String"]["input"]>
  /** Specifies the email subject. */
  subject?: InputMaybe<Scalars["String"]["input"]>
  /** Specifies the email recipient. */
  to?: InputMaybe<Scalars["String"]["input"]>
}

/** Error position information in a ShopifyQL parsing error. */
export type ErrorPosition = {
  __typename?: "ErrorPosition"
  /** The character position of the error in the line. */
  character: Scalars["Int"]["output"]
  /** The line number of the error. */
  line: Scalars["Int"]["output"]
}

/** An error that occurs during the execution of a server pixel mutation. */
export type ErrorsServerPixelUserError = DisplayableError & {
  __typename?: "ErrorsServerPixelUserError"
  /** The error code. */
  code?: Maybe<ErrorsServerPixelUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `ErrorsServerPixelUserError`. */
export enum ErrorsServerPixelUserErrorCode {
  /** A server pixel already exists for this app and shop. Only one server pixel can exist for any app and shop combination. */
  AlreadyExists = "ALREADY_EXISTS",
  /** Server Pixel must be configured with a valid AWS Event Bridge or GCP pub/sub endpoint address to be connected. */
  NeedsConfigurationToConnect = "NEEDS_CONFIGURATION_TO_CONNECT",
  /** A server pixel doesn't exist for this app and shop. */
  NotFound = "NOT_FOUND",
  /** PubSubProject and PubSubTopic values resulted in an address that is not a valid GCP pub/sub format.Address format should be pubsub://project:topic. */
  PubSubError = "PUB_SUB_ERROR",
}

/** An error that occurs during the execution of a web pixel mutation. */
export type ErrorsWebPixelUserError = DisplayableError & {
  __typename?: "ErrorsWebPixelUserError"
  /** The error code. */
  code?: Maybe<ErrorsWebPixelUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `ErrorsWebPixelUserError`. */
export enum ErrorsWebPixelUserErrorCode {
  /** The input value is blank. */
  Blank = "BLANK",
  /** The provided settings ID does not match the expected settings definition on the app. */
  InvalidSettings = "INVALID_SETTINGS",
  /** The record with the ID used as the input value couldn't be found. */
  NotFound = "NOT_FOUND",
  /** The input value is already taken. */
  Taken = "TAKEN",
  /** An error occurred and the web pixel couldnt be deleted. */
  UnableToDelete = "UNABLE_TO_DELETE",
}

/**
 * Events chronicle resource activities such as the creation of an article, the fulfillment of an order, or the
 * addition of a product.
 *
 */
export type Event = {
  /** The name of the app that created the event. */
  appTitle?: Maybe<Scalars["String"]["output"]>
  /** Whether the event was created by an app. */
  attributeToApp: Scalars["Boolean"]["output"]
  /** Whether the event was caused by an admin user. */
  attributeToUser: Scalars["Boolean"]["output"]
  /** The date and time when the event was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** Whether the event is critical. */
  criticalAlert: Scalars["Boolean"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** Human readable text that describes the event. */
  message: Scalars["FormattedString"]["output"]
}

/** Return type for `eventBridgeServerPixelUpdate` mutation. */
export type EventBridgeServerPixelUpdatePayload = {
  __typename?: "EventBridgeServerPixelUpdatePayload"
  /** The server pixel as configured by the mutation. */
  serverPixel?: Maybe<ServerPixel>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<ErrorsServerPixelUserError>
}

/** Return type for `eventBridgeWebhookSubscriptionCreate` mutation. */
export type EventBridgeWebhookSubscriptionCreatePayload = {
  __typename?: "EventBridgeWebhookSubscriptionCreatePayload"
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
  /** The webhook subscription that was created. */
  webhookSubscription?: Maybe<WebhookSubscription>
}

/**
 * The input fields for an EventBridge webhook subscription.
 *
 */
export type EventBridgeWebhookSubscriptionInput = {
  /** The ARN of the EventBridge partner event source. */
  arn?: InputMaybe<Scalars["ARN"]["input"]>
  /** The format in which the webhook subscription should send the data. */
  format?: InputMaybe<WebhookSubscriptionFormat>
  /** The list of fields to be included in the webhook subscription. */
  includeFields?: InputMaybe<Array<Scalars["String"]["input"]>>
  /** The list of namespaces for any metafields that should be included in the webhook subscription. */
  metafieldNamespaces?: InputMaybe<Array<Scalars["String"]["input"]>>
}

/** Return type for `eventBridgeWebhookSubscriptionUpdate` mutation. */
export type EventBridgeWebhookSubscriptionUpdatePayload = {
  __typename?: "EventBridgeWebhookSubscriptionUpdatePayload"
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
  /** The webhook subscription that was updated. */
  webhookSubscription?: Maybe<WebhookSubscription>
}

/**
 * An auto-generated type for paginating through multiple Events.
 *
 */
export type EventConnection = {
  __typename?: "EventConnection"
  /** A list of edges. */
  edges: Array<EventEdge>
  /** A list of the nodes contained in EventEdge. */
  nodes: Array<Event>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one Event and a cursor during pagination.
 *
 */
export type EventEdge = {
  __typename?: "EventEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of EventEdge. */
  node: Event
}

/** The set of valid sort keys for the Event query. */
export enum EventSortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
}

/** An exchange where existing items on an order are returned and new items are added to the order. */
export type ExchangeV2 = Node & {
  __typename?: "ExchangeV2"
  /** The details of the new items in the exchange. */
  additions: ExchangeV2Additions
  /** The date and time when the exchange was completed. */
  completedAt?: Maybe<Scalars["DateTime"]["output"]>
  /** The date and time when the exchange was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The location where the exchange happened. */
  location?: Maybe<Location>
  /** The text of an optional note that a shop owner can attach to the exchange. */
  note?: Maybe<Scalars["String"]["output"]>
  /** The refunds processed during the exchange. */
  refunds: Array<Refund>
  /** The details of the returned items in the exchange. */
  returns: ExchangeV2Returns
  /** The staff member associated with the exchange. */
  staffMember?: Maybe<StaffMember>
  /** The amount of money that was paid or refunded as part of the exchange. */
  totalAmountProcessedSet: MoneyBag
  /** The difference in values of the items that were exchanged. */
  totalPriceSet: MoneyBag
  /** The order transactions related to the exchange. */
  transactions: Array<OrderTransaction>
}

/** New items associated to the exchange. */
export type ExchangeV2Additions = {
  __typename?: "ExchangeV2Additions"
  /** The list of new items for the exchange. */
  lineItems: Array<ExchangeV2LineItem>
  /** The subtotal of the items being added, including discounts. */
  subtotalPriceSet: MoneyBag
  /** The summary of all taxes of the items being added. */
  taxLines: Array<TaxLine>
  /** The total price of the items being added, including discounts and taxes. */
  totalPriceSet: MoneyBag
}

/**
 * An auto-generated type for paginating through multiple ExchangeV2s.
 *
 */
export type ExchangeV2Connection = {
  __typename?: "ExchangeV2Connection"
  /** A list of edges. */
  edges: Array<ExchangeV2Edge>
  /** A list of the nodes contained in ExchangeV2Edge. */
  nodes: Array<ExchangeV2>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one ExchangeV2 and a cursor during pagination.
 *
 */
export type ExchangeV2Edge = {
  __typename?: "ExchangeV2Edge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of ExchangeV2Edge. */
  node: ExchangeV2
}

/** Contains information about an item in the exchange. */
export type ExchangeV2LineItem = {
  __typename?: "ExchangeV2LineItem"
  /** A list of attributes that represent custom features or special requests. */
  customAttributes: Array<Attribute>
  /** The total line price, in shop and presentment currencies, after discounts are applied. */
  discountedTotalSet: MoneyBag
  /**
   * The price, in shop and presentment currencies,
   * of a single variant unit after line item discounts are applied.
   *
   */
  discountedUnitPriceSet: MoneyBag
  /**
   * Name of the service provider who fulfilled the order.
   *
   * Valid values are either **manual** or the name of the provider.
   * For example, **amazon**, **shipwire**.
   *
   * Deleted fulfillment services will return null.
   *
   */
  fulfillmentService?: Maybe<FulfillmentService>
  /** Indiciates if this line item is a gift card. */
  giftCard: Scalars["Boolean"]["output"]
  /** The gift cards associated with the line item. */
  giftCards: Array<GiftCard>
  /** The line item associated with this object. */
  lineItem?: Maybe<LineItem>
  /** The name of the product. */
  name: Scalars["String"]["output"]
  /** The total price, in shop and presentment currencies, before discounts are applied. */
  originalTotalSet: MoneyBag
  /**
   * The price, in shop and presentment currencies,
   * of a single variant unit before line item discounts are applied.
   *
   */
  originalUnitPriceSet: MoneyBag
  /** The number of products that were purchased. */
  quantity: Scalars["Int"]["output"]
  /** Whether physical shipping is required for the variant. */
  requiresShipping: Scalars["Boolean"]["output"]
  /** The SKU number of the product variant. */
  sku?: Maybe<Scalars["String"]["output"]>
  /** The TaxLine object connected to this line item. */
  taxLines: Array<TaxLine>
  /** Whether the variant is taxable. */
  taxable: Scalars["Boolean"]["output"]
  /** The title of the product or variant. This field only applies to custom line items. */
  title: Scalars["String"]["output"]
  /** The product variant of the line item. */
  variant?: Maybe<ProductVariant>
  /** The name of the variant. */
  variantTitle?: Maybe<Scalars["String"]["output"]>
  /** The name of the vendor who created the product variant. */
  vendor?: Maybe<Scalars["String"]["output"]>
}

/** Return items associated to the exchange. */
export type ExchangeV2Returns = {
  __typename?: "ExchangeV2Returns"
  /** The list of return items for the exchange. */
  lineItems: Array<ExchangeV2LineItem>
  /**
   * The amount of the order-level discount for the items and shipping being returned, which doesn't contain any line item discounts.
   *
   */
  orderDiscountAmountSet: MoneyBag
  /** The amount of money to be refunded for shipping. */
  shippingRefundAmountSet: MoneyBag
  /** The subtotal of the items being returned. */
  subtotalPriceSet: MoneyBag
  /** The summary of all taxes of the items being returned. */
  taxLines: Array<TaxLine>
  /** The amount of money to be refunded for tip. */
  tipRefundAmountSet: MoneyBag
  /** The total value of the items being returned. */
  totalPriceSet: MoneyBag
}

/**
 * Represents a video hosted outside of Shopify.
 *
 */
export type ExternalVideo = Media &
  Node & {
    __typename?: "ExternalVideo"
    /** A word or phrase to share the nature or contents of a media. */
    alt?: Maybe<Scalars["String"]["output"]>
    /** The embed URL of the video for the respective host. */
    embedUrl: Scalars["URL"]["output"]
    /**
     * The URL.
     * @deprecated Use `originUrl` instead.
     */
    embeddedUrl: Scalars["URL"]["output"]
    /** The host of the external video. */
    host: MediaHost
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The media content type. */
    mediaContentType: MediaContentType
    /** Any errors which have occurred on the media. */
    mediaErrors: Array<MediaError>
    /** The warnings attached to the media. */
    mediaWarnings: Array<MediaWarning>
    /** The origin URL of the video on the respective host. */
    originUrl: Scalars["URL"]["output"]
    /** The preview image for the media. */
    preview?: Maybe<MediaPreviewImage>
    /** Current status of the media. */
    status: MediaStatus
  }

/** Requirements that must be met before an app can be installed. */
export type FailedRequirement = {
  __typename?: "FailedRequirement"
  /** Action to be taken to resolve a failed requirement, including URL link. */
  action?: Maybe<NavigationItem>
  /**
   * A concise set of copy strings to be displayed to merchants, to guide them in resolving problems your app
   * encounters when trying to make use of their Shop and its resources.
   *
   */
  message: Scalars["String"]["output"]
}

/** A file interface. */
export type File = {
  /** A word or phrase to describe the contents or the function of a file. */
  alt?: Maybe<Scalars["String"]["output"]>
  /**
   * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) when the file was created.
   *
   */
  createdAt: Scalars["DateTime"]["output"]
  /** Any errors that have occurred on the file. */
  fileErrors: Array<FileError>
  /** The status of the file. */
  fileStatus: FileStatus
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The preview image for the media. */
  preview?: Maybe<MediaPreviewImage>
  /** The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) when the file was last updated. */
  updatedAt: Scalars["DateTime"]["output"]
}

/** Return type for `fileAcknowledgeUpdateFailed` mutation. */
export type FileAcknowledgeUpdateFailedPayload = {
  __typename?: "FileAcknowledgeUpdateFailedPayload"
  /** The updated file(s). */
  files?: Maybe<Array<File>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<FilesUserError>
}

/**
 * An auto-generated type for paginating through multiple Files.
 *
 */
export type FileConnection = {
  __typename?: "FileConnection"
  /** A list of edges. */
  edges: Array<FileEdge>
  /** A list of the nodes contained in FileEdge. */
  nodes: Array<File>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** The possible content types for a file object. */
export enum FileContentType {
  /** A Shopify-hosted generic file. */
  File = "FILE",
  /** A Shopify-hosted image. */
  Image = "IMAGE",
  /** A Shopify-hosted video file. It's recommended to use this type for all video files. */
  Video = "VIDEO",
}

/** The input fields that are required to create a file object. */
export type FileCreateInput = {
  /** The alternative text description of the file. */
  alt?: InputMaybe<Scalars["String"]["input"]>
  /** The file content type. If omitted, then Shopify will attempt to determine the content type during file processing. */
  contentType?: InputMaybe<FileContentType>
  /** How to handle if filename is already in use. */
  duplicateResolutionMode?: InputMaybe<FileCreateInputDuplicateResolutionMode>
  /**
   * When provided, the file will be created with the given filename,
   * otherwise the filename in the originalSource will be used.
   *
   */
  filename?: InputMaybe<Scalars["String"]["input"]>
  /**
   * An external URL (for images only) or a
   * [staged upload URL](https://shopify.dev/api/admin-graphql/latest/mutations/stageduploadscreate).
   *
   */
  originalSource: Scalars["String"]["input"]
}

/** The input fields for handling if filename is already in use. */
export enum FileCreateInputDuplicateResolutionMode {
  /** Append a UUID if filename is already in use. */
  AppendUuid = "APPEND_UUID",
  /** Raise an error if filename is already in use. */
  RaiseError = "RAISE_ERROR",
  /** Replace the existing file if filename is already in use. */
  Replace = "REPLACE",
}

/** Return type for `fileCreate` mutation. */
export type FileCreatePayload = {
  __typename?: "FileCreatePayload"
  /** The newly created files. */
  files?: Maybe<Array<File>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<FilesUserError>
}

/** Return type for `fileDelete` mutation. */
export type FileDeletePayload = {
  __typename?: "FileDeletePayload"
  /** The IDs of the deleted files. */
  deletedFileIds?: Maybe<Array<Scalars["ID"]["output"]>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<FilesUserError>
}

/**
 * An auto-generated type which holds one File and a cursor during pagination.
 *
 */
export type FileEdge = {
  __typename?: "FileEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of FileEdge. */
  node: File
}

/**
 * A file error. This typically occurs when there is an issue with the file itself causing it to fail validation.
 * Check the file before attempting to upload again.
 *
 */
export type FileError = {
  __typename?: "FileError"
  /** Code representing the type of error. */
  code: FileErrorCode
  /** Additional details regarding the error. */
  details?: Maybe<Scalars["String"]["output"]>
  /** Translated error message. */
  message: Scalars["String"]["output"]
}

/** The error types for a file. */
export enum FileErrorCode {
  /** File could not be created because a file with the same name already exists. */
  DuplicateFilenameError = "DUPLICATE_FILENAME_ERROR",
  /** File could not be created because embed permissions are disabled for this video. */
  ExternalVideoEmbedDisabled = "EXTERNAL_VIDEO_EMBED_DISABLED",
  /** File could not be created because video is either not found or still transcoding. */
  ExternalVideoEmbedNotFoundOrTranscoding = "EXTERNAL_VIDEO_EMBED_NOT_FOUND_OR_TRANSCODING",
  /** File could not be created because the external video has an invalid aspect ratio. */
  ExternalVideoInvalidAspectRatio = "EXTERNAL_VIDEO_INVALID_ASPECT_RATIO",
  /** File could not be created because the external video could not be found. */
  ExternalVideoNotFound = "EXTERNAL_VIDEO_NOT_FOUND",
  /** File could not be created because the external video is not listed or is private. */
  ExternalVideoUnlisted = "EXTERNAL_VIDEO_UNLISTED",
  /** File could not be created because the cumulative file storage limit would be exceeded. */
  FileStorageLimitExceeded = "FILE_STORAGE_LIMIT_EXCEEDED",
  /** File could not be processed because the source could not be downloaded. */
  GenericFileDownloadFailure = "GENERIC_FILE_DOWNLOAD_FAILURE",
  /** File could not be created because the size is too large. */
  GenericFileInvalidSize = "GENERIC_FILE_INVALID_SIZE",
  /** File could not be processed because the image could not be downloaded. */
  ImageDownloadFailure = "IMAGE_DOWNLOAD_FAILURE",
  /** File could not be processed because the image could not be processed. */
  ImageProcessingFailure = "IMAGE_PROCESSING_FAILURE",
  /** File could not be created because the image has an invalid aspect ratio. */
  InvalidImageAspectRatio = "INVALID_IMAGE_ASPECT_RATIO",
  /** File could not be created because the image size is too large. */
  InvalidImageFileSize = "INVALID_IMAGE_FILE_SIZE",
  /** File could not be created because the image's resolution exceeds the max limit. */
  InvalidImageResolution = "INVALID_IMAGE_RESOLUTION",
  /** File could not be processed because the signed URL was invalid. */
  InvalidSignedUrl = "INVALID_SIGNED_URL",
  /** File timed out because it is currently being modified by another operation. */
  MediaTimeoutError = "MEDIA_TIMEOUT_ERROR",
  /** File could not be created because the model file failed processing. */
  Model3DGlbOutputCreationError = "MODEL3D_GLB_OUTPUT_CREATION_ERROR",
  /** File could not be created because the model can't be converted to USDZ format. */
  Model3DGlbToUsdzConversionError = "MODEL3D_GLB_TO_USDZ_CONVERSION_ERROR",
  /** File could not be created because the model file failed processing. */
  Model3DProcessingFailure = "MODEL3D_PROCESSING_FAILURE",
  /** File could not be created because the model's thumbnail generation failed. */
  Model3DThumbnailGenerationError = "MODEL3D_THUMBNAIL_GENERATION_ERROR",
  /** There was an issue while trying to generate a new thumbnail. */
  Model3DThumbnailRegenerationError = "MODEL3D_THUMBNAIL_REGENERATION_ERROR",
  /** Model failed validation. */
  Model3DValidationError = "MODEL3D_VALIDATION_ERROR",
  /** File error has occurred for an unknown reason. */
  Unknown = "UNKNOWN",
  /** File could not be created because the image is an unsupported file type. */
  UnsupportedImageFileType = "UNSUPPORTED_IMAGE_FILE_TYPE",
  /** File could not be created because it has an invalid file type. */
  VideoInvalidFiletypeError = "VIDEO_INVALID_FILETYPE_ERROR",
  /** File could not be created because it does not meet the maximum duration requirement. */
  VideoMaxDurationError = "VIDEO_MAX_DURATION_ERROR",
  /** File could not be created because it does not meet the maximum height requirement. */
  VideoMaxHeightError = "VIDEO_MAX_HEIGHT_ERROR",
  /** File could not be created because it does not meet the maximum width requirement. */
  VideoMaxWidthError = "VIDEO_MAX_WIDTH_ERROR",
  /** File could not be created because the metadata could not be read. */
  VideoMetadataReadError = "VIDEO_METADATA_READ_ERROR",
  /** File could not be created because it does not meet the minimum duration requirement. */
  VideoMinDurationError = "VIDEO_MIN_DURATION_ERROR",
  /** File could not be created because it does not meet the minimum height requirement. */
  VideoMinHeightError = "VIDEO_MIN_HEIGHT_ERROR",
  /** File could not be created because it does not meet the minimum width requirement. */
  VideoMinWidthError = "VIDEO_MIN_WIDTH_ERROR",
  /** Video failed validation. */
  VideoValidationError = "VIDEO_VALIDATION_ERROR",
}

/** The set of valid sort keys for the File query. */
export enum FileSortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `filename` value. */
  Filename = "FILENAME",
  /** Sort by the `id` value. */
  Id = "ID",
  /** Sort by the `original_upload_size` value. */
  OriginalUploadSize = "ORIGINAL_UPLOAD_SIZE",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `updated_at` value. */
  UpdatedAt = "UPDATED_AT",
}

/** The possible statuses for a file object. */
export enum FileStatus {
  /** File processing has failed. */
  Failed = "FAILED",
  /** File is being processed. */
  Processing = "PROCESSING",
  /** File is ready to be displayed. */
  Ready = "READY",
  /** File has been uploaded but hasn't been processed. */
  Uploaded = "UPLOADED",
}

/** The input fields that are required to update a file object. */
export type FileUpdateInput = {
  /** The alternative text description of the file. */
  alt?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The name of the file including its extension.
   *
   */
  filename?: InputMaybe<Scalars["String"]["input"]>
  /** The ID of the file to be updated. */
  id: Scalars["ID"]["input"]
  /**
   * The source from which to update a media image or generic file.
   * An external URL (for images only) or a
   * [staged upload URL](https://shopify.dev/api/admin-graphql/latest/mutations/stageduploadscreate).
   *
   */
  originalSource?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The source from which to update the media preview image.
   * May be an external URL or a
   * [staged upload URL](https://shopify.dev/api/admin-graphql/latest/mutations/stageduploadscreate).
   *
   */
  previewImageSource?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `fileUpdate` mutation. */
export type FileUpdatePayload = {
  __typename?: "FileUpdatePayload"
  /** The list of updated files. */
  files?: Maybe<Array<File>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<FilesUserError>
}

/** Possible error codes that can be returned by `FilesUserError`. */
export enum FilesErrorCode {
  /** The alt value exceeds the maximum limit of 512 characters. */
  AltValueLimitExceeded = "ALT_VALUE_LIMIT_EXCEEDED",
  /** The search term must not be blank. */
  BlankSearch = "BLANK_SEARCH",
  /** The provided filename already exists. */
  FilenameAlreadyExists = "FILENAME_ALREADY_EXISTS",
  /** File does not exist. */
  FileDoesNotExist = "FILE_DOES_NOT_EXIST",
  /** File has a pending operation. */
  FileLocked = "FILE_LOCKED",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** Duplicate resolution mode is not supported for this file type. */
  InvalidDuplicateModeForType = "INVALID_DUPLICATE_MODE_FOR_TYPE",
  /** The provided filename is invalid. */
  InvalidFilename = "INVALID_FILENAME",
  /** Invalid filename extension. */
  InvalidFilenameExtension = "INVALID_FILENAME_EXTENSION",
  /** Invalid image source url value provided. */
  InvalidImageSourceUrl = "INVALID_IMAGE_SOURCE_URL",
  /** Search query isn't supported. */
  InvalidQuery = "INVALID_QUERY",
  /** Cannot create file with custom filename which does not match original source extension. */
  MismatchedFilenameAndOriginalSource = "MISMATCHED_FILENAME_AND_ORIGINAL_SOURCE",
  /** At least one argument is required. */
  MissingArguments = "MISSING_ARGUMENTS",
  /** Duplicate resolution mode REPLACE cannot be used without specifying filename. */
  MissingFilenameForDuplicateModeReplace = "MISSING_FILENAME_FOR_DUPLICATE_MODE_REPLACE",
  /** Exceeded the limit of non-image media per shop. */
  NonImageMediaPerShopLimitExceeded = "NON_IMAGE_MEDIA_PER_SHOP_LIMIT_EXCEEDED",
  /** The file is not in the READY state. */
  NonReadyState = "NON_READY_STATE",
  /** Specify one argument: search, IDs, or deleteAll. */
  TooManyArguments = "TOO_MANY_ARGUMENTS",
  /** The file type is not supported. */
  UnacceptableAsset = "UNACCEPTABLE_ASSET",
  /** The file is not supported on trial accounts. Select a plan to upload this file. */
  UnacceptableTrialAsset = "UNACCEPTABLE_TRIAL_ASSET",
  /** The file is not supported on trial accounts that have not validated their email. Either select a plan or verify the shop owner email to upload this file. */
  UnacceptableUnverifiedTrialAsset = "UNACCEPTABLE_UNVERIFIED_TRIAL_ASSET",
  /** Filename update is only supported on Image and GenericFile. */
  UnsupportedMediaTypeForFilenameUpdate = "UNSUPPORTED_MEDIA_TYPE_FOR_FILENAME_UPDATE",
}

/** An error that happens during the execution of a Files API query or mutation. */
export type FilesUserError = DisplayableError & {
  __typename?: "FilesUserError"
  /** The error code. */
  code?: Maybe<FilesErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** A filter option is one possible value in a search filter. */
export type FilterOption = {
  __typename?: "FilterOption"
  /** The filter option's label for display purposes. */
  label: Scalars["String"]["output"]
  /** The filter option's value. */
  value: Scalars["String"]["output"]
}

/**
 * An amount that's allocated to a line item based on an associated discount application.
 *
 */
export type FinancialSummaryDiscountAllocation = {
  __typename?: "FinancialSummaryDiscountAllocation"
  /** The money amount that's allocated per unit on the associated line based on the discount application in shop and presentment currencies. If the allocated amount for the line cannot be evenly divided by the quantity, then this amount will be an approximate amount, avoiding fractional pennies. For example, if the associated line had a quantity of 3 with a discount of 4 cents, then the discount distribution would be [0.01, 0.01, 0.02]. This field returns the highest number of the distribution. In this example, this would be 0.02. */
  approximateAllocatedAmountPerItem: MoneyBag
  /** The discount application that the allocated amount originated from. */
  discountApplication: FinancialSummaryDiscountApplication
}

/**
 * Discount applications capture the intentions of a discount source at
 * the time of application on an order's line items or shipping lines.
 *
 */
export type FinancialSummaryDiscountApplication = {
  __typename?: "FinancialSummaryDiscountApplication"
  /** The method by which the discount's value is applied to its entitled items. */
  allocationMethod: DiscountApplicationAllocationMethod
  /** How the discount amount is distributed on the discounted lines. */
  targetSelection: DiscountApplicationTargetSelection
  /** Whether the discount is applied on line items or shipping lines. */
  targetType: DiscountApplicationTargetType
}

/** Return type for `flowGenerateSignature` mutation. */
export type FlowGenerateSignaturePayload = {
  __typename?: "FlowGenerateSignaturePayload"
  /** The payload used to generate the signature. */
  payload?: Maybe<Scalars["String"]["output"]>
  /** The generated signature. */
  signature?: Maybe<Scalars["String"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `flowTriggerReceive` mutation. */
export type FlowTriggerReceivePayload = {
  __typename?: "FlowTriggerReceivePayload"
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * Represents a fulfillment.
 * In Shopify, a fulfillment represents a shipment of one or more items in an order.
 * When an order has been completely fulfilled, it means that all the items that are included
 * in the order have been sent to the customer.
 * There can be more than one fulfillment for an order.
 *
 */
export type Fulfillment = LegacyInteroperability &
  Node & {
    __typename?: "Fulfillment"
    /** The date and time when the fulfillment was created. */
    createdAt: Scalars["DateTime"]["output"]
    /** The date that this fulfillment was delivered. */
    deliveredAt?: Maybe<Scalars["DateTime"]["output"]>
    /** Human readable display status for this fulfillment. */
    displayStatus?: Maybe<FulfillmentDisplayStatus>
    /** The estimated date that this fulfillment will arrive. */
    estimatedDeliveryAt?: Maybe<Scalars["DateTime"]["output"]>
    /** The history of events associated with this fulfillment. */
    events: FulfillmentEventConnection
    /** List of the fulfillment's line items. */
    fulfillmentLineItems: FulfillmentLineItemConnection
    /** A paginated list of fulfillment orders for the fulfillment. */
    fulfillmentOrders: FulfillmentOrderConnection
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The date and time when the fulfillment went into transit. */
    inTransitAt?: Maybe<Scalars["DateTime"]["output"]>
    /** The ID of the corresponding resource in the REST Admin API. */
    legacyResourceId: Scalars["UnsignedInt64"]["output"]
    /** The location that the fulfillment was processed at. */
    location?: Maybe<Location>
    /** Human readable reference identifier for this fulfillment. */
    name: Scalars["String"]["output"]
    /** The order for which the fulfillment was created. */
    order: Order
    /** The address at which the fulfillment occurred. This field is intended for tax purposes, as a full address is required for tax providers to accurately calculate taxes. Typically this is the address of the warehouse or fulfillment center. To retrieve a fulfillment location's address, use the `assignedLocation` field on the [`FulfillmentOrder`](/docs/api/admin-graphql/latest/objects/FulfillmentOrder) object instead. */
    originAddress?: Maybe<FulfillmentOriginAddress>
    /** Whether any of the line items in the fulfillment require shipping. */
    requiresShipping: Scalars["Boolean"]["output"]
    /** Fulfillment service associated with the fulfillment. */
    service?: Maybe<FulfillmentService>
    /** The status of the fulfillment. */
    status: FulfillmentStatus
    /** Sum of all line item quantities for the fulfillment. */
    totalQuantity: Scalars["Int"]["output"]
    /**
     * Tracking information associated with the fulfillment,
     * such as the tracking company, tracking number, and tracking URL.
     *
     */
    trackingInfo: Array<FulfillmentTrackingInfo>
    /**
     * The date and time when the fulfillment was last modified.
     *
     */
    updatedAt: Scalars["DateTime"]["output"]
  }

/**
 * Represents a fulfillment.
 * In Shopify, a fulfillment represents a shipment of one or more items in an order.
 * When an order has been completely fulfilled, it means that all the items that are included
 * in the order have been sent to the customer.
 * There can be more than one fulfillment for an order.
 *
 */
export type FulfillmentEventsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<FulfillmentEventSortKeys>
}

/**
 * Represents a fulfillment.
 * In Shopify, a fulfillment represents a shipment of one or more items in an order.
 * When an order has been completely fulfilled, it means that all the items that are included
 * in the order have been sent to the customer.
 * There can be more than one fulfillment for an order.
 *
 */
export type FulfillmentFulfillmentLineItemsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents a fulfillment.
 * In Shopify, a fulfillment represents a shipment of one or more items in an order.
 * When an order has been completely fulfilled, it means that all the items that are included
 * in the order have been sent to the customer.
 * There can be more than one fulfillment for an order.
 *
 */
export type FulfillmentFulfillmentOrdersArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents a fulfillment.
 * In Shopify, a fulfillment represents a shipment of one or more items in an order.
 * When an order has been completely fulfilled, it means that all the items that are included
 * in the order have been sent to the customer.
 * There can be more than one fulfillment for an order.
 *
 */
export type FulfillmentTrackingInfoArgs = {
  first?: InputMaybe<Scalars["Int"]["input"]>
}

/** Return type for `fulfillmentCancel` mutation. */
export type FulfillmentCancelPayload = {
  __typename?: "FulfillmentCancelPayload"
  /** The canceled fulfillment. */
  fulfillment?: Maybe<Fulfillment>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * An auto-generated type for paginating through multiple Fulfillments.
 *
 */
export type FulfillmentConnection = {
  __typename?: "FulfillmentConnection"
  /** A list of edges. */
  edges: Array<FulfillmentEdge>
  /** A list of the nodes contained in FulfillmentEdge. */
  nodes: Array<Fulfillment>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** A fulfillment constraint rule. */
export type FulfillmentConstraintRule = HasMetafields &
  Node & {
    __typename?: "FulfillmentConstraintRule"
    /** The ID for the fulfillment constraint function. */
    function: ShopifyFunction
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
  }

/** A fulfillment constraint rule. */
export type FulfillmentConstraintRuleMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/** A fulfillment constraint rule. */
export type FulfillmentConstraintRuleMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** A fulfillment constraint rule. */
export type FulfillmentConstraintRulePrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/** A fulfillment constraint rule. */
export type FulfillmentConstraintRulePrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Return type for `fulfillmentConstraintRuleCreate` mutation. */
export type FulfillmentConstraintRuleCreatePayload = {
  __typename?: "FulfillmentConstraintRuleCreatePayload"
  /** The newly created fulfillment constraint rule. */
  fulfillmentConstraintRule?: Maybe<FulfillmentConstraintRule>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<FulfillmentConstraintRuleCreateUserError>
}

/** An error that occurs during the execution of `FulfillmentConstraintRuleCreate`. */
export type FulfillmentConstraintRuleCreateUserError = DisplayableError & {
  __typename?: "FulfillmentConstraintRuleCreateUserError"
  /** The error code. */
  code?: Maybe<FulfillmentConstraintRuleCreateUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `FulfillmentConstraintRuleCreateUserError`. */
export enum FulfillmentConstraintRuleCreateUserErrorCode {
  /** Shop must be on a Shopify Plus plan to activate functions from a custom app. */
  CustomAppFunctionNotEligible = "CUSTOM_APP_FUNCTION_NOT_ELIGIBLE",
  /** A fulfillment constraint rule already exists for the provided function_id. */
  FunctionAlreadyRegistered = "FUNCTION_ALREADY_REGISTERED",
  /** Function does not implement the required interface for this fulfillment constraint rule. */
  FunctionDoesNotImplement = "FUNCTION_DOES_NOT_IMPLEMENT",
  /** No Shopify Function found for provided function_id. */
  FunctionNotFound = "FUNCTION_NOT_FOUND",
  /** Function is pending deletion and cannot have new rules created against it. */
  FunctionPendingDeletion = "FUNCTION_PENDING_DELETION",
  /** Failed to create fulfillment constraint rule due to invalid input. */
  InputInvalid = "INPUT_INVALID",
}

/** Return type for `fulfillmentConstraintRuleDelete` mutation. */
export type FulfillmentConstraintRuleDeletePayload = {
  __typename?: "FulfillmentConstraintRuleDeletePayload"
  /** Whether or not the fulfillment constraint rule was successfully deleted. */
  success?: Maybe<Scalars["Boolean"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<FulfillmentConstraintRuleDeleteUserError>
}

/** An error that occurs during the execution of `FulfillmentConstraintRuleDelete`. */
export type FulfillmentConstraintRuleDeleteUserError = DisplayableError & {
  __typename?: "FulfillmentConstraintRuleDeleteUserError"
  /** The error code. */
  code?: Maybe<FulfillmentConstraintRuleDeleteUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `FulfillmentConstraintRuleDeleteUserError`. */
export enum FulfillmentConstraintRuleDeleteUserErrorCode {
  /** Could not find fulfillment constraint rule for provided id. */
  NotFound = "NOT_FOUND",
  /** Unauthorized app scope. */
  UnauthorizedAppScope = "UNAUTHORIZED_APP_SCOPE",
}

/** Return type for `fulfillmentCreateV2` mutation. */
export type FulfillmentCreateV2Payload = {
  __typename?: "FulfillmentCreateV2Payload"
  /** The created fulfillment. */
  fulfillment?: Maybe<Fulfillment>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The display status of a fulfillment. */
export enum FulfillmentDisplayStatus {
  /** Displayed as **Attempted delivery**. */
  AttemptedDelivery = "ATTEMPTED_DELIVERY",
  /** Displayed as **Canceled**. */
  Canceled = "CANCELED",
  /** Displayed as **Confirmed**. */
  Confirmed = "CONFIRMED",
  /** Displayed as **Delivered**. */
  Delivered = "DELIVERED",
  /** Displayed as **Failure**. */
  Failure = "FAILURE",
  /** Displayed as **Fulfilled**. */
  Fulfilled = "FULFILLED",
  /** Displayed as **In transit**. */
  InTransit = "IN_TRANSIT",
  /** Displayed as **Label printed**. */
  LabelPrinted = "LABEL_PRINTED",
  /** Displayed as **Label purchased**. */
  LabelPurchased = "LABEL_PURCHASED",
  /** Displayed as **Label voided**. */
  LabelVoided = "LABEL_VOIDED",
  /** Displayed as **Marked as fulfilled**. */
  MarkedAsFulfilled = "MARKED_AS_FULFILLED",
  /** Displayed as **Not delivered**. */
  NotDelivered = "NOT_DELIVERED",
  /** Displayed as **Out for delivery**. */
  OutForDelivery = "OUT_FOR_DELIVERY",
  /** Displayed as **Picked up**. */
  PickedUp = "PICKED_UP",
  /** Displayed as **Ready for pickup**. */
  ReadyForPickup = "READY_FOR_PICKUP",
  /** Displayed as **Submitted**. */
  Submitted = "SUBMITTED",
}

/**
 * An auto-generated type which holds one Fulfillment and a cursor during pagination.
 *
 */
export type FulfillmentEdge = {
  __typename?: "FulfillmentEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of FulfillmentEdge. */
  node: Fulfillment
}

/** The fulfillment event that describes the fulfilllment status at a particular time. */
export type FulfillmentEvent = Node & {
  __typename?: "FulfillmentEvent"
  /** The street address where this fulfillment event occurred. */
  address1?: Maybe<Scalars["String"]["output"]>
  /** The city where this fulfillment event occurred. */
  city?: Maybe<Scalars["String"]["output"]>
  /** The country where this fulfillment event occurred. */
  country?: Maybe<Scalars["String"]["output"]>
  /** The estimated delivery date and time of the fulfillment. */
  estimatedDeliveryAt?: Maybe<Scalars["DateTime"]["output"]>
  /** The time at which this fulfillment event happened. */
  happenedAt: Scalars["DateTime"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The latitude where this fulfillment event occurred. */
  latitude?: Maybe<Scalars["Float"]["output"]>
  /** The longitude where this fulfillment event occurred. */
  longitude?: Maybe<Scalars["Float"]["output"]>
  /** A message associated with this fulfillment event. */
  message?: Maybe<Scalars["String"]["output"]>
  /** The province where this fulfillment event occurred. */
  province?: Maybe<Scalars["String"]["output"]>
  /** The status of this fulfillment event. */
  status: FulfillmentEventStatus
  /** The zip code of the location where this fulfillment event occurred. */
  zip?: Maybe<Scalars["String"]["output"]>
}

/**
 * An auto-generated type for paginating through multiple FulfillmentEvents.
 *
 */
export type FulfillmentEventConnection = {
  __typename?: "FulfillmentEventConnection"
  /** A list of edges. */
  edges: Array<FulfillmentEventEdge>
  /** A list of the nodes contained in FulfillmentEventEdge. */
  nodes: Array<FulfillmentEvent>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `fulfillmentEventCreate` mutation. */
export type FulfillmentEventCreatePayload = {
  __typename?: "FulfillmentEventCreatePayload"
  /** The created fulfillment event. */
  fulfillmentEvent?: Maybe<FulfillmentEvent>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * An auto-generated type which holds one FulfillmentEvent and a cursor during pagination.
 *
 */
export type FulfillmentEventEdge = {
  __typename?: "FulfillmentEventEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of FulfillmentEventEdge. */
  node: FulfillmentEvent
}

/** The input fields used to create a fulfillment event. */
export type FulfillmentEventInput = {
  /** The street address where this fulfillment event occurred. */
  address1?: InputMaybe<Scalars["String"]["input"]>
  /** The city where this fulfillment event occurred. */
  city?: InputMaybe<Scalars["String"]["input"]>
  /** The country where this fulfillment event occurred. */
  country?: InputMaybe<Scalars["String"]["input"]>
  /** The estimated delivery date and time of the fulfillment. */
  estimatedDeliveryAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The ID for the fulfillment that's associated with this fulfillment event. */
  fulfillmentId: Scalars["ID"]["input"]
  /** The time at which this fulfillment event happened. */
  happenedAt?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The latitude where this fulfillment event occurred. */
  latitude?: InputMaybe<Scalars["Float"]["input"]>
  /** The longitude where this fulfillment event occurred. */
  longitude?: InputMaybe<Scalars["Float"]["input"]>
  /** A message associated with this fulfillment event. */
  message?: InputMaybe<Scalars["String"]["input"]>
  /** The province where this fulfillment event occurred. */
  province?: InputMaybe<Scalars["String"]["input"]>
  /** The status of this fulfillment event. */
  status: FulfillmentEventStatus
  /** The zip code of the location where this fulfillment event occurred. */
  zip?: InputMaybe<Scalars["String"]["input"]>
}

/** The set of valid sort keys for the FulfillmentEvent query. */
export enum FulfillmentEventSortKeys {
  /** Sort by the `happened_at` value. */
  HappenedAt = "HAPPENED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
}

/** The status that describes a fulfillment or delivery event. */
export enum FulfillmentEventStatus {
  /** A delivery was attempted. */
  AttemptedDelivery = "ATTEMPTED_DELIVERY",
  /** The fulfillment is confirmed. This is the default value when no other information is available. */
  Confirmed = "CONFIRMED",
  /** The fulfillment was successfully delivered. */
  Delivered = "DELIVERED",
  /** The fulfillment request failed. */
  Failure = "FAILURE",
  /** The fulfillment is in transit. */
  InTransit = "IN_TRANSIT",
  /** A purchased shipping label has been printed. */
  LabelPrinted = "LABEL_PRINTED",
  /** A shipping label has been purchased. */
  LabelPurchased = "LABEL_PURCHASED",
  /** The fulfillment is out for delivery. */
  OutForDelivery = "OUT_FOR_DELIVERY",
  /** The fulfillment is ready to be picked up. */
  ReadyForPickup = "READY_FOR_PICKUP",
}

/**
 * A fulfillment hold currently applied on a fulfillment order.
 *
 */
export type FulfillmentHold = {
  __typename?: "FulfillmentHold"
  /** The name of the app or service that applied the fulfillment hold. */
  heldBy?: Maybe<Scalars["String"]["output"]>
  /** The reason for the fulfillment hold. */
  reason: FulfillmentHoldReason
  /** Additional information about the fulfillment hold reason. */
  reasonNotes?: Maybe<Scalars["String"]["output"]>
}

/** The reason for a fulfillment hold. */
export enum FulfillmentHoldReason {
  /** The fulfillment hold is applied because payment is pending. */
  AwaitingPayment = "AWAITING_PAYMENT",
  /** The fulfillment hold is applied because of return items not yet received during an exchange. */
  AwaitingReturnItems = "AWAITING_RETURN_ITEMS",
  /** The fulfillment hold is applied because of a high risk of fraud. */
  HighRiskOfFraud = "HIGH_RISK_OF_FRAUD",
  /** The fulfillment hold is applied because of an incorrect address. */
  IncorrectAddress = "INCORRECT_ADDRESS",
  /** The fulfillment hold is applied because inventory is out of stock. */
  InventoryOutOfStock = "INVENTORY_OUT_OF_STOCK",
  /** The fulfillment hold is applied because of a post purchase upsell offer. */
  OnlineStorePostPurchaseCrossSell = "ONLINE_STORE_POST_PURCHASE_CROSS_SELL",
  /** The fulfillment hold is applied for another reason. */
  Other = "OTHER",
  /** The fulfillment hold is applied because of an unknown delivery date. */
  UnknownDeliveryDate = "UNKNOWN_DELIVERY_DATE",
}

/** Represents a line item from an order that's included in a fulfillment. */
export type FulfillmentLineItem = Node & {
  __typename?: "FulfillmentLineItem"
  /**
   * The total price after discounts are applied.
   * @deprecated Use `discountedTotalSet` instead.
   */
  discountedTotal: Scalars["Money"]["output"]
  /** The total price after discounts are applied in shop and presentment currencies. */
  discountedTotalSet: MoneyBag
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The associated order's line item. */
  lineItem: LineItem
  /**
   * The total price before discounts are applied.
   * @deprecated Use `originalTotalSet` instead.
   */
  originalTotal: Scalars["Money"]["output"]
  /** The total price before discounts are applied in shop and presentment currencies. */
  originalTotalSet: MoneyBag
  /** Number of line items in the fulfillment. */
  quantity?: Maybe<Scalars["Int"]["output"]>
}

/**
 * An auto-generated type for paginating through multiple FulfillmentLineItems.
 *
 */
export type FulfillmentLineItemConnection = {
  __typename?: "FulfillmentLineItemConnection"
  /** A list of edges. */
  edges: Array<FulfillmentLineItemEdge>
  /** A list of the nodes contained in FulfillmentLineItemEdge. */
  nodes: Array<FulfillmentLineItem>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one FulfillmentLineItem and a cursor during pagination.
 *
 */
export type FulfillmentLineItemEdge = {
  __typename?: "FulfillmentLineItemEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of FulfillmentLineItemEdge. */
  node: FulfillmentLineItem
}

/**
 * The FulfillmentOrder object represents either an item or a group of items in an
 * [Order](https://shopify.dev/api/admin-graphql/latest/objects/Order)
 * that are expected to be fulfilled from the same location.
 * There can be more than one fulfillment order for an
 * [order](https://shopify.dev/api/admin-graphql/latest/objects/Order)
 * at a given location.
 *
 * {{ '/api/reference/fulfillment_order_relationships.png' | image }}
 *
 * Fulfillment orders represent the work which is intended to be done in relation to an order.
 * When fulfillment has started for one or more line items, a
 * [Fulfillment](https://shopify.dev/api/admin-graphql/latest/objects/Fulfillment)
 * is created by a merchant or third party to represent the ongoing or completed work of fulfillment.
 *
 * [See below for more details on creating fulfillments](#the-lifecycle-of-a-fulfillment-order-at-a-location-which-is-managed-by-a-fulfillment-service).
 *
 * > Note:
 * > Shopify creates fulfillment orders automatically when an order is created.
 * > It is not possible to manually create fulfillment orders.
 * >
 * > [See below for more details on the lifecycle of a fulfillment order](#the-lifecycle-of-a-fulfillment-order).
 *
 * ## Retrieving fulfillment orders
 *
 * ### Fulfillment orders from an order
 *
 * All fulfillment orders related to a given order can be retrieved with the
 * [Order.fulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/objects/Order#connection-order-fulfillmentorders)
 * connection.
 *
 * [API access scopes](#api-access-scopes)
 * govern which fulfillments orders are returned to clients.
 * An API client will only receive a subset of the fulfillment orders which belong to an order
 * if they don't have the necessary access scopes to view all of the fulfillment orders.
 *
 * ### Fulfillment orders assigned to the app for fulfillment
 *
 * Fulfillment service apps can retrieve the fulfillment orders which have been assigned to their locations with the
 * [Shop.assignedFulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/objects/Shop#connection-shop-assignedfulfillmentorders)
 * connection.
 * Use the `assignmentStatus` argument to control whether all assigned fulfillment orders
 * should be returned or only those where a merchant has sent a
 * [fulfillment request](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentOrderMerchantRequest)
 * and it has yet to be responded to.
 *
 * The API client must be granted the `read_assigned_fulfillment_orders` access scope to access
 * the assigned fulfillment orders.
 *
 * ### All fulfillment orders
 *
 * Apps can retrieve all fulfillment orders with the
 * [fulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/queries/fulfillmentOrders)
 * query. This query returns all assigned, merchant-managed, and third-party fulfillment orders on the shop,
 * which are accessible to the app according to the
 * [fulfillment order access scopes](#api-access-scopes) it was granted with.
 *
 * ## The lifecycle of a fulfillment order
 *
 * ### Fulfillment Order Creation
 *
 * After an order is created, a background worker performs the order routing process which determines
 * which locations will be responsible for fulfilling the purchased items.
 * Once the order routing process is complete, one or more fulfillment orders will be created
 * and assigned to these locations. It is not possible to manually create fulfillment orders.
 *
 * Once a fulfillment order has been created, it will have one of two different lifecycles depending on
 * the type of location which the fulfillment order is assigned to.
 *
 * ### The lifecycle of a fulfillment order at a merchant managed location
 *
 * Fulfillment orders are completed by creating
 * [fulfillments](https://shopify.dev/api/admin-graphql/latest/objects/Fulfillment).
 * Fulfillments represents the work done.
 *
 * For digital products a merchant or an order management app would create a fulfilment once the digital asset
 * has been provisioned.
 * For example, in the case of a digital gift card, a merchant would to do this once
 * the gift card has been activated - before the email has been shipped.
 *
 * On the other hand, for a traditional shipped order,
 * a merchant or an order management app would create a fulfillment after picking and packing the items relating
 * to a fulfillment order, but before the courier has collected the goods.
 *
 * [Learn about managing fulfillment orders as an order management app](https://shopify.dev/apps/fulfillment/order-management-apps/manage-fulfillments).
 *
 * ### The lifecycle of a fulfillment order at a location which is managed by a fulfillment service
 *
 * For fulfillment orders which are assigned to a location that is managed by a fulfillment service,
 * a merchant or an Order Management App can
 * [send a fulfillment request](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderSubmitFulfillmentRequest)
 * to the fulfillment service which operates the location to request that they fulfill the associated items.
 * A fulfillment service has the option to
 * [accept](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderAcceptFulfillmentRequest)
 * or [reject](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderRejectFulfillmentRequest)
 * this fulfillment request.
 *
 * Once the fulfillment service has accepted the request, the request can no longer be cancelled by the merchant
 * or order management app and instead a
 * [cancellation request must be submitted](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderSubmitCancellationRequest)
 * to the fulfillment service.
 *
 * Once a fulfillment service accepts a fulfillment request,
 * then after they are ready to pack items and send them for delivery, they create fulfillments with the
 * [fulfillmentCreateV2](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentCreateV2)
 * mutation.
 * They can provide tracking information right away or create fulfillments without it and then
 * update the tracking information for fulfillments with the
 * [fulfillmentTrackingInfoUpdateV2](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentTrackingInfoUpdateV2)
 * mutation.
 *
 * [Learn about managing fulfillment orders as a fulfillment service](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments).
 *
 * ## API access scopes
 *
 * Fulfillment orders are governed by the following API access scopes:
 *
 * * The `read_merchant_managed_fulfillment_orders` and
 *   `write_merchant_managed_fulfillment_orders` access scopes
 *   grant access to fulfillment orders assigned to merchant-managed locations.
 * * The `read_assigned_fulfillment_orders` and `write_assigned_fulfillment_orders`
 *   access scopes are intended for fulfillment services.
 *   These scopes grant access to fulfillment orders assigned to locations that are being managed
 *   by fulfillment services.
 * * The `read_third_party_fulfillment_orders` and `write_third_party_fulfillment_orders`
 *   access scopes grant access to fulfillment orders
 *   assigned to locations managed by other fulfillment services.
 *
 * ### Fulfillment service app access scopes
 *
 * Usually, **fulfillment services** have the `write_assigned_fulfillment_orders` access scope
 * and don't have the `*_third_party_fulfillment_orders`
 * or `*_merchant_managed_fulfillment_orders` access scopes.
 * The app will only have access to the fulfillment orders assigned to their location
 * (or multiple locations if the app registers multiple fulfillment services on the shop).
 * The app will not have access to fulfillment orders assigned to merchant-managed locations
 * or locations owned by other fulfillment service apps.
 *
 * ### Order management app access scopes
 *
 * **Order management apps** will usually request `write_merchant_managed_fulfillment_orders` and
 * `write_third_party_fulfillment_orders` access scopes. This will allow them to manage all fulfillment orders
 * on behalf of a merchant.
 *
 * If an app combines the functions of an order management app and a fulfillment service,
 * then the app should request all
 * access scopes to manage all assigned and all unassigned fulfillment orders.
 *
 * ## Notifications about fulfillment orders
 *
 * Fulfillment services are required to
 * [register](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentService)
 * a self-hosted callback URL which has a number of uses. One of these uses is that this callback URL will be notified
 * whenever a merchant submits a fulfillment or cancellation request.
 *
 * Both merchants and apps can
 * [subscribe](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments#webhooks)
 * to the
 * [fulfillment order webhooks](https://shopify.dev/api/admin-graphql/latest/enums/WebhookSubscriptionTopic#value-fulfillmentorderscancellationrequestaccepted)
 * to be notified whenever fulfillment order related domain events occur.
 *
 * [Learn about fulfillment workflows](https://shopify.dev/apps/fulfillment).
 *
 */
export type FulfillmentOrder = Node & {
  __typename?: "FulfillmentOrder"
  /**
   * The fulfillment order's assigned location. This is the location where the fulfillment is expected to happen.
   *
   * The fulfillment order's assigned location might change in the following cases:
   *
   * - The fulfillment order has been entirely moved to a new location. For example, the [fulfillmentOrderMove](
   *   https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderMove
   *   ) mutation has been called, and you see the original fulfillment order in the [movedFulfillmentOrder](
   *   https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderMove#field-fulfillmentordermovepayload-movedfulfillmentorder
   *   ) field within the mutation's response.
   * - Work on the fulfillment order hasn't yet begun, which means that the fulfillment order has the
   *     [OPEN](https://shopify.dev/api/admin-graphql/latest/enums/FulfillmentOrderStatus#value-open),
   *     [SCHEDULED](https://shopify.dev/api/admin-graphql/latest/enums/FulfillmentOrderStatus#value-scheduled), or
   *     [ON_HOLD](https://shopify.dev/api/admin-graphql/latest/enums/FulfillmentOrderStatus#value-onhold)
   *     status, and the shop's location properties might be undergoing edits (for example, in the Shopify admin).
   *
   */
  assignedLocation: FulfillmentOrderAssignedLocation
  /** ID of the channel that created the order. */
  channelId?: Maybe<Scalars["ID"]["output"]>
  /** Date and time when the fulfillment order was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** Delivery method of this fulfillment order. */
  deliveryMethod?: Maybe<DeliveryMethod>
  /** The destination where the items should be sent. */
  destination?: Maybe<FulfillmentOrderDestination>
  /** The date and time at which the fulfillment order will be fulfillable. When this date and time is reached, the scheduled fulfillment order is automatically transitioned to open. For example, the `fulfill_at` date for a subscription order might be the 1st of each month, a pre-order `fulfill_at` date would be `nil`, and a standard order `fulfill_at` date would be the order creation date. */
  fulfillAt?: Maybe<Scalars["DateTime"]["output"]>
  /** The latest date and time by which all items in the fulfillment order need to be fulfilled. */
  fulfillBy?: Maybe<Scalars["DateTime"]["output"]>
  /** The fulfillment holds applied on the fulfillment order. */
  fulfillmentHolds: Array<FulfillmentHold>
  /** Fulfillment orders eligible for merging with the given fulfillment order. */
  fulfillmentOrdersForMerge: FulfillmentOrderConnection
  /** A list of fulfillments for the fulfillment order. */
  fulfillments: FulfillmentConnection
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The duties delivery method of this fulfillment order. */
  internationalDuties?: Maybe<FulfillmentOrderInternationalDuties>
  /** A list of the fulfillment order's line items. */
  lineItems: FulfillmentOrderLineItemConnection
  /** A list of locations that the fulfillment order can potentially move to. */
  locationsForMove: FulfillmentOrderLocationForMoveConnection
  /** A list of requests sent by the merchant or an order management app to the fulfillment service for the fulfillment order. */
  merchantRequests: FulfillmentOrderMerchantRequestConnection
  /** The order that's associated with the fulfillment order. */
  order: Order
  /** ID of the order that's associated with the fulfillment order. */
  orderId: Scalars["ID"]["output"]
  /**
   * The unique identifier for the order that appears on the order page in the Shopify admin and the <b>Order status</b> page.
   * For example, "#1001", "EN1001", or "1001-A".
   * This value isn't unique across multiple stores.
   *
   */
  orderName: Scalars["String"]["output"]
  /**
   * The date and time when the order was processed.
   * This date and time might not match the date and time when the order was created.
   *
   */
  orderProcessedAt: Scalars["DateTime"]["output"]
  /** The request status of the fulfillment order. */
  requestStatus: FulfillmentOrderRequestStatus
  /** The status of the fulfillment order. */
  status: FulfillmentOrderStatus
  /** The actions that can be performed on this fulfillment order. */
  supportedActions: Array<FulfillmentOrderSupportedAction>
  /** The date and time when the fulfillment order was last updated. */
  updatedAt: Scalars["DateTime"]["output"]
}

/**
 * The FulfillmentOrder object represents either an item or a group of items in an
 * [Order](https://shopify.dev/api/admin-graphql/latest/objects/Order)
 * that are expected to be fulfilled from the same location.
 * There can be more than one fulfillment order for an
 * [order](https://shopify.dev/api/admin-graphql/latest/objects/Order)
 * at a given location.
 *
 * {{ '/api/reference/fulfillment_order_relationships.png' | image }}
 *
 * Fulfillment orders represent the work which is intended to be done in relation to an order.
 * When fulfillment has started for one or more line items, a
 * [Fulfillment](https://shopify.dev/api/admin-graphql/latest/objects/Fulfillment)
 * is created by a merchant or third party to represent the ongoing or completed work of fulfillment.
 *
 * [See below for more details on creating fulfillments](#the-lifecycle-of-a-fulfillment-order-at-a-location-which-is-managed-by-a-fulfillment-service).
 *
 * > Note:
 * > Shopify creates fulfillment orders automatically when an order is created.
 * > It is not possible to manually create fulfillment orders.
 * >
 * > [See below for more details on the lifecycle of a fulfillment order](#the-lifecycle-of-a-fulfillment-order).
 *
 * ## Retrieving fulfillment orders
 *
 * ### Fulfillment orders from an order
 *
 * All fulfillment orders related to a given order can be retrieved with the
 * [Order.fulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/objects/Order#connection-order-fulfillmentorders)
 * connection.
 *
 * [API access scopes](#api-access-scopes)
 * govern which fulfillments orders are returned to clients.
 * An API client will only receive a subset of the fulfillment orders which belong to an order
 * if they don't have the necessary access scopes to view all of the fulfillment orders.
 *
 * ### Fulfillment orders assigned to the app for fulfillment
 *
 * Fulfillment service apps can retrieve the fulfillment orders which have been assigned to their locations with the
 * [Shop.assignedFulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/objects/Shop#connection-shop-assignedfulfillmentorders)
 * connection.
 * Use the `assignmentStatus` argument to control whether all assigned fulfillment orders
 * should be returned or only those where a merchant has sent a
 * [fulfillment request](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentOrderMerchantRequest)
 * and it has yet to be responded to.
 *
 * The API client must be granted the `read_assigned_fulfillment_orders` access scope to access
 * the assigned fulfillment orders.
 *
 * ### All fulfillment orders
 *
 * Apps can retrieve all fulfillment orders with the
 * [fulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/queries/fulfillmentOrders)
 * query. This query returns all assigned, merchant-managed, and third-party fulfillment orders on the shop,
 * which are accessible to the app according to the
 * [fulfillment order access scopes](#api-access-scopes) it was granted with.
 *
 * ## The lifecycle of a fulfillment order
 *
 * ### Fulfillment Order Creation
 *
 * After an order is created, a background worker performs the order routing process which determines
 * which locations will be responsible for fulfilling the purchased items.
 * Once the order routing process is complete, one or more fulfillment orders will be created
 * and assigned to these locations. It is not possible to manually create fulfillment orders.
 *
 * Once a fulfillment order has been created, it will have one of two different lifecycles depending on
 * the type of location which the fulfillment order is assigned to.
 *
 * ### The lifecycle of a fulfillment order at a merchant managed location
 *
 * Fulfillment orders are completed by creating
 * [fulfillments](https://shopify.dev/api/admin-graphql/latest/objects/Fulfillment).
 * Fulfillments represents the work done.
 *
 * For digital products a merchant or an order management app would create a fulfilment once the digital asset
 * has been provisioned.
 * For example, in the case of a digital gift card, a merchant would to do this once
 * the gift card has been activated - before the email has been shipped.
 *
 * On the other hand, for a traditional shipped order,
 * a merchant or an order management app would create a fulfillment after picking and packing the items relating
 * to a fulfillment order, but before the courier has collected the goods.
 *
 * [Learn about managing fulfillment orders as an order management app](https://shopify.dev/apps/fulfillment/order-management-apps/manage-fulfillments).
 *
 * ### The lifecycle of a fulfillment order at a location which is managed by a fulfillment service
 *
 * For fulfillment orders which are assigned to a location that is managed by a fulfillment service,
 * a merchant or an Order Management App can
 * [send a fulfillment request](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderSubmitFulfillmentRequest)
 * to the fulfillment service which operates the location to request that they fulfill the associated items.
 * A fulfillment service has the option to
 * [accept](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderAcceptFulfillmentRequest)
 * or [reject](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderRejectFulfillmentRequest)
 * this fulfillment request.
 *
 * Once the fulfillment service has accepted the request, the request can no longer be cancelled by the merchant
 * or order management app and instead a
 * [cancellation request must be submitted](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderSubmitCancellationRequest)
 * to the fulfillment service.
 *
 * Once a fulfillment service accepts a fulfillment request,
 * then after they are ready to pack items and send them for delivery, they create fulfillments with the
 * [fulfillmentCreateV2](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentCreateV2)
 * mutation.
 * They can provide tracking information right away or create fulfillments without it and then
 * update the tracking information for fulfillments with the
 * [fulfillmentTrackingInfoUpdateV2](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentTrackingInfoUpdateV2)
 * mutation.
 *
 * [Learn about managing fulfillment orders as a fulfillment service](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments).
 *
 * ## API access scopes
 *
 * Fulfillment orders are governed by the following API access scopes:
 *
 * * The `read_merchant_managed_fulfillment_orders` and
 *   `write_merchant_managed_fulfillment_orders` access scopes
 *   grant access to fulfillment orders assigned to merchant-managed locations.
 * * The `read_assigned_fulfillment_orders` and `write_assigned_fulfillment_orders`
 *   access scopes are intended for fulfillment services.
 *   These scopes grant access to fulfillment orders assigned to locations that are being managed
 *   by fulfillment services.
 * * The `read_third_party_fulfillment_orders` and `write_third_party_fulfillment_orders`
 *   access scopes grant access to fulfillment orders
 *   assigned to locations managed by other fulfillment services.
 *
 * ### Fulfillment service app access scopes
 *
 * Usually, **fulfillment services** have the `write_assigned_fulfillment_orders` access scope
 * and don't have the `*_third_party_fulfillment_orders`
 * or `*_merchant_managed_fulfillment_orders` access scopes.
 * The app will only have access to the fulfillment orders assigned to their location
 * (or multiple locations if the app registers multiple fulfillment services on the shop).
 * The app will not have access to fulfillment orders assigned to merchant-managed locations
 * or locations owned by other fulfillment service apps.
 *
 * ### Order management app access scopes
 *
 * **Order management apps** will usually request `write_merchant_managed_fulfillment_orders` and
 * `write_third_party_fulfillment_orders` access scopes. This will allow them to manage all fulfillment orders
 * on behalf of a merchant.
 *
 * If an app combines the functions of an order management app and a fulfillment service,
 * then the app should request all
 * access scopes to manage all assigned and all unassigned fulfillment orders.
 *
 * ## Notifications about fulfillment orders
 *
 * Fulfillment services are required to
 * [register](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentService)
 * a self-hosted callback URL which has a number of uses. One of these uses is that this callback URL will be notified
 * whenever a merchant submits a fulfillment or cancellation request.
 *
 * Both merchants and apps can
 * [subscribe](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments#webhooks)
 * to the
 * [fulfillment order webhooks](https://shopify.dev/api/admin-graphql/latest/enums/WebhookSubscriptionTopic#value-fulfillmentorderscancellationrequestaccepted)
 * to be notified whenever fulfillment order related domain events occur.
 *
 * [Learn about fulfillment workflows](https://shopify.dev/apps/fulfillment).
 *
 */
export type FulfillmentOrderFulfillmentOrdersForMergeArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * The FulfillmentOrder object represents either an item or a group of items in an
 * [Order](https://shopify.dev/api/admin-graphql/latest/objects/Order)
 * that are expected to be fulfilled from the same location.
 * There can be more than one fulfillment order for an
 * [order](https://shopify.dev/api/admin-graphql/latest/objects/Order)
 * at a given location.
 *
 * {{ '/api/reference/fulfillment_order_relationships.png' | image }}
 *
 * Fulfillment orders represent the work which is intended to be done in relation to an order.
 * When fulfillment has started for one or more line items, a
 * [Fulfillment](https://shopify.dev/api/admin-graphql/latest/objects/Fulfillment)
 * is created by a merchant or third party to represent the ongoing or completed work of fulfillment.
 *
 * [See below for more details on creating fulfillments](#the-lifecycle-of-a-fulfillment-order-at-a-location-which-is-managed-by-a-fulfillment-service).
 *
 * > Note:
 * > Shopify creates fulfillment orders automatically when an order is created.
 * > It is not possible to manually create fulfillment orders.
 * >
 * > [See below for more details on the lifecycle of a fulfillment order](#the-lifecycle-of-a-fulfillment-order).
 *
 * ## Retrieving fulfillment orders
 *
 * ### Fulfillment orders from an order
 *
 * All fulfillment orders related to a given order can be retrieved with the
 * [Order.fulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/objects/Order#connection-order-fulfillmentorders)
 * connection.
 *
 * [API access scopes](#api-access-scopes)
 * govern which fulfillments orders are returned to clients.
 * An API client will only receive a subset of the fulfillment orders which belong to an order
 * if they don't have the necessary access scopes to view all of the fulfillment orders.
 *
 * ### Fulfillment orders assigned to the app for fulfillment
 *
 * Fulfillment service apps can retrieve the fulfillment orders which have been assigned to their locations with the
 * [Shop.assignedFulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/objects/Shop#connection-shop-assignedfulfillmentorders)
 * connection.
 * Use the `assignmentStatus` argument to control whether all assigned fulfillment orders
 * should be returned or only those where a merchant has sent a
 * [fulfillment request](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentOrderMerchantRequest)
 * and it has yet to be responded to.
 *
 * The API client must be granted the `read_assigned_fulfillment_orders` access scope to access
 * the assigned fulfillment orders.
 *
 * ### All fulfillment orders
 *
 * Apps can retrieve all fulfillment orders with the
 * [fulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/queries/fulfillmentOrders)
 * query. This query returns all assigned, merchant-managed, and third-party fulfillment orders on the shop,
 * which are accessible to the app according to the
 * [fulfillment order access scopes](#api-access-scopes) it was granted with.
 *
 * ## The lifecycle of a fulfillment order
 *
 * ### Fulfillment Order Creation
 *
 * After an order is created, a background worker performs the order routing process which determines
 * which locations will be responsible for fulfilling the purchased items.
 * Once the order routing process is complete, one or more fulfillment orders will be created
 * and assigned to these locations. It is not possible to manually create fulfillment orders.
 *
 * Once a fulfillment order has been created, it will have one of two different lifecycles depending on
 * the type of location which the fulfillment order is assigned to.
 *
 * ### The lifecycle of a fulfillment order at a merchant managed location
 *
 * Fulfillment orders are completed by creating
 * [fulfillments](https://shopify.dev/api/admin-graphql/latest/objects/Fulfillment).
 * Fulfillments represents the work done.
 *
 * For digital products a merchant or an order management app would create a fulfilment once the digital asset
 * has been provisioned.
 * For example, in the case of a digital gift card, a merchant would to do this once
 * the gift card has been activated - before the email has been shipped.
 *
 * On the other hand, for a traditional shipped order,
 * a merchant or an order management app would create a fulfillment after picking and packing the items relating
 * to a fulfillment order, but before the courier has collected the goods.
 *
 * [Learn about managing fulfillment orders as an order management app](https://shopify.dev/apps/fulfillment/order-management-apps/manage-fulfillments).
 *
 * ### The lifecycle of a fulfillment order at a location which is managed by a fulfillment service
 *
 * For fulfillment orders which are assigned to a location that is managed by a fulfillment service,
 * a merchant or an Order Management App can
 * [send a fulfillment request](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderSubmitFulfillmentRequest)
 * to the fulfillment service which operates the location to request that they fulfill the associated items.
 * A fulfillment service has the option to
 * [accept](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderAcceptFulfillmentRequest)
 * or [reject](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderRejectFulfillmentRequest)
 * this fulfillment request.
 *
 * Once the fulfillment service has accepted the request, the request can no longer be cancelled by the merchant
 * or order management app and instead a
 * [cancellation request must be submitted](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderSubmitCancellationRequest)
 * to the fulfillment service.
 *
 * Once a fulfillment service accepts a fulfillment request,
 * then after they are ready to pack items and send them for delivery, they create fulfillments with the
 * [fulfillmentCreateV2](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentCreateV2)
 * mutation.
 * They can provide tracking information right away or create fulfillments without it and then
 * update the tracking information for fulfillments with the
 * [fulfillmentTrackingInfoUpdateV2](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentTrackingInfoUpdateV2)
 * mutation.
 *
 * [Learn about managing fulfillment orders as a fulfillment service](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments).
 *
 * ## API access scopes
 *
 * Fulfillment orders are governed by the following API access scopes:
 *
 * * The `read_merchant_managed_fulfillment_orders` and
 *   `write_merchant_managed_fulfillment_orders` access scopes
 *   grant access to fulfillment orders assigned to merchant-managed locations.
 * * The `read_assigned_fulfillment_orders` and `write_assigned_fulfillment_orders`
 *   access scopes are intended for fulfillment services.
 *   These scopes grant access to fulfillment orders assigned to locations that are being managed
 *   by fulfillment services.
 * * The `read_third_party_fulfillment_orders` and `write_third_party_fulfillment_orders`
 *   access scopes grant access to fulfillment orders
 *   assigned to locations managed by other fulfillment services.
 *
 * ### Fulfillment service app access scopes
 *
 * Usually, **fulfillment services** have the `write_assigned_fulfillment_orders` access scope
 * and don't have the `*_third_party_fulfillment_orders`
 * or `*_merchant_managed_fulfillment_orders` access scopes.
 * The app will only have access to the fulfillment orders assigned to their location
 * (or multiple locations if the app registers multiple fulfillment services on the shop).
 * The app will not have access to fulfillment orders assigned to merchant-managed locations
 * or locations owned by other fulfillment service apps.
 *
 * ### Order management app access scopes
 *
 * **Order management apps** will usually request `write_merchant_managed_fulfillment_orders` and
 * `write_third_party_fulfillment_orders` access scopes. This will allow them to manage all fulfillment orders
 * on behalf of a merchant.
 *
 * If an app combines the functions of an order management app and a fulfillment service,
 * then the app should request all
 * access scopes to manage all assigned and all unassigned fulfillment orders.
 *
 * ## Notifications about fulfillment orders
 *
 * Fulfillment services are required to
 * [register](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentService)
 * a self-hosted callback URL which has a number of uses. One of these uses is that this callback URL will be notified
 * whenever a merchant submits a fulfillment or cancellation request.
 *
 * Both merchants and apps can
 * [subscribe](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments#webhooks)
 * to the
 * [fulfillment order webhooks](https://shopify.dev/api/admin-graphql/latest/enums/WebhookSubscriptionTopic#value-fulfillmentorderscancellationrequestaccepted)
 * to be notified whenever fulfillment order related domain events occur.
 *
 * [Learn about fulfillment workflows](https://shopify.dev/apps/fulfillment).
 *
 */
export type FulfillmentOrderFulfillmentsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * The FulfillmentOrder object represents either an item or a group of items in an
 * [Order](https://shopify.dev/api/admin-graphql/latest/objects/Order)
 * that are expected to be fulfilled from the same location.
 * There can be more than one fulfillment order for an
 * [order](https://shopify.dev/api/admin-graphql/latest/objects/Order)
 * at a given location.
 *
 * {{ '/api/reference/fulfillment_order_relationships.png' | image }}
 *
 * Fulfillment orders represent the work which is intended to be done in relation to an order.
 * When fulfillment has started for one or more line items, a
 * [Fulfillment](https://shopify.dev/api/admin-graphql/latest/objects/Fulfillment)
 * is created by a merchant or third party to represent the ongoing or completed work of fulfillment.
 *
 * [See below for more details on creating fulfillments](#the-lifecycle-of-a-fulfillment-order-at-a-location-which-is-managed-by-a-fulfillment-service).
 *
 * > Note:
 * > Shopify creates fulfillment orders automatically when an order is created.
 * > It is not possible to manually create fulfillment orders.
 * >
 * > [See below for more details on the lifecycle of a fulfillment order](#the-lifecycle-of-a-fulfillment-order).
 *
 * ## Retrieving fulfillment orders
 *
 * ### Fulfillment orders from an order
 *
 * All fulfillment orders related to a given order can be retrieved with the
 * [Order.fulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/objects/Order#connection-order-fulfillmentorders)
 * connection.
 *
 * [API access scopes](#api-access-scopes)
 * govern which fulfillments orders are returned to clients.
 * An API client will only receive a subset of the fulfillment orders which belong to an order
 * if they don't have the necessary access scopes to view all of the fulfillment orders.
 *
 * ### Fulfillment orders assigned to the app for fulfillment
 *
 * Fulfillment service apps can retrieve the fulfillment orders which have been assigned to their locations with the
 * [Shop.assignedFulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/objects/Shop#connection-shop-assignedfulfillmentorders)
 * connection.
 * Use the `assignmentStatus` argument to control whether all assigned fulfillment orders
 * should be returned or only those where a merchant has sent a
 * [fulfillment request](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentOrderMerchantRequest)
 * and it has yet to be responded to.
 *
 * The API client must be granted the `read_assigned_fulfillment_orders` access scope to access
 * the assigned fulfillment orders.
 *
 * ### All fulfillment orders
 *
 * Apps can retrieve all fulfillment orders with the
 * [fulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/queries/fulfillmentOrders)
 * query. This query returns all assigned, merchant-managed, and third-party fulfillment orders on the shop,
 * which are accessible to the app according to the
 * [fulfillment order access scopes](#api-access-scopes) it was granted with.
 *
 * ## The lifecycle of a fulfillment order
 *
 * ### Fulfillment Order Creation
 *
 * After an order is created, a background worker performs the order routing process which determines
 * which locations will be responsible for fulfilling the purchased items.
 * Once the order routing process is complete, one or more fulfillment orders will be created
 * and assigned to these locations. It is not possible to manually create fulfillment orders.
 *
 * Once a fulfillment order has been created, it will have one of two different lifecycles depending on
 * the type of location which the fulfillment order is assigned to.
 *
 * ### The lifecycle of a fulfillment order at a merchant managed location
 *
 * Fulfillment orders are completed by creating
 * [fulfillments](https://shopify.dev/api/admin-graphql/latest/objects/Fulfillment).
 * Fulfillments represents the work done.
 *
 * For digital products a merchant or an order management app would create a fulfilment once the digital asset
 * has been provisioned.
 * For example, in the case of a digital gift card, a merchant would to do this once
 * the gift card has been activated - before the email has been shipped.
 *
 * On the other hand, for a traditional shipped order,
 * a merchant or an order management app would create a fulfillment after picking and packing the items relating
 * to a fulfillment order, but before the courier has collected the goods.
 *
 * [Learn about managing fulfillment orders as an order management app](https://shopify.dev/apps/fulfillment/order-management-apps/manage-fulfillments).
 *
 * ### The lifecycle of a fulfillment order at a location which is managed by a fulfillment service
 *
 * For fulfillment orders which are assigned to a location that is managed by a fulfillment service,
 * a merchant or an Order Management App can
 * [send a fulfillment request](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderSubmitFulfillmentRequest)
 * to the fulfillment service which operates the location to request that they fulfill the associated items.
 * A fulfillment service has the option to
 * [accept](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderAcceptFulfillmentRequest)
 * or [reject](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderRejectFulfillmentRequest)
 * this fulfillment request.
 *
 * Once the fulfillment service has accepted the request, the request can no longer be cancelled by the merchant
 * or order management app and instead a
 * [cancellation request must be submitted](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderSubmitCancellationRequest)
 * to the fulfillment service.
 *
 * Once a fulfillment service accepts a fulfillment request,
 * then after they are ready to pack items and send them for delivery, they create fulfillments with the
 * [fulfillmentCreateV2](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentCreateV2)
 * mutation.
 * They can provide tracking information right away or create fulfillments without it and then
 * update the tracking information for fulfillments with the
 * [fulfillmentTrackingInfoUpdateV2](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentTrackingInfoUpdateV2)
 * mutation.
 *
 * [Learn about managing fulfillment orders as a fulfillment service](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments).
 *
 * ## API access scopes
 *
 * Fulfillment orders are governed by the following API access scopes:
 *
 * * The `read_merchant_managed_fulfillment_orders` and
 *   `write_merchant_managed_fulfillment_orders` access scopes
 *   grant access to fulfillment orders assigned to merchant-managed locations.
 * * The `read_assigned_fulfillment_orders` and `write_assigned_fulfillment_orders`
 *   access scopes are intended for fulfillment services.
 *   These scopes grant access to fulfillment orders assigned to locations that are being managed
 *   by fulfillment services.
 * * The `read_third_party_fulfillment_orders` and `write_third_party_fulfillment_orders`
 *   access scopes grant access to fulfillment orders
 *   assigned to locations managed by other fulfillment services.
 *
 * ### Fulfillment service app access scopes
 *
 * Usually, **fulfillment services** have the `write_assigned_fulfillment_orders` access scope
 * and don't have the `*_third_party_fulfillment_orders`
 * or `*_merchant_managed_fulfillment_orders` access scopes.
 * The app will only have access to the fulfillment orders assigned to their location
 * (or multiple locations if the app registers multiple fulfillment services on the shop).
 * The app will not have access to fulfillment orders assigned to merchant-managed locations
 * or locations owned by other fulfillment service apps.
 *
 * ### Order management app access scopes
 *
 * **Order management apps** will usually request `write_merchant_managed_fulfillment_orders` and
 * `write_third_party_fulfillment_orders` access scopes. This will allow them to manage all fulfillment orders
 * on behalf of a merchant.
 *
 * If an app combines the functions of an order management app and a fulfillment service,
 * then the app should request all
 * access scopes to manage all assigned and all unassigned fulfillment orders.
 *
 * ## Notifications about fulfillment orders
 *
 * Fulfillment services are required to
 * [register](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentService)
 * a self-hosted callback URL which has a number of uses. One of these uses is that this callback URL will be notified
 * whenever a merchant submits a fulfillment or cancellation request.
 *
 * Both merchants and apps can
 * [subscribe](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments#webhooks)
 * to the
 * [fulfillment order webhooks](https://shopify.dev/api/admin-graphql/latest/enums/WebhookSubscriptionTopic#value-fulfillmentorderscancellationrequestaccepted)
 * to be notified whenever fulfillment order related domain events occur.
 *
 * [Learn about fulfillment workflows](https://shopify.dev/apps/fulfillment).
 *
 */
export type FulfillmentOrderLineItemsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * The FulfillmentOrder object represents either an item or a group of items in an
 * [Order](https://shopify.dev/api/admin-graphql/latest/objects/Order)
 * that are expected to be fulfilled from the same location.
 * There can be more than one fulfillment order for an
 * [order](https://shopify.dev/api/admin-graphql/latest/objects/Order)
 * at a given location.
 *
 * {{ '/api/reference/fulfillment_order_relationships.png' | image }}
 *
 * Fulfillment orders represent the work which is intended to be done in relation to an order.
 * When fulfillment has started for one or more line items, a
 * [Fulfillment](https://shopify.dev/api/admin-graphql/latest/objects/Fulfillment)
 * is created by a merchant or third party to represent the ongoing or completed work of fulfillment.
 *
 * [See below for more details on creating fulfillments](#the-lifecycle-of-a-fulfillment-order-at-a-location-which-is-managed-by-a-fulfillment-service).
 *
 * > Note:
 * > Shopify creates fulfillment orders automatically when an order is created.
 * > It is not possible to manually create fulfillment orders.
 * >
 * > [See below for more details on the lifecycle of a fulfillment order](#the-lifecycle-of-a-fulfillment-order).
 *
 * ## Retrieving fulfillment orders
 *
 * ### Fulfillment orders from an order
 *
 * All fulfillment orders related to a given order can be retrieved with the
 * [Order.fulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/objects/Order#connection-order-fulfillmentorders)
 * connection.
 *
 * [API access scopes](#api-access-scopes)
 * govern which fulfillments orders are returned to clients.
 * An API client will only receive a subset of the fulfillment orders which belong to an order
 * if they don't have the necessary access scopes to view all of the fulfillment orders.
 *
 * ### Fulfillment orders assigned to the app for fulfillment
 *
 * Fulfillment service apps can retrieve the fulfillment orders which have been assigned to their locations with the
 * [Shop.assignedFulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/objects/Shop#connection-shop-assignedfulfillmentorders)
 * connection.
 * Use the `assignmentStatus` argument to control whether all assigned fulfillment orders
 * should be returned or only those where a merchant has sent a
 * [fulfillment request](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentOrderMerchantRequest)
 * and it has yet to be responded to.
 *
 * The API client must be granted the `read_assigned_fulfillment_orders` access scope to access
 * the assigned fulfillment orders.
 *
 * ### All fulfillment orders
 *
 * Apps can retrieve all fulfillment orders with the
 * [fulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/queries/fulfillmentOrders)
 * query. This query returns all assigned, merchant-managed, and third-party fulfillment orders on the shop,
 * which are accessible to the app according to the
 * [fulfillment order access scopes](#api-access-scopes) it was granted with.
 *
 * ## The lifecycle of a fulfillment order
 *
 * ### Fulfillment Order Creation
 *
 * After an order is created, a background worker performs the order routing process which determines
 * which locations will be responsible for fulfilling the purchased items.
 * Once the order routing process is complete, one or more fulfillment orders will be created
 * and assigned to these locations. It is not possible to manually create fulfillment orders.
 *
 * Once a fulfillment order has been created, it will have one of two different lifecycles depending on
 * the type of location which the fulfillment order is assigned to.
 *
 * ### The lifecycle of a fulfillment order at a merchant managed location
 *
 * Fulfillment orders are completed by creating
 * [fulfillments](https://shopify.dev/api/admin-graphql/latest/objects/Fulfillment).
 * Fulfillments represents the work done.
 *
 * For digital products a merchant or an order management app would create a fulfilment once the digital asset
 * has been provisioned.
 * For example, in the case of a digital gift card, a merchant would to do this once
 * the gift card has been activated - before the email has been shipped.
 *
 * On the other hand, for a traditional shipped order,
 * a merchant or an order management app would create a fulfillment after picking and packing the items relating
 * to a fulfillment order, but before the courier has collected the goods.
 *
 * [Learn about managing fulfillment orders as an order management app](https://shopify.dev/apps/fulfillment/order-management-apps/manage-fulfillments).
 *
 * ### The lifecycle of a fulfillment order at a location which is managed by a fulfillment service
 *
 * For fulfillment orders which are assigned to a location that is managed by a fulfillment service,
 * a merchant or an Order Management App can
 * [send a fulfillment request](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderSubmitFulfillmentRequest)
 * to the fulfillment service which operates the location to request that they fulfill the associated items.
 * A fulfillment service has the option to
 * [accept](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderAcceptFulfillmentRequest)
 * or [reject](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderRejectFulfillmentRequest)
 * this fulfillment request.
 *
 * Once the fulfillment service has accepted the request, the request can no longer be cancelled by the merchant
 * or order management app and instead a
 * [cancellation request must be submitted](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderSubmitCancellationRequest)
 * to the fulfillment service.
 *
 * Once a fulfillment service accepts a fulfillment request,
 * then after they are ready to pack items and send them for delivery, they create fulfillments with the
 * [fulfillmentCreateV2](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentCreateV2)
 * mutation.
 * They can provide tracking information right away or create fulfillments without it and then
 * update the tracking information for fulfillments with the
 * [fulfillmentTrackingInfoUpdateV2](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentTrackingInfoUpdateV2)
 * mutation.
 *
 * [Learn about managing fulfillment orders as a fulfillment service](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments).
 *
 * ## API access scopes
 *
 * Fulfillment orders are governed by the following API access scopes:
 *
 * * The `read_merchant_managed_fulfillment_orders` and
 *   `write_merchant_managed_fulfillment_orders` access scopes
 *   grant access to fulfillment orders assigned to merchant-managed locations.
 * * The `read_assigned_fulfillment_orders` and `write_assigned_fulfillment_orders`
 *   access scopes are intended for fulfillment services.
 *   These scopes grant access to fulfillment orders assigned to locations that are being managed
 *   by fulfillment services.
 * * The `read_third_party_fulfillment_orders` and `write_third_party_fulfillment_orders`
 *   access scopes grant access to fulfillment orders
 *   assigned to locations managed by other fulfillment services.
 *
 * ### Fulfillment service app access scopes
 *
 * Usually, **fulfillment services** have the `write_assigned_fulfillment_orders` access scope
 * and don't have the `*_third_party_fulfillment_orders`
 * or `*_merchant_managed_fulfillment_orders` access scopes.
 * The app will only have access to the fulfillment orders assigned to their location
 * (or multiple locations if the app registers multiple fulfillment services on the shop).
 * The app will not have access to fulfillment orders assigned to merchant-managed locations
 * or locations owned by other fulfillment service apps.
 *
 * ### Order management app access scopes
 *
 * **Order management apps** will usually request `write_merchant_managed_fulfillment_orders` and
 * `write_third_party_fulfillment_orders` access scopes. This will allow them to manage all fulfillment orders
 * on behalf of a merchant.
 *
 * If an app combines the functions of an order management app and a fulfillment service,
 * then the app should request all
 * access scopes to manage all assigned and all unassigned fulfillment orders.
 *
 * ## Notifications about fulfillment orders
 *
 * Fulfillment services are required to
 * [register](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentService)
 * a self-hosted callback URL which has a number of uses. One of these uses is that this callback URL will be notified
 * whenever a merchant submits a fulfillment or cancellation request.
 *
 * Both merchants and apps can
 * [subscribe](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments#webhooks)
 * to the
 * [fulfillment order webhooks](https://shopify.dev/api/admin-graphql/latest/enums/WebhookSubscriptionTopic#value-fulfillmentorderscancellationrequestaccepted)
 * to be notified whenever fulfillment order related domain events occur.
 *
 * [Learn about fulfillment workflows](https://shopify.dev/apps/fulfillment).
 *
 */
export type FulfillmentOrderLocationsForMoveArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  lineItemIds?: InputMaybe<Array<Scalars["ID"]["input"]>>
  locationIds?: InputMaybe<Array<Scalars["ID"]["input"]>>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * The FulfillmentOrder object represents either an item or a group of items in an
 * [Order](https://shopify.dev/api/admin-graphql/latest/objects/Order)
 * that are expected to be fulfilled from the same location.
 * There can be more than one fulfillment order for an
 * [order](https://shopify.dev/api/admin-graphql/latest/objects/Order)
 * at a given location.
 *
 * {{ '/api/reference/fulfillment_order_relationships.png' | image }}
 *
 * Fulfillment orders represent the work which is intended to be done in relation to an order.
 * When fulfillment has started for one or more line items, a
 * [Fulfillment](https://shopify.dev/api/admin-graphql/latest/objects/Fulfillment)
 * is created by a merchant or third party to represent the ongoing or completed work of fulfillment.
 *
 * [See below for more details on creating fulfillments](#the-lifecycle-of-a-fulfillment-order-at-a-location-which-is-managed-by-a-fulfillment-service).
 *
 * > Note:
 * > Shopify creates fulfillment orders automatically when an order is created.
 * > It is not possible to manually create fulfillment orders.
 * >
 * > [See below for more details on the lifecycle of a fulfillment order](#the-lifecycle-of-a-fulfillment-order).
 *
 * ## Retrieving fulfillment orders
 *
 * ### Fulfillment orders from an order
 *
 * All fulfillment orders related to a given order can be retrieved with the
 * [Order.fulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/objects/Order#connection-order-fulfillmentorders)
 * connection.
 *
 * [API access scopes](#api-access-scopes)
 * govern which fulfillments orders are returned to clients.
 * An API client will only receive a subset of the fulfillment orders which belong to an order
 * if they don't have the necessary access scopes to view all of the fulfillment orders.
 *
 * ### Fulfillment orders assigned to the app for fulfillment
 *
 * Fulfillment service apps can retrieve the fulfillment orders which have been assigned to their locations with the
 * [Shop.assignedFulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/objects/Shop#connection-shop-assignedfulfillmentorders)
 * connection.
 * Use the `assignmentStatus` argument to control whether all assigned fulfillment orders
 * should be returned or only those where a merchant has sent a
 * [fulfillment request](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentOrderMerchantRequest)
 * and it has yet to be responded to.
 *
 * The API client must be granted the `read_assigned_fulfillment_orders` access scope to access
 * the assigned fulfillment orders.
 *
 * ### All fulfillment orders
 *
 * Apps can retrieve all fulfillment orders with the
 * [fulfillmentOrders](https://shopify.dev/api/admin-graphql/latest/queries/fulfillmentOrders)
 * query. This query returns all assigned, merchant-managed, and third-party fulfillment orders on the shop,
 * which are accessible to the app according to the
 * [fulfillment order access scopes](#api-access-scopes) it was granted with.
 *
 * ## The lifecycle of a fulfillment order
 *
 * ### Fulfillment Order Creation
 *
 * After an order is created, a background worker performs the order routing process which determines
 * which locations will be responsible for fulfilling the purchased items.
 * Once the order routing process is complete, one or more fulfillment orders will be created
 * and assigned to these locations. It is not possible to manually create fulfillment orders.
 *
 * Once a fulfillment order has been created, it will have one of two different lifecycles depending on
 * the type of location which the fulfillment order is assigned to.
 *
 * ### The lifecycle of a fulfillment order at a merchant managed location
 *
 * Fulfillment orders are completed by creating
 * [fulfillments](https://shopify.dev/api/admin-graphql/latest/objects/Fulfillment).
 * Fulfillments represents the work done.
 *
 * For digital products a merchant or an order management app would create a fulfilment once the digital asset
 * has been provisioned.
 * For example, in the case of a digital gift card, a merchant would to do this once
 * the gift card has been activated - before the email has been shipped.
 *
 * On the other hand, for a traditional shipped order,
 * a merchant or an order management app would create a fulfillment after picking and packing the items relating
 * to a fulfillment order, but before the courier has collected the goods.
 *
 * [Learn about managing fulfillment orders as an order management app](https://shopify.dev/apps/fulfillment/order-management-apps/manage-fulfillments).
 *
 * ### The lifecycle of a fulfillment order at a location which is managed by a fulfillment service
 *
 * For fulfillment orders which are assigned to a location that is managed by a fulfillment service,
 * a merchant or an Order Management App can
 * [send a fulfillment request](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderSubmitFulfillmentRequest)
 * to the fulfillment service which operates the location to request that they fulfill the associated items.
 * A fulfillment service has the option to
 * [accept](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderAcceptFulfillmentRequest)
 * or [reject](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderRejectFulfillmentRequest)
 * this fulfillment request.
 *
 * Once the fulfillment service has accepted the request, the request can no longer be cancelled by the merchant
 * or order management app and instead a
 * [cancellation request must be submitted](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderSubmitCancellationRequest)
 * to the fulfillment service.
 *
 * Once a fulfillment service accepts a fulfillment request,
 * then after they are ready to pack items and send them for delivery, they create fulfillments with the
 * [fulfillmentCreateV2](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentCreateV2)
 * mutation.
 * They can provide tracking information right away or create fulfillments without it and then
 * update the tracking information for fulfillments with the
 * [fulfillmentTrackingInfoUpdateV2](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentTrackingInfoUpdateV2)
 * mutation.
 *
 * [Learn about managing fulfillment orders as a fulfillment service](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments).
 *
 * ## API access scopes
 *
 * Fulfillment orders are governed by the following API access scopes:
 *
 * * The `read_merchant_managed_fulfillment_orders` and
 *   `write_merchant_managed_fulfillment_orders` access scopes
 *   grant access to fulfillment orders assigned to merchant-managed locations.
 * * The `read_assigned_fulfillment_orders` and `write_assigned_fulfillment_orders`
 *   access scopes are intended for fulfillment services.
 *   These scopes grant access to fulfillment orders assigned to locations that are being managed
 *   by fulfillment services.
 * * The `read_third_party_fulfillment_orders` and `write_third_party_fulfillment_orders`
 *   access scopes grant access to fulfillment orders
 *   assigned to locations managed by other fulfillment services.
 *
 * ### Fulfillment service app access scopes
 *
 * Usually, **fulfillment services** have the `write_assigned_fulfillment_orders` access scope
 * and don't have the `*_third_party_fulfillment_orders`
 * or `*_merchant_managed_fulfillment_orders` access scopes.
 * The app will only have access to the fulfillment orders assigned to their location
 * (or multiple locations if the app registers multiple fulfillment services on the shop).
 * The app will not have access to fulfillment orders assigned to merchant-managed locations
 * or locations owned by other fulfillment service apps.
 *
 * ### Order management app access scopes
 *
 * **Order management apps** will usually request `write_merchant_managed_fulfillment_orders` and
 * `write_third_party_fulfillment_orders` access scopes. This will allow them to manage all fulfillment orders
 * on behalf of a merchant.
 *
 * If an app combines the functions of an order management app and a fulfillment service,
 * then the app should request all
 * access scopes to manage all assigned and all unassigned fulfillment orders.
 *
 * ## Notifications about fulfillment orders
 *
 * Fulfillment services are required to
 * [register](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentService)
 * a self-hosted callback URL which has a number of uses. One of these uses is that this callback URL will be notified
 * whenever a merchant submits a fulfillment or cancellation request.
 *
 * Both merchants and apps can
 * [subscribe](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments#webhooks)
 * to the
 * [fulfillment order webhooks](https://shopify.dev/api/admin-graphql/latest/enums/WebhookSubscriptionTopic#value-fulfillmentorderscancellationrequestaccepted)
 * to be notified whenever fulfillment order related domain events occur.
 *
 * [Learn about fulfillment workflows](https://shopify.dev/apps/fulfillment).
 *
 */
export type FulfillmentOrderMerchantRequestsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  kind?: InputMaybe<FulfillmentOrderMerchantRequestKind>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Return type for `fulfillmentOrderAcceptCancellationRequest` mutation. */
export type FulfillmentOrderAcceptCancellationRequestPayload = {
  __typename?: "FulfillmentOrderAcceptCancellationRequestPayload"
  /** The fulfillment order whose cancellation request was accepted. */
  fulfillmentOrder?: Maybe<FulfillmentOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `fulfillmentOrderAcceptFulfillmentRequest` mutation. */
export type FulfillmentOrderAcceptFulfillmentRequestPayload = {
  __typename?: "FulfillmentOrderAcceptFulfillmentRequestPayload"
  /** The fulfillment order whose fulfillment request was accepted. */
  fulfillmentOrder?: Maybe<FulfillmentOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The actions that can be taken on a fulfillment order. */
export enum FulfillmentOrderAction {
  /** Cancels a fulfillment order. The corresponding mutation for this action is `fulfillmentOrderCancel`. */
  CancelFulfillmentOrder = "CANCEL_FULFILLMENT_ORDER",
  /** Creates a fulfillment for selected line items in the fulfillment order. The corresponding mutation for this action is `fulfillmentCreateV2`. */
  CreateFulfillment = "CREATE_FULFILLMENT",
  /** Opens an external URL to initiate the fulfillment process outside Shopify. This action should be paired with `FulfillmentOrderSupportedAction.externalUrl`. */
  External = "EXTERNAL",
  /** Applies a fulfillment hold on an open fulfillment order. The corresponding mutation for this action is `fulfillmentOrderHold`. */
  Hold = "HOLD",
  /** Marks the fulfillment order as open. The corresponding mutation for this action is `fulfillmentOrderOpen`. */
  MarkAsOpen = "MARK_AS_OPEN",
  /** Merges a fulfillment order. The corresponding mutation for this action is `fulfillmentOrderMerge`. */
  Merge = "MERGE",
  /** Moves a fulfillment order. The corresponding mutation for this action is `fulfillmentOrderMove`. */
  Move = "MOVE",
  /** Releases the fulfillment hold on the fulfillment order. The corresponding mutation for this action is `fulfillmentOrderReleaseHold`. */
  ReleaseHold = "RELEASE_HOLD",
  /** Sends a cancellation request to the fulfillment service of a fulfillment order. The corresponding mutation for this action is `fulfillmentOrderSubmitCancellationRequest`. */
  RequestCancellation = "REQUEST_CANCELLATION",
  /** Sends a request for fulfilling selected line items in a fulfillment order to a fulfillment service. The corresponding mutation for this action is `fulfillmentOrderSubmitFulfillmentRequest`. */
  RequestFulfillment = "REQUEST_FULFILLMENT",
  /** Splits a fulfillment order. The corresponding mutation for this action is `fulfillmentOrderSplit`. */
  Split = "SPLIT",
}

/**
 * The fulfillment order's assigned location. This is the location where the fulfillment is expected to happen.
 *
 *  The fulfillment order's assigned location might change in the following cases:
 *
 *   - The fulfillment order has been entirely moved to a new location. For example, the [fulfillmentOrderMove](
 *     https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderMove
 *     ) mutation has been called, and you see the original fulfillment order in the [movedFulfillmentOrder](
 *     https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderMove#field-fulfillmentordermovepayload-movedfulfillmentorder
 *     ) field within the mutation's response.
 *
 *   - Work on the fulfillment order has not yet begun, which means that the fulfillment order has the
 *       [OPEN](https://shopify.dev/api/admin-graphql/latest/enums/FulfillmentOrderStatus#value-open),
 *       [SCHEDULED](https://shopify.dev/api/admin-graphql/latest/enums/FulfillmentOrderStatus#value-scheduled), or
 *       [ON_HOLD](https://shopify.dev/api/admin-graphql/latest/enums/FulfillmentOrderStatus#value-onhold)
 *       status, and the shop's location properties might be undergoing edits (for example, in the Shopify admin).
 *
 * If the [fulfillmentOrderMove](
 * https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentOrderMove
 * ) mutation has moved the fulfillment order's line items to a new location,
 * but hasn't moved the fulfillment order instance itself, then the original fulfillment order's assigned location
 * doesn't change.
 * This happens if the fulfillment order is being split during the move, or if all line items can be moved
 * to an existing fulfillment order at a new location.
 *
 * Once the fulfillment order has been taken into work or canceled,
 * which means that the fulfillment order has the
 * [IN_PROGRESS](https://shopify.dev/api/admin-graphql/latest/enums/FulfillmentOrderStatus#value-inprogress),
 * [CLOSED](https://shopify.dev/api/admin-graphql/latest/enums/FulfillmentOrderStatus#value-closed),
 * [CANCELLED](https://shopify.dev/api/admin-graphql/latest/enums/FulfillmentOrderStatus#value-cancelled), or
 * [INCOMPLETE](https://shopify.dev/api/admin-graphql/latest/enums/FulfillmentOrderStatus#value-incomplete)
 * status, `FulfillmentOrderAssignedLocation` acts as a snapshot of the shop's location content.
 * Up-to-date shop's location data may be queried through [location](
 *   https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentOrderAssignedLocation#field-fulfillmentorderassignedlocation-location
 * ) connection.
 *
 */
export type FulfillmentOrderAssignedLocation = {
  __typename?: "FulfillmentOrderAssignedLocation"
  /** The first line of the address for the location. */
  address1?: Maybe<Scalars["String"]["output"]>
  /** The second line of the address for the location. */
  address2?: Maybe<Scalars["String"]["output"]>
  /** The city of the location. */
  city?: Maybe<Scalars["String"]["output"]>
  /** The two-letter country code of the location. */
  countryCode: CountryCode
  /**
   * The location where the fulfillment is expected to happen. This value might be different from
   * `FulfillmentOrderAssignedLocation` if the location's attributes were updated
   * after the fulfillment order was taken into work of canceled.
   *
   */
  location?: Maybe<Location>
  /** The name of the location. */
  name: Scalars["String"]["output"]
  /** The phone number of the location. */
  phone?: Maybe<Scalars["String"]["output"]>
  /** The province of the location. */
  province?: Maybe<Scalars["String"]["output"]>
  /** The ZIP code of the location. */
  zip?: Maybe<Scalars["String"]["output"]>
}

/** The assigment status to be used to filter fulfillment orders. */
export enum FulfillmentOrderAssignmentStatus {
  /**
   * Fulfillment orders for which the merchant has requested cancellation of
   * the previously accepted fulfillment request.
   *
   */
  CancellationRequested = "CANCELLATION_REQUESTED",
  /**
   * Fulfillment orders for which the merchant's fulfillment request has been accepted.
   * Any number of fulfillments can be created on these fulfillment orders
   * to completely fulfill the requested items.
   *
   */
  FulfillmentAccepted = "FULFILLMENT_ACCEPTED",
  /**
   * Fulfillment orders for which the merchant has requested fulfillment.
   *
   */
  FulfillmentRequested = "FULFILLMENT_REQUESTED",
}

/** Return type for `fulfillmentOrderCancel` mutation. */
export type FulfillmentOrderCancelPayload = {
  __typename?: "FulfillmentOrderCancelPayload"
  /** The fulfillment order that was marked as canceled. */
  fulfillmentOrder?: Maybe<FulfillmentOrder>
  /** The fulfillment order that was created to replace the canceled fulfillment order. */
  replacementFulfillmentOrder?: Maybe<FulfillmentOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `fulfillmentOrderClose` mutation. */
export type FulfillmentOrderClosePayload = {
  __typename?: "FulfillmentOrderClosePayload"
  /** The fulfillment order that was marked as incomplete. */
  fulfillmentOrder?: Maybe<FulfillmentOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * An auto-generated type for paginating through multiple FulfillmentOrders.
 *
 */
export type FulfillmentOrderConnection = {
  __typename?: "FulfillmentOrderConnection"
  /** A list of edges. */
  edges: Array<FulfillmentOrderEdge>
  /** A list of the nodes contained in FulfillmentOrderEdge. */
  nodes: Array<FulfillmentOrder>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * Represents the destination where the items should be sent upon fulfillment.
 *
 */
export type FulfillmentOrderDestination = Node & {
  __typename?: "FulfillmentOrderDestination"
  /** The first line of the address of the destination. */
  address1?: Maybe<Scalars["String"]["output"]>
  /** The second line of the address of the destination. */
  address2?: Maybe<Scalars["String"]["output"]>
  /** The city of the destination. */
  city?: Maybe<Scalars["String"]["output"]>
  /** The company of the destination. */
  company?: Maybe<Scalars["String"]["output"]>
  /** The two-letter country code of the destination. */
  countryCode?: Maybe<CountryCode>
  /** The email of the customer at the destination. */
  email?: Maybe<Scalars["String"]["output"]>
  /** The first name of the customer at the destination. */
  firstName?: Maybe<Scalars["String"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The last name of the customer at the destination. */
  lastName?: Maybe<Scalars["String"]["output"]>
  /** The phone number of the customer at the destination. */
  phone?: Maybe<Scalars["String"]["output"]>
  /** The province of the destination. */
  province?: Maybe<Scalars["String"]["output"]>
  /** The ZIP code of the destination. */
  zip?: Maybe<Scalars["String"]["output"]>
}

/**
 * An auto-generated type which holds one FulfillmentOrder and a cursor during pagination.
 *
 */
export type FulfillmentOrderEdge = {
  __typename?: "FulfillmentOrderEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of FulfillmentOrderEdge. */
  node: FulfillmentOrder
}

/** The input fields for the fulfillment hold applied on the fulfillment order. */
export type FulfillmentOrderHoldInput = {
  /** A configurable ID used to track the automation system releasing these holds. */
  externalId?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The fulfillment order line items to be placed on hold.
   * If left blank, all line items of the fulfillment order are placed on hold.
   *
   */
  fulfillmentOrderLineItems?: InputMaybe<Array<FulfillmentOrderLineItemInput>>
  /** Whether the merchant receives a notification about the fulfillment hold. The default value is `false`. */
  notifyMerchant?: InputMaybe<Scalars["Boolean"]["input"]>
  /** The reason for the fulfillment hold. */
  reason: FulfillmentHoldReason
  /** Additional information about the fulfillment hold reason. */
  reasonNotes?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `fulfillmentOrderHold` mutation. */
export type FulfillmentOrderHoldPayload = {
  __typename?: "FulfillmentOrderHoldPayload"
  /** The fulfillment order on which a fulfillment hold was applied. */
  fulfillmentOrder?: Maybe<FulfillmentOrder>
  /**
   * The remaining fulfillment order containing the line items to which the hold wasn't applied,
   * if specific line items were specified to be placed on hold.
   *
   */
  remainingFulfillmentOrder?: Maybe<FulfillmentOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<FulfillmentOrderHoldUserError>
}

/** An error that occurs during the execution of `FulfillmentOrderHold`. */
export type FulfillmentOrderHoldUserError = DisplayableError & {
  __typename?: "FulfillmentOrderHoldUserError"
  /** The error code. */
  code?: Maybe<FulfillmentOrderHoldUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `FulfillmentOrderHoldUserError`. */
export enum FulfillmentOrderHoldUserErrorCode {
  /** The fulfillment order could not be found. */
  FulfillmentOrderNotFound = "FULFILLMENT_ORDER_NOT_FOUND",
  /** The fulfillment order line item quantity must be greater than 0. */
  GreaterThanZero = "GREATER_THAN_ZERO",
  /** The fulfillment order line item quantity is invalid. */
  InvalidLineItemQuantity = "INVALID_LINE_ITEM_QUANTITY",
  /** The input value is already taken. */
  Taken = "TAKEN",
}

/**
 * The international duties relevant to a fulfillment order.
 *
 */
export type FulfillmentOrderInternationalDuties = {
  __typename?: "FulfillmentOrderInternationalDuties"
  /** The method of duties payment. Example values: `DDP`, `DAP`. */
  incoterm: Scalars["String"]["output"]
}

/**
 * Associates an order line item with quantities requiring fulfillment from the respective fulfillment order.
 *
 */
export type FulfillmentOrderLineItem = Node & {
  __typename?: "FulfillmentOrderLineItem"
  /** The financial summary for the Fulfillment Order's Line Items. */
  financialSummaries: Array<FulfillmentOrderLineItemFinancialSummary>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The image associated to the line item's variant. */
  image?: Maybe<Image>
  /** The ID of the inventory item. */
  inventoryItemId?: Maybe<Scalars["ID"]["output"]>
  /**
   * The associated order line item.
   * @deprecated           As of API version 2023-01, this field has been deprecated. The order line item associated with a `FulfillmentOrderLineItem`
   *           shouldn't be used to determine what to fulfill. Use the `FulfillmentOrderLineItem` and `FulfillmentOrder` objects
   *           instead. An order `LineItem` represents a single line item on an order, but it doesn't represent what should be fulfilled.
   *
   */
  lineItem: LineItem
  /**
   * The variant unit price without discounts applied, in shop and presentment currencies.
   * @deprecated Use `financialSummaries` instead.
   */
  originalUnitPriceSet: MoneyBag
  /** The title of the product. */
  productTitle: Scalars["String"]["output"]
  /** The number of units remaining to be fulfilled. */
  remainingQuantity: Scalars["Int"]["output"]
  /** Whether physical shipping is required for the variant. */
  requiresShipping: Scalars["Boolean"]["output"]
  /** The variant SKU number. */
  sku?: Maybe<Scalars["String"]["output"]>
  /** The total number of units to be fulfilled. */
  totalQuantity: Scalars["Int"]["output"]
  /** The name of the variant. */
  variantTitle?: Maybe<Scalars["String"]["output"]>
  /** The name of the vendor who made the variant. */
  vendor?: Maybe<Scalars["String"]["output"]>
  /** Warning messages for a fulfillment order line item. */
  warnings: Array<FulfillmentOrderLineItemWarning>
  /** The weight of a line item unit. */
  weight?: Maybe<Weight>
}

/**
 * An auto-generated type for paginating through multiple FulfillmentOrderLineItems.
 *
 */
export type FulfillmentOrderLineItemConnection = {
  __typename?: "FulfillmentOrderLineItemConnection"
  /** A list of edges. */
  edges: Array<FulfillmentOrderLineItemEdge>
  /** A list of the nodes contained in FulfillmentOrderLineItemEdge. */
  nodes: Array<FulfillmentOrderLineItem>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one FulfillmentOrderLineItem and a cursor during pagination.
 *
 */
export type FulfillmentOrderLineItemEdge = {
  __typename?: "FulfillmentOrderLineItemEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of FulfillmentOrderLineItemEdge. */
  node: FulfillmentOrderLineItem
}

/**
 * The financial details of a fulfillment order line item.
 *
 */
export type FulfillmentOrderLineItemFinancialSummary = {
  __typename?: "FulfillmentOrderLineItemFinancialSummary"
  /** The approximate split price of a line item unit, in shop and presentment currencies. This value doesn't include discounts applied to the entire order.For the full picture of applied discounts, see discountAllocations. */
  approximateDiscountedUnitPriceSet: MoneyBag
  /** The discounts that have been allocated onto the line item by discount applications, not including order edits and refunds. */
  discountAllocations: Array<FinancialSummaryDiscountAllocation>
  /** The variant unit price without discounts applied, in shop and presentment currencies. */
  originalUnitPriceSet: MoneyBag
  /** Number of line items that this financial summary applies to. */
  quantity: Scalars["Int"]["output"]
}

/**
 * The input fields used to include the quantity of the fulfillment order line item that should be fulfilled.
 *
 */
export type FulfillmentOrderLineItemInput = {
  /** The ID of the fulfillment order line item. */
  id: Scalars["ID"]["input"]
  /** The quantity of the fulfillment order line item. */
  quantity: Scalars["Int"]["input"]
}

/**
 * A fulfillment order line item warning. For example, a warning about why a fulfillment request was rejected.
 *
 */
export type FulfillmentOrderLineItemWarning = {
  __typename?: "FulfillmentOrderLineItemWarning"
  /** The description of warning. */
  description?: Maybe<Scalars["String"]["output"]>
  /** The title of warning. */
  title?: Maybe<Scalars["String"]["output"]>
}

/**
 * The input fields used to include the line items of a specified fulfillment order that should be fulfilled.
 *
 */
export type FulfillmentOrderLineItemsInput = {
  /** The ID of the fulfillment order. */
  fulfillmentOrderId: Scalars["ID"]["input"]
  /**
   * The fulfillment order line items to be fulfilled.
   * If left blank, all line items of the fulfillment order will be fulfilled.
   *
   */
  fulfillmentOrderLineItems?: InputMaybe<Array<FulfillmentOrderLineItemInput>>
}

/** The input fields for marking fulfillment order line items as ready for pickup. */
export type FulfillmentOrderLineItemsPreparedForPickupInput = {
  /**
   * The fulfillment orders associated with the line items which are ready to be picked up by a customer.
   *
   */
  lineItemsByFulfillmentOrder: Array<PreparedFulfillmentOrderLineItemsInput>
}

/** Return type for `fulfillmentOrderLineItemsPreparedForPickup` mutation. */
export type FulfillmentOrderLineItemsPreparedForPickupPayload = {
  __typename?: "FulfillmentOrderLineItemsPreparedForPickupPayload"
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<FulfillmentOrderLineItemsPreparedForPickupUserError>
}

/** An error that occurs during the execution of `FulfillmentOrderLineItemsPreparedForPickup`. */
export type FulfillmentOrderLineItemsPreparedForPickupUserError = DisplayableError & {
  __typename?: "FulfillmentOrderLineItemsPreparedForPickupUserError"
  /** The error code. */
  code?: Maybe<FulfillmentOrderLineItemsPreparedForPickupUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `FulfillmentOrderLineItemsPreparedForPickupUserError`. */
export enum FulfillmentOrderLineItemsPreparedForPickupUserErrorCode {
  /** Invalid fulfillment order ID provided. */
  FulfillmentOrderInvalid = "FULFILLMENT_ORDER_INVALID",
  /** The fulfillment order does not have any line items that can be prepared. */
  NoLineItemsToPrepareForFulfillmentOrder = "NO_LINE_ITEMS_TO_PREPARE_FOR_FULFILLMENT_ORDER",
  /** Unable to prepare quantity. */
  UnableToPrepareQuantity = "UNABLE_TO_PREPARE_QUANTITY",
}

/**
 * A location that a fulfillment order can potentially move to.
 *
 */
export type FulfillmentOrderLocationForMove = {
  __typename?: "FulfillmentOrderLocationForMove"
  /**
   * Fulfillment order line items that can be moved from their current location to the given location.
   *
   */
  availableLineItems: FulfillmentOrderLineItemConnection
  /**
   * Total number of fulfillment order line items that can be moved from their current assigned location to the
   * given location.
   *
   */
  availableLineItemsCount: Scalars["UnsignedInt64"]["output"]
  /** The location being considered as the fulfillment order's new assigned location. */
  location: Location
  /**
   * A human-readable string with the reason why the fulfillment order, or some of its line items, can't be
   * moved to the location.
   *
   */
  message?: Maybe<Scalars["String"]["output"]>
  /** Whether the fulfillment order can be moved to the location. */
  movable: Scalars["Boolean"]["output"]
  /**
   * Fulfillment order line items that cannot be moved from their current location to the given location.
   *
   */
  unavailableLineItems: FulfillmentOrderLineItemConnection
  /**
   * Total number of fulfillment order line items that can't be moved from their current assigned location to the
   * given location.
   *
   */
  unavailableLineItemsCount: Scalars["UnsignedInt64"]["output"]
}

/**
 * A location that a fulfillment order can potentially move to.
 *
 */
export type FulfillmentOrderLocationForMoveAvailableLineItemsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * A location that a fulfillment order can potentially move to.
 *
 */
export type FulfillmentOrderLocationForMoveUnavailableLineItemsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple FulfillmentOrderLocationForMoves.
 *
 */
export type FulfillmentOrderLocationForMoveConnection = {
  __typename?: "FulfillmentOrderLocationForMoveConnection"
  /** A list of edges. */
  edges: Array<FulfillmentOrderLocationForMoveEdge>
  /** A list of the nodes contained in FulfillmentOrderLocationForMoveEdge. */
  nodes: Array<FulfillmentOrderLocationForMove>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one FulfillmentOrderLocationForMove and a cursor during pagination.
 *
 */
export type FulfillmentOrderLocationForMoveEdge = {
  __typename?: "FulfillmentOrderLocationForMoveEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of FulfillmentOrderLocationForMoveEdge. */
  node: FulfillmentOrderLocationForMove
}

/**
 * A request made by the merchant or an order management app to a fulfillment service
 * for a fulfillment order.
 *
 */
export type FulfillmentOrderMerchantRequest = Node & {
  __typename?: "FulfillmentOrderMerchantRequest"
  /** The fulfillment order associated with the merchant request. */
  fulfillmentOrder: FulfillmentOrder
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The kind of request made. */
  kind: FulfillmentOrderMerchantRequestKind
  /** The optional message that the merchant included in the request. */
  message?: Maybe<Scalars["String"]["output"]>
  /**
   * Additional options requested by the merchant. These depend on the `kind` of the request.
   * For example, for a `FULFILLMENT_REQUEST`, one option is `notify_customer`, which indicates whether the
   * merchant intends to notify the customer upon fulfillment. The fulfillment service can then set
   * `notifyCustomer` when making calls to `FulfillmentCreateV2`.
   *
   */
  requestOptions?: Maybe<Scalars["JSON"]["output"]>
  /** The response from the fulfillment service. */
  responseData?: Maybe<Scalars["JSON"]["output"]>
  /** The timestamp when the request was made. */
  sentAt: Scalars["DateTime"]["output"]
}

/**
 * An auto-generated type for paginating through multiple FulfillmentOrderMerchantRequests.
 *
 */
export type FulfillmentOrderMerchantRequestConnection = {
  __typename?: "FulfillmentOrderMerchantRequestConnection"
  /** A list of edges. */
  edges: Array<FulfillmentOrderMerchantRequestEdge>
  /** A list of the nodes contained in FulfillmentOrderMerchantRequestEdge. */
  nodes: Array<FulfillmentOrderMerchantRequest>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one FulfillmentOrderMerchantRequest and a cursor during pagination.
 *
 */
export type FulfillmentOrderMerchantRequestEdge = {
  __typename?: "FulfillmentOrderMerchantRequestEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of FulfillmentOrderMerchantRequestEdge. */
  node: FulfillmentOrderMerchantRequest
}

/** The kinds of request merchants can make to a fulfillment service. */
export enum FulfillmentOrderMerchantRequestKind {
  /**
   * The merchant requests cancellation of an `IN_PROGRESS` fulfillment order.
   *
   */
  CancellationRequest = "CANCELLATION_REQUEST",
  /**
   * The merchant requests fulfillment for an `OPEN` fulfillment order.
   *
   */
  FulfillmentRequest = "FULFILLMENT_REQUEST",
}

/** The input fields for merging fulfillment orders. */
export type FulfillmentOrderMergeInput = {
  /** The details of the fulfillment orders to be merged. */
  mergeIntents: Array<FulfillmentOrderMergeInputMergeIntent>
}

/** The input fields for merging fulfillment orders into a single merged fulfillment order. */
export type FulfillmentOrderMergeInputMergeIntent = {
  /** The ID of the fulfillment order to be merged. */
  fulfillmentOrderId: Scalars["ID"]["input"]
  /**
   * The fulfillment order line items to be merged.
   *
   */
  fulfillmentOrderLineItems?: InputMaybe<Array<FulfillmentOrderLineItemInput>>
}

/** Return type for `fulfillmentOrderMerge` mutation. */
export type FulfillmentOrderMergePayload = {
  __typename?: "FulfillmentOrderMergePayload"
  /** The result of the fulfillment order merges. */
  fulfillmentOrderMerges?: Maybe<Array<FulfillmentOrderMergeResult>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<FulfillmentOrderMergeUserError>
}

/** The result of merging a set of fulfillment orders. */
export type FulfillmentOrderMergeResult = {
  __typename?: "FulfillmentOrderMergeResult"
  /** The new fulfillment order as a result of the merge. */
  fulfillmentOrder: FulfillmentOrder
}

/** An error that occurs during the execution of `FulfillmentOrderMerge`. */
export type FulfillmentOrderMergeUserError = DisplayableError & {
  __typename?: "FulfillmentOrderMergeUserError"
  /** The error code. */
  code?: Maybe<FulfillmentOrderMergeUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `FulfillmentOrderMergeUserError`. */
export enum FulfillmentOrderMergeUserErrorCode {
  /** The fulfillment order could not be found. */
  FulfillmentOrderNotFound = "FULFILLMENT_ORDER_NOT_FOUND",
  /** The fulfillment order line item quantity must be greater than 0. */
  GreaterThan = "GREATER_THAN",
  /** The fulfillment order line item quantity is invalid. */
  InvalidLineItemQuantity = "INVALID_LINE_ITEM_QUANTITY",
}

/** Return type for `fulfillmentOrderMove` mutation. */
export type FulfillmentOrderMovePayload = {
  __typename?: "FulfillmentOrderMovePayload"
  /**
   * The fulfillment order which now contains the moved line items and is assigned to the destination location.
   *
   * **First scenario:** All line items belonging to the original fulfillment order are re-assigned.
   *
   * In this case, this will be the original fulfillment order.
   *
   * **Second scenario:** A subset of the line items belonging to the original fulfillment order are re-assigned.
   *
   * If the new location is already assigned to fulfill line items on the order, then
   * this will be an existing active fulfillment order.
   * Otherwise, this will be a new fulfillment order with the moved line items assigned.
   *
   */
  movedFulfillmentOrder?: Maybe<FulfillmentOrder>
  /**
   * The final state of the original fulfillment order.
   *
   * As a result of the move operation, the original fulfillment order might be moved to the new location
   * or remain in the original location. The original fulfillment order might have the same status or be closed.
   *
   */
  originalFulfillmentOrder?: Maybe<FulfillmentOrder>
  /**
   * This field is deprecated.
   *
   */
  remainingFulfillmentOrder?: Maybe<FulfillmentOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `fulfillmentOrderOpen` mutation. */
export type FulfillmentOrderOpenPayload = {
  __typename?: "FulfillmentOrderOpenPayload"
  /** The fulfillment order that was transitioned to open and is fulfillable. */
  fulfillmentOrder?: Maybe<FulfillmentOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `fulfillmentOrderRejectCancellationRequest` mutation. */
export type FulfillmentOrderRejectCancellationRequestPayload = {
  __typename?: "FulfillmentOrderRejectCancellationRequestPayload"
  /** The fulfillment order whose cancellation request was rejected. */
  fulfillmentOrder?: Maybe<FulfillmentOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `fulfillmentOrderRejectFulfillmentRequest` mutation. */
export type FulfillmentOrderRejectFulfillmentRequestPayload = {
  __typename?: "FulfillmentOrderRejectFulfillmentRequestPayload"
  /** The fulfillment order whose fulfillment request was rejected. */
  fulfillmentOrder?: Maybe<FulfillmentOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The reason for a fulfillment order rejection. */
export enum FulfillmentOrderRejectionReason {
  /** The fulfillment order was rejected because of an incorrect address. */
  IncorrectAddress = "INCORRECT_ADDRESS",
  /** The fulfillment order was rejected because of an ineligible product. */
  IneligibleProduct = "INELIGIBLE_PRODUCT",
  /** The fulfillment order was rejected because inventory is out of stock. */
  InventoryOutOfStock = "INVENTORY_OUT_OF_STOCK",
  /** The fulfillment order was rejected for another reason. */
  Other = "OTHER",
  /** The fulfillment order was rejected because of an undeliverable destination. */
  UndeliverableDestination = "UNDELIVERABLE_DESTINATION",
}

/** Return type for `fulfillmentOrderReleaseHold` mutation. */
export type FulfillmentOrderReleaseHoldPayload = {
  __typename?: "FulfillmentOrderReleaseHoldPayload"
  /** The fulfillment order on which the hold was released. */
  fulfillmentOrder?: Maybe<FulfillmentOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<FulfillmentOrderReleaseHoldUserError>
}

/** An error that occurs during the execution of `FulfillmentOrderReleaseHold`. */
export type FulfillmentOrderReleaseHoldUserError = DisplayableError & {
  __typename?: "FulfillmentOrderReleaseHoldUserError"
  /** The error code. */
  code?: Maybe<FulfillmentOrderReleaseHoldUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `FulfillmentOrderReleaseHoldUserError`. */
export enum FulfillmentOrderReleaseHoldUserErrorCode {
  /** The fulfillment order wasn't found. */
  FulfillmentOrderNotFound = "FULFILLMENT_ORDER_NOT_FOUND",
  /** The fulfillment order line item quantity must be greater than 0. */
  GreaterThanZero = "GREATER_THAN_ZERO",
  /** The fulfillment order line item quantity is invalid. */
  InvalidLineItemQuantity = "INVALID_LINE_ITEM_QUANTITY",
}

/** The request status of a fulfillment order. */
export enum FulfillmentOrderRequestStatus {
  /** The fulfillment service accepted the merchant's fulfillment request. */
  Accepted = "ACCEPTED",
  /**
   * The fulfillment service accepted the merchant's fulfillment cancellation request.
   *
   */
  CancellationAccepted = "CANCELLATION_ACCEPTED",
  /**
   * The fulfillment service rejected the merchant's fulfillment cancellation request.
   *
   */
  CancellationRejected = "CANCELLATION_REJECTED",
  /**
   * The merchant requested a cancellation of the fulfillment request for this fulfillment order.
   *
   */
  CancellationRequested = "CANCELLATION_REQUESTED",
  /** The fulfillment service closed the fulfillment order without completing it. */
  Closed = "CLOSED",
  /** The fulfillment service rejected the merchant's fulfillment request. */
  Rejected = "REJECTED",
  /** The merchant requested fulfillment for this fulfillment order. */
  Submitted = "SUBMITTED",
  /**
   * The initial request status for the newly-created fulfillment orders. This is the only valid
   * request status for fulfillment orders that aren't assigned to a fulfillment service.
   *
   */
  Unsubmitted = "UNSUBMITTED",
}

/** Return type for `fulfillmentOrderReschedule` mutation. */
export type FulfillmentOrderReschedulePayload = {
  __typename?: "FulfillmentOrderReschedulePayload"
  /**
   * A fulfillment order with the rescheduled line items.
   *
   * Fulfillment orders may be merged if they have the same `fulfillAt` datetime.
   *
   * If the fulfillment order is merged then the resulting fulfillment order will be returned.
   * Otherwise the original fulfillment order will be returned with an updated `fulfillAt` datetime.
   *
   */
  fulfillmentOrder?: Maybe<FulfillmentOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<FulfillmentOrderRescheduleUserError>
}

/** An error that occurs during the execution of `FulfillmentOrderReschedule`. */
export type FulfillmentOrderRescheduleUserError = DisplayableError & {
  __typename?: "FulfillmentOrderRescheduleUserError"
  /** The error code. */
  code?: Maybe<FulfillmentOrderRescheduleUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `FulfillmentOrderRescheduleUserError`. */
export enum FulfillmentOrderRescheduleUserErrorCode {
  /** Fulfillment order could not be found. */
  FulfillmentOrderNotFound = "FULFILLMENT_ORDER_NOT_FOUND",
}

/** The set of valid sort keys for the FulfillmentOrder query. */
export enum FulfillmentOrderSortKeys {
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
}

/** The input fields for the split applied to the fulfillment order. */
export type FulfillmentOrderSplitInput = {
  /** The ID of the fulfillment order to be split. */
  fulfillmentOrderId: Scalars["ID"]["input"]
  /**
   * The fulfillment order line items to be split out.
   *
   */
  fulfillmentOrderLineItems: Array<FulfillmentOrderLineItemInput>
}

/** Return type for `fulfillmentOrderSplit` mutation. */
export type FulfillmentOrderSplitPayload = {
  __typename?: "FulfillmentOrderSplitPayload"
  /** The result of the fulfillment order splits. */
  fulfillmentOrderSplits?: Maybe<Array<FulfillmentOrderSplitResult>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<FulfillmentOrderSplitUserError>
}

/** The result of splitting a fulfillment order. */
export type FulfillmentOrderSplitResult = {
  __typename?: "FulfillmentOrderSplitResult"
  /** The original fulfillment order as a result of the split. */
  fulfillmentOrder: FulfillmentOrder
  /** The remaining fulfillment order as a result of the split. */
  remainingFulfillmentOrder: FulfillmentOrder
  /** The replacement fulfillment order if the original fulfillment order wasn't in a state to be split. */
  replacementFulfillmentOrder?: Maybe<FulfillmentOrder>
}

/** An error that occurs during the execution of `FulfillmentOrderSplit`. */
export type FulfillmentOrderSplitUserError = DisplayableError & {
  __typename?: "FulfillmentOrderSplitUserError"
  /** The error code. */
  code?: Maybe<FulfillmentOrderSplitUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `FulfillmentOrderSplitUserError`. */
export enum FulfillmentOrderSplitUserErrorCode {
  /** The fulfillment order could not be found. */
  FulfillmentOrderNotFound = "FULFILLMENT_ORDER_NOT_FOUND",
  /** The fulfillment order line item quantity must be greater than 0. */
  GreaterThan = "GREATER_THAN",
  /** The fulfillment order line item quantity is invalid. */
  InvalidLineItemQuantity = "INVALID_LINE_ITEM_QUANTITY",
  /** The fulfillment order must have at least one line item input to split. */
  NoLineItemsProvidedToSplit = "NO_LINE_ITEMS_PROVIDED_TO_SPLIT",
}

/** The status of a fulfillment order. */
export enum FulfillmentOrderStatus {
  /** The fulfillment order has been cancelled by the merchant. */
  Cancelled = "CANCELLED",
  /** The fulfillment order has been completed and closed. */
  Closed = "CLOSED",
  /** The fulfillment order cannot be completed as requested. */
  Incomplete = "INCOMPLETE",
  /** The fulfillment order is being processed. */
  InProgress = "IN_PROGRESS",
  /** The fulfillment order is on hold. The fulfillment process can't be initiated until the hold on the fulfillment order is released. */
  OnHold = "ON_HOLD",
  /** The fulfillment order is ready for fulfillment. */
  Open = "OPEN",
  /** The fulfillment order is deferred and will be ready for fulfillment after the date and time specified in `fulfill_at`. */
  Scheduled = "SCHEDULED",
}

/** Return type for `fulfillmentOrderSubmitCancellationRequest` mutation. */
export type FulfillmentOrderSubmitCancellationRequestPayload = {
  __typename?: "FulfillmentOrderSubmitCancellationRequestPayload"
  /** The fulfillment order specified in the cancelation request. */
  fulfillmentOrder?: Maybe<FulfillmentOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `fulfillmentOrderSubmitFulfillmentRequest` mutation. */
export type FulfillmentOrderSubmitFulfillmentRequestPayload = {
  __typename?: "FulfillmentOrderSubmitFulfillmentRequestPayload"
  /**
   * The original fulfillment order intended to request fulfillment for.
   *
   */
  originalFulfillmentOrder?: Maybe<FulfillmentOrder>
  /**
   * The fulfillment order that was submitted to the fulfillment service. This will be the same as
   * the original fulfillment order field. The exception to this is partial fulfillment requests or
   * fulfillment request for cancelled or incomplete fulfillment orders.
   *
   */
  submittedFulfillmentOrder?: Maybe<FulfillmentOrder>
  /**
   * This field will only be present for partial fulfillment requests. This will represent the new
   * fulfillment order with the remaining line items not submitted to the fulfillment service.
   *
   */
  unsubmittedFulfillmentOrder?: Maybe<FulfillmentOrder>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * One of the actions that the fulfillment order supports in its current state.
 *
 */
export type FulfillmentOrderSupportedAction = {
  __typename?: "FulfillmentOrderSupportedAction"
  /** The action value. */
  action: FulfillmentOrderAction
  /**
   * The external URL to be used to initiate the fulfillment process outside Shopify.
   * Applicable only when the `action` value is `EXTERNAL`.
   *
   */
  externalUrl?: Maybe<Scalars["URL"]["output"]>
}

/** Return type for `fulfillmentOrdersReleaseHolds` mutation. */
export type FulfillmentOrdersReleaseHoldsPayload = {
  __typename?: "FulfillmentOrdersReleaseHoldsPayload"
  /** The asynchronous job that will release the fulfillment holds. */
  job?: Maybe<Job>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<FulfillmentOrdersReleaseHoldsUserError>
}

/** An error that occurs during the execution of `FulfillmentOrdersReleaseHolds`. */
export type FulfillmentOrdersReleaseHoldsUserError = DisplayableError & {
  __typename?: "FulfillmentOrdersReleaseHoldsUserError"
  /** The error code. */
  code?: Maybe<FulfillmentOrdersReleaseHoldsUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `FulfillmentOrdersReleaseHoldsUserError`. */
export enum FulfillmentOrdersReleaseHoldsUserErrorCode {
  /** Failed to create release fulfillment order holds job. */
  FailedToCreateJob = "FAILED_TO_CREATE_JOB",
}

/** Return type for `fulfillmentOrdersSetFulfillmentDeadline` mutation. */
export type FulfillmentOrdersSetFulfillmentDeadlinePayload = {
  __typename?: "FulfillmentOrdersSetFulfillmentDeadlinePayload"
  /** Whether the fulfillment deadline was successfully set. */
  success?: Maybe<Scalars["Boolean"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<FulfillmentOrdersSetFulfillmentDeadlineUserError>
}

/** An error that occurs during the execution of `FulfillmentOrdersSetFulfillmentDeadline`. */
export type FulfillmentOrdersSetFulfillmentDeadlineUserError = DisplayableError & {
  __typename?: "FulfillmentOrdersSetFulfillmentDeadlineUserError"
  /** The error code. */
  code?: Maybe<FulfillmentOrdersSetFulfillmentDeadlineUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `FulfillmentOrdersSetFulfillmentDeadlineUserError`. */
export enum FulfillmentOrdersSetFulfillmentDeadlineUserErrorCode {
  /** The fulfillment orders could not be found. */
  FulfillmentOrdersNotFound = "FULFILLMENT_ORDERS_NOT_FOUND",
}

/** The address at which the fulfillment occurred. This object is intended for tax purposes, as a full address is required for tax providers to accurately calculate taxes. Typically this is the address of the warehouse or fulfillment center. To retrieve a fulfillment location's address, use the `assignedLocation` field on the [`FulfillmentOrder`](/docs/api/admin-graphql/latest/objects/FulfillmentOrder) object instead. */
export type FulfillmentOriginAddress = {
  __typename?: "FulfillmentOriginAddress"
  /** The street address of the fulfillment location. */
  address1?: Maybe<Scalars["String"]["output"]>
  /** The second line of the address. Typically the number of the apartment, suite, or unit. */
  address2?: Maybe<Scalars["String"]["output"]>
  /** The city in which the fulfillment location is located. */
  city?: Maybe<Scalars["String"]["output"]>
  /** The country code of the fulfillment location. */
  countryCode: Scalars["String"]["output"]
  /** The province code of the fulfillment location. */
  provinceCode?: Maybe<Scalars["String"]["output"]>
  /** The zip code of the fulfillment location. */
  zip?: Maybe<Scalars["String"]["output"]>
}

/** The input fields used to include the address at which the fulfillment occurred. This input object is intended for tax purposes, as a full address is required for tax providers to accurately calculate taxes. Typically this is the address of the warehouse or fulfillment center. To retrieve a fulfillment location's address, use the `assignedLocation` field on the [`FulfillmentOrder`](/docs/api/admin-graphql/latest/objects/FulfillmentOrder) object instead. */
export type FulfillmentOriginAddressInput = {
  /** The street address of the fulfillment location. */
  address1?: InputMaybe<Scalars["String"]["input"]>
  /** The second line of the address. Typically the number of the apartment, suite, or unit. */
  address2?: InputMaybe<Scalars["String"]["input"]>
  /** The city in which the fulfillment location is located. */
  city?: InputMaybe<Scalars["String"]["input"]>
  /** The country of the fulfillment location. */
  countryCode: Scalars["String"]["input"]
  /** The province of the fulfillment location. */
  provinceCode?: InputMaybe<Scalars["String"]["input"]>
  /** The zip code of the fulfillment location. */
  zip?: InputMaybe<Scalars["String"]["input"]>
}

/**
 * A **Fulfillment Service** is a third party warehouse that prepares and ships orders
 * on behalf of the store owner. Fulfillment services charge a fee to package and ship items
 * and update product inventory levels. Some well known fulfillment services with Shopify integrations
 * include: Amazon, Shipwire, and Rakuten. When an app registers a new `FulfillmentService` on a store,
 * Shopify automatically creates a `Location` that's associated to the fulfillment service.
 * To learn more about fulfillment services, refer to
 * [Manage fulfillments as a fulfillment service app](https://shopify.dev/apps/fulfillment/fulfillment-service-apps)
 * guide.
 *
 * ## Mutations
 *
 * You can work with the `FulfillmentService` object with the
 * [fulfillmentServiceCreate](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentServiceCreate),
 * [fulfillmentServiceUpdate](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentServiceUpdate),
 * and [fulfillmentServiceDelete](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentServiceDelete)
 * mutations.
 *
 * ## Hosted endpoints
 *
 * Fulfillment service providers integrate with Shopify by providing Shopify with a set of hosted endpoints that
 * Shopify can query on certain conditions.
 * These endpoints must have a common prefix, and this prefix should be supplied in the `callbackUrl` parameter
 * in the
 * [fulfillmentServiceCreate](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentServiceCreate)
 * mutation.
 *
 * - Shopify sends POST requests to the `<callbackUrl>/fulfillment_order_notification` endpoint
 *   to notify the fulfillment service about fulfillment requests and fulfillment cancellation requests,
 *   if `fulfillment_orders_opt_in` is set to `true`.
 *
 *   [As of the 2022-07 API version](https://shopify.dev/changelog/legacy-fulfillment-api-deprecation),
 *   it's mandatory for a fulfillment service to follow a fulfillment order based workflow by
 *   having `fulfillment_orders_opt_in` set to `true`,
 *   hosting the `<callbackUrl>/fulfillment_order_notification` endpoint, and acting on fulfillment requests and cancellations.
 *
 *   For more information, refer to
 *   [Receive fulfillment requests and cancellations](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments#step-2-receive-fulfillment-requests-and-cancellations).
 * - Shopify sends GET requests to the `<callbackUrl>/fetch_tracking_numbers` endpoint to retrieve tracking numbers for orders,
 *   if `trackingSupport` is set to `true`.
 *
 *   For more information, refer to
 *   [Enable tracking support](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments#step-8-enable-tracking-support-optional).
 *
 *   Fulfillment services can also update tracking information with the
 *   [fulfillmentTrackingInfoUpdateV2](https://shopify.dev/api/admin-graphql/latest/mutations/fulfillmentTrackingInfoUpdateV2) mutation,
 *   rather than waiting for Shopify to ask for tracking numbers.
 * - Shopify sends GET requests to the `<callbackUrl>/fetch_stock` endpoint to retrieve inventory levels,
 *   if `inventoryManagement` is set to `true`.
 *
 *   For more information, refer to
 *   [Sharing inventory levels with Shopify](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments#step-9-share-inventory-levels-with-shopify-optional).
 *
 * To make sure you have everything set up correctly, you can test the `callbackUrl`-prefixed endpoints
 * in your development store.
 *
 * ## Resources and webhooks
 *
 * There are a variety of objects and webhooks that enable a fulfillment service to work.
 * To exchange fulfillment information with Shopify, fulfillment services use the
 * [FulfillmentOrder](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentOrder),
 * [Fulfillment](https://shopify.dev/api/admin-graphql/latest/objects/Fulfillment) and
 * [Order](https://shopify.dev/api/admin-graphql/latest/objects/Order) objects and related mutations.
 * To act on fulfillment process events that happen on the Shopify side,
 * besides awaiting calls to `callbackUrl`-prefixed endpoints,
 * fulfillment services can subscribe to the
 * [fulfillment order](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments#webhooks)
 * and [order](https://shopify.dev/api/admin-rest/latest/resources/webhook)
 * webhooks.
 *
 */
export type FulfillmentService = {
  __typename?: "FulfillmentService"
  /**
   * The callback URL that the fulfillment service has registered for requests. The following considerations apply:
   *
   * - Shopify queries the `<callbackUrl>/fetch_tracking_numbers` endpoint to retrieve tracking numbers
   *     for orders, if `trackingSupport` is set to `true`.
   * - Shopify queries the `<callbackUrl>/fetch_stock` endpoint to retrieve inventory levels,
   *     if `inventoryManagement` is set to `true`.
   * - Shopify uses the `<callbackUrl>/fulfillment_order_notification` endpoint to send
   *     [fulfillment and cancellation requests](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments#step-2-receive-fulfillment-requests-and-cancellations),
   *     if the fulfillment service has opted in to the fulfillment order based workflow for managing fulfillments
   *     (`fulfillmentOrdersOptIn` is set to `true`).
   *
   */
  callbackUrl?: Maybe<Scalars["URL"]["output"]>
  /**
   * Whether the fulfillment service uses the [fulfillment order based workflow](https://shopify.dev/apps/fulfillment/fulfillment-service-apps/manage-fulfillments) for managing fulfillments.
   *
   * As the migration is now finished, the `fulfillmentOrdersOptIn` property is [deprecated](
   * https://shopify.dev/changelog/deprecation-of-the-fulfillmentservice-fulfillmentordersoptin-field)
   * and is always set to `true` on correctly functioning fulfillment services.
   *
   * @deprecated Migration period ended. All correctly functioning fulfillment services have `fulfillmentOrdersOptIn` set to `true`.
   */
  fulfillmentOrdersOptIn: Scalars["Boolean"]["output"]
  /** Human-readable unique identifier for this fulfillment service. */
  handle: Scalars["String"]["output"]
  /** The ID of the fulfillment service. */
  id: Scalars["ID"]["output"]
  /** Whether the fulfillment service tracks product inventory and provides updates to Shopify. */
  inventoryManagement: Scalars["Boolean"]["output"]
  /** Location associated with the fulfillment service. */
  location?: Maybe<Location>
  /** Whether the fulfillment service can stock inventory alongside other locations. */
  permitsSkuSharing: Scalars["Boolean"]["output"]
  /** Whether the fulfillment service supports local deliveries. */
  productBased: Scalars["Boolean"]["output"]
  /** The name of the fulfillment service as seen by merchants. */
  serviceName: Scalars["String"]["output"]
  /**
   * Shipping methods associated with the fulfillment service provider. Applies only to Fulfill By Amazon fulfillment service.
   * @deprecated The Fulfillment by Amazon feature will no longer be supported from March 30, 2023. To continue using Amazon fulfillment, merchants need to set up a Multi-Channel Fulfillment solution recommended by Amazon: https://help.shopify.com/manual/shipping/fulfillment-services/amazon#activate-fulfillment-by-amazon
   */
  shippingMethods: Array<ShippingMethod>
  /** Type associated with the fulfillment service. */
  type: FulfillmentServiceType
}

/** Return type for `fulfillmentServiceCreate` mutation. */
export type FulfillmentServiceCreatePayload = {
  __typename?: "FulfillmentServiceCreatePayload"
  /** The created fulfillment service. */
  fulfillmentService?: Maybe<FulfillmentService>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `fulfillmentServiceDelete` mutation. */
export type FulfillmentServiceDeletePayload = {
  __typename?: "FulfillmentServiceDeletePayload"
  /** The ID of the deleted fulfillment service. */
  deletedId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The type of a fulfillment service. */
export enum FulfillmentServiceType {
  /** Fulfillment by gift card. */
  GiftCard = "GIFT_CARD",
  /** Manual fulfillment by the merchant. */
  Manual = "MANUAL",
  /** Fullfillment by a third-party fulfillment service. */
  ThirdParty = "THIRD_PARTY",
}

/** Return type for `fulfillmentServiceUpdate` mutation. */
export type FulfillmentServiceUpdatePayload = {
  __typename?: "FulfillmentServiceUpdatePayload"
  /** The updated fulfillment service. */
  fulfillmentService?: Maybe<FulfillmentService>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The status of a fulfillment. */
export enum FulfillmentStatus {
  /** The fulfillment was canceled. */
  Cancelled = "CANCELLED",
  /** There was an error with the fulfillment request. */
  Error = "ERROR",
  /** The fulfillment request failed. */
  Failure = "FAILURE",
  /**
   * The third-party fulfillment service has acknowledged the fulfillment and is processing it.
   *
   * @deprecated This is a legacy status and is due to be deprecated.
   */
  Open = "OPEN",
  /**
   * Shopify has created the fulfillment and is waiting for the third-party fulfillment service to transition it to `open` or `success`.
   *
   * @deprecated This is a legacy status and is due to be deprecated.
   */
  Pending = "PENDING",
  /** The fulfillment was completed successfully. */
  Success = "SUCCESS",
}

/** Represents the tracking information for a fulfillment. */
export type FulfillmentTrackingInfo = {
  __typename?: "FulfillmentTrackingInfo"
  /**
   * The name of the tracking company.
   *
   * For tracking company names from the list below
   * Shopify will automatically build tracking URLs for all provided tracking numbers,
   * which will make the tracking numbers clickable in the interface.
   *
   * Additionally, for the tracking companies listed on the
   * [Shipping Carriers help page](https://help.shopify.com/manual/shipping/understanding-shipping/shipping-carriers#integrated-shipping-carriers)
   * Shopify will automatically update the fulfillment's `shipment_status` field during the fulfillment process.
   *
   * ### Supported tracking companies
   *
   * The following tracking companies display for shops located in any country:
   *
   *   * 4PX
   *   * AGS
   *   * Amazon Logistics UK
   *   * Amazon Logistics US
   *   * An Post
   *   * Anjun Logistics
   *   * APC
   *   * Asendia USA
   *   * Australia Post
   *   * Bonshaw
   *   * BPost
   *   * BPost International
   *   * Canada Post
   *   * Canpar
   *   * CDL Last Mile
   *   * China Post
   *   * Chronopost
   *   * Chukou1
   *   * Colissimo
   *   * Comingle
   *   * Coordinadora
   *   * Correios
   *   * Correos
   *   * CTT
   *   * CTT Express
   *   * Cyprus Post
   *   * Delnext
   *   * Deutsche Post
   *   * DHL eCommerce
   *   * DHL eCommerce Asia
   *   * DHL Express
   *   * DoorDash
   *   * DPD
   *   * DPD Local
   *   * DPD UK
   *   * DTD Express
   *   * DX
   *   * Eagle
   *   * Estes
   *   * Evri
   *   * FedEx
   *   * First Global Logistics
   *   * First Line
   *   * FSC
   *   * Fulfilla
   *   * GLS
   *   * Guangdong Weisuyi Information Technology (WSE)
   *   * Heppner Internationale Spedition GmbH & Co.
   *   * Iceland Post
   *   * IDEX
   *   * Israel Post
   *   * Japan Post (EN)
   *   * Japan Post (JA)
   *   * La Poste
   *   * Lasership
   *   * Latvia Post
   *   * Lietuvos Paštas
   *   * Logisters
   *   * Lone Star Overnight
   *   * M3 Logistics
   *   * Meteor Space
   *   * Mondial Relay
   *   * New Zealand Post
   *   * NinjaVan
   *   * North Russia Supply Chain (Shenzhen) Co.
   *   * OnTrac
   *   * Packeta
   *   * Pago Logistics
   *   * Ping An Da Tengfei Express
   *   * Pitney Bowes
   *   * Portal PostNord
   *   * Poste Italiane
   *   * PostNL
   *   * PostNord DK
   *   * PostNord NO
   *   * PostNord SE
   *   * Purolator
   *   * Qxpress
   *   * Qyun Express
   *   * Royal Mail
   *   * Royal Shipments
   *   * Sagawa (EN)
   *   * Sagawa (JA)
   *   * Sendle
   *   * SF Express
   *   * SFC Fulfillment
   *   * SHREE NANDAN COURIER
   *   * Singapore Post
   *   * Southwest Air Cargo
   *   * StarTrack
   *   * Step Forward Freight
   *   * Swiss Post
   *   * TForce Final Mile
   *   * Tinghao
   *   * TNT
   *   * Toll IPEC
   *   * United Delivery Service
   *   * UPS
   *   * USPS
   *   * Venipak
   *   * We Post
   *   * Whistl
   *   * Wizmo
   *   * WMYC
   *   * Xpedigo
   *   * XPO Logistics
   *   * Yamato (EN)
   *   * Yamato (JA)
   *   * YiFan Express
   *   * YunExpress
   *
   * The following tracking companies are displayed for shops located in specific countries:
   *
   *   * **Australia**: Australia Post, Sendle, Aramex Australia, TNT Australia, Hunter Express, Couriers Please, Bonds, Allied Express, Direct Couriers, Northline, GO Logistics
   *   * **Austria**: Österreichische Post
   *   * **Bulgaria**: Speedy
   *   * **Canada**: Intelcom, BoxKnight, Loomis, GLS
   *   * **China**: China Post, DHL eCommerce Asia, WanbExpress, YunExpress, Anjun Logistics, SFC Fulfillment, FSC
   *   * **Czechia**: Zásilkovna
   *   * **Germany**: Deutsche Post (DE), Deutsche Post (EN), DHL, DHL Express, Swiship, Hermes, GLS
   *   * **Spain**: SEUR
   *   * **France**: Colissimo, Mondial Relay, Colis Privé, GLS
   *   * **United Kingdom**: Evri, DPD UK, Parcelforce, Yodel, DHL Parcel, Tuffnells
   *   * **Greece**: ACS Courier
   *   * **Hong Kong SAR**: SF Express
   *   * **Ireland**: Fastway, DPD Ireland
   *   * **India**: DTDC, India Post, Delhivery, Gati KWE, Professional Couriers, XpressBees, Ecom Express, Ekart, Shadowfax, Bluedart
   *   * **Italy**: BRT, GLS Italy
   *   * **Japan**: エコ配, 西濃運輸, 西濃スーパーエキスプレス, 福山通運, 日本通運, 名鉄運輸, 第一貨物
   *   * **Netherlands**: DHL Parcel, DPD
   *   * **Norway**: Bring
   *   * **Poland**: Inpost
   *   * **Turkey**: PTT, Yurtiçi Kargo, Aras Kargo, Sürat Kargo
   *   * **United States**: GLS, Alliance Air Freight, Pilot Freight, LSO, Old Dominion, R+L Carriers, Southwest Air Cargo
   *   * **South Africa**: Fastway, Skynet.
   *
   */
  company?: Maybe<Scalars["String"]["output"]>
  /**
   * The tracking number of the fulfillment.
   *
   * The tracking number is clickable in the interface if one of the following applies
   * (the highest in the list has the highest priority):
   *
   * * Tracking url provided in the `url` field.
   * * [Shopify-known tracking company name](#supported-tracking-companies) specified in the `company` field.
   *   Shopify will build the tracking URL automatically based on the tracking number specified.
   * * The tracking number has a Shopify-known format.
   *   Shopify will guess the tracking provider and build the tracking url based on the tracking number format.
   *   Not all tracking carriers are supported, and multiple tracking carriers may use similarly formatted tracking numbers.
   *   This can result in an invalid tracking URL.
   *   It is highly recommended that you send the tracking company and the tracking URL.
   *
   */
  number?: Maybe<Scalars["String"]["output"]>
  /**
   * The URLs to track the fulfillment.
   *
   * The tracking URL is displayed in the merchant's admin on the order page.
   * The tracking URL is displayed in the shipping confirmation email, which can optionally be sent to the customer.
   * When accounts are enabled, it's also displayed in the customer's order history.
   *
   */
  url?: Maybe<Scalars["URL"]["output"]>
}

/** Return type for `fulfillmentTrackingInfoUpdateV2` mutation. */
export type FulfillmentTrackingInfoUpdateV2Payload = {
  __typename?: "FulfillmentTrackingInfoUpdateV2Payload"
  /** The updated fulfillment with tracking information. */
  fulfillment?: Maybe<Fulfillment>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * The input fields that specify all possible fields for tracking information.
 *
 * > Note:
 * > If you provide the `url` field, you should not provide the `urls` field.
 * >
 * > If you provide the `number` field, you should not provide the `numbers` field.
 * >
 * > If you provide the `url` field, you should provide the `number` field.
 * >
 * > If you provide the `urls` field, you should provide the `numbers` field.
 *
 */
export type FulfillmentTrackingInput = {
  /**
   * The name of the tracking company.
   *
   * If you specify a tracking company name from
   * [the list](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentTrackingInfo#supported-tracking-companies),
   * Shopify will automatically build tracking URLs for all provided tracking numbers,
   * which will make the tracking numbers clickable in the interface.
   * The same tracking company will be applied to all tracking numbers specified.
   *
   * Additionally, for the tracking companies listed on the
   * [Shipping Carriers help page](https://help.shopify.com/manual/shipping/understanding-shipping/shipping-carriers#integrated-shipping-carriers)
   * Shopify will automatically update the fulfillment's `shipment_status` field during the fulfillment process.
   *
   * > Note:
   * > Send the tracking company name exactly as written in
   * > [the list](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentTrackingInfo#supported-tracking-companies)
   * > (capitalization matters).
   *
   */
  company?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The tracking number of the fulfillment.
   *
   * The tracking number will be clickable in the interface if one of the following applies
   * (the highest in the list has the highest priority):
   *
   * * Tracking url provided in the `url` field.
   * * [Shopify-known tracking company name](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentTrackingInfo#supported-tracking-companies)
   *   specified in the `company` field.
   *   Shopify will build the tracking URL automatically based on the tracking number specified.
   * * The tracking number has a Shopify-known format.
   *   Shopify will guess the tracking provider and build the tracking url based on the tracking number format.
   *   Not all tracking carriers are supported, and multiple tracking carriers may use similarly formatted tracking numbers.
   *   This can result in an invalid tracking URL.
   *   It is highly recommended that you send the tracking company and the tracking URL.
   *
   */
  number?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The tracking numbers of the fulfillment, one or many.
   *
   * With multiple tracking numbers, you can provide tracking information
   * for all shipments associated with the fulfillment, if there are more than one.
   * For example, if you're shipping assembly parts of one furniture item in several boxes.
   *
   * Tracking numbers will be clickable in the interface if one of the following applies
   * (the highest in the list has the highest priority):
   *
   * * Tracking URLs provided in the `urls` field.
   *   The tracking URLs will be matched to the tracking numbers based on their positions in the arrays.
   * * [Shopify-known tracking company name](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentTrackingInfo#supported-tracking-companies)
   *   specified in the `company` field.
   *   Shopify will build tracking URLs automatically for all tracking numbers specified.
   *   The same tracking company will be applied to all tracking numbers.
   * * Tracking numbers have a Shopify-known format.
   *   Shopify will guess tracking providers and build tracking URLs based on the tracking number formats.
   *   Not all tracking carriers are supported, and multiple tracking carriers may use similarly formatted tracking numbers.
   *   This can result in an invalid tracking URL.
   *   It is highly recommended that you send the tracking company and the tracking URLs.
   *
   *
   */
  numbers?: InputMaybe<Array<Scalars["String"]["input"]>>
  /**
   * The URL to track the fulfillment.
   *
   * The tracking URL is displayed in the merchant's admin on the order page.
   * The tracking URL is displayed in the shipping confirmation email, which can optionally be sent to the customer.
   * When accounts are enabled, it's also displayed in the customer's order history.
   *
   * The URL must be an [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986) and
   * [RFC 3987](https://datatracker.ietf.org/doc/html/rfc3987)-compliant URI string.
   * For example, `"https://www.myshipping.com/track/?tracknumbers=TRACKING_NUMBER"` is a valid URL.
   * It includes a scheme (`https`) and a host (`myshipping.com`).
   *
   */
  url?: InputMaybe<Scalars["URL"]["input"]>
  /**
   * The URLs to track the fulfillment, one or many.
   *
   * The tracking URLs are displayed in the merchant's admin on the order page.
   * The tracking URLs are displayed in the shipping confirmation email, which can optionally be sent to the customer.
   * When accounts are enabled, the tracking URLs are also displayed in the customer's order history.
   *
   * If you're not specifying a
   * [Shopify-known](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentTrackingInfo#supported-tracking-companies)
   * tracking company name in the `company` field,
   * then provide tracking URLs for all tracking numbers from the `numbers` field.
   *
   * Tracking URLs from the `urls` array field are being matched with the tracking numbers from the `numbers` array
   * field correspondingly their positions in the arrays.
   *
   * Each URL must be an [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986) and
   * [RFC 3987](https://datatracker.ietf.org/doc/html/rfc3987)-compliant URI string.
   * For example, `"https://www.myshipping.com/track/?tracknumbers=TRACKING_NUMBER"` is a valid URL.
   * It includes a scheme (`https`) and a host (`myshipping.com`).
   *
   */
  urls?: InputMaybe<Array<Scalars["URL"]["input"]>>
}

/** The input fields used to create a fulfillment from fulfillment orders. */
export type FulfillmentV2Input = {
  /**
   * Pairs of `fulfillment_order_id` and `fulfillment_order_line_items` that represent the fulfillment
   * order line items that have to be fulfilled for each fulfillment order.  For any given pair, if the
   * fulfillment order line items are left blank then all the fulfillment order line items of the
   * associated fulfillment order ID will be fulfilled.
   *
   */
  lineItemsByFulfillmentOrder: Array<FulfillmentOrderLineItemsInput>
  /**
   * Whether the customer is notified.
   * If `true`, then a notification is sent when the fulfillment is created. The default value is `false`.
   *
   */
  notifyCustomer?: InputMaybe<Scalars["Boolean"]["input"]>
  /**
   * Address information about the location from which the order was fulfilled.
   *
   */
  originAddress?: InputMaybe<FulfillmentOriginAddressInput>
  /**
   * The fulfillment's tracking information, including a tracking URL, a tracking number,
   * and the company associated with the fulfillment.
   *
   */
  trackingInfo?: InputMaybe<FulfillmentTrackingInput>
}

/** The App Bridge information for a Shopify Function. */
export type FunctionsAppBridge = {
  __typename?: "FunctionsAppBridge"
  /** The relative path for creating a customization. */
  createPath: Scalars["String"]["output"]
  /** The relative path for viewing a customization. */
  detailsPath: Scalars["String"]["output"]
}

/** The error history from running a Shopify Function. */
export type FunctionsErrorHistory = {
  __typename?: "FunctionsErrorHistory"
  /** The date and time that the first error occurred. */
  errorsFirstOccurredAt: Scalars["DateTime"]["output"]
  /** The date and time that the first error occurred. */
  firstOccurredAt: Scalars["DateTime"]["output"]
  /** Whether the merchant has shared all the recent errors with the developer. */
  hasBeenSharedSinceLastError: Scalars["Boolean"]["output"]
  /** Whether the merchant has shared all the recent errors with the developer. */
  hasSharedRecentErrors: Scalars["Boolean"]["output"]
}

/**
 * Represents any file other than HTML.
 *
 */
export type GenericFile = File &
  Node & {
    __typename?: "GenericFile"
    /** A word or phrase to describe the contents or the function of a file. */
    alt?: Maybe<Scalars["String"]["output"]>
    /**
     * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) when the file was created.
     *
     */
    createdAt: Scalars["DateTime"]["output"]
    /** Any errors that have occurred on the file. */
    fileErrors: Array<FileError>
    /** The status of the file. */
    fileStatus: FileStatus
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The generic file's MIME type. */
    mimeType?: Maybe<Scalars["String"]["output"]>
    /** The generic file's size in bytes. */
    originalFileSize?: Maybe<Scalars["Int"]["output"]>
    /** The preview image for the media. */
    preview?: Maybe<MediaPreviewImage>
    /** The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) when the file was last updated. */
    updatedAt: Scalars["DateTime"]["output"]
    /** The generic file's URL. */
    url?: Maybe<Scalars["URL"]["output"]>
  }

/** Represents an issued gift card. */
export type GiftCard = Node & {
  __typename?: "GiftCard"
  /** The gift card's remaining balance. */
  balance: MoneyV2
  /** The date and time at which the gift card was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** The customer who will receive the gift card. */
  customer?: Maybe<Customer>
  /** The date and time at which the gift card was disabled. */
  disabledAt?: Maybe<Scalars["DateTime"]["output"]>
  /** Whether the gift card is enabled. */
  enabled: Scalars["Boolean"]["output"]
  /** The date at which the gift card will expire. */
  expiresOn?: Maybe<Scalars["Date"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The initial value of the gift card. */
  initialValue: MoneyV2
  /** The final four characters of the gift card code. */
  lastCharacters: Scalars["String"]["output"]
  /** The gift card code. Everything but the final four characters is masked. */
  maskedCode: Scalars["String"]["output"]
  /** The note associated with the gift card, which isn't visible to the customer. */
  note?: Maybe<Scalars["String"]["output"]>
  /**
   * The order associated with the gift card. This value is `null` if the gift card was issued manually.
   *
   */
  order?: Maybe<Order>
}

/**
 * An auto-generated type for paginating through multiple GiftCards.
 *
 */
export type GiftCardConnection = {
  __typename?: "GiftCardConnection"
  /** A list of edges. */
  edges: Array<GiftCardEdge>
  /** A list of the nodes contained in GiftCardEdge. */
  nodes: Array<GiftCard>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** The input fields to issue a gift card. */
export type GiftCardCreateInput = {
  /**
   * The gift card's code. It must be 8-20 characters long and contain only letters(a-z) and numbers(0-9).
   * It isn't case sensitive. If not provided, then a random code will be generated.
   *
   */
  code?: InputMaybe<Scalars["String"]["input"]>
  /** The ID of the customer who will receive the gift card. Requires `write_customers` access_scope. */
  customerId?: InputMaybe<Scalars["ID"]["input"]>
  /**
   * The date at which the gift card will expire. If not provided, then the gift card will never expire.
   *
   */
  expiresOn?: InputMaybe<Scalars["Date"]["input"]>
  /** The initial value of the gift card. */
  initialValue: Scalars["Decimal"]["input"]
  /** The note associated with the gift card, which isn't visible to the customer. */
  note?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The suffix of the Liquid template that's used to render the gift card online.
   * For example, if the value is `birthday`, then the gift card is rendered using the template `gift_card.birthday.liquid`.
   * If not provided, then the default `gift_card.liquid` template is used.
   *
   */
  templateSuffix?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `giftCardCreate` mutation. */
export type GiftCardCreatePayload = {
  __typename?: "GiftCardCreatePayload"
  /** The created gift card. */
  giftCard?: Maybe<GiftCard>
  /** The created gift card's code. */
  giftCardCode?: Maybe<Scalars["String"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<GiftCardUserError>
}

/** Return type for `giftCardDisable` mutation. */
export type GiftCardDisablePayload = {
  __typename?: "GiftCardDisablePayload"
  /** The disabled gift card. */
  giftCard?: Maybe<GiftCard>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * An auto-generated type which holds one GiftCard and a cursor during pagination.
 *
 */
export type GiftCardEdge = {
  __typename?: "GiftCardEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of GiftCardEdge. */
  node: GiftCard
}

/** Possible error codes that can be returned by `GiftCardUserError`. */
export enum GiftCardErrorCode {
  /** The input value should be greater than the minimum allowed value. */
  GreaterThan = "GREATER_THAN",
  /** Unexpected internal error happened. */
  InternalError = "INTERNAL_ERROR",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** Missing a required argument. */
  MissingArgument = "MISSING_ARGUMENT",
  /** The input value is already taken. */
  Taken = "TAKEN",
  /** The input value is too long. */
  TooLong = "TOO_LONG",
  /** The input value is too short. */
  TooShort = "TOO_SHORT",
}

/** A sale associated with a gift card. */
export type GiftCardSale = Sale & {
  __typename?: "GiftCardSale"
  /** The type of order action that the sale represents. */
  actionType: SaleActionType
  /** The unique ID for the sale. */
  id: Scalars["ID"]["output"]
  /** The line item for the associated sale. */
  lineItem: LineItem
  /** The line type assocated with the sale. */
  lineType: SaleLineType
  /** The number of units either ordered or intended to be returned. */
  quantity?: Maybe<Scalars["Int"]["output"]>
  /** All individual taxes associated with the sale. */
  taxes: Array<SaleTax>
  /** The total sale amount after taxes and discounts. */
  totalAmount: MoneyBag
  /** The total discounts allocated to the sale after taxes. */
  totalDiscountAmountAfterTaxes: MoneyBag
  /** The total discounts allocated to the sale before taxes. */
  totalDiscountAmountBeforeTaxes: MoneyBag
  /** The total amount of taxes for the sale. */
  totalTaxAmount: MoneyBag
}

/** The set of valid sort keys for the GiftCard query. */
export enum GiftCardSortKeys {
  /** Sort by the `amount_spent` value. */
  AmountSpent = "AMOUNT_SPENT",
  /** Sort by the `balance` value. */
  Balance = "BALANCE",
  /** Sort by the `code` value. */
  Code = "CODE",
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `customer_name` value. */
  CustomerName = "CUSTOMER_NAME",
  /** Sort by the `disabled_at` value. */
  DisabledAt = "DISABLED_AT",
  /** Sort by the `expires_on` value. */
  ExpiresOn = "EXPIRES_ON",
  /** Sort by the `id` value. */
  Id = "ID",
  /** Sort by the `initial_value` value. */
  InitialValue = "INITIAL_VALUE",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `updated_at` value. */
  UpdatedAt = "UPDATED_AT",
}

/** The input fields to update a gift card. */
export type GiftCardUpdateInput = {
  /**
   * The ID of the customer who will receive the gift card. The ID can't be changed if the gift card already has an assigned customer ID.
   *
   */
  customerId?: InputMaybe<Scalars["ID"]["input"]>
  /**
   * The date at which the gift card will expire. If set to `null`, then the gift card will never expire.
   *
   */
  expiresOn?: InputMaybe<Scalars["Date"]["input"]>
  /** The note associated with the gift card, which isn't visible to the customer. */
  note?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The suffix of the Liquid template that's used to render the gift card online.
   * For example, if the value is `birthday`, then the gift card is rendered using the template `gift_card.birthday.liquid`.
   *
   */
  templateSuffix?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `giftCardUpdate` mutation. */
export type GiftCardUpdatePayload = {
  __typename?: "GiftCardUpdatePayload"
  /** The updated gift card. */
  giftCard?: Maybe<GiftCard>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Represents an error that happens during the execution of a gift card mutation. */
export type GiftCardUserError = DisplayableError & {
  __typename?: "GiftCardUserError"
  /** The error code. */
  code?: Maybe<GiftCardErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Represents an object that has a list of events. */
export type HasEvents = {
  /** The paginated list of events associated with the host subject. */
  events: EventConnection
}

/** Represents an object that has a list of events. */
export type HasEventsEventsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<EventSortKeys>
}

/**
 * Localization extensions associated with the specified resource. For example, the tax id for government invoice.
 *
 */
export type HasLocalizationExtensions = {
  /** List of localization extensions for the resource. */
  localizationExtensions: LocalizationExtensionConnection
}

/**
 * Localization extensions associated with the specified resource. For example, the tax id for government invoice.
 *
 */
export type HasLocalizationExtensionsLocalizationExtensionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  countryCodes?: InputMaybe<Array<CountryCode>>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  purposes?: InputMaybe<Array<LocalizationExtensionPurpose>>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Resources that metafield definitions can be applied to. */
export type HasMetafieldDefinitions = {
  /** List of metafield definitions. */
  metafieldDefinitions: MetafieldDefinitionConnection
}

/** Resources that metafield definitions can be applied to. */
export type HasMetafieldDefinitionsMetafieldDefinitionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  pinnedStatus?: InputMaybe<MetafieldDefinitionPinnedStatus>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<MetafieldDefinitionSortKeys>
}

/** Represents information about the metafields associated to the specified resource. */
export type HasMetafields = {
  /** Returns a metafield by namespace and key that belongs to the resource. */
  metafield?: Maybe<Metafield>
  /** List of metafields that belong to the resource. */
  metafields: MetafieldConnection
  /**
   * Returns a private metafield by namespace and key that belongs to the resource.
   * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
   * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
   *
   */
  privateMetafield?: Maybe<PrivateMetafield>
  /**
   * List of private metafields that belong to the resource.
   * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
   * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
   *
   */
  privateMetafields: PrivateMetafieldConnection
}

/** Represents information about the metafields associated to the specified resource. */
export type HasMetafieldsMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/** Represents information about the metafields associated to the specified resource. */
export type HasMetafieldsMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Represents information about the metafields associated to the specified resource. */
export type HasMetafieldsPrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/** Represents information about the metafields associated to the specified resource. */
export type HasMetafieldsPrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Published translations associated with the resource. */
export type HasPublishedTranslations = {
  /** The translations associated with the resource. */
  translations: Array<Translation>
}

/** Published translations associated with the resource. */
export type HasPublishedTranslationsTranslationsArgs = {
  locale: Scalars["String"]["input"]
  marketId?: InputMaybe<Scalars["ID"]["input"]>
}

/** Represents an image resource. */
export type Image = HasMetafields & {
  __typename?: "Image"
  /** A word or phrase to share the nature or contents of an image. */
  altText?: Maybe<Scalars["String"]["output"]>
  /** The original height of the image in pixels. Returns `null` if the image isn't hosted by Shopify. */
  height?: Maybe<Scalars["Int"]["output"]>
  /** A unique ID for the image. */
  id?: Maybe<Scalars["ID"]["output"]>
  /** Returns a metafield by namespace and key that belongs to the resource. */
  metafield?: Maybe<Metafield>
  /** List of metafields that belong to the resource. */
  metafields: MetafieldConnection
  /**
   * The location of the original image as a URL.
   *
   * If there are any existing transformations in the original source URL, they will remain and not be stripped.
   *
   * @deprecated Use `url` instead.
   */
  originalSrc: Scalars["URL"]["output"]
  /**
   * Returns a private metafield by namespace and key that belongs to the resource.
   * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
   * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
   *
   */
  privateMetafield?: Maybe<PrivateMetafield>
  /**
   * List of private metafields that belong to the resource.
   * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
   * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
   *
   */
  privateMetafields: PrivateMetafieldConnection
  /**
   * The location of the image as a URL.
   * @deprecated Use `url` instead.
   */
  src: Scalars["URL"]["output"]
  /**
   * The location of the transformed image as a URL.
   *
   * All transformation arguments are considered "best-effort". If they can be applied to an image, they will be.
   * Otherwise any transformations which an image type doesn't support will be ignored.
   *
   * @deprecated Use `url(transform:)` instead
   */
  transformedSrc: Scalars["URL"]["output"]
  /**
   * The location of the image as a URL.
   *
   * If no transform options are specified, then the original image will be preserved including any pre-applied transforms.
   *
   * All transformation options are considered "best-effort". Any transformation that the original image type doesn't support will be ignored.
   *
   * If you need multiple variations of the same image, then you can use [GraphQL aliases](https://graphql.org/learn/queries/#aliases).
   *
   */
  url: Scalars["URL"]["output"]
  /** The original width of the image in pixels. Returns `null` if the image isn't hosted by Shopify. */
  width?: Maybe<Scalars["Int"]["output"]>
}

/** Represents an image resource. */
export type ImageMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/** Represents an image resource. */
export type ImageMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Represents an image resource. */
export type ImagePrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/** Represents an image resource. */
export type ImagePrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Represents an image resource. */
export type ImageTransformedSrcArgs = {
  crop?: InputMaybe<CropRegion>
  maxHeight?: InputMaybe<Scalars["Int"]["input"]>
  maxWidth?: InputMaybe<Scalars["Int"]["input"]>
  preferredContentType?: InputMaybe<ImageContentType>
  scale?: InputMaybe<Scalars["Int"]["input"]>
}

/** Represents an image resource. */
export type ImageUrlArgs = {
  transform?: InputMaybe<ImageTransformInput>
}

/**
 * An auto-generated type for paginating through multiple Images.
 *
 */
export type ImageConnection = {
  __typename?: "ImageConnection"
  /** A list of edges. */
  edges: Array<ImageEdge>
  /** A list of the nodes contained in ImageEdge. */
  nodes: Array<Image>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** List of supported image content types. */
export enum ImageContentType {
  /** A JPG image. */
  Jpg = "JPG",
  /** A PNG image. */
  Png = "PNG",
  /** A WEBP image. */
  Webp = "WEBP",
}

/**
 * An auto-generated type which holds one Image and a cursor during pagination.
 *
 */
export type ImageEdge = {
  __typename?: "ImageEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of ImageEdge. */
  node: Image
}

/** The input fields for an image. */
export type ImageInput = {
  /** A word or phrase to share the nature or contents of an image. */
  altText?: InputMaybe<Scalars["String"]["input"]>
  /** A globally-unique ID. */
  id?: InputMaybe<Scalars["ID"]["input"]>
  /** The URL of the image. May be a staged upload URL. */
  src?: InputMaybe<Scalars["String"]["input"]>
}

/**
 * The available options for transforming an image.
 *
 * All transformation options are considered best effort. Any transformation that the original image type doesn't support will be ignored.
 *
 */
export type ImageTransformInput = {
  /**
   * The region of the image to remain after cropping.
   * Must be used in conjunction with the `maxWidth` and/or `maxHeight` fields, where the `maxWidth` and `maxHeight` aren't equal.
   * The `crop` argument should coincide with the smaller value. A smaller `maxWidth` indicates a `LEFT` or `RIGHT` crop, while
   * a smaller `maxHeight` indicates a `TOP` or `BOTTOM` crop. For example, `{ maxWidth: 5, maxHeight: 10, crop: LEFT }` will result
   * in an image with a width of 5 and height of 10, where the right side of the image is removed.
   *
   */
  crop?: InputMaybe<CropRegion>
  /**
   * Image height in pixels between 1 and 5760.
   *
   */
  maxHeight?: InputMaybe<Scalars["Int"]["input"]>
  /**
   * Image width in pixels between 1 and 5760.
   *
   */
  maxWidth?: InputMaybe<Scalars["Int"]["input"]>
  /**
   * Convert the source image into the preferred content type.
   * Supported conversions: `.svg` to `.png`, any file type to `.jpg`, and any file type to `.webp`.
   *
   */
  preferredContentType?: InputMaybe<ImageContentType>
  /**
   * Image size multiplier for high-resolution retina displays. Must be within 1..3.
   *
   */
  scale?: InputMaybe<Scalars["Int"]["input"]>
}

/**
 * A parameter to upload an image.
 *
 * Deprecated in favor of
 * [StagedUploadParameter](https://shopify.dev/api/admin-graphql/latest/objects/StagedUploadParameter),
 * which is used in
 * [StagedMediaUploadTarget](https://shopify.dev/api/admin-graphql/latest/objects/StagedMediaUploadTarget)
 * and returned by the
 * [stagedUploadsCreate mutation](https://shopify.dev/api/admin-graphql/latest/mutations/stagedUploadsCreate).
 *
 */
export type ImageUploadParameter = {
  __typename?: "ImageUploadParameter"
  /** The parameter name. */
  name: Scalars["String"]["output"]
  /** The parameter value. */
  value: Scalars["String"]["output"]
}

/** The input fields for the incoming line item. */
export type IncomingRequestLineItemInput = {
  /** The ID of the rejected line item. */
  fulfillmentOrderLineItemId: Scalars["ID"]["input"]
  /** The rejection message of the line item. */
  message?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `inventoryActivate` mutation. */
export type InventoryActivatePayload = {
  __typename?: "InventoryActivatePayload"
  /** The inventory level that was activated. */
  inventoryLevel?: Maybe<InventoryLevel>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The input fields for items and their adjustments. */
export type InventoryAdjustItemInput = {
  /** The change applied to the `available` quantity of the item at the location. */
  availableDelta: Scalars["Int"]["input"]
  /** ID of the inventory item to adjust. */
  inventoryItemId: Scalars["ID"]["input"]
}

/** The input fields required to adjust inventory quantities. */
export type InventoryAdjustQuantitiesInput = {
  /** The quantity changes of items at locations to be made. */
  changes: Array<InventoryChangeInput>
  /**
   * The quantity [name](https://shopify.dev/docs/apps/fulfillment/inventory-management-apps#inventory-states)
   * to be adjusted.
   *
   */
  name: Scalars["String"]["input"]
  /**
   * The reason for the quantity changes. The value must be one of the [possible
   * reasons](https://shopify.dev/docs/apps/fulfillment/inventory-management-apps/quantities-states#set-inventory-quantities-on-hand).
   *
   */
  reason: Scalars["String"]["input"]
  /** The reference document URI for the changes. Used to denote what's causing the change. */
  referenceDocumentUri?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `inventoryAdjustQuantities` mutation. */
export type InventoryAdjustQuantitiesPayload = {
  __typename?: "InventoryAdjustQuantitiesPayload"
  /** The group of changes made by the operation. */
  inventoryAdjustmentGroup?: Maybe<InventoryAdjustmentGroup>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<InventoryAdjustQuantitiesUserError>
}

/** An error that occurs during the execution of `InventoryAdjustQuantities`. */
export type InventoryAdjustQuantitiesUserError = DisplayableError & {
  __typename?: "InventoryAdjustQuantitiesUserError"
  /** The error code. */
  code?: Maybe<InventoryAdjustQuantitiesUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `InventoryAdjustQuantitiesUserError`. */
export enum InventoryAdjustQuantitiesUserErrorCode {
  /** The quantities couldn't be adjusted. Try again. */
  AdjustQuantitiesFailed = "ADJUST_QUANTITIES_FAILED",
  /** Internal (gid://shopify/) ledger documents are not allowed to be adjusted via API. */
  InternalLedgerDocument = "INTERNAL_LEDGER_DOCUMENT",
  /** A ledger document URI is not allowed when adjusting available. */
  InvalidAvailableDocument = "INVALID_AVAILABLE_DOCUMENT",
  /** The specified inventory item could not be found. */
  InvalidInventoryItem = "INVALID_INVENTORY_ITEM",
  /** The specified ledger document is invalid. */
  InvalidLedgerDocument = "INVALID_LEDGER_DOCUMENT",
  /** The specified location could not be found. */
  InvalidLocation = "INVALID_LOCATION",
  /** A ledger document URI is required except when adjusting available. */
  InvalidQuantityDocument = "INVALID_QUANTITY_DOCUMENT",
  /** The specified quantity name is invalid. */
  InvalidQuantityName = "INVALID_QUANTITY_NAME",
  /** The quantity can't be higher than 2,000,000,000. */
  InvalidQuantityTooHigh = "INVALID_QUANTITY_TOO_HIGH",
  /** The quantity can't be lower than -2,000,000,000. */
  InvalidQuantityTooLow = "INVALID_QUANTITY_TOO_LOW",
  /** The specified reason is invalid. */
  InvalidReason = "INVALID_REASON",
  /** The specified reference document is invalid. */
  InvalidReferenceDocument = "INVALID_REFERENCE_DOCUMENT",
  /** The inventory item is not stocked at the location. */
  ItemNotStockedAtLocation = "ITEM_NOT_STOCKED_AT_LOCATION",
  /** All changes must have the same ledger document URI or, in the case of adjusting available, no ledger document URI. */
  MaxOneLedgerDocument = "MAX_ONE_LEDGER_DOCUMENT",
  /** The specified inventory item is not allowed to be adjusted via API. */
  NonMutableInventoryItem = "NON_MUTABLE_INVENTORY_ITEM",
}

/** The input fields required to adjust the inventory quantity. */
export type InventoryAdjustQuantityInput = {
  /** The change applied to the `available` quantity of the item at the location. */
  availableDelta: Scalars["Int"]["input"]
  /** ID of the inventory level to adjust. */
  inventoryLevelId: Scalars["ID"]["input"]
}

/** Return type for `inventoryAdjustQuantity` mutation. */
export type InventoryAdjustQuantityPayload = {
  __typename?: "InventoryAdjustQuantityPayload"
  /** Represents the updated inventory quantity of an inventory item at a specific location. */
  inventoryLevel?: Maybe<InventoryLevel>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * Represents a group of adjustments made as part of the same operation.
 *
 */
export type InventoryAdjustmentGroup = Node & {
  __typename?: "InventoryAdjustmentGroup"
  /** The app that triggered the inventory event, if one exists. */
  app?: Maybe<App>
  /** The set of inventory quantity changes that occurred in the inventory event. */
  changes: Array<InventoryChange>
  /** The date and time the inventory adjustment group was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The reason for the group of adjustments. */
  reason: Scalars["String"]["output"]
  /** The reference document URI for the changes. Denotes what's causing the change. */
  referenceDocumentUri?: Maybe<Scalars["String"]["output"]>
  /** The staff member associated with the inventory event. */
  staffMember?: Maybe<StaffMember>
}

/**
 * Represents a group of adjustments made as part of the same operation.
 *
 */
export type InventoryAdjustmentGroupChangesArgs = {
  inventoryItemIds?: InputMaybe<Array<Scalars["ID"]["input"]>>
  locationIds?: InputMaybe<Array<Scalars["ID"]["input"]>>
  quantityNames?: InputMaybe<Array<Scalars["String"]["input"]>>
}

/** Return type for `inventoryBulkAdjustQuantityAtLocation` mutation. */
export type InventoryBulkAdjustQuantityAtLocationPayload = {
  __typename?: "InventoryBulkAdjustQuantityAtLocationPayload"
  /** Represents the updated inventory quantities of an inventory item at the location. */
  inventoryLevels?: Maybe<Array<InventoryLevel>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * The input fields to specify whether the inventory item should be activated or not at the specified location.
 *
 */
export type InventoryBulkToggleActivationInput = {
  /** Whether the inventory item can be stocked at the specified location. To deactivate, set the value to false which removes an inventory item's quantities from that location, and turns off inventory at that location. */
  activate: Scalars["Boolean"]["input"]
  /** The ID of the location to modify the inventory item's stocked status. */
  locationId: Scalars["ID"]["input"]
}

/** Return type for `inventoryBulkToggleActivation` mutation. */
export type InventoryBulkToggleActivationPayload = {
  __typename?: "InventoryBulkToggleActivationPayload"
  /** The inventory item that was updated. */
  inventoryItem?: Maybe<InventoryItem>
  /** The activated inventory levels. */
  inventoryLevels?: Maybe<Array<InventoryLevel>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<InventoryBulkToggleActivationUserError>
}

/** An error that occurred while setting the activation status of an inventory item. */
export type InventoryBulkToggleActivationUserError = DisplayableError & {
  __typename?: "InventoryBulkToggleActivationUserError"
  /** The error code. */
  code?: Maybe<InventoryBulkToggleActivationUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `InventoryBulkToggleActivationUserError`. */
export enum InventoryBulkToggleActivationUserErrorCode {
  /** Cannot unstock an inventory item from the only location at which it is stocked. */
  CannotDeactivateFromOnlyLocation = "CANNOT_DEACTIVATE_FROM_ONLY_LOCATION",
  /**
   * Cannot unstock this inventory item from this location because it has committed and incoming quantities.
   * @deprecated This error code is deprecated. Both INCOMING_INVENTORY_AT_LOCATION and COMMITTED_INVENTORY_AT_LOCATION codes will be returned as individual errors instead.
   */
  CommittedAndIncomingInventoryAtLocation = "COMMITTED_AND_INCOMING_INVENTORY_AT_LOCATION",
  /** Cannot unstock this inventory item from this location because it has committed quantities. */
  CommittedInventoryAtLocation = "COMMITTED_INVENTORY_AT_LOCATION",
  /** Failed to stock this inventory item at this location. */
  FailedToStockAtLocation = "FAILED_TO_STOCK_AT_LOCATION",
  /** Failed to unstock this inventory item from this location. */
  FailedToUnstockFromLocation = "FAILED_TO_UNSTOCK_FROM_LOCATION",
  /** An error occurred while setting the activation status. */
  GenericError = "GENERIC_ERROR",
  /** Cannot unstock this inventory item from this location because it has incoming quantities. */
  IncomingInventoryAtLocation = "INCOMING_INVENTORY_AT_LOCATION",
  /** The inventory item was not found. */
  InventoryItemNotFound = "INVENTORY_ITEM_NOT_FOUND",
  /** Cannot stock this inventory item at this location because it is managed by a third-party fulfillment service. */
  InventoryManagedBy_3RdParty = "INVENTORY_MANAGED_BY_3RD_PARTY",
  /** Cannot stock this inventory item at this location because it is managed by Shopify. */
  InventoryManagedByShopify = "INVENTORY_MANAGED_BY_SHOPIFY",
  /** The location was not found. */
  LocationNotFound = "LOCATION_NOT_FOUND",
  /** Cannot stock this inventory item at this location because the variant is missing a SKU. */
  MissingSku = "MISSING_SKU",
  /** Cannot unstock this inventory item from this location because it has unavailable quantities. */
  ReservedInventoryAtLocation = "RESERVED_INVENTORY_AT_LOCATION",
}

/**
 * Represents a change in an inventory quantity of an inventory item at a location.
 *
 */
export type InventoryChange = {
  __typename?: "InventoryChange"
  /** The amount by which the inventory quantity was changed. */
  delta: Scalars["Int"]["output"]
  /** The inventory item associated with this inventory change. */
  item?: Maybe<InventoryItem>
  /** The ledger document URI for the change. Denotes who the change is applied to. */
  ledgerDocumentUri?: Maybe<Scalars["String"]["output"]>
  /** The location associated with this inventory change. */
  location?: Maybe<Location>
  /**
   * The [name](https://shopify.dev/docs/apps/fulfillment/inventory-management-apps#inventory-states)
   * of the inventory quantity that was changed.
   *
   */
  name: Scalars["String"]["output"]
  /** The quantity of named inventory after the change. */
  quantityAfterChange?: Maybe<Scalars["Int"]["output"]>
}

/**
 * The input fields for the change to be made to an inventory item at a location.
 *
 */
export type InventoryChangeInput = {
  /** The amount by which the inventory quantity will be changed. */
  delta: Scalars["Int"]["input"]
  /** Specifies the inventory item to which the change will be applied. */
  inventoryItemId: Scalars["ID"]["input"]
  /** The ledger document URI to which the quantity change is being applied. Not allowed for 'available' and required for other quantity names. */
  ledgerDocumentUri?: InputMaybe<Scalars["String"]["input"]>
  /** Specifies the location at which the change will be applied. */
  locationId: Scalars["ID"]["input"]
}

/** Return type for `inventoryDeactivate` mutation. */
export type InventoryDeactivatePayload = {
  __typename?: "InventoryDeactivatePayload"
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * Represents the goods available to be shipped to a customer.
 * It holds essential information about the goods, including SKU and whether it is tracked.
 *
 */
export type InventoryItem = LegacyInteroperability &
  Node & {
    __typename?: "InventoryItem"
    /** The ISO 3166-1 alpha-2 country code of where the item originated from. */
    countryCodeOfOrigin?: Maybe<CountryCode>
    /** A list of country specific harmonized system codes. */
    countryHarmonizedSystemCodes: CountryHarmonizedSystemCodeConnection
    /** The date and time when the inventory item was created. */
    createdAt: Scalars["DateTime"]["output"]
    /** The number of inventory items that share the same SKU with this item. */
    duplicateSkuCount: Scalars["Int"]["output"]
    /** The harmonized system code of the item. */
    harmonizedSystemCode?: Maybe<Scalars["String"]["output"]>
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The URL that points to the inventory history for the item. */
    inventoryHistoryUrl?: Maybe<Scalars["URL"]["output"]>
    /** The inventory item's quantities at the specified location. */
    inventoryLevel?: Maybe<InventoryLevel>
    /** A list of the inventory item's quantities for each location that the inventory item can be stocked at. */
    inventoryLevels: InventoryLevelConnection
    /** The ID of the corresponding resource in the REST Admin API. */
    legacyResourceId: Scalars["UnsignedInt64"]["output"]
    /** The number of locations where this inventory item is stocked. */
    locationsCount: Scalars["Int"]["output"]
    /** The ISO 3166-2 alpha-2 province code of where the item originated from. */
    provinceCodeOfOrigin?: Maybe<Scalars["String"]["output"]>
    /** Whether the inventory item requires shipping. */
    requiresShipping: Scalars["Boolean"]["output"]
    /** Inventory item SKU. Case-sensitive string. */
    sku?: Maybe<Scalars["String"]["output"]>
    /** Whether inventory levels are tracked for the item. */
    tracked: Scalars["Boolean"]["output"]
    /** Whether the value of the `tracked` field for the inventory item can be changed. */
    trackedEditable: EditableProperty
    /** Unit cost associated with the inventory item. Note: the user must have "View product costs" permission granted in order to access this field once product granular permissions are enabled. */
    unitCost?: Maybe<MoneyV2>
    /** The date and time when the inventory item was updated. */
    updatedAt: Scalars["DateTime"]["output"]
    /** The variant that owns this inventory item. */
    variant: ProductVariant
  }

/**
 * Represents the goods available to be shipped to a customer.
 * It holds essential information about the goods, including SKU and whether it is tracked.
 *
 */
export type InventoryItemCountryHarmonizedSystemCodesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents the goods available to be shipped to a customer.
 * It holds essential information about the goods, including SKU and whether it is tracked.
 *
 */
export type InventoryItemInventoryLevelArgs = {
  locationId: Scalars["ID"]["input"]
}

/**
 * Represents the goods available to be shipped to a customer.
 * It holds essential information about the goods, including SKU and whether it is tracked.
 *
 */
export type InventoryItemInventoryLevelsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple InventoryItems.
 *
 */
export type InventoryItemConnection = {
  __typename?: "InventoryItemConnection"
  /** A list of edges. */
  edges: Array<InventoryItemEdge>
  /** A list of the nodes contained in InventoryItemEdge. */
  nodes: Array<InventoryItem>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one InventoryItem and a cursor during pagination.
 *
 */
export type InventoryItemEdge = {
  __typename?: "InventoryItemEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of InventoryItemEdge. */
  node: InventoryItem
}

/** The input fields for an inventory item. */
export type InventoryItemInput = {
  /** Unit cost associated with the inventory item, the currency is the shop's default currency. */
  cost?: InputMaybe<Scalars["Decimal"]["input"]>
  /** Whether the inventory item is tracked. */
  tracked?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** The input fields for an inventory item. */
export type InventoryItemUpdateInput = {
  /** Unit cost associated with the inventory item, the currency is the shop's default currency. */
  cost?: InputMaybe<Scalars["Decimal"]["input"]>
  /** The ISO 3166-1 alpha-2 country code of where the item originated from. */
  countryCodeOfOrigin?: InputMaybe<CountryCode>
  /** List of country-specific harmonized system codes. */
  countryHarmonizedSystemCodes?: InputMaybe<Array<CountryHarmonizedSystemCodeInput>>
  /** The harmonized system code of the inventory item. This must be a number between 6 and 13 digits. */
  harmonizedSystemCode?: InputMaybe<Scalars["String"]["input"]>
  /** The ISO 3166-2 alpha-2 province/state code of where the item originated from. */
  provinceCodeOfOrigin?: InputMaybe<Scalars["String"]["input"]>
  /** Whether the inventory item is tracked. The value must be true to adjust the item's inventory levels. */
  tracked?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Return type for `inventoryItemUpdate` mutation. */
export type InventoryItemUpdatePayload = {
  __typename?: "InventoryItemUpdatePayload"
  /** The inventory item that was updated. */
  inventoryItem?: Maybe<InventoryItem>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * The quantities of an inventory item that are related to a specific location.
 *
 */
export type InventoryLevel = Node & {
  __typename?: "InventoryLevel"
  /**
   * The quantity of inventory items that are available at the inventory level's associated location.
   * @deprecated Use the `quantities` field instead and specify available for names. Example: `quantities(names:["available"]){name quantity}`.
   *
   */
  available: Scalars["Int"]["output"]
  /** Whether the inventory items associated with the inventory level can be deactivated. */
  canDeactivate: Scalars["Boolean"]["output"]
  /** The date and time when the inventory level was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** Describes either the impact of deactivating the inventory level, or why the inventory level can't be deactivated. */
  deactivationAlert?: Maybe<Scalars["String"]["output"]>
  /**
   * Describes, in HTML with embedded URLs, either the impact of deactivating the inventory level or why the inventory level can't be deactivated.
   * @deprecated Use `deactivationAlert` instead.
   */
  deactivationAlertHtml?: Maybe<Scalars["FormattedString"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /**
   * The quantity of inventory items that are going to the inventory level's associated location.
   * @deprecated Use the `quantities` field instead and specify incoming for names. Example: `quantities(names:["incoming"]){name quantity}`.
   *
   */
  incoming: Scalars["Int"]["output"]
  /** Inventory item associated with the inventory level. */
  item: InventoryItem
  /** The location associated with the inventory level. */
  location: Location
  /** Quantities for the requested names. */
  quantities: Array<InventoryQuantity>
  /** Scheduled changes for the requested quantity names. */
  scheduledChanges: InventoryScheduledChangeConnection
  /** The date and time when the inventory level was updated. */
  updatedAt: Scalars["DateTime"]["output"]
}

/**
 * The quantities of an inventory item that are related to a specific location.
 *
 */
export type InventoryLevelQuantitiesArgs = {
  names: Array<Scalars["String"]["input"]>
}

/**
 * The quantities of an inventory item that are related to a specific location.
 *
 */
export type InventoryLevelScheduledChangesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<ScheduledChangeSortKeys>
}

/**
 * An auto-generated type for paginating through multiple InventoryLevels.
 *
 */
export type InventoryLevelConnection = {
  __typename?: "InventoryLevelConnection"
  /** A list of edges. */
  edges: Array<InventoryLevelEdge>
  /** A list of the nodes contained in InventoryLevelEdge. */
  nodes: Array<InventoryLevel>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one InventoryLevel and a cursor during pagination.
 *
 */
export type InventoryLevelEdge = {
  __typename?: "InventoryLevelEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of InventoryLevelEdge. */
  node: InventoryLevel
}

/** The input fields for an inventory level. */
export type InventoryLevelInput = {
  /** The available quantity of an inventory item at a location. */
  availableQuantity: Scalars["Int"]["input"]
  /** The ID of a location. */
  locationId: Scalars["ID"]["input"]
}

/** The input fields required to move inventory quantities. */
export type InventoryMoveQuantitiesInput = {
  /** The quantity changes of items at locations to be made. */
  changes: Array<InventoryMoveQuantityChange>
  /**
   * The reason for the quantity changes. The value must be one of the [possible
   * reasons](https://shopify.dev/docs/apps/fulfillment/inventory-management-apps/quantities-states#set-inventory-quantities-on-hand).
   *
   */
  reason: Scalars["String"]["input"]
  /** The reference document URI for the changes. Used to denote what's causing the change. */
  referenceDocumentUri: Scalars["String"]["input"]
}

/** Return type for `inventoryMoveQuantities` mutation. */
export type InventoryMoveQuantitiesPayload = {
  __typename?: "InventoryMoveQuantitiesPayload"
  /** The group of changes made by the operation. */
  inventoryAdjustmentGroup?: Maybe<InventoryAdjustmentGroup>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<InventoryMoveQuantitiesUserError>
}

/** An error that occurs during the execution of `InventoryMoveQuantities`. */
export type InventoryMoveQuantitiesUserError = DisplayableError & {
  __typename?: "InventoryMoveQuantitiesUserError"
  /** The error code. */
  code?: Maybe<InventoryMoveQuantitiesUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `InventoryMoveQuantitiesUserError`. */
export enum InventoryMoveQuantitiesUserErrorCode {
  /** The quantities can't be moved between different locations. */
  DifferentLocations = "DIFFERENT_LOCATIONS",
  /** Internal (gid://shopify/) ledger documents are not allowed to be adjusted via API. */
  InternalLedgerDocument = "INTERNAL_LEDGER_DOCUMENT",
  /** A ledger document URI is not allowed when adjusting available. */
  InvalidAvailableDocument = "INVALID_AVAILABLE_DOCUMENT",
  /** The specified inventory item could not be found. */
  InvalidInventoryItem = "INVALID_INVENTORY_ITEM",
  /** The specified ledger document is invalid. */
  InvalidLedgerDocument = "INVALID_LEDGER_DOCUMENT",
  /** The specified location could not be found. */
  InvalidLocation = "INVALID_LOCATION",
  /** A ledger document URI is required except when adjusting available. */
  InvalidQuantityDocument = "INVALID_QUANTITY_DOCUMENT",
  /** The specified quantity name is invalid. */
  InvalidQuantityName = "INVALID_QUANTITY_NAME",
  /** The quantity can't be negative. */
  InvalidQuantityNegative = "INVALID_QUANTITY_NEGATIVE",
  /** The quantity can't be higher than 2,000,000,000. */
  InvalidQuantityTooHigh = "INVALID_QUANTITY_TOO_HIGH",
  /** The specified reason is invalid. */
  InvalidReason = "INVALID_REASON",
  /** The specified reference document is invalid. */
  InvalidReferenceDocument = "INVALID_REFERENCE_DOCUMENT",
  /** The inventory item is not stocked at the location. */
  ItemNotStockedAtLocation = "ITEM_NOT_STOCKED_AT_LOCATION",
  /** Only a maximum of 2 ledger document URIs across all changes is allowed. */
  MaximumLedgerDocumentUris = "MAXIMUM_LEDGER_DOCUMENT_URIS",
  /** The quantities couldn't be moved. Try again. */
  MoveQuantitiesFailed = "MOVE_QUANTITIES_FAILED",
  /** The specified inventory item is not allowed to be adjusted via API. */
  NonMutableInventoryItem = "NON_MUTABLE_INVENTORY_ITEM",
  /** The quantity names for each change can't be the same. */
  SameQuantityName = "SAME_QUANTITY_NAME",
}

/**
 * Represents the change to be made to an inventory item at a location.
 * The change can either involve the same quantity name between different locations,
 * or involve different quantity names between the same location.
 *
 */
export type InventoryMoveQuantityChange = {
  /** Details about where the move will be made from. */
  from: InventoryMoveQuantityTerminalInput
  /** Specifies the inventory item to which the change will be applied. */
  inventoryItemId: Scalars["ID"]["input"]
  /** The amount by which the inventory quantity will be changed. */
  quantity: Scalars["Int"]["input"]
  /** Details about where the move will be made to. */
  to: InventoryMoveQuantityTerminalInput
}

/**
 * The input fields representing the change to be made to an inventory item at a location.
 *
 */
export type InventoryMoveQuantityTerminalInput = {
  /** The ledger document URI for the quantity move. Not allowed for 'available' and required for other quantity names. */
  ledgerDocumentUri?: InputMaybe<Scalars["String"]["input"]>
  /** Specifies the location at which the change will be applied. */
  locationId: Scalars["ID"]["input"]
  /**
   * The quantity
   * [name](https://shopify.dev/docs/apps/fulfillment/inventory-management-apps#inventory-states) to be
   * moved.
   *
   */
  name: Scalars["String"]["input"]
}

/** General inventory properties for the shop. */
export type InventoryProperties = {
  __typename?: "InventoryProperties"
  /** All the quantity names. */
  quantityNames: Array<InventoryQuantityName>
}

/**
 * Represents a quantity of an inventory item at a specific location, for a specific name.
 *
 */
export type InventoryQuantity = Node & {
  __typename?: "InventoryQuantity"
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /**
   * The [name](https://shopify.dev/docs/apps/fulfillment/inventory-management-apps#inventory-states)
   * that identifies the inventory quantity.
   *
   */
  name: Scalars["String"]["output"]
  /** The quantity for the quantity name. */
  quantity: Scalars["Int"]["output"]
  /** When the quantity was last updated. */
  updatedAt?: Maybe<Scalars["DateTime"]["output"]>
}

/** Details about an individual quantity name. */
export type InventoryQuantityName = {
  __typename?: "InventoryQuantityName"
  /** List of quantity names that this quantity name belongs to. */
  belongsTo: Array<Scalars["String"]["output"]>
  /** List of quantity names that comprise this quantity name. */
  comprises: Array<Scalars["String"]["output"]>
  /** The display name for quantity names translated into applicable language. */
  displayName?: Maybe<Scalars["String"]["output"]>
  /** Whether the quantity name has been used by the merchant. */
  isInUse: Scalars["Boolean"]["output"]
  /**
   * The [name](https://shopify.dev/docs/apps/fulfillment/inventory-management-apps#inventory-states) of
   * the inventory quantity. Used by
   * [inventory queries and mutations](https://shopify.dev/docs/apps/fulfillment/inventory-management-apps#graphql-queries-and-mutations).
   *
   */
  name: Scalars["String"]["output"]
}

/**
 * Returns the scheduled changes to inventory states related to the ledger document.
 *
 */
export type InventoryScheduledChange = {
  __typename?: "InventoryScheduledChange"
  /** The date and time that the scheduled change is expected to happen. */
  expectedAt: Scalars["DateTime"]["output"]
  /**
   * The quantity
   * [name](https://shopify.dev/docs/apps/fulfillment/inventory-management-apps/quantities-states#move-inventory-quantities-between-states)
   * to transition from.
   *
   */
  fromName: Scalars["String"]["output"]
  /** The quantities of an inventory item that are related to a specific location. */
  inventoryLevel: InventoryLevel
  /** An active reference document associated with the inventory quantity. Must be a valid URI. */
  ledgerDocumentUri: Scalars["URL"]["output"]
  /** The quantity of the scheduled change associated with the ledger document in the `from_name` state. */
  quantity: Scalars["Int"]["output"]
  /**
   * The quantity
   * [name](https://shopify.dev/docs/apps/fulfillment/inventory-management-apps/quantities-states#move-inventory-quantities-between-states)
   * to transition to.
   *
   */
  toName: Scalars["String"]["output"]
}

/**
 * An auto-generated type for paginating through multiple InventoryScheduledChanges.
 *
 */
export type InventoryScheduledChangeConnection = {
  __typename?: "InventoryScheduledChangeConnection"
  /** A list of edges. */
  edges: Array<InventoryScheduledChangeEdge>
  /** A list of the nodes contained in InventoryScheduledChangeEdge. */
  nodes: Array<InventoryScheduledChange>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one InventoryScheduledChange and a cursor during pagination.
 *
 */
export type InventoryScheduledChangeEdge = {
  __typename?: "InventoryScheduledChangeEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of InventoryScheduledChangeEdge. */
  node: InventoryScheduledChange
}

/** The input fields for a scheduled change of an inventory item. */
export type InventoryScheduledChangeInput = {
  /** The date and time that the scheduled change is expected to happen. */
  expectedAt: Scalars["DateTime"]["input"]
  /** The state to transition from. */
  fromName: Scalars["String"]["input"]
  /** The state to transition to. */
  toName: Scalars["String"]["input"]
}

/** The input fields for the inventory item associated with the scheduled changes that need to be applied. */
export type InventoryScheduledChangeItemInput = {
  /** The ID of the inventory item. */
  inventoryItemId: Scalars["ID"]["input"]
  /** The ledger document URI which will be used to calculate the quantity transfered. */
  ledgerDocumentUri: Scalars["URL"]["input"]
  /** The ID of the location. */
  locationId: Scalars["ID"]["input"]
  /** An array of all the scheduled changes for the item. */
  scheduledChanges: Array<InventoryScheduledChangeInput>
}

/** The input fields required to set inventory on hand quantities. */
export type InventorySetOnHandQuantitiesInput = {
  /**
   * The reason for the quantity changes. The value must be one of the [possible
   * reasons](https://shopify.dev/docs/apps/fulfillment/inventory-management-apps/quantities-states#set-inventory-quantities-on-hand).
   *
   */
  reason: Scalars["String"]["input"]
  /** The reference document URI for the changes. Used to denote what's causing the change. */
  referenceDocumentUri?: InputMaybe<Scalars["String"]["input"]>
  /** The value to which the on hand quantity will be set. */
  setQuantities: Array<InventorySetQuantityInput>
}

/** Return type for `inventorySetOnHandQuantities` mutation. */
export type InventorySetOnHandQuantitiesPayload = {
  __typename?: "InventorySetOnHandQuantitiesPayload"
  /** The group of changes made by the operation. */
  inventoryAdjustmentGroup?: Maybe<InventoryAdjustmentGroup>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<InventorySetOnHandQuantitiesUserError>
}

/** An error that occurs during the execution of `InventorySetOnHandQuantities`. */
export type InventorySetOnHandQuantitiesUserError = DisplayableError & {
  __typename?: "InventorySetOnHandQuantitiesUserError"
  /** The error code. */
  code?: Maybe<InventorySetOnHandQuantitiesUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `InventorySetOnHandQuantitiesUserError`. */
export enum InventorySetOnHandQuantitiesUserErrorCode {
  /** The specified inventory item could not be found. */
  InvalidInventoryItem = "INVALID_INVENTORY_ITEM",
  /** The specified location could not be found. */
  InvalidLocation = "INVALID_LOCATION",
  /** The quantity can't be negative. */
  InvalidQuantityNegative = "INVALID_QUANTITY_NEGATIVE",
  /** The total quantity can't be higher than 1,000,000,000. */
  InvalidQuantityTooHigh = "INVALID_QUANTITY_TOO_HIGH",
  /** The specified reason is invalid. */
  InvalidReason = "INVALID_REASON",
  /** The specified reference document is invalid. */
  InvalidReferenceDocument = "INVALID_REFERENCE_DOCUMENT",
  /** The inventory item is not stocked at the location. */
  ItemNotStockedAtLocation = "ITEM_NOT_STOCKED_AT_LOCATION",
  /** The specified inventory item is not allowed to be adjusted via API. */
  NonMutableInventoryItem = "NON_MUTABLE_INVENTORY_ITEM",
  /** The on-hand quantities couldn't be set. Try again. */
  SetOnHandQuantitiesFailed = "SET_ON_HAND_QUANTITIES_FAILED",
}

/**
 * The input fields for the quantity to be set for an inventory item at a location.
 *
 */
export type InventorySetQuantityInput = {
  /** Specifies the inventory item to which the quantity will be set. */
  inventoryItemId: Scalars["ID"]["input"]
  /** Specifies the location at which the quantity will be set. */
  locationId: Scalars["ID"]["input"]
  /** The quantity to which the inventory quantity will be set. */
  quantity: Scalars["Int"]["input"]
}

/** The input fields for setting up scheduled changes of inventory items. */
export type InventorySetScheduledChangesInput = {
  /** The list of all the items on which the scheduled changes need to be applied. */
  items: Array<InventoryScheduledChangeItemInput>
  /** The reason for setting up the scheduled changes. */
  reason: Scalars["String"]["input"]
  /** The reference document URI to indicate how the scheduled changes are related for auditing purposes. */
  referenceDocumentUri: Scalars["URL"]["input"]
}

/** Return type for `inventorySetScheduledChanges` mutation. */
export type InventorySetScheduledChangesPayload = {
  __typename?: "InventorySetScheduledChangesPayload"
  /** The scheduled changes that were created. */
  scheduledChanges?: Maybe<Array<InventoryScheduledChange>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<InventorySetScheduledChangesUserError>
}

/** An error that occurs during the execution of `InventorySetScheduledChanges`. */
export type InventorySetScheduledChangesUserError = DisplayableError & {
  __typename?: "InventorySetScheduledChangesUserError"
  /** The error code. */
  code?: Maybe<InventorySetScheduledChangesUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `InventorySetScheduledChangesUserError`. */
export enum InventorySetScheduledChangesUserErrorCode {
  /** The item can only have one scheduled change for %{from_name} as the fromName. */
  DuplicateFromName = "DUPLICATE_FROM_NAME",
  /** The item can only have one scheduled change for %{to_name} as the to_name. */
  DuplicateToName = "DUPLICATE_TO_NAME",
  /** There was an error updating the scheduled changes. */
  ErrorUpdatingScheduled = "ERROR_UPDATING_SCHEDULED",
  /** The specified field is invalid. */
  Inclusion = "INCLUSION",
  /** The specified fromName is invalid. */
  InvalidFromName = "INVALID_FROM_NAME",
  /** The specified reason is invalid. Valid values: %{reasons}. */
  InvalidReason = "INVALID_REASON",
  /** The specified toName is invalid. */
  InvalidToName = "INVALID_TO_NAME",
  /** The inventory item was not found. */
  InventoryItemNotFound = "INVENTORY_ITEM_NOT_FOUND",
  /** The inventory item was not found at the location specified. */
  InventoryStateNotFound = "INVENTORY_STATE_NOT_FOUND",
  /** At least 1 item must be provided. */
  ItemsEmpty = "ITEMS_EMPTY",
  /** The location couldn't be found. */
  LocationNotFound = "LOCATION_NOT_FOUND",
  /** The from_name and to_name can't be the same. */
  SameFromToNames = "SAME_FROM_TO_NAMES",
}

/** A job corresponds to some long running task that the client should poll for status. */
export type Job = {
  __typename?: "Job"
  /** This indicates if the job is still queued or has been run. */
  done: Scalars["Boolean"]["output"]
  /** A globally-unique ID that's returned when running an asynchronous mutation. */
  id: Scalars["ID"]["output"]
  /** This field will only resolve once the job is done. Can be used to ask for object(s) that have been changed by the job. */
  query?: Maybe<QueryRoot>
}

/** A job corresponds to some long running task that the client should poll for status. */
export type JobResult = {
  /** This indicates if the job is still queued or has been run. */
  done: Scalars["Boolean"]["output"]
  /** A globally-unique ID that's returned when running an asynchronous mutation. */
  id: Scalars["ID"]["output"]
}

/** ISO 639-1 language codes supported by Shopify. */
export enum LanguageCode {
  /** Afrikaans. */
  Af = "AF",
  /** Akan. */
  Ak = "AK",
  /** Amharic. */
  Am = "AM",
  /** Arabic. */
  Ar = "AR",
  /** Assamese. */
  As = "AS",
  /** Azerbaijani. */
  Az = "AZ",
  /** Belarusian. */
  Be = "BE",
  /** Bulgarian. */
  Bg = "BG",
  /** Bambara. */
  Bm = "BM",
  /** Bangla. */
  Bn = "BN",
  /** Tibetan. */
  Bo = "BO",
  /** Breton. */
  Br = "BR",
  /** Bosnian. */
  Bs = "BS",
  /** Catalan. */
  Ca = "CA",
  /** Chechen. */
  Ce = "CE",
  /** Czech. */
  Cs = "CS",
  /** Church Slavic. */
  Cu = "CU",
  /** Welsh. */
  Cy = "CY",
  /** Danish. */
  Da = "DA",
  /** German. */
  De = "DE",
  /** Dzongkha. */
  Dz = "DZ",
  /** Ewe. */
  Ee = "EE",
  /** Greek. */
  El = "EL",
  /** English. */
  En = "EN",
  /** Esperanto. */
  Eo = "EO",
  /** Spanish. */
  Es = "ES",
  /** Estonian. */
  Et = "ET",
  /** Basque. */
  Eu = "EU",
  /** Persian. */
  Fa = "FA",
  /** Fulah. */
  Ff = "FF",
  /** Finnish. */
  Fi = "FI",
  /** Faroese. */
  Fo = "FO",
  /** French. */
  Fr = "FR",
  /** Western Frisian. */
  Fy = "FY",
  /** Irish. */
  Ga = "GA",
  /** Scottish Gaelic. */
  Gd = "GD",
  /** Galician. */
  Gl = "GL",
  /** Gujarati. */
  Gu = "GU",
  /** Manx. */
  Gv = "GV",
  /** Hausa. */
  Ha = "HA",
  /** Hebrew. */
  He = "HE",
  /** Hindi. */
  Hi = "HI",
  /** Croatian. */
  Hr = "HR",
  /** Hungarian. */
  Hu = "HU",
  /** Armenian. */
  Hy = "HY",
  /** Interlingua. */
  Ia = "IA",
  /** Indonesian. */
  Id = "ID",
  /** Igbo. */
  Ig = "IG",
  /** Sichuan Yi. */
  Ii = "II",
  /** Icelandic. */
  Is = "IS",
  /** Italian. */
  It = "IT",
  /** Japanese. */
  Ja = "JA",
  /** Javanese. */
  Jv = "JV",
  /** Georgian. */
  Ka = "KA",
  /** Kikuyu. */
  Ki = "KI",
  /** Kazakh. */
  Kk = "KK",
  /** Kalaallisut. */
  Kl = "KL",
  /** Khmer. */
  Km = "KM",
  /** Kannada. */
  Kn = "KN",
  /** Korean. */
  Ko = "KO",
  /** Kashmiri. */
  Ks = "KS",
  /** Kurdish. */
  Ku = "KU",
  /** Cornish. */
  Kw = "KW",
  /** Kyrgyz. */
  Ky = "KY",
  /** Luxembourgish. */
  Lb = "LB",
  /** Ganda. */
  Lg = "LG",
  /** Lingala. */
  Ln = "LN",
  /** Lao. */
  Lo = "LO",
  /** Lithuanian. */
  Lt = "LT",
  /** Luba-Katanga. */
  Lu = "LU",
  /** Latvian. */
  Lv = "LV",
  /** Malagasy. */
  Mg = "MG",
  /** Māori. */
  Mi = "MI",
  /** Macedonian. */
  Mk = "MK",
  /** Malayalam. */
  Ml = "ML",
  /** Mongolian. */
  Mn = "MN",
  /** Marathi. */
  Mr = "MR",
  /** Malay. */
  Ms = "MS",
  /** Maltese. */
  Mt = "MT",
  /** Burmese. */
  My = "MY",
  /** Norwegian (Bokmål). */
  Nb = "NB",
  /** North Ndebele. */
  Nd = "ND",
  /** Nepali. */
  Ne = "NE",
  /** Dutch. */
  Nl = "NL",
  /** Norwegian Nynorsk. */
  Nn = "NN",
  /** Norwegian. */
  No = "NO",
  /** Oromo. */
  Om = "OM",
  /** Odia. */
  Or = "OR",
  /** Ossetic. */
  Os = "OS",
  /** Punjabi. */
  Pa = "PA",
  /** Polish. */
  Pl = "PL",
  /** Pashto. */
  Ps = "PS",
  /** Portuguese. */
  Pt = "PT",
  /** Portuguese (Brazil). */
  PtBr = "PT_BR",
  /** Portuguese (Portugal). */
  PtPt = "PT_PT",
  /** Quechua. */
  Qu = "QU",
  /** Romansh. */
  Rm = "RM",
  /** Rundi. */
  Rn = "RN",
  /** Romanian. */
  Ro = "RO",
  /** Russian. */
  Ru = "RU",
  /** Kinyarwanda. */
  Rw = "RW",
  /** Sindhi. */
  Sd = "SD",
  /** Northern Sami. */
  Se = "SE",
  /** Sango. */
  Sg = "SG",
  /** Sinhala. */
  Si = "SI",
  /** Slovak. */
  Sk = "SK",
  /** Slovenian. */
  Sl = "SL",
  /** Shona. */
  Sn = "SN",
  /** Somali. */
  So = "SO",
  /** Albanian. */
  Sq = "SQ",
  /** Serbian. */
  Sr = "SR",
  /** Sundanese. */
  Su = "SU",
  /** Swedish. */
  Sv = "SV",
  /** Swahili. */
  Sw = "SW",
  /** Tamil. */
  Ta = "TA",
  /** Telugu. */
  Te = "TE",
  /** Tajik. */
  Tg = "TG",
  /** Thai. */
  Th = "TH",
  /** Tigrinya. */
  Ti = "TI",
  /** Turkmen. */
  Tk = "TK",
  /** Tongan. */
  To = "TO",
  /** Turkish. */
  Tr = "TR",
  /** Tatar. */
  Tt = "TT",
  /** Uyghur. */
  Ug = "UG",
  /** Ukrainian. */
  Uk = "UK",
  /** Urdu. */
  Ur = "UR",
  /** Uzbek. */
  Uz = "UZ",
  /** Vietnamese. */
  Vi = "VI",
  /** Volapük. */
  Vo = "VO",
  /** Wolof. */
  Wo = "WO",
  /** Xhosa. */
  Xh = "XH",
  /** Yiddish. */
  Yi = "YI",
  /** Yoruba. */
  Yo = "YO",
  /** Chinese. */
  Zh = "ZH",
  /** Chinese (Simplified). */
  ZhCn = "ZH_CN",
  /** Chinese (Traditional). */
  ZhTw = "ZH_TW",
  /** Zulu. */
  Zu = "ZU",
}

/**
 * Interoperability metadata for types that directly correspond to a REST Admin API resource.
 * For example, on the Product type, LegacyInteroperability returns metadata for the corresponding [Product object](https://shopify.dev/api/admin-graphql/latest/objects/product) in the REST Admin API.
 *
 */
export type LegacyInteroperability = {
  /** The ID of the corresponding resource in the REST Admin API. */
  legacyResourceId: Scalars["UnsignedInt64"]["output"]
}

/** Units of measurement for length. */
export enum LengthUnit {
  /** 100 centimeters equals 1 meter. */
  Centimeters = "CENTIMETERS",
  /** Imperial system unit of length. */
  Feet = "FEET",
  /** 12 inches equals 1 foot. */
  Inches = "INCHES",
  /** Metric system unit of length. */
  Meters = "METERS",
  /** 1000 millimeters equals 1 meter. */
  Millimeters = "MILLIMETERS",
  /** 1 yard equals 3 feet. */
  Yards = "YARDS",
}

/**
 * The total number of pending orders on a shop if less then a maximum, or that maximum.
 * The atMax field indicates when this maximum has been reached.
 *
 */
export type LimitedPendingOrderCount = {
  __typename?: "LimitedPendingOrderCount"
  /** This is set when the number of pending orders has reached the maximum. */
  atMax: Scalars["Boolean"]["output"]
  /**
   * The number of pendings orders on the shop.
   * Limited to a maximum of 10000.
   *
   */
  count: Scalars["Int"]["output"]
}

/** Represents individual products and quantities purchased in the associated order. */
export type LineItem = Node & {
  __typename?: "LineItem"
  /**
   * Whether the line item can be restocked.
   * @deprecated Use `restockable` instead.
   */
  canRestock: Scalars["Boolean"]["output"]
  /** The subscription contract associated with this line item. */
  contract?: Maybe<SubscriptionContract>
  /** The line item's quantity, minus the removed quantity. */
  currentQuantity: Scalars["Int"]["output"]
  /** A list of attributes that represent custom features or special requests. */
  customAttributes: Array<Attribute>
  /** The discounts that have been allocated onto the line item by discount applications, not including order edits and refunds. */
  discountAllocations: Array<DiscountAllocation>
  /**
   * The total line price after discounts are applied, in shop currency.
   * @deprecated Use `discountedTotalSet` instead.
   */
  discountedTotal: Scalars["Money"]["output"]
  /** The total line price after discounts are applied, in shop and presentment currencies. */
  discountedTotalSet: MoneyBag
  /**
   * The approximate split price of a line item unit, in shop currency. This value doesn't include discounts applied to the entire order.
   * @deprecated Use `discountedUnitPriceSet` instead.
   */
  discountedUnitPrice: Scalars["Money"]["output"]
  /** The approximate split price of the line item, including any discounts that apply to the entire order. */
  discountedUnitPriceAfterAllDiscountsSet: MoneyBag
  /** The approximate split price of a line item unit, in shop and presentment currencies. This value doesn't include discounts applied to the entire order. */
  discountedUnitPriceSet: MoneyBag
  /** The duties associated with the line item. */
  duties: Array<Duty>
  /**
   * The total number of units to fulfill.
   * @deprecated Use [FulfillmentOrderLineItem#remainingQuantity](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentOrderLineItem#field-fulfillmentorderlineitem-remainingquantity) instead.
   */
  fulfillableQuantity: Scalars["Int"]["output"]
  /**
   * The fulfillment service that stocks the product variant belonging to a line item.
   *
   * This is a third-party fulfillment service in the following scenarios:
   *
   * **Scenario 1**
   * - The product variant is stocked by a single fulfillment service.
   * - The [FulfillmentService](/api/admin-graphql/latest/objects/FulfillmentService) is a third-party fulfillment service. Third-party fulfillment services don't have a handle with the value `manual`.
   *
   * **Scenario 2**
   * - Multiple fulfillment services stock the product variant.
   * - The last time that the line item was unfulfilled, it was awaiting fulfillment by a third-party fulfillment service. Third-party fulfillment services don't have a handle with the value `manual`.
   *
   * If none of the above conditions are met, then the fulfillment service has the `manual` handle.
   *
   * @deprecated
   * The [relationship between a product variant and a fulfillment service was changed in the `2022-07` API version](/changelog/fulfillment-service-sku-sharing). A [ProductVariant](/api/admin-graphql/latest/objects/ProductVariant) can be stocked by multiple fulfillment services. As a result, we recommend that you use the [inventoryItem field](/api/admin-graphql/latest/objects/ProductVariant#field-productvariant-inventoryitem) if you need to determine where a product variant is stocked.
   *
   * If you need to determine whether a product is a gift card, then you should continue to use this field until an alternative is available.
   *
   * Altering the locations which stock a product variant won't change the value of this field for existing orders.
   *
   * Learn about [managing inventory quantities and states](/apps/fulfillment/inventory-management-apps/quantities-states).
   *
   */
  fulfillmentService?: Maybe<FulfillmentService>
  /**
   * The line item's fulfillment status. Returns 'fulfilled' if fulfillableQuantity >= quantity,
   * 'partial' if  fulfillableQuantity > 0, and 'unfulfilled' otherwise.
   *
   * @deprecated Use [FulfillmentOrderLineItem#remainingQuantity](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentOrderLineItem#field-fulfillmentorderlineitem-remainingquantity) instead
   */
  fulfillmentStatus: Scalars["String"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The image associated to the line item's variant. */
  image?: Maybe<Image>
  /** The line item group associated to the line item. */
  lineItemGroup?: Maybe<LineItemGroup>
  /** Whether the line item can be edited or not. */
  merchantEditable: Scalars["Boolean"]["output"]
  /** The title of the product, optionally appended with the title of the variant (if applicable). */
  name: Scalars["String"]["output"]
  /** The total number of units that can't be fulfilled. For example, if items have been refunded, or the item is not something that can be fulfilled, like a tip. Please see the [FulfillmentOrder](https://shopify.dev/api/admin-graphql/latest/objects/FulfillmentOrder) object for more fulfillment details. */
  nonFulfillableQuantity: Scalars["Int"]["output"]
  /**
   * The total price without discounts applied, in shop currency.
   * This value is based on the unit price of the variant x quantity.
   *
   * @deprecated Use `originalTotalSet` instead.
   */
  originalTotal: Scalars["Money"]["output"]
  /** The total price in shop and presentment currencies, without discounts applied. This value is based on the unit price of the variant x quantity. */
  originalTotalSet: MoneyBag
  /**
   * The variant unit price without discounts applied, in shop currency.
   * @deprecated Use `originalUnitPriceSet` instead.
   */
  originalUnitPrice: Scalars["Money"]["output"]
  /** The variant unit price without discounts applied, in shop and presentment currencies. */
  originalUnitPriceSet: MoneyBag
  /** The Product object associated with this line item's variant. */
  product?: Maybe<Product>
  /** The number of variant units ordered. */
  quantity: Scalars["Int"]["output"]
  /** The line item's quantity, minus the refunded quantity. */
  refundableQuantity: Scalars["Int"]["output"]
  /** Whether physical shipping is required for the variant. */
  requiresShipping: Scalars["Boolean"]["output"]
  /** Whether the line item can be restocked. */
  restockable: Scalars["Boolean"]["output"]
  /** The selling plan details associated with the line item. */
  sellingPlan?: Maybe<LineItemSellingPlan>
  /** The variant SKU number. */
  sku?: Maybe<Scalars["String"]["output"]>
  /** Staff attributed to the line item. */
  staffMember?: Maybe<StaffMember>
  /** The taxes charged for this line item. */
  taxLines: Array<TaxLine>
  /** Whether the variant is taxable. */
  taxable: Scalars["Boolean"]["output"]
  /** The title of the product at time of order creation. */
  title: Scalars["String"]["output"]
  /**
   * The total amount of the discount allocated to the line item in the shop currency.
   * @deprecated Use `totalDiscountSet` instead.
   */
  totalDiscount: Scalars["Money"]["output"]
  /** The total amount of the discount that's allocated to the line item, in the shop and presentment currencies. This field must be explicitly set using draft orders, Shopify scripts, or the API. */
  totalDiscountSet: MoneyBag
  /**
   * The total discounted value of unfulfilled units, in shop currency.
   * @deprecated Use `unfulfilledDiscountedTotalSet` instead.
   */
  unfulfilledDiscountedTotal: Scalars["Money"]["output"]
  /** The total discounted value of unfulfilled units, in shop and presentment currencies. */
  unfulfilledDiscountedTotalSet: MoneyBag
  /**
   * The total price, without any discounts applied. This value is based on the unit price of the variant x quantity of all unfulfilled units, in shop currency.
   * @deprecated Use `unfulfilledOriginalTotalSet` instead.
   */
  unfulfilledOriginalTotal: Scalars["Money"]["output"]
  /** The total price, without any discounts applied. This value is based on the unit price of the variant x quantity of all unfulfilled units, in shop and presentment currencies. */
  unfulfilledOriginalTotalSet: MoneyBag
  /** The number of units not yet fulfilled. */
  unfulfilledQuantity: Scalars["Int"]["output"]
  /** The Variant object associated with this line item. */
  variant?: Maybe<ProductVariant>
  /** The title of the variant at time of order creation. */
  variantTitle?: Maybe<Scalars["String"]["output"]>
  /** The name of the vendor who made the variant. */
  vendor?: Maybe<Scalars["String"]["output"]>
}

/** Represents individual products and quantities purchased in the associated order. */
export type LineItemTaxLinesArgs = {
  first?: InputMaybe<Scalars["Int"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple LineItems.
 *
 */
export type LineItemConnection = {
  __typename?: "LineItemConnection"
  /** A list of edges. */
  edges: Array<LineItemEdge>
  /** A list of the nodes contained in LineItemEdge. */
  nodes: Array<LineItem>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one LineItem and a cursor during pagination.
 *
 */
export type LineItemEdge = {
  __typename?: "LineItemEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of LineItemEdge. */
  node: LineItem
}

/** A line item group (bundle) to which a line item belongs to. */
export type LineItemGroup = {
  __typename?: "LineItemGroup"
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** Quantity of the line item group on the order. */
  quantity: Scalars["Int"]["output"]
  /** Title of the line item group. */
  title: Scalars["String"]["output"]
  /** ID of the variant of the line item group. */
  variantId?: Maybe<Scalars["ID"]["output"]>
  /** SKU of the variant of the line item group. */
  variantSku?: Maybe<Scalars["String"]["output"]>
}

/** Represents a single line item on an order. */
export type LineItemMutable = Node & {
  __typename?: "LineItemMutable"
  /**
   * Whether the line item can be restocked.
   * @deprecated Use `restockable` instead.
   */
  canRestock: Scalars["Boolean"]["output"]
  /** A list of attributes that represent custom features or special requests. */
  customAttributes: Array<Attribute>
  /** The discounts that have been allocated onto the line item by discount applications. */
  discountAllocations: Array<DiscountAllocation>
  /**
   * The total line price after discounts are applied, in shop currency.
   * @deprecated Use `discountedTotalSet` instead.
   */
  discountedTotal: Scalars["Money"]["output"]
  /** The total line price after discounts are applied, in shop and presentment currencies. */
  discountedTotalSet: MoneyBag
  /**
   * The approximate split price of a line item unit, in shop currency. This value doesn't include discounts applied to the entire order.
   * @deprecated Use `discountedUnitPriceSet` instead.
   */
  discountedUnitPrice: Scalars["Money"]["output"]
  /** The approximate split price of a line item unit, in shop and presentment currencies. This value doesn't include discounts applied to the entire order. */
  discountedUnitPriceSet: MoneyBag
  /** The total number of units to fulfill. */
  fulfillableQuantity: Scalars["Int"]["output"]
  /**
   * The service provider that fulfills the line item.
   *
   * Deleted fulfillment services will return null.
   *
   */
  fulfillmentService?: Maybe<FulfillmentService>
  /**
   * The line item's fulfillment status. Returns 'fulfilled' if fulfillableQuantity >= quantity,
   * 'partial' if  fulfillableQuantity > 0, and 'unfulfilled' otherwise.
   *
   */
  fulfillmentStatus: Scalars["String"]["output"]
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The image associated to the line item's variant. */
  image?: Maybe<Image>
  /** Whether the line item can be edited or not. */
  merchantEditable: Scalars["Boolean"]["output"]
  /** The name of the product. */
  name: Scalars["String"]["output"]
  /** The total number of units that can't be fulfilled. For example, if items have been refunded, or the item isn't something that can be fulfilled, like a tip. */
  nonFulfillableQuantity: Scalars["Int"]["output"]
  /**
   * The total price without any discounts applied, in shop currency. ""This value is based on the unit price of the variant x quantity.
   *
   * @deprecated Use `originalTotalSet` instead.
   */
  originalTotal: Scalars["Money"]["output"]
  /** The total price in shop and presentment currencies, without discounts applied. This value is based on the unit price of the variant x quantity. */
  originalTotalSet: MoneyBag
  /**
   * The variant unit price without discounts applied, in shop currency.
   * @deprecated Use `originalUnitPriceSet` instead.
   */
  originalUnitPrice: Scalars["Money"]["output"]
  /** The variant unit price without discounts applied, in shop and presentment currencies. */
  originalUnitPriceSet: MoneyBag
  /** The Product object associated with this line item's variant. */
  product?: Maybe<Product>
  /** The number of variant units ordered. */
  quantity: Scalars["Int"]["output"]
  /** The line item's quantity, minus the refunded quantity. */
  refundableQuantity: Scalars["Int"]["output"]
  /** Whether physical shipping is required for the variant. */
  requiresShipping: Scalars["Boolean"]["output"]
  /** Whether the line item can be restocked. */
  restockable: Scalars["Boolean"]["output"]
  /** The variant SKU number. */
  sku?: Maybe<Scalars["String"]["output"]>
  /** Staff attributed to the line item. */
  staffMember?: Maybe<StaffMember>
  /** The TaxLine object connected to this line item. */
  taxLines: Array<TaxLine>
  /** Whether the variant is taxable. */
  taxable: Scalars["Boolean"]["output"]
  /** The title of the product. */
  title: Scalars["String"]["output"]
  /**
   * The total amount of the discount allocated to the line item in the shop currency. This field must be explicitly set using draft orders, Shopify scripts, or the API. Instead of using this field, Shopify recommends using `discountAllocations`, which provides the same information.
   * @deprecated Use `totalDiscountSet` instead.
   */
  totalDiscount: Scalars["Money"]["output"]
  /** The total amount of the discount allocated to the line item in the presentment currency. This field must be explicitly set using draft orders, Shopify scripts, or the API. Instead of using this field, Shopify recommends using `discountAllocations`, which provides the same information. */
  totalDiscountSet: MoneyBag
  /**
   * The total discounted value of unfulfilled units, in shop currency.
   * @deprecated Use `unfulfilledDiscountedTotalSet` instead.
   */
  unfulfilledDiscountedTotal: Scalars["Money"]["output"]
  /** The total discounted value of unfulfilled units, in shop and presentment currencies. */
  unfulfilledDiscountedTotalSet: MoneyBag
  /**
   * The total price without any discounts applied. This value is based on the unit price of the variant x quantity of all unfulfilled units, in shop currency.
   * @deprecated Use `unfulfilledOriginalTotalSet` instead.
   */
  unfulfilledOriginalTotal: Scalars["Money"]["output"]
  /** The total price without any discounts applied. This value is based on the unit price of the variant x quantity of all unfulfilled units, in shop and presentment currencies. */
  unfulfilledOriginalTotalSet: MoneyBag
  /** The number of units not yet fulfilled. */
  unfulfilledQuantity: Scalars["Int"]["output"]
  /** The Variant object associated with this line item. */
  variant?: Maybe<ProductVariant>
  /** The name of the variant. */
  variantTitle?: Maybe<Scalars["String"]["output"]>
  /** The name of the vendor who made the variant. */
  vendor?: Maybe<Scalars["String"]["output"]>
}

/** Represents a single line item on an order. */
export type LineItemMutableTaxLinesArgs = {
  first?: InputMaybe<Scalars["Int"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple LineItemMutables.
 *
 */
export type LineItemMutableConnection = {
  __typename?: "LineItemMutableConnection"
  /** A list of edges. */
  edges: Array<LineItemMutableEdge>
  /** A list of the nodes contained in LineItemMutableEdge. */
  nodes: Array<LineItemMutable>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one LineItemMutable and a cursor during pagination.
 *
 */
export type LineItemMutableEdge = {
  __typename?: "LineItemMutableEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of LineItemMutableEdge. */
  node: LineItemMutable
}

/** Represents the selling plan for a line item. */
export type LineItemSellingPlan = {
  __typename?: "LineItemSellingPlan"
  /** The name of the selling plan for display purposes. */
  name: Scalars["String"]["output"]
  /** The ID of the selling plan associated with the line item. */
  sellingPlanId?: Maybe<Scalars["ID"]["output"]>
}

/** A link to direct users to. */
export type Link = HasPublishedTranslations & {
  __typename?: "Link"
  /** A context-sensitive label for the link. */
  label: Scalars["String"]["output"]
  /** The translations associated with the resource. */
  translations: Array<Translation>
  /** The URL that the link visits. */
  url: Scalars["URL"]["output"]
}

/** A link to direct users to. */
export type LinkTranslationsArgs = {
  locale: Scalars["String"]["input"]
  marketId?: InputMaybe<Scalars["ID"]["input"]>
}

/** A locale. */
export type Locale = {
  __typename?: "Locale"
  /** Locale ISO code. */
  isoCode: Scalars["String"]["output"]
  /** Human-readable locale name. */
  name: Scalars["String"]["output"]
}

/** Specifies the type of the underlying localizable content. This can be used to conditionally render different UI elements such as input fields. */
export enum LocalizableContentType {
  /** A file reference. */
  FileReference = "FILE_REFERENCE",
  /** An HTML. */
  Html = "HTML",
  /** An inline rich text. */
  InlineRichText = "INLINE_RICH_TEXT",
  /** A JSON. */
  Json = "JSON",
  /** A JSON string. */
  JsonString = "JSON_STRING",
  /** A list of file references. */
  ListFileReference = "LIST_FILE_REFERENCE",
  /** A list of multi-line texts. */
  ListMultiLineTextField = "LIST_MULTI_LINE_TEXT_FIELD",
  /** A list of single-line texts. */
  ListSingleLineTextField = "LIST_SINGLE_LINE_TEXT_FIELD",
  /** A list of URLs. */
  ListUrl = "LIST_URL",
  /** A multi-line text. */
  MultiLineTextField = "MULTI_LINE_TEXT_FIELD",
  /** A rich text. */
  RichTextField = "RICH_TEXT_FIELD",
  /** A single-line text. */
  SingleLineTextField = "SINGLE_LINE_TEXT_FIELD",
  /** A string. */
  String = "STRING",
  /** A URI. */
  Uri = "URI",
  /** A URL. */
  Url = "URL",
}

/** Represents the value captured by a localization extension. Localization extensions are additional fields required by certain countries on international orders. For example, some countries require additional fields for customs information or tax identification numbers. */
export type LocalizationExtension = {
  __typename?: "LocalizationExtension"
  /** Country ISO 3166-1 alpha-2 code. */
  countryCode: CountryCode
  /** The localized extension keys that are allowed. */
  key: LocalizationExtensionKey
  /** The purpose of this localization extension. */
  purpose: LocalizationExtensionPurpose
  /** The localized extension title. */
  title: Scalars["String"]["output"]
  /** The value of the field. */
  value: Scalars["String"]["output"]
}

/**
 * An auto-generated type for paginating through multiple LocalizationExtensions.
 *
 */
export type LocalizationExtensionConnection = {
  __typename?: "LocalizationExtensionConnection"
  /** A list of edges. */
  edges: Array<LocalizationExtensionEdge>
  /** A list of the nodes contained in LocalizationExtensionEdge. */
  nodes: Array<LocalizationExtension>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one LocalizationExtension and a cursor during pagination.
 *
 */
export type LocalizationExtensionEdge = {
  __typename?: "LocalizationExtensionEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of LocalizationExtensionEdge. */
  node: LocalizationExtension
}

/**
 * The input fields for a LocalizationExtensionInput.
 *
 */
export type LocalizationExtensionInput = {
  /** The key for the localization extension. */
  key: LocalizationExtensionKey
  /** The localization extension value. */
  value: Scalars["String"]["input"]
}

/** The key of a localization extension. */
export enum LocalizationExtensionKey {
  /** Extension key 'shipping_credential_br' for country BR. */
  ShippingCredentialBr = "SHIPPING_CREDENTIAL_BR",
  /** Extension key 'shipping_credential_cn' for country CN. */
  ShippingCredentialCn = "SHIPPING_CREDENTIAL_CN",
  /** Extension key 'shipping_credential_kr' for country KR. */
  ShippingCredentialKr = "SHIPPING_CREDENTIAL_KR",
  /** Extension key 'tax_credential_br' for country BR. */
  TaxCredentialBr = "TAX_CREDENTIAL_BR",
  /** Extension key 'tax_credential_it' for country IT. */
  TaxCredentialIt = "TAX_CREDENTIAL_IT",
  /** Extension key 'tax_email_it' for country IT. */
  TaxEmailIt = "TAX_EMAIL_IT",
}

/** The purpose of a localization extension. */
export enum LocalizationExtensionPurpose {
  /** Extensions that are used for shipping purposes, for example, customs clearance. */
  Shipping = "SHIPPING",
  /** Extensions that are used for taxes purposes, for example, invoicing. */
  Tax = "TAX",
}

/**
 * Represents the location where the physical good resides.
 *
 */
export type Location = HasMetafieldDefinitions &
  HasMetafields &
  LegacyInteroperability &
  Node & {
    __typename?: "Location"
    /** Whether this location can be reactivated. */
    activatable: Scalars["Boolean"]["output"]
    /** The address of this location. */
    address: LocationAddress
    /** Whether the location address has been verified. */
    addressVerified: Scalars["Boolean"]["output"]
    /** Whether this location can be deactivated. */
    deactivatable: Scalars["Boolean"]["output"]
    /** The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) that the location was deactivated at. For example, 3:30 pm on September 7, 2019 in the time zone of UTC (Universal Time Coordinated) is represented as `"2019-09-07T15:50:00Z`". */
    deactivatedAt?: Maybe<Scalars["String"]["output"]>
    /** Whether this location can be deleted. */
    deletable: Scalars["Boolean"]["output"]
    /** Name of the service provider that fulfills from this location. */
    fulfillmentService?: Maybe<FulfillmentService>
    /** Whether this location can fulfill online orders. */
    fulfillsOnlineOrders: Scalars["Boolean"]["output"]
    /** Whether this location has active inventory. */
    hasActiveInventory: Scalars["Boolean"]["output"]
    /** Whether this location has orders that need to be fulfilled. */
    hasUnfulfilledOrders: Scalars["Boolean"]["output"]
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The quantities of an inventory item at this location. */
    inventoryLevel?: Maybe<InventoryLevel>
    /** A list of the quantities of the inventory items that can be stocked at this location. */
    inventoryLevels: InventoryLevelConnection
    /** Whether the location is active. */
    isActive: Scalars["Boolean"]["output"]
    /**
     * Whether the location is your primary location for shipping inventory.
     * @deprecated The concept of a primary location is deprecated, shipsInventory can be used to get a fallback location
     */
    isPrimary: Scalars["Boolean"]["output"]
    /** The ID of the corresponding resource in the REST Admin API. */
    legacyResourceId: Scalars["UnsignedInt64"]["output"]
    /** Local pickup settings for the location. */
    localPickupSettingsV2?: Maybe<DeliveryLocalPickupSettings>
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafield definitions. */
    metafieldDefinitions: MetafieldDefinitionConnection
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /** The name of the location. */
    name: Scalars["String"]["output"]
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
    /** Whether this location is used for calculating shipping rates. In multi-origin shipping mode, this flag is ignored. */
    shipsInventory: Scalars["Boolean"]["output"]
    /** List of suggested addresses for this location (empty if none). */
    suggestedAddresses: Array<LocationSuggestedAddress>
  }

/**
 * Represents the location where the physical good resides.
 *
 */
export type LocationInventoryLevelArgs = {
  inventoryItemId: Scalars["ID"]["input"]
}

/**
 * Represents the location where the physical good resides.
 *
 */
export type LocationInventoryLevelsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents the location where the physical good resides.
 *
 */
export type LocationMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/**
 * Represents the location where the physical good resides.
 *
 */
export type LocationMetafieldDefinitionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  pinnedStatus?: InputMaybe<MetafieldDefinitionPinnedStatus>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<MetafieldDefinitionSortKeys>
}

/**
 * Represents the location where the physical good resides.
 *
 */
export type LocationMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * Represents the location where the physical good resides.
 *
 */
export type LocationPrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/**
 * Represents the location where the physical good resides.
 *
 */
export type LocationPrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Return type for `locationActivate` mutation. */
export type LocationActivatePayload = {
  __typename?: "LocationActivatePayload"
  /** The location that was activated. */
  location?: Maybe<Location>
  /** The list of errors that occurred from executing the mutation. */
  locationActivateUserErrors: Array<LocationActivateUserError>
}

/** An error that occurs while activating a location. */
export type LocationActivateUserError = DisplayableError & {
  __typename?: "LocationActivateUserError"
  /** The error code. */
  code?: Maybe<LocationActivateUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `LocationActivateUserError`. */
export enum LocationActivateUserErrorCode {
  /** An error occurred while activating the location. */
  GenericError = "GENERIC_ERROR",
  /** There is already an active location with this name. */
  HasNonUniqueName = "HAS_NON_UNIQUE_NAME",
  /** This location currently cannot be activated as inventory, pending orders or transfers are being relocated from this location. */
  HasOngoingRelocation = "HAS_ONGOING_RELOCATION",
  /** Shop has reached its location limit. */
  LocationLimit = "LOCATION_LIMIT",
  /** Location not found. */
  LocationNotFound = "LOCATION_NOT_FOUND",
}

/** The input fields to use to specify the address while adding a location. */
export type LocationAddAddressInput = {
  /** The first line of the address. */
  address1?: InputMaybe<Scalars["String"]["input"]>
  /** The second line of the address. */
  address2?: InputMaybe<Scalars["String"]["input"]>
  /** The name of the city, district, village, or town. */
  city?: InputMaybe<Scalars["String"]["input"]>
  /** The two-letter code of country for the address. */
  countryCode: CountryCode
  /** The phone number of the location. */
  phone?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The code for the region of the address, such as the state, province, or district.
   * For example CA for California, United States.
   *
   */
  provinceCode?: InputMaybe<Scalars["String"]["input"]>
  /** The ZIP code or postal code of the address. */
  zip?: InputMaybe<Scalars["String"]["input"]>
}

/** The input fields to use to add a location. */
export type LocationAddInput = {
  /** The address of the location. */
  address: LocationAddAddressInput
  /** Whether inventory at this location is available for sale online. */
  fulfillsOnlineOrders?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Additional customizable information to associate with the location. */
  metafields?: InputMaybe<Array<MetafieldInput>>
  /** The name of the location. */
  name: Scalars["String"]["input"]
}

/** Return type for `locationAdd` mutation. */
export type LocationAddPayload = {
  __typename?: "LocationAddPayload"
  /** The location that was added. */
  location?: Maybe<Location>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<LocationAddUserError>
}

/** An error that occurs while adding a location. */
export type LocationAddUserError = DisplayableError & {
  __typename?: "LocationAddUserError"
  /** The error code. */
  code?: Maybe<LocationAddUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `LocationAddUserError`. */
export enum LocationAddUserErrorCode {
  /** ApiPermission metafields can only be created or updated by the app owner. */
  AppNotAuthorized = "APP_NOT_AUTHORIZED",
  /** The input value is blank. */
  Blank = "BLANK",
  /** Owner type can't be used in this mutation. */
  DisallowedOwnerType = "DISALLOWED_OWNER_TYPE",
  /** An error occurred while adding the location. */
  GenericError = "GENERIC_ERROR",
  /** The input value isn't included in the list. */
  Inclusion = "INCLUSION",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** The type is invalid. */
  InvalidType = "INVALID_TYPE",
  /** The ZIP code is not a valid US ZIP code. */
  InvalidUsZipcode = "INVALID_US_ZIPCODE",
  /** The value is invalid for the metafield type or for the definition options. */
  InvalidValue = "INVALID_VALUE",
  /** The input value needs to be blank. */
  Present = "PRESENT",
  /** The input value is already taken. */
  Taken = "TAKEN",
  /** The input value is too long. */
  TooLong = "TOO_LONG",
  /** The input value is too short. */
  TooShort = "TOO_SHORT",
  /** Unstructured reserved namespace. */
  UnstructuredReservedNamespace = "UNSTRUCTURED_RESERVED_NAMESPACE",
}

/**
 * Represents the address of a location.
 *
 */
export type LocationAddress = {
  __typename?: "LocationAddress"
  /** The first line of the address for the location. */
  address1?: Maybe<Scalars["String"]["output"]>
  /** The second line of the address for the location. */
  address2?: Maybe<Scalars["String"]["output"]>
  /** The city of the location. */
  city?: Maybe<Scalars["String"]["output"]>
  /** The country of the location. */
  country?: Maybe<Scalars["String"]["output"]>
  /** The country code of the location. */
  countryCode?: Maybe<Scalars["String"]["output"]>
  /** A formatted version of the address for the location. */
  formatted: Array<Scalars["String"]["output"]>
  /** The approximate latitude coordinates of the location. */
  latitude?: Maybe<Scalars["Float"]["output"]>
  /** The approximate longitude coordinates of the location. */
  longitude?: Maybe<Scalars["Float"]["output"]>
  /** The phone number of the location. */
  phone?: Maybe<Scalars["String"]["output"]>
  /** The province of the location. */
  province?: Maybe<Scalars["String"]["output"]>
  /**
   * The code for the province, state, or district of the address of the location.
   *
   */
  provinceCode?: Maybe<Scalars["String"]["output"]>
  /** The ZIP code of the location. */
  zip?: Maybe<Scalars["String"]["output"]>
}

/**
 * An auto-generated type for paginating through multiple Locations.
 *
 */
export type LocationConnection = {
  __typename?: "LocationConnection"
  /** A list of edges. */
  edges: Array<LocationEdge>
  /** A list of the nodes contained in LocationEdge. */
  nodes: Array<Location>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `locationDeactivate` mutation. */
export type LocationDeactivatePayload = {
  __typename?: "LocationDeactivatePayload"
  /** The location that was deactivated. */
  location?: Maybe<Location>
  /** The list of errors that occurred from executing the mutation. */
  locationDeactivateUserErrors: Array<LocationDeactivateUserError>
}

/** The possible errors that can be returned when executing the `locationDeactivate` mutation. */
export type LocationDeactivateUserError = DisplayableError & {
  __typename?: "LocationDeactivateUserError"
  /** The error code. */
  code?: Maybe<LocationDeactivateUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `LocationDeactivateUserError`. */
export enum LocationDeactivateUserErrorCode {
  /** At least one location must fulfill online orders. */
  CannotDisableOnlineOrderFulfillment = "CANNOT_DISABLE_ONLINE_ORDER_FULFILLMENT",
  /** Destination location is the same as the location to be deactivated. */
  DestinationLocationIsTheSameLocation = "DESTINATION_LOCATION_IS_THE_SAME_LOCATION",
  /** Destination location is not found or inactive. */
  DestinationLocationNotFoundOrInactive = "DESTINATION_LOCATION_NOT_FOUND_OR_INACTIVE",
  /** Failed to relocate active inventories to the destination location. */
  FailedToRelocateActiveInventories = "FAILED_TO_RELOCATE_ACTIVE_INVENTORIES",
  /** Failed to relocate incoming movements to the destination location. */
  FailedToRelocateIncomingMovements = "FAILED_TO_RELOCATE_INCOMING_MOVEMENTS",
  /** Failed to relocate open purchase orders to the destination location. */
  FailedToRelocateOpenPurchaseOrders = "FAILED_TO_RELOCATE_OPEN_PURCHASE_ORDERS",
  /** Failed to relocate open transfers to the destination location. */
  FailedToRelocateOpenTransfers = "FAILED_TO_RELOCATE_OPEN_TRANSFERS",
  /** Location could not be deactivated without specifying where to relocate inventory at the location. */
  HasActiveInventoryError = "HAS_ACTIVE_INVENTORY_ERROR",
  /** Location needs to be removed from Shopify POS for Retail subscription in Point of Sale channel. */
  HasActiveRetailSubscriptions = "HAS_ACTIVE_RETAIL_SUBSCRIPTIONS",
  /** Location could not be deactivated because it has pending orders. */
  HasFulfillmentOrdersError = "HAS_FULFILLMENT_ORDERS_ERROR",
  /** Location could not be deactivated because it has open Shopify Fulfillment Network transfers. */
  HasIncomingMovementsError = "HAS_INCOMING_MOVEMENTS_ERROR",
  /** Location could not be deactivated because it has open purchase orders. */
  HasOpenPurchaseOrdersError = "HAS_OPEN_PURCHASE_ORDERS_ERROR",
  /** Location could not be deactivated because it has open transfers. */
  HasOpenTransfersError = "HAS_OPEN_TRANSFERS_ERROR",
  /** Location not found. */
  LocationNotFound = "LOCATION_NOT_FOUND",
  /** Location either has a fulfillment service or is the only location with a shipping address. */
  PermanentlyBlockedFromDeactivationError = "PERMANENTLY_BLOCKED_FROM_DEACTIVATION_ERROR",
  /** Location has incoming inventory. The location can be deactivated after the inventory has been received. */
  TemporarilyBlockedFromDeactivationError = "TEMPORARILY_BLOCKED_FROM_DEACTIVATION_ERROR",
}

/** Return type for `locationDelete` mutation. */
export type LocationDeletePayload = {
  __typename?: "LocationDeletePayload"
  /** The ID of the location that was deleted. */
  deletedLocationId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  locationDeleteUserErrors: Array<LocationDeleteUserError>
}

/** An error that occurs while deleting a location. */
export type LocationDeleteUserError = DisplayableError & {
  __typename?: "LocationDeleteUserError"
  /** The error code. */
  code?: Maybe<LocationDeleteUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `LocationDeleteUserError`. */
export enum LocationDeleteUserErrorCode {
  /** An error occurred while deleting the location. */
  GenericError = "GENERIC_ERROR",
  /** The location cannot be deleted while it has any active Retail subscriptions in the Point of Sale channel. */
  LocationHasActiveRetailSubscription = "LOCATION_HAS_ACTIVE_RETAIL_SUBSCRIPTION",
  /** The location cannot be deleted while it has inventory. */
  LocationHasInventory = "LOCATION_HAS_INVENTORY",
  /** The location cannot be deleted while it has pending orders. */
  LocationHasPendingOrders = "LOCATION_HAS_PENDING_ORDERS",
  /** The location cannot be deleted while it is active. */
  LocationIsActive = "LOCATION_IS_ACTIVE",
  /** Location not found. */
  LocationNotFound = "LOCATION_NOT_FOUND",
}

/**
 * An auto-generated type which holds one Location and a cursor during pagination.
 *
 */
export type LocationEdge = {
  __typename?: "LocationEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of LocationEdge. */
  node: Location
}

/** The input fields to use to edit the address of a location. */
export type LocationEditAddressInput = {
  /** The first line of the address. */
  address1?: InputMaybe<Scalars["String"]["input"]>
  /** The second line of the address. */
  address2?: InputMaybe<Scalars["String"]["input"]>
  /** The name of the city, district, village, or town. */
  city?: InputMaybe<Scalars["String"]["input"]>
  /** The two-letter code of country for the address. */
  countryCode?: InputMaybe<CountryCode>
  /** The phone number of the location. */
  phone?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The code for the region of the address, such as the state, province, or district.
   * For example CA for California, United States.
   *
   */
  provinceCode?: InputMaybe<Scalars["String"]["input"]>
  /** The ZIP code or postal code of the location. */
  zip?: InputMaybe<Scalars["String"]["input"]>
}

/** The input fields to use to edit a location. */
export type LocationEditInput = {
  /** The address of the location. */
  address?: InputMaybe<LocationEditAddressInput>
  /**
   * Whether inventory at this location is available for sale online.
   *
   * **Note:** This can't be disabled for fulfillment service locations.
   *
   */
  fulfillsOnlineOrders?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Additional customizable information to associate with the location. */
  metafields?: InputMaybe<Array<MetafieldInput>>
  /** The name of the location. */
  name?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `locationEdit` mutation. */
export type LocationEditPayload = {
  __typename?: "LocationEditPayload"
  /** The location that was edited. */
  location?: Maybe<Location>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<LocationEditUserError>
}

/** An error that occurs while editing a location. */
export type LocationEditUserError = DisplayableError & {
  __typename?: "LocationEditUserError"
  /** The error code. */
  code?: Maybe<LocationEditUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `LocationEditUserError`. */
export enum LocationEditUserErrorCode {
  /** ApiPermission metafields can only be created or updated by the app owner. */
  AppNotAuthorized = "APP_NOT_AUTHORIZED",
  /** The input value is blank. */
  Blank = "BLANK",
  /** At least one location must fulfill online orders. */
  CannotDisableOnlineOrderFulfillment = "CANNOT_DISABLE_ONLINE_ORDER_FULFILLMENT",
  /** Cannot modify the online order fulfillment preference for fulfillment service locations. */
  CannotModifyOnlineOrderFulfillmentForFsLocation = "CANNOT_MODIFY_ONLINE_ORDER_FULFILLMENT_FOR_FS_LOCATION",
  /** Owner type can't be used in this mutation. */
  DisallowedOwnerType = "DISALLOWED_OWNER_TYPE",
  /** An error occurred while editing the location. */
  GenericError = "GENERIC_ERROR",
  /** The input value isn't included in the list. */
  Inclusion = "INCLUSION",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** The type is invalid. */
  InvalidType = "INVALID_TYPE",
  /** The ZIP code is not a valid US ZIP code. */
  InvalidUsZipcode = "INVALID_US_ZIPCODE",
  /** The value is invalid for the metafield type or for the definition options. */
  InvalidValue = "INVALID_VALUE",
  /** The record with the ID used as the input value couldn't be found. */
  NotFound = "NOT_FOUND",
  /** The input value needs to be blank. */
  Present = "PRESENT",
  /** The input value is already taken. */
  Taken = "TAKEN",
  /** The input value is too long. */
  TooLong = "TOO_LONG",
  /** The input value is too short. */
  TooShort = "TOO_SHORT",
  /** Unstructured reserved namespace. */
  UnstructuredReservedNamespace = "UNSTRUCTURED_RESERVED_NAMESPACE",
}

/** Return type for `locationLocalPickupDisable` mutation. */
export type LocationLocalPickupDisablePayload = {
  __typename?: "LocationLocalPickupDisablePayload"
  /** The ID of the location for which local pickup was disabled. */
  locationId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DeliveryLocationLocalPickupSettingsError>
}

/** Return type for `locationLocalPickupEnable` mutation. */
export type LocationLocalPickupEnablePayload = {
  __typename?: "LocationLocalPickupEnablePayload"
  /** The local pickup settings that were enabled. */
  localPickupSettings?: Maybe<DeliveryLocalPickupSettings>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<DeliveryLocationLocalPickupSettingsError>
}

/** The set of valid sort keys for the Location query. */
export enum LocationSortKeys {
  /** Sort by the `id` value. */
  Id = "ID",
  /** Sort by the `name` value. */
  Name = "NAME",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
}

/**
 * Represents a suggested address for a location.
 *
 */
export type LocationSuggestedAddress = {
  __typename?: "LocationSuggestedAddress"
  /** The first line of the suggested address. */
  address1?: Maybe<Scalars["String"]["output"]>
  /** The second line of the suggested address. */
  address2?: Maybe<Scalars["String"]["output"]>
  /** The city of the suggested address. */
  city?: Maybe<Scalars["String"]["output"]>
  /** The country of the suggested address. */
  country?: Maybe<Scalars["String"]["output"]>
  /** The country code of the suggested address. */
  countryCode?: Maybe<CountryCode>
  /** A formatted version of the suggested address. */
  formatted: Array<Scalars["String"]["output"]>
  /** The province of the suggested address. */
  province?: Maybe<Scalars["String"]["output"]>
  /** The code for the province, state, or district of the suggested address. */
  provinceCode?: Maybe<Scalars["String"]["output"]>
  /** The ZIP code of the suggested address. */
  zip?: Maybe<Scalars["String"]["output"]>
}

/**
 * Represents a customer mailing address.
 *
 * For example, a customer's default address and an order's billing address are both mailling addresses.
 *
 */
export type MailingAddress = Node & {
  __typename?: "MailingAddress"
  /** The first line of the address. Typically the street address or PO Box number. */
  address1?: Maybe<Scalars["String"]["output"]>
  /**
   * The second line of the address. Typically the number of the apartment, suite, or unit.
   *
   */
  address2?: Maybe<Scalars["String"]["output"]>
  /**
   * The name of the city, district, village, or town.
   *
   */
  city?: Maybe<Scalars["String"]["output"]>
  /**
   * The name of the customer's company or organization.
   *
   */
  company?: Maybe<Scalars["String"]["output"]>
  /** Whether the address coordinates are valid. */
  coordinatesValidated: Scalars["Boolean"]["output"]
  /**
   * The name of the country.
   *
   */
  country?: Maybe<Scalars["String"]["output"]>
  /**
   * The two-letter code for the country of the address.
   *
   * For example, US.
   *
   * @deprecated Use `countryCodeV2` instead.
   */
  countryCode?: Maybe<Scalars["String"]["output"]>
  /**
   * The two-letter code for the country of the address.
   *
   * For example, US.
   *
   */
  countryCodeV2?: Maybe<CountryCode>
  /** The first name of the customer. */
  firstName?: Maybe<Scalars["String"]["output"]>
  /** A formatted version of the address, customized by the provided arguments. */
  formatted: Array<Scalars["String"]["output"]>
  /** A comma-separated list of the values for city, province, and country. */
  formattedArea?: Maybe<Scalars["String"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The last name of the customer. */
  lastName?: Maybe<Scalars["String"]["output"]>
  /** The latitude coordinate of the customer address. */
  latitude?: Maybe<Scalars["Float"]["output"]>
  /** The longitude coordinate of the customer address. */
  longitude?: Maybe<Scalars["Float"]["output"]>
  /**
   * The full name of the customer, based on firstName and lastName.
   *
   */
  name?: Maybe<Scalars["String"]["output"]>
  /**
   * A unique phone number for the customer.
   *
   * Formatted using E.164 standard. For example, _+16135551111_.
   *
   */
  phone?: Maybe<Scalars["String"]["output"]>
  /** The region of the address, such as the province, state, or district. */
  province?: Maybe<Scalars["String"]["output"]>
  /**
   * The two-letter code for the region.
   *
   * For example, ON.
   *
   */
  provinceCode?: Maybe<Scalars["String"]["output"]>
  /** The time zone of the address. */
  timeZone?: Maybe<Scalars["String"]["output"]>
  /** The zip or postal code of the address. */
  zip?: Maybe<Scalars["String"]["output"]>
}

/**
 * Represents a customer mailing address.
 *
 * For example, a customer's default address and an order's billing address are both mailling addresses.
 *
 */
export type MailingAddressFormattedArgs = {
  withCompany?: InputMaybe<Scalars["Boolean"]["input"]>
  withName?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple MailingAddresses.
 *
 */
export type MailingAddressConnection = {
  __typename?: "MailingAddressConnection"
  /** A list of edges. */
  edges: Array<MailingAddressEdge>
  /** A list of the nodes contained in MailingAddressEdge. */
  nodes: Array<MailingAddress>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one MailingAddress and a cursor during pagination.
 *
 */
export type MailingAddressEdge = {
  __typename?: "MailingAddressEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of MailingAddressEdge. */
  node: MailingAddress
}

/** The input fields to create or update a mailing address. */
export type MailingAddressInput = {
  /**
   * The first line of the address. Typically the street address or PO Box number.
   *
   */
  address1?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The second line of the address. Typically the number of the apartment, suite, or unit.
   *
   */
  address2?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The name of the city, district, village, or town.
   *
   */
  city?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The name of the customer's company or organization.
   *
   */
  company?: InputMaybe<Scalars["String"]["input"]>
  /** The two-letter code for the country of the address. */
  countryCode?: InputMaybe<CountryCode>
  /** The first name of the customer. */
  firstName?: InputMaybe<Scalars["String"]["input"]>
  /** The last name of the customer. */
  lastName?: InputMaybe<Scalars["String"]["input"]>
  /**
   * A unique phone number for the customer.
   *
   * Formatted using E.164 standard. For example, _+16135551111_.
   *
   */
  phone?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The code for the region of the address, such as the province, state, or district.
   * For example QC for Quebec, Canada.
   *
   */
  provinceCode?: InputMaybe<Scalars["String"]["input"]>
  /** The zip or postal code of the address. */
  zip?: InputMaybe<Scalars["String"]["input"]>
}

/**
 * Manual discount applications capture the intentions of a discount that was manually created for an order.
 *
 * Discount applications don't represent the actual final amount discounted on a line (line item or shipping line). The actual amount discounted on a line is represented by the [DiscountAllocation](https://shopify.dev/api/admin-graphql/latest/objects/discountallocation) object.
 *
 */
export type ManualDiscountApplication = DiscountApplication & {
  __typename?: "ManualDiscountApplication"
  /** The method by which the discount's value is applied to its entitled items. */
  allocationMethod: DiscountApplicationAllocationMethod
  /** The description of the discount application. */
  description?: Maybe<Scalars["String"]["output"]>
  /**
   * An ordered index that can be used to identify the discount application and indicate the precedence
   * of the discount application for calculations.
   *
   */
  index: Scalars["Int"]["output"]
  /** How the discount amount is distributed on the discounted lines. */
  targetSelection: DiscountApplicationTargetSelection
  /** Whether the discount is applied on line items or shipping lines. */
  targetType: DiscountApplicationTargetType
  /** The title of the discount application. */
  title: Scalars["String"]["output"]
  /** The value of the discount application. */
  value: PricingValue
}

/**
 * A market is a group of one or more regions that you want to target for international sales.
 * By creating a market, you can configure a distinct, localized shopping experience for
 * customers from a specific area of the world. For example, you can
 * [change currency](https://shopify.dev/api/admin-graphql/current/mutations/marketCurrencySettingsUpdate),
 * [configure international pricing](https://shopify.dev/apps/internationalization/product-price-lists),
 * or [add market-specific domains or subfolders](https://shopify.dev/api/admin-graphql/current/objects/MarketWebPresence).
 *
 */
export type Market = HasMetafieldDefinitions &
  HasMetafields &
  Node & {
    __typename?: "Market"
    /** The catalogs that belong to the market. */
    catalogs: MarketCatalogConnection
    /** The market’s currency settings. */
    currencySettings: MarketCurrencySettings
    /**
     * Whether the market is enabled to receive visitors and sales. **Note**: Regions in inactive
     * markets can't be selected on the storefront or in checkout.
     *
     */
    enabled: Scalars["Boolean"]["output"]
    /** A short, human-readable unique identifier for the market. This is changeable by the merchant. */
    handle: Scalars["String"]["output"]
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafield definitions. */
    metafieldDefinitions: MetafieldDefinitionConnection
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /** The name of the market. Not shown to customers. */
    name: Scalars["String"]["output"]
    /**
     * The market’s price list, which specifies a percentage-based price adjustment as well as
     * fixed price overrides for specific variants.
     *
     */
    priceList?: Maybe<PriceList>
    /**
     * Whether the market is the shop’s primary market.
     *
     */
    primary: Scalars["Boolean"]["output"]
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
    /** The regions that comprise the market. */
    regions: MarketRegionConnection
    /**
     * The market’s web presence, which defines its SEO strategy. This can be a different domain,
     * subdomain, or subfolders of the primary domain. Each web presence comprises one or more
     * language variants. If a market doesn't have its own web presence, then the market is accessible on the
     * primary market's domains using [country
     * selectors](https://shopify.dev/themes/internationalization/multiple-currencies-languages#the-country-selector).
     * If it's the primary market and it has multiple web presences, then this field will return the primary domain web presence.
     *
     */
    webPresence?: Maybe<MarketWebPresence>
    /**
     * The market’s web presences, which defines its SEO strategy. This can be a different domain,
     * subdomain, or subfolders of the primary domain. Each web presence comprises one or more
     * language variants. If a market doesn't have any web presences, then the market is accessible on the
     * primary market's domains using [country
     * selectors](https://shopify.dev/themes/internationalization/multiple-currencies-languages#the-country-selector).
     *
     */
    webPresences: MarketWebPresenceConnection
  }

/**
 * A market is a group of one or more regions that you want to target for international sales.
 * By creating a market, you can configure a distinct, localized shopping experience for
 * customers from a specific area of the world. For example, you can
 * [change currency](https://shopify.dev/api/admin-graphql/current/mutations/marketCurrencySettingsUpdate),
 * [configure international pricing](https://shopify.dev/apps/internationalization/product-price-lists),
 * or [add market-specific domains or subfolders](https://shopify.dev/api/admin-graphql/current/objects/MarketWebPresence).
 *
 */
export type MarketCatalogsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * A market is a group of one or more regions that you want to target for international sales.
 * By creating a market, you can configure a distinct, localized shopping experience for
 * customers from a specific area of the world. For example, you can
 * [change currency](https://shopify.dev/api/admin-graphql/current/mutations/marketCurrencySettingsUpdate),
 * [configure international pricing](https://shopify.dev/apps/internationalization/product-price-lists),
 * or [add market-specific domains or subfolders](https://shopify.dev/api/admin-graphql/current/objects/MarketWebPresence).
 *
 */
export type MarketMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/**
 * A market is a group of one or more regions that you want to target for international sales.
 * By creating a market, you can configure a distinct, localized shopping experience for
 * customers from a specific area of the world. For example, you can
 * [change currency](https://shopify.dev/api/admin-graphql/current/mutations/marketCurrencySettingsUpdate),
 * [configure international pricing](https://shopify.dev/apps/internationalization/product-price-lists),
 * or [add market-specific domains or subfolders](https://shopify.dev/api/admin-graphql/current/objects/MarketWebPresence).
 *
 */
export type MarketMetafieldDefinitionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  pinnedStatus?: InputMaybe<MetafieldDefinitionPinnedStatus>
  query?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  sortKey?: InputMaybe<MetafieldDefinitionSortKeys>
}

/**
 * A market is a group of one or more regions that you want to target for international sales.
 * By creating a market, you can configure a distinct, localized shopping experience for
 * customers from a specific area of the world. For example, you can
 * [change currency](https://shopify.dev/api/admin-graphql/current/mutations/marketCurrencySettingsUpdate),
 * [configure international pricing](https://shopify.dev/apps/internationalization/product-price-lists),
 * or [add market-specific domains or subfolders](https://shopify.dev/api/admin-graphql/current/objects/MarketWebPresence).
 *
 */
export type MarketMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * A market is a group of one or more regions that you want to target for international sales.
 * By creating a market, you can configure a distinct, localized shopping experience for
 * customers from a specific area of the world. For example, you can
 * [change currency](https://shopify.dev/api/admin-graphql/current/mutations/marketCurrencySettingsUpdate),
 * [configure international pricing](https://shopify.dev/apps/internationalization/product-price-lists),
 * or [add market-specific domains or subfolders](https://shopify.dev/api/admin-graphql/current/objects/MarketWebPresence).
 *
 */
export type MarketPrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/**
 * A market is a group of one or more regions that you want to target for international sales.
 * By creating a market, you can configure a distinct, localized shopping experience for
 * customers from a specific area of the world. For example, you can
 * [change currency](https://shopify.dev/api/admin-graphql/current/mutations/marketCurrencySettingsUpdate),
 * [configure international pricing](https://shopify.dev/apps/internationalization/product-price-lists),
 * or [add market-specific domains or subfolders](https://shopify.dev/api/admin-graphql/current/objects/MarketWebPresence).
 *
 */
export type MarketPrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * A market is a group of one or more regions that you want to target for international sales.
 * By creating a market, you can configure a distinct, localized shopping experience for
 * customers from a specific area of the world. For example, you can
 * [change currency](https://shopify.dev/api/admin-graphql/current/mutations/marketCurrencySettingsUpdate),
 * [configure international pricing](https://shopify.dev/apps/internationalization/product-price-lists),
 * or [add market-specific domains or subfolders](https://shopify.dev/api/admin-graphql/current/objects/MarketWebPresence).
 *
 */
export type MarketRegionsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * A market is a group of one or more regions that you want to target for international sales.
 * By creating a market, you can configure a distinct, localized shopping experience for
 * customers from a specific area of the world. For example, you can
 * [change currency](https://shopify.dev/api/admin-graphql/current/mutations/marketCurrencySettingsUpdate),
 * [configure international pricing](https://shopify.dev/apps/internationalization/product-price-lists),
 * or [add market-specific domains or subfolders](https://shopify.dev/api/admin-graphql/current/objects/MarketWebPresence).
 *
 */
export type MarketWebPresencesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * A list of products with publishing and pricing information associated with markets.
 *
 */
export type MarketCatalog = Catalog &
  Node & {
    __typename?: "MarketCatalog"
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The markets associated with the catalog. */
    markets: MarketConnection
    /** Most recent catalog operations. */
    operations: Array<ResourceOperation>
    /** The price list associated with the catalog. */
    priceList?: Maybe<PriceList>
    /** A group of products and collections that's published to a catalog. */
    publication?: Maybe<Publication>
    /** The status of the catalog. */
    status: CatalogStatus
    /** The name of the catalog. */
    title: Scalars["String"]["output"]
  }

/**
 * A list of products with publishing and pricing information associated with markets.
 *
 */
export type MarketCatalogMarketsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An auto-generated type for paginating through multiple MarketCatalogs.
 *
 */
export type MarketCatalogConnection = {
  __typename?: "MarketCatalogConnection"
  /** A list of edges. */
  edges: Array<MarketCatalogEdge>
  /** A list of the nodes contained in MarketCatalogEdge. */
  nodes: Array<MarketCatalog>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one MarketCatalog and a cursor during pagination.
 *
 */
export type MarketCatalogEdge = {
  __typename?: "MarketCatalogEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of MarketCatalogEdge. */
  node: MarketCatalog
}

/**
 * An auto-generated type for paginating through multiple Markets.
 *
 */
export type MarketConnection = {
  __typename?: "MarketConnection"
  /** A list of edges. */
  edges: Array<MarketEdge>
  /** A list of the nodes contained in MarketEdge. */
  nodes: Array<Market>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** The input fields required to create a market. */
export type MarketCreateInput = {
  /**
   * Whether the market is enabled to receive visitors and sales. If a
   * value isn't provided, then the market is enabled by default if all
   * included regions have shipping rates, and disabled if any regions don't
   * have shipping rates.
   *
   * **Note**: Regions in inactive markets can't be selected on the
   * storefront or in checkout.
   *
   */
  enabled?: InputMaybe<Scalars["Boolean"]["input"]>
  /**
   * A unique identifier for the market. For example `"ca"`.
   * If the handle isn't provided, then the handle is auto-generated based on the country or name.
   *
   */
  handle?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The name of the market. Not shown to customers.
   *
   */
  name: Scalars["String"]["input"]
  /**
   * The regions to be included in the market. Each region can only be included in one market at
   * a time.
   *
   */
  regions: Array<MarketRegionCreateInput>
}

/** Return type for `marketCreate` mutation. */
export type MarketCreatePayload = {
  __typename?: "MarketCreatePayload"
  /** The market object. */
  market?: Maybe<Market>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketUserError>
}

/** A market's currency settings. */
export type MarketCurrencySettings = {
  __typename?: "MarketCurrencySettings"
  /**
   * The currency which this market's prices are defined in, and the
   * currency which its customers must use if local currencies are disabled.
   *
   */
  baseCurrency: CurrencySetting
  /**
   * Whether or not local currencies are enabled. If enabled, then prices will
   * be converted to give each customer the best experience based on their
   * region. If disabled, then all customers in this market will see prices
   * in the market's base currency. For single country markets this will be true when
   * the market's base currency is the same as the default currency for the region.
   *
   */
  localCurrencies: Scalars["Boolean"]["output"]
}

/** The input fields used to update the currency settings of a market. */
export type MarketCurrencySettingsUpdateInput = {
  /**
   * The currency which this market’s prices are defined in, and the
   * currency which its customers must use if local currencies are disabled.
   *
   */
  baseCurrency?: InputMaybe<CurrencyCode>
  /**
   * Whether or not local currencies are enabled. If enabled, then prices will
   * be converted to give each customer the best experience based on their
   * region. If disabled, then all customers in this market will see prices
   * in the market's base currency.
   *
   */
  localCurrencies?: InputMaybe<Scalars["Boolean"]["input"]>
}

/** Return type for `marketCurrencySettingsUpdate` mutation. */
export type MarketCurrencySettingsUpdatePayload = {
  __typename?: "MarketCurrencySettingsUpdatePayload"
  /** The market object. */
  market?: Maybe<Market>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketCurrencySettingsUserError>
}

/** Error codes for failed market multi-currency operations. */
export type MarketCurrencySettingsUserError = DisplayableError & {
  __typename?: "MarketCurrencySettingsUserError"
  /** The error code. */
  code?: Maybe<MarketCurrencySettingsUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `MarketCurrencySettingsUserError`. */
export enum MarketCurrencySettingsUserErrorCode {
  /** The currency settings of the given market cannot be changed because the market manager has exclusive control of pricing. */
  ManagedMarket = "MANAGED_MARKET",
  /** The specified market wasn't found. */
  MarketNotFound = "MARKET_NOT_FOUND",
  /** The shop's payment gateway does not support enabling more than one currency. */
  MultipleCurrenciesNotSupported = "MULTIPLE_CURRENCIES_NOT_SUPPORTED",
  /** Can't enable or disable local currencies on a single country market. */
  NoLocalCurrenciesOnSingleCountryMarket = "NO_LOCAL_CURRENCIES_ON_SINGLE_COUNTRY_MARKET",
  /** The primary market must use the shop currency. */
  PrimaryMarketUsesShopCurrency = "PRIMARY_MARKET_USES_SHOP_CURRENCY",
  /** The specified currency is not supported. */
  UnsupportedCurrency = "UNSUPPORTED_CURRENCY",
}

/** Return type for `marketDelete` mutation. */
export type MarketDeletePayload = {
  __typename?: "MarketDeletePayload"
  /** The ID of the deleted market. */
  deletedId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketUserError>
}

/**
 * An auto-generated type which holds one Market and a cursor during pagination.
 *
 */
export type MarketEdge = {
  __typename?: "MarketEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of MarketEdge. */
  node: Market
}

/** The market localizable content of a resource's field. */
export type MarketLocalizableContent = {
  __typename?: "MarketLocalizableContent"
  /** The hash digest representation of the content value. */
  digest?: Maybe<Scalars["String"]["output"]>
  /** The resource field that's being localized. */
  key: Scalars["String"]["output"]
  /** The content value. */
  value?: Maybe<Scalars["String"]["output"]>
}

/** A resource that has market localizable fields. */
export type MarketLocalizableResource = {
  __typename?: "MarketLocalizableResource"
  /** The market localizable content. */
  marketLocalizableContent: Array<MarketLocalizableContent>
  /** Market localizations for the market localizable content. */
  marketLocalizations: Array<MarketLocalization>
  /** The GID of the resource. */
  resourceId: Scalars["ID"]["output"]
}

/** A resource that has market localizable fields. */
export type MarketLocalizableResourceMarketLocalizationsArgs = {
  marketId: Scalars["ID"]["input"]
}

/**
 * An auto-generated type for paginating through multiple MarketLocalizableResources.
 *
 */
export type MarketLocalizableResourceConnection = {
  __typename?: "MarketLocalizableResourceConnection"
  /** A list of edges. */
  edges: Array<MarketLocalizableResourceEdge>
  /** A list of the nodes contained in MarketLocalizableResourceEdge. */
  nodes: Array<MarketLocalizableResource>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one MarketLocalizableResource and a cursor during pagination.
 *
 */
export type MarketLocalizableResourceEdge = {
  __typename?: "MarketLocalizableResourceEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of MarketLocalizableResourceEdge. */
  node: MarketLocalizableResource
}

/** The type of resources that are market localizable. */
export enum MarketLocalizableResourceType {
  /** A metafield. Market localizable fields: `value`. */
  Metafield = "METAFIELD",
  /** A Metaobject. Market Localizable fields are determined by the Metaobject type. */
  Metaobject = "METAOBJECT",
}

/** The market localization of a field within a resource, which is determined by the market ID. */
export type MarketLocalization = {
  __typename?: "MarketLocalization"
  /** A reference to the value being localized on the resource that this market localization belongs to. */
  key: Scalars["String"]["output"]
  /** The market that the localization is specific to. */
  market: Market
  /** Whether the original content has changed since this market localization was updated. */
  outdated: Scalars["Boolean"]["output"]
  /** The date and time when the market localization was updated. */
  updatedAt?: Maybe<Scalars["DateTime"]["output"]>
  /** The value of the market localization. */
  value?: Maybe<Scalars["String"]["output"]>
}

/** The input fields and values for creating or updating a market localization. */
export type MarketLocalizationRegisterInput = {
  /** A reference to the value being localized on the resource that this market localization belongs to. */
  key: Scalars["String"]["input"]
  /** The ID of the market that the localization is specific to. */
  marketId: Scalars["ID"]["input"]
  /** A hash digest representation of the content being localized. */
  marketLocalizableContentDigest: Scalars["String"]["input"]
  /** The value of the market localization. */
  value: Scalars["String"]["input"]
}

/** Return type for `marketLocalizationsRegister` mutation. */
export type MarketLocalizationsRegisterPayload = {
  __typename?: "MarketLocalizationsRegisterPayload"
  /** The market localizations that were created or updated. */
  marketLocalizations?: Maybe<Array<MarketLocalization>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<TranslationUserError>
}

/** Return type for `marketLocalizationsRemove` mutation. */
export type MarketLocalizationsRemovePayload = {
  __typename?: "MarketLocalizationsRemovePayload"
  /** The market localizations that were deleted. */
  marketLocalizations?: Maybe<Array<MarketLocalization>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<TranslationUserError>
}

/** A geographic region which comprises a market. */
export type MarketRegion = {
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The name of the region. */
  name: Scalars["String"]["output"]
}

/**
 * An auto-generated type for paginating through multiple MarketRegions.
 *
 */
export type MarketRegionConnection = {
  __typename?: "MarketRegionConnection"
  /** A list of edges. */
  edges: Array<MarketRegionEdge>
  /** A list of the nodes contained in MarketRegionEdge. */
  nodes: Array<MarketRegion>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** A country which comprises a market. */
export type MarketRegionCountry = MarketRegion &
  Node & {
    __typename?: "MarketRegionCountry"
    /** The ISO code identifying the country. */
    code: CountryCode
    /** The currency which this country uses given its market settings. */
    currency: CurrencySetting
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The name of the region. */
    name: Scalars["String"]["output"]
  }

/** The input fields for creating a market region with exactly one required option. */
export type MarketRegionCreateInput = {
  /** A country code for the region. */
  countryCode: CountryCode
}

/** Return type for `marketRegionDelete` mutation. */
export type MarketRegionDeletePayload = {
  __typename?: "MarketRegionDeletePayload"
  /** The ID of the deleted market region. */
  deletedId?: Maybe<Scalars["ID"]["output"]>
  /** The parent market object of the deleted region. */
  market?: Maybe<Market>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketUserError>
}

/**
 * An auto-generated type which holds one MarketRegion and a cursor during pagination.
 *
 */
export type MarketRegionEdge = {
  __typename?: "MarketRegionEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of MarketRegionEdge. */
  node: MarketRegion
}

/** Return type for `marketRegionsCreate` mutation. */
export type MarketRegionsCreatePayload = {
  __typename?: "MarketRegionsCreatePayload"
  /** The market object. */
  market?: Maybe<Market>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketUserError>
}

/** Return type for `marketRegionsDelete` mutation. */
export type MarketRegionsDeletePayload = {
  __typename?: "MarketRegionsDeletePayload"
  /** The ID of the deleted market region. */
  deletedIds?: Maybe<Array<Scalars["ID"]["output"]>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketUserError>
}

/** The input fields used to update a market. */
export type MarketUpdateInput = {
  /**
   * Whether the market is enabled to receive visitors and sales. **Note**: Regions in
   * inactive markets cannot be selected on the storefront or in checkout.
   *
   */
  enabled?: InputMaybe<Scalars["Boolean"]["input"]>
  /**
   * A unique identifier for the market. For example `"ca"`.
   *
   */
  handle?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The name of the market. Not shown to customers.
   *
   */
  name?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `marketUpdate` mutation. */
export type MarketUpdatePayload = {
  __typename?: "MarketUpdatePayload"
  /** The market object. */
  market?: Maybe<Market>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketUserError>
}

/**
 * Defines errors encountered while managing a Market.
 *
 */
export type MarketUserError = DisplayableError & {
  __typename?: "MarketUserError"
  /** The error code. */
  code?: Maybe<MarketUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `MarketUserError`. */
export enum MarketUserErrorCode {
  /** The input value is blank. */
  Blank = "BLANK",
  /** Can't add customer account domain to a market. */
  CannotAddCustomerDomain = "CANNOT_ADD_CUSTOMER_DOMAIN",
  /** Can't add regions to the primary market. */
  CannotAddRegionsToPrimaryMarket = "CANNOT_ADD_REGIONS_TO_PRIMARY_MARKET",
  /** Can't add the web presence to the primary market. */
  CannotAddWebPresenceToPrimaryMarket = "CANNOT_ADD_WEB_PRESENCE_TO_PRIMARY_MARKET",
  /** Can't delete the only region in a market. */
  CannotDeleteOnlyRegion = "CANNOT_DELETE_ONLY_REGION",
  /** Can't delete the primary market. */
  CannotDeletePrimaryMarket = "CANNOT_DELETE_PRIMARY_MARKET",
  /** Can't delete the primary market's web presence. */
  CannotDeletePrimaryMarketWebPresence = "CANNOT_DELETE_PRIMARY_MARKET_WEB_PRESENCE",
  /** Can't disable the primary market. */
  CannotDisablePrimaryMarket = "CANNOT_DISABLE_PRIMARY_MARKET",
  /** Can't have both subfolder and domain web presences. */
  CannotHaveBothSubfolderAndDomainWebPresences = "CANNOT_HAVE_BOTH_SUBFOLDER_AND_DOMAIN_WEB_PRESENCES",
  /** Can't have multiple subfolder web presences per market. */
  CannotHaveMultipleSubfoldersPerMarket = "CANNOT_HAVE_MULTIPLE_SUBFOLDERS_PER_MARKET",
  /** Can't pass both `subfolderSuffix` and `domainId`. */
  CannotHaveSubfolderAndDomain = "CANNOT_HAVE_SUBFOLDER_AND_DOMAIN",
  /** Can't set default locale to null. */
  CannotSetDefaultLocaleToNull = "CANNOT_SET_DEFAULT_LOCALE_TO_NULL",
  /** The language isn't enabled on the store. */
  DisabledLanguage = "DISABLED_LANGUAGE",
  /** Domain was not found. */
  DomainNotFound = "DOMAIN_NOT_FOUND",
  /** Duplicates found in languages. */
  DuplicateLanguages = "DUPLICATE_LANGUAGES",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** The market wasn't found. */
  MarketNotFound = "MARKET_NOT_FOUND",
  /** Can't add another web presence to the market. */
  MarketReachedWebPresenceLimit = "MARKET_REACHED_WEB_PRESENCE_LIMIT",
  /** No languages selected. */
  NoLanguages = "NO_LANGUAGES",
  /** The primary market must use the primary domain. */
  PrimaryMarketMustUsePrimaryDomain = "PRIMARY_MARKET_MUST_USE_PRIMARY_DOMAIN",
  /** The market region wasn't found. */
  RegionNotFound = "REGION_NOT_FOUND",
  /** Cannot add region-specific language. */
  RegionSpecificLanguage = "REGION_SPECIFIC_LANGUAGE",
  /** One of `subfolderSuffix` or `domainId` is required. */
  RequiresDomainOrSubfolder = "REQUIRES_DOMAIN_OR_SUBFOLDER",
  /** Exactly one input option is required. */
  RequiresExactlyOneOption = "REQUIRES_EXACTLY_ONE_OPTION",
  /** Can't have more than 50 markets. */
  ShopReachedMarketsLimit = "SHOP_REACHED_MARKETS_LIMIT",
  /** The subfolder suffix is invalid, please provide a different value. */
  SubfolderSuffixCannotBeScriptCode = "SUBFOLDER_SUFFIX_CANNOT_BE_SCRIPT_CODE",
  /** The subfolder suffix must contain only letters. */
  SubfolderSuffixMustContainOnlyLetters = "SUBFOLDER_SUFFIX_MUST_CONTAIN_ONLY_LETTERS",
  /** The input value is already taken. */
  Taken = "TAKEN",
  /** The input value is too long. */
  TooLong = "TOO_LONG",
  /** The input value is too short. */
  TooShort = "TOO_SHORT",
  /** The language isn't published to the store. */
  UnpublishedLanguage = "UNPUBLISHED_LANGUAGE",
  /** Can't add unsupported country or region. */
  UnsupportedCountryRegion = "UNSUPPORTED_COUNTRY_REGION",
  /** The market web presence wasn't found. */
  WebPresenceNotFound = "WEB_PRESENCE_NOT_FOUND",
}

/**
 * The market’s web presence, which defines its SEO strategy. This can be a different domain
 * (e.g. `example.ca`), subdomain (e.g. `ca.example.com`), or subfolders of the primary
 * domain (e.g. `example.com/en-ca`). Each web presence comprises one or more language
 * variants. If a market does not have its own web presence, it is accessible on the shop’s
 * primary domain via [country
 * selectors](https://shopify.dev/themes/internationalization/multiple-currencies-languages#the-country-selector).
 *
 * Note: while the domain/subfolders defined by a market’s web presence are not applicable to
 * custom storefronts, which must manage their own domains and routing, the languages chosen
 * here do govern [the languages available on the Storefront
 * API](https://shopify.dev/custom-storefronts/internationalization/multiple-languages) for the countries in
 * this market.
 *
 */
export type MarketWebPresence = Node & {
  __typename?: "MarketWebPresence"
  /**
   * The ISO codes for the alternate locales. When a domain is used, these locales will be
   * available as language-specific subfolders. For example, if English is an
   * alternate locale, and `example.ca` is the market’s domain, then
   * `example.ca/en` will load in English.
   *
   */
  alternateLocales: Array<Scalars["String"]["output"]>
  /**
   * The ISO code for the default locale. When a domain is used, this is the locale that will
   * be used when the domain root is accessed. For example, if French is the default locale,
   * and `example.ca` is the market’s domain, then `example.ca` will load in French.
   *
   */
  defaultLocale: Scalars["String"]["output"]
  /**
   * The web presence’s domain.
   * This field will be null if `subfolderSuffix` isn't null.
   *
   */
  domain?: Maybe<Domain>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The associated market. */
  market: Market
  /**
   * The list of root URLs for each of the web presence’s locales. As of version `2024-04` this value will no longer have a trailing slash.
   *
   */
  rootUrls: Array<MarketWebPresenceRootUrl>
  /** The market-specific suffix of the subfolders defined by the web presence. Example: in `/en-us` the subfolder suffix is `us`. This field will be null if `domain` isn't null. */
  subfolderSuffix?: Maybe<Scalars["String"]["output"]>
}

/**
 * An auto-generated type for paginating through multiple MarketWebPresences.
 *
 */
export type MarketWebPresenceConnection = {
  __typename?: "MarketWebPresenceConnection"
  /** A list of edges. */
  edges: Array<MarketWebPresenceEdge>
  /** A list of the nodes contained in MarketWebPresenceEdge. */
  nodes: Array<MarketWebPresence>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** The input fields used to create a web presence for a market. */
export type MarketWebPresenceCreateInput = {
  /**
   * The alternate locales for the market’s web presence.
   *
   */
  alternateLocales?: InputMaybe<Array<Scalars["String"]["input"]>>
  /**
   * The default locale for the market’s web presence.
   *
   */
  defaultLocale: Scalars["String"]["input"]
  /**
   * The web presence's domain ID. This field must be `null` if the `subfolderSuffix` isn't `null`.
   *
   */
  domainId?: InputMaybe<Scalars["ID"]["input"]>
  /**
   * The market-specific suffix of the subfolders defined by the web presence.
   * For example: in `/en-us`, the subfolder suffix is `us`.
   * Only ASCII characters are allowed. This field must be `null` if the `domainId` isn't `null`.
   *
   */
  subfolderSuffix?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `marketWebPresenceCreate` mutation. */
export type MarketWebPresenceCreatePayload = {
  __typename?: "MarketWebPresenceCreatePayload"
  /** The market object. */
  market?: Maybe<Market>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketUserError>
}

/** Return type for `marketWebPresenceDelete` mutation. */
export type MarketWebPresenceDeletePayload = {
  __typename?: "MarketWebPresenceDeletePayload"
  /** The ID of the deleted web presence. */
  deletedId?: Maybe<Scalars["ID"]["output"]>
  /** The market for which the web presence was deleted. */
  market?: Maybe<Market>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketUserError>
}

/**
 * An auto-generated type which holds one MarketWebPresence and a cursor during pagination.
 *
 */
export type MarketWebPresenceEdge = {
  __typename?: "MarketWebPresenceEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of MarketWebPresenceEdge. */
  node: MarketWebPresence
}

/**
 * The URL for the homepage of the online store in the context of a particular market and a
 * particular locale.
 *
 */
export type MarketWebPresenceRootUrl = {
  __typename?: "MarketWebPresenceRootUrl"
  /** The locale that the storefront loads in. */
  locale: Scalars["String"]["output"]
  /** The URL. */
  url: Scalars["URL"]["output"]
}

/** The input fields used to update a web presence for a market. */
export type MarketWebPresenceUpdateInput = {
  /**
   * The alternate locales for the market’s web presence.
   *
   */
  alternateLocales?: InputMaybe<Array<Scalars["String"]["input"]>>
  /**
   * The default locale for the market’s web presence.
   *
   */
  defaultLocale?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The web presence's domain ID. This field must be null if `subfolderSuffix` is not null.
   *
   */
  domainId?: InputMaybe<Scalars["ID"]["input"]>
  /**
   * The market-specific suffix of the subfolders defined by the web presence.
   * Example: in `/en-us` the subfolder suffix is `us`.
   * Only ASCII characters are allowed. This field must be null if `domainId` is not null.
   *
   */
  subfolderSuffix?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `marketWebPresenceUpdate` mutation. */
export type MarketWebPresenceUpdatePayload = {
  __typename?: "MarketWebPresenceUpdatePayload"
  /** The market object. */
  market?: Maybe<Market>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketUserError>
}

/** Return type for `marketingActivitiesDeleteAllExternal` mutation. */
export type MarketingActivitiesDeleteAllExternalPayload = {
  __typename?: "MarketingActivitiesDeleteAllExternalPayload"
  /** The asynchronous job that performs the deletion. The status of the job may be used to determine when it's safe again to create new activities. */
  job?: Maybe<Job>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketingActivityUserError>
}

/**
 * The marketing activity resource represents marketing that a
 *         merchant created through an app.
 */
export type MarketingActivity = Node & {
  __typename?: "MarketingActivity"
  /** The URL of the marketing activity listing page in the marketing section. */
  activityListUrl?: Maybe<Scalars["URL"]["output"]>
  /** The amount spent on the marketing activity. */
  adSpend?: Maybe<MoneyV2>
  /** The app which created this marketing activity. */
  app: App
  /** The errors generated when an app publishes the marketing activity. */
  appErrors?: Maybe<MarketingActivityExtensionAppErrors>
  /** The allocated budget for the marketing activity. */
  budget?: Maybe<MarketingBudget>
  /** The date and time when the marketing activity was created. */
  createdAt: Scalars["DateTime"]["output"]
  /** The completed content in the marketing activity creation form. */
  formData?: Maybe<Scalars["String"]["output"]>
  /** The hierarchy level of the marketing activity. */
  hierarchyLevel?: Maybe<MarketingActivityHierarchyLevel>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** Whether the marketing activity is in the main workflow version of the marketing automation. */
  inMainWorkflowVersion: Scalars["Boolean"]["output"]
  /**
   * The medium through which the marketing activity and event reached consumers. This is used for reporting aggregation.
   * @deprecated Use `marketingChannelType` instead.
   */
  marketingChannel: MarketingChannel
  /** The medium through which the marketing activity and event reached consumers. This is used for reporting aggregation. */
  marketingChannelType: MarketingChannel
  /** Associated marketing event of this marketing activity. */
  marketingEvent?: Maybe<MarketingEvent>
  /** ID of the parent activity of this marketing activity. */
  parentActivityId?: Maybe<Scalars["ID"]["output"]>
  /** ID of the parent activity of this marketing activity. */
  parentRemoteId?: Maybe<Scalars["String"]["output"]>
  /** A contextual description of the marketing activity based on the platform and tactic used. */
  sourceAndMedium: Scalars["String"]["output"]
  /** The current state of the marketing activity. */
  status: MarketingActivityStatus
  /**
   * The severity of the marketing activity's status.
   * @deprecated Use `statusBadgeTypeV2` instead.
   */
  statusBadgeType?: Maybe<MarketingActivityStatusBadgeType>
  /** The severity of the marketing activity's status. */
  statusBadgeTypeV2?: Maybe<BadgeType>
  /** The rendered status of the marketing activity. */
  statusLabel: Scalars["String"]["output"]
  /**
   * The [date and time](
   *           https://help.shopify.com/https://en.wikipedia.org/wiki/ISO_8601
   *           ) when the activity's status last changed.
   */
  statusTransitionedAt?: Maybe<Scalars["DateTime"]["output"]>
  /** The method of marketing used for this marketing activity. */
  tactic: MarketingTactic
  /** The status to which the marketing activity is currently transitioning. */
  targetStatus?: Maybe<MarketingActivityStatus>
  /** The marketing activity's title, which is rendered on the marketing listing page. */
  title: Scalars["String"]["output"]
  /** The date and time when the marketing activity was updated. */
  updatedAt: Scalars["DateTime"]["output"]
  /** A URL parameter value associated with this marketing activity. */
  urlParameterValue?: Maybe<Scalars["String"]["output"]>
  /**
   * The set of [Urchin Tracking Module](
   *           https://help.shopify.com/https://en.wikipedia.org/wiki/UTM_parameters
   *           ) used in the URL for tracking this marketing activity.
   */
  utmParameters?: Maybe<UtmParameters>
}

/** The input fields combining budget amount and its marketing budget type. */
export type MarketingActivityBudgetInput = {
  /** Budget type for marketing activity. */
  budgetType?: InputMaybe<MarketingBudgetBudgetType>
  /** Amount of budget for the marketing activity. */
  total?: InputMaybe<MoneyInput>
}

/**
 * An auto-generated type for paginating through multiple MarketingActivities.
 *
 */
export type MarketingActivityConnection = {
  __typename?: "MarketingActivityConnection"
  /** A list of edges. */
  edges: Array<MarketingActivityEdge>
  /** A list of the nodes contained in MarketingActivityEdge. */
  nodes: Array<MarketingActivity>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** The input fields for creating an externally-managed marketing activity. */
export type MarketingActivityCreateExternalInput = {
  /** The amount spent on the marketing activity. */
  adSpend?: InputMaybe<MoneyInput>
  /** The budget for this marketing activity. */
  budget?: InputMaybe<MarketingActivityBudgetInput>
  /** The unique string identifier of the channel to which this activity belongs. For the correct handle for your channel, contact your partner manager. */
  channelHandle?: InputMaybe<Scalars["String"]["input"]>
  /** The date and time at which the activity ended. If omitted or set to `null`, the current time will be used if the status is set to `INACTIVE` or `DELETED_EXTERNALLY`. */
  end?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The hierarchy level of the activity within a campaign. The hierarchy level can't be updated. */
  hierarchyLevel?: InputMaybe<MarketingActivityHierarchyLevel>
  /** The medium through which the marketing activity and event reached consumers. This is used for reporting aggregation. */
  marketingChannelType: MarketingChannel
  /** The ID for the parent marketing activity, if creating hierarchical activities. */
  parentActivityId?: InputMaybe<Scalars["ID"]["input"]>
  /** The remote ID for the parent marketing activity, if creating hierarchical activities. */
  parentRemoteId?: InputMaybe<Scalars["String"]["input"]>
  /** The domain from which ad clicks are forwarded to the shop. */
  referringDomain?: InputMaybe<Scalars["String"]["input"]>
  /** The ID of an activity that's hosted outside of Shopify. */
  remoteId?: InputMaybe<Scalars["String"]["input"]>
  /** The URL for a preview image that's used for the marketing activity. */
  remotePreviewImageUrl?: InputMaybe<Scalars["URL"]["input"]>
  /** The URL for viewing and/or managing the activity outside of Shopify. */
  remoteUrl: Scalars["URL"]["input"]
  /** The date and time at which the activity is scheduled to end. */
  scheduledEnd?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The date and time at which the activity is scheduled to start. */
  scheduledStart?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The date and time at which the activity started. If omitted or set to `null`, the current time will be used. */
  start?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The status of the marketing activity. If status isn't set it will default to UNDEFINED. */
  status?: InputMaybe<MarketingActivityExternalStatus>
  /** The method of marketing used for this marketing activity. The marketing tactic determines which default fields are included in the marketing activity. */
  tactic: MarketingTactic
  /** The title of the marketing activity. */
  title: Scalars["String"]["input"]
  /** Value for a query parameters that gets inserted into storefront URLs for matching storefront traffic to this activity. This feature is currently available on a limited basis to some partners only. UTMs should continue to be used for most partners. Either the URL parameter value or UTM can be set, but not both. */
  urlParameterValue?: InputMaybe<Scalars["String"]["input"]>
  /** Specifies the [Urchin Traffic Module (UTM) parameters](https://en.wikipedia.org/wiki/UTM_parameters) that are associated with a related marketing campaign. Either the URL parameter value or UTM can be set, but not both. */
  utm?: InputMaybe<UtmInput>
}

/** Return type for `marketingActivityCreateExternal` mutation. */
export type MarketingActivityCreateExternalPayload = {
  __typename?: "MarketingActivityCreateExternalPayload"
  /** The external marketing activity that was created. */
  marketingActivity?: Maybe<MarketingActivity>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketingActivityUserError>
}

/** The input fields required to create a marketing activity. */
export type MarketingActivityCreateInput = {
  /** The budget for this marketing activity. */
  budget?: InputMaybe<MarketingActivityBudgetInput>
  /** Encoded context containing marketing campaign id. */
  context?: InputMaybe<Scalars["String"]["input"]>
  /** The form data in JSON serialized as a string. */
  formData?: InputMaybe<Scalars["String"]["input"]>
  /** The ID of the marketing activity extension. */
  marketingActivityExtensionId: Scalars["ID"]["input"]
  /** The title of the marketing activity. */
  marketingActivityTitle?: InputMaybe<Scalars["String"]["input"]>
  /** The current state of the marketing activity. */
  status: MarketingActivityStatus
  /**
   * Specifies the
   * [Urchin Traffic Module (UTM) parameters](https://en.wikipedia.org/wiki/UTM_parameters)
   * that are associated with a related marketing campaign. UTMInput is required for all Marketing
   * tactics except Storefront App.
   *
   */
  utm?: InputMaybe<UtmInput>
}

/** Return type for `marketingActivityCreate` mutation. */
export type MarketingActivityCreatePayload = {
  __typename?: "MarketingActivityCreatePayload"
  /** The created marketing activity. */
  marketingActivity?: Maybe<MarketingActivity>
  /** The path to return back to shopify admin from embedded editor. */
  redirectPath?: Maybe<Scalars["String"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `marketingActivityDeleteExternal` mutation. */
export type MarketingActivityDeleteExternalPayload = {
  __typename?: "MarketingActivityDeleteExternalPayload"
  /** The ID of the marketing activity that was deleted, if one was deleted. */
  deletedMarketingActivityId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketingActivityUserError>
}

/**
 * An auto-generated type which holds one MarketingActivity and a cursor during pagination.
 *
 */
export type MarketingActivityEdge = {
  __typename?: "MarketingActivityEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of MarketingActivityEdge. */
  node: MarketingActivity
}

/** The error code resulted from the marketing activity extension integration. */
export enum MarketingActivityExtensionAppErrorCode {
  /** The app is either not responding or returning unexpected data. */
  ApiError = "API_ERROR",
  /** The app needs to be installed. */
  InstallRequiredError = "INSTALL_REQUIRED_ERROR",
  /** The shop/user must be onboarded to use the app. */
  NotOnboardedError = "NOT_ONBOARDED_ERROR",
  /** The app has returned an error when invoking the platform. */
  PlatformError = "PLATFORM_ERROR",
  /** The app has returned validation errors. */
  ValidationError = "VALIDATION_ERROR",
}

/** Represents errors returned from apps when using the marketing activity extension. */
export type MarketingActivityExtensionAppErrors = {
  __typename?: "MarketingActivityExtensionAppErrors"
  /** The app error type. */
  code: MarketingActivityExtensionAppErrorCode
  /** The list of errors returned by the app. */
  userErrors: Array<UserError>
}

/** Set of possible statuses for an external marketing activity. */
export enum MarketingActivityExternalStatus {
  /** This marketing activity is currently running. */
  Active = "ACTIVE",
  /** This marketing activity was deleted and it was triggered from outside of Shopify. */
  DeletedExternally = "DELETED_EXTERNALLY",
  /** This marketing activity has completed running. */
  Inactive = "INACTIVE",
  /** This marketing activity is currently not running. */
  Paused = "PAUSED",
  /** This marketing activity is scheduled to run. */
  Scheduled = "SCHEDULED",
  /** The marketing activity's status is unknown. */
  Undefined = "UNDEFINED",
}

/** Hierarchy levels for external marketing activities. */
export enum MarketingActivityHierarchyLevel {
  /** An advertisement activity. Must be parented by an ad group or a campaign activity, and must be assigned tracking parameters (URL or UTM). */
  Ad = "AD",
  /** A group of advertisement activities. Must be parented by a campaign activity. */
  AdGroup = "AD_GROUP",
  /** A campaign activity. May contain either ad groups or ads as child activities. If childless, then the campaign activity should have tracking parameters assigned (URL or UTM) otherwise it won't appear in marketing reports. */
  Campaign = "CAMPAIGN",
}

/** The set of valid sort keys for the MarketingActivity query. */
export enum MarketingActivitySortKeys {
  /** Sort by the `created_at` value. */
  CreatedAt = "CREATED_AT",
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `title` value. */
  Title = "TITLE",
}

/** Status helps to identify if this marketing activity has been completed, queued, failed etc. */
export enum MarketingActivityStatus {
  /** This marketing activity is currently running. */
  Active = "ACTIVE",
  /** This marketing activity is permanently unavailable. */
  Deleted = "DELETED",
  /** This marketing activity was deleted and it was triggered from outside of Shopify. */
  DeletedExternally = "DELETED_EXTERNALLY",
  /** This marketing activity is disconnected and no longer editable. */
  Disconnected = "DISCONNECTED",
  /** This marketing activity has been edited, but it is not yet created. */
  Draft = "DRAFT",
  /** This marketing activity is unable to run. */
  Failed = "FAILED",
  /** This marketing activity has completed running. */
  Inactive = "INACTIVE",
  /** This marketing activity is currently not running. */
  Paused = "PAUSED",
  /** This marketing activity is pending creation on the app's marketing platform. */
  Pending = "PENDING",
  /** This marketing activity is scheduled to run. */
  Scheduled = "SCHEDULED",
  /** The marketing activity's status is unknown. */
  Undefined = "UNDEFINED",
}

/** StatusBadgeType helps to identify the color of the status badge. */
export enum MarketingActivityStatusBadgeType {
  /** This status badge has type attention. */
  Attention = "ATTENTION",
  /** This status badge has type default. */
  Default = "DEFAULT",
  /** This status badge has type info. */
  Info = "INFO",
  /** This status badge has type success. */
  Success = "SUCCESS",
  /** This status badge has type warning. */
  Warning = "WARNING",
}

/** The input fields required to update an externally managed marketing activity. */
export type MarketingActivityUpdateExternalInput = {
  /** The amount spent on the marketing activity. */
  adSpend?: InputMaybe<MoneyInput>
  /** The budget for this marketing activity. */
  budget?: InputMaybe<MarketingActivityBudgetInput>
  /** The date and time at which the activity ended. */
  end?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The medium through which the marketing activity and event reached consumers. This is used for reporting aggregation. */
  marketingChannelType?: InputMaybe<MarketingChannel>
  /** The domain from which ad clicks are forwarded to the shop. */
  referringDomain?: InputMaybe<Scalars["String"]["input"]>
  /** The URL for a preview image that's used for the marketing activity. */
  remotePreviewImageUrl?: InputMaybe<Scalars["URL"]["input"]>
  /** The URL for viewing and/or managing the activity outside of Shopify. */
  remoteUrl?: InputMaybe<Scalars["URL"]["input"]>
  /** The date and time at which the activity is scheduled to end. */
  scheduledEnd?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The date and time at which the activity is scheduled to start. */
  scheduledStart?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The date and time at which the activity started. */
  start?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The status of the marketing activity. */
  status?: InputMaybe<MarketingActivityExternalStatus>
  /** The method of marketing used for this marketing activity. The marketing tactic determines which default fields are included in the marketing activity. */
  tactic?: InputMaybe<MarketingTactic>
  /** The title of the marketing activity. */
  title?: InputMaybe<Scalars["String"]["input"]>
}

/** Return type for `marketingActivityUpdateExternal` mutation. */
export type MarketingActivityUpdateExternalPayload = {
  __typename?: "MarketingActivityUpdateExternalPayload"
  /** The updated marketing activity. */
  marketingActivity?: Maybe<MarketingActivity>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketingActivityUserError>
}

/** The input fields required to update a marketing activity. */
export type MarketingActivityUpdateInput = {
  /** The budget for the marketing activity. */
  budget?: InputMaybe<MarketingActivityBudgetInput>
  /**
   * The error messages that were generated when the app was trying to complete the activity.
   * Learn more about the
   * [JSON format expected for error messages](/api/marketing-activities/statuses#failed-status).
   *
   */
  errors?: InputMaybe<Scalars["JSON"]["input"]>
  /**
   * The form data of the marketing activity. This is only used if the marketing activity is
   *               integrated with the external editor.
   */
  formData?: InputMaybe<Scalars["String"]["input"]>
  /** The ID of the marketing activity. */
  id: Scalars["ID"]["input"]
  /**
   * A list of the item IDs that were marketed in this marketing activity. Valid types for these items are:
   * * `Product`
   * * `Shop`
   *
   */
  marketedResources?: InputMaybe<Array<Scalars["ID"]["input"]>>
  /** The ID of the recommendation that the marketing activity was created from, if one exists. */
  marketingRecommendationId?: InputMaybe<Scalars["ID"]["input"]>
  /**
   * The current state of the marketing activity. Learn more about
   * [marketing activities statuses](/api/marketing-activities/statuses).
   *
   */
  status?: InputMaybe<MarketingActivityStatus>
  /** The target state that the marketing activity is transitioning to. Learn more about [marketing activities statuses](/api/marketing-activities/statuses). */
  targetStatus?: InputMaybe<MarketingActivityStatus>
  /** The title of the marketing activity. */
  title?: InputMaybe<Scalars["String"]["input"]>
  /**
   * Specifies the
   * [Urchin Traffic Module (UTM) parameters](https://en.wikipedia.org/wiki/UTM_parameters)
   * that are associated with a related marketing campaign. UTMInput is required for all Marketing
   * tactics except Storefront App. The utm field can only be set once and never modified.
   *
   */
  utm?: InputMaybe<UtmInput>
}

/** Return type for `marketingActivityUpdate` mutation. */
export type MarketingActivityUpdatePayload = {
  __typename?: "MarketingActivityUpdatePayload"
  /** The updated marketing activity. */
  marketingActivity?: Maybe<MarketingActivity>
  /** The redirect path from the embedded editor to the Shopify admin. */
  redirectPath?: Maybe<Scalars["String"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The input fields for creating or updating an externally-managed marketing activity. */
export type MarketingActivityUpsertExternalInput = {
  /** The amount spent on the marketing activity. */
  adSpend?: InputMaybe<MoneyInput>
  /** The budget for this marketing activity. */
  budget?: InputMaybe<MarketingActivityBudgetInput>
  /** The unique string identifier of the channel to which this activity belongs. For the correct handle for your channel, contact your partner manager. */
  channelHandle?: InputMaybe<Scalars["String"]["input"]>
  /** The date and time at which the activity started. On creation, if this field is omitted or set to `null`, the current time will be used if the status is set to `INACTIVE` or `DELETED_EXTERNALLY` . */
  end?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The hierarchy level of the activity within a campaign. The hierarchy level can't be updated. */
  hierarchyLevel?: InputMaybe<MarketingActivityHierarchyLevel>
  /** The medium through which the marketing activity and event reached consumers. This is used for reporting aggregation. */
  marketingChannelType: MarketingChannel
  /** The remote ID for the parent marketing activity, if creating hierarchical activities. */
  parentRemoteId?: InputMaybe<Scalars["String"]["input"]>
  /** The domain from which ad clicks are forwarded to the shop. */
  referringDomain?: InputMaybe<Scalars["String"]["input"]>
  /** The ID of an activity that's hosted outside of Shopify. */
  remoteId: Scalars["String"]["input"]
  /** The URL for a preview image that's used for the marketing activity. */
  remotePreviewImageUrl?: InputMaybe<Scalars["URL"]["input"]>
  /** The URL for viewing and/or managing the activity outside of Shopify. */
  remoteUrl: Scalars["URL"]["input"]
  /** The date and time at which the activity is scheduled to end. */
  scheduledEnd?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The date and time at which the activity is scheduled to start. */
  scheduledStart?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The date and time at which the activity started. On creation, if this field is omitted or set to `null`, the current time will be used. */
  start?: InputMaybe<Scalars["DateTime"]["input"]>
  /** The status of the marketing activity. */
  status: MarketingActivityExternalStatus
  /** The method of marketing used for this marketing activity. The marketing tactic determines which default fields are included in the marketing activity. */
  tactic: MarketingTactic
  /** The title of the marketing activity. */
  title: Scalars["String"]["input"]
  /** Value for a query parameters that gets inserted into storefront URLs for matching storefront traffic to this activity. This feature is currently available on a limited basis to some partners only. UTMs should continue to be used for most partners. Either the URL parameter value or UTM can be set, but not both. */
  urlParameterValue?: InputMaybe<Scalars["String"]["input"]>
  /** Specifies the [Urchin Traffic Module (UTM) parameters](https://en.wikipedia.org/wiki/UTM_parameters) that are associated with a related marketing campaign. Either the URL parameter value or UTM can be set, but not both. */
  utm?: InputMaybe<UtmInput>
}

/** Return type for `marketingActivityUpsertExternal` mutation. */
export type MarketingActivityUpsertExternalPayload = {
  __typename?: "MarketingActivityUpsertExternalPayload"
  /** The external marketing activity that was created or updated. */
  marketingActivity?: Maybe<MarketingActivity>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketingActivityUserError>
}

/** An error that occurs during the execution of a Shopify Marketing mutation. */
export type MarketingActivityUserError = DisplayableError & {
  __typename?: "MarketingActivityUserError"
  /** The error code. */
  code?: Maybe<MarketingActivityUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `MarketingActivityUserError`. */
export enum MarketingActivityUserErrorCode {
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** The input value is already taken. */
  Taken = "TAKEN",
}

/**
 * This type combines budget amount and its marketing budget type.
 *
 */
export type MarketingBudget = {
  __typename?: "MarketingBudget"
  /** The budget type for a marketing activity. */
  budgetType: MarketingBudgetBudgetType
  /** The amount of budget for marketing activity. */
  total: MoneyV2
}

/** The budget type for a marketing activity. */
export enum MarketingBudgetBudgetType {
  /** A daily budget. */
  Daily = "DAILY",
  /** A budget for the lifetime of a marketing activity. */
  Lifetime = "LIFETIME",
}

/** The medium through which the marketing activity and event reached consumers. This is used for reporting aggregation. */
export enum MarketingChannel {
  /** Displayed ads. */
  Display = "DISPLAY",
  /** Email. */
  Email = "EMAIL",
  /** Referral links. */
  Referral = "REFERRAL",
  /** Paid search. */
  Search = "SEARCH",
  /** Social media. */
  Social = "SOCIAL",
}

/** Marketing engagement represents customer activity taken on a marketing activity or a marketing channel. */
export type MarketingEngagement = {
  __typename?: "MarketingEngagement"
  /** The total ad spend for the marketing content. Recurring weekly, monthly, or yearly spend needs to be divided into daily amounts. */
  adSpend?: Maybe<MoneyV2>
  /** The unique string identifier of the channel to which the engagement metrics are being provided. This should be set when and only when providing channel-level engagements. This should be nil when providing activity-level engagements. For the correct handle for your channel, contact your partner manager. */
  channelHandle?: Maybe<Scalars["String"]["output"]>
  /** The total number of interactions, such as a button press or a screen touch, that occurred on the marketing content. */
  clicksCount?: Maybe<Scalars["Int"]["output"]>
  /** The total number of comments on the marketing content. */
  commentsCount?: Maybe<Scalars["Int"]["output"]>
  /** The total number of complaints on the marketing content. For message-based platforms such as email or SMS, this represents the number of marketing emails or messages that were marked as spam. For social media platforms, this represents the number of dislikes or the number of times marketing content was reported. */
  complaintsCount?: Maybe<Scalars["Int"]["output"]>
  /** The total number of fails for the marketing content. For message-based platforms such as email or SMS, this represents the number of bounced marketing emails or messages. */
  failsCount?: Maybe<Scalars["Int"]["output"]>
  /** The total number of favorites, likes, saves, or bookmarks on the marketing content. */
  favoritesCount?: Maybe<Scalars["Int"]["output"]>
  /** The number of customers that have placed their first order. Doesn't include adjustments such as edits, exchanges, or returns. */
  firstTimeCustomers?: Maybe<Scalars["Decimal"]["output"]>
  /** The total number of times marketing content was displayed to users, whether or not an interaction occurred. For message-based platforms such as email or SMS, this represents the number of marketing emails or messages that were delivered. */
  impressionsCount?: Maybe<Scalars["Int"]["output"]>
  /** Whether the engagements are reported as lifetime totals rather than daily increments. */
  isCumulative: Scalars["Boolean"]["output"]
  /** The marketing activity object related to this engagement. This corresponds to the marketingActivityId passed in on creation of the engagement. */
  marketingActivity?: Maybe<MarketingActivity>
  /** The date that the engagements occurred on. */
  occurredOn: Scalars["Date"]["output"]
  /** The number of orders generated from the marketing content. */
  orders?: Maybe<Scalars["Decimal"]["output"]>
  /** The number of returning customers that have placed an order. Doesn't include adjustments such as edits, exchanges, or returns. */
  returningCustomers?: Maybe<Scalars["Decimal"]["output"]>
  /** The amount of sales generated from the marketing content. */
  sales?: Maybe<MoneyV2>
  /** The total number of marketing emails or messages that were sent. */
  sendsCount?: Maybe<Scalars["Int"]["output"]>
  /** The number of online store sessions generated from the marketing content. */
  sessionsCount?: Maybe<Scalars["Int"]["output"]>
  /** The total number of times marketing content was distributed or reposted to either one's own network of followers through a social media platform or other digital channels. For message-based platforms such as email or SMS, this represents the number of times marketing emails or messages were forwarded. */
  sharesCount?: Maybe<Scalars["Int"]["output"]>
  /** The total number of unique clicks on the marketing content. */
  uniqueClicksCount?: Maybe<Scalars["Int"]["output"]>
  /** The total number of all users who saw marketing content since it was published. For  message-based platforms such as email or SMS, this represents the number of unique users that opened a  marketing email or message. For video-based content, this represents the number of unique users that  played video content. */
  uniqueViewsCount?: Maybe<Scalars["Int"]["output"]>
  /** The total number of unsubscribes on the marketing content. For social media platforms, this represents the number of unfollows. */
  unsubscribesCount?: Maybe<Scalars["Int"]["output"]>
  /** The time difference, in hours, between UTC and the time zone used to aggregate these metrics. */
  utcOffset: Scalars["UtcOffset"]["output"]
  /** The total number of views on the marketing content. For message-based platforms such as email or SMS, this represents the number of times marketing emails or messages were opened. For video-based content, this represents the number of times videos were played. */
  viewsCount?: Maybe<Scalars["Int"]["output"]>
}

/** Return type for `marketingEngagementCreate` mutation. */
export type MarketingEngagementCreatePayload = {
  __typename?: "MarketingEngagementCreatePayload"
  /** The marketing engagement that was created. This represents customer activity taken on a marketing activity or a marketing channel. */
  marketingEngagement?: Maybe<MarketingEngagement>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** The input fields for a marketing engagement. */
export type MarketingEngagementInput = {
  /** The total ad spend for the marketing content. Recurring weekly, monthly, or yearly spend needs to be divided into daily amounts. */
  adSpend?: InputMaybe<MoneyInput>
  /** The total number of interactions, such as a button press or a screen touch, that occurred on the marketing content. */
  clicksCount?: InputMaybe<Scalars["Int"]["input"]>
  /** The total number of comments on the marketing content. */
  commentsCount?: InputMaybe<Scalars["Int"]["input"]>
  /** The total number of complaints on the marketing content. For message-based platforms such as email or SMS, this represents the number of marketing emails or messages that were marked as spam. For social media platforms, this represents the number of dislikes or the number of times marketing content was reported. */
  complaintsCount?: InputMaybe<Scalars["Int"]["input"]>
  /** The total number of fails for the marketing content. For message-based platforms such as email or SMS, this represents the number of bounced marketing emails or messages. */
  failsCount?: InputMaybe<Scalars["Int"]["input"]>
  /** The total number of favorites, likes, saves, or bookmarks on the marketing content. */
  favoritesCount?: InputMaybe<Scalars["Int"]["input"]>
  /** The number of customers that have placed their first order. Doesn't include adjustments such as edits, exchanges, or returns. */
  firstTimeCustomers?: InputMaybe<Scalars["Decimal"]["input"]>
  /** The total number of times marketing content was displayed to users, whether or not an interaction occurred. For message-based platforms such as email or SMS, this represents the number of marketing emails or messages that were delivered. */
  impressionsCount?: InputMaybe<Scalars["Int"]["input"]>
  /** Whether the engagements are reported as lifetime totals rather than daily increments. */
  isCumulative: Scalars["Boolean"]["input"]
  /** The date that the engagements occurred on. */
  occurredOn: Scalars["Date"]["input"]
  /** The number of orders generated from the marketing content. */
  orders?: InputMaybe<Scalars["Decimal"]["input"]>
  /** The number of returning customers that have placed an order. Doesn't include adjustments such as edits, exchanges, or returns. */
  returningCustomers?: InputMaybe<Scalars["Decimal"]["input"]>
  /** The amount of sales generated from the marketing content. */
  sales?: InputMaybe<MoneyInput>
  /** The total number of marketing emails or messages that were sent. */
  sendsCount?: InputMaybe<Scalars["Int"]["input"]>
  /** The number of online store sessions generated from the marketing content. */
  sessionsCount?: InputMaybe<Scalars["Int"]["input"]>
  /** The total number of times marketing content was distributed or reposted to either one's own network of followers through a social media platform or other digital channels. For message-based platforms such as email or SMS, this represents the number of times marketing emails or messages were forwarded. */
  sharesCount?: InputMaybe<Scalars["Int"]["input"]>
  /** The total number of unique clicks on the marketing content. */
  uniqueClicksCount?: InputMaybe<Scalars["Int"]["input"]>
  /** The total number of all users who saw marketing content since it was published. For  message-based platforms such as email or SMS, this represents the number of unique users that opened a  marketing email or message. For video-based content, this represents the number of unique users that  played video content. */
  uniqueViewsCount?: InputMaybe<Scalars["Int"]["input"]>
  /** The total number of unsubscribes on the marketing content. For social media platforms, this represents the number of unfollows. */
  unsubscribesCount?: InputMaybe<Scalars["Int"]["input"]>
  /** The time difference, in hours, between UTC and the time zone used to aggregate these metrics. */
  utcOffset: Scalars["UtcOffset"]["input"]
  /** The total number of views on the marketing content. For message-based platforms such as email or SMS, this represents the number of times marketing emails or messages were opened. For video-based content, this represents the number of times videos were played. */
  viewsCount?: InputMaybe<Scalars["Int"]["input"]>
}

/** Return type for `marketingEngagementsDelete` mutation. */
export type MarketingEngagementsDeletePayload = {
  __typename?: "MarketingEngagementsDeletePayload"
  /** Informational message about the engagement data that has been marked for deletion. */
  result?: Maybe<Scalars["String"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MarketingActivityUserError>
}

/** Represents actions that market a merchant's store or products. */
export type MarketingEvent = LegacyInteroperability &
  Node & {
    __typename?: "MarketingEvent"
    /** The app that the marketing event is attributed to. */
    app: App
    /**
     * The medium through which the marketing activity and event reached consumers. This is used for reporting aggregation.
     * @deprecated Use `marketingChannelType` instead.
     */
    channel?: Maybe<MarketingChannel>
    /** The unique string identifier of the channel to which this activity belongs. For the correct handle for your channel, contact your partner manager. */
    channelHandle?: Maybe<Scalars["String"]["output"]>
    /** A human-readable description of the marketing event. */
    description?: Maybe<Scalars["String"]["output"]>
    /** The date and time when the marketing event ended. */
    endedAt?: Maybe<Scalars["DateTime"]["output"]>
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The ID of the corresponding resource in the REST Admin API. */
    legacyResourceId: Scalars["UnsignedInt64"]["output"]
    /** The URL where the marketing event can be managed. */
    manageUrl?: Maybe<Scalars["URL"]["output"]>
    /** The medium through which the marketing activity and event reached consumers. This is used for reporting aggregation. */
    marketingChannelType?: Maybe<MarketingChannel>
    /** The URL where the marketing event can be previewed. */
    previewUrl?: Maybe<Scalars["URL"]["output"]>
    /** An optional ID that helps Shopify validate engagement data. */
    remoteId?: Maybe<Scalars["String"]["output"]>
    /** The date and time when the marketing event is scheduled to end. */
    scheduledToEndAt?: Maybe<Scalars["DateTime"]["output"]>
    /**
     * Where the `MarketingEvent` occurred and what kind of content was used.
     * Because `utmSource` and `utmMedium` are often used interchangeably, this is
     * based on a combination of `marketingChannel`, `referringDomain`, and `type` to
     * provide a consistent representation for any given piece of marketing
     * regardless of the app that created it.
     *
     */
    sourceAndMedium: Scalars["String"]["output"]
    /** The date and time when the marketing event started. */
    startedAt: Scalars["DateTime"]["output"]
    /**
     * The display text for the marketing event type.
     * @deprecated Use `sourceAndMedium` instead.
     */
    targetTypeDisplayText: Scalars["String"]["output"]
    /** The marketing event type. */
    type: MarketingTactic
    /** The name of the marketing campaign. */
    utmCampaign?: Maybe<Scalars["String"]["output"]>
    /** The medium that the marketing campaign is using. Example values: `cpc`, `banner`. */
    utmMedium?: Maybe<Scalars["String"]["output"]>
    /** The referrer of the marketing event. Example values: `google`, `newsletter`. */
    utmSource?: Maybe<Scalars["String"]["output"]>
  }

/**
 * An auto-generated type for paginating through multiple MarketingEvents.
 *
 */
export type MarketingEventConnection = {
  __typename?: "MarketingEventConnection"
  /** A list of edges. */
  edges: Array<MarketingEventEdge>
  /** A list of the nodes contained in MarketingEventEdge. */
  nodes: Array<MarketingEvent>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one MarketingEvent and a cursor during pagination.
 *
 */
export type MarketingEventEdge = {
  __typename?: "MarketingEventEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of MarketingEventEdge. */
  node: MarketingEvent
}

/** The set of valid sort keys for the MarketingEvent query. */
export enum MarketingEventSortKeys {
  /** Sort by the `id` value. */
  Id = "ID",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
  /** Sort by the `started_at` value. */
  StartedAt = "STARTED_AT",
}

/** The available types of marketing event. */
export enum MarketingTactic {
  /** An abandoned cart recovery email. */
  AbandonedCart = "ABANDONED_CART",
  /** An ad, such as a Facebook ad. */
  Ad = "AD",
  /** An affiliate link. */
  Affiliate = "AFFILIATE",
  /** A direct visit to the online store. */
  Direct = "DIRECT",
  /**
   * A display ad.
   * @deprecated `DISPLAY` is deprecated. Use `AD` instead.
   */
  Display = "DISPLAY",
  /**
   * A follow-up email.
   * @deprecated 'FOLLOW_UP' is deprecated. Use 'TRANSACTIONAL' instead.
   */
  FollowUp = "FOLLOW_UP",
  /** A link. */
  Link = "LINK",
  /** A loyalty program. */
  Loyalty = "LOYALTY",
  /** A messaging app, such as Facebook Messenger. */
  Message = "MESSAGE",
  /** A newsletter. */
  Newsletter = "NEWSLETTER",
  /** A notification in the Shopify admin. */
  Notification = "NOTIFICATION",
  /** A blog post. */
  Post = "POST",
  /**
   * A promotional receipt.
   * @deprecated 'RECEIPT' is deprecated. Use 'TRANSACTIONAL' instead.
   */
  Receipt = "RECEIPT",
  /** A retargeting ad. */
  Retargeting = "RETARGETING",
  /**
   * Paid search.
   * @deprecated `SEARCH` is deprecated. Use `AD` instead.
   */
  Search = "SEARCH",
  /** Search engine optimization. */
  Seo = "SEO",
  /** A popup on the online store. */
  StorefrontApp = "STOREFRONT_APP",
  /** A transactional email. */
  Transactional = "TRANSACTIONAL",
}

/** Represents a media interface. */
export type Media = {
  /** A word or phrase to share the nature or contents of a media. */
  alt?: Maybe<Scalars["String"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The media content type. */
  mediaContentType: MediaContentType
  /** Any errors which have occurred on the media. */
  mediaErrors: Array<MediaError>
  /** The warnings attached to the media. */
  mediaWarnings: Array<MediaWarning>
  /** The preview image for the media. */
  preview?: Maybe<MediaPreviewImage>
  /** Current status of the media. */
  status: MediaStatus
}

/**
 * An auto-generated type for paginating through multiple Media.
 *
 */
export type MediaConnection = {
  __typename?: "MediaConnection"
  /** A list of edges. */
  edges: Array<MediaEdge>
  /** A list of the nodes contained in MediaEdge. */
  nodes: Array<Media>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** The possible content types for a media object. */
export enum MediaContentType {
  /** An externally hosted video. */
  ExternalVideo = "EXTERNAL_VIDEO",
  /** A Shopify-hosted image. */
  Image = "IMAGE",
  /** A 3d model. */
  Model_3D = "MODEL_3D",
  /** A Shopify-hosted video. */
  Video = "VIDEO",
}

/**
 * An auto-generated type which holds one Media and a cursor during pagination.
 *
 */
export type MediaEdge = {
  __typename?: "MediaEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of MediaEdge. */
  node: Media
}

/**
 * Represents a media error. This typically occurs when there is an issue with the media itself causing it to fail validation.
 * Check the media before attempting to upload again.
 *
 */
export type MediaError = {
  __typename?: "MediaError"
  /** Code representing the type of error. */
  code: MediaErrorCode
  /** Additional details regarding the error. */
  details?: Maybe<Scalars["String"]["output"]>
  /** Translated error message. */
  message: Scalars["String"]["output"]
}

/** Error types for media. */
export enum MediaErrorCode {
  /** Media could not be created because a file with the same name already exists. */
  DuplicateFilenameError = "DUPLICATE_FILENAME_ERROR",
  /** Media could not be created because embed permissions are disabled for this video. */
  ExternalVideoEmbedDisabled = "EXTERNAL_VIDEO_EMBED_DISABLED",
  /** Media could not be created because video is either not found or still transcoding. */
  ExternalVideoEmbedNotFoundOrTranscoding = "EXTERNAL_VIDEO_EMBED_NOT_FOUND_OR_TRANSCODING",
  /** Media could not be created because the external video has an invalid aspect ratio. */
  ExternalVideoInvalidAspectRatio = "EXTERNAL_VIDEO_INVALID_ASPECT_RATIO",
  /** Media could not be created because the external video could not be found. */
  ExternalVideoNotFound = "EXTERNAL_VIDEO_NOT_FOUND",
  /** Media could not be created because the external video is not listed or is private. */
  ExternalVideoUnlisted = "EXTERNAL_VIDEO_UNLISTED",
  /** Media could not be created because the cumulative file storage limit would be exceeded. */
  FileStorageLimitExceeded = "FILE_STORAGE_LIMIT_EXCEEDED",
  /** File could not be processed because the source could not be downloaded. */
  GenericFileDownloadFailure = "GENERIC_FILE_DOWNLOAD_FAILURE",
  /** File could not be created because the size is too large. */
  GenericFileInvalidSize = "GENERIC_FILE_INVALID_SIZE",
  /** Media could not be processed because the image could not be downloaded. */
  ImageDownloadFailure = "IMAGE_DOWNLOAD_FAILURE",
  /** Media could not be processed because the image could not be processed. */
  ImageProcessingFailure = "IMAGE_PROCESSING_FAILURE",
  /** Media could not be created because the image has an invalid aspect ratio. */
  InvalidImageAspectRatio = "INVALID_IMAGE_ASPECT_RATIO",
  /** Media could not be created because the image size is too large. */
  InvalidImageFileSize = "INVALID_IMAGE_FILE_SIZE",
  /** Media could not be created because the image's resolution exceeds the max limit. */
  InvalidImageResolution = "INVALID_IMAGE_RESOLUTION",
  /** Media could not be processed because the signed URL was invalid. */
  InvalidSignedUrl = "INVALID_SIGNED_URL",
  /** Media timed out because it is currently being modified by another operation. */
  MediaTimeoutError = "MEDIA_TIMEOUT_ERROR",
  /** Media could not be created because the model file failed processing. */
  Model3DGlbOutputCreationError = "MODEL3D_GLB_OUTPUT_CREATION_ERROR",
  /** Media could not be created because the model can't be converted to USDZ format. */
  Model3DGlbToUsdzConversionError = "MODEL3D_GLB_TO_USDZ_CONVERSION_ERROR",
  /** Media could not be created because the model file failed processing. */
  Model3DProcessingFailure = "MODEL3D_PROCESSING_FAILURE",
  /** Media could not be created because the model's thumbnail generation failed. */
  Model3DThumbnailGenerationError = "MODEL3D_THUMBNAIL_GENERATION_ERROR",
  /** There was an issue while trying to generate a new thumbnail. */
  Model3DThumbnailRegenerationError = "MODEL3D_THUMBNAIL_REGENERATION_ERROR",
  /** Model failed validation. */
  Model3DValidationError = "MODEL3D_VALIDATION_ERROR",
  /** Media error has occured for unknown reason. */
  Unknown = "UNKNOWN",
  /** Media could not be created because the image is an unsupported file type. */
  UnsupportedImageFileType = "UNSUPPORTED_IMAGE_FILE_TYPE",
  /** Media could not be created because it has an invalid file type. */
  VideoInvalidFiletypeError = "VIDEO_INVALID_FILETYPE_ERROR",
  /** Media could not be created because it does not meet the maximum duration requirement. */
  VideoMaxDurationError = "VIDEO_MAX_DURATION_ERROR",
  /** Media could not be created because it does not meet the maximum height requirement. */
  VideoMaxHeightError = "VIDEO_MAX_HEIGHT_ERROR",
  /** Media could not be created because it does not meet the maximum width requirement. */
  VideoMaxWidthError = "VIDEO_MAX_WIDTH_ERROR",
  /** Media could not be created because the metadata could not be read. */
  VideoMetadataReadError = "VIDEO_METADATA_READ_ERROR",
  /** Media could not be created because it does not meet the minimum duration requirement. */
  VideoMinDurationError = "VIDEO_MIN_DURATION_ERROR",
  /** Media could not be created because it does not meet the minimum height requirement. */
  VideoMinHeightError = "VIDEO_MIN_HEIGHT_ERROR",
  /** Media could not be created because it does not meet the minimum width requirement. */
  VideoMinWidthError = "VIDEO_MIN_WIDTH_ERROR",
  /** Video failed validation. */
  VideoValidationError = "VIDEO_VALIDATION_ERROR",
}

/** Host for a Media Resource. */
export enum MediaHost {
  /** Host for Vimeo embedded videos. */
  Vimeo = "VIMEO",
  /** Host for YouTube embedded videos. */
  Youtube = "YOUTUBE",
}

/**
 * An image hosted on Shopify.
 *
 */
export type MediaImage = File &
  HasMetafields &
  Media &
  Node & {
    __typename?: "MediaImage"
    /** A word or phrase to share the nature or contents of a media. */
    alt?: Maybe<Scalars["String"]["output"]>
    /**
     * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) when the file was created.
     *
     */
    createdAt: Scalars["DateTime"]["output"]
    /** Any errors that have occurred on the file. */
    fileErrors: Array<FileError>
    /** The status of the file. */
    fileStatus: FileStatus
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The image for the media. Returns `null` until `status` is `READY`. */
    image?: Maybe<Image>
    /** The media content type. */
    mediaContentType: MediaContentType
    /** Any errors which have occurred on the media. */
    mediaErrors: Array<MediaError>
    /** The warnings attached to the media. */
    mediaWarnings: Array<MediaWarning>
    /** Returns a metafield by namespace and key that belongs to the resource. */
    metafield?: Maybe<Metafield>
    /** List of metafields that belong to the resource. */
    metafields: MetafieldConnection
    /** The MIME type of the image. */
    mimeType?: Maybe<Scalars["String"]["output"]>
    /** The original source of the image. */
    originalSource?: Maybe<MediaImageOriginalSource>
    /** The preview image for the media. */
    preview?: Maybe<MediaPreviewImage>
    /**
     * Returns a private metafield by namespace and key that belongs to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafield?: Maybe<PrivateMetafield>
    /**
     * List of private metafields that belong to the resource.
     * @deprecated Metafields created using a reserved namespace are private by default. See our guide for
     * [migrating private metafields](https://shopify.dev/docs/apps/custom-data/metafields/migrate-private-metafields).
     *
     */
    privateMetafields: PrivateMetafieldConnection
    /** Current status of the media. */
    status: MediaStatus
    /** The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) when the file was last updated. */
    updatedAt: Scalars["DateTime"]["output"]
  }

/**
 * An image hosted on Shopify.
 *
 */
export type MediaImageMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace?: InputMaybe<Scalars["String"]["input"]>
}

/**
 * An image hosted on Shopify.
 *
 */
export type MediaImageMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  keys?: InputMaybe<Array<Scalars["String"]["input"]>>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * An image hosted on Shopify.
 *
 */
export type MediaImagePrivateMetafieldArgs = {
  key: Scalars["String"]["input"]
  namespace: Scalars["String"]["input"]
}

/**
 * An image hosted on Shopify.
 *
 */
export type MediaImagePrivateMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  namespace?: InputMaybe<Scalars["String"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
}

/**
 * The original source for an image.
 *
 */
export type MediaImageOriginalSource = {
  __typename?: "MediaImageOriginalSource"
  /** The size of the original file in bytes. */
  fileSize?: Maybe<Scalars["Int"]["output"]>
  /** The URL of the original image, valid only for a short period. */
  url?: Maybe<Scalars["URL"]["output"]>
}

/** Represents the preview image for a media. */
export type MediaPreviewImage = {
  __typename?: "MediaPreviewImage"
  /** The preview image for the media. Returns `null` until `status` is `READY`. */
  image?: Maybe<Image>
  /** Current status of the preview image. */
  status: MediaPreviewImageStatus
}

/** The possible statuses for a media preview image. */
export enum MediaPreviewImageStatus {
  /** Preview image processing has failed. */
  Failed = "FAILED",
  /** Preview image is being processed. */
  Processing = "PROCESSING",
  /** Preview image is ready to be displayed. */
  Ready = "READY",
  /** Preview image is uploaded but not yet processed. */
  Uploaded = "UPLOADED",
}

/** The possible statuses for a media object. */
export enum MediaStatus {
  /** Media processing has failed. */
  Failed = "FAILED",
  /** Media is being processed. */
  Processing = "PROCESSING",
  /** Media is ready to be displayed. */
  Ready = "READY",
  /** Media has been uploaded but not yet processed. */
  Uploaded = "UPLOADED",
}

/** Represents an error that happens during execution of a Media query or mutation. */
export type MediaUserError = DisplayableError & {
  __typename?: "MediaUserError"
  /** The error code. */
  code?: Maybe<MediaUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `MediaUserError`. */
export enum MediaUserErrorCode {
  /** The input value is blank. */
  Blank = "BLANK",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** Invalid media type. */
  InvalidMediaType = "INVALID_MEDIA_TYPE",
  /** Exceeded the maximum number of 100 variant-media pairs per mutation call. */
  MaximumVariantMediaPairsExceeded = "MAXIMUM_VARIANT_MEDIA_PAIRS_EXCEEDED",
  /** Media cannot be modified. It is currently being modified by another operation. */
  MediaCannotBeModified = "MEDIA_CANNOT_BE_MODIFIED",
  /** Media does not exist. */
  MediaDoesNotExist = "MEDIA_DOES_NOT_EXIST",
  /** Media does not exist on the given product. */
  MediaDoesNotExistOnProduct = "MEDIA_DOES_NOT_EXIST_ON_PRODUCT",
  /** The specified media is not attached to the specified variant. */
  MediaIsNotAttachedToVariant = "MEDIA_IS_NOT_ATTACHED_TO_VARIANT",
  /** Model3d creation throttle was exceeded. */
  Model3DThrottleExceeded = "MODEL3D_THROTTLE_EXCEEDED",
  /** Model validation failed. */
  Model3DValidationError = "MODEL3D_VALIDATION_ERROR",
  /** Non-ready media are not supported. */
  NonReadyMedia = "NON_READY_MEDIA",
  /** Product does not exist. */
  ProductDoesNotExist = "PRODUCT_DOES_NOT_EXIST",
  /** Exceeded the limit of media per product. */
  ProductMediaLimitExceeded = "PRODUCT_MEDIA_LIMIT_EXCEEDED",
  /** Product variant already has attached media. */
  ProductVariantAlreadyHasMedia = "PRODUCT_VARIANT_ALREADY_HAS_MEDIA",
  /** Variant does not exist on the given product. */
  ProductVariantDoesNotExistOnProduct = "PRODUCT_VARIANT_DOES_NOT_EXIST_ON_PRODUCT",
  /** Variant specified in more than one pair. */
  ProductVariantSpecifiedMultipleTimes = "PRODUCT_VARIANT_SPECIFIED_MULTIPLE_TIMES",
  /** Exceeded the limit of media per shop. */
  ShopMediaLimitExceeded = "SHOP_MEDIA_LIMIT_EXCEEDED",
  /** Only one mediaId is allowed per variant-media input pair. */
  TooManyMediaPerInputPair = "TOO_MANY_MEDIA_PER_INPUT_PAIR",
  /** Video creation throttle was exceeded. */
  VideoThrottleExceeded = "VIDEO_THROTTLE_EXCEEDED",
  /** Video validation failed. */
  VideoValidationError = "VIDEO_VALIDATION_ERROR",
}

/**
 * Represents a media warning. This occurs when there is a non-blocking concern regarding your media.
 * Consider reviewing your media to ensure it is correct and its parameters are as expected.
 *
 */
export type MediaWarning = {
  __typename?: "MediaWarning"
  /** The code representing the type of warning. */
  code: MediaWarningCode
  /** Translated warning message. */
  message?: Maybe<Scalars["String"]["output"]>
}

/** Warning types for media. */
export enum MediaWarningCode {
  /** 3D model physical size might be invalid. The dimensions of your model are very large. Consider reviewing your model to ensure they are correct. */
  ModelLargePhysicalSize = "MODEL_LARGE_PHYSICAL_SIZE",
  /** 3D model physical size might be invalid. The dimensions of your model are very small. Consider reviewing your model to ensure they are correct. */
  ModelSmallPhysicalSize = "MODEL_SMALL_PHYSICAL_SIZE",
}

/** The class of the discount for combining purposes. */
export enum MerchandiseDiscountClass {
  /** Combined as an order discount. */
  Order = "ORDER",
  /** Combined as a product discount. */
  Product = "PRODUCT",
}

/** Merchant approval for accelerated onboarding to channel integration apps. */
export type MerchantApprovalSignals = {
  __typename?: "MerchantApprovalSignals"
  /** Whether the shop's Shopify Payments account identity is verified. Returns `false` if the identity is unverified or if the shop doesn't have a Shopify Payments account. */
  identityVerified: Scalars["Boolean"]["output"]
  /** Whether Shopify has pre-verified the merchant's business for onboarding to channel integration apps. Returns `false` if the shop isn't marked for verification. */
  verifiedByShopify: Scalars["Boolean"]["output"]
  /** Which tier of the Shopify verification was determined for the merchant's business for onboarding to channel integration apps. */
  verifiedByShopifyTier: Scalars["String"]["output"]
}

/**
 * Metafields enable you to attach additional information to a Shopify resource, such as a [Product](https://shopify.dev/api/admin-graphql/latest/objects/product) or a [Collection](https://shopify.dev/api/admin-graphql/latest/objects/collection).
 * For more information about where you can attach metafields refer to [HasMetafields](https://shopify.dev/api/admin/graphql/reference/common-objects/HasMetafields).
 * Some examples of the data that metafields enable you to store are specifications, size charts, downloadable documents, release dates, images, or part numbers.
 * Metafields are identified by an owner resource, namespace, and key. and store a value along with type information for that value.
 *
 */
export type Metafield = LegacyInteroperability &
  Node & {
    __typename?: "Metafield"
    /** The date and time when the metafield was created. */
    createdAt: Scalars["DateTime"]["output"]
    /** The metafield definition that the metafield belongs to, if any. */
    definition?: Maybe<MetafieldDefinition>
    /** The description of the metafield. */
    description?: Maybe<Scalars["String"]["output"]>
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The unique identifier for the metafield within its namespace. */
    key: Scalars["String"]["output"]
    /** The ID of the corresponding resource in the REST Admin API. */
    legacyResourceId: Scalars["UnsignedInt64"]["output"]
    /**
     * The container for a group of metafields that the metafield is associated with.
     *
     */
    namespace: Scalars["String"]["output"]
    /** The resource that the metafield is attached to. */
    owner: HasMetafields
    /**
     * The type of resource that the metafield is attached to.
     *
     */
    ownerType: MetafieldOwnerType
    /** Returns a reference object if the metafield definition's type is a resource reference. */
    reference?: Maybe<MetafieldReference>
    /** A list of reference objects if the metafield's type is a resource reference list. */
    references?: Maybe<MetafieldReferenceConnection>
    /**
     * The type of data that is stored in the metafield.
     * Refer to the list of [supported types](https://shopify.dev/apps/metafields/types).
     *
     */
    type: Scalars["String"]["output"]
    /** The date and time when the metafield was updated. */
    updatedAt: Scalars["DateTime"]["output"]
    /**
     * The data stored in the metafield. Always stored as a string, regardless of the metafield's type.
     *
     */
    value: Scalars["String"]["output"]
  }

/**
 * Metafields enable you to attach additional information to a Shopify resource, such as a [Product](https://shopify.dev/api/admin-graphql/latest/objects/product) or a [Collection](https://shopify.dev/api/admin-graphql/latest/objects/collection).
 * For more information about where you can attach metafields refer to [HasMetafields](https://shopify.dev/api/admin/graphql/reference/common-objects/HasMetafields).
 * Some examples of the data that metafields enable you to store are specifications, size charts, downloadable documents, release dates, images, or part numbers.
 * Metafields are identified by an owner resource, namespace, and key. and store a value along with type information for that value.
 *
 */
export type MetafieldReferencesArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
}

/** The access settings for this metafield definition. */
export type MetafieldAccess = {
  __typename?: "MetafieldAccess"
  /** The default admin access setting used for the metafields under this definition. */
  admin?: Maybe<MetafieldAdminAccess>
  /**
   * The explicit grants for this metafield definition, superseding the default admin access
   * for the specified grantees.
   *
   */
  grants: Array<MetafieldAccessGrant>
  /** The storefront access setting used for the metafields under this definition. */
  storefront?: Maybe<MetafieldStorefrontAccess>
}

/**
 * An explicit access grant for the metafields under this definition.
 *
 */
export type MetafieldAccessGrant = {
  __typename?: "MetafieldAccessGrant"
  /** The level of access the grantee has. */
  access: MetafieldGrantAccessLevel
  /** The grantee being granted access. */
  grantee: Scalars["String"]["output"]
}

/**
 * The input fields for an explicit access grant to be deleted for the metafields under this definition.
 *
 */
export type MetafieldAccessGrantDeleteInput = {
  /** The grantee whose grant should be deleted. */
  grantee: Scalars["String"]["input"]
}

/**
 * The input fields for an explicit access grant to be created or updated for the metafields under this definition.
 *
 */
export type MetafieldAccessGrantInput = {
  /** The level of access being granted. */
  access: MetafieldGrantAccessLevel
  /** The grantee being granted access. */
  grantee: Scalars["String"]["input"]
}

/**
 * The input fields for possible operations for modifying access grants. Exactly one option is required.
 *
 */
export type MetafieldAccessGrantOperationInput = {
  /**
   * The input fields for an explicit access grant to be created or updated for the metafields under this definition.
   *
   */
  create?: InputMaybe<MetafieldAccessGrantInput>
  /**
   * The input fields for an explicit access grant to be deleted for the metafields under this definition.
   *
   */
  delete?: InputMaybe<MetafieldAccessGrantDeleteInput>
  /**
   * The input fields for an explicit access grant to be created or updated for the metafields under this definition.
   *
   */
  update?: InputMaybe<MetafieldAccessGrantInput>
}

/**
 * The input fields for the access settings for the metafields under the definition.
 *
 */
export type MetafieldAccessInput = {
  /** The admin access setting to use for the metafields under this definition. */
  admin: MetafieldAdminAccess
  /**
   * The list of explicit grants to grant for the metafields under this definition.
   *
   */
  grants?: InputMaybe<Array<MetafieldAccessGrantInput>>
  /** The storefront access setting to use for the metafields under this definition. */
  storefront?: InputMaybe<MetafieldStorefrontAccess>
}

/**
 * The input fields for the access settings for the metafields under the definition.
 *
 */
export type MetafieldAccessUpdateInput = {
  /** The admin access setting to use for the metafields under this definition. */
  admin: MetafieldAdminAccess
  /** The set of grant operations to perform. */
  grants?: InputMaybe<Array<MetafieldAccessGrantOperationInput>>
  /** The storefront access setting to use for the metafields under this definition. */
  storefront?: InputMaybe<MetafieldStorefrontAccess>
}

/** Possible admin access settings for metafields. */
export enum MetafieldAdminAccess {
  /** Owner gets full access. The merchant has read-only access. No one else has access rights. */
  MerchantRead = "MERCHANT_READ",
  /** Owner gets full access. The merchant has read and write access. No one else has access rights. */
  MerchantReadWrite = "MERCHANT_READ_WRITE",
  /** Owner gets full access. No one else has access rights. */
  Private = "PRIVATE",
  /** Owner gets full access. All applications and the merchant have read-only access. */
  PublicRead = "PUBLIC_READ",
}

/**
 * An auto-generated type for paginating through multiple Metafields.
 *
 */
export type MetafieldConnection = {
  __typename?: "MetafieldConnection"
  /** A list of edges. */
  edges: Array<MetafieldEdge>
  /** A list of the nodes contained in MetafieldEdge. */
  nodes: Array<Metafield>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * Metafield definitions enable you to define additional validation constraints for metafields, and enable the
 * merchant to edit metafield values in context.
 *
 */
export type MetafieldDefinition = Node & {
  __typename?: "MetafieldDefinition"
  /** The access settings associated with the metafield definition. */
  access: MetafieldAccess
  /** The description of the metafield definition. */
  description?: Maybe<Scalars["String"]["output"]>
  /** A globally-unique ID. */
  id: Scalars["ID"]["output"]
  /** The unique identifier for the metafield definition within its namespace. */
  key: Scalars["String"]["output"]
  /** The metafields that belong to the metafield definition. */
  metafields: MetafieldConnection
  /** The count of the metafields that belong to the metafield definition. */
  metafieldsCount: Scalars["Int"]["output"]
  /** The human-readable name of the metafield definition. */
  name: Scalars["String"]["output"]
  /** The container for a group of metafields that the metafield definition is associated with. */
  namespace: Scalars["String"]["output"]
  /** The resource type that the metafield definition is attached to. */
  ownerType: MetafieldOwnerType
  /** The position of the metafield definition in the pinned list. */
  pinnedPosition?: Maybe<Scalars["Int"]["output"]>
  /** The standard metafield definition template associated with the metafield definition. */
  standardTemplate?: Maybe<StandardMetafieldDefinitionTemplate>
  /**
   * The type of data that each of the metafields that belong to the metafield definition will store.
   * Refer to the list of [supported types](https://shopify.dev/apps/metafields/types).
   *
   */
  type: MetafieldDefinitionType
  /** Whether the metafield definition can be used as a collection condition. */
  useAsCollectionCondition: Scalars["Boolean"]["output"]
  /** The validation status for the metafields that belong to the metafield definition. */
  validationStatus: MetafieldDefinitionValidationStatus
  /**
   * A list of [validation options](https://shopify.dev/apps/metafields/definitions/validation) for
   * the metafields that belong to the metafield definition. For example, for a metafield definition with the
   * type `date`, you can set a minimum date validation so that each of the metafields that belong to it can only
   * store dates after the specified minimum.
   *
   */
  validations: Array<MetafieldDefinitionValidation>
  /**
   * Whether each of the metafields that belong to the metafield definition are visible from the Storefront API.
   *
   * @deprecated Use `access.storefront` instead.
   */
  visibleToStorefrontApi: Scalars["Boolean"]["output"]
}

/**
 * Metafield definitions enable you to define additional validation constraints for metafields, and enable the
 * merchant to edit metafield values in context.
 *
 */
export type MetafieldDefinitionMetafieldsArgs = {
  after?: InputMaybe<Scalars["String"]["input"]>
  before?: InputMaybe<Scalars["String"]["input"]>
  first?: InputMaybe<Scalars["Int"]["input"]>
  last?: InputMaybe<Scalars["Int"]["input"]>
  reverse?: InputMaybe<Scalars["Boolean"]["input"]>
  validationStatus?: InputMaybe<MetafieldValidationStatus>
}

/**
 * Metafield definitions enable you to define additional validation constraints for metafields, and enable the
 * merchant to edit metafield values in context.
 *
 */
export type MetafieldDefinitionMetafieldsCountArgs = {
  validationStatus?: InputMaybe<MetafieldValidationStatus>
}

/**
 * An auto-generated type for paginating through multiple MetafieldDefinitions.
 *
 */
export type MetafieldDefinitionConnection = {
  __typename?: "MetafieldDefinitionConnection"
  /** A list of edges. */
  edges: Array<MetafieldDefinitionEdge>
  /** A list of the nodes contained in MetafieldDefinitionEdge. */
  nodes: Array<MetafieldDefinition>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `metafieldDefinitionCreate` mutation. */
export type MetafieldDefinitionCreatePayload = {
  __typename?: "MetafieldDefinitionCreatePayload"
  /** The metafield definition that was created. */
  createdDefinition?: Maybe<MetafieldDefinition>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MetafieldDefinitionCreateUserError>
}

/** An error that occurs during the execution of `MetafieldDefinitionCreate`. */
export type MetafieldDefinitionCreateUserError = DisplayableError & {
  __typename?: "MetafieldDefinitionCreateUserError"
  /** The error code. */
  code?: Maybe<MetafieldDefinitionCreateUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `MetafieldDefinitionCreateUserError`. */
export enum MetafieldDefinitionCreateUserErrorCode {
  /** A duplicate option. */
  DuplicateOption = "DUPLICATE_OPTION",
  /** The maximum limit of grants per definition type has been exceeded. */
  GrantLimitExceeded = "GRANT_LIMIT_EXCEEDED",
  /** The input value isn't included in the list. */
  Inclusion = "INCLUSION",
  /** The input value is invalid. */
  Invalid = "INVALID",
  /** A field contains an invalid character. */
  InvalidCharacter = "INVALID_CHARACTER",
  /** The input combination is invalid. */
  InvalidInputCombination = "INVALID_INPUT_COMBINATION",
  /** An invalid option. */
  InvalidOption = "INVALID_OPTION",
  /** The maximum limit of definitions per owner type has exceeded. */
  LimitExceeded = "LIMIT_EXCEEDED",
  /** You have reached the maximum allowed definitions for automated collections. */
  OwnerTypeLimitExceededForAutomatedCollections = "OWNER_TYPE_LIMIT_EXCEEDED_FOR_AUTOMATED_COLLECTIONS",
  /** The pinned limit has been reached for the owner type. */
  PinnedLimitReached = "PINNED_LIMIT_REACHED",
  /** The input value needs to be blank. */
  Present = "PRESENT",
  /** This namespace and key combination is reserved for standard definitions. */
  ReservedNamespaceKey = "RESERVED_NAMESPACE_KEY",
  /** The definition limit per owner type has exceeded. */
  ResourceTypeLimitExceeded = "RESOURCE_TYPE_LIMIT_EXCEEDED",
  /** The input value is already taken. */
  Taken = "TAKEN",
  /** The input value is too long. */
  TooLong = "TOO_LONG",
  /** The input value is too short. */
  TooShort = "TOO_SHORT",
  /** The definition type is not eligible to be used as collection condition. */
  TypeNotAllowedForConditions = "TYPE_NOT_ALLOWED_FOR_CONDITIONS",
  /** This namespace and key combination is already in use for a set of your metafields. */
  UnstructuredAlreadyExists = "UNSTRUCTURED_ALREADY_EXISTS",
}

/** Return type for `metafieldDefinitionDelete` mutation. */
export type MetafieldDefinitionDeletePayload = {
  __typename?: "MetafieldDefinitionDeletePayload"
  /** The ID of the deleted metafield definition. */
  deletedDefinitionId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MetafieldDefinitionDeleteUserError>
}

/** An error that occurs during the execution of `MetafieldDefinitionDelete`. */
export type MetafieldDefinitionDeleteUserError = DisplayableError & {
  __typename?: "MetafieldDefinitionDeleteUserError"
  /** The error code. */
  code?: Maybe<MetafieldDefinitionDeleteUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `MetafieldDefinitionDeleteUserError`. */
export enum MetafieldDefinitionDeleteUserErrorCode {
  /** Owner type can't be used in this mutation. */
  DisallowedOwnerType = "DISALLOWED_OWNER_TYPE",
  /** An internal error occurred. */
  InternalError = "INTERNAL_ERROR",
  /** Action cannot proceed. Definition is currently in use. */
  MetafieldDefinitionInUse = "METAFIELD_DEFINITION_IN_USE",
  /** Definition not found. */
  NotFound = "NOT_FOUND",
  /** The input value needs to be blank. */
  Present = "PRESENT",
  /** Deleting a reference type metafield definition requires deletion of its associated metafields. */
  ReferenceTypeDeletionError = "REFERENCE_TYPE_DELETION_ERROR",
}

/**
 * An auto-generated type which holds one MetafieldDefinition and a cursor during pagination.
 *
 */
export type MetafieldDefinitionEdge = {
  __typename?: "MetafieldDefinitionEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of MetafieldDefinitionEdge. */
  node: MetafieldDefinition
}

/**
 * The input fields required to create a metafield definition.
 *
 */
export type MetafieldDefinitionInput = {
  /** The access settings that apply to each of the metafields that belong to the metafield definition. */
  access?: InputMaybe<MetafieldAccessInput>
  /** The description for the metafield definition. */
  description?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The unique identifier for the metafield definition within its namespace.
   *
   * Must be 3-64 characters long and only contain alphanumeric, hyphen, and underscore characters.
   *
   */
  key: Scalars["String"]["input"]
  /** The human-readable name for the metafield definition. */
  name: Scalars["String"]["input"]
  /**
   * The container for a group of metafields that the metafield definition will be associated with. If omitted, the
   * app-reserved namespace will be used.
   *
   * Must be 3-255 characters long and only contain alphanumeric, hyphen, and underscore characters.
   *
   */
  namespace?: InputMaybe<Scalars["String"]["input"]>
  /** The resource type that the metafield definition is attached to. */
  ownerType: MetafieldOwnerType
  /**
   * Whether to [pin](https://help.shopify.com/manual/custom-data/metafields/pinning-metafield-definitions)
   * the metafield definition.
   *
   */
  pin?: InputMaybe<Scalars["Boolean"]["input"]>
  /**
   * The type of data that each of the metafields that belong to the metafield definition will store.
   * Refer to the list of [supported types](https://shopify.dev/apps/metafields/types).
   *
   */
  type: Scalars["String"]["input"]
  /** Whether the metafield definition can be used as a collection condition. */
  useAsCollectionCondition?: InputMaybe<Scalars["Boolean"]["input"]>
  /**
   * A list of [validation options](https://shopify.dev/apps/metafields/definitions/validation) for
   * the metafields that belong to the metafield definition. For example, for a metafield definition with the
   * type `date`, you can set a minimum date validation so that each of the metafields that belong to it can only
   * store dates after the specified minimum.
   *
   */
  validations?: InputMaybe<Array<MetafieldDefinitionValidationInput>>
}

/** Return type for `metafieldDefinitionPin` mutation. */
export type MetafieldDefinitionPinPayload = {
  __typename?: "MetafieldDefinitionPinPayload"
  /** The metafield definition that was pinned. */
  pinnedDefinition?: Maybe<MetafieldDefinition>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MetafieldDefinitionPinUserError>
}

/** An error that occurs during the execution of `MetafieldDefinitionPin`. */
export type MetafieldDefinitionPinUserError = DisplayableError & {
  __typename?: "MetafieldDefinitionPinUserError"
  /** The error code. */
  code?: Maybe<MetafieldDefinitionPinUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `MetafieldDefinitionPinUserError`. */
export enum MetafieldDefinitionPinUserErrorCode {
  /** The metafield definition is already pinned. */
  AlreadyPinned = "ALREADY_PINNED",
  /** Owner type can't be used in this mutation. */
  DisallowedOwnerType = "DISALLOWED_OWNER_TYPE",
  /** An internal error occurred. */
  InternalError = "INTERNAL_ERROR",
  /** The metafield definition was not found. */
  NotFound = "NOT_FOUND",
  /** The pinned limit has been reached for owner type. */
  PinnedLimitReached = "PINNED_LIMIT_REACHED",
}

/** Possible metafield definition pinned statuses. */
export enum MetafieldDefinitionPinnedStatus {
  /** All metafield definitions. */
  Any = "ANY",
  /** Only metafield definitions that are pinned. */
  Pinned = "PINNED",
  /** Only metafield definitions that are not pinned. */
  Unpinned = "UNPINNED",
}

/** The set of valid sort keys for the MetafieldDefinition query. */
export enum MetafieldDefinitionSortKeys {
  /** Sort by the `id` value. */
  Id = "ID",
  /** Sort by the `name` value. */
  Name = "NAME",
  /** Sort by the `pinned_position` value. */
  PinnedPosition = "PINNED_POSITION",
  /**
   * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
   * Don't use this sort key when no search query is specified.
   *
   */
  Relevance = "RELEVANCE",
}

/**
 * The type and name for the optional validation configuration of a metafield.
 *
 * For example, a supported validation might consist of a `max` name and a `number_integer` type.
 * This validation can then be used to enforce a maximum character length for a `single_line_text_field` metafield.
 *
 */
export type MetafieldDefinitionSupportedValidation = {
  __typename?: "MetafieldDefinitionSupportedValidation"
  /** The name of the metafield definition validation. */
  name: Scalars["String"]["output"]
  /** The type of input for the validation. */
  type: Scalars["String"]["output"]
}

/**
 * A metafield definition type provides basic foundation and validation for a metafield.
 *
 */
export type MetafieldDefinitionType = {
  __typename?: "MetafieldDefinitionType"
  /** The category associated with the metafield definition type. */
  category: Scalars["String"]["output"]
  /**
   * The name of the type for the metafield definition.
   * See the list of [supported types](https://shopify.dev/apps/metafields/types).
   *
   */
  name: Scalars["String"]["output"]
  /** The supported validations for a metafield definition type. */
  supportedValidations: Array<MetafieldDefinitionSupportedValidation>
  /** Whether metafields without a definition can be migrated to a definition of this type. */
  supportsDefinitionMigrations: Scalars["Boolean"]["output"]
  /**
   * The value type for a metafield created with this definition type.
   * @deprecated `valueType` is deprecated and `name` should be used for type information.
   */
  valueType: MetafieldValueType
}

/** Return type for `metafieldDefinitionUnpin` mutation. */
export type MetafieldDefinitionUnpinPayload = {
  __typename?: "MetafieldDefinitionUnpinPayload"
  /** The metafield definition that was unpinned. */
  unpinnedDefinition?: Maybe<MetafieldDefinition>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MetafieldDefinitionUnpinUserError>
}

/** An error that occurs during the execution of `MetafieldDefinitionUnpin`. */
export type MetafieldDefinitionUnpinUserError = DisplayableError & {
  __typename?: "MetafieldDefinitionUnpinUserError"
  /** The error code. */
  code?: Maybe<MetafieldDefinitionUnpinUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `MetafieldDefinitionUnpinUserError`. */
export enum MetafieldDefinitionUnpinUserErrorCode {
  /** Owner type can't be used in this mutation. */
  DisallowedOwnerType = "DISALLOWED_OWNER_TYPE",
  /** An internal error occurred. */
  InternalError = "INTERNAL_ERROR",
  /** The metafield definition was not found. */
  NotFound = "NOT_FOUND",
  /** The metafield definition isn't pinned. */
  NotPinned = "NOT_PINNED",
}

/**
 * The input fields required to update a metafield definition.
 *
 */
export type MetafieldDefinitionUpdateInput = {
  /** The access settings that apply to each of the metafields that belong to the metafield definition. */
  access?: InputMaybe<MetafieldAccessUpdateInput>
  /** The description for the metafield definition. */
  description?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The unique identifier for the metafield definition within its namespace. Used to help identify the metafield
   * definition, but can't be updated itself.
   *
   */
  key: Scalars["String"]["input"]
  /** The human-readable name for the metafield definition. */
  name?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The container for a group of metafields that the metafield definition is associated with. Used to help identify
   * the metafield definition, but cannot be updated itself. If omitted, the app-reserved namespace will be used.
   *
   */
  namespace?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The resource type that the metafield definition is attached to. Used to help identify the metafield definition,
   * but can't be updated itself.
   *
   */
  ownerType: MetafieldOwnerType
  /** Whether to pin the metafield definition. */
  pin?: InputMaybe<Scalars["Boolean"]["input"]>
  /** Whether the metafield definition can be used as a collection condition. */
  useAsCollectionCondition?: InputMaybe<Scalars["Boolean"]["input"]>
  /**
   * A list of [validation options](https://shopify.dev/apps/metafields/definitions/validation) for
   * the metafields that belong to the metafield definition. For example, for a metafield definition with the
   * type `date`, you can set a minimum date validation so that each of the metafields that belong to it can only
   * store dates after the specified minimum.
   *
   */
  validations?: InputMaybe<Array<MetafieldDefinitionValidationInput>>
}

/** Return type for `metafieldDefinitionUpdate` mutation. */
export type MetafieldDefinitionUpdatePayload = {
  __typename?: "MetafieldDefinitionUpdatePayload"
  /** The metafield definition that was updated. */
  updatedDefinition?: Maybe<MetafieldDefinition>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MetafieldDefinitionUpdateUserError>
  /** The asynchronous job updating the metafield definition's validation_status. */
  validationJob?: Maybe<Job>
}

/** An error that occurs during the execution of `MetafieldDefinitionUpdate`. */
export type MetafieldDefinitionUpdateUserError = DisplayableError & {
  __typename?: "MetafieldDefinitionUpdateUserError"
  /** The error code. */
  code?: Maybe<MetafieldDefinitionUpdateUserErrorCode>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `MetafieldDefinitionUpdateUserError`. */
export enum MetafieldDefinitionUpdateUserErrorCode {
  /** The maximum limit of grants per definition type has been exceeded. */
  GrantLimitExceeded = "GRANT_LIMIT_EXCEEDED",
  /** An internal error occurred. */
  InternalError = "INTERNAL_ERROR",
  /** An invalid input. */
  InvalidInput = "INVALID_INPUT",
  /** The input combination is invalid. */
  InvalidInputCombination = "INVALID_INPUT_COMBINATION",
  /** Action cannot proceed. Definition is currently in use. */
  MetafieldDefinitionInUse = "METAFIELD_DEFINITION_IN_USE",
  /** You cannot change the metaobject definition pointed to by a metaobject reference metafield definition. */
  MetaobjectDefinitionChanged = "METAOBJECT_DEFINITION_CHANGED",
  /** The metafield definition wasn't found. */
  NotFound = "NOT_FOUND",
  /** You have reached the maximum allowed definitions for automated collections. */
  OwnerTypeLimitExceededForAutomatedCollections = "OWNER_TYPE_LIMIT_EXCEEDED_FOR_AUTOMATED_COLLECTIONS",
  /** The pinned limit has been reached for the owner type. */
  PinnedLimitReached = "PINNED_LIMIT_REACHED",
  /** The input value needs to be blank. */
  Present = "PRESENT",
  /** The input value is too long. */
  TooLong = "TOO_LONG",
  /** The definition type is not eligible to be used as collection condition. */
  TypeNotAllowedForConditions = "TYPE_NOT_ALLOWED_FOR_CONDITIONS",
}

/**
 * A configured metafield definition validation.
 *
 * For example, for a metafield definition of `number_integer` type, you can set a validation with the name `max`
 * and a value of `15`. This validation will ensure that the value of the metafield is a number less than or equal to 15.
 *
 * Refer to the [list of supported validations](https://shopify.dev/api/admin/graphql/reference/common-objects/metafieldDefinitionTypes#examples-Fetch_all_metafield_definition_types).
 *
 */
export type MetafieldDefinitionValidation = {
  __typename?: "MetafieldDefinitionValidation"
  /** The validation name. */
  name: Scalars["String"]["output"]
  /** The name for the metafield type of this validation. */
  type: Scalars["String"]["output"]
  /** The validation value. */
  value?: Maybe<Scalars["String"]["output"]>
}

/**
 * The name and value for a metafield definition validation.
 *
 * For example, for a metafield definition of `single_line_text_field` type, you can set a validation with the name `min` and a value of `10`.
 * This validation will ensure that the value of the metafield is at least 10 characters.
 *
 * Refer to the [list of supported validations](https://shopify.dev/api/admin/graphql/reference/common-objects/metafieldDefinitionTypes#examples-Fetch_all_metafield_definition_types).
 *
 */
export type MetafieldDefinitionValidationInput = {
  /** The name for the metafield definition validation. */
  name: Scalars["String"]["input"]
  /** The value for the metafield definition validation. */
  value: Scalars["String"]["input"]
}

/** Possible metafield definition validation statuses. */
export enum MetafieldDefinitionValidationStatus {
  /** All of this definition's metafields are valid. */
  AllValid = "ALL_VALID",
  /** Asynchronous validation of this definition's metafields is in progress. */
  InProgress = "IN_PROGRESS",
  /** Some of this definition's metafields are invalid. */
  SomeInvalid = "SOME_INVALID",
}

/** The input fields to delete a metafield. */
export type MetafieldDeleteInput = {
  /** The ID of the metafield to delete. */
  id: Scalars["ID"]["input"]
}

/** Return type for `metafieldDelete` mutation. */
export type MetafieldDeletePayload = {
  __typename?: "MetafieldDeletePayload"
  /** The ID of the deleted metafield. */
  deletedId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * An auto-generated type which holds one Metafield and a cursor during pagination.
 *
 */
export type MetafieldEdge = {
  __typename?: "MetafieldEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of MetafieldEdge. */
  node: Metafield
}

/** Possible access levels for explicit metafield access grants. */
export enum MetafieldGrantAccessLevel {
  /** Read metafield access. */
  Read = "READ",
  /** Read and write metafield access. */
  ReadWrite = "READ_WRITE",
}

/**
 * The input fields to use to create or update a metafield through a mutation on the owning resource.
 * An alternative way to create or update a metafield is by using the
 * [metafieldsSet](https://shopify.dev/api/admin-graphql/latest/mutations/metafieldsSet) mutation.
 *
 */
export type MetafieldInput = {
  /**
   * The unique ID of the metafield.
   *
   * Required when updating a metafield, but shouldn't be included when creating as it's created automatically.
   *
   */
  id?: InputMaybe<Scalars["ID"]["input"]>
  /**
   * The unique identifier for a metafield within its namespace.
   *
   * Required when creating a metafield, but optional when updating. Used to help identify the metafield when
   * updating, but can't be updated itself.
   *
   * Must be 3-64 characters long and can contain alphanumeric, hyphen, and underscore characters.
   *
   */
  key?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The container for a group of metafields that the metafield is or will be associated with. Used in tandem with
   * `key` to lookup a metafield on a resource, preventing conflicts with other metafields with the same `key`.
   *
   * Required when creating a metafield, but optional when updating. Used to help identify the metafield when
   * updating, but can't be updated itself.
   *
   * Must be 3-255 characters long and can contain alphanumeric, hyphen, and underscore characters.
   *
   */
  namespace?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The type of data that is stored in the metafield.
   * Refer to the list of [supported types](https://shopify.dev/apps/metafields/types).
   *
   * Required when creating a metafield, but optional when updating.
   *
   */
  type?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The data stored in the metafield. Always stored as a string, regardless of the metafield's type.
   *
   */
  value?: InputMaybe<Scalars["String"]["input"]>
}

/** Possible types of a metafield's owner resource. */
export enum MetafieldOwnerType {
  /** The Api Permission metafield owner type. */
  ApiPermission = "API_PERMISSION",
  /** The Article metafield owner type. */
  Article = "ARTICLE",
  /** The Blog metafield owner type. */
  Blog = "BLOG",
  /** The Cart Transform metafield owner type. */
  Carttransform = "CARTTRANSFORM",
  /** The Collection metafield owner type. */
  Collection = "COLLECTION",
  /** The Company metafield owner type. */
  Company = "COMPANY",
  /** The Company Location metafield owner type. */
  CompanyLocation = "COMPANY_LOCATION",
  /** The Customer metafield owner type. */
  Customer = "CUSTOMER",
  /** The Delivery Customization metafield owner type. */
  DeliveryCustomization = "DELIVERY_CUSTOMIZATION",
  /** The Discount metafield owner type. */
  Discount = "DISCOUNT",
  /** The Draft Order metafield owner type. */
  Draftorder = "DRAFTORDER",
  /** The Fulfillment Constraint Rule metafield owner type. */
  FulfillmentConstraintRule = "FULFILLMENT_CONSTRAINT_RULE",
  /** The Location metafield owner type. */
  Location = "LOCATION",
  /** The Market metafield owner type. */
  Market = "MARKET",
  /** The Media Image metafield owner type. */
  MediaImage = "MEDIA_IMAGE",
  /** The Order metafield owner type. */
  Order = "ORDER",
  /** The Order Routing Location Rule metafield owner type. */
  OrderRoutingLocationRule = "ORDER_ROUTING_LOCATION_RULE",
  /** The Page metafield owner type. */
  Page = "PAGE",
  /** The Payment Customization metafield owner type. */
  PaymentCustomization = "PAYMENT_CUSTOMIZATION",
  /** The Product metafield owner type. */
  Product = "PRODUCT",
  /**
   * The Product Image metafield owner type.
   * @deprecated `PRODUCTIMAGE` is deprecated. Use `MEDIA_IMAGE` instead.
   */
  Productimage = "PRODUCTIMAGE",
  /** The Product Variant metafield owner type. */
  Productvariant = "PRODUCTVARIANT",
  /** The Shop metafield owner type. */
  Shop = "SHOP",
  /** The Validation metafield owner type. */
  Validation = "VALIDATION",
}

/**
 * The resource referenced by the metafield value.
 *
 */
export type MetafieldReference = Collection | GenericFile | MediaImage | Metaobject | OnlineStorePage | Product | ProductVariant | Video

/**
 * An auto-generated type for paginating through multiple MetafieldReferences.
 *
 */
export type MetafieldReferenceConnection = {
  __typename?: "MetafieldReferenceConnection"
  /** A list of edges. */
  edges: Array<MetafieldReferenceEdge>
  /** A list of the nodes contained in MetafieldReferenceEdge. */
  nodes: Array<Maybe<MetafieldReference>>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one MetafieldReference and a cursor during pagination.
 *
 */
export type MetafieldReferenceEdge = {
  __typename?: "MetafieldReferenceEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of MetafieldReferenceEdge. */
  node?: Maybe<MetafieldReference>
}

/**
 * Types of resources that may use metafields to reference other resources.
 *
 */
export type MetafieldReferencer =
  | AppInstallation
  | Collection
  | Customer
  | DeliveryCustomization
  | DiscountAutomaticNode
  | DiscountCodeNode
  | DiscountNode
  | DraftOrder
  | FulfillmentOrder
  | Location
  | Market
  | Metaobject
  | OnlineStoreArticle
  | OnlineStoreBlog
  | OnlineStorePage
  | Order
  | PaymentCustomization
  | Product
  | ProductVariant
  | Shop

/**
 * Defines a relation between two resources via a reference metafield.
 * The referencer owns the joining field with a given namespace and key,
 * while the target is referenced by the field.
 *
 */
export type MetafieldRelation = {
  __typename?: "MetafieldRelation"
  /** The key of the field making the reference. */
  key: Scalars["String"]["output"]
  /** The name of the field making the reference. */
  name: Scalars["String"]["output"]
  /** The namespace of the metafield making the reference, or type of the metaobject. */
  namespace: Scalars["String"]["output"]
  /** The resource making the reference. */
  referencer: MetafieldReferencer
  /** The referenced resource. */
  target: MetafieldReference
}

/**
 * An auto-generated type for paginating through multiple MetafieldRelations.
 *
 */
export type MetafieldRelationConnection = {
  __typename?: "MetafieldRelationConnection"
  /** A list of edges. */
  edges: Array<MetafieldRelationEdge>
  /** A list of the nodes contained in MetafieldRelationEdge. */
  nodes: Array<MetafieldRelation>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/**
 * An auto-generated type which holds one MetafieldRelation and a cursor during pagination.
 *
 */
export type MetafieldRelationEdge = {
  __typename?: "MetafieldRelationEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of MetafieldRelationEdge. */
  node: MetafieldRelation
}

/**
 * Defines how the metafields of a definition can be accessed in Storefront API surface areas, including Liquid and the GraphQL Storefront API.
 *
 */
export enum MetafieldStorefrontAccess {
  /** Metafields are not accessible in any Storefront API surface area. */
  None = "NONE",
  /** Metafields are accessible in the GraphQL Storefront API and online store Liquid templates. */
  PublicRead = "PUBLIC_READ",
}

/**
 * By default, the Storefront API can't read metafields. To make specific metafields visible in the Storefront API,
 * you need to create a `MetafieldStorefrontVisibility` record. A `MetafieldStorefrontVisibility` record is a list
 * of the metafields, defined by the `owner_type`, `namespace`, and `key`, to make visible in the Storefront API.
 *
 * Learn about [exposing metafields in the Storefront API]
 * (https://shopify.dev/custom-storefronts/products-collections/metafields)
 * for more details.
 *
 */
export type MetafieldStorefrontVisibility = LegacyInteroperability &
  Node & {
    __typename?: "MetafieldStorefrontVisibility"
    /** The date and time when the metafield was set to visible in the Storefront API. */
    createdAt: Scalars["DateTime"]["output"]
    /** A globally-unique ID. */
    id: Scalars["ID"]["output"]
    /** The key of a metafield to make visible in the Storefront API. */
    key: Scalars["String"]["output"]
    /** The ID of the corresponding resource in the REST Admin API. */
    legacyResourceId: Scalars["UnsignedInt64"]["output"]
    /** The namespace of a metafield to make visible in the Storefront API. */
    namespace: Scalars["String"]["output"]
    /** The owner type of a metafield to make visible in the Storefront API. */
    ownerType: MetafieldOwnerType
    /**
     * The date and time when the `MetafieldStorefrontVisilibty` record was updated.
     *
     */
    updatedAt: Scalars["DateTime"]["output"]
  }

/**
 * An auto-generated type for paginating through multiple MetafieldStorefrontVisibilities.
 *
 */
export type MetafieldStorefrontVisibilityConnection = {
  __typename?: "MetafieldStorefrontVisibilityConnection"
  /** A list of edges. */
  edges: Array<MetafieldStorefrontVisibilityEdge>
  /** A list of the nodes contained in MetafieldStorefrontVisibilityEdge. */
  nodes: Array<MetafieldStorefrontVisibility>
  /** Information to aid in pagination. */
  pageInfo: PageInfo
}

/** Return type for `metafieldStorefrontVisibilityCreate` mutation. */
export type MetafieldStorefrontVisibilityCreatePayload = {
  __typename?: "MetafieldStorefrontVisibilityCreatePayload"
  /** The `MetafieldStorefrontVisibility` that was created. */
  metafieldStorefrontVisibility?: Maybe<MetafieldStorefrontVisibility>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/** Return type for `metafieldStorefrontVisibilityDelete` mutation. */
export type MetafieldStorefrontVisibilityDeletePayload = {
  __typename?: "MetafieldStorefrontVisibilityDeletePayload"
  /** The ID of the deleted `MetafieldStorefrontVisibility` record. */
  deletedMetafieldStorefrontVisibilityId?: Maybe<Scalars["ID"]["output"]>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<UserError>
}

/**
 * An auto-generated type which holds one MetafieldStorefrontVisibility and a cursor during pagination.
 *
 */
export type MetafieldStorefrontVisibilityEdge = {
  __typename?: "MetafieldStorefrontVisibilityEdge"
  /** A cursor for use in pagination. */
  cursor: Scalars["String"]["output"]
  /** The item at the end of MetafieldStorefrontVisibilityEdge. */
  node: MetafieldStorefrontVisibility
}

/**
 * The input fields to create a MetafieldStorefrontVisibility record.
 *
 */
export type MetafieldStorefrontVisibilityInput = {
  /** The key of a metafield to make visible in the Storefront API. */
  key: Scalars["String"]["input"]
  /** The namespace of a metafield to make visible in the Storefront API. If omitted the app reserved namespace will be used. */
  namespace?: InputMaybe<Scalars["String"]["input"]>
  /** The owner type of a metafield to make visible in the Storefront API. */
  ownerType: MetafieldOwnerType
}

/** Possible metafield validation statuses. */
export enum MetafieldValidationStatus {
  /** Any validation status (valid or invalid). */
  Any = "ANY",
  /** Invalid (according to definition). */
  Invalid = "INVALID",
  /** Valid (according to definition). */
  Valid = "VALID",
}

/**
 * Legacy type information for the stored value.
 * Replaced by `type`.
 *
 */
export enum MetafieldValueType {
  /** A `true` or `false` value. */
  Boolean = "BOOLEAN",
  /** A whole number. */
  Integer = "INTEGER",
  /** A JSON string. */
  JsonString = "JSON_STRING",
  /** A text field. */
  String = "STRING",
}

/** The input fields for a metafield value to set. */
export type MetafieldsSetInput = {
  /**
   * The unique identifier for a metafield within its namespace.
   *
   * Must be 3-64 characters long and can contain alphanumeric, hyphen, and underscore characters.
   *
   */
  key: Scalars["String"]["input"]
  /**
   * The container for a group of metafields that the metafield is or will be associated with. Used in tandem
   * with `key` to lookup a metafield on a resource, preventing conflicts with other metafields with the
   * same `key`. If omitted the app-reserved namespace will be used.
   *
   * Must be 3-255 characters long and can contain alphanumeric, hyphen, and underscore characters.
   *
   */
  namespace?: InputMaybe<Scalars["String"]["input"]>
  /** The unique ID of the resource that the metafield is attached to. */
  ownerId: Scalars["ID"]["input"]
  /**
   * The type of data that is stored in the metafield.
   * The type must be one of the [supported types](https://shopify.dev/apps/metafields/types).
   *
   * Required when there is no corresponding definition for the given `namespace`, `key`, and
   * owner resource type (derived from `ownerId`).
   *
   */
  type?: InputMaybe<Scalars["String"]["input"]>
  /**
   * The data stored in the metafield. Always stored as a string, regardless of the metafield's type.
   *
   */
  value: Scalars["String"]["input"]
}

/** Return type for `metafieldsSet` mutation. */
export type MetafieldsSetPayload = {
  __typename?: "MetafieldsSetPayload"
  /** The list of metafields that were set. */
  metafields?: Maybe<Array<Metafield>>
  /** The list of errors that occurred from executing the mutation. */
  userErrors: Array<MetafieldsSetUserError>
}

/** An error that occurs during the execution of `MetafieldsSet`. */
export type MetafieldsSetUserError = DisplayableError & {
  __typename?: "MetafieldsSetUserError"
  /** The error code. */
  code?: Maybe<MetafieldsSetUserErrorCode>
  /** The index of the array element that's causing the error. */
  elementIndex?: Maybe<Scalars["Int"]["output"]>
  /** The path to the input field that caused the error. */
  field?: Maybe<Array<Scalars["String"]["output"]>>
  /** The error message. */
  message: Scalars["String"]["output"]
}

/** Possible error codes that can be returned by `MetafieldsSetUserError`. */
export enum MetafieldsSetUserErrorCode {
  /** ApiPermission metafields can only be created or updated by the app owner. */
  AppNotAuthorized = "APP_NOT_AUTHORIZED",
  /** The input value is blank. */
  Blank = "BLANK",
  /** The metafield violates a capability restriction. */
  CapabilityViolation = "CAPABILITY_VIOLATION",
  /** The input value isn't included in the list. */
  Inclusion = "INCLUSION",
  /** The type is invalid. */
  InvalidType = "INVALID_TYPE",
  /** The value is invalid for metafield type or for definition options. */
  InvalidValue = "INVALID_VALUE",
  /** The input value should be less than or equal to the maximum value allowed. */
  LessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO",
  /** The input value needs to be blank. */
  Present = "PRESENT",
  /** The input value is too long. */
  TooLong = "TOO_LONG",
  /** The input value is too short. */
  TooShort = "TOO_SHORT",
}

/** Provides an object instance represented by a MetaobjectDefinition. */
export type Metaobject = Node & {
  __typename?: "Metaobject"
  /** Metaobject capabilities f